@(SNIPPET(
    'publisher_groovy-postbuild',
    script='\n'.join([
        '// FIND UPDATED PACKAGES AND TRIGGER RECONFIGURE',
        'import hudson.model.Cause.UserIdCause',
        'import hudson.model.ParametersAction',
        'import hudson.model.StringParameterValue',
        'import java.io.BufferedReader',
        'import java.util.regex.Matcher',
        'import java.util.regex.Pattern',
        'import jenkins.model.Jenkins',
        '',
        'reconfigure_job_names = []',
    ] +
    ['reconfigure_job_names << "%s"' % name for name in reconfigure_job_names] +
    [
        '',
        'pattern = Pattern.compile(".*- updated manifest of package \'(.+)\' to version \'(.+)\'")',
        '',
        'packages = []',
        'r = manager.build.getLogReader()',
        'br = new BufferedReader(r)',
        'def line',
        'while ((line = br.readLine()) != null) {',
        '    matcher = pattern.matcher(line)',
        '    if (matcher.matches()) {',
        '        packages << [',
        '          "name": matcher.group(1),',
        '          "version": matcher.group(2),',
        '        ]',
        '    }',
        '}',
        '',
        'if (packages) {',
        '    description = "Updated packages:"',
        '    package_names = ""',
        '    for (pkg in packages) {',
        '        description += " " + pkg["name"] + " " + pkg["version"]',
        '        if (package_names != "") package_names += " "',
        '        package_names += pkg["name"]',
        '    }',
        '    manager.build.setDescription(description)',
        '',
        '    for (job_name in reconfigure_job_names) {',
        '        p = Jenkins.instance.getItemByFullName(job_name)',
        '        if (p) {',
        '            p.scheduleBuild(1, new UserIdCause(), new ParametersAction(new StringParameterValue("package_names", package_names)))',
        '        }',
        '    }',
        '}',
    ]),
))@
