/*
 *    This file is part of ACADO Toolkit.
 *
 *    ACADO Toolkit -- A Toolkit for Automatic Control and Dynamic Optimization.
 *    Copyright (C) 2008-2014 by Boris Houska, Hans Joachim Ferreau,
 *    Milan Vukov, Rien Quirynen, KU Leuven.
 *    Developed within the Optimization in Engineering Center (OPTEC)
 *    under supervision of Moritz Diehl. All rights reserved.
 *
 *    ACADO Toolkit is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    ACADO Toolkit is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with ACADO Toolkit; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */



/**
 *    \file include/acado/symbolic_expression/symbolic_expression.hpp
 *    \author Boris Houska, Hans Joachim Ferreau, Milan Vukov
 *    \date 2008 - 2013
 */


#ifndef ACADO_TOOLKIT_SYMBOLIC_EXPRESSION_HPP
#define ACADO_TOOLKIT_SYMBOLIC_EXPRESSION_HPP


// COLLECTION OF ALL EXPRESSION-HEADER FILES:
// -------------------------------------------------------

#include <acado/symbolic_expression/expression.hpp>
#include <acado/symbolic_expression/variable_types.hpp>
#include <acado/symbolic_expression/lyapunov.hpp>

#include <acado/symbolic_expression/acado_syntax.hpp>

#include <acado/symbolic_expression/constraint_component.hpp>

#include <acado/symbolic_operator/symbolic_operator.hpp>

#endif // ACADO_TOOLKIT_SYMBOLIC_EXPRESSION_HPP
