/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="position")
public class YtPosition
extends AbstractExtension {
    private int position;

    public YtPosition() {
    }

    public YtPosition(int position) {
        this.position = position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        generator.setContent(Integer.toString(this.position + 1));
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        int value;
        super.consumeAttributes(helper);
        try {
            value = Integer.parseInt(helper.consumeContent(true));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Position should be an integer");
        }
        if (value <= 0) {
            throw new ParseException("Position should be >= 1");
        }
        this.position = value - 1;
    }
}

