/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2013-10-08 17:02:52.109034
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "baxter_ikfast_left_arm_plugin/ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x53,x54,x55,x56,x57,x58,x59,x60,x61,x62,x63,x64,x65,x66,x67,x68,x69,x70,x71,x72,x73;
x0=IKcos(j[0]);
x1=IKcos(j[2]);
x2=IKsin(j[1]);
x3=IKsin(j[0]);
x4=IKsin(j[2]);
x5=IKsin(j[3]);
x6=IKcos(j[1]);
x7=IKcos(j[3]);
x8=IKsin(j[4]);
x9=IKcos(j[4]);
x10=IKcos(j[6]);
x11=IKsin(j[6]);
x12=IKsin(j[5]);
x13=IKcos(j[5]);
x14=((IkReal(0.0690000000000000))*(x0));
x15=((IkReal(0.0100000000000000))*(x7));
x16=((IkReal(1.00000000000000))*(x3));
x17=((IkReal(0.279525000000000))*(x5));
x18=((IkReal(1.00000000000000))*(x9));
x19=((IkReal(0.279525000000000))*(x9));
x20=((IkReal(1.00000000000000))*(x5));
x21=((IkReal(0.374290000000000))*(x3));
x22=((IkReal(0.374290000000000))*(x0));
x23=((IkReal(1.00000000000000))*(x0));
x24=((IkReal(0.0100000000000000))*(x2));
x25=((IkReal(1.00000000000000))*(x8));
x26=((IkReal(0.279525000000000))*(x8));
x27=((IkReal(0.0690000000000000))*(x3));
x28=((IkReal(0.0100000000000000))*(x0));
x29=((IkReal(-1.00000000000000))*(x9));
x30=((x2)*(x7));
x31=((x1)*(x6));
x32=((IkReal(-1.00000000000000))*(x12));
x33=((x1)*(x2));
x34=((x0)*(x4));
x35=((x5)*(x6));
x36=((x3)*(x6));
x37=((x6)*(x7));
x38=((IkReal(-1.00000000000000))*(x8));
x39=((x1)*(x3));
x40=((x4)*(x6));
x41=((IkReal(-1.00000000000000))*(x13));
x42=((x2)*(x23)*(x4));
x43=((x23)*(x37));
x44=((x16)*(x33));
x45=((x16)*(x37));
x46=((x18)*(x40));
x47=((x39)+(((IkReal(-1.00000000000000))*(x42))));
x48=((((IkReal(-1.00000000000000))*(x44)))+(x34));
x49=((((IkReal(-1.00000000000000))*(x31)*(x7)))+(((x2)*(x5))));
x50=((((x31)*(x5)))+(x30));
x51=((x42)+(((IkReal(-1.00000000000000))*(x1)*(x16))));
x52=((x44)+(((IkReal(-1.00000000000000))*(x23)*(x4))));
x53=((((x23)*(x33)))+(((x16)*(x4))));
x54=((IkReal(-1.00000000000000))*(x53));
x55=((((x1)*(x23)))+(((x16)*(x2)*(x4))));
x56=((x48)*(x7));
x57=((x5)*(x52));
x58=((x51)*(x8));
x59=((x54)*(x7));
x60=((x55)*(x8));
x61=((x5)*(x53));
x62=((x56)+(((IkReal(-1.00000000000000))*(x16)*(x35))));
x63=((((x40)*(x8)))+(((x49)*(x9))));
x64=((x57)+(((IkReal(-1.00000000000000))*(x45))));
x65=((x59)+(((IkReal(-1.00000000000000))*(x0)*(x20)*(x6))));
x66=((x61)+(((IkReal(-1.00000000000000))*(x43))));
x67=((x13)*(x63));
x68=((x12)*(x64));
x69=((x60)+(((x62)*(x9))));
x70=((x58)+(((x65)*(x9))));
x71=((x13)*(x69));
x72=((((IkReal(-1.00000000000000))*(x29)*(x55)))+(((x38)*(x62))));
x73=((x13)*(x70));
eerot[0]=((((x10)*(((((x12)*(x66)))+(x73)))))+(((x11)*(((((x38)*(x65)))+(((x29)*(x47))))))));
eerot[1]=((((x10)*(((((IkReal(-1.00000000000000))*(x25)*(x65)))+(((IkReal(-1.00000000000000))*(x18)*(x47)))))))+(((x11)*(((((x32)*(x66)))+(((x41)*(x70))))))));
eerot[2]=((((x13)*(((x43)+(((IkReal(-1.00000000000000))*(x20)*(x53)))))))+(((x12)*(x70))));
IkReal x74=((IkReal(1.00000000000000))*(x35));
IkReal x75=((IkReal(1.00000000000000))*(x4));
IkReal x76=((IkReal(1.00000000000000))*(x33));
eetrans[0]=((IkReal(0.0556950000000000))+(((x12)*(((((x26)*(x51)))+(((x19)*(((x59)+(((IkReal(-1.00000000000000))*(x0)*(x74)))))))))))+(((IkReal(-1.00000000000000))*(x27)*(x75)))+(x14)+(((IkReal(-1.00000000000000))*(x14)*(x76)))+(((x22)*(x37)))+(((x5)*(((((IkReal(-1.00000000000000))*(x22)*(x76)))+(((IkReal(-1.00000000000000))*(x21)*(x75)))))))+(((x9)*(((((x15)*(x54)))+(((IkReal(-1.00000000000000))*(x28)*(x74)))))))+(((x13)*(((((IkReal(0.279525000000000))*(x0)*(x37)))+(((IkReal(-1.00000000000000))*(x17)*(x53)))))))+(((IkReal(0.364420000000000))*(x0)*(x6)))+(((x8)*(((((x24)*(x34)))+(((IkReal(-0.0100000000000000))*(x39))))))));
eerot[3]=((((x10)*(((x68)+(x71)))))+(((x11)*(x72))));
eerot[4]=((((x10)*(x72)))+(((x11)*(((((IkReal(-1.00000000000000))*(x71)))+(((IkReal(-1.00000000000000))*(x68))))))));
eerot[5]=((((x12)*(x69)))+(((x13)*(((((IkReal(-1.00000000000000))*(x20)*(x52)))+(x45))))));
IkReal x77=((x3)*(x35));
IkReal x78=((IkReal(1.00000000000000))*(x33));
eetrans[1]=((((x12)*(((((x26)*(x55)))+(((x19)*(((x56)+(((IkReal(-1.00000000000000))*(x77)))))))))))+(((IkReal(-1.00000000000000))*(x27)*(x78)))+(x27)+(((x8)*(((((x24)*(x3)*(x4)))+(((x1)*(x28)))))))+(((x9)*(((((x15)*(x48)))+(((IkReal(-0.0100000000000000))*(x77)))))))+(((x21)*(x37)))+(((x13)*(((((IkReal(-1.00000000000000))*(x17)*(x52)))+(((IkReal(0.279525000000000))*(x36)*(x7)))))))+(((x5)*(((((x22)*(x4)))+(((IkReal(-1.00000000000000))*(x21)*(x78)))))))+(((IkReal(0.364420000000000))*(x36)))+(((x14)*(x4))));
eerot[6]=((((x11)*(((x46)+(((x38)*(x49)))))))+(((x10)*(((((x12)*(x50)))+(x67))))));
eerot[7]=((((x10)*(((x46)+(((IkReal(-1.00000000000000))*(x25)*(x49)))))))+(((x11)*(((((x32)*(x50)))+(((x41)*(x63))))))));
eerot[8]=((((x13)*(((((IkReal(-1.00000000000000))*(x30)))+(((IkReal(-1.00000000000000))*(x20)*(x31)))))))+(((x12)*(x63))));
IkReal x79=((IkReal(1.00000000000000))*(x31));
eetrans[2]=((IkReal(0.281388000000000))+(((IkReal(-0.0690000000000000))*(x31)))+(((IkReal(0.0100000000000000))*(x40)*(x8)))+(((IkReal(-0.374290000000000))*(x30)))+(((IkReal(-0.364420000000000))*(x2)))+(((x12)*(((((x19)*(x49)))+(((x26)*(x40)))))))+(((x13)*(((((IkReal(-0.279525000000000))*(x30)))+(((IkReal(-1.00000000000000))*(x17)*(x79)))))))+(((x9)*(((((IkReal(-1.00000000000000))*(x15)*(x79)))+(((x24)*(x5)))))))+(((IkReal(-0.374290000000000))*(x31)*(x5))));
}

IKFAST_API int GetNumFreeParameters() { return 1; }
IKFAST_API int* GetFreeParameters() { static int freeparams[] = {5}; return freeparams; }
IKFAST_API int GetNumJoints() { return 7; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j1,cj1,sj1,htj1,j2,cj2,sj2,htj2,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,j6,cj6,sj6,htj6,j5,cj5,sj5,htj5,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4,_ij6[2], _nj6,_ij5[2], _nj5;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j6=numeric_limits<IkReal>::quiet_NaN(); _ij6[0] = -1; _ij6[1] = -1; _nj6 = -1;  _ij5[0] = -1; _ij5[1] = -1; _nj5 = 0; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
j5=pfree[0]; cj5=cos(pfree[0]); sj5=sin(pfree[0]);
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=((IkReal(-1.00000000000000))*(r01));
new_r01=r00;
new_r02=r02;
new_px=((IkReal(-0.0556950000000000))+(((IkReal(-0.279525000000000))*(r02)))+(px));
new_r10=((IkReal(-1.00000000000000))*(r11));
new_r11=r10;
new_r12=r12;
new_py=((((IkReal(-0.279525000000000))*(r12)))+(py));
new_r20=((IkReal(-1.00000000000000))*(r21));
new_r21=r20;
new_r22=r22;
new_pz=((IkReal(-0.281388000000000))+(((IkReal(-0.279525000000000))*(r22)))+(pz));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
pp=(((px)*(px))+((pz)*(pz))+((py)*(py)));
npx=((((py)*(r10)))+(((pz)*(r20)))+(((px)*(r00))));
npy=((((px)*(r01)))+(((pz)*(r21)))+(((py)*(r11))));
npz=((((py)*(r12)))+(((pz)*(r22)))+(((px)*(r02))));
rxp0_0=((((IkReal(-1.00000000000000))*(py)*(r20)))+(((pz)*(r10))));
rxp0_1=((((px)*(r20)))+(((IkReal(-1.00000000000000))*(pz)*(r00))));
rxp0_2=((((py)*(r00)))+(((IkReal(-1.00000000000000))*(px)*(r10))));
rxp1_0=((((pz)*(r11)))+(((IkReal(-1.00000000000000))*(py)*(r21))));
rxp1_1=((((IkReal(-1.00000000000000))*(pz)*(r01)))+(((px)*(r21))));
rxp1_2=((((py)*(r01)))+(((IkReal(-1.00000000000000))*(px)*(r11))));
rxp2_0=((((IkReal(-1.00000000000000))*(py)*(r22)))+(((pz)*(r12))));
rxp2_1=((((px)*(r22)))+(((IkReal(-1.00000000000000))*(pz)*(r02))));
rxp2_2=((((py)*(r02)))+(((IkReal(-1.00000000000000))*(px)*(r12))));
IkReal op[72], zeror[48];
int numroots;
IkReal x80=((IkReal(0.138000000000000))*(px));
IkReal x81=((IkReal(0.748580000000000))*(py));
IkReal x82=((IkReal(0.0200000000000000))*(rxp0_1));
IkReal x83=((IkReal(0.00866840000000000))*(r20));
IkReal x84=((IkReal(0.00728840000000000))*(r00));
IkReal x85=((IkReal(0.0400000000000000))*(rxp1_1));
IkReal x86=((IkReal(0.00590840000000000))*(r20));
IkReal x87=((IkReal(0.276000000000000))*(py));
IkReal x88=((IkReal(1.49716000000000))*(px));
IkReal x89=((IkReal(0.0400000000000000))*(rxp0_0));
IkReal x90=((IkReal(0.0145768000000000))*(r10));
IkReal x91=((IkReal(0.0800000000000000))*(rxp1_0));
IkReal x92=((IkReal(0.0173368000000000))*(r21));
IkReal x93=((IkReal(0.0118168000000000))*(r21));
IkReal x94=((cj5)*(r00));
IkReal x95=((IkReal(0.0959180554000000))*(sj5));
IkReal x96=((cj5)*(r12));
IkReal x97=((cj5)*(r02));
IkReal x98=((r11)*(sj5));
IkReal x99=((r12)*(sj5));
IkReal x100=((r02)*(sj5));
IkReal x101=((rxp1_2)*(sj5));
IkReal x102=((cj5)*(rxp2_2));
IkReal x103=((r00)*(sj5));
IkReal x104=((npx)*(sj5));
IkReal x105=((r10)*(sj5));
IkReal x106=((IkReal(2.00000000000000))*(pp));
IkReal x107=((rxp0_2)*(sj5));
IkReal x108=((IkReal(1.45768000000000))*(sj5));
IkReal x109=((cj5)*(r01));
IkReal x110=((IkReal(1.00000000000000))*(pp));
IkReal x111=((cj5)*(npz));
IkReal x112=((IkReal(4.00000000000000))*(px));
IkReal x113=((r01)*(sj5));
IkReal x114=((cj5)*(r10));
IkReal x115=((npy)*(sj5));
IkReal x116=((IkReal(2.00000000000000))*(py));
IkReal x117=((cj5)*(r11));
IkReal x118=((IkReal(0.0516520200000000))*(x97));
IkReal x119=((IkReal(0.0200000000000000))*(cj5)*(npy));
IkReal x120=((IkReal(0.00138000000000000))*(x100));
IkReal x121=((IkReal(0.0516520200000000))*(x113));
IkReal x122=((IkReal(0.748580000000000))*(x111));
IkReal x123=((IkReal(0.00138000000000000))*(x109));
IkReal x124=((IkReal(0.748580000000000))*(x115));
IkReal x125=((IkReal(0.0200000000000000))*(npz)*(sj5));
IkReal x126=((IkReal(0.0526208923000000))*(x98));
IkReal x127=((IkReal(0.0526208923000000))*(x96));
IkReal x128=((IkReal(0.00748580000000000))*(x117));
IkReal x129=((IkReal(0.866840000000000))*(x102));
IkReal x130=((pp)*(x96));
IkReal x131=((IkReal(0.866840000000000))*(x101));
IkReal x132=((IkReal(0.00748580000000000))*(x99));
IkReal x133=((IkReal(0.728840000000000))*(cj5)*(rxp2_0));
IkReal x134=((IkReal(0.728840000000000))*(rxp1_0)*(sj5));
IkReal x135=((IkReal(0.0149716000000000))*(x114));
IkReal x136=((pp)*(x98));
IkReal x137=((IkReal(0.0479590277000000))*(x98));
IkReal x138=((IkReal(0.0479590277000000))*(x96));
IkReal x139=((IkReal(0.590840000000000))*(x102));
IkReal x140=((IkReal(0.590840000000000))*(x101));
IkReal x141=((IkReal(0.103304040000000))*(x96));
IkReal x142=((IkReal(0.103304040000000))*(x98));
IkReal x143=((IkReal(0.00276000000000000))*(x99));
IkReal x144=((IkReal(0.00276000000000000))*(x117));
IkReal x145=((IkReal(0.0149716000000000))*(x100));
IkReal x146=((IkReal(0.105241784600000))*(x97));
IkReal x147=((IkReal(0.105241784600000))*(x113));
IkReal x148=((IkReal(0.0149716000000000))*(x109));
IkReal x149=((IkReal(1.45768000000000))*(cj5)*(rxp2_1));
IkReal x150=((rxp1_1)*(x108));
IkReal x151=((IkReal(0.0299432000000000))*(x94));
IkReal x152=((IkReal(0.0959180554000000))*(x97));
IkReal x153=((r01)*(x95));
IkReal x154=((IkReal(0.103304040000000))*(x103));
IkReal x155=((IkReal(1.49716000000000))*(x104));
IkReal x156=((IkReal(0.0400000000000000))*(cj5)*(npx));
IkReal x157=((IkReal(0.00276000000000000))*(x94));
IkReal x158=((IkReal(0.105241784600000))*(x105));
IkReal x159=((IkReal(1.73368000000000))*(x107));
IkReal x160=((IkReal(1.18168000000000))*(x107));
IkReal x161=((r10)*(x95));
IkReal x162=((x115)*(x116));
IkReal x163=((x111)*(x116));
IkReal x164=((x110)*(x98));
IkReal x165=((IkReal(4.00000000000000))*(py)*(x104));
IkReal x166=((x105)*(x106));
IkReal x167=((x112)*(x115));
IkReal x168=((x111)*(x112));
IkReal x169=((x106)*(x113));
IkReal x170=((x106)*(x97));
IkReal x171=((IkReal(4.00000000000000))*(pp)*(x103));
IkReal x172=((IkReal(8.00000000000000))*(px)*(x104));
IkReal x173=((x110)*(x96));
IkReal x174=((((IkReal(-1.00000000000000))*(rxp0_0)*(x108)))+(((IkReal(-0.0145768000000000))*(r01))));
IkReal x175=((((IkReal(0.00552000000000000))*(x114)))+(((IkReal(-0.206608080000000))*(x105))));
IkReal x176=((((IkReal(-0.0291536000000000))*(r11)))+(((IkReal(-2.91536000000000))*(rxp0_1)*(sj5))));
IkReal x177=((x133)+(x84));
IkReal x178=((((IkReal(0.0145768000000000))*(r01)))+(((rxp0_0)*(x108))));
IkReal x179=((x129)+(x83));
IkReal x180=((x130)+(x81));
IkReal x181=((x159)+(x92));
IkReal x182=((IkReal(0.00739106770000000))+(x123)+(pp));
IkReal x183=((x119)+(x80));
IkReal x184=((x124)+(x80));
IkReal x185=((IkReal(0.00739106770000000))+(x121)+(pp));
IkReal x186=((x160)+(x93));
IkReal x187=((x134)+(x133));
IkReal x188=((x173)+(x81));
IkReal x189=((x139)+(x140));
IkReal x190=((x170)+(x88));
IkReal x191=((x126)+(x131));
IkReal x192=((x125)+(x122));
IkReal x193=((x172)+(x91));
IkReal x194=((x165)+(x85));
IkReal x195=((x141)+(x143));
IkReal x196=((x177)+(((IkReal(-1.00000000000000))*(x134))));
IkReal x197=((x187)+(((IkReal(-1.00000000000000))*(x84))));
IkReal x198=((((IkReal(-1.00000000000000))*(x150)))+(x149)+(x90));
IkReal x199=((x150)+(((IkReal(-1.00000000000000))*(x90)))+(x149));
IkReal x200=((((IkReal(-1.00000000000000))*(x177)))+(x134));
IkReal x201=((((IkReal(-1.00000000000000))*(x187)))+(x84));
IkReal x202=((x163)+(x132));
IkReal x203=((x127)+(x162));
IkReal x204=((x153)+(x167));
IkReal x205=((x168)+(x145));
IkReal x206=((x171)+(x151));
IkReal x207=((x166)+(x135));
IkReal x208=((x162)+(x137));
IkReal x209=((x128)+(x136)+(x82));
IkReal x210=((x128)+(x164)+(x82));
IkReal x211=((x169)+(x148)+(x89));
IkReal x212=((x124)+(x120)+(x118));
IkReal x213=((x208)+(x86));
IkReal x214=((x194)+(x161));
IkReal x215=((x120)+(x119)+(x118));
IkReal x216=((x158)+(x207));
IkReal x217=((x152)+(x205));
IkReal x218=((((IkReal(-1.00000000000000))*(x154)))+(x157)+(x155)+(((IkReal(-1.00000000000000))*(x156))));
IkReal x219=((x155)+(x154)+(((IkReal(-1.00000000000000))*(x157)))+(((IkReal(-1.00000000000000))*(x156))));
IkReal x220=((((IkReal(-1.00000000000000))*(x142)))+(x195)+(x144)+(((IkReal(-1.00000000000000))*(x87))));
IkReal x221=((x195)+(x142)+(((IkReal(-1.00000000000000))*(x144)))+(((IkReal(-1.00000000000000))*(x87))));
IkReal x222=((((IkReal(-1.00000000000000))*(x192)))+(((IkReal(-1.00000000000000))*(x183)))+(x212)+(x182)+(((IkReal(-1.00000000000000))*(x121))));
IkReal x223=((((IkReal(-1.00000000000000))*(x192)))+(x215)+(x185)+(((IkReal(-1.00000000000000))*(x184)))+(((IkReal(-1.00000000000000))*(x123))));
IkReal x224=((((IkReal(-1.00000000000000))*(x192)))+(((IkReal(-1.00000000000000))*(x215)))+(x184)+(x185)+(((IkReal(-1.00000000000000))*(x123))));
IkReal x225=((((IkReal(-1.00000000000000))*(x192)))+(((IkReal(-1.00000000000000))*(x212)))+(x182)+(x183)+(((IkReal(-1.00000000000000))*(x121))));
op[0]=x222;
op[1]=IkReal(0);
op[2]=x218;
op[3]=IkReal(0);
op[4]=x223;
op[5]=IkReal(0);
op[6]=IkReal(0);
op[7]=x222;
op[8]=IkReal(0);
op[9]=x218;
op[10]=IkReal(0);
op[11]=x223;
op[12]=((((IkReal(-1.00000000000000))*(x210)))+(x179)+(((IkReal(-1.00000000000000))*(x191)))+(((IkReal(-1.00000000000000))*(x202)))+(x180)+(x203));
op[13]=x196;
op[14]=((x194)+(((IkReal(-1.00000000000000))*(x181)))+(((IkReal(-1.00000000000000))*(x216))));
op[15]=x174;
op[16]=((((IkReal(-1.00000000000000))*(x202)))+(x191)+(x180)+(x127)+(x129)+(x209)+(((IkReal(-1.00000000000000))*(x83)))+(((IkReal(-1.00000000000000))*(x162))));
op[17]=x197;
op[18]=x196;
op[19]=((((IkReal(-1.00000000000000))*(x86)))+(((IkReal(-1.00000000000000))*(x210)))+(((IkReal(-1.00000000000000))*(x202)))+(((IkReal(-1.00000000000000))*(x139)))+(((IkReal(-1.00000000000000))*(x138)))+(x180)+(x208)+(x140));
op[20]=x174;
op[21]=((x214)+(x186)+(((IkReal(-1.00000000000000))*(x207))));
op[22]=x197;
op[23]=((((IkReal(-1.00000000000000))*(x189)))+(((IkReal(-1.00000000000000))*(x202)))+(((IkReal(-1.00000000000000))*(x138)))+(x180)+(x209)+(x86)+(((IkReal(-1.00000000000000))*(x208))));
op[24]=x220;
op[25]=IkReal(0);
op[26]=x175;
op[27]=IkReal(0);
op[28]=x221;
op[29]=IkReal(0);
op[30]=IkReal(0);
op[31]=x220;
op[32]=IkReal(0);
op[33]=x175;
op[34]=IkReal(0);
op[35]=x221;
op[36]=((((IkReal(-1.00000000000000))*(x167)))+(x211)+(((IkReal(-1.00000000000000))*(x146)))+(x205)+(((IkReal(-1.00000000000000))*(x190)))+(x147));
op[37]=x198;
op[38]=((((IkReal(-1.00000000000000))*(x193)))+(x206)+(((IkReal(0.210483569200000))*(x103))));
op[39]=x176;
op[40]=((((IkReal(-1.00000000000000))*(x146)))+(x167)+(x205)+(((IkReal(-1.00000000000000))*(x147)))+(((IkReal(-1.00000000000000))*(x190)))+(((IkReal(-1.00000000000000))*(x211))));
op[41]=x199;
op[42]=x198;
op[43]=((((IkReal(-1.00000000000000))*(x204)))+(x211)+(x217)+(((IkReal(-1.00000000000000))*(x190))));
op[44]=x176;
op[45]=((((IkReal(-1.00000000000000))*(x193)))+(x206)+(((IkReal(-0.191836110800000))*(x103))));
op[46]=x199;
op[47]=((x217)+(x204)+(((IkReal(-1.00000000000000))*(x190)))+(((IkReal(-1.00000000000000))*(x211))));
op[48]=x224;
op[49]=IkReal(0);
op[50]=x219;
op[51]=IkReal(0);
op[52]=x225;
op[53]=IkReal(0);
op[54]=IkReal(0);
op[55]=x224;
op[56]=IkReal(0);
op[57]=x219;
op[58]=IkReal(0);
op[59]=x225;
op[60]=((x179)+(((IkReal(-1.00000000000000))*(x188)))+(((IkReal(-1.00000000000000))*(x203)))+(((IkReal(-1.00000000000000))*(x131)))+(x126)+(x202)+(x209));
op[61]=x200;
op[62]=((x216)+(((IkReal(-1.00000000000000))*(x181)))+(((IkReal(-1.00000000000000))*(x194))));
op[63]=x178;
op[64]=((((IkReal(-1.00000000000000))*(x210)))+(((IkReal(-1.00000000000000))*(x188)))+(((IkReal(-1.00000000000000))*(x126)))+(((IkReal(-1.00000000000000))*(x127)))+(x129)+(x162)+(x202)+(((IkReal(-1.00000000000000))*(x83)))+(x131));
op[65]=x201;
op[66]=x200;
op[67]=((((IkReal(-1.00000000000000))*(x188)))+(((IkReal(-1.00000000000000))*(x139)))+(((IkReal(-1.00000000000000))*(x213)))+(x202)+(x209)+(x138)+(x140));
op[68]=x178;
op[69]=((((IkReal(-1.00000000000000))*(x214)))+(x186)+(x207));
op[70]=x201;
op[71]=((((IkReal(-1.00000000000000))*(x210)))+(((IkReal(-1.00000000000000))*(x188)))+(((IkReal(-1.00000000000000))*(x189)))+(x213)+(x202)+(x138));
solvedialyticpoly8qep(op,zeror,numroots);
IkReal j0array[16], cj0array[16], sj0array[16], j6array[16], cj6array[16], sj6array[16], j1array[16], cj1array[16], sj1array[16];
int numsolutions = 0;
for(int ij0 = 0; ij0 < numroots; ij0 += 3)
{
IkReal htj0 = zeror[ij0+0], htj6 = zeror[ij0+1], htj1 = zeror[ij0+2];
j0array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj0)));
j6array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj6)));
j1array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj1)));
IkReal x226=(htj0)*(htj0);
IkReal x227=(htj6)*(htj6);
IkReal x228=(htj1)*(htj1);
cj0array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x226))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x226)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x226))))));
cj6array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x227))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x227)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x227))))));
cj1array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x228))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x228)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x228))))));
sj0array[numsolutions]=((IkReal(2.00000000000000))*(htj0)*(((IKabs(((IkReal(1.00000000000000))+((htj0)*(htj0)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj0)*(htj0))))):(IkReal)1.0e30)));
sj6array[numsolutions]=((IkReal(2.00000000000000))*(htj6)*(((IKabs(((IkReal(1.00000000000000))+((htj6)*(htj6)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj6)*(htj6))))):(IkReal)1.0e30)));
sj1array[numsolutions]=((IkReal(2.00000000000000))*(htj1)*(((IKabs(((IkReal(1.00000000000000))+((htj1)*(htj1)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj1)*(htj1))))):(IkReal)1.0e30)));
if( j0array[numsolutions] > IKPI )
{
    j0array[numsolutions]-=IK2PI;
}
else if( j0array[numsolutions] < -IKPI )
{
    j0array[numsolutions]+=IK2PI;
}
if( j6array[numsolutions] > IKPI )
{
    j6array[numsolutions]-=IK2PI;
}
else if( j6array[numsolutions] < -IKPI )
{
    j6array[numsolutions]+=IK2PI;
}
if( j1array[numsolutions] > IKPI )
{
    j1array[numsolutions]-=IK2PI;
}
else if( j1array[numsolutions] < -IKPI )
{
    j1array[numsolutions]+=IK2PI;
}
numsolutions++;
}
bool j0valid[16]={true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true};
_nj0 = 16;
_nj6 = 1;
_nj1 = 1;
for(int ij0 = 0; ij0 < numsolutions; ++ij0)
    {
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
_ij6[0] = 0; _ij6[1] = -1;
_ij1[0] = 0; _ij1[1] = -1;
for(int iij0 = ij0+1; iij0 < numsolutions; ++iij0)
{
if( !j0valid[iij0] ) { continue; }
if( IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(cj6array[ij0]-cj6array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij0]-sj6array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(cj1array[ij0]-cj1array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij0]-sj1array[iij0]) < IKFAST_SOLUTION_THRESH &&  1 )
{
    j0valid[iij0]=false; _ij0[1] = iij0; _ij6[1] = 0; _ij1[1] = 0;  break; 
}
}
    j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

    j6 = j6array[ij0]; cj6 = cj6array[ij0]; sj6 = sj6array[ij0];

    j1 = j1array[ij0]; cj1 = cj1array[ij0]; sj1 = sj1array[ij0];

{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[2];
IkReal x229=((cj0)*(cj5));
IkReal x230=((IkReal(0.374290000000000))*(sj0));
IkReal x231=((cj6)*(r11));
IkReal x232=((IkReal(0.0100000000000000))*(sj6));
IkReal x233=((cj6)*(r01));
IkReal x234=((IkReal(0.0100000000000000))*(sj0));
IkReal x235=((cj0)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.433420000000000))+(((cj5)*(r10)*(sj0)*(x232)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(sj6)*(x230)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-0.374290000000000))*(r00)*(sj6)*(x235)))+(((IkReal(-1.00000000000000))*(sj5)*(x230)*(x231)))+(((IkReal(0.0100000000000000))*(r02)*(x235)))+(((IkReal(-0.374290000000000))*(x233)*(x235)))+(((r12)*(sj5)*(x234)))+(((r00)*(x229)*(x232)))+(((IkReal(0.0100000000000000))*(x229)*(x233)))+(((cj5)*(x231)*(x234)))+(((cj5)*(r12)*(x230)))+(((IkReal(-1.00000000000000))*(py)*(sj0)))+(((IkReal(0.374290000000000))*(r02)*(x229))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x236=((cj0)*(r11));
IkReal x237=((r01)*(sj0));
IkReal x238=((cj0)*(r10));
IkReal x239=((IkReal(0.144927536231884))*(sj5));
IkReal x240=((IkReal(5.42449275362319))*(cj5));
IkReal x241=((r00)*(sj0));
IkReal x242=((cj0)*(r12));
IkReal x243=((r02)*(sj0));
IkReal x244=((IkReal(5.42449275362319))*(cj6)*(sj5));
IkReal x245=((IkReal(5.42449275362319))*(sj5)*(sj6));
IkReal x246=((IkReal(0.144927536231884))*(cj5)*(sj6));
IkReal x247=((IkReal(0.144927536231884))*(cj5)*(cj6));
if( IKabs(((((IkReal(-1.00000000000000))*(x238)*(x246)))+(((x241)*(x246)))+(((x240)*(x243)))+(((IkReal(-1.00000000000000))*(x236)*(x247)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((IkReal(-1.00000000000000))*(x239)*(x242)))+(((x236)*(x244)))+(((x238)*(x245)))+(((IkReal(-1.00000000000000))*(x241)*(x245)))+(((IkReal(-1.00000000000000))*(x240)*(x242)))+(((IkReal(-1.00000000000000))*(x237)*(x244)))+(((x239)*(x243)))+(((x237)*(x247))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r22)*(x240)))+(((IkReal(-14.4927536231884))*(pz)))+(((IkReal(-1.00000000000000))*(r20)*(x245)))+(((r22)*(x239)))+(((r21)*(x247)))+(((IkReal(-1.00000000000000))*(r21)*(x244)))+(((r20)*(x246))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x238)*(x246)))+(((x241)*(x246)))+(((x240)*(x243)))+(((IkReal(-1.00000000000000))*(x236)*(x247)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((IkReal(-1.00000000000000))*(x239)*(x242)))+(((x236)*(x244)))+(((x238)*(x245)))+(((IkReal(-1.00000000000000))*(x241)*(x245)))+(((IkReal(-1.00000000000000))*(x240)*(x242)))+(((IkReal(-1.00000000000000))*(x237)*(x244)))+(((x239)*(x243)))+(((x237)*(x247)))))+IKsqr(((((r22)*(x240)))+(((IkReal(-14.4927536231884))*(pz)))+(((IkReal(-1.00000000000000))*(r20)*(x245)))+(((r22)*(x239)))+(((r21)*(x247)))+(((IkReal(-1.00000000000000))*(r21)*(x244)))+(((r20)*(x246)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x238)*(x246)))+(((x241)*(x246)))+(((x240)*(x243)))+(((IkReal(-1.00000000000000))*(x236)*(x247)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((IkReal(-1.00000000000000))*(x239)*(x242)))+(((x236)*(x244)))+(((x238)*(x245)))+(((IkReal(-1.00000000000000))*(x241)*(x245)))+(((IkReal(-1.00000000000000))*(x240)*(x242)))+(((IkReal(-1.00000000000000))*(x237)*(x244)))+(((x239)*(x243)))+(((x237)*(x247)))), ((((r22)*(x240)))+(((IkReal(-14.4927536231884))*(pz)))+(((IkReal(-1.00000000000000))*(r20)*(x245)))+(((r22)*(x239)))+(((r21)*(x247)))+(((IkReal(-1.00000000000000))*(r21)*(x244)))+(((r20)*(x246)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x248=((cj6)*(r11));
IkReal x249=((IkReal(0.374290000000000))*(sj0));
IkReal x250=((IkReal(0.0100000000000000))*(cj5));
IkReal x251=((cj6)*(r21));
IkReal x252=((r10)*(sj6));
IkReal x253=((IkReal(0.374290000000000))*(sj5));
IkReal x254=((IkReal(0.0100000000000000))*(sj5));
IkReal x255=((cj6)*(r01));
IkReal x256=((r20)*(sj6));
IkReal x257=((IkReal(0.374290000000000))*(cj5));
IkReal x258=((cj0)*(r12));
IkReal x259=((r00)*(sj6));
IkReal x260=((cj0)*(x253));
evalcond[0]=((((IkReal(-1.00000000000000))*(r22)*(x254)))+(((x253)*(x256)))+(((IkReal(0.0690000000000000))*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(x250)*(x256)))+(((IkReal(-1.00000000000000))*(x250)*(x251)))+(pz)+(((x251)*(x253)))+(((IkReal(-1.00000000000000))*(r22)*(x257))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x254)))+(((IkReal(-1.00000000000000))*(sj0)*(x250)*(x255)))+(((IkReal(-1.00000000000000))*(sj0)*(x250)*(x259)))+(((IkReal(-1.00000000000000))*(cj0)*(py)))+(((IkReal(-1.00000000000000))*(x252)*(x260)))+(((cj0)*(x248)*(x250)))+(((sj5)*(x249)*(x259)))+(((IkReal(-1.00000000000000))*(x248)*(x260)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(x249)))+(((x254)*(x258)))+(((IkReal(0.0690000000000000))*(IKsin(j2))))+(((sj5)*(x249)*(x255)))+(((cj0)*(x250)*(x252)))+(((x257)*(x258)))+(((px)*(sj0))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst40;
IkReal x261=(sj6)*(sj6);
IkReal x262=(cj6)*(cj6);
IkReal x263=((r10)*(sj0));
IkReal x264=((r22)*(sj5));
IkReal x265=((cj0)*(cj5));
IkReal x266=((IkReal(1.00000000000000))*(r20));
IkReal x267=((cj0)*(sj6));
IkReal x268=((r21)*(sj5));
IkReal x269=((sj0)*(sj6));
IkReal x270=((cj6)*(sj5));
IkReal x271=((r21)*(x262));
IkReal x272=((cj5)*(r11)*(sj0));
IkReal x273=((r21)*(x261));
gconst40=IKsign(((((IkReal(-1.00000000000000))*(cj0)*(r02)*(x266)*(x270)))+(((cj5)*(x263)*(x271)))+(((cj6)*(x263)*(x264)))+(((IkReal(-1.00000000000000))*(r01)*(x264)*(x267)))+(((cj0)*(cj6)*(r00)*(x264)))+(((IkReal(-1.00000000000000))*(r01)*(x262)*(x265)*(x266)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x266)*(x270)))+(((IkReal(-1.00000000000000))*(x261)*(x266)*(x272)))+(((IkReal(-1.00000000000000))*(r11)*(x264)*(x269)))+(((cj5)*(x263)*(x273)))+(((r02)*(x267)*(x268)))+(((r00)*(x265)*(x271)))+(((r00)*(x265)*(x273)))+(((r12)*(x268)*(x269)))+(((IkReal(-1.00000000000000))*(x262)*(x266)*(x272)))+(((IkReal(-1.00000000000000))*(r01)*(x261)*(x265)*(x266)))));
IkReal x274=(sj6)*(sj6);
IkReal x275=(cj6)*(cj6);
IkReal x276=((r10)*(sj0));
IkReal x277=((r22)*(sj5));
IkReal x278=((cj0)*(cj5));
IkReal x279=((IkReal(1.00000000000000))*(r20));
IkReal x280=((cj0)*(sj6));
IkReal x281=((r21)*(sj5));
IkReal x282=((sj0)*(sj6));
IkReal x283=((cj6)*(sj5));
IkReal x284=((r21)*(x275));
IkReal x285=((cj5)*(r11)*(sj0));
IkReal x286=((r21)*(x274));
dummyeval[0]=((((cj5)*(x276)*(x284)))+(((IkReal(-1.00000000000000))*(r01)*(x275)*(x278)*(x279)))+(((r12)*(x281)*(x282)))+(((IkReal(-1.00000000000000))*(x275)*(x279)*(x285)))+(((cj0)*(cj6)*(r00)*(x277)))+(((IkReal(-1.00000000000000))*(r01)*(x274)*(x278)*(x279)))+(((cj5)*(x276)*(x286)))+(((r02)*(x280)*(x281)))+(((IkReal(-1.00000000000000))*(r11)*(x277)*(x282)))+(((IkReal(-1.00000000000000))*(x274)*(x279)*(x285)))+(((IkReal(-1.00000000000000))*(r01)*(x277)*(x280)))+(((cj6)*(x276)*(x277)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x279)*(x283)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x279)*(x283)))+(((r00)*(x278)*(x286)))+(((r00)*(x278)*(x284))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst39;
IkReal x287=(cj6)*(cj6);
IkReal x288=(sj6)*(sj6);
IkReal x289=((IkReal(1.00000000000000))*(r01));
IkReal x290=((sj0)*(sj5));
IkReal x291=((cj6)*(r22));
IkReal x292=((r21)*(sj6));
IkReal x293=((r00)*(r21));
IkReal x294=((cj0)*(sj5));
IkReal x295=((cj6)*(r20));
IkReal x296=((r22)*(sj6));
IkReal x297=((cj0)*(cj5));
IkReal x298=((IkReal(1.00000000000000))*(r10));
IkReal x299=((cj5)*(sj0));
IkReal x300=((r20)*(x288));
IkReal x301=((x287)*(x299));
gconst39=IKsign(((((IkReal(-1.00000000000000))*(x289)*(x299)*(x300)))+(((IkReal(-1.00000000000000))*(x291)*(x294)*(x298)))+(((IkReal(-1.00000000000000))*(r02)*(x290)*(x295)))+(((r11)*(x297)*(x300)))+(((r12)*(x294)*(x295)))+(((IkReal(-1.00000000000000))*(r21)*(x288)*(x297)*(x298)))+(((IkReal(-1.00000000000000))*(x289)*(x290)*(x296)))+(((x293)*(x301)))+(((r11)*(r20)*(x287)*(x297)))+(((IkReal(-1.00000000000000))*(r21)*(x287)*(x297)*(x298)))+(((r02)*(x290)*(x292)))+(((IkReal(-1.00000000000000))*(r20)*(x289)*(x301)))+(((x288)*(x293)*(x299)))+(((r11)*(x294)*(x296)))+(((IkReal(-1.00000000000000))*(r12)*(x292)*(x294)))+(((r00)*(x290)*(x291)))));
IkReal x302=(cj6)*(cj6);
IkReal x303=(sj6)*(sj6);
IkReal x304=((IkReal(1.00000000000000))*(r01));
IkReal x305=((sj0)*(sj5));
IkReal x306=((cj6)*(r22));
IkReal x307=((r21)*(sj6));
IkReal x308=((r00)*(r21));
IkReal x309=((cj0)*(sj5));
IkReal x310=((cj6)*(r20));
IkReal x311=((r22)*(sj6));
IkReal x312=((cj0)*(cj5));
IkReal x313=((IkReal(1.00000000000000))*(r10));
IkReal x314=((cj5)*(sj0));
IkReal x315=((r20)*(x303));
IkReal x316=((x302)*(x314));
dummyeval[0]=((((x303)*(x308)*(x314)))+(((x308)*(x316)))+(((IkReal(-1.00000000000000))*(x304)*(x314)*(x315)))+(((r00)*(x305)*(x306)))+(((IkReal(-1.00000000000000))*(x304)*(x305)*(x311)))+(((IkReal(-1.00000000000000))*(r21)*(x302)*(x312)*(x313)))+(((r11)*(x312)*(x315)))+(((IkReal(-1.00000000000000))*(r21)*(x303)*(x312)*(x313)))+(((r02)*(x305)*(x307)))+(((IkReal(-1.00000000000000))*(x306)*(x309)*(x313)))+(((IkReal(-1.00000000000000))*(r12)*(x307)*(x309)))+(((IkReal(-1.00000000000000))*(r02)*(x305)*(x310)))+(((r11)*(r20)*(x302)*(x312)))+(((r11)*(x309)*(x311)))+(((r12)*(x309)*(x310)))+(((IkReal(-1.00000000000000))*(r20)*(x304)*(x316))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x317=((cj5)*(r22));
IkReal x318=((IkReal(0.374290000000000))*(sj5));
IkReal x319=((cj0)*(sj6));
IkReal x320=((cj6)*(r21));
IkReal x321=((IkReal(0.0100000000000000))*(sj5));
IkReal x322=((cj0)*(r02));
IkReal x323=((IkReal(0.0100000000000000))*(cj5));
IkReal x324=((IkReal(1.00000000000000))*(py));
IkReal x325=((r01)*(sj0));
IkReal x326=((r20)*(sj6));
IkReal x327=((r11)*(sj0));
IkReal x328=((IkReal(0.374290000000000))*(cj5));
IkReal x329=((cj0)*(r12));
IkReal x330=((sj0)*(x328));
IkReal x331=((cj6)*(x323));
IkReal x332=((r10)*(sj0)*(sj6));
IkReal x333=((r00)*(sj0)*(sj6));
IkReal x334=((cj0)*(cj6)*(x318));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x317)))+(((sj5)*(x320)))+(((sj5)*(x326))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x320)*(x323)))+(((x318)*(x326)))+(((IkReal(-1.00000000000000))*(r22)*(x321)))+(((IkReal(-0.374290000000000))*(x317)))+(((x318)*(x320)))+(pz)+(((IkReal(-1.00000000000000))*(x323)*(x326))));
evalcond[3]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r11)*(x334)))+(((IkReal(-1.00000000000000))*(x323)*(x333)))+(((r10)*(x319)*(x323)))+(((IkReal(-1.00000000000000))*(r02)*(x330)))+(((x328)*(x329)))+(((cj6)*(x318)*(x325)))+(((x321)*(x329)))+(((IkReal(-1.00000000000000))*(cj0)*(x324)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x321)))+(((x318)*(x333)))+(((cj0)*(r11)*(x331)))+(((IkReal(-1.00000000000000))*(x325)*(x331)))+(((IkReal(-1.00000000000000))*(r10)*(x318)*(x319)))+(((px)*(sj0))));
evalcond[4]=((IkReal(0.433420000000000))+(((r00)*(x319)*(x323)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((x323)*(x332)))+(((x322)*(x328)))+(((r12)*(sj0)*(x321)))+(((cj0)*(r01)*(x331)))+(((x321)*(x322)))+(((IkReal(-1.00000000000000))*(r01)*(x334)))+(((IkReal(-1.00000000000000))*(r00)*(x318)*(x319)))+(((IkReal(-1.00000000000000))*(sj0)*(x324)))+(((r12)*(x330)))+(((x327)*(x331)))+(((IkReal(-1.00000000000000))*(x318)*(x332)))+(((IkReal(-1.00000000000000))*(cj6)*(x318)*(x327))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x335=((cj0)*(cj5));
IkReal x336=((IkReal(1.00000000000000))*(cj0));
IkReal x337=((cj6)*(r11));
IkReal x338=((r10)*(sj6));
IkReal x339=((cj5)*(sj0));
IkReal x340=((r00)*(sj5)*(sj6));
IkReal x341=((cj6)*(r01)*(sj5));
IkReal x342=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x336)*(x338)))+(((IkReal(-1.00000000000000))*(r02)*(x339)))+(((r12)*(x335)))+(((sj0)*(x341)))+(((IkReal(-1.00000000000000))*(sj5)*(x336)*(x337)))+(((sj0)*(x340))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r12)*(x339)))+(((r02)*(x335)))+(((IkReal(-1.00000000000000))*(x336)*(x340)))+(((IkReal(-1.00000000000000))*(x336)*(x341)))+(((IkReal(-1.00000000000000))*(x337)*(x342)))+(((IkReal(-1.00000000000000))*(x338)*(x342))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x336)*(x338)))+(((IkReal(-1.00000000000000))*(r02)*(x339)))+(((r12)*(x335)))+(((sj0)*(x341)))+(((IkReal(-1.00000000000000))*(sj5)*(x336)*(x337)))+(((sj0)*(x340)))))+IKsqr(((((r12)*(x339)))+(((r02)*(x335)))+(((IkReal(-1.00000000000000))*(x336)*(x340)))+(((IkReal(-1.00000000000000))*(x336)*(x341)))+(((IkReal(-1.00000000000000))*(x337)*(x342)))+(((IkReal(-1.00000000000000))*(x338)*(x342)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x336)*(x338)))+(((IkReal(-1.00000000000000))*(r02)*(x339)))+(((r12)*(x335)))+(((sj0)*(x341)))+(((IkReal(-1.00000000000000))*(sj5)*(x336)*(x337)))+(((sj0)*(x340)))), ((((r12)*(x339)))+(((r02)*(x335)))+(((IkReal(-1.00000000000000))*(x336)*(x340)))+(((IkReal(-1.00000000000000))*(x336)*(x341)))+(((IkReal(-1.00000000000000))*(x337)*(x342)))+(((IkReal(-1.00000000000000))*(x338)*(x342)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x343=((cj0)*(cj5));
IkReal x344=((IkReal(1.00000000000000))*(cj0));
IkReal x345=((cj6)*(r11));
IkReal x346=((r10)*(sj6));
IkReal x347=((cj5)*(sj0));
IkReal x348=((r00)*(sj5)*(sj6));
IkReal x349=((cj6)*(r01)*(sj5));
IkReal x350=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj5)*(x344)*(x346)))+(((IkReal(-1.00000000000000))*(r02)*(x347)))+(((r12)*(x343)))+(((sj0)*(x348)))+(((sj0)*(x349)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(sj5)*(x344)*(x345))));
evalcond[1]=((((r12)*(x347)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(x344)*(x348)))+(((IkReal(-1.00000000000000))*(x346)*(x350)))+(((IkReal(-1.00000000000000))*(x344)*(x349)))+(((IkReal(-1.00000000000000))*(x345)*(x350)))+(((r02)*(x343))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst46;
IkReal x351=(cj5)*(cj5);
IkReal x352=(r20)*(r20);
IkReal x353=(sj6)*(sj6);
IkReal x354=(cj6)*(cj6);
IkReal x355=(r21)*(r21);
IkReal x356=((cj6)*(r21));
IkReal x357=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x358=((cj5)*(r22)*(sj5));
gconst46=IKsign((((((r22)*(r22))*((sj5)*(sj5))))+(((x353)*(x355)))+(((IkReal(2.00000000000000))*(x356)*(x358)))+(((x357)*(x358)))+(((IkReal(-1.00000000000000))*(x356)*(x357)))+(((x351)*(x356)*(x357)))+(((x351)*(x352)*(x353)))+(((x351)*(x354)*(x355)))+(((x352)*(x354)))));
IkReal x359=(cj5)*(cj5);
IkReal x360=(r20)*(r20);
IkReal x361=(sj6)*(sj6);
IkReal x362=(cj6)*(cj6);
IkReal x363=(r21)*(r21);
IkReal x364=((cj6)*(r21));
IkReal x365=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x366=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x359)*(x364)*(x365)))+(((x365)*(x366)))+((((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x364)*(x365)))+(((x359)*(x360)*(x361)))+(((x360)*(x362)))+(((x359)*(x362)*(x363)))+(((IkReal(2.00000000000000))*(x364)*(x366)))+(((x361)*(x363))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst47;
IkReal x367=(cj6)*(cj6);
IkReal x368=(sj6)*(sj6);
IkReal x369=((IkReal(1.00000000000000))*(r21));
IkReal x370=((cj6)*(r20));
IkReal x371=((r22)*(sj5));
IkReal x372=((r01)*(sj0));
IkReal x373=((r00)*(sj0));
IkReal x374=((cj0)*(r10));
IkReal x375=((r02)*(sj0)*(sj5));
IkReal x376=((cj5)*(x367));
IkReal x377=((cj0)*(r12)*(sj5));
IkReal x378=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x379=((cj5)*(x368));
IkReal x380=((r20)*(x379));
gconst47=IKsign(((((IkReal(-1.00000000000000))*(cj6)*(x371)*(x373)))+(((IkReal(-1.00000000000000))*(sj6)*(x369)*(x375)))+(((sj6)*(x371)*(x372)))+(((r21)*(x374)*(x376)))+(((IkReal(-1.00000000000000))*(r20)*(x376)*(x378)))+(((IkReal(-1.00000000000000))*(sj6)*(x371)*(x378)))+(((IkReal(-1.00000000000000))*(x369)*(x373)*(x376)))+(((IkReal(-1.00000000000000))*(x378)*(x380)))+(((r21)*(x374)*(x379)))+(((r21)*(sj6)*(x377)))+(((IkReal(-1.00000000000000))*(x369)*(x373)*(x379)))+(((IkReal(-1.00000000000000))*(x370)*(x377)))+(((cj6)*(x371)*(x374)))+(((r20)*(x372)*(x376)))+(((x372)*(x380)))+(((x370)*(x375)))));
IkReal x381=(cj6)*(cj6);
IkReal x382=(sj6)*(sj6);
IkReal x383=((IkReal(1.00000000000000))*(r21));
IkReal x384=((cj6)*(r20));
IkReal x385=((r22)*(sj5));
IkReal x386=((r01)*(sj0));
IkReal x387=((r00)*(sj0));
IkReal x388=((cj0)*(r10));
IkReal x389=((r02)*(sj0)*(sj5));
IkReal x390=((cj5)*(x381));
IkReal x391=((cj0)*(r12)*(sj5));
IkReal x392=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x393=((cj5)*(x382));
IkReal x394=((r20)*(x393));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x383)*(x387)*(x390)))+(((x384)*(x389)))+(((r20)*(x386)*(x390)))+(((IkReal(-1.00000000000000))*(r20)*(x390)*(x392)))+(((x386)*(x394)))+(((IkReal(-1.00000000000000))*(cj6)*(x385)*(x387)))+(((IkReal(-1.00000000000000))*(x383)*(x387)*(x393)))+(((IkReal(-1.00000000000000))*(sj6)*(x383)*(x389)))+(((sj6)*(x385)*(x386)))+(((IkReal(-1.00000000000000))*(sj6)*(x385)*(x392)))+(((IkReal(-1.00000000000000))*(x392)*(x394)))+(((IkReal(-1.00000000000000))*(x384)*(x391)))+(((r21)*(x388)*(x393)))+(((r21)*(sj6)*(x391)))+(((r21)*(x388)*(x390)))+(((cj6)*(x385)*(x388))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x395=((sj0)*(sj6));
IkReal x396=((cj0)*(r10));
IkReal x397=((IkReal(1.00000000000000))*(cj5));
IkReal x398=((cj6)*(sj0));
IkReal x399=((cj0)*(r11));
if( IKabs(((gconst47)*(((((IkReal(-1.00000000000000))*(r00)*(x398)))+(((cj6)*(x396)))+(((r01)*(x395)))+(((IkReal(-1.00000000000000))*(sj6)*(x399))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst47)*(((((cj5)*(sj6)*(x396)))+(((IkReal(-1.00000000000000))*(r01)*(x397)*(x398)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(cj6)*(x399)))+(((IkReal(-1.00000000000000))*(r00)*(x395)*(x397))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst47)*(((((IkReal(-1.00000000000000))*(r00)*(x398)))+(((cj6)*(x396)))+(((r01)*(x395)))+(((IkReal(-1.00000000000000))*(sj6)*(x399)))))), ((gconst47)*(((((cj5)*(sj6)*(x396)))+(((IkReal(-1.00000000000000))*(r01)*(x397)*(x398)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(cj6)*(x399)))+(((IkReal(-1.00000000000000))*(r00)*(x395)*(x397)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x400=IKsin(j4);
IkReal x401=IKcos(j4);
IkReal x402=((r22)*(sj5));
IkReal x403=((IkReal(1.00000000000000))*(cj6));
IkReal x404=((IkReal(1.00000000000000))*(cj0));
IkReal x405=((cj5)*(r11));
IkReal x406=((cj5)*(cj6));
IkReal x407=((r11)*(sj6));
IkReal x408=((IkReal(1.00000000000000))*(sj6));
IkReal x409=((cj6)*(r00));
IkReal x410=((r12)*(sj5));
IkReal x411=((r02)*(sj5));
IkReal x412=((cj6)*(r10));
IkReal x413=((cj5)*(sj6));
IkReal x414=((cj5)*(r01));
IkReal x415=((sj0)*(x400));
IkReal x416=((r00)*(x413));
IkReal x417=((cj0)*(x400));
IkReal x418=((sj0)*(x401));
IkReal x419=((r20)*(x401));
IkReal x420=((cj0)*(x401));
IkReal x421=((r21)*(x400));
IkReal x422=((r21)*(x401));
IkReal x423=((r20)*(x400));
IkReal x424=((x401)*(x410));
IkReal x425=((r01)*(sj6)*(x401));
IkReal x426=((cj5)*(r10)*(x408));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x403)*(x419)))+(((x413)*(x423)))+(((x406)*(x421)))+(((x400)*(x402)))+(((sj6)*(x422))));
evalcond[1]=((((x413)*(x419)))+(((IkReal(-1.00000000000000))*(x408)*(x421)))+(((x406)*(x422)))+(((cj6)*(x423)))+(((x401)*(x402))));
evalcond[2]=((((x412)*(x420)))+(((x415)*(x416)))+(((IkReal(-1.00000000000000))*(r10)*(x400)*(x404)*(x413)))+(((IkReal(-1.00000000000000))*(x401)*(x404)*(x407)))+(((IkReal(-1.00000000000000))*(r00)*(x403)*(x418)))+(((IkReal(-1.00000000000000))*(x400)*(x404)*(x410)))+(((r01)*(sj6)*(x418)))+(((IkReal(-1.00000000000000))*(x403)*(x405)*(x417)))+(((x411)*(x415)))+(((r01)*(x406)*(x415))));
evalcond[3]=((((x409)*(x415)))+(((x411)*(x418)))+(((x416)*(x418)))+(((IkReal(-1.00000000000000))*(r10)*(x403)*(x417)))+(((IkReal(-1.00000000000000))*(r10)*(x401)*(x404)*(x413)))+(cj3)+(((x407)*(x417)))+(((IkReal(-1.00000000000000))*(x403)*(x405)*(x420)))+(((IkReal(-1.00000000000000))*(x404)*(x424)))+(((r01)*(x406)*(x418)))+(((IkReal(-1.00000000000000))*(r01)*(x408)*(x415))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x403)*(x405)*(x415)))+(((IkReal(-1.00000000000000))*(x400)*(x404)*(x416)))+(((IkReal(-1.00000000000000))*(x407)*(x418)))+(((IkReal(-1.00000000000000))*(x400)*(x404)*(x411)))+(((IkReal(-1.00000000000000))*(x403)*(x414)*(x417)))+(((IkReal(-1.00000000000000))*(x415)*(x426)))+(((x412)*(x418)))+(((IkReal(-1.00000000000000))*(x410)*(x415)))+(((IkReal(-1.00000000000000))*(x404)*(x425)))+(((x409)*(x420))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x418)*(x426)))+(((IkReal(-1.00000000000000))*(x410)*(x418)))+(((IkReal(-1.00000000000000))*(x401)*(x404)*(x416)))+(((IkReal(-1.00000000000000))*(x403)*(x405)*(x418)))+(((IkReal(-1.00000000000000))*(x403)*(x414)*(x420)))+(((r01)*(sj6)*(x417)))+(((IkReal(-1.00000000000000))*(r00)*(x403)*(x417)))+(((IkReal(-1.00000000000000))*(sj3)))+(((x407)*(x415)))+(((IkReal(-1.00000000000000))*(r10)*(x403)*(x415)))+(((IkReal(-1.00000000000000))*(x401)*(x404)*(x411))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst46)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst46)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst46)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst46)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x427=IKsin(j4);
IkReal x428=IKcos(j4);
IkReal x429=((r22)*(sj5));
IkReal x430=((IkReal(1.00000000000000))*(cj6));
IkReal x431=((IkReal(1.00000000000000))*(cj0));
IkReal x432=((cj5)*(r11));
IkReal x433=((cj5)*(cj6));
IkReal x434=((r11)*(sj6));
IkReal x435=((IkReal(1.00000000000000))*(sj6));
IkReal x436=((cj6)*(r00));
IkReal x437=((r12)*(sj5));
IkReal x438=((r02)*(sj5));
IkReal x439=((cj6)*(r10));
IkReal x440=((cj5)*(sj6));
IkReal x441=((cj5)*(r01));
IkReal x442=((sj0)*(x427));
IkReal x443=((r00)*(x440));
IkReal x444=((cj0)*(x427));
IkReal x445=((sj0)*(x428));
IkReal x446=((r20)*(x428));
IkReal x447=((cj0)*(x428));
IkReal x448=((r21)*(x427));
IkReal x449=((r21)*(x428));
IkReal x450=((r20)*(x427));
IkReal x451=((x428)*(x437));
IkReal x452=((r01)*(sj6)*(x428));
IkReal x453=((cj5)*(r10)*(x435));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x430)*(x446)))+(((x433)*(x448)))+(((x427)*(x429)))+(((x440)*(x450)))+(((sj6)*(x449))));
evalcond[1]=((((x433)*(x449)))+(((cj6)*(x450)))+(((x428)*(x429)))+(((IkReal(-1.00000000000000))*(x435)*(x448)))+(((x440)*(x446))));
evalcond[2]=((((r01)*(x433)*(x442)))+(((x439)*(x447)))+(((IkReal(-1.00000000000000))*(r00)*(x430)*(x445)))+(((x442)*(x443)))+(((x438)*(x442)))+(((IkReal(-1.00000000000000))*(r10)*(x427)*(x431)*(x440)))+(((r01)*(sj6)*(x445)))+(((IkReal(-1.00000000000000))*(x430)*(x432)*(x444)))+(((IkReal(-1.00000000000000))*(x428)*(x431)*(x434)))+(((IkReal(-1.00000000000000))*(x427)*(x431)*(x437))));
evalcond[3]=((((r01)*(x433)*(x445)))+(((IkReal(-1.00000000000000))*(r10)*(x428)*(x431)*(x440)))+(((x436)*(x442)))+(((IkReal(-1.00000000000000))*(r01)*(x435)*(x442)))+(((x438)*(x445)))+(((IkReal(-1.00000000000000))*(x431)*(x451)))+(cj3)+(((IkReal(-1.00000000000000))*(x430)*(x432)*(x447)))+(((IkReal(-1.00000000000000))*(r10)*(x430)*(x444)))+(((x443)*(x445)))+(((x434)*(x444))));
evalcond[4]=((((x436)*(x447)))+(((IkReal(-1.00000000000000))*(x430)*(x432)*(x442)))+(((IkReal(-1.00000000000000))*(x427)*(x431)*(x443)))+(((IkReal(-1.00000000000000))*(x434)*(x445)))+(((IkReal(-1.00000000000000))*(x431)*(x452)))+(((IkReal(-1.00000000000000))*(x430)*(x441)*(x444)))+(((IkReal(-1.00000000000000))*(x437)*(x442)))+(((IkReal(-1.00000000000000))*(x427)*(x431)*(x438)))+(((IkReal(-1.00000000000000))*(x442)*(x453)))+(((x439)*(x445))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x437)*(x445)))+(((IkReal(-1.00000000000000))*(x430)*(x432)*(x445)))+(((IkReal(-1.00000000000000))*(x445)*(x453)))+(((IkReal(-1.00000000000000))*(r10)*(x430)*(x442)))+(((IkReal(-1.00000000000000))*(x428)*(x431)*(x443)))+(((IkReal(-1.00000000000000))*(x428)*(x431)*(x438)))+(((IkReal(-1.00000000000000))*(x430)*(x441)*(x447)))+(((x434)*(x442)))+(((IkReal(-1.00000000000000))*(sj3)))+(((r01)*(sj6)*(x444)))+(((IkReal(-1.00000000000000))*(r00)*(x430)*(x444))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x454=((cj5)*(r22));
IkReal x455=((IkReal(0.374290000000000))*(sj5));
IkReal x456=((cj0)*(sj6));
IkReal x457=((cj6)*(r21));
IkReal x458=((IkReal(0.0100000000000000))*(sj5));
IkReal x459=((cj0)*(r02));
IkReal x460=((IkReal(0.0100000000000000))*(cj5));
IkReal x461=((IkReal(1.00000000000000))*(py));
IkReal x462=((r01)*(sj0));
IkReal x463=((r20)*(sj6));
IkReal x464=((r11)*(sj0));
IkReal x465=((IkReal(0.374290000000000))*(cj5));
IkReal x466=((cj0)*(r12));
IkReal x467=((sj0)*(x465));
IkReal x468=((cj6)*(x460));
IkReal x469=((r10)*(sj0)*(sj6));
IkReal x470=((r00)*(sj0)*(sj6));
IkReal x471=((cj0)*(cj6)*(x455));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x454)))+(((sj5)*(x457)))+(((sj5)*(x463))));
evalcond[2]=((((IkReal(-0.374290000000000))*(x454)))+(((x455)*(x457)))+(((IkReal(-1.00000000000000))*(x460)*(x463)))+(((IkReal(-1.00000000000000))*(x457)*(x460)))+(((x455)*(x463)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x458))));
evalcond[3]=((IkReal(-0.0690000000000000))+(((r10)*(x456)*(x460)))+(((x465)*(x466)))+(((IkReal(-1.00000000000000))*(cj0)*(x461)))+(((IkReal(-1.00000000000000))*(x460)*(x470)))+(((IkReal(-1.00000000000000))*(x462)*(x468)))+(((x455)*(x470)))+(((IkReal(-1.00000000000000))*(r10)*(x455)*(x456)))+(((IkReal(-1.00000000000000))*(r02)*(x467)))+(((cj0)*(r11)*(x468)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(r11)*(x471)))+(((cj6)*(x455)*(x462)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x458)))+(((x458)*(x466))));
evalcond[4]=((IkReal(0.433420000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((r00)*(x456)*(x460)))+(((IkReal(-1.00000000000000))*(r00)*(x455)*(x456)))+(((x458)*(x459)))+(((x460)*(x469)))+(((cj0)*(r01)*(x468)))+(((x464)*(x468)))+(((r12)*(sj0)*(x458)))+(((IkReal(-1.00000000000000))*(cj6)*(x455)*(x464)))+(((IkReal(-1.00000000000000))*(x455)*(x469)))+(((r12)*(x467)))+(((IkReal(-1.00000000000000))*(sj0)*(x461)))+(((x459)*(x465)))+(((IkReal(-1.00000000000000))*(r01)*(x471))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x472=((cj5)*(r02));
IkReal x473=((cj0)*(sj5));
IkReal x474=((r10)*(sj6));
IkReal x475=((IkReal(1.00000000000000))*(cj6));
IkReal x476=((sj0)*(sj5));
IkReal x477=((cj5)*(r12));
IkReal x478=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(x476)*(x478)))+(((IkReal(-1.00000000000000))*(cj0)*(x477)))+(((IkReal(-1.00000000000000))*(r01)*(x475)*(x476)))+(((sj0)*(x472)))+(((x473)*(x474)))+(((cj6)*(r11)*(x473))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x473)*(x478)))+(((cj0)*(x472)))+(((IkReal(-1.00000000000000))*(r11)*(x475)*(x476)))+(((IkReal(-1.00000000000000))*(r01)*(x473)*(x475)))+(((IkReal(-1.00000000000000))*(x474)*(x476)))+(((sj0)*(x477))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x476)*(x478)))+(((IkReal(-1.00000000000000))*(cj0)*(x477)))+(((IkReal(-1.00000000000000))*(r01)*(x475)*(x476)))+(((sj0)*(x472)))+(((x473)*(x474)))+(((cj6)*(r11)*(x473)))))+IKsqr(((((IkReal(-1.00000000000000))*(x473)*(x478)))+(((cj0)*(x472)))+(((IkReal(-1.00000000000000))*(r11)*(x475)*(x476)))+(((IkReal(-1.00000000000000))*(r01)*(x473)*(x475)))+(((IkReal(-1.00000000000000))*(x474)*(x476)))+(((sj0)*(x477)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x476)*(x478)))+(((IkReal(-1.00000000000000))*(cj0)*(x477)))+(((IkReal(-1.00000000000000))*(r01)*(x475)*(x476)))+(((sj0)*(x472)))+(((x473)*(x474)))+(((cj6)*(r11)*(x473)))), ((((IkReal(-1.00000000000000))*(x473)*(x478)))+(((cj0)*(x472)))+(((IkReal(-1.00000000000000))*(r11)*(x475)*(x476)))+(((IkReal(-1.00000000000000))*(r01)*(x473)*(x475)))+(((IkReal(-1.00000000000000))*(x474)*(x476)))+(((sj0)*(x477)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x479=((cj0)*(cj5));
IkReal x480=((IkReal(1.00000000000000))*(cj0));
IkReal x481=((cj6)*(r11));
IkReal x482=((r10)*(sj6));
IkReal x483=((cj5)*(sj0));
IkReal x484=((r00)*(sj5)*(sj6));
IkReal x485=((cj6)*(r01)*(sj5));
IkReal x486=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((sj0)*(x484)))+(((r12)*(x479)))+(IKsin(j3))+(((IkReal(-1.00000000000000))*(sj5)*(x480)*(x481)))+(((IkReal(-1.00000000000000))*(sj5)*(x480)*(x482)))+(((IkReal(-1.00000000000000))*(r02)*(x483)))+(((sj0)*(x485))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x480)*(x484)))+(((r12)*(x483)))+(((r02)*(x479)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(x482)*(x486)))+(((IkReal(-1.00000000000000))*(x481)*(x486)))+(((IkReal(-1.00000000000000))*(x480)*(x485))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst50;
IkReal x487=(r21)*(r21);
IkReal x488=(cj5)*(cj5);
IkReal x489=(sj6)*(sj6);
IkReal x490=(cj6)*(cj6);
IkReal x491=(r20)*(r20);
IkReal x492=((cj6)*(r21));
IkReal x493=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x494=((cj5)*(r22)*(sj5));
IkReal x495=((IkReal(1.00000000000000))*(x489));
IkReal x496=((IkReal(1.00000000000000))*(x490));
gconst50=IKsign(((((IkReal(-1.00000000000000))*(x487)*(x488)*(x496)))+(((IkReal(-1.00000000000000))*(x488)*(x492)*(x493)))+(((x492)*(x493)))+(((IkReal(-1.00000000000000))*(x491)*(x496)))+(((IkReal(-2.00000000000000))*(x492)*(x494)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x488)*(x491)*(x495)))+(((IkReal(-1.00000000000000))*(x487)*(x495)))+(((IkReal(-1.00000000000000))*(x493)*(x494)))));
IkReal x497=(r21)*(r21);
IkReal x498=(cj5)*(cj5);
IkReal x499=(sj6)*(sj6);
IkReal x500=(cj6)*(cj6);
IkReal x501=(r20)*(r20);
IkReal x502=((cj6)*(r21));
IkReal x503=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x504=((cj5)*(r22)*(sj5));
IkReal x505=((IkReal(1.00000000000000))*(x499));
IkReal x506=((IkReal(1.00000000000000))*(x500));
dummyeval[0]=((((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x497)*(x505)))+(((IkReal(-1.00000000000000))*(x503)*(x504)))+(((IkReal(-1.00000000000000))*(x498)*(x502)*(x503)))+(((IkReal(-1.00000000000000))*(x498)*(x501)*(x505)))+(((x502)*(x503)))+(((IkReal(-1.00000000000000))*(x501)*(x506)))+(((IkReal(-2.00000000000000))*(x502)*(x504)))+(((IkReal(-1.00000000000000))*(x497)*(x498)*(x506))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst51;
IkReal x507=(cj6)*(cj6);
IkReal x508=(sj6)*(sj6);
IkReal x509=((IkReal(1.00000000000000))*(r01));
IkReal x510=((sj0)*(sj5));
IkReal x511=((cj6)*(r22));
IkReal x512=((r21)*(sj6));
IkReal x513=((r00)*(r21));
IkReal x514=((cj0)*(sj5));
IkReal x515=((cj6)*(r20));
IkReal x516=((r22)*(sj6));
IkReal x517=((cj0)*(cj5));
IkReal x518=((IkReal(1.00000000000000))*(r10));
IkReal x519=((cj5)*(sj0));
IkReal x520=((r20)*(x508));
IkReal x521=((x507)*(x519));
gconst51=IKsign(((((r11)*(x514)*(x516)))+(((IkReal(-1.00000000000000))*(r20)*(x509)*(x521)))+(((IkReal(-1.00000000000000))*(r12)*(x512)*(x514)))+(((r00)*(x510)*(x511)))+(((IkReal(-1.00000000000000))*(r21)*(x508)*(x517)*(x518)))+(((x513)*(x521)))+(((x508)*(x513)*(x519)))+(((IkReal(-1.00000000000000))*(x509)*(x510)*(x516)))+(((r11)*(x517)*(x520)))+(((r11)*(r20)*(x507)*(x517)))+(((IkReal(-1.00000000000000))*(r21)*(x507)*(x517)*(x518)))+(((r02)*(x510)*(x512)))+(((IkReal(-1.00000000000000))*(x511)*(x514)*(x518)))+(((IkReal(-1.00000000000000))*(x509)*(x519)*(x520)))+(((IkReal(-1.00000000000000))*(r02)*(x510)*(x515)))+(((r12)*(x514)*(x515)))));
IkReal x522=(cj6)*(cj6);
IkReal x523=(sj6)*(sj6);
IkReal x524=((IkReal(1.00000000000000))*(r01));
IkReal x525=((sj0)*(sj5));
IkReal x526=((cj6)*(r22));
IkReal x527=((r21)*(sj6));
IkReal x528=((r00)*(r21));
IkReal x529=((cj0)*(sj5));
IkReal x530=((cj6)*(r20));
IkReal x531=((r22)*(sj6));
IkReal x532=((cj0)*(cj5));
IkReal x533=((IkReal(1.00000000000000))*(r10));
IkReal x534=((cj5)*(sj0));
IkReal x535=((r20)*(x523));
IkReal x536=((x522)*(x534));
dummyeval[0]=((((r11)*(x529)*(x531)))+(((r12)*(x529)*(x530)))+(((r00)*(x525)*(x526)))+(((r02)*(x525)*(x527)))+(((IkReal(-1.00000000000000))*(r21)*(x522)*(x532)*(x533)))+(((IkReal(-1.00000000000000))*(r20)*(x524)*(x536)))+(((IkReal(-1.00000000000000))*(x526)*(x529)*(x533)))+(((IkReal(-1.00000000000000))*(r21)*(x523)*(x532)*(x533)))+(((IkReal(-1.00000000000000))*(r02)*(x525)*(x530)))+(((IkReal(-1.00000000000000))*(r12)*(x527)*(x529)))+(((IkReal(-1.00000000000000))*(x524)*(x525)*(x531)))+(((r11)*(x532)*(x535)))+(((x528)*(x536)))+(((r11)*(r20)*(x522)*(x532)))+(((IkReal(-1.00000000000000))*(x524)*(x534)*(x535)))+(((x523)*(x528)*(x534))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x537=((sj0)*(sj6));
IkReal x538=((cj0)*(r10));
IkReal x539=((IkReal(1.00000000000000))*(cj5));
IkReal x540=((cj6)*(sj0));
IkReal x541=((cj0)*(r11));
if( IKabs(((gconst51)*(((((r01)*(x537)))+(((IkReal(-1.00000000000000))*(r00)*(x540)))+(((IkReal(-1.00000000000000))*(sj6)*(x541)))+(((cj6)*(x538))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst51)*(((((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x537)*(x539)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(cj6)*(x541)))+(((cj5)*(sj6)*(x538)))+(((IkReal(-1.00000000000000))*(r01)*(x539)*(x540))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst51)*(((((r01)*(x537)))+(((IkReal(-1.00000000000000))*(r00)*(x540)))+(((IkReal(-1.00000000000000))*(sj6)*(x541)))+(((cj6)*(x538)))))), ((gconst51)*(((((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x537)*(x539)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(cj6)*(x541)))+(((cj5)*(sj6)*(x538)))+(((IkReal(-1.00000000000000))*(r01)*(x539)*(x540)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x542=IKsin(j4);
IkReal x543=IKcos(j4);
IkReal x544=((r22)*(sj5));
IkReal x545=((IkReal(1.00000000000000))*(cj6));
IkReal x546=((IkReal(1.00000000000000))*(cj0));
IkReal x547=((cj5)*(r11));
IkReal x548=((cj5)*(cj6));
IkReal x549=((r11)*(sj6));
IkReal x550=((IkReal(1.00000000000000))*(sj6));
IkReal x551=((cj6)*(r00));
IkReal x552=((r12)*(sj5));
IkReal x553=((r02)*(sj5));
IkReal x554=((cj6)*(r10));
IkReal x555=((cj5)*(sj6));
IkReal x556=((cj5)*(r01));
IkReal x557=((sj0)*(x542));
IkReal x558=((r00)*(x555));
IkReal x559=((cj0)*(x542));
IkReal x560=((sj0)*(x543));
IkReal x561=((r20)*(x543));
IkReal x562=((cj0)*(x543));
IkReal x563=((r21)*(x542));
IkReal x564=((r21)*(x543));
IkReal x565=((r20)*(x542));
IkReal x566=((x543)*(x552));
IkReal x567=((r01)*(sj6)*(x543));
IkReal x568=((cj5)*(r10)*(x550));
evalcond[0]=((IkReal(1.00000000000000))+(((sj6)*(x564)))+(((x542)*(x544)))+(((IkReal(-1.00000000000000))*(x545)*(x561)))+(((x548)*(x563)))+(((x555)*(x565))));
evalcond[1]=((((cj6)*(x565)))+(((x555)*(x561)))+(((IkReal(-1.00000000000000))*(x550)*(x563)))+(((x548)*(x564)))+(((x543)*(x544))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x542)*(x546)*(x555)))+(((IkReal(-1.00000000000000))*(x542)*(x546)*(x552)))+(((r01)*(x548)*(x557)))+(((IkReal(-1.00000000000000))*(x543)*(x546)*(x549)))+(((IkReal(-1.00000000000000))*(r00)*(x545)*(x560)))+(((IkReal(-1.00000000000000))*(x545)*(x547)*(x559)))+(((r01)*(sj6)*(x560)))+(((x557)*(x558)))+(((x554)*(x562)))+(((x553)*(x557))));
evalcond[3]=((((r01)*(x548)*(x560)))+(((x553)*(x560)))+(((x549)*(x559)))+(((IkReal(-1.00000000000000))*(r10)*(x545)*(x559)))+(((IkReal(-1.00000000000000))*(r01)*(x550)*(x557)))+(((IkReal(-1.00000000000000))*(r10)*(x543)*(x546)*(x555)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x545)*(x547)*(x562)))+(((x551)*(x557)))+(((IkReal(-1.00000000000000))*(x546)*(x566)))+(((x558)*(x560))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x542)*(x546)*(x553)))+(((IkReal(-1.00000000000000))*(x542)*(x546)*(x558)))+(((IkReal(-1.00000000000000))*(x546)*(x567)))+(((IkReal(-1.00000000000000))*(x557)*(x568)))+(((IkReal(-1.00000000000000))*(x545)*(x547)*(x557)))+(((IkReal(-1.00000000000000))*(x549)*(x560)))+(((IkReal(-1.00000000000000))*(x545)*(x556)*(x559)))+(((x554)*(x560)))+(((x551)*(x562)))+(((IkReal(-1.00000000000000))*(x552)*(x557))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x560)*(x568)))+(((r01)*(sj6)*(x559)))+(((IkReal(-1.00000000000000))*(r00)*(x545)*(x559)))+(((IkReal(-1.00000000000000))*(x545)*(x556)*(x562)))+(((IkReal(-1.00000000000000))*(r10)*(x545)*(x557)))+(((IkReal(-1.00000000000000))*(x545)*(x547)*(x560)))+(((IkReal(-1.00000000000000))*(x543)*(x546)*(x558)))+(((IkReal(-1.00000000000000))*(x552)*(x560)))+(((IkReal(-1.00000000000000))*(x543)*(x546)*(x553)))+(((IkReal(-1.00000000000000))*(sj3)))+(((x549)*(x557))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst50)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst50)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst50)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst50)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x569=IKsin(j4);
IkReal x570=IKcos(j4);
IkReal x571=((r22)*(sj5));
IkReal x572=((IkReal(1.00000000000000))*(cj6));
IkReal x573=((IkReal(1.00000000000000))*(cj0));
IkReal x574=((cj5)*(r11));
IkReal x575=((cj5)*(cj6));
IkReal x576=((r11)*(sj6));
IkReal x577=((IkReal(1.00000000000000))*(sj6));
IkReal x578=((cj6)*(r00));
IkReal x579=((r12)*(sj5));
IkReal x580=((r02)*(sj5));
IkReal x581=((cj6)*(r10));
IkReal x582=((cj5)*(sj6));
IkReal x583=((cj5)*(r01));
IkReal x584=((sj0)*(x569));
IkReal x585=((r00)*(x582));
IkReal x586=((cj0)*(x569));
IkReal x587=((sj0)*(x570));
IkReal x588=((r20)*(x570));
IkReal x589=((cj0)*(x570));
IkReal x590=((r21)*(x569));
IkReal x591=((r21)*(x570));
IkReal x592=((r20)*(x569));
IkReal x593=((x570)*(x579));
IkReal x594=((r01)*(sj6)*(x570));
IkReal x595=((cj5)*(r10)*(x577));
evalcond[0]=((IkReal(1.00000000000000))+(((sj6)*(x591)))+(((x582)*(x592)))+(((x575)*(x590)))+(((IkReal(-1.00000000000000))*(x572)*(x588)))+(((x569)*(x571))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x577)*(x590)))+(((x575)*(x591)))+(((x570)*(x571)))+(((cj6)*(x592)))+(((x582)*(x588))));
evalcond[2]=((((r01)*(sj6)*(x587)))+(((IkReal(-1.00000000000000))*(x572)*(x574)*(x586)))+(((x584)*(x585)))+(((IkReal(-1.00000000000000))*(r10)*(x569)*(x573)*(x582)))+(((IkReal(-1.00000000000000))*(r00)*(x572)*(x587)))+(((r01)*(x575)*(x584)))+(((IkReal(-1.00000000000000))*(x570)*(x573)*(x576)))+(((x580)*(x584)))+(((IkReal(-1.00000000000000))*(x569)*(x573)*(x579)))+(((x581)*(x589))));
evalcond[3]=((((x580)*(x587)))+(((IkReal(-1.00000000000000))*(r01)*(x577)*(x584)))+(((r01)*(x575)*(x587)))+(((x585)*(x587)))+(((IkReal(-1.00000000000000))*(x572)*(x574)*(x589)))+(((IkReal(-1.00000000000000))*(x573)*(x593)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(r10)*(x572)*(x586)))+(((x578)*(x584)))+(((IkReal(-1.00000000000000))*(r10)*(x570)*(x573)*(x582)))+(((x576)*(x586))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x572)*(x583)*(x586)))+(((x578)*(x589)))+(((x581)*(x587)))+(((IkReal(-1.00000000000000))*(x573)*(x594)))+(((IkReal(-1.00000000000000))*(x584)*(x595)))+(((IkReal(-1.00000000000000))*(x569)*(x573)*(x580)))+(((IkReal(-1.00000000000000))*(x579)*(x584)))+(((IkReal(-1.00000000000000))*(x569)*(x573)*(x585)))+(((IkReal(-1.00000000000000))*(x576)*(x587)))+(((IkReal(-1.00000000000000))*(x572)*(x574)*(x584))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x572)*(x583)*(x589)))+(((IkReal(-1.00000000000000))*(r00)*(x572)*(x586)))+(((IkReal(-1.00000000000000))*(x587)*(x595)))+(((IkReal(-1.00000000000000))*(x572)*(x574)*(x587)))+(((IkReal(-1.00000000000000))*(x570)*(x573)*(x580)))+(((IkReal(-1.00000000000000))*(x579)*(x587)))+(((IkReal(-1.00000000000000))*(x570)*(x573)*(x585)))+(((r01)*(sj6)*(x586)))+(((x576)*(x584)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(r10)*(x572)*(x584))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x596=((sj5)*(sj6));
IkReal x597=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj6)*(r21)*(sj5)))+(((r20)*(x596)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x597)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x596)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x597)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x596))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj6)*(r21)*(sj5)))+(((r20)*(x596)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))))+IKsqr(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x597)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x596)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x597)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x596)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj6)*(r21)*(sj5)))+(((r20)*(x596)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))), ((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x597)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x596)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x597)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x596)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x598=IKsin(j3);
IkReal x599=((sj5)*(sj6));
IkReal x600=((cj0)*(cj5));
IkReal x601=((IkReal(1.00000000000000))*(cj0));
IkReal x602=((IkReal(1.00000000000000))*(sj0));
IkReal x603=((IkReal(1.00000000000000))*(x598));
IkReal x604=((cj6)*(r01)*(sj5));
IkReal x605=((cj6)*(r11)*(sj5));
evalcond[0]=((((r20)*(x599)))+(((IkReal(-1.00000000000000))*(cj2)*(x603)))+(((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj5)*(r02)*(x602)))+(((r00)*(sj0)*(x599)))+(((IkReal(-1.00000000000000))*(sj2)*(x603)))+(((IkReal(-1.00000000000000))*(x601)*(x605)))+(((IkReal(-1.00000000000000))*(r10)*(x599)*(x601)))+(((sj0)*(x604)))+(((r12)*(x600))));
evalcond[2]=((((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(r10)*(x599)*(x602)))+(((IkReal(-1.00000000000000))*(r00)*(x599)*(x601)))+(((r02)*(x600)))+(((IkReal(-1.00000000000000))*(x602)*(x605)))+(((IkReal(-1.00000000000000))*(x601)*(x604))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst41;
IkReal x606=(r21)*(r21);
IkReal x607=(cj5)*(cj5);
IkReal x608=(sj6)*(sj6);
IkReal x609=(cj6)*(cj6);
IkReal x610=(r20)*(r20);
IkReal x611=((cj6)*(r21));
IkReal x612=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x613=((cj5)*(r22)*(sj5));
IkReal x614=((IkReal(1.00000000000000))*(x608));
IkReal x615=((IkReal(1.00000000000000))*(x609));
gconst41=IKsign(((((IkReal(-1.00000000000000))*(x606)*(x614)))+(((IkReal(-1.00000000000000))*(x610)*(x615)))+(((IkReal(-1.00000000000000))*(x607)*(x610)*(x614)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x612)*(x613)))+(((IkReal(-2.00000000000000))*(x611)*(x613)))+(((IkReal(-1.00000000000000))*(x606)*(x607)*(x615)))+(((IkReal(-1.00000000000000))*(x607)*(x611)*(x612)))+(((x611)*(x612)))));
IkReal x616=(r21)*(r21);
IkReal x617=(cj5)*(cj5);
IkReal x618=(sj6)*(sj6);
IkReal x619=(cj6)*(cj6);
IkReal x620=(r20)*(r20);
IkReal x621=((cj6)*(r21));
IkReal x622=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x623=((cj5)*(r22)*(sj5));
IkReal x624=((IkReal(1.00000000000000))*(x618));
IkReal x625=((IkReal(1.00000000000000))*(x619));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x616)*(x617)*(x625)))+(((IkReal(-1.00000000000000))*(x616)*(x624)))+(((IkReal(-1.00000000000000))*(x620)*(x625)))+(((IkReal(-2.00000000000000))*(x621)*(x623)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((x621)*(x622)))+(((IkReal(-1.00000000000000))*(x622)*(x623)))+(((IkReal(-1.00000000000000))*(x617)*(x620)*(x624)))+(((IkReal(-1.00000000000000))*(x617)*(x621)*(x622))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst42;
IkReal x626=(cj6)*(cj6);
IkReal x627=(sj6)*(sj6);
IkReal x628=((IkReal(1.00000000000000))*(r01));
IkReal x629=((sj0)*(sj5));
IkReal x630=((cj6)*(r22));
IkReal x631=((r21)*(sj6));
IkReal x632=((r00)*(r21));
IkReal x633=((cj0)*(sj5));
IkReal x634=((cj6)*(r20));
IkReal x635=((r22)*(sj6));
IkReal x636=((cj0)*(cj5));
IkReal x637=((IkReal(1.00000000000000))*(r10));
IkReal x638=((cj5)*(sj0));
IkReal x639=((r20)*(x627));
IkReal x640=((x626)*(x638));
gconst42=IKsign(((((r00)*(x629)*(x630)))+(((r02)*(x629)*(x631)))+(((IkReal(-1.00000000000000))*(r12)*(x631)*(x633)))+(((IkReal(-1.00000000000000))*(x628)*(x638)*(x639)))+(((r12)*(x633)*(x634)))+(((IkReal(-1.00000000000000))*(x630)*(x633)*(x637)))+(((IkReal(-1.00000000000000))*(r21)*(x626)*(x636)*(x637)))+(((IkReal(-1.00000000000000))*(r21)*(x627)*(x636)*(x637)))+(((r11)*(x633)*(x635)))+(((IkReal(-1.00000000000000))*(x628)*(x629)*(x635)))+(((IkReal(-1.00000000000000))*(r02)*(x629)*(x634)))+(((r11)*(r20)*(x626)*(x636)))+(((IkReal(-1.00000000000000))*(r20)*(x628)*(x640)))+(((x632)*(x640)))+(((r11)*(x636)*(x639)))+(((x627)*(x632)*(x638)))));
IkReal x641=(cj6)*(cj6);
IkReal x642=(sj6)*(sj6);
IkReal x643=((IkReal(1.00000000000000))*(r01));
IkReal x644=((sj0)*(sj5));
IkReal x645=((cj6)*(r22));
IkReal x646=((r21)*(sj6));
IkReal x647=((r00)*(r21));
IkReal x648=((cj0)*(sj5));
IkReal x649=((cj6)*(r20));
IkReal x650=((r22)*(sj6));
IkReal x651=((cj0)*(cj5));
IkReal x652=((IkReal(1.00000000000000))*(r10));
IkReal x653=((cj5)*(sj0));
IkReal x654=((r20)*(x642));
IkReal x655=((x641)*(x653));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r02)*(x644)*(x649)))+(((IkReal(-1.00000000000000))*(r21)*(x642)*(x651)*(x652)))+(((r02)*(x644)*(x646)))+(((x642)*(x647)*(x653)))+(((IkReal(-1.00000000000000))*(x643)*(x644)*(x650)))+(((IkReal(-1.00000000000000))*(r20)*(x643)*(x655)))+(((IkReal(-1.00000000000000))*(x643)*(x653)*(x654)))+(((IkReal(-1.00000000000000))*(x645)*(x648)*(x652)))+(((r11)*(r20)*(x641)*(x651)))+(((r00)*(x644)*(x645)))+(((x647)*(x655)))+(((IkReal(-1.00000000000000))*(r21)*(x641)*(x651)*(x652)))+(((IkReal(-1.00000000000000))*(r12)*(x646)*(x648)))+(((r11)*(x648)*(x650)))+(((r12)*(x648)*(x649)))+(((r11)*(x651)*(x654))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x656=((r01)*(sj0));
IkReal x657=((cj2)*(sj6));
IkReal x658=((IkReal(1.00000000000000))*(cj0));
IkReal x659=((r10)*(sj2));
IkReal x660=((sj2)*(sj5));
IkReal x661=((cj5)*(sj6));
IkReal x662=((sj2)*(sj6));
IkReal x663=((cj2)*(cj6));
IkReal x664=((cj5)*(cj6)*(sj2));
IkReal x665=((r00)*(sj0)*(sj2));
if( IKabs(((gconst42)*(((((cj6)*(x665)))+(((r20)*(x663)))+(((cj0)*(r11)*(x662)))+(((IkReal(-1.00000000000000))*(r21)*(x657)))+(((IkReal(-1.00000000000000))*(cj6)*(x658)*(x659)))+(((IkReal(-1.00000000000000))*(x656)*(x662))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst42)*(((((cj2)*(r22)*(sj5)))+(((x656)*(x664)))+(((x661)*(x665)))+(((IkReal(-1.00000000000000))*(x658)*(x659)*(x661)))+(((cj5)*(r21)*(x663)))+(((IkReal(-1.00000000000000))*(r11)*(x658)*(x664)))+(((r02)*(sj0)*(x660)))+(((cj5)*(r20)*(x657)))+(((IkReal(-1.00000000000000))*(r12)*(x658)*(x660))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst42)*(((((cj6)*(x665)))+(((r20)*(x663)))+(((cj0)*(r11)*(x662)))+(((IkReal(-1.00000000000000))*(r21)*(x657)))+(((IkReal(-1.00000000000000))*(cj6)*(x658)*(x659)))+(((IkReal(-1.00000000000000))*(x656)*(x662)))))), ((gconst42)*(((((cj2)*(r22)*(sj5)))+(((x656)*(x664)))+(((x661)*(x665)))+(((IkReal(-1.00000000000000))*(x658)*(x659)*(x661)))+(((cj5)*(r21)*(x663)))+(((IkReal(-1.00000000000000))*(r11)*(x658)*(x664)))+(((r02)*(sj0)*(x660)))+(((cj5)*(r20)*(x657)))+(((IkReal(-1.00000000000000))*(r12)*(x658)*(x660)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x666=IKsin(j4);
IkReal x667=IKcos(j4);
IkReal x668=((r00)*(sj6));
IkReal x669=((IkReal(1.00000000000000))*(r12));
IkReal x670=((IkReal(1.00000000000000))*(cj6));
IkReal x671=((cj6)*(r01));
IkReal x672=((r11)*(sj6));
IkReal x673=((r01)*(sj6));
IkReal x674=((IkReal(1.00000000000000))*(cj5));
IkReal x675=((IkReal(1.00000000000000))*(sj6));
IkReal x676=((cj5)*(sj6));
IkReal x677=((cj5)*(r11));
IkReal x678=((cj6)*(r00));
IkReal x679=((cj5)*(cj6));
IkReal x680=((r02)*(sj5));
IkReal x681=((cj6)*(r10));
IkReal x682=((r10)*(sj6));
IkReal x683=((cj5)*(r01));
IkReal x684=((sj5)*(x666));
IkReal x685=((cj0)*(x667));
IkReal x686=((cj0)*(x666));
IkReal x687=((sj0)*(x667));
IkReal x688=((sj0)*(x666));
IkReal x689=((r20)*(x667));
IkReal x690=((r21)*(x666));
IkReal x691=((r21)*(x667));
IkReal x692=((r20)*(x666));
IkReal x693=((cj5)*(x688));
evalcond[0]=((((sj6)*(x691)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x670)*(x689)))+(((r22)*(x684)))+(((x679)*(x690)))+(((x676)*(x692))));
evalcond[1]=((((cj6)*(x692)))+(((x679)*(x691)))+(((cj2)*(cj3)))+(((r22)*(sj5)*(x667)))+(((x676)*(x689)))+(((IkReal(-1.00000000000000))*(x675)*(x690))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj0)*(x669)*(x684)))+(((x681)*(x685)))+(((x680)*(x688)))+(((x668)*(x693)))+(((IkReal(-1.00000000000000))*(r00)*(x670)*(x687)))+(((x673)*(x687)))+(((IkReal(-1.00000000000000))*(x670)*(x677)*(x686)))+(((x671)*(x693)))+(cj2)+(((IkReal(-1.00000000000000))*(x674)*(x682)*(x686)))+(((IkReal(-1.00000000000000))*(x672)*(x685))));
evalcond[3]=((((x680)*(x687)))+(((cj5)*(x668)*(x687)))+(((IkReal(-1.00000000000000))*(x673)*(x688)))+(((IkReal(-1.00000000000000))*(x670)*(x677)*(x685)))+(((IkReal(-1.00000000000000))*(r10)*(x670)*(x686)))+(((x678)*(x688)))+(((x672)*(x686)))+(((IkReal(-1.00000000000000))*(sj5)*(x669)*(x685)))+(((cj5)*(x671)*(x687)))+(((IkReal(-1.00000000000000))*(x674)*(x682)*(x685)))+(((cj3)*(sj2))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x680)*(x686)))+(((IkReal(-1.00000000000000))*(x668)*(x674)*(x686)))+(((IkReal(-1.00000000000000))*(x670)*(x677)*(x688)))+(((IkReal(-1.00000000000000))*(x670)*(x683)*(x686)))+(((IkReal(-1.00000000000000))*(sj0)*(x669)*(x684)))+(((IkReal(-1.00000000000000))*(x672)*(x687)))+(((x681)*(x687)))+(((IkReal(-1.00000000000000))*(x674)*(x682)*(x688)))+(((IkReal(-1.00000000000000))*(x673)*(x685)))+(((x678)*(x685))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x674)*(x682)*(x687)))+(((IkReal(-1.00000000000000))*(x680)*(x685)))+(((IkReal(-1.00000000000000))*(sj5)*(x669)*(x687)))+(((x673)*(x686)))+(((IkReal(-1.00000000000000))*(r00)*(x670)*(x686)))+(((IkReal(-1.00000000000000))*(x670)*(x677)*(x687)))+(((IkReal(-1.00000000000000))*(x668)*(x674)*(x685)))+(((x672)*(x688)))+(((IkReal(-1.00000000000000))*(x670)*(x683)*(x685)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(r10)*(x670)*(x688))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x694=((IkReal(1.00000000000000))*(sj2));
IkReal x695=((r22)*(sj5));
IkReal x696=((cj5)*(sj6));
IkReal x697=((cj2)*(cj3));
IkReal x698=((r21)*(sj6));
IkReal x699=((r20)*(x697));
IkReal x700=((cj5)*(cj6)*(r21));
if( IKabs(((gconst41)*(((((cj6)*(x699)))+(((IkReal(-1.00000000000000))*(x697)*(x698)))+(((IkReal(-1.00000000000000))*(r20)*(x694)*(x696)))+(((IkReal(-1.00000000000000))*(x694)*(x695)))+(((IkReal(-1.00000000000000))*(x694)*(x700))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst41)*(((((x697)*(x700)))+(((cj6)*(r20)*(sj2)))+(((IkReal(-1.00000000000000))*(x694)*(x698)))+(((x696)*(x699)))+(((x695)*(x697))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst41)*(((((cj6)*(x699)))+(((IkReal(-1.00000000000000))*(x697)*(x698)))+(((IkReal(-1.00000000000000))*(r20)*(x694)*(x696)))+(((IkReal(-1.00000000000000))*(x694)*(x695)))+(((IkReal(-1.00000000000000))*(x694)*(x700)))))), ((gconst41)*(((((x697)*(x700)))+(((cj6)*(r20)*(sj2)))+(((IkReal(-1.00000000000000))*(x694)*(x698)))+(((x696)*(x699)))+(((x695)*(x697)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x701=IKsin(j4);
IkReal x702=IKcos(j4);
IkReal x703=((r00)*(sj6));
IkReal x704=((IkReal(1.00000000000000))*(r12));
IkReal x705=((IkReal(1.00000000000000))*(cj6));
IkReal x706=((cj6)*(r01));
IkReal x707=((r11)*(sj6));
IkReal x708=((r01)*(sj6));
IkReal x709=((IkReal(1.00000000000000))*(cj5));
IkReal x710=((IkReal(1.00000000000000))*(sj6));
IkReal x711=((cj5)*(sj6));
IkReal x712=((cj5)*(r11));
IkReal x713=((cj6)*(r00));
IkReal x714=((cj5)*(cj6));
IkReal x715=((r02)*(sj5));
IkReal x716=((cj6)*(r10));
IkReal x717=((r10)*(sj6));
IkReal x718=((cj5)*(r01));
IkReal x719=((sj5)*(x701));
IkReal x720=((cj0)*(x702));
IkReal x721=((cj0)*(x701));
IkReal x722=((sj0)*(x702));
IkReal x723=((sj0)*(x701));
IkReal x724=((r20)*(x702));
IkReal x725=((r21)*(x701));
IkReal x726=((r21)*(x702));
IkReal x727=((r20)*(x701));
IkReal x728=((cj5)*(x723));
evalcond[0]=((((sj6)*(x726)))+(((r22)*(x719)))+(((IkReal(-1.00000000000000))*(sj2)))+(((x711)*(x727)))+(((x714)*(x725)))+(((IkReal(-1.00000000000000))*(x705)*(x724))));
evalcond[1]=((((x714)*(x726)))+(((cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(x710)*(x725)))+(((r22)*(sj5)*(x702)))+(((x711)*(x724)))+(((cj6)*(x727))));
evalcond[2]=((((x715)*(x723)))+(((x703)*(x728)))+(((x708)*(x722)))+(((x706)*(x728)))+(((x716)*(x720)))+(cj2)+(((IkReal(-1.00000000000000))*(x705)*(x712)*(x721)))+(((IkReal(-1.00000000000000))*(cj0)*(x704)*(x719)))+(((IkReal(-1.00000000000000))*(r00)*(x705)*(x722)))+(((IkReal(-1.00000000000000))*(x709)*(x717)*(x721)))+(((IkReal(-1.00000000000000))*(x707)*(x720))));
evalcond[3]=((((x715)*(x722)))+(((IkReal(-1.00000000000000))*(r10)*(x705)*(x721)))+(((x707)*(x721)))+(((cj5)*(x706)*(x722)))+(((cj5)*(x703)*(x722)))+(((IkReal(-1.00000000000000))*(x709)*(x717)*(x720)))+(((x713)*(x723)))+(((IkReal(-1.00000000000000))*(x705)*(x712)*(x720)))+(((cj3)*(sj2)))+(((IkReal(-1.00000000000000))*(sj5)*(x704)*(x720)))+(((IkReal(-1.00000000000000))*(x708)*(x723))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x709)*(x717)*(x723)))+(((IkReal(-1.00000000000000))*(x703)*(x709)*(x721)))+(((IkReal(-1.00000000000000))*(sj0)*(x704)*(x719)))+(((IkReal(-1.00000000000000))*(x715)*(x721)))+(((IkReal(-1.00000000000000))*(x708)*(x720)))+(((x713)*(x720)))+(((x716)*(x722)))+(((IkReal(-1.00000000000000))*(x705)*(x718)*(x721)))+(((IkReal(-1.00000000000000))*(x707)*(x722)))+(((IkReal(-1.00000000000000))*(x705)*(x712)*(x723))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x715)*(x720)))+(((IkReal(-1.00000000000000))*(r00)*(x705)*(x721)))+(((IkReal(-1.00000000000000))*(r10)*(x705)*(x723)))+(((x707)*(x723)))+(((IkReal(-1.00000000000000))*(x705)*(x718)*(x720)))+(((IkReal(-1.00000000000000))*(x703)*(x709)*(x720)))+(((IkReal(-1.00000000000000))*(x705)*(x712)*(x722)))+(((IkReal(-1.00000000000000))*(x709)*(x717)*(x722)))+(((IkReal(-1.00000000000000))*(sj3)))+(((x708)*(x721)))+(((IkReal(-1.00000000000000))*(sj5)*(x704)*(x722))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x729=((r01)*(sj0));
IkReal x730=((IkReal(1.00000000000000))*(cj0));
IkReal x731=((r10)*(sj2));
IkReal x732=((sj2)*(sj5));
IkReal x733=((IkReal(1.00000000000000))*(sj6));
IkReal x734=((cj2)*(r21));
IkReal x735=((cj5)*(sj6));
IkReal x736=((cj2)*(r20));
IkReal x737=((cj5)*(cj6)*(sj2));
IkReal x738=((r00)*(sj0)*(sj2));
if( IKabs(((gconst39)*(((((cj6)*(x736)))+(((cj6)*(x738)))+(((cj0)*(r11)*(sj2)*(sj6)))+(((IkReal(-1.00000000000000))*(x733)*(x734)))+(((IkReal(-1.00000000000000))*(sj2)*(x729)*(x733)))+(((IkReal(-1.00000000000000))*(cj6)*(x730)*(x731))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst39)*(((((cj2)*(r22)*(sj5)))+(((x729)*(x737)))+(((IkReal(-1.00000000000000))*(r12)*(x730)*(x732)))+(((x735)*(x738)))+(((IkReal(-1.00000000000000))*(r11)*(x730)*(x737)))+(((x735)*(x736)))+(((r02)*(sj0)*(x732)))+(((IkReal(-1.00000000000000))*(x730)*(x731)*(x735)))+(((cj5)*(cj6)*(x734))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst39)*(((((cj6)*(x736)))+(((cj6)*(x738)))+(((cj0)*(r11)*(sj2)*(sj6)))+(((IkReal(-1.00000000000000))*(x733)*(x734)))+(((IkReal(-1.00000000000000))*(sj2)*(x729)*(x733)))+(((IkReal(-1.00000000000000))*(cj6)*(x730)*(x731)))))), ((gconst39)*(((((cj2)*(r22)*(sj5)))+(((x729)*(x737)))+(((IkReal(-1.00000000000000))*(r12)*(x730)*(x732)))+(((x735)*(x738)))+(((IkReal(-1.00000000000000))*(r11)*(x730)*(x737)))+(((x735)*(x736)))+(((r02)*(sj0)*(x732)))+(((IkReal(-1.00000000000000))*(x730)*(x731)*(x735)))+(((cj5)*(cj6)*(x734)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x739=IKsin(j4);
IkReal x740=IKcos(j4);
IkReal x741=((r00)*(sj6));
IkReal x742=((cj6)*(r01));
IkReal x743=((IkReal(1.00000000000000))*(cj0));
IkReal x744=((IkReal(1.00000000000000))*(sj0));
IkReal x745=((r10)*(sj6));
IkReal x746=((sj5)*(x739));
IkReal x747=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x748=((cj5)*(x739));
IkReal x749=((cj6)*(x740));
IkReal x750=((sj0)*(x748));
IkReal x751=((r01)*(sj6)*(x740));
IkReal x752=((r11)*(sj6)*(x740));
evalcond[0]=((((r20)*(sj6)*(x748)))+(((IkReal(-1.00000000000000))*(sj2)))+(((r21)*(sj6)*(x740)))+(((r22)*(x746)))+(((IkReal(-1.00000000000000))*(r20)*(x749)))+(((cj6)*(r21)*(x748))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r12)*(x743)*(x746)))+(((sj0)*(x751)))+(((IkReal(-1.00000000000000))*(x743)*(x752)))+(((IkReal(-1.00000000000000))*(x743)*(x745)*(x748)))+(cj2)+(((x742)*(x750)))+(((x741)*(x750)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x743)*(x748)))+(((IkReal(-1.00000000000000))*(r00)*(x744)*(x749)))+(((cj0)*(r10)*(x749)))+(((r02)*(sj0)*(x746))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x744)*(x745)*(x748)))+(((IkReal(-1.00000000000000))*(x742)*(x743)*(x748)))+(((IkReal(-1.00000000000000))*(r02)*(x743)*(x746)))+(((IkReal(-1.00000000000000))*(x744)*(x752)))+(((cj0)*(r00)*(x749)))+(((IkReal(-1.00000000000000))*(r12)*(x744)*(x746)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x744)*(x748)))+(((IkReal(-1.00000000000000))*(x741)*(x743)*(x748)))+(((r10)*(sj0)*(x749)))+(((IkReal(-1.00000000000000))*(x743)*(x751))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst43;
gconst43=IKsign(cj2);
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x753=((cj5)*(sj4));
IkReal x754=((IkReal(1.00000000000000))*(sj6));
IkReal x755=((r10)*(sj0));
IkReal x756=((sj4)*(sj5));
IkReal x757=((cj5)*(cj6));
IkReal x758=((r01)*(sj0));
IkReal x759=((IkReal(1.00000000000000))*(r02));
IkReal x760=((IkReal(0.374290000000000))*(cj0));
IkReal x761=((cj5)*(r12));
IkReal x762=((cj6)*(sj5));
IkReal x763=((cj0)*(r11));
IkReal x764=((cj5)*(sj0));
IkReal x765=((r20)*(sj6));
IkReal x766=((IkReal(1.00000000000000))*(sj0));
IkReal x767=((cj4)*(cj5));
IkReal x768=((IkReal(1.00000000000000))*(cj6));
IkReal x769=((IkReal(0.0100000000000000))*(sj5));
IkReal x770=((sj5)*(sj6));
IkReal x771=((cj0)*(r10));
IkReal x772=((cj4)*(cj6));
IkReal x773=((cj0)*(r01));
IkReal x774=((IkReal(1.00000000000000))*(cj4));
IkReal x775=((cj0)*(r00));
IkReal x776=((IkReal(0.374290000000000))*(sj0));
IkReal x777=((cj0)*(r12));
IkReal x778=((IkReal(0.374290000000000))*(sj5));
IkReal x779=((cj4)*(sj6));
IkReal x780=((IkReal(1.00000000000000))*(cj0));
IkReal x781=((r02)*(sj0));
IkReal x782=((IkReal(0.0100000000000000))*(cj5));
IkReal x783=((r11)*(sj0));
IkReal x784=((r00)*(sj0)*(sj6));
IkReal x785=((r00)*(x772));
IkReal x786=((sj6)*(x782));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x756)))+(((cj6)*(r21)*(x753)))+(((x753)*(x765)))+(((IkReal(-1.00000000000000))*(cj4)*(r20)*(x768)))+(((r21)*(x779))));
evalcond[2]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r22)*(x769)))+(((IkReal(-0.0100000000000000))*(r21)*(x757)))+(((IkReal(-1.00000000000000))*(x765)*(x782)))+(((IkReal(0.374290000000000))*(r21)*(x762)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((x765)*(x778))));
evalcond[3]=((((cj0)*(x761)))+(((x758)*(x762)))+(((IkReal(-1.00000000000000))*(x762)*(x763)))+(((IkReal(-1.00000000000000))*(x759)*(x764)))+(((IkReal(-1.00000000000000))*(sj5)*(x754)*(x771)))+(((r00)*(sj0)*(x770))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x753)*(x763)*(x768)))+(((x753)*(x784)))+(((IkReal(-1.00000000000000))*(cj4)*(x754)*(x763)))+(((cj6)*(x753)*(x758)))+(((IkReal(-1.00000000000000))*(x753)*(x754)*(x771)))+(((x756)*(x781)))+(((IkReal(-1.00000000000000))*(x766)*(x785)))+(((x771)*(x772)))+(((x758)*(x779)))+(((IkReal(-1.00000000000000))*(x756)*(x777))));
evalcond[5]=((((sj4)*(sj6)*(x763)))+(((IkReal(-1.00000000000000))*(sj4)*(x754)*(x758)))+(((IkReal(-1.00000000000000))*(sj5)*(x774)*(x777)))+(((r00)*(x764)*(x779)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((cj4)*(sj5)*(x781)))+(((IkReal(-1.00000000000000))*(sj4)*(x768)*(x771)))+(((IkReal(-1.00000000000000))*(x754)*(x767)*(x771)))+(((cj4)*(x757)*(x758)))+(((IkReal(-1.00000000000000))*(x757)*(x763)*(x774))));
evalcond[6]=((((x755)*(x772)))+(((IkReal(-1.00000000000000))*(x753)*(x754)*(x775)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x753)*(x766)))+(((x772)*(x775)))+(((IkReal(-1.00000000000000))*(cj4)*(x754)*(x783)))+(((IkReal(-1.00000000000000))*(x753)*(x768)*(x773)))+(((IkReal(-1.00000000000000))*(x753)*(x754)*(x755)))+(((IkReal(-1.00000000000000))*(cj0)*(x756)*(x759)))+(((IkReal(-1.00000000000000))*(cj4)*(x754)*(x773)))+(((IkReal(-1.00000000000000))*(r12)*(x756)*(x766))));
evalcond[7]=((((IkReal(-0.0100000000000000))*(x757)*(x758)))+(((IkReal(0.374290000000000))*(x758)*(x762)))+(((x769)*(x777)))+(((IkReal(-1.00000000000000))*(r11)*(x760)*(x762)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x764)))+(((IkReal(-1.00000000000000))*(py)*(x780)))+(((IkReal(-1.00000000000000))*(x769)*(x781)))+(((x760)*(x761)))+(((r00)*(x770)*(x776)))+(((x771)*(x786)))+(((IkReal(0.0100000000000000))*(x757)*(x763)))+(((IkReal(-1.00000000000000))*(r10)*(x760)*(x770)))+(((px)*(sj0)))+(((IkReal(-0.374290000000000))*(r02)*(x764))));
evalcond[8]=((IkReal(0.433420000000000))+(((x755)*(x786)))+(((x775)*(x786)))+(((IkReal(-0.374290000000000))*(x755)*(x770)))+(((IkReal(-1.00000000000000))*(r11)*(x762)*(x776)))+(((IkReal(-1.00000000000000))*(py)*(x766)))+(((IkReal(0.0100000000000000))*(x757)*(x773)))+(((x761)*(x776)))+(((cj0)*(r02)*(x769)))+(((IkReal(0.0100000000000000))*(x757)*(x783)))+(((IkReal(-1.00000000000000))*(r01)*(x760)*(x762)))+(((IkReal(-1.00000000000000))*(px)*(x780)))+(((cj5)*(r02)*(x760)))+(((r12)*(sj0)*(x769)))+(((IkReal(-1.00000000000000))*(r00)*(x760)*(x770))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x787=((IkReal(1.00000000000000))*(cj4));
IkReal x788=((cj6)*(r21));
IkReal x789=((r20)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x788)))+(((sj5)*(x789))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj5)*(x787)*(x788)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x787)*(x789)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x787)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x788)))+(((sj5)*(x789)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(x787)*(x788)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x787)*(x789)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x787)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x788)))+(((sj5)*(x789)))), ((((IkReal(-1.00000000000000))*(cj5)*(x787)*(x788)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x787)*(x789)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x787)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x790=IKcos(j3);
IkReal x791=((IkReal(1.00000000000000))*(cj4));
IkReal x792=((sj0)*(sj5));
IkReal x793=((cj0)*(cj5));
IkReal x794=((cj6)*(r01));
IkReal x795=((r00)*(sj6));
IkReal x796=((cj6)*(r11));
IkReal x797=((cj5)*(sj0));
IkReal x798=((cj6)*(sj4));
IkReal x799=((sj4)*(sj6));
IkReal x800=((cj4)*(cj5));
IkReal x801=((cj6)*(r21));
IkReal x802=((r20)*(sj6));
IkReal x803=((r10)*(sj6));
IkReal x804=((IkReal(1.00000000000000))*(IKsin(j3)));
IkReal x805=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(x804)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x801)))+(((sj5)*(x802))));
evalcond[1]=((((x800)*(x801)))+(((r20)*(x798)))+(((x800)*(x802)))+(((cj4)*(r22)*(sj5)))+(x790)+(((IkReal(-1.00000000000000))*(r21)*(x799))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x792)*(x803)))+(((r12)*(x797)))+(((r02)*(x793)))+(((IkReal(-1.00000000000000))*(x794)*(x805)))+(((IkReal(-1.00000000000000))*(x792)*(x796)))+(((IkReal(-1.00000000000000))*(x790)))+(((IkReal(-1.00000000000000))*(x795)*(x805))));
evalcond[3]=((((r11)*(sj0)*(x799)))+(((IkReal(-1.00000000000000))*(x791)*(x797)*(x803)))+(((IkReal(-1.00000000000000))*(x791)*(x793)*(x794)))+(((IkReal(-1.00000000000000))*(x804)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x791)))+(((IkReal(-1.00000000000000))*(r12)*(x791)*(x792)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x798)))+(((cj0)*(r01)*(x799)))+(((IkReal(-1.00000000000000))*(x791)*(x796)*(x797)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x798)))+(((IkReal(-1.00000000000000))*(x791)*(x793)*(x795))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x806=((cj5)*(sj4));
IkReal x807=((IkReal(1.00000000000000))*(sj6));
IkReal x808=((r10)*(sj0));
IkReal x809=((sj4)*(sj5));
IkReal x810=((cj5)*(cj6));
IkReal x811=((r01)*(sj0));
IkReal x812=((IkReal(1.00000000000000))*(r02));
IkReal x813=((IkReal(0.374290000000000))*(cj0));
IkReal x814=((cj5)*(r12));
IkReal x815=((cj6)*(sj5));
IkReal x816=((cj0)*(r11));
IkReal x817=((cj5)*(sj0));
IkReal x818=((r20)*(sj6));
IkReal x819=((IkReal(1.00000000000000))*(sj0));
IkReal x820=((cj4)*(cj5));
IkReal x821=((IkReal(1.00000000000000))*(cj6));
IkReal x822=((IkReal(0.0100000000000000))*(sj5));
IkReal x823=((sj5)*(sj6));
IkReal x824=((cj0)*(r10));
IkReal x825=((cj4)*(cj6));
IkReal x826=((cj0)*(r01));
IkReal x827=((IkReal(1.00000000000000))*(cj4));
IkReal x828=((cj0)*(r00));
IkReal x829=((IkReal(0.374290000000000))*(sj0));
IkReal x830=((cj0)*(r12));
IkReal x831=((IkReal(0.374290000000000))*(sj5));
IkReal x832=((cj4)*(sj6));
IkReal x833=((IkReal(1.00000000000000))*(cj0));
IkReal x834=((r02)*(sj0));
IkReal x835=((IkReal(0.0100000000000000))*(cj5));
IkReal x836=((r11)*(sj0));
IkReal x837=((r00)*(sj0)*(sj6));
IkReal x838=((r00)*(x825));
IkReal x839=((sj6)*(x835));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j2, IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r21)*(x806)))+(((r21)*(x832)))+(((x806)*(x818)))+(((IkReal(-1.00000000000000))*(cj4)*(r20)*(x821)))+(((r22)*(x809))));
evalcond[2]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(x818)*(x835)))+(((IkReal(0.374290000000000))*(r21)*(x815)))+(((IkReal(-0.0100000000000000))*(r21)*(x810)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x822)))+(((x818)*(x831))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x815)*(x816)))+(((IkReal(-1.00000000000000))*(sj5)*(x807)*(x824)))+(((r00)*(sj0)*(x823)))+(((cj0)*(x814)))+(((IkReal(-1.00000000000000))*(x812)*(x817)))+(((x811)*(x815))));
evalcond[4]=((IkReal(-1.00000000000000))+(((cj6)*(x806)*(x811)))+(((IkReal(-1.00000000000000))*(x806)*(x807)*(x824)))+(((IkReal(-1.00000000000000))*(x806)*(x816)*(x821)))+(((x824)*(x825)))+(((x811)*(x832)))+(((IkReal(-1.00000000000000))*(cj4)*(x807)*(x816)))+(((IkReal(-1.00000000000000))*(x819)*(x838)))+(((x809)*(x834)))+(((IkReal(-1.00000000000000))*(x809)*(x830)))+(((x806)*(x837))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj4)*(x807)*(x811)))+(((IkReal(-1.00000000000000))*(sj5)*(x827)*(x830)))+(((sj4)*(sj6)*(x816)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((r00)*(x817)*(x832)))+(((IkReal(-1.00000000000000))*(sj4)*(x821)*(x824)))+(((cj4)*(x810)*(x811)))+(((IkReal(-1.00000000000000))*(x810)*(x816)*(x827)))+(((IkReal(-1.00000000000000))*(x807)*(x820)*(x824)))+(((cj4)*(sj5)*(x834))));
evalcond[6]=((((IkReal(-1.00000000000000))*(cj0)*(x809)*(x812)))+(((IkReal(-1.00000000000000))*(x806)*(x821)*(x826)))+(((IkReal(-1.00000000000000))*(cj4)*(x807)*(x826)))+(((IkReal(-1.00000000000000))*(x806)*(x807)*(x828)))+(((IkReal(-1.00000000000000))*(x806)*(x807)*(x808)))+(((IkReal(-1.00000000000000))*(cj4)*(x807)*(x836)))+(((IkReal(-1.00000000000000))*(r12)*(x809)*(x819)))+(((x808)*(x825)))+(((x825)*(x828)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x806)*(x819))));
evalcond[7]=((((x824)*(x839)))+(((IkReal(-1.00000000000000))*(r11)*(x813)*(x815)))+(((r00)*(x823)*(x829)))+(((IkReal(-0.0100000000000000))*(x810)*(x811)))+(((IkReal(-1.00000000000000))*(py)*(x833)))+(((IkReal(-0.374290000000000))*(r02)*(x817)))+(((IkReal(0.0100000000000000))*(x810)*(x816)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x817)))+(((IkReal(0.374290000000000))*(x811)*(x815)))+(((x813)*(x814)))+(((IkReal(-1.00000000000000))*(x822)*(x834)))+(((x822)*(x830)))+(((IkReal(-1.00000000000000))*(r10)*(x813)*(x823)))+(((px)*(sj0))));
evalcond[8]=((IkReal(0.433420000000000))+(((IkReal(-1.00000000000000))*(r00)*(x813)*(x823)))+(((IkReal(-0.374290000000000))*(x808)*(x823)))+(((IkReal(0.0100000000000000))*(x810)*(x826)))+(((x808)*(x839)))+(((IkReal(0.0100000000000000))*(x810)*(x836)))+(((IkReal(-1.00000000000000))*(px)*(x833)))+(((r12)*(sj0)*(x822)))+(((IkReal(-1.00000000000000))*(r11)*(x815)*(x829)))+(((IkReal(-1.00000000000000))*(r01)*(x813)*(x815)))+(((cj5)*(r02)*(x813)))+(((IkReal(-1.00000000000000))*(py)*(x819)))+(((x814)*(x829)))+(((cj0)*(r02)*(x822)))+(((x828)*(x839))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x840=((IkReal(1.00000000000000))*(r21));
IkReal x841=((cj4)*(cj5));
IkReal x842=((r20)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x842)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x840))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x840)))+(((x841)*(x842)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x841))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x842)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x840)))))+IKsqr(((((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x840)))+(((x841)*(x842)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x841)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x842)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x840)))), ((((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x840)))+(((x841)*(x842)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x841)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x843=IKsin(j3);
IkReal x844=((IkReal(1.00000000000000))*(cj4));
IkReal x845=((sj0)*(sj5));
IkReal x846=((cj0)*(cj5));
IkReal x847=((cj6)*(r01));
IkReal x848=((r00)*(sj6));
IkReal x849=((cj6)*(r11));
IkReal x850=((cj5)*(sj0));
IkReal x851=((cj6)*(sj4));
IkReal x852=((sj4)*(sj6));
IkReal x853=((cj4)*(cj5));
IkReal x854=((cj6)*(r21));
IkReal x855=((r20)*(sj6));
IkReal x856=((r10)*(sj6));
IkReal x857=((IkReal(1.00000000000000))*(IKcos(j3)));
IkReal x858=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((((sj5)*(x854)))+(((sj5)*(x855)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(x843));
evalcond[1]=((((r20)*(x851)))+(((x853)*(x854)))+(((cj4)*(r22)*(sj5)))+(((x853)*(x855)))+(((IkReal(-1.00000000000000))*(x857)))+(((IkReal(-1.00000000000000))*(r21)*(x852))));
evalcond[2]=((((r12)*(x850)))+(((IkReal(-1.00000000000000))*(x848)*(x858)))+(((IkReal(-1.00000000000000))*(x845)*(x849)))+(((IkReal(-1.00000000000000))*(x857)))+(((IkReal(-1.00000000000000))*(x847)*(x858)))+(((IkReal(-1.00000000000000))*(x845)*(x856)))+(((r02)*(x846))));
evalcond[3]=((((r11)*(sj0)*(x852)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x844)))+(((cj0)*(r01)*(x852)))+(((IkReal(-1.00000000000000))*(x843)))+(((IkReal(-1.00000000000000))*(x844)*(x849)*(x850)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x851)))+(((IkReal(-1.00000000000000))*(r12)*(x844)*(x845)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x851)))+(((IkReal(-1.00000000000000))*(x844)*(x846)*(x848)))+(((IkReal(-1.00000000000000))*(x844)*(x846)*(x847)))+(((IkReal(-1.00000000000000))*(x844)*(x850)*(x856))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x859=((IkReal(1.00000000000000))*(cj0));
IkReal x860=((cj4)*(sj6));
IkReal x861=((sj0)*(sj4));
IkReal x862=((cj5)*(sj6));
IkReal x863=((sj4)*(sj5));
IkReal x864=((r12)*(sj5));
IkReal x865=((IkReal(0.374290000000000))*(cj5));
IkReal x866=((r02)*(sj0));
IkReal x867=((r20)*(sj4));
IkReal x868=((IkReal(1.00000000000000))*(sj0));
IkReal x869=((IkReal(1.00000000000000))*(cj5));
IkReal x870=((cj0)*(r10));
IkReal x871=((cj4)*(cj6));
IkReal x872=((r00)*(sj0));
IkReal x873=((cj6)*(r21));
IkReal x874=((IkReal(0.374290000000000))*(sj5));
IkReal x875=((cj0)*(r00));
IkReal x876=((IkReal(0.0100000000000000))*(sj5));
IkReal x877=((cj0)*(r02));
IkReal x878=((cj5)*(sj4));
IkReal x879=((cj6)*(r01));
IkReal x880=((cj6)*(r11));
IkReal x881=((r01)*(sj0));
IkReal x882=((r10)*(sj0));
IkReal x883=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x884=((sj6)*(x874));
IkReal x885=((cj0)*(cj6)*(x874));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x869)))+(((sj5)*(x873)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(-1.00000000000000))+(((r22)*(x863)))+(((x873)*(x878)))+(((x862)*(x867)))+(((IkReal(-1.00000000000000))*(r20)*(x871)))+(((r21)*(x860))));
evalcond[3]=((((IkReal(-0.0100000000000000))*(r20)*(x862)))+(((IkReal(-0.0100000000000000))*(cj5)*(x873)))+(((IkReal(-1.00000000000000))*(r22)*(x876)))+(((x873)*(x874)))+(((r20)*(x884)))+(((IkReal(-1.00000000000000))*(r22)*(x865)))+(pz));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r20)*(x860)))+(((cj6)*(x867)))+(((cj5)*(r21)*(x871))));
evalcond[5]=((((x860)*(x881)))+(((x870)*(x871)))+(((IkReal(-1.00000000000000))*(r12)*(x859)*(x863)))+(((IkReal(-1.00000000000000))*(r00)*(x868)*(x871)))+(((IkReal(-1.00000000000000))*(x859)*(x878)*(x880)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x859)*(x862)))+(((r02)*(sj5)*(x861)))+(((r00)*(x861)*(x862)))+(((cj5)*(x861)*(x879)))+(((IkReal(-1.00000000000000))*(r11)*(x859)*(x860))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x859)*(x878)*(x879)))+(((IkReal(-1.00000000000000))*(r10)*(x861)*(x862)))+(((IkReal(-1.00000000000000))*(x861)*(x864)))+(((IkReal(-1.00000000000000))*(x861)*(x869)*(x880)))+(((IkReal(-1.00000000000000))*(r02)*(x859)*(x863)))+(((x871)*(x882)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x859)*(x862)))+(((IkReal(-1.00000000000000))*(r01)*(x859)*(x860)))+(((x871)*(x875)))+(((IkReal(-1.00000000000000))*(r11)*(x860)*(x868))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x879)))+(((IkReal(0.0100000000000000))*(cj0)*(x864)))+(((IkReal(-0.0100000000000000))*(x862)*(x872)))+(((IkReal(-1.00000000000000))*(x865)*(x866)))+(((IkReal(0.0100000000000000))*(x862)*(x870)))+(((sj0)*(x874)*(x879)))+(((x872)*(x884)))+(((cj0)*(r12)*(x865)))+(((IkReal(-1.00000000000000))*(cj0)*(x874)*(x880)))+(((IkReal(-1.00000000000000))*(py)*(x859)))+(((IkReal(-1.00000000000000))*(x870)*(x884)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x866)*(x876)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x880))));
evalcond[8]=((IkReal(0.433420000000000))+(((IkReal(-1.00000000000000))*(py)*(x868)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x879)))+(((IkReal(-1.00000000000000))*(x882)*(x884)))+(((r12)*(sj0)*(x865)))+(((IkReal(0.0100000000000000))*(sj0)*(x864)))+(((x876)*(x877)))+(((IkReal(0.0100000000000000))*(x862)*(x875)))+(((IkReal(-1.00000000000000))*(cj0)*(x874)*(x879)))+(((IkReal(-1.00000000000000))*(sj0)*(x874)*(x880)))+(((IkReal(-1.00000000000000))*(x875)*(x884)))+(((x865)*(x877)))+(((IkReal(0.0100000000000000))*(x862)*(x882)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x880)))+(((IkReal(-1.00000000000000))*(px)*(x859))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x886=((cj0)*(cj5));
IkReal x887=((IkReal(1.00000000000000))*(cj0));
IkReal x888=((cj6)*(r11));
IkReal x889=((r10)*(sj6));
IkReal x890=((cj5)*(sj0));
IkReal x891=((r00)*(sj5)*(sj6));
IkReal x892=((cj6)*(r01)*(sj5));
IkReal x893=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((r12)*(x886)))+(((IkReal(-1.00000000000000))*(r02)*(x890)))+(((sj0)*(x891)))+(((IkReal(-1.00000000000000))*(sj5)*(x887)*(x888)))+(((IkReal(-1.00000000000000))*(sj5)*(x887)*(x889)))+(((sj0)*(x892))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x887)*(x892)))+(((IkReal(-1.00000000000000))*(x887)*(x891)))+(((IkReal(-1.00000000000000))*(x888)*(x893)))+(((IkReal(-1.00000000000000))*(x889)*(x893)))+(((r02)*(x886)))+(((r12)*(x890))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r12)*(x886)))+(((IkReal(-1.00000000000000))*(r02)*(x890)))+(((sj0)*(x891)))+(((IkReal(-1.00000000000000))*(sj5)*(x887)*(x888)))+(((IkReal(-1.00000000000000))*(sj5)*(x887)*(x889)))+(((sj0)*(x892)))))+IKsqr(((((IkReal(-1.00000000000000))*(x887)*(x892)))+(((IkReal(-1.00000000000000))*(x887)*(x891)))+(((IkReal(-1.00000000000000))*(x888)*(x893)))+(((IkReal(-1.00000000000000))*(x889)*(x893)))+(((r02)*(x886)))+(((r12)*(x890)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r12)*(x886)))+(((IkReal(-1.00000000000000))*(r02)*(x890)))+(((sj0)*(x891)))+(((IkReal(-1.00000000000000))*(sj5)*(x887)*(x888)))+(((IkReal(-1.00000000000000))*(sj5)*(x887)*(x889)))+(((sj0)*(x892)))), ((((IkReal(-1.00000000000000))*(x887)*(x892)))+(((IkReal(-1.00000000000000))*(x887)*(x891)))+(((IkReal(-1.00000000000000))*(x888)*(x893)))+(((IkReal(-1.00000000000000))*(x889)*(x893)))+(((r02)*(x886)))+(((r12)*(x890)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x894=IKcos(j3);
IkReal x895=((sj0)*(sj5));
IkReal x896=((r00)*(sj6));
IkReal x897=((cj6)*(sj0));
IkReal x898=((IkReal(1.00000000000000))*(cj4));
IkReal x899=((r00)*(sj4));
IkReal x900=((cj0)*(cj5));
IkReal x901=((cj5)*(sj0));
IkReal x902=((cj6)*(r11));
IkReal x903=((r10)*(sj6));
IkReal x904=((cj0)*(sj5));
IkReal x905=((r10)*(sj4));
IkReal x906=((IkReal(1.00000000000000))*(IKsin(j3)));
IkReal x907=((cj4)*(cj5)*(r01));
IkReal x908=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x909=((cj0)*(sj4)*(sj6));
IkReal x910=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(r02)*(x901)))+(((IkReal(-1.00000000000000))*(x903)*(x904)))+(((cj6)*(r01)*(x895)))+(((IkReal(-1.00000000000000))*(x902)*(x904)))+(((r12)*(x900)))+(((x895)*(x896)))+(((IkReal(-1.00000000000000))*(x906))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x895)*(x903)))+(((IkReal(-1.00000000000000))*(x896)*(x904)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x904)))+(((r02)*(x900)))+(((IkReal(-1.00000000000000))*(x894)))+(((IkReal(-1.00000000000000))*(x895)*(x902)))+(((r12)*(x901))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x905)*(x908)))+(((r11)*(x909)))+(((IkReal(-1.00000000000000))*(r12)*(x898)*(x904)))+(((IkReal(-1.00000000000000))*(r01)*(x910)))+(((x897)*(x907)))+(((IkReal(-1.00000000000000))*(x898)*(x900)*(x903)))+(((x897)*(x899)))+(((IkReal(-1.00000000000000))*(x898)*(x900)*(x902)))+(x894)+(((cj4)*(x896)*(x901)))+(((cj4)*(r02)*(x895))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj5)*(r11)*(x897)*(x898)))+(((IkReal(-1.00000000000000))*(r12)*(x895)*(x898)))+(((IkReal(-1.00000000000000))*(r02)*(x898)*(x904)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x898)*(x900)))+(((IkReal(-1.00000000000000))*(x899)*(x908)))+(((r11)*(x910)))+(((IkReal(-1.00000000000000))*(x897)*(x905)))+(((IkReal(-1.00000000000000))*(x896)*(x898)*(x900)))+(((r01)*(x909)))+(((IkReal(-1.00000000000000))*(x898)*(x901)*(x903)))+(((IkReal(-1.00000000000000))*(x906))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x911=((IkReal(1.00000000000000))*(cj0));
IkReal x912=((cj4)*(sj6));
IkReal x913=((sj0)*(sj4));
IkReal x914=((cj5)*(sj6));
IkReal x915=((sj4)*(sj5));
IkReal x916=((r12)*(sj5));
IkReal x917=((IkReal(0.374290000000000))*(cj5));
IkReal x918=((r02)*(sj0));
IkReal x919=((r20)*(sj4));
IkReal x920=((IkReal(1.00000000000000))*(sj0));
IkReal x921=((IkReal(1.00000000000000))*(cj5));
IkReal x922=((cj0)*(r10));
IkReal x923=((cj4)*(cj6));
IkReal x924=((r00)*(sj0));
IkReal x925=((cj6)*(r21));
IkReal x926=((IkReal(0.374290000000000))*(sj5));
IkReal x927=((cj0)*(r00));
IkReal x928=((IkReal(0.0100000000000000))*(sj5));
IkReal x929=((cj0)*(r02));
IkReal x930=((cj5)*(sj4));
IkReal x931=((cj6)*(r01));
IkReal x932=((cj6)*(r11));
IkReal x933=((r01)*(sj0));
IkReal x934=((r10)*(sj0));
IkReal x935=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x936=((sj6)*(x926));
IkReal x937=((cj0)*(cj6)*(x926));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x921)))+(((sj5)*(x925)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(1.00000000000000))+(((r21)*(x912)))+(((x914)*(x919)))+(((IkReal(-1.00000000000000))*(r20)*(x923)))+(((r22)*(x915)))+(((x925)*(x930))));
evalcond[3]=((((x925)*(x926)))+(((IkReal(-1.00000000000000))*(r22)*(x917)))+(pz)+(((r20)*(x936)))+(((IkReal(-0.0100000000000000))*(r20)*(x914)))+(((IkReal(-0.0100000000000000))*(cj5)*(x925)))+(((IkReal(-1.00000000000000))*(r22)*(x928))));
evalcond[4]=((((cj5)*(r21)*(x923)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj5)*(r20)*(x912)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(x919))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r11)*(x911)*(x912)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x911)*(x914)))+(((IkReal(-1.00000000000000))*(r00)*(x920)*(x923)))+(((IkReal(-1.00000000000000))*(r12)*(x911)*(x915)))+(((r02)*(sj5)*(x913)))+(((IkReal(-1.00000000000000))*(x911)*(x930)*(x932)))+(((cj5)*(x913)*(x931)))+(((x912)*(x933)))+(((r00)*(x913)*(x914)))+(((x922)*(x923))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r02)*(x911)*(x915)))+(((x923)*(x934)))+(((IkReal(-1.00000000000000))*(x911)*(x930)*(x931)))+(((IkReal(-1.00000000000000))*(r10)*(x913)*(x914)))+(((IkReal(-1.00000000000000))*(x913)*(x921)*(x932)))+(((IkReal(-1.00000000000000))*(x913)*(x916)))+(((IkReal(-1.00000000000000))*(r11)*(x912)*(x920)))+(((x923)*(x927)))+(((IkReal(-1.00000000000000))*(r01)*(x911)*(x912)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x911)*(x914))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(py)*(x911)))+(((IkReal(-0.0100000000000000))*(x914)*(x924)))+(((IkReal(-1.00000000000000))*(x918)*(x928)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x932)))+(((IkReal(0.0100000000000000))*(cj0)*(x916)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x931)))+(((IkReal(-1.00000000000000))*(x917)*(x918)))+(((sj0)*(x926)*(x931)))+(((IkReal(-1.00000000000000))*(x922)*(x936)))+(((IkReal(0.0100000000000000))*(x914)*(x922)))+(((cj0)*(r12)*(x917)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(x926)*(x932)))+(((x924)*(x936))));
evalcond[8]=((IkReal(0.433420000000000))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x932)))+(((IkReal(0.0100000000000000))*(x914)*(x927)))+(((IkReal(0.0100000000000000))*(x914)*(x934)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x931)))+(((x928)*(x929)))+(((IkReal(-1.00000000000000))*(sj0)*(x926)*(x932)))+(((IkReal(-1.00000000000000))*(py)*(x920)))+(((IkReal(-1.00000000000000))*(cj0)*(x926)*(x931)))+(((x917)*(x929)))+(((IkReal(-1.00000000000000))*(px)*(x911)))+(((IkReal(-1.00000000000000))*(x934)*(x936)))+(((IkReal(0.0100000000000000))*(sj0)*(x916)))+(((IkReal(-1.00000000000000))*(x927)*(x936)))+(((r12)*(sj0)*(x917))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x938=((cj5)*(r02));
IkReal x939=((cj0)*(sj5));
IkReal x940=((r10)*(sj6));
IkReal x941=((IkReal(1.00000000000000))*(cj6));
IkReal x942=((sj0)*(sj5));
IkReal x943=((cj5)*(r12));
IkReal x944=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj0)*(x943)))+(((IkReal(-1.00000000000000))*(r01)*(x941)*(x942)))+(((cj6)*(r11)*(x939)))+(((x939)*(x940)))+(((sj0)*(x938)))+(((IkReal(-1.00000000000000))*(x942)*(x944))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x940)*(x942)))+(((IkReal(-1.00000000000000))*(r01)*(x939)*(x941)))+(((sj0)*(x943)))+(((IkReal(-1.00000000000000))*(r11)*(x941)*(x942)))+(((cj0)*(x938)))+(((IkReal(-1.00000000000000))*(x939)*(x944))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj0)*(x943)))+(((IkReal(-1.00000000000000))*(r01)*(x941)*(x942)))+(((cj6)*(r11)*(x939)))+(((x939)*(x940)))+(((sj0)*(x938)))+(((IkReal(-1.00000000000000))*(x942)*(x944)))))+IKsqr(((((IkReal(-1.00000000000000))*(x940)*(x942)))+(((IkReal(-1.00000000000000))*(r01)*(x939)*(x941)))+(((sj0)*(x943)))+(((IkReal(-1.00000000000000))*(r11)*(x941)*(x942)))+(((cj0)*(x938)))+(((IkReal(-1.00000000000000))*(x939)*(x944)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj0)*(x943)))+(((IkReal(-1.00000000000000))*(r01)*(x941)*(x942)))+(((cj6)*(r11)*(x939)))+(((x939)*(x940)))+(((sj0)*(x938)))+(((IkReal(-1.00000000000000))*(x942)*(x944)))), ((((IkReal(-1.00000000000000))*(x940)*(x942)))+(((IkReal(-1.00000000000000))*(r01)*(x939)*(x941)))+(((sj0)*(x943)))+(((IkReal(-1.00000000000000))*(r11)*(x941)*(x942)))+(((cj0)*(x938)))+(((IkReal(-1.00000000000000))*(x939)*(x944)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x945=IKsin(j3);
IkReal x946=((sj0)*(sj5));
IkReal x947=((r00)*(sj6));
IkReal x948=((IkReal(1.00000000000000))*(cj4));
IkReal x949=((cj6)*(sj0));
IkReal x950=((r00)*(sj4));
IkReal x951=((cj0)*(cj5));
IkReal x952=((cj6)*(r01));
IkReal x953=((cj5)*(sj0));
IkReal x954=((cj0)*(sj5));
IkReal x955=((cj6)*(r11));
IkReal x956=((r10)*(sj6));
IkReal x957=((r10)*(sj4));
IkReal x958=((IkReal(1.00000000000000))*(IKcos(j3)));
IkReal x959=((cj0)*(sj4)*(sj6));
IkReal x960=((sj0)*(sj4)*(sj6));
IkReal x961=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((((x946)*(x952)))+(((IkReal(-1.00000000000000))*(x954)*(x955)))+(((r12)*(x951)))+(((x946)*(x947)))+(x945)+(((IkReal(-1.00000000000000))*(r02)*(x953)))+(((IkReal(-1.00000000000000))*(x954)*(x956))));
evalcond[1]=((((r02)*(x951)))+(((r12)*(x953)))+(((IkReal(-1.00000000000000))*(x946)*(x955)))+(((IkReal(-1.00000000000000))*(x947)*(x954)))+(((IkReal(-1.00000000000000))*(x946)*(x956)))+(((IkReal(-1.00000000000000))*(x958)))+(((IkReal(-1.00000000000000))*(x952)*(x954))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x960)))+(((cj4)*(x947)*(x953)))+(((r11)*(x959)))+(((cj4)*(cj5)*(r01)*(x949)))+(((IkReal(-1.00000000000000))*(x957)*(x961)))+(((IkReal(-1.00000000000000))*(x948)*(x951)*(x955)))+(((x949)*(x950)))+(((IkReal(-1.00000000000000))*(r12)*(x948)*(x954)))+(((cj4)*(r02)*(x946)))+(((IkReal(-1.00000000000000))*(x948)*(x951)*(x956)))+(((IkReal(-1.00000000000000))*(x958))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x950)*(x961)))+(((IkReal(-1.00000000000000))*(x945)))+(((IkReal(-1.00000000000000))*(x949)*(x957)))+(((IkReal(-1.00000000000000))*(x948)*(x953)*(x956)))+(((IkReal(-1.00000000000000))*(x948)*(x951)*(x952)))+(((r01)*(x959)))+(((IkReal(-1.00000000000000))*(r12)*(x946)*(x948)))+(((r11)*(x960)))+(((IkReal(-1.00000000000000))*(x947)*(x948)*(x951)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x948)*(x949)))+(((IkReal(-1.00000000000000))*(r02)*(x948)*(x954))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x962=((cj0)*(cj5));
IkReal x963=((IkReal(1.00000000000000))*(cj0));
IkReal x964=((cj6)*(r11));
IkReal x965=((r10)*(sj6));
IkReal x966=((cj5)*(sj0));
IkReal x967=((r00)*(sj5)*(sj6));
IkReal x968=((cj6)*(r01)*(sj5));
IkReal x969=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r12)*(x962)))+(((IkReal(-1.00000000000000))*(r02)*(x966)))+(((IkReal(-1.00000000000000))*(sj5)*(x963)*(x965)))+(((sj0)*(x967)))+(((sj0)*(x968)))+(((IkReal(-1.00000000000000))*(sj5)*(x963)*(x964))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x964)*(x969)))+(((IkReal(-1.00000000000000))*(x963)*(x968)))+(((IkReal(-1.00000000000000))*(x965)*(x969)))+(((r02)*(x962)))+(((r12)*(x966)))+(((IkReal(-1.00000000000000))*(x963)*(x967))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r12)*(x962)))+(((IkReal(-1.00000000000000))*(r02)*(x966)))+(((IkReal(-1.00000000000000))*(sj5)*(x963)*(x965)))+(((sj0)*(x967)))+(((sj0)*(x968)))+(((IkReal(-1.00000000000000))*(sj5)*(x963)*(x964)))))))+IKsqr(((((IkReal(-1.00000000000000))*(x964)*(x969)))+(((IkReal(-1.00000000000000))*(x963)*(x968)))+(((IkReal(-1.00000000000000))*(x965)*(x969)))+(((r02)*(x962)))+(((r12)*(x966)))+(((IkReal(-1.00000000000000))*(x963)*(x967)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r12)*(x962)))+(((IkReal(-1.00000000000000))*(r02)*(x966)))+(((IkReal(-1.00000000000000))*(sj5)*(x963)*(x965)))+(((sj0)*(x967)))+(((sj0)*(x968)))+(((IkReal(-1.00000000000000))*(sj5)*(x963)*(x964)))))), ((((IkReal(-1.00000000000000))*(x964)*(x969)))+(((IkReal(-1.00000000000000))*(x963)*(x968)))+(((IkReal(-1.00000000000000))*(x965)*(x969)))+(((r02)*(x962)))+(((r12)*(x966)))+(((IkReal(-1.00000000000000))*(x963)*(x967)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x970=IKsin(j3);
IkReal x971=IKcos(j3);
IkReal x972=((sj0)*(sj5));
IkReal x973=((r00)*(sj6));
IkReal x974=((IkReal(1.00000000000000))*(cj4));
IkReal x975=((cj6)*(r01));
IkReal x976=((cj0)*(cj5));
IkReal x977=((cj5)*(sj0));
IkReal x978=((cj6)*(r11));
IkReal x979=((cj0)*(sj5));
IkReal x980=((cj6)*(sj4));
IkReal x981=((cj4)*(cj5));
IkReal x982=((cj6)*(r21));
IkReal x983=((r20)*(sj6));
IkReal x984=((r10)*(sj6));
IkReal x985=((IkReal(1.00000000000000))*(cj0));
IkReal x986=((IkReal(1.00000000000000))*(x970));
IkReal x987=((cj0)*(sj4)*(sj6));
IkReal x988=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj2)*(x986)))+(((sj5)*(x982)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x983))));
evalcond[1]=((((x981)*(x983)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj2)*(x971)))+(((x981)*(x982)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x980))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x978)*(x979)))+(((x972)*(x975)))+(((IkReal(-1.00000000000000))*(sj2)*(x986)))+(((IkReal(-1.00000000000000))*(x979)*(x984)))+(((IkReal(-1.00000000000000))*(r02)*(x977)))+(((r12)*(x976)))+(((x972)*(x973))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x972)*(x978)))+(((IkReal(-1.00000000000000))*(x973)*(x979)))+(((r02)*(x976)))+(((IkReal(-1.00000000000000))*(x971)))+(((IkReal(-1.00000000000000))*(x972)*(x984)))+(((IkReal(-1.00000000000000))*(x975)*(x979)))+(((r12)*(x977))));
evalcond[4]=((((r11)*(x987)))+(((IkReal(-1.00000000000000))*(r10)*(x980)*(x985)))+(((r00)*(sj0)*(x980)))+(((IkReal(-1.00000000000000))*(x974)*(x976)*(x978)))+(((cj4)*(r02)*(x972)))+(((cj4)*(x973)*(x977)))+(((IkReal(-1.00000000000000))*(r12)*(x974)*(x979)))+(((cj4)*(x975)*(x977)))+(((IkReal(-1.00000000000000))*(r01)*(x988)))+(((IkReal(-1.00000000000000))*(x974)*(x976)*(x984)))+(((sj2)*(x971))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x973)*(x974)*(x976)))+(((IkReal(-1.00000000000000))*(x974)*(x977)*(x978)))+(((IkReal(-1.00000000000000))*(x974)*(x977)*(x984)))+(((r01)*(x987)))+(((IkReal(-1.00000000000000))*(r00)*(x980)*(x985)))+(((IkReal(-1.00000000000000))*(r02)*(x974)*(x979)))+(((r11)*(x988)))+(((IkReal(-1.00000000000000))*(x986)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x980)))+(((IkReal(-1.00000000000000))*(x974)*(x975)*(x976)))+(((IkReal(-1.00000000000000))*(r12)*(x972)*(x974))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x989=((sj5)*(sj6));
IkReal x990=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj6)*(r21)*(sj5)))+(((r20)*(x989)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x989)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x989)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x990)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x990))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj6)*(r21)*(sj5)))+(((r20)*(x989)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))))+IKsqr(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x989)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x989)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x990)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x990)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj6)*(r21)*(sj5)))+(((r20)*(x989)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))), ((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x989)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x989)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x990)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x990)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x991=IKsin(j3);
IkReal x992=IKcos(j3);
IkReal x993=((sj0)*(sj5));
IkReal x994=((r00)*(sj6));
IkReal x995=((IkReal(1.00000000000000))*(cj4));
IkReal x996=((cj6)*(r01));
IkReal x997=((cj0)*(cj5));
IkReal x998=((cj5)*(sj0));
IkReal x999=((cj6)*(r11));
IkReal x1000=((cj0)*(sj5));
IkReal x1001=((cj6)*(sj4));
IkReal x1002=((cj4)*(cj5));
IkReal x1003=((cj6)*(r21));
IkReal x1004=((r20)*(sj6));
IkReal x1005=((r10)*(sj6));
IkReal x1006=((IkReal(1.00000000000000))*(cj0));
IkReal x1007=((IkReal(1.00000000000000))*(x991));
IkReal x1008=((cj0)*(sj4)*(sj6));
IkReal x1009=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x1003)))+(((IkReal(-1.00000000000000))*(cj2)*(x1007)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1004))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x1002)*(x1003)))+(((r20)*(x1001)))+(((cj4)*(r22)*(sj5)))+(((cj2)*(x992)))+(((x1002)*(x1004))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r02)*(x998)))+(((IkReal(-1.00000000000000))*(sj2)*(x1007)))+(((x993)*(x994)))+(((IkReal(-1.00000000000000))*(x1000)*(x999)))+(((r12)*(x997)))+(((IkReal(-1.00000000000000))*(x1000)*(x1005)))+(((x993)*(x996))));
evalcond[3]=((((r02)*(x997)))+(((IkReal(-1.00000000000000))*(x992)))+(((IkReal(-1.00000000000000))*(x993)*(x999)))+(((IkReal(-1.00000000000000))*(x1005)*(x993)))+(((IkReal(-1.00000000000000))*(x1000)*(x994)))+(((r12)*(x998)))+(((IkReal(-1.00000000000000))*(x1000)*(x996))));
evalcond[4]=((((cj4)*(r02)*(x993)))+(((sj2)*(x992)))+(((r00)*(sj0)*(x1001)))+(((IkReal(-1.00000000000000))*(r12)*(x1000)*(x995)))+(((IkReal(-1.00000000000000))*(x1005)*(x995)*(x997)))+(((IkReal(-1.00000000000000))*(x995)*(x997)*(x999)))+(((IkReal(-1.00000000000000))*(r10)*(x1001)*(x1006)))+(((r11)*(x1008)))+(((cj4)*(x994)*(x998)))+(((cj4)*(x996)*(x998)))+(((IkReal(-1.00000000000000))*(r01)*(x1009))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r12)*(x993)*(x995)))+(((IkReal(-1.00000000000000))*(x995)*(x998)*(x999)))+(((r01)*(x1008)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1001)))+(((IkReal(-1.00000000000000))*(x1007)))+(((IkReal(-1.00000000000000))*(r02)*(x1000)*(x995)))+(((IkReal(-1.00000000000000))*(r00)*(x1001)*(x1006)))+(((IkReal(-1.00000000000000))*(x995)*(x996)*(x997)))+(((IkReal(-1.00000000000000))*(x994)*(x995)*(x997)))+(((r11)*(x1009)))+(((IkReal(-1.00000000000000))*(x1005)*(x995)*(x998))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1010=((IkReal(1.00000000000000))*(cj4));
IkReal x1011=((cj6)*(r21));
IkReal x1012=((r20)*(sj6));
if( IKabs(((gconst43)*(((((sj5)*(x1012)))+(((sj5)*(x1011)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst43)*(((((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x1010)*(x1012)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1010)))+(((IkReal(-1.00000000000000))*(cj5)*(x1010)*(x1011)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst43)*(((((sj5)*(x1012)))+(((sj5)*(x1011)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))), ((gconst43)*(((((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x1010)*(x1012)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1010)))+(((IkReal(-1.00000000000000))*(cj5)*(x1010)*(x1011)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1013=IKsin(j3);
IkReal x1014=IKcos(j3);
IkReal x1015=((sj0)*(sj5));
IkReal x1016=((r00)*(sj6));
IkReal x1017=((IkReal(1.00000000000000))*(cj4));
IkReal x1018=((cj6)*(r01));
IkReal x1019=((cj0)*(cj5));
IkReal x1020=((cj5)*(sj0));
IkReal x1021=((cj6)*(r11));
IkReal x1022=((cj0)*(sj5));
IkReal x1023=((cj6)*(sj4));
IkReal x1024=((cj4)*(cj5));
IkReal x1025=((cj6)*(r21));
IkReal x1026=((r20)*(sj6));
IkReal x1027=((r10)*(sj6));
IkReal x1028=((IkReal(1.00000000000000))*(cj0));
IkReal x1029=((IkReal(1.00000000000000))*(x1013));
IkReal x1030=((cj0)*(sj4)*(sj6));
IkReal x1031=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x1025)))+(((IkReal(-1.00000000000000))*(cj2)*(x1029)))+(((sj5)*(x1026)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((r20)*(x1023)))+(((x1024)*(x1025)))+(((x1024)*(x1026)))+(((cj4)*(r22)*(sj5)))+(((cj2)*(x1014))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1021)*(x1022)))+(((r12)*(x1019)))+(((IkReal(-1.00000000000000))*(r02)*(x1020)))+(((x1015)*(x1016)))+(((IkReal(-1.00000000000000))*(sj2)*(x1029)))+(((x1015)*(x1018)))+(((IkReal(-1.00000000000000))*(x1022)*(x1027))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1015)*(x1027)))+(((IkReal(-1.00000000000000))*(x1015)*(x1021)))+(((IkReal(-1.00000000000000))*(x1014)))+(((IkReal(-1.00000000000000))*(x1018)*(x1022)))+(((r12)*(x1020)))+(((r02)*(x1019)))+(((IkReal(-1.00000000000000))*(x1016)*(x1022))));
evalcond[4]=((((r11)*(x1030)))+(((IkReal(-1.00000000000000))*(r01)*(x1031)))+(((IkReal(-1.00000000000000))*(r12)*(x1017)*(x1022)))+(((r00)*(sj0)*(x1023)))+(((IkReal(-1.00000000000000))*(r10)*(x1023)*(x1028)))+(((IkReal(-1.00000000000000))*(x1017)*(x1019)*(x1021)))+(((cj4)*(x1018)*(x1020)))+(((IkReal(-1.00000000000000))*(x1017)*(x1019)*(x1027)))+(((cj4)*(x1016)*(x1020)))+(((cj4)*(r02)*(x1015)))+(((sj2)*(x1014))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r02)*(x1017)*(x1022)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1023)))+(((IkReal(-1.00000000000000))*(x1017)*(x1018)*(x1019)))+(((IkReal(-1.00000000000000))*(x1017)*(x1020)*(x1027)))+(((r01)*(x1030)))+(((IkReal(-1.00000000000000))*(r12)*(x1015)*(x1017)))+(((IkReal(-1.00000000000000))*(r00)*(x1023)*(x1028)))+(((IkReal(-1.00000000000000))*(x1017)*(x1020)*(x1021)))+(((IkReal(-1.00000000000000))*(x1029)))+(((IkReal(-1.00000000000000))*(x1016)*(x1017)*(x1019)))+(((r11)*(x1031))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1032=((r11)*(sj0));
IkReal x1033=((cj0)*(r01));
IkReal x1034=((cj0)*(sj2));
IkReal x1035=((sj0)*(sj2));
IkReal x1036=((cj5)*(sj6));
IkReal x1037=((IkReal(1.00000000000000))*(sj2)*(sj6));
IkReal x1038=((cj5)*(cj6)*(sj2));
if( IKabs(((gconst40)*(((((IkReal(-1.00000000000000))*(x1032)*(x1037)))+(((cj6)*(r10)*(x1035)))+(((IkReal(-1.00000000000000))*(x1033)*(x1037)))+(((cj6)*(r00)*(x1034))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst40)*(((((r00)*(x1034)*(x1036)))+(((x1033)*(x1038)))+(((r02)*(sj5)*(x1034)))+(((r10)*(x1035)*(x1036)))+(((x1032)*(x1038)))+(((r12)*(sj5)*(x1035))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst40)*(((((IkReal(-1.00000000000000))*(x1032)*(x1037)))+(((cj6)*(r10)*(x1035)))+(((IkReal(-1.00000000000000))*(x1033)*(x1037)))+(((cj6)*(r00)*(x1034)))))), ((gconst40)*(((((r00)*(x1034)*(x1036)))+(((x1033)*(x1038)))+(((r02)*(sj5)*(x1034)))+(((r10)*(x1035)*(x1036)))+(((x1032)*(x1038)))+(((r12)*(sj5)*(x1035)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1039=IKsin(j4);
IkReal x1040=IKcos(j4);
IkReal x1041=((r00)*(sj6));
IkReal x1042=((cj6)*(r01));
IkReal x1043=((IkReal(1.00000000000000))*(cj0));
IkReal x1044=((IkReal(1.00000000000000))*(sj0));
IkReal x1045=((r10)*(sj6));
IkReal x1046=((sj5)*(x1039));
IkReal x1047=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x1048=((cj5)*(x1039));
IkReal x1049=((cj6)*(x1040));
IkReal x1050=((sj0)*(x1048));
IkReal x1051=((r01)*(sj6)*(x1040));
IkReal x1052=((r11)*(sj6)*(x1040));
evalcond[0]=((((r22)*(x1046)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(r20)*(x1049)))+(((r20)*(sj6)*(x1048)))+(((r21)*(sj6)*(x1040)))+(((cj6)*(r21)*(x1048))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1043)*(x1045)*(x1048)))+(((sj0)*(x1051)))+(((IkReal(-1.00000000000000))*(x1043)*(x1052)))+(((IkReal(-1.00000000000000))*(r12)*(x1043)*(x1046)))+(((cj0)*(r10)*(x1049)))+(((IkReal(-1.00000000000000))*(r00)*(x1044)*(x1049)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1043)*(x1048)))+(cj2)+(((x1042)*(x1050)))+(((x1041)*(x1050)))+(((r02)*(sj0)*(x1046))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1044)*(x1052)))+(((IkReal(-1.00000000000000))*(x1041)*(x1043)*(x1048)))+(((IkReal(-1.00000000000000))*(x1044)*(x1045)*(x1048)))+(((IkReal(-1.00000000000000))*(r02)*(x1043)*(x1046)))+(((IkReal(-1.00000000000000))*(r12)*(x1044)*(x1046)))+(((IkReal(-1.00000000000000))*(x1042)*(x1043)*(x1048)))+(((r10)*(sj0)*(x1049)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1044)*(x1048)))+(((cj0)*(r00)*(x1049)))+(((IkReal(-1.00000000000000))*(x1043)*(x1051))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst43;
gconst43=IKsign(cj2);
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x1053=((cj5)*(sj4));
IkReal x1054=((IkReal(1.00000000000000))*(sj6));
IkReal x1055=((r10)*(sj0));
IkReal x1056=((sj4)*(sj5));
IkReal x1057=((cj5)*(cj6));
IkReal x1058=((r01)*(sj0));
IkReal x1059=((IkReal(1.00000000000000))*(r02));
IkReal x1060=((IkReal(0.374290000000000))*(cj0));
IkReal x1061=((cj5)*(r12));
IkReal x1062=((cj6)*(sj5));
IkReal x1063=((cj0)*(r11));
IkReal x1064=((cj5)*(sj0));
IkReal x1065=((r20)*(sj6));
IkReal x1066=((IkReal(1.00000000000000))*(sj0));
IkReal x1067=((cj4)*(cj5));
IkReal x1068=((IkReal(1.00000000000000))*(cj6));
IkReal x1069=((IkReal(0.0100000000000000))*(sj5));
IkReal x1070=((sj5)*(sj6));
IkReal x1071=((cj0)*(r10));
IkReal x1072=((cj4)*(cj6));
IkReal x1073=((cj0)*(r01));
IkReal x1074=((IkReal(1.00000000000000))*(cj4));
IkReal x1075=((cj0)*(r00));
IkReal x1076=((IkReal(0.374290000000000))*(sj0));
IkReal x1077=((cj0)*(r12));
IkReal x1078=((IkReal(0.374290000000000))*(sj5));
IkReal x1079=((cj4)*(sj6));
IkReal x1080=((IkReal(1.00000000000000))*(cj0));
IkReal x1081=((r02)*(sj0));
IkReal x1082=((IkReal(0.0100000000000000))*(cj5));
IkReal x1083=((r11)*(sj0));
IkReal x1084=((r00)*(sj0)*(sj6));
IkReal x1085=((r00)*(x1072));
IkReal x1086=((sj6)*(x1082));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((x1053)*(x1065)))+(((r21)*(x1079)))+(((cj6)*(r21)*(x1053)))+(((r22)*(x1056)))+(((IkReal(-1.00000000000000))*(cj4)*(r20)*(x1068))));
evalcond[2]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r22)*(x1069)))+(((x1065)*(x1078)))+(((IkReal(-0.0100000000000000))*(r21)*(x1057)))+(((IkReal(-1.00000000000000))*(x1065)*(x1082)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((IkReal(0.374290000000000))*(r21)*(x1062))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1062)*(x1063)))+(((IkReal(-1.00000000000000))*(sj5)*(x1054)*(x1071)))+(((IkReal(-1.00000000000000))*(x1059)*(x1064)))+(((x1058)*(x1062)))+(((r00)*(sj0)*(x1070)))+(((cj0)*(x1061))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(cj4)*(x1054)*(x1063)))+(((cj6)*(x1053)*(x1058)))+(((IkReal(-1.00000000000000))*(x1056)*(x1077)))+(((IkReal(-1.00000000000000))*(x1066)*(x1085)))+(((x1071)*(x1072)))+(((x1053)*(x1084)))+(((IkReal(-1.00000000000000))*(x1053)*(x1063)*(x1068)))+(((x1058)*(x1079)))+(((IkReal(-1.00000000000000))*(x1053)*(x1054)*(x1071)))+(((x1056)*(x1081))));
evalcond[5]=((((sj4)*(sj6)*(x1063)))+(((IkReal(-1.00000000000000))*(sj4)*(x1054)*(x1058)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((IkReal(-1.00000000000000))*(sj4)*(x1068)*(x1071)))+(((IkReal(-1.00000000000000))*(sj5)*(x1074)*(x1077)))+(((cj4)*(x1057)*(x1058)))+(((IkReal(-1.00000000000000))*(x1057)*(x1063)*(x1074)))+(((IkReal(-1.00000000000000))*(x1054)*(x1067)*(x1071)))+(((cj4)*(sj5)*(x1081)))+(((r00)*(x1064)*(x1079))));
evalcond[6]=((((x1072)*(x1075)))+(((IkReal(-1.00000000000000))*(cj4)*(x1054)*(x1073)))+(((x1055)*(x1072)))+(((IkReal(-1.00000000000000))*(x1053)*(x1068)*(x1073)))+(((IkReal(-1.00000000000000))*(cj0)*(x1056)*(x1059)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1053)*(x1066)))+(((IkReal(-1.00000000000000))*(cj4)*(x1054)*(x1083)))+(((IkReal(-1.00000000000000))*(x1053)*(x1054)*(x1075)))+(((IkReal(-1.00000000000000))*(x1053)*(x1054)*(x1055)))+(((IkReal(-1.00000000000000))*(r12)*(x1056)*(x1066))));
evalcond[7]=((((IkReal(-1.00000000000000))*(py)*(x1080)))+(((IkReal(-0.0100000000000000))*(x1057)*(x1058)))+(((x1060)*(x1061)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x1064)))+(((IkReal(-1.00000000000000))*(r11)*(x1060)*(x1062)))+(((IkReal(-1.00000000000000))*(r10)*(x1060)*(x1070)))+(((x1071)*(x1086)))+(((IkReal(0.0100000000000000))*(x1057)*(x1063)))+(((x1069)*(x1077)))+(((IkReal(-0.374290000000000))*(r02)*(x1064)))+(((IkReal(0.374290000000000))*(x1058)*(x1062)))+(((r00)*(x1070)*(x1076)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x1069)*(x1081))));
evalcond[8]=((IkReal(0.433420000000000))+(((x1061)*(x1076)))+(((IkReal(-0.374290000000000))*(x1055)*(x1070)))+(((IkReal(0.0100000000000000))*(x1057)*(x1073)))+(((IkReal(-1.00000000000000))*(r01)*(x1060)*(x1062)))+(((IkReal(-1.00000000000000))*(r00)*(x1060)*(x1070)))+(((IkReal(-1.00000000000000))*(px)*(x1080)))+(((r12)*(sj0)*(x1069)))+(((IkReal(-1.00000000000000))*(r11)*(x1062)*(x1076)))+(((cj0)*(r02)*(x1069)))+(((IkReal(-1.00000000000000))*(py)*(x1066)))+(((IkReal(0.0100000000000000))*(x1057)*(x1083)))+(((cj5)*(r02)*(x1060)))+(((x1055)*(x1086)))+(((x1075)*(x1086))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1087=((IkReal(1.00000000000000))*(cj4));
IkReal x1088=((cj6)*(r21));
IkReal x1089=((r20)*(sj6));
if( IKabs(((((sj5)*(x1089)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1088))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1087)))+(((IkReal(-1.00000000000000))*(cj5)*(x1087)*(x1089)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x1087)*(x1088)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x1089)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1088)))))+IKsqr(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1087)))+(((IkReal(-1.00000000000000))*(cj5)*(x1087)*(x1089)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x1087)*(x1088)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x1089)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1088)))), ((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1087)))+(((IkReal(-1.00000000000000))*(cj5)*(x1087)*(x1089)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x1087)*(x1088)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1090=IKcos(j3);
IkReal x1091=((IkReal(1.00000000000000))*(cj4));
IkReal x1092=((sj0)*(sj5));
IkReal x1093=((cj0)*(cj5));
IkReal x1094=((cj6)*(r01));
IkReal x1095=((r00)*(sj6));
IkReal x1096=((cj6)*(r11));
IkReal x1097=((cj5)*(sj0));
IkReal x1098=((cj6)*(sj4));
IkReal x1099=((sj4)*(sj6));
IkReal x1100=((cj4)*(cj5));
IkReal x1101=((cj6)*(r21));
IkReal x1102=((r20)*(sj6));
IkReal x1103=((r10)*(sj6));
IkReal x1104=((IkReal(1.00000000000000))*(IKsin(j3)));
IkReal x1105=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1104)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1102)))+(((sj5)*(x1101))));
evalcond[1]=((((r20)*(x1098)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r21)*(x1099)))+(x1090)+(((x1100)*(x1101)))+(((x1100)*(x1102))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1095)*(x1105)))+(((IkReal(-1.00000000000000))*(x1094)*(x1105)))+(((r02)*(x1093)))+(((IkReal(-1.00000000000000))*(x1092)*(x1103)))+(((IkReal(-1.00000000000000))*(x1092)*(x1096)))+(((r12)*(x1097)))+(((IkReal(-1.00000000000000))*(x1090))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1091)*(x1093)*(x1095)))+(((IkReal(-1.00000000000000))*(x1104)))+(((IkReal(-1.00000000000000))*(r12)*(x1091)*(x1092)))+(((IkReal(-1.00000000000000))*(x1091)*(x1093)*(x1094)))+(((cj0)*(r01)*(x1099)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x1091)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1098)))+(((IkReal(-1.00000000000000))*(x1091)*(x1097)*(x1103)))+(((r11)*(sj0)*(x1099)))+(((IkReal(-1.00000000000000))*(x1091)*(x1096)*(x1097)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1098))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x1106=((cj5)*(sj4));
IkReal x1107=((IkReal(1.00000000000000))*(sj6));
IkReal x1108=((r10)*(sj0));
IkReal x1109=((sj4)*(sj5));
IkReal x1110=((cj5)*(cj6));
IkReal x1111=((r01)*(sj0));
IkReal x1112=((IkReal(1.00000000000000))*(r02));
IkReal x1113=((IkReal(0.374290000000000))*(cj0));
IkReal x1114=((cj5)*(r12));
IkReal x1115=((cj6)*(sj5));
IkReal x1116=((cj0)*(r11));
IkReal x1117=((cj5)*(sj0));
IkReal x1118=((r20)*(sj6));
IkReal x1119=((IkReal(1.00000000000000))*(sj0));
IkReal x1120=((cj4)*(cj5));
IkReal x1121=((IkReal(1.00000000000000))*(cj6));
IkReal x1122=((IkReal(0.0100000000000000))*(sj5));
IkReal x1123=((sj5)*(sj6));
IkReal x1124=((cj0)*(r10));
IkReal x1125=((cj4)*(cj6));
IkReal x1126=((cj0)*(r01));
IkReal x1127=((IkReal(1.00000000000000))*(cj4));
IkReal x1128=((cj0)*(r00));
IkReal x1129=((IkReal(0.374290000000000))*(sj0));
IkReal x1130=((cj0)*(r12));
IkReal x1131=((IkReal(0.374290000000000))*(sj5));
IkReal x1132=((cj4)*(sj6));
IkReal x1133=((IkReal(1.00000000000000))*(cj0));
IkReal x1134=((r02)*(sj0));
IkReal x1135=((IkReal(0.0100000000000000))*(cj5));
IkReal x1136=((r11)*(sj0));
IkReal x1137=((r00)*(sj0)*(sj6));
IkReal x1138=((r00)*(x1125));
IkReal x1139=((sj6)*(x1135));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j2, IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x1132)))+(((cj6)*(r21)*(x1106)))+(((x1106)*(x1118)))+(((r22)*(x1109)))+(((IkReal(-1.00000000000000))*(cj4)*(r20)*(x1121))));
evalcond[2]=((IkReal(-0.0690000000000000))+(((IkReal(0.374290000000000))*(r21)*(x1115)))+(((IkReal(-0.0100000000000000))*(r21)*(x1110)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x1122)))+(((IkReal(-1.00000000000000))*(x1118)*(x1135)))+(((x1118)*(x1131))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x1107)*(x1124)))+(((x1111)*(x1115)))+(((IkReal(-1.00000000000000))*(x1115)*(x1116)))+(((r00)*(sj0)*(x1123)))+(((cj0)*(x1114)))+(((IkReal(-1.00000000000000))*(x1112)*(x1117))));
evalcond[4]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x1106)*(x1107)*(x1124)))+(((x1106)*(x1137)))+(((IkReal(-1.00000000000000))*(x1119)*(x1138)))+(((IkReal(-1.00000000000000))*(cj4)*(x1107)*(x1116)))+(((IkReal(-1.00000000000000))*(x1109)*(x1130)))+(((x1124)*(x1125)))+(((x1111)*(x1132)))+(((IkReal(-1.00000000000000))*(x1106)*(x1116)*(x1121)))+(((x1109)*(x1134)))+(((cj6)*(x1106)*(x1111))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj5)*(x1127)*(x1130)))+(((cj4)*(sj5)*(x1134)))+(((IkReal(-1.00000000000000))*(x1107)*(x1120)*(x1124)))+(((cj4)*(x1110)*(x1111)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((r00)*(x1117)*(x1132)))+(((sj4)*(sj6)*(x1116)))+(((IkReal(-1.00000000000000))*(sj4)*(x1107)*(x1111)))+(((IkReal(-1.00000000000000))*(sj4)*(x1121)*(x1124)))+(((IkReal(-1.00000000000000))*(x1110)*(x1116)*(x1127))));
evalcond[6]=((((x1108)*(x1125)))+(((IkReal(-1.00000000000000))*(cj4)*(x1107)*(x1136)))+(((x1125)*(x1128)))+(((IkReal(-1.00000000000000))*(x1106)*(x1107)*(x1108)))+(((IkReal(-1.00000000000000))*(cj4)*(x1107)*(x1126)))+(((IkReal(-1.00000000000000))*(x1106)*(x1121)*(x1126)))+(((IkReal(-1.00000000000000))*(x1106)*(x1107)*(x1128)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1106)*(x1119)))+(((IkReal(-1.00000000000000))*(r12)*(x1109)*(x1119)))+(((IkReal(-1.00000000000000))*(cj0)*(x1109)*(x1112))));
evalcond[7]=((((IkReal(-1.00000000000000))*(py)*(x1133)))+(((x1122)*(x1130)))+(((IkReal(-1.00000000000000))*(r11)*(x1113)*(x1115)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x1117)))+(((r00)*(x1123)*(x1129)))+(((IkReal(0.0100000000000000))*(x1110)*(x1116)))+(((IkReal(-1.00000000000000))*(r10)*(x1113)*(x1123)))+(((IkReal(-1.00000000000000))*(x1122)*(x1134)))+(((x1124)*(x1139)))+(((IkReal(0.374290000000000))*(x1111)*(x1115)))+(((px)*(sj0)))+(((x1113)*(x1114)))+(((IkReal(-0.0100000000000000))*(x1110)*(x1111)))+(((IkReal(-0.374290000000000))*(r02)*(x1117))));
evalcond[8]=((IkReal(0.433420000000000))+(((r12)*(sj0)*(x1122)))+(((x1114)*(x1129)))+(((IkReal(0.0100000000000000))*(x1110)*(x1136)))+(((x1128)*(x1139)))+(((IkReal(-0.374290000000000))*(x1108)*(x1123)))+(((IkReal(-1.00000000000000))*(r00)*(x1113)*(x1123)))+(((IkReal(-1.00000000000000))*(px)*(x1133)))+(((IkReal(-1.00000000000000))*(r11)*(x1115)*(x1129)))+(((IkReal(-1.00000000000000))*(py)*(x1119)))+(((cj0)*(r02)*(x1122)))+(((IkReal(-1.00000000000000))*(r01)*(x1113)*(x1115)))+(((x1108)*(x1139)))+(((cj5)*(r02)*(x1113)))+(((IkReal(0.0100000000000000))*(x1110)*(x1126))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1140=((IkReal(1.00000000000000))*(r21));
IkReal x1141=((cj4)*(cj5));
IkReal x1142=((r20)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x1142)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x1140)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj6)*(r20)*(sj4)))+(((x1141)*(x1142)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x1141)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x1140))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x1142)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x1140)))+(((cj5)*(r22)))))+IKsqr(((((cj6)*(r20)*(sj4)))+(((x1141)*(x1142)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x1141)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x1140)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x1142)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x1140)))+(((cj5)*(r22)))), ((((cj6)*(r20)*(sj4)))+(((x1141)*(x1142)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x1141)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x1140)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1143=IKsin(j3);
IkReal x1144=((IkReal(1.00000000000000))*(cj4));
IkReal x1145=((sj0)*(sj5));
IkReal x1146=((cj0)*(cj5));
IkReal x1147=((cj6)*(r01));
IkReal x1148=((r00)*(sj6));
IkReal x1149=((cj6)*(r11));
IkReal x1150=((cj5)*(sj0));
IkReal x1151=((cj6)*(sj4));
IkReal x1152=((sj4)*(sj6));
IkReal x1153=((cj4)*(cj5));
IkReal x1154=((cj6)*(r21));
IkReal x1155=((r20)*(sj6));
IkReal x1156=((r10)*(sj6));
IkReal x1157=((IkReal(1.00000000000000))*(IKcos(j3)));
IkReal x1158=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((x1143)+(((sj5)*(x1154)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1155))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(x1152)))+(((cj4)*(r22)*(sj5)))+(((x1153)*(x1154)))+(((x1153)*(x1155)))+(((r20)*(x1151)))+(((IkReal(-1.00000000000000))*(x1157))));
evalcond[2]=((((r02)*(x1146)))+(((IkReal(-1.00000000000000))*(x1145)*(x1149)))+(((IkReal(-1.00000000000000))*(x1148)*(x1158)))+(((IkReal(-1.00000000000000))*(x1145)*(x1156)))+(((r12)*(x1150)))+(((IkReal(-1.00000000000000))*(x1147)*(x1158)))+(((IkReal(-1.00000000000000))*(x1157))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r12)*(x1144)*(x1145)))+(((IkReal(-1.00000000000000))*(x1144)*(x1146)*(x1148)))+(((IkReal(-1.00000000000000))*(x1144)*(x1150)*(x1156)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1151)))+(((IkReal(-1.00000000000000))*(x1144)*(x1149)*(x1150)))+(((r11)*(sj0)*(x1152)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x1144)))+(((IkReal(-1.00000000000000))*(x1143)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1151)))+(((cj0)*(r01)*(x1152)))+(((IkReal(-1.00000000000000))*(x1144)*(x1146)*(x1147))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x1159=((IkReal(1.00000000000000))*(cj0));
IkReal x1160=((cj4)*(sj6));
IkReal x1161=((sj0)*(sj4));
IkReal x1162=((cj5)*(sj6));
IkReal x1163=((sj4)*(sj5));
IkReal x1164=((r12)*(sj5));
IkReal x1165=((IkReal(0.374290000000000))*(cj5));
IkReal x1166=((r02)*(sj0));
IkReal x1167=((r20)*(sj4));
IkReal x1168=((IkReal(1.00000000000000))*(sj0));
IkReal x1169=((IkReal(1.00000000000000))*(cj5));
IkReal x1170=((cj0)*(r10));
IkReal x1171=((cj4)*(cj6));
IkReal x1172=((r00)*(sj0));
IkReal x1173=((cj6)*(r21));
IkReal x1174=((IkReal(0.374290000000000))*(sj5));
IkReal x1175=((cj0)*(r00));
IkReal x1176=((IkReal(0.0100000000000000))*(sj5));
IkReal x1177=((cj0)*(r02));
IkReal x1178=((cj5)*(sj4));
IkReal x1179=((cj6)*(r01));
IkReal x1180=((cj6)*(r11));
IkReal x1181=((r01)*(sj0));
IkReal x1182=((r10)*(sj0));
IkReal x1183=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x1184=((sj6)*(x1174));
IkReal x1185=((cj0)*(cj6)*(x1174));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x1169)))+(((sj5)*(x1173)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(-1.00000000000000))+(((x1173)*(x1178)))+(((x1162)*(x1167)))+(((IkReal(-1.00000000000000))*(r20)*(x1171)))+(((r22)*(x1163)))+(((r21)*(x1160))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x1176)))+(((IkReal(-0.0100000000000000))*(r20)*(x1162)))+(((r20)*(x1184)))+(pz)+(((IkReal(-0.0100000000000000))*(cj5)*(x1173)))+(((x1173)*(x1174)))+(((IkReal(-1.00000000000000))*(r22)*(x1165))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj5)*(r20)*(x1160)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(x1167)))+(((cj5)*(r21)*(x1171))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r11)*(x1159)*(x1160)))+(((x1160)*(x1181)))+(((cj5)*(x1161)*(x1179)))+(((IkReal(-1.00000000000000))*(r00)*(x1168)*(x1171)))+(((r00)*(x1161)*(x1162)))+(((IkReal(-1.00000000000000))*(x1159)*(x1178)*(x1180)))+(((IkReal(-1.00000000000000))*(r12)*(x1159)*(x1163)))+(((r02)*(sj5)*(x1161)))+(((x1170)*(x1171)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x1159)*(x1162))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r10)*(x1161)*(x1162)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x1159)*(x1162)))+(((IkReal(-1.00000000000000))*(r01)*(x1159)*(x1160)))+(((IkReal(-1.00000000000000))*(x1161)*(x1169)*(x1180)))+(((x1171)*(x1175)))+(((IkReal(-1.00000000000000))*(x1161)*(x1164)))+(((x1171)*(x1182)))+(((IkReal(-1.00000000000000))*(x1159)*(x1178)*(x1179)))+(((IkReal(-1.00000000000000))*(r11)*(x1160)*(x1168)))+(((IkReal(-1.00000000000000))*(r02)*(x1159)*(x1163))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(py)*(x1159)))+(((IkReal(-1.00000000000000))*(x1166)*(x1176)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x1180)))+(((IkReal(0.0100000000000000))*(cj0)*(x1164)))+(((sj0)*(x1174)*(x1179)))+(((IkReal(0.0100000000000000))*(x1162)*(x1170)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x1179)))+(((IkReal(-1.00000000000000))*(x1165)*(x1166)))+(((x1172)*(x1184)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(x1174)*(x1180)))+(((cj0)*(r12)*(x1165)))+(((IkReal(-1.00000000000000))*(x1170)*(x1184)))+(((IkReal(-0.0100000000000000))*(x1162)*(x1172))));
evalcond[8]=((IkReal(0.433420000000000))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x1180)))+(((IkReal(-1.00000000000000))*(x1175)*(x1184)))+(((IkReal(-1.00000000000000))*(cj0)*(x1174)*(x1179)))+(((IkReal(0.0100000000000000))*(x1162)*(x1175)))+(((IkReal(-1.00000000000000))*(x1182)*(x1184)))+(((IkReal(0.0100000000000000))*(x1162)*(x1182)))+(((x1176)*(x1177)))+(((r12)*(sj0)*(x1165)))+(((IkReal(-1.00000000000000))*(px)*(x1159)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x1179)))+(((x1165)*(x1177)))+(((IkReal(-1.00000000000000))*(py)*(x1168)))+(((IkReal(0.0100000000000000))*(sj0)*(x1164)))+(((IkReal(-1.00000000000000))*(sj0)*(x1174)*(x1180))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1186=((cj0)*(cj5));
IkReal x1187=((IkReal(1.00000000000000))*(cj0));
IkReal x1188=((cj6)*(r11));
IkReal x1189=((r10)*(sj6));
IkReal x1190=((cj5)*(sj0));
IkReal x1191=((r00)*(sj5)*(sj6));
IkReal x1192=((cj6)*(r01)*(sj5));
IkReal x1193=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((sj0)*(x1192)))+(((IkReal(-1.00000000000000))*(sj5)*(x1187)*(x1188)))+(((IkReal(-1.00000000000000))*(sj5)*(x1187)*(x1189)))+(((IkReal(-1.00000000000000))*(r02)*(x1190)))+(((sj0)*(x1191)))+(((r12)*(x1186))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x1189)*(x1193)))+(((r02)*(x1186)))+(((IkReal(-1.00000000000000))*(x1188)*(x1193)))+(((IkReal(-1.00000000000000))*(x1187)*(x1191)))+(((r12)*(x1190)))+(((IkReal(-1.00000000000000))*(x1187)*(x1192))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj0)*(x1192)))+(((IkReal(-1.00000000000000))*(sj5)*(x1187)*(x1188)))+(((IkReal(-1.00000000000000))*(sj5)*(x1187)*(x1189)))+(((IkReal(-1.00000000000000))*(r02)*(x1190)))+(((sj0)*(x1191)))+(((r12)*(x1186)))))+IKsqr(((((IkReal(-1.00000000000000))*(x1189)*(x1193)))+(((r02)*(x1186)))+(((IkReal(-1.00000000000000))*(x1188)*(x1193)))+(((IkReal(-1.00000000000000))*(x1187)*(x1191)))+(((r12)*(x1190)))+(((IkReal(-1.00000000000000))*(x1187)*(x1192)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj0)*(x1192)))+(((IkReal(-1.00000000000000))*(sj5)*(x1187)*(x1188)))+(((IkReal(-1.00000000000000))*(sj5)*(x1187)*(x1189)))+(((IkReal(-1.00000000000000))*(r02)*(x1190)))+(((sj0)*(x1191)))+(((r12)*(x1186)))), ((((IkReal(-1.00000000000000))*(x1189)*(x1193)))+(((r02)*(x1186)))+(((IkReal(-1.00000000000000))*(x1188)*(x1193)))+(((IkReal(-1.00000000000000))*(x1187)*(x1191)))+(((r12)*(x1190)))+(((IkReal(-1.00000000000000))*(x1187)*(x1192)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1194=IKcos(j3);
IkReal x1195=((sj0)*(sj5));
IkReal x1196=((r00)*(sj6));
IkReal x1197=((cj6)*(sj0));
IkReal x1198=((IkReal(1.00000000000000))*(cj4));
IkReal x1199=((r00)*(sj4));
IkReal x1200=((cj0)*(cj5));
IkReal x1201=((cj5)*(sj0));
IkReal x1202=((cj6)*(r11));
IkReal x1203=((r10)*(sj6));
IkReal x1204=((cj0)*(sj5));
IkReal x1205=((r10)*(sj4));
IkReal x1206=((IkReal(1.00000000000000))*(IKsin(j3)));
IkReal x1207=((cj4)*(cj5)*(r01));
IkReal x1208=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x1209=((cj0)*(sj4)*(sj6));
IkReal x1210=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1203)*(x1204)))+(((x1195)*(x1196)))+(((r12)*(x1200)))+(((cj6)*(r01)*(x1195)))+(((IkReal(-1.00000000000000))*(x1206)))+(((IkReal(-1.00000000000000))*(x1202)*(x1204)))+(((IkReal(-1.00000000000000))*(r02)*(x1201))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1195)*(x1202)))+(((IkReal(-1.00000000000000))*(x1194)))+(((r02)*(x1200)))+(((IkReal(-1.00000000000000))*(x1195)*(x1203)))+(((IkReal(-1.00000000000000))*(x1196)*(x1204)))+(((r12)*(x1201)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1204))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1198)*(x1200)*(x1203)))+(((IkReal(-1.00000000000000))*(x1205)*(x1208)))+(((IkReal(-1.00000000000000))*(r12)*(x1198)*(x1204)))+(((r11)*(x1209)))+(((IkReal(-1.00000000000000))*(x1198)*(x1200)*(x1202)))+(((cj4)*(r02)*(x1195)))+(x1194)+(((x1197)*(x1207)))+(((IkReal(-1.00000000000000))*(r01)*(x1210)))+(((cj4)*(x1196)*(x1201)))+(((x1197)*(x1199))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r02)*(x1198)*(x1204)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1197)*(x1198)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1198)*(x1200)))+(((IkReal(-1.00000000000000))*(x1196)*(x1198)*(x1200)))+(((IkReal(-1.00000000000000))*(x1197)*(x1205)))+(((IkReal(-1.00000000000000))*(x1199)*(x1208)))+(((r01)*(x1209)))+(((IkReal(-1.00000000000000))*(x1198)*(x1201)*(x1203)))+(((IkReal(-1.00000000000000))*(x1206)))+(((IkReal(-1.00000000000000))*(r12)*(x1195)*(x1198)))+(((r11)*(x1210))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x1211=((IkReal(1.00000000000000))*(cj0));
IkReal x1212=((cj4)*(sj6));
IkReal x1213=((sj0)*(sj4));
IkReal x1214=((cj5)*(sj6));
IkReal x1215=((sj4)*(sj5));
IkReal x1216=((r12)*(sj5));
IkReal x1217=((IkReal(0.374290000000000))*(cj5));
IkReal x1218=((r02)*(sj0));
IkReal x1219=((r20)*(sj4));
IkReal x1220=((IkReal(1.00000000000000))*(sj0));
IkReal x1221=((IkReal(1.00000000000000))*(cj5));
IkReal x1222=((cj0)*(r10));
IkReal x1223=((cj4)*(cj6));
IkReal x1224=((r00)*(sj0));
IkReal x1225=((cj6)*(r21));
IkReal x1226=((IkReal(0.374290000000000))*(sj5));
IkReal x1227=((cj0)*(r00));
IkReal x1228=((IkReal(0.0100000000000000))*(sj5));
IkReal x1229=((cj0)*(r02));
IkReal x1230=((cj5)*(sj4));
IkReal x1231=((cj6)*(r01));
IkReal x1232=((cj6)*(r11));
IkReal x1233=((r01)*(sj0));
IkReal x1234=((r10)*(sj0));
IkReal x1235=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x1236=((sj6)*(x1226));
IkReal x1237=((cj0)*(cj6)*(x1226));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x1225)))+(((IkReal(-1.00000000000000))*(r22)*(x1221)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r20)*(x1223)))+(((x1225)*(x1230)))+(((r21)*(x1212)))+(((r22)*(x1215)))+(((x1214)*(x1219))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x1217)))+(((IkReal(-0.0100000000000000))*(r20)*(x1214)))+(((r20)*(x1236)))+(((IkReal(-1.00000000000000))*(r22)*(x1228)))+(((x1225)*(x1226)))+(pz)+(((IkReal(-0.0100000000000000))*(cj5)*(x1225))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(x1219)))+(((cj5)*(r20)*(x1212)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r21)*(x1223))));
evalcond[5]=((((r00)*(x1213)*(x1214)))+(((IkReal(-1.00000000000000))*(r12)*(x1211)*(x1215)))+(((IkReal(-1.00000000000000))*(x1211)*(x1230)*(x1232)))+(((IkReal(-1.00000000000000))*(r00)*(x1220)*(x1223)))+(((r02)*(sj5)*(x1213)))+(((x1212)*(x1233)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x1211)*(x1214)))+(((cj5)*(x1213)*(x1231)))+(((IkReal(-1.00000000000000))*(r11)*(x1211)*(x1212)))+(((x1222)*(x1223))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x1211)*(x1230)*(x1231)))+(((IkReal(-1.00000000000000))*(r11)*(x1212)*(x1220)))+(((x1223)*(x1227)))+(((x1223)*(x1234)))+(((IkReal(-1.00000000000000))*(x1213)*(x1216)))+(((IkReal(-1.00000000000000))*(r02)*(x1211)*(x1215)))+(((IkReal(-1.00000000000000))*(r10)*(x1213)*(x1214)))+(((IkReal(-1.00000000000000))*(x1213)*(x1221)*(x1232)))+(((IkReal(-1.00000000000000))*(r01)*(x1211)*(x1212)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x1211)*(x1214))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((cj0)*(r12)*(x1217)))+(((IkReal(-1.00000000000000))*(cj0)*(x1226)*(x1232)))+(((x1224)*(x1236)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x1232)))+(((IkReal(0.0100000000000000))*(cj0)*(x1216)))+(((IkReal(-1.00000000000000))*(py)*(x1211)))+(((IkReal(-1.00000000000000))*(x1217)*(x1218)))+(((IkReal(-0.0100000000000000))*(x1214)*(x1224)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x1231)))+(((IkReal(-1.00000000000000))*(x1218)*(x1228)))+(((px)*(sj0)))+(((IkReal(0.0100000000000000))*(x1214)*(x1222)))+(((IkReal(-1.00000000000000))*(x1222)*(x1236)))+(((sj0)*(x1226)*(x1231))));
evalcond[8]=((IkReal(0.433420000000000))+(((IkReal(-1.00000000000000))*(cj0)*(x1226)*(x1231)))+(((IkReal(-1.00000000000000))*(sj0)*(x1226)*(x1232)))+(((IkReal(-1.00000000000000))*(x1227)*(x1236)))+(((IkReal(0.0100000000000000))*(sj0)*(x1216)))+(((IkReal(0.0100000000000000))*(x1214)*(x1234)))+(((IkReal(-1.00000000000000))*(py)*(x1220)))+(((x1217)*(x1229)))+(((IkReal(-1.00000000000000))*(px)*(x1211)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x1231)))+(((IkReal(0.0100000000000000))*(x1214)*(x1227)))+(((IkReal(-1.00000000000000))*(x1234)*(x1236)))+(((x1228)*(x1229)))+(((r12)*(sj0)*(x1217)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x1232))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1238=((cj5)*(r02));
IkReal x1239=((cj0)*(sj5));
IkReal x1240=((r10)*(sj6));
IkReal x1241=((IkReal(1.00000000000000))*(cj6));
IkReal x1242=((sj0)*(sj5));
IkReal x1243=((cj5)*(r12));
IkReal x1244=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj0)*(x1243)))+(((IkReal(-1.00000000000000))*(r01)*(x1241)*(x1242)))+(((IkReal(-1.00000000000000))*(x1242)*(x1244)))+(((x1239)*(x1240)))+(((cj6)*(r11)*(x1239)))+(((sj0)*(x1238))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x1240)*(x1242)))+(((IkReal(-1.00000000000000))*(r01)*(x1239)*(x1241)))+(((IkReal(-1.00000000000000))*(r11)*(x1241)*(x1242)))+(((IkReal(-1.00000000000000))*(x1239)*(x1244)))+(((sj0)*(x1243)))+(((cj0)*(x1238))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj0)*(x1243)))+(((IkReal(-1.00000000000000))*(r01)*(x1241)*(x1242)))+(((IkReal(-1.00000000000000))*(x1242)*(x1244)))+(((x1239)*(x1240)))+(((cj6)*(r11)*(x1239)))+(((sj0)*(x1238)))))+IKsqr(((((IkReal(-1.00000000000000))*(x1240)*(x1242)))+(((IkReal(-1.00000000000000))*(r01)*(x1239)*(x1241)))+(((IkReal(-1.00000000000000))*(r11)*(x1241)*(x1242)))+(((IkReal(-1.00000000000000))*(x1239)*(x1244)))+(((sj0)*(x1243)))+(((cj0)*(x1238)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj0)*(x1243)))+(((IkReal(-1.00000000000000))*(r01)*(x1241)*(x1242)))+(((IkReal(-1.00000000000000))*(x1242)*(x1244)))+(((x1239)*(x1240)))+(((cj6)*(r11)*(x1239)))+(((sj0)*(x1238)))), ((((IkReal(-1.00000000000000))*(x1240)*(x1242)))+(((IkReal(-1.00000000000000))*(r01)*(x1239)*(x1241)))+(((IkReal(-1.00000000000000))*(r11)*(x1241)*(x1242)))+(((IkReal(-1.00000000000000))*(x1239)*(x1244)))+(((sj0)*(x1243)))+(((cj0)*(x1238)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1245=IKsin(j3);
IkReal x1246=((sj0)*(sj5));
IkReal x1247=((r00)*(sj6));
IkReal x1248=((IkReal(1.00000000000000))*(cj4));
IkReal x1249=((cj6)*(sj0));
IkReal x1250=((r00)*(sj4));
IkReal x1251=((cj0)*(cj5));
IkReal x1252=((cj6)*(r01));
IkReal x1253=((cj5)*(sj0));
IkReal x1254=((cj0)*(sj5));
IkReal x1255=((cj6)*(r11));
IkReal x1256=((r10)*(sj6));
IkReal x1257=((r10)*(sj4));
IkReal x1258=((IkReal(1.00000000000000))*(IKcos(j3)));
IkReal x1259=((cj0)*(sj4)*(sj6));
IkReal x1260=((sj0)*(sj4)*(sj6));
IkReal x1261=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((((x1246)*(x1252)))+(((r12)*(x1251)))+(((IkReal(-1.00000000000000))*(x1254)*(x1255)))+(((IkReal(-1.00000000000000))*(r02)*(x1253)))+(x1245)+(((IkReal(-1.00000000000000))*(x1254)*(x1256)))+(((x1246)*(x1247))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1252)*(x1254)))+(((IkReal(-1.00000000000000))*(x1246)*(x1256)))+(((r12)*(x1253)))+(((IkReal(-1.00000000000000))*(x1247)*(x1254)))+(((IkReal(-1.00000000000000))*(x1246)*(x1255)))+(((r02)*(x1251)))+(((IkReal(-1.00000000000000))*(x1258))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1257)*(x1261)))+(((IkReal(-1.00000000000000))*(r01)*(x1260)))+(((x1249)*(x1250)))+(((IkReal(-1.00000000000000))*(r12)*(x1248)*(x1254)))+(((IkReal(-1.00000000000000))*(x1248)*(x1251)*(x1255)))+(((cj4)*(x1247)*(x1253)))+(((cj4)*(r02)*(x1246)))+(((cj4)*(cj5)*(r01)*(x1249)))+(((IkReal(-1.00000000000000))*(x1248)*(x1251)*(x1256)))+(((r11)*(x1259)))+(((IkReal(-1.00000000000000))*(x1258))));
evalcond[3]=((((r01)*(x1259)))+(((r11)*(x1260)))+(((IkReal(-1.00000000000000))*(x1250)*(x1261)))+(((IkReal(-1.00000000000000))*(x1245)))+(((IkReal(-1.00000000000000))*(x1247)*(x1248)*(x1251)))+(((IkReal(-1.00000000000000))*(r12)*(x1246)*(x1248)))+(((IkReal(-1.00000000000000))*(x1248)*(x1251)*(x1252)))+(((IkReal(-1.00000000000000))*(x1249)*(x1257)))+(((IkReal(-1.00000000000000))*(x1248)*(x1253)*(x1256)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1248)*(x1249)))+(((IkReal(-1.00000000000000))*(r02)*(x1248)*(x1254))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1262=((cj0)*(cj5));
IkReal x1263=((IkReal(1.00000000000000))*(cj0));
IkReal x1264=((cj6)*(r11));
IkReal x1265=((r10)*(sj6));
IkReal x1266=((cj5)*(sj0));
IkReal x1267=((r00)*(sj5)*(sj6));
IkReal x1268=((cj6)*(r01)*(sj5));
IkReal x1269=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r12)*(x1262)))+(((IkReal(-1.00000000000000))*(r02)*(x1266)))+(((IkReal(-1.00000000000000))*(sj5)*(x1263)*(x1265)))+(((IkReal(-1.00000000000000))*(sj5)*(x1263)*(x1264)))+(((sj0)*(x1268)))+(((sj0)*(x1267))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x1264)*(x1269)))+(((IkReal(-1.00000000000000))*(x1265)*(x1269)))+(((IkReal(-1.00000000000000))*(x1263)*(x1267)))+(((r12)*(x1266)))+(((IkReal(-1.00000000000000))*(x1263)*(x1268)))+(((r02)*(x1262))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r12)*(x1262)))+(((IkReal(-1.00000000000000))*(r02)*(x1266)))+(((IkReal(-1.00000000000000))*(sj5)*(x1263)*(x1265)))+(((IkReal(-1.00000000000000))*(sj5)*(x1263)*(x1264)))+(((sj0)*(x1268)))+(((sj0)*(x1267)))))))+IKsqr(((((IkReal(-1.00000000000000))*(x1264)*(x1269)))+(((IkReal(-1.00000000000000))*(x1265)*(x1269)))+(((IkReal(-1.00000000000000))*(x1263)*(x1267)))+(((r12)*(x1266)))+(((IkReal(-1.00000000000000))*(x1263)*(x1268)))+(((r02)*(x1262)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r12)*(x1262)))+(((IkReal(-1.00000000000000))*(r02)*(x1266)))+(((IkReal(-1.00000000000000))*(sj5)*(x1263)*(x1265)))+(((IkReal(-1.00000000000000))*(sj5)*(x1263)*(x1264)))+(((sj0)*(x1268)))+(((sj0)*(x1267)))))), ((((IkReal(-1.00000000000000))*(x1264)*(x1269)))+(((IkReal(-1.00000000000000))*(x1265)*(x1269)))+(((IkReal(-1.00000000000000))*(x1263)*(x1267)))+(((r12)*(x1266)))+(((IkReal(-1.00000000000000))*(x1263)*(x1268)))+(((r02)*(x1262)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1270=IKsin(j3);
IkReal x1271=IKcos(j3);
IkReal x1272=((sj0)*(sj5));
IkReal x1273=((r00)*(sj6));
IkReal x1274=((IkReal(1.00000000000000))*(cj4));
IkReal x1275=((cj6)*(r01));
IkReal x1276=((cj0)*(cj5));
IkReal x1277=((cj5)*(sj0));
IkReal x1278=((cj6)*(r11));
IkReal x1279=((cj0)*(sj5));
IkReal x1280=((cj6)*(sj4));
IkReal x1281=((cj4)*(cj5));
IkReal x1282=((cj6)*(r21));
IkReal x1283=((r20)*(sj6));
IkReal x1284=((r10)*(sj6));
IkReal x1285=((IkReal(1.00000000000000))*(cj0));
IkReal x1286=((IkReal(1.00000000000000))*(x1270));
IkReal x1287=((cj0)*(sj4)*(sj6));
IkReal x1288=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x1282)))+(((sj5)*(x1283)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj2)*(x1286))));
evalcond[1]=((((cj2)*(x1271)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x1281)*(x1283)))+(((x1281)*(x1282)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x1280))));
evalcond[2]=((((r12)*(x1276)))+(((x1272)*(x1275)))+(((IkReal(-1.00000000000000))*(x1279)*(x1284)))+(((IkReal(-1.00000000000000))*(sj2)*(x1286)))+(((x1272)*(x1273)))+(((IkReal(-1.00000000000000))*(x1278)*(x1279)))+(((IkReal(-1.00000000000000))*(r02)*(x1277))));
evalcond[3]=((((r12)*(x1277)))+(((IkReal(-1.00000000000000))*(x1272)*(x1284)))+(((IkReal(-1.00000000000000))*(x1275)*(x1279)))+(((IkReal(-1.00000000000000))*(x1271)))+(((r02)*(x1276)))+(((IkReal(-1.00000000000000))*(x1272)*(x1278)))+(((IkReal(-1.00000000000000))*(x1273)*(x1279))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1274)*(x1276)*(x1278)))+(((IkReal(-1.00000000000000))*(r01)*(x1288)))+(((cj4)*(x1275)*(x1277)))+(((cj4)*(x1273)*(x1277)))+(((r00)*(sj0)*(x1280)))+(((IkReal(-1.00000000000000))*(r10)*(x1280)*(x1285)))+(((r11)*(x1287)))+(((IkReal(-1.00000000000000))*(r12)*(x1274)*(x1279)))+(((cj4)*(r02)*(x1272)))+(((sj2)*(x1271)))+(((IkReal(-1.00000000000000))*(x1274)*(x1276)*(x1284))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1286)))+(((IkReal(-1.00000000000000))*(x1274)*(x1277)*(x1278)))+(((IkReal(-1.00000000000000))*(x1273)*(x1274)*(x1276)))+(((r11)*(x1288)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1280)))+(((r01)*(x1287)))+(((IkReal(-1.00000000000000))*(x1274)*(x1277)*(x1284)))+(((IkReal(-1.00000000000000))*(r02)*(x1274)*(x1279)))+(((IkReal(-1.00000000000000))*(x1274)*(x1275)*(x1276)))+(((IkReal(-1.00000000000000))*(r00)*(x1280)*(x1285)))+(((IkReal(-1.00000000000000))*(r12)*(x1272)*(x1274))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1289=((sj5)*(sj6));
IkReal x1290=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((r20)*(x1289)))+(((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1289)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x1290)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1289)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x1290))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((r20)*(x1289)))+(((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))))+IKsqr(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1289)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x1290)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1289)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x1290)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((r20)*(x1289)))+(((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))), ((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1289)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x1290)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1289)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x1290)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1291=IKsin(j3);
IkReal x1292=IKcos(j3);
IkReal x1293=((sj0)*(sj5));
IkReal x1294=((r00)*(sj6));
IkReal x1295=((IkReal(1.00000000000000))*(cj4));
IkReal x1296=((cj6)*(r01));
IkReal x1297=((cj0)*(cj5));
IkReal x1298=((cj5)*(sj0));
IkReal x1299=((cj6)*(r11));
IkReal x1300=((cj0)*(sj5));
IkReal x1301=((cj6)*(sj4));
IkReal x1302=((cj4)*(cj5));
IkReal x1303=((cj6)*(r21));
IkReal x1304=((r20)*(sj6));
IkReal x1305=((r10)*(sj6));
IkReal x1306=((IkReal(1.00000000000000))*(cj0));
IkReal x1307=((IkReal(1.00000000000000))*(x1291));
IkReal x1308=((cj0)*(sj4)*(sj6));
IkReal x1309=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj2)*(x1307)))+(((sj5)*(x1304)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1303))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((x1302)*(x1303)))+(((r20)*(x1301)))+(((cj2)*(x1292)))+(((x1302)*(x1304))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1300)*(x1305)))+(((r12)*(x1297)))+(((IkReal(-1.00000000000000))*(sj2)*(x1307)))+(((IkReal(-1.00000000000000))*(r02)*(x1298)))+(((x1293)*(x1294)))+(((IkReal(-1.00000000000000))*(x1299)*(x1300)))+(((x1293)*(x1296))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1292)))+(((IkReal(-1.00000000000000))*(x1293)*(x1305)))+(((IkReal(-1.00000000000000))*(x1293)*(x1299)))+(((IkReal(-1.00000000000000))*(x1296)*(x1300)))+(((r12)*(x1298)))+(((IkReal(-1.00000000000000))*(x1294)*(x1300)))+(((r02)*(x1297))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r10)*(x1301)*(x1306)))+(((cj4)*(r02)*(x1293)))+(((IkReal(-1.00000000000000))*(x1295)*(x1297)*(x1305)))+(((r00)*(sj0)*(x1301)))+(((IkReal(-1.00000000000000))*(x1295)*(x1297)*(x1299)))+(((cj4)*(x1296)*(x1298)))+(((IkReal(-1.00000000000000))*(r12)*(x1295)*(x1300)))+(((r11)*(x1308)))+(((cj4)*(x1294)*(x1298)))+(((sj2)*(x1292)))+(((IkReal(-1.00000000000000))*(r01)*(x1309))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r02)*(x1295)*(x1300)))+(((IkReal(-1.00000000000000))*(x1295)*(x1298)*(x1299)))+(((IkReal(-1.00000000000000))*(x1295)*(x1298)*(x1305)))+(((IkReal(-1.00000000000000))*(r00)*(x1301)*(x1306)))+(((IkReal(-1.00000000000000))*(r12)*(x1293)*(x1295)))+(((IkReal(-1.00000000000000))*(x1294)*(x1295)*(x1297)))+(((IkReal(-1.00000000000000))*(x1295)*(x1296)*(x1297)))+(((IkReal(-1.00000000000000))*(x1307)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1301)))+(((r11)*(x1309)))+(((r01)*(x1308))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1310=((IkReal(1.00000000000000))*(cj4));
IkReal x1311=((cj6)*(r21));
IkReal x1312=((r20)*(sj6));
if( IKabs(((gconst43)*(((((sj5)*(x1311)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1312))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst43)*(((((IkReal(-1.00000000000000))*(cj5)*(x1310)*(x1312)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x1310)*(x1311)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1310)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst43)*(((((sj5)*(x1311)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1312)))))), ((gconst43)*(((((IkReal(-1.00000000000000))*(cj5)*(x1310)*(x1312)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(x1310)*(x1311)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1310)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1313=IKsin(j3);
IkReal x1314=IKcos(j3);
IkReal x1315=((sj0)*(sj5));
IkReal x1316=((r00)*(sj6));
IkReal x1317=((IkReal(1.00000000000000))*(cj4));
IkReal x1318=((cj6)*(r01));
IkReal x1319=((cj0)*(cj5));
IkReal x1320=((cj5)*(sj0));
IkReal x1321=((cj6)*(r11));
IkReal x1322=((cj0)*(sj5));
IkReal x1323=((cj6)*(sj4));
IkReal x1324=((cj4)*(cj5));
IkReal x1325=((cj6)*(r21));
IkReal x1326=((r20)*(sj6));
IkReal x1327=((r10)*(sj6));
IkReal x1328=((IkReal(1.00000000000000))*(cj0));
IkReal x1329=((IkReal(1.00000000000000))*(x1313));
IkReal x1330=((cj0)*(sj4)*(sj6));
IkReal x1331=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x1325)))+(((sj5)*(x1326)))+(((IkReal(-1.00000000000000))*(cj2)*(x1329))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x1324)*(x1325)))+(((r20)*(x1323)))+(((cj2)*(x1314)))+(((cj4)*(r22)*(sj5)))+(((x1324)*(x1326))));
evalcond[2]=((((x1315)*(x1318)))+(((r12)*(x1319)))+(((IkReal(-1.00000000000000))*(x1321)*(x1322)))+(((IkReal(-1.00000000000000))*(sj2)*(x1329)))+(((IkReal(-1.00000000000000))*(x1322)*(x1327)))+(((x1315)*(x1316)))+(((IkReal(-1.00000000000000))*(r02)*(x1320))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1316)*(x1322)))+(((IkReal(-1.00000000000000))*(x1315)*(x1321)))+(((r12)*(x1320)))+(((IkReal(-1.00000000000000))*(x1314)))+(((IkReal(-1.00000000000000))*(x1318)*(x1322)))+(((IkReal(-1.00000000000000))*(x1315)*(x1327)))+(((r02)*(x1319))));
evalcond[4]=((((cj4)*(r02)*(x1315)))+(((IkReal(-1.00000000000000))*(x1317)*(x1319)*(x1321)))+(((cj4)*(x1316)*(x1320)))+(((r11)*(x1330)))+(((IkReal(-1.00000000000000))*(r12)*(x1317)*(x1322)))+(((IkReal(-1.00000000000000))*(x1317)*(x1319)*(x1327)))+(((cj4)*(x1318)*(x1320)))+(((sj2)*(x1314)))+(((IkReal(-1.00000000000000))*(r01)*(x1331)))+(((IkReal(-1.00000000000000))*(r10)*(x1323)*(x1328)))+(((r00)*(sj0)*(x1323))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1323)))+(((IkReal(-1.00000000000000))*(x1317)*(x1320)*(x1327)))+(((IkReal(-1.00000000000000))*(r12)*(x1315)*(x1317)))+(((r11)*(x1331)))+(((IkReal(-1.00000000000000))*(x1317)*(x1320)*(x1321)))+(((r01)*(x1330)))+(((IkReal(-1.00000000000000))*(r02)*(x1317)*(x1322)))+(((IkReal(-1.00000000000000))*(r00)*(x1323)*(x1328)))+(((IkReal(-1.00000000000000))*(x1316)*(x1317)*(x1319)))+(((IkReal(-1.00000000000000))*(x1329)))+(((IkReal(-1.00000000000000))*(x1317)*(x1318)*(x1319))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

} else
{
IkReal x1332=((cj0)*(cj5));
IkReal x1333=((IkReal(0.374290000000000))*(sj0));
IkReal x1334=((cj6)*(r11));
IkReal x1335=((IkReal(0.0100000000000000))*(sj6));
IkReal x1336=((cj6)*(r01));
IkReal x1337=((IkReal(0.0100000000000000))*(sj0));
IkReal x1338=((cj0)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j1, IkReal(6.28318530717959))));
evalcond[1]=((IkReal(-0.295420000000000))+(((IkReal(-1.00000000000000))*(sj5)*(x1333)*(x1334)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((cj5)*(x1334)*(x1337)))+(((r00)*(x1332)*(x1335)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(sj6)*(x1333)))+(((IkReal(-0.374290000000000))*(x1336)*(x1338)))+(((IkReal(0.0100000000000000))*(x1332)*(x1336)))+(((cj5)*(r12)*(x1333)))+(((r12)*(sj5)*(x1337)))+(((IkReal(-0.374290000000000))*(r00)*(sj6)*(x1338)))+(((IkReal(0.0100000000000000))*(r02)*(x1338)))+(((IkReal(-1.00000000000000))*(py)*(sj0)))+(((IkReal(0.374290000000000))*(r02)*(x1332)))+(((cj5)*(r10)*(sj0)*(x1335))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1339=((cj0)*(r11));
IkReal x1340=((r01)*(sj0));
IkReal x1341=((r20)*(sj6));
IkReal x1342=((IkReal(0.144927536231884))*(cj5));
IkReal x1343=((IkReal(5.42449275362319))*(cj5));
IkReal x1344=((IkReal(5.42449275362319))*(sj5));
IkReal x1345=((IkReal(0.144927536231884))*(sj5));
IkReal x1346=((cj0)*(r12));
IkReal x1347=((r02)*(sj0));
IkReal x1348=((cj6)*(x1344));
IkReal x1349=((cj0)*(r10)*(sj6));
IkReal x1350=((r00)*(sj0)*(sj6));
if( IKabs(((((x1344)*(x1349)))+(((x1342)*(x1350)))+(((x1345)*(x1347)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-1.00000000000000))*(x1344)*(x1350)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((cj6)*(x1340)*(x1342)))+(((IkReal(-1.00000000000000))*(x1342)*(x1349)))+(((IkReal(-1.00000000000000))*(cj6)*(x1339)*(x1342)))+(((IkReal(-1.00000000000000))*(x1345)*(x1346)))+(((x1339)*(x1348)))+(((x1343)*(x1347)))+(((IkReal(-1.00000000000000))*(x1343)*(x1346)))+(((IkReal(-1.00000000000000))*(x1340)*(x1348))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x1341)*(x1344)))+(((IkReal(-1.00000000000000))*(r22)*(x1343)))+(((IkReal(14.4927536231884))*(pz)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1342)))+(((r21)*(x1348)))+(((IkReal(-1.00000000000000))*(x1341)*(x1342)))+(((IkReal(-1.00000000000000))*(r22)*(x1345))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((x1344)*(x1349)))+(((x1342)*(x1350)))+(((x1345)*(x1347)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-1.00000000000000))*(x1344)*(x1350)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((cj6)*(x1340)*(x1342)))+(((IkReal(-1.00000000000000))*(x1342)*(x1349)))+(((IkReal(-1.00000000000000))*(cj6)*(x1339)*(x1342)))+(((IkReal(-1.00000000000000))*(x1345)*(x1346)))+(((x1339)*(x1348)))+(((x1343)*(x1347)))+(((IkReal(-1.00000000000000))*(x1343)*(x1346)))+(((IkReal(-1.00000000000000))*(x1340)*(x1348)))))+IKsqr(((((x1341)*(x1344)))+(((IkReal(-1.00000000000000))*(r22)*(x1343)))+(((IkReal(14.4927536231884))*(pz)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1342)))+(((r21)*(x1348)))+(((IkReal(-1.00000000000000))*(x1341)*(x1342)))+(((IkReal(-1.00000000000000))*(r22)*(x1345)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((x1344)*(x1349)))+(((x1342)*(x1350)))+(((x1345)*(x1347)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-1.00000000000000))*(x1344)*(x1350)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((cj6)*(x1340)*(x1342)))+(((IkReal(-1.00000000000000))*(x1342)*(x1349)))+(((IkReal(-1.00000000000000))*(cj6)*(x1339)*(x1342)))+(((IkReal(-1.00000000000000))*(x1345)*(x1346)))+(((x1339)*(x1348)))+(((x1343)*(x1347)))+(((IkReal(-1.00000000000000))*(x1343)*(x1346)))+(((IkReal(-1.00000000000000))*(x1340)*(x1348)))), ((((x1341)*(x1344)))+(((IkReal(-1.00000000000000))*(r22)*(x1343)))+(((IkReal(14.4927536231884))*(pz)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1342)))+(((r21)*(x1348)))+(((IkReal(-1.00000000000000))*(x1341)*(x1342)))+(((IkReal(-1.00000000000000))*(r22)*(x1345)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x1351=((cj6)*(r11));
IkReal x1352=((IkReal(0.374290000000000))*(sj0));
IkReal x1353=((IkReal(0.0100000000000000))*(cj5));
IkReal x1354=((cj6)*(r21));
IkReal x1355=((r10)*(sj6));
IkReal x1356=((IkReal(0.374290000000000))*(sj5));
IkReal x1357=((IkReal(0.0100000000000000))*(sj5));
IkReal x1358=((cj6)*(r01));
IkReal x1359=((r20)*(sj6));
IkReal x1360=((IkReal(0.374290000000000))*(cj5));
IkReal x1361=((cj0)*(r12));
IkReal x1362=((r00)*(sj6));
IkReal x1363=((cj0)*(x1356));
evalcond[0]=((((IkReal(-1.00000000000000))*(r22)*(x1360)))+(((IkReal(-0.0690000000000000))*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(x1353)*(x1359)))+(((x1356)*(x1359)))+(((IkReal(-1.00000000000000))*(r22)*(x1357)))+(((IkReal(-1.00000000000000))*(x1353)*(x1354)))+(pz)+(((x1354)*(x1356))));
evalcond[1]=((((cj0)*(x1351)*(x1353)))+(((IkReal(-1.00000000000000))*(x1355)*(x1363)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(x1352)))+(((IkReal(-1.00000000000000))*(cj0)*(py)))+(((cj0)*(x1353)*(x1355)))+(((IkReal(-1.00000000000000))*(sj0)*(x1353)*(x1358)))+(((IkReal(-1.00000000000000))*(sj0)*(x1353)*(x1362)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1357)))+(((IkReal(0.0690000000000000))*(IKsin(j2))))+(((sj5)*(x1352)*(x1358)))+(((x1357)*(x1361)))+(((x1360)*(x1361)))+(((sj5)*(x1352)*(x1362)))+(((IkReal(-1.00000000000000))*(x1351)*(x1363)))+(((px)*(sj0))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst53;
IkReal x1364=(cj6)*(cj6);
IkReal x1365=(sj6)*(sj6);
IkReal x1366=((sj5)*(sj6));
IkReal x1367=((IkReal(1.00000000000000))*(cj0));
IkReal x1368=((cj6)*(sj5));
IkReal x1369=((r20)*(sj0));
IkReal x1370=((cj0)*(r20));
IkReal x1371=((r00)*(r21));
IkReal x1372=((r22)*(sj0));
IkReal x1373=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x1374=((cj5)*(x1365));
IkReal x1375=((cj5)*(x1364));
gconst53=IKsign(((((r11)*(x1369)*(x1375)))+(((IkReal(-1.00000000000000))*(x1367)*(x1371)*(x1375)))+(((cj0)*(r01)*(r22)*(x1366)))+(((IkReal(-1.00000000000000))*(r10)*(x1373)*(x1374)))+(((r01)*(x1370)*(x1374)))+(((r01)*(x1370)*(x1375)))+(((r11)*(x1366)*(x1372)))+(((r11)*(x1369)*(x1374)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x1367)*(x1368)))+(((IkReal(-1.00000000000000))*(r10)*(x1373)*(x1375)))+(((r12)*(x1368)*(x1369)))+(((r02)*(x1368)*(x1370)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x1366)*(x1367)))+(((IkReal(-1.00000000000000))*(r12)*(x1366)*(x1373)))+(((IkReal(-1.00000000000000))*(r10)*(x1368)*(x1372)))+(((IkReal(-1.00000000000000))*(x1367)*(x1371)*(x1374)))));
IkReal x1376=(cj6)*(cj6);
IkReal x1377=(sj6)*(sj6);
IkReal x1378=((sj5)*(sj6));
IkReal x1379=((IkReal(1.00000000000000))*(cj0));
IkReal x1380=((cj6)*(sj5));
IkReal x1381=((r20)*(sj0));
IkReal x1382=((cj0)*(r20));
IkReal x1383=((r00)*(r21));
IkReal x1384=((r22)*(sj0));
IkReal x1385=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x1386=((cj5)*(x1377));
IkReal x1387=((cj5)*(x1376));
dummyeval[0]=((((r01)*(x1382)*(x1386)))+(((IkReal(-1.00000000000000))*(r10)*(x1385)*(x1387)))+(((r02)*(x1380)*(x1382)))+(((IkReal(-1.00000000000000))*(x1379)*(x1383)*(x1387)))+(((cj0)*(r01)*(r22)*(x1378)))+(((r11)*(x1381)*(x1386)))+(((r11)*(x1381)*(x1387)))+(((IkReal(-1.00000000000000))*(r10)*(x1385)*(x1386)))+(((r11)*(x1378)*(x1384)))+(((IkReal(-1.00000000000000))*(r12)*(x1378)*(x1385)))+(((IkReal(-1.00000000000000))*(r10)*(x1380)*(x1384)))+(((r12)*(x1380)*(x1381)))+(((IkReal(-1.00000000000000))*(x1379)*(x1383)*(x1386)))+(((r01)*(x1382)*(x1387)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x1379)*(x1380)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x1378)*(x1379))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst52;
IkReal x1388=(cj6)*(cj6);
IkReal x1389=(sj6)*(sj6);
IkReal x1390=((IkReal(1.00000000000000))*(r01));
IkReal x1391=((sj0)*(sj5));
IkReal x1392=((cj6)*(r22));
IkReal x1393=((r21)*(sj6));
IkReal x1394=((r00)*(r21));
IkReal x1395=((cj0)*(sj5));
IkReal x1396=((cj6)*(r20));
IkReal x1397=((r22)*(sj6));
IkReal x1398=((cj0)*(cj5));
IkReal x1399=((IkReal(1.00000000000000))*(r10));
IkReal x1400=((cj5)*(sj0));
IkReal x1401=((r20)*(x1389));
IkReal x1402=((x1388)*(x1400));
gconst52=IKsign(((((r11)*(x1395)*(x1397)))+(((r11)*(x1398)*(x1401)))+(((IkReal(-1.00000000000000))*(r12)*(x1393)*(x1395)))+(((IkReal(-1.00000000000000))*(x1390)*(x1391)*(x1397)))+(((r00)*(x1391)*(x1392)))+(((r12)*(x1395)*(x1396)))+(((r02)*(x1391)*(x1393)))+(((x1394)*(x1402)))+(((IkReal(-1.00000000000000))*(x1390)*(x1400)*(x1401)))+(((IkReal(-1.00000000000000))*(r02)*(x1391)*(x1396)))+(((IkReal(-1.00000000000000))*(r21)*(x1388)*(x1398)*(x1399)))+(((IkReal(-1.00000000000000))*(x1392)*(x1395)*(x1399)))+(((IkReal(-1.00000000000000))*(r20)*(x1390)*(x1402)))+(((x1389)*(x1394)*(x1400)))+(((r11)*(r20)*(x1388)*(x1398)))+(((IkReal(-1.00000000000000))*(r21)*(x1389)*(x1398)*(x1399)))));
IkReal x1403=(cj6)*(cj6);
IkReal x1404=(sj6)*(sj6);
IkReal x1405=((IkReal(1.00000000000000))*(r01));
IkReal x1406=((sj0)*(sj5));
IkReal x1407=((cj6)*(r22));
IkReal x1408=((r21)*(sj6));
IkReal x1409=((r00)*(r21));
IkReal x1410=((cj0)*(sj5));
IkReal x1411=((cj6)*(r20));
IkReal x1412=((r22)*(sj6));
IkReal x1413=((cj0)*(cj5));
IkReal x1414=((IkReal(1.00000000000000))*(r10));
IkReal x1415=((cj5)*(sj0));
IkReal x1416=((r20)*(x1404));
IkReal x1417=((x1403)*(x1415));
dummyeval[0]=((((r11)*(r20)*(x1403)*(x1413)))+(((IkReal(-1.00000000000000))*(r12)*(x1408)*(x1410)))+(((IkReal(-1.00000000000000))*(x1407)*(x1410)*(x1414)))+(((r12)*(x1410)*(x1411)))+(((IkReal(-1.00000000000000))*(r21)*(x1403)*(x1413)*(x1414)))+(((x1404)*(x1409)*(x1415)))+(((r11)*(x1413)*(x1416)))+(((r02)*(x1406)*(x1408)))+(((IkReal(-1.00000000000000))*(r20)*(x1405)*(x1417)))+(((r00)*(x1406)*(x1407)))+(((IkReal(-1.00000000000000))*(r21)*(x1404)*(x1413)*(x1414)))+(((IkReal(-1.00000000000000))*(x1405)*(x1406)*(x1412)))+(((IkReal(-1.00000000000000))*(x1405)*(x1415)*(x1416)))+(((x1409)*(x1417)))+(((r11)*(x1410)*(x1412)))+(((IkReal(-1.00000000000000))*(r02)*(x1406)*(x1411))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x1418=((cj5)*(r22));
IkReal x1419=((IkReal(0.374290000000000))*(sj5));
IkReal x1420=((cj0)*(sj6));
IkReal x1421=((cj6)*(r21));
IkReal x1422=((IkReal(0.0100000000000000))*(sj5));
IkReal x1423=((cj0)*(r02));
IkReal x1424=((IkReal(0.0100000000000000))*(cj5));
IkReal x1425=((IkReal(1.00000000000000))*(py));
IkReal x1426=((r01)*(sj0));
IkReal x1427=((r20)*(sj6));
IkReal x1428=((r11)*(sj0));
IkReal x1429=((IkReal(0.374290000000000))*(cj5));
IkReal x1430=((cj0)*(r12));
IkReal x1431=((sj0)*(x1429));
IkReal x1432=((cj6)*(x1424));
IkReal x1433=((r10)*(sj0)*(sj6));
IkReal x1434=((r00)*(sj0)*(sj6));
IkReal x1435=((cj0)*(cj6)*(x1419));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x1421)))+(((sj5)*(x1427)))+(((IkReal(-1.00000000000000))*(x1418))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1424)*(x1427)))+(((IkReal(-1.00000000000000))*(r22)*(x1422)))+(((IkReal(-1.00000000000000))*(x1421)*(x1424)))+(((x1419)*(x1421)))+(pz)+(((IkReal(-0.374290000000000))*(x1418)))+(((x1419)*(x1427))));
evalcond[3]=((IkReal(0.0690000000000000))+(((cj0)*(r11)*(x1432)))+(((IkReal(-1.00000000000000))*(r11)*(x1435)))+(((IkReal(-1.00000000000000))*(cj0)*(x1425)))+(((r10)*(x1420)*(x1424)))+(((cj6)*(x1419)*(x1426)))+(((IkReal(-1.00000000000000))*(x1426)*(x1432)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1422)))+(((x1422)*(x1430)))+(((IkReal(-1.00000000000000))*(x1424)*(x1434)))+(((x1429)*(x1430)))+(((IkReal(-1.00000000000000))*(r02)*(x1431)))+(((px)*(sj0)))+(((x1419)*(x1434)))+(((IkReal(-1.00000000000000))*(r10)*(x1419)*(x1420))));
evalcond[4]=((IkReal(-0.295420000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((x1424)*(x1433)))+(((x1422)*(x1423)))+(((x1428)*(x1432)))+(((r12)*(sj0)*(x1422)))+(((x1423)*(x1429)))+(((IkReal(-1.00000000000000))*(r00)*(x1419)*(x1420)))+(((IkReal(-1.00000000000000))*(sj0)*(x1425)))+(((r00)*(x1420)*(x1424)))+(((cj0)*(r01)*(x1432)))+(((r12)*(x1431)))+(((IkReal(-1.00000000000000))*(cj6)*(x1419)*(x1428)))+(((IkReal(-1.00000000000000))*(r01)*(x1435)))+(((IkReal(-1.00000000000000))*(x1419)*(x1433))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1436=((sj0)*(sj5));
IkReal x1437=((r00)*(sj6));
IkReal x1438=((IkReal(1.00000000000000))*(cj5));
IkReal x1439=((cj6)*(r11));
IkReal x1440=((cj6)*(r01));
IkReal x1441=((r10)*(sj6));
IkReal x1442=((cj0)*(sj5));
if( IKabs(((((x1436)*(x1440)))+(((x1436)*(x1437)))+(((IkReal(-1.00000000000000))*(x1441)*(x1442)))+(((IkReal(-1.00000000000000))*(x1439)*(x1442)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1438))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x1440)*(x1442)))+(((x1436)*(x1439)))+(((x1437)*(x1442)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1438)))+(((x1436)*(x1441)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1438))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((x1436)*(x1440)))+(((x1436)*(x1437)))+(((IkReal(-1.00000000000000))*(x1441)*(x1442)))+(((IkReal(-1.00000000000000))*(x1439)*(x1442)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1438)))))+IKsqr(((((x1440)*(x1442)))+(((x1436)*(x1439)))+(((x1437)*(x1442)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1438)))+(((x1436)*(x1441)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1438)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((x1436)*(x1440)))+(((x1436)*(x1437)))+(((IkReal(-1.00000000000000))*(x1441)*(x1442)))+(((IkReal(-1.00000000000000))*(x1439)*(x1442)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1438)))), ((((x1440)*(x1442)))+(((x1436)*(x1439)))+(((x1437)*(x1442)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1438)))+(((x1436)*(x1441)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1438)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1443=((cj0)*(cj5));
IkReal x1444=((IkReal(1.00000000000000))*(cj0));
IkReal x1445=((cj6)*(r11));
IkReal x1446=((r10)*(sj6));
IkReal x1447=((cj5)*(sj0));
IkReal x1448=((r00)*(sj5)*(sj6));
IkReal x1449=((cj6)*(r01)*(sj5));
IkReal x1450=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj5)*(x1444)*(x1445)))+(((IkReal(-1.00000000000000))*(r02)*(x1447)))+(((r12)*(x1443)))+(((sj0)*(x1448)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((sj0)*(x1449)))+(((IkReal(-1.00000000000000))*(sj5)*(x1444)*(x1446))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1446)*(x1450)))+(((r12)*(x1447)))+(((IkReal(-1.00000000000000))*(x1445)*(x1450)))+(((IkReal(-1.00000000000000))*(x1444)*(x1448)))+(IKcos(j3))+(((r02)*(x1443)))+(((IkReal(-1.00000000000000))*(x1444)*(x1449))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst59;
IkReal x1451=(r21)*(r21);
IkReal x1452=(cj5)*(cj5);
IkReal x1453=(sj6)*(sj6);
IkReal x1454=(cj6)*(cj6);
IkReal x1455=(r20)*(r20);
IkReal x1456=((cj6)*(r21));
IkReal x1457=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x1458=((cj5)*(r22)*(sj5));
IkReal x1459=((IkReal(1.00000000000000))*(x1453));
IkReal x1460=((IkReal(1.00000000000000))*(x1454));
gconst59=IKsign(((((x1456)*(x1457)))+(((IkReal(-1.00000000000000))*(x1455)*(x1460)))+(((IkReal(-1.00000000000000))*(x1457)*(x1458)))+(((IkReal(-1.00000000000000))*(x1451)*(x1452)*(x1460)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1452)*(x1456)*(x1457)))+(((IkReal(-2.00000000000000))*(x1456)*(x1458)))+(((IkReal(-1.00000000000000))*(x1451)*(x1459)))+(((IkReal(-1.00000000000000))*(x1452)*(x1455)*(x1459)))));
IkReal x1461=(r21)*(r21);
IkReal x1462=(cj5)*(cj5);
IkReal x1463=(sj6)*(sj6);
IkReal x1464=(cj6)*(cj6);
IkReal x1465=(r20)*(r20);
IkReal x1466=((cj6)*(r21));
IkReal x1467=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x1468=((cj5)*(r22)*(sj5));
IkReal x1469=((IkReal(1.00000000000000))*(x1463));
IkReal x1470=((IkReal(1.00000000000000))*(x1464));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1462)*(x1466)*(x1467)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1461)*(x1462)*(x1470)))+(((IkReal(-2.00000000000000))*(x1466)*(x1468)))+(((IkReal(-1.00000000000000))*(x1462)*(x1465)*(x1469)))+(((IkReal(-1.00000000000000))*(x1467)*(x1468)))+(((IkReal(-1.00000000000000))*(x1465)*(x1470)))+(((IkReal(-1.00000000000000))*(x1461)*(x1469)))+(((x1466)*(x1467))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst60;
IkReal x1471=(cj6)*(cj6);
IkReal x1472=(sj6)*(sj6);
IkReal x1473=((IkReal(1.00000000000000))*(r01));
IkReal x1474=((sj0)*(sj5));
IkReal x1475=((cj6)*(r22));
IkReal x1476=((r21)*(sj6));
IkReal x1477=((r00)*(r21));
IkReal x1478=((cj0)*(sj5));
IkReal x1479=((cj6)*(r20));
IkReal x1480=((r22)*(sj6));
IkReal x1481=((cj0)*(cj5));
IkReal x1482=((IkReal(1.00000000000000))*(r10));
IkReal x1483=((cj5)*(sj0));
IkReal x1484=((r20)*(x1472));
IkReal x1485=((x1471)*(x1483));
gconst60=IKsign(((((IkReal(-1.00000000000000))*(r12)*(x1476)*(x1478)))+(((IkReal(-1.00000000000000))*(r02)*(x1474)*(x1479)))+(((IkReal(-1.00000000000000))*(x1473)*(x1483)*(x1484)))+(((r02)*(x1474)*(x1476)))+(((IkReal(-1.00000000000000))*(r20)*(x1473)*(x1485)))+(((r11)*(x1478)*(x1480)))+(((r11)*(x1481)*(x1484)))+(((IkReal(-1.00000000000000))*(r21)*(x1472)*(x1481)*(x1482)))+(((r00)*(x1474)*(x1475)))+(((IkReal(-1.00000000000000))*(r21)*(x1471)*(x1481)*(x1482)))+(((x1472)*(x1477)*(x1483)))+(((r12)*(x1478)*(x1479)))+(((r11)*(r20)*(x1471)*(x1481)))+(((IkReal(-1.00000000000000))*(x1475)*(x1478)*(x1482)))+(((IkReal(-1.00000000000000))*(x1473)*(x1474)*(x1480)))+(((x1477)*(x1485)))));
IkReal x1486=(cj6)*(cj6);
IkReal x1487=(sj6)*(sj6);
IkReal x1488=((IkReal(1.00000000000000))*(r01));
IkReal x1489=((sj0)*(sj5));
IkReal x1490=((cj6)*(r22));
IkReal x1491=((r21)*(sj6));
IkReal x1492=((r00)*(r21));
IkReal x1493=((cj0)*(sj5));
IkReal x1494=((cj6)*(r20));
IkReal x1495=((r22)*(sj6));
IkReal x1496=((cj0)*(cj5));
IkReal x1497=((IkReal(1.00000000000000))*(r10));
IkReal x1498=((cj5)*(sj0));
IkReal x1499=((r20)*(x1487));
IkReal x1500=((x1486)*(x1498));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1488)*(x1489)*(x1495)))+(((IkReal(-1.00000000000000))*(r12)*(x1491)*(x1493)))+(((IkReal(-1.00000000000000))*(x1490)*(x1493)*(x1497)))+(((r12)*(x1493)*(x1494)))+(((r11)*(x1493)*(x1495)))+(((r11)*(r20)*(x1486)*(x1496)))+(((IkReal(-1.00000000000000))*(r20)*(x1488)*(x1500)))+(((IkReal(-1.00000000000000))*(x1488)*(x1498)*(x1499)))+(((x1492)*(x1500)))+(((x1487)*(x1492)*(x1498)))+(((IkReal(-1.00000000000000))*(r21)*(x1486)*(x1496)*(x1497)))+(((r11)*(x1496)*(x1499)))+(((IkReal(-1.00000000000000))*(r02)*(x1489)*(x1494)))+(((r02)*(x1489)*(x1491)))+(((IkReal(-1.00000000000000))*(r21)*(x1487)*(x1496)*(x1497)))+(((r00)*(x1489)*(x1490))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1501=((sj0)*(sj6));
IkReal x1502=((cj0)*(r10));
IkReal x1503=((IkReal(1.00000000000000))*(cj5));
IkReal x1504=((cj6)*(sj0));
IkReal x1505=((cj0)*(r11));
if( IKabs(((gconst60)*(((((IkReal(-1.00000000000000))*(sj6)*(x1505)))+(((r01)*(x1501)))+(((cj6)*(x1502)))+(((IkReal(-1.00000000000000))*(r00)*(x1504))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst60)*(((((cj5)*(sj6)*(x1502)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(cj6)*(x1505)))+(((IkReal(-1.00000000000000))*(r00)*(x1501)*(x1503)))+(((IkReal(-1.00000000000000))*(r01)*(x1503)*(x1504))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst60)*(((((IkReal(-1.00000000000000))*(sj6)*(x1505)))+(((r01)*(x1501)))+(((cj6)*(x1502)))+(((IkReal(-1.00000000000000))*(r00)*(x1504)))))), ((gconst60)*(((((cj5)*(sj6)*(x1502)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(cj6)*(x1505)))+(((IkReal(-1.00000000000000))*(r00)*(x1501)*(x1503)))+(((IkReal(-1.00000000000000))*(r01)*(x1503)*(x1504)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1506=IKsin(j4);
IkReal x1507=IKcos(j4);
IkReal x1508=((r22)*(sj5));
IkReal x1509=((IkReal(1.00000000000000))*(cj6));
IkReal x1510=((IkReal(1.00000000000000))*(cj0));
IkReal x1511=((cj5)*(r11));
IkReal x1512=((cj5)*(cj6));
IkReal x1513=((r11)*(sj6));
IkReal x1514=((IkReal(1.00000000000000))*(sj6));
IkReal x1515=((cj6)*(r00));
IkReal x1516=((r12)*(sj5));
IkReal x1517=((r02)*(sj5));
IkReal x1518=((cj6)*(r10));
IkReal x1519=((cj5)*(sj6));
IkReal x1520=((cj5)*(r01));
IkReal x1521=((sj0)*(x1506));
IkReal x1522=((r00)*(x1519));
IkReal x1523=((cj0)*(x1506));
IkReal x1524=((sj0)*(x1507));
IkReal x1525=((r20)*(x1507));
IkReal x1526=((cj0)*(x1507));
IkReal x1527=((r21)*(x1506));
IkReal x1528=((r21)*(x1507));
IkReal x1529=((r20)*(x1506));
IkReal x1530=((x1507)*(x1516));
IkReal x1531=((r01)*(sj6)*(x1507));
IkReal x1532=((cj5)*(r10)*(x1514));
evalcond[0]=((IkReal(1.00000000000000))+(((x1506)*(x1508)))+(((IkReal(-1.00000000000000))*(x1509)*(x1525)))+(((sj6)*(x1528)))+(((x1519)*(x1529)))+(((x1512)*(x1527))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1514)*(x1527)))+(((x1507)*(x1508)))+(((x1512)*(x1528)))+(((cj6)*(x1529)))+(((x1519)*(x1525))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1506)*(x1510)*(x1516)))+(((IkReal(-1.00000000000000))*(r00)*(x1509)*(x1524)))+(((IkReal(-1.00000000000000))*(x1507)*(x1510)*(x1513)))+(((x1518)*(x1526)))+(((x1517)*(x1521)))+(((r01)*(x1512)*(x1521)))+(((r01)*(sj6)*(x1524)))+(((x1521)*(x1522)))+(((IkReal(-1.00000000000000))*(x1509)*(x1511)*(x1523)))+(((IkReal(-1.00000000000000))*(r10)*(x1506)*(x1510)*(x1519))));
evalcond[3]=((((x1517)*(x1524)))+(((IkReal(-1.00000000000000))*(x1510)*(x1530)))+(((IkReal(-1.00000000000000))*(r10)*(x1507)*(x1510)*(x1519)))+(cj3)+(((r01)*(x1512)*(x1524)))+(((x1515)*(x1521)))+(((x1513)*(x1523)))+(((IkReal(-1.00000000000000))*(x1509)*(x1511)*(x1526)))+(((x1522)*(x1524)))+(((IkReal(-1.00000000000000))*(r10)*(x1509)*(x1523)))+(((IkReal(-1.00000000000000))*(r01)*(x1514)*(x1521))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1506)*(x1510)*(x1517)))+(((IkReal(-1.00000000000000))*(x1509)*(x1511)*(x1521)))+(((IkReal(-1.00000000000000))*(x1506)*(x1510)*(x1522)))+(((x1518)*(x1524)))+(((IkReal(-1.00000000000000))*(x1510)*(x1531)))+(((IkReal(-1.00000000000000))*(x1521)*(x1532)))+(((IkReal(-1.00000000000000))*(x1516)*(x1521)))+(((IkReal(-1.00000000000000))*(x1509)*(x1520)*(x1523)))+(((IkReal(-1.00000000000000))*(x1513)*(x1524)))+(((x1515)*(x1526))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1509)*(x1511)*(x1524)))+(((r01)*(sj6)*(x1523)))+(((IkReal(-1.00000000000000))*(x1516)*(x1524)))+(sj3)+(((IkReal(-1.00000000000000))*(x1507)*(x1510)*(x1522)))+(((IkReal(-1.00000000000000))*(x1509)*(x1520)*(x1526)))+(((IkReal(-1.00000000000000))*(x1507)*(x1510)*(x1517)))+(((IkReal(-1.00000000000000))*(r00)*(x1509)*(x1523)))+(((IkReal(-1.00000000000000))*(x1524)*(x1532)))+(((x1513)*(x1521)))+(((IkReal(-1.00000000000000))*(r10)*(x1509)*(x1521))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst59)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst59)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst59)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst59)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1533=IKsin(j4);
IkReal x1534=IKcos(j4);
IkReal x1535=((r22)*(sj5));
IkReal x1536=((IkReal(1.00000000000000))*(cj6));
IkReal x1537=((IkReal(1.00000000000000))*(cj0));
IkReal x1538=((cj5)*(r11));
IkReal x1539=((cj5)*(cj6));
IkReal x1540=((r11)*(sj6));
IkReal x1541=((IkReal(1.00000000000000))*(sj6));
IkReal x1542=((cj6)*(r00));
IkReal x1543=((r12)*(sj5));
IkReal x1544=((r02)*(sj5));
IkReal x1545=((cj6)*(r10));
IkReal x1546=((cj5)*(sj6));
IkReal x1547=((cj5)*(r01));
IkReal x1548=((sj0)*(x1533));
IkReal x1549=((r00)*(x1546));
IkReal x1550=((cj0)*(x1533));
IkReal x1551=((sj0)*(x1534));
IkReal x1552=((r20)*(x1534));
IkReal x1553=((cj0)*(x1534));
IkReal x1554=((r21)*(x1533));
IkReal x1555=((r21)*(x1534));
IkReal x1556=((r20)*(x1533));
IkReal x1557=((x1534)*(x1543));
IkReal x1558=((r01)*(sj6)*(x1534));
IkReal x1559=((cj5)*(r10)*(x1541));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1536)*(x1552)))+(((x1546)*(x1556)))+(((x1533)*(x1535)))+(((x1539)*(x1554)))+(((sj6)*(x1555))));
evalcond[1]=((((cj6)*(x1556)))+(((x1534)*(x1535)))+(((x1546)*(x1552)))+(((x1539)*(x1555)))+(((IkReal(-1.00000000000000))*(x1541)*(x1554))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1536)*(x1538)*(x1550)))+(((IkReal(-1.00000000000000))*(x1533)*(x1537)*(x1543)))+(((x1544)*(x1548)))+(((IkReal(-1.00000000000000))*(r10)*(x1533)*(x1537)*(x1546)))+(((IkReal(-1.00000000000000))*(x1534)*(x1537)*(x1540)))+(((r01)*(sj6)*(x1551)))+(((x1548)*(x1549)))+(((r01)*(x1539)*(x1548)))+(((x1545)*(x1553)))+(((IkReal(-1.00000000000000))*(r00)*(x1536)*(x1551))));
evalcond[3]=((((x1540)*(x1550)))+(((x1542)*(x1548)))+(((IkReal(-1.00000000000000))*(r10)*(x1536)*(x1550)))+(((r01)*(x1539)*(x1551)))+(((x1544)*(x1551)))+(((IkReal(-1.00000000000000))*(x1537)*(x1557)))+(((IkReal(-1.00000000000000))*(r01)*(x1541)*(x1548)))+(((IkReal(-1.00000000000000))*(r10)*(x1534)*(x1537)*(x1546)))+(cj3)+(((x1549)*(x1551)))+(((IkReal(-1.00000000000000))*(x1536)*(x1538)*(x1553))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1540)*(x1551)))+(((x1542)*(x1553)))+(((IkReal(-1.00000000000000))*(x1536)*(x1538)*(x1548)))+(((IkReal(-1.00000000000000))*(x1533)*(x1537)*(x1544)))+(((IkReal(-1.00000000000000))*(x1533)*(x1537)*(x1549)))+(((IkReal(-1.00000000000000))*(x1536)*(x1547)*(x1550)))+(((IkReal(-1.00000000000000))*(x1543)*(x1548)))+(((IkReal(-1.00000000000000))*(x1548)*(x1559)))+(((x1545)*(x1551)))+(((IkReal(-1.00000000000000))*(x1537)*(x1558))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1536)*(x1547)*(x1553)))+(((x1540)*(x1548)))+(((r01)*(sj6)*(x1550)))+(((IkReal(-1.00000000000000))*(r00)*(x1536)*(x1550)))+(sj3)+(((IkReal(-1.00000000000000))*(x1536)*(x1538)*(x1551)))+(((IkReal(-1.00000000000000))*(r10)*(x1536)*(x1548)))+(((IkReal(-1.00000000000000))*(x1551)*(x1559)))+(((IkReal(-1.00000000000000))*(x1534)*(x1537)*(x1544)))+(((IkReal(-1.00000000000000))*(x1534)*(x1537)*(x1549)))+(((IkReal(-1.00000000000000))*(x1543)*(x1551))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x1560=((cj5)*(r22));
IkReal x1561=((IkReal(0.374290000000000))*(sj5));
IkReal x1562=((cj0)*(sj6));
IkReal x1563=((cj6)*(r21));
IkReal x1564=((IkReal(0.0100000000000000))*(sj5));
IkReal x1565=((cj0)*(r02));
IkReal x1566=((IkReal(0.0100000000000000))*(cj5));
IkReal x1567=((IkReal(1.00000000000000))*(py));
IkReal x1568=((r01)*(sj0));
IkReal x1569=((r20)*(sj6));
IkReal x1570=((r11)*(sj0));
IkReal x1571=((IkReal(0.374290000000000))*(cj5));
IkReal x1572=((cj0)*(r12));
IkReal x1573=((sj0)*(x1571));
IkReal x1574=((cj6)*(x1566));
IkReal x1575=((r10)*(sj0)*(sj6));
IkReal x1576=((r00)*(sj0)*(sj6));
IkReal x1577=((cj0)*(cj6)*(x1561));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1560)))+(((sj5)*(x1569)))+(((sj5)*(x1563))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1566)*(x1569)))+(((x1561)*(x1563)))+(((IkReal(-1.00000000000000))*(r22)*(x1564)))+(pz)+(((x1561)*(x1569)))+(((IkReal(-1.00000000000000))*(x1563)*(x1566)))+(((IkReal(-0.374290000000000))*(x1560))));
evalcond[3]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(x1566)*(x1576)))+(((IkReal(-1.00000000000000))*(r11)*(x1577)))+(((x1571)*(x1572)))+(((r10)*(x1562)*(x1566)))+(((x1561)*(x1576)))+(((IkReal(-1.00000000000000))*(cj0)*(x1567)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1564)))+(((cj6)*(x1561)*(x1568)))+(((IkReal(-1.00000000000000))*(x1568)*(x1574)))+(((px)*(sj0)))+(((cj0)*(r11)*(x1574)))+(((x1564)*(x1572)))+(((IkReal(-1.00000000000000))*(r02)*(x1573)))+(((IkReal(-1.00000000000000))*(r10)*(x1561)*(x1562))));
evalcond[4]=((IkReal(-0.295420000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-1.00000000000000))*(r00)*(x1561)*(x1562)))+(((cj0)*(r01)*(x1574)))+(((x1565)*(x1571)))+(((IkReal(-1.00000000000000))*(sj0)*(x1567)))+(((x1570)*(x1574)))+(((r12)*(sj0)*(x1564)))+(((x1564)*(x1565)))+(((r12)*(x1573)))+(((IkReal(-1.00000000000000))*(x1561)*(x1575)))+(((IkReal(-1.00000000000000))*(cj6)*(x1561)*(x1570)))+(((r00)*(x1562)*(x1566)))+(((x1566)*(x1575)))+(((IkReal(-1.00000000000000))*(r01)*(x1577))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1578=((IkReal(1.00000000000000))*(cj5));
IkReal x1579=((r10)*(sj5)*(sj6));
IkReal x1580=((cj6)*(sj0)*(sj5));
IkReal x1581=((r00)*(sj5)*(sj6));
IkReal x1582=((cj0)*(cj6)*(sj5));
if( IKabs(((((cj0)*(x1579)))+(((IkReal(-1.00000000000000))*(sj0)*(x1581)))+(((IkReal(-1.00000000000000))*(r01)*(x1580)))+(((cj5)*(r02)*(sj0)))+(((r11)*(x1582)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x1578))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1578)))+(((sj0)*(x1579)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1578)))+(((r11)*(x1580)))+(((r01)*(x1582)))+(((cj0)*(x1581))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj0)*(x1579)))+(((IkReal(-1.00000000000000))*(sj0)*(x1581)))+(((IkReal(-1.00000000000000))*(r01)*(x1580)))+(((cj5)*(r02)*(sj0)))+(((r11)*(x1582)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x1578)))))+IKsqr(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1578)))+(((sj0)*(x1579)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1578)))+(((r11)*(x1580)))+(((r01)*(x1582)))+(((cj0)*(x1581)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj0)*(x1579)))+(((IkReal(-1.00000000000000))*(sj0)*(x1581)))+(((IkReal(-1.00000000000000))*(r01)*(x1580)))+(((cj5)*(r02)*(sj0)))+(((r11)*(x1582)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x1578)))), ((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1578)))+(((sj0)*(x1579)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1578)))+(((r11)*(x1580)))+(((r01)*(x1582)))+(((cj0)*(x1581)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1583=((cj0)*(cj5));
IkReal x1584=((IkReal(1.00000000000000))*(cj0));
IkReal x1585=((cj6)*(r11));
IkReal x1586=((r10)*(sj6));
IkReal x1587=((cj5)*(sj0));
IkReal x1588=((r00)*(sj5)*(sj6));
IkReal x1589=((cj6)*(r01)*(sj5));
IkReal x1590=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj5)*(x1584)*(x1585)))+(((IkReal(-1.00000000000000))*(r02)*(x1587)))+(((r12)*(x1583)))+(((sj0)*(x1588)))+(IKsin(j3))+(((sj0)*(x1589)))+(((IkReal(-1.00000000000000))*(sj5)*(x1584)*(x1586))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1584)*(x1589)))+(((r02)*(x1583)))+(((IkReal(-1.00000000000000))*(x1585)*(x1590)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(x1586)*(x1590)))+(((IkReal(-1.00000000000000))*(x1584)*(x1588)))+(((r12)*(x1587))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst63;
IkReal x1591=(cj5)*(cj5);
IkReal x1592=(r20)*(r20);
IkReal x1593=(sj6)*(sj6);
IkReal x1594=(cj6)*(cj6);
IkReal x1595=(r21)*(r21);
IkReal x1596=((cj6)*(r21));
IkReal x1597=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x1598=((cj5)*(r22)*(sj5));
gconst63=IKsign(((((x1592)*(x1594)))+(((x1593)*(x1595)))+(((IkReal(-1.00000000000000))*(x1596)*(x1597)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x1591)*(x1594)*(x1595)))+(((x1591)*(x1592)*(x1593)))+(((IkReal(2.00000000000000))*(x1596)*(x1598)))+(((x1597)*(x1598)))+(((x1591)*(x1596)*(x1597)))));
IkReal x1599=(cj5)*(cj5);
IkReal x1600=(r20)*(r20);
IkReal x1601=(sj6)*(sj6);
IkReal x1602=(cj6)*(cj6);
IkReal x1603=(r21)*(r21);
IkReal x1604=((cj6)*(r21));
IkReal x1605=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x1606=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x1601)*(x1603)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x1600)*(x1602)))+(((IkReal(2.00000000000000))*(x1604)*(x1606)))+(((x1605)*(x1606)))+(((x1599)*(x1604)*(x1605)))+(((x1599)*(x1600)*(x1601)))+(((x1599)*(x1602)*(x1603)))+(((IkReal(-1.00000000000000))*(x1604)*(x1605))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst64;
IkReal x1607=(cj6)*(cj6);
IkReal x1608=(sj6)*(sj6);
IkReal x1609=((IkReal(1.00000000000000))*(r21));
IkReal x1610=((cj6)*(r20));
IkReal x1611=((r22)*(sj5));
IkReal x1612=((r01)*(sj0));
IkReal x1613=((r00)*(sj0));
IkReal x1614=((cj0)*(r10));
IkReal x1615=((r02)*(sj0)*(sj5));
IkReal x1616=((cj5)*(x1607));
IkReal x1617=((cj0)*(r12)*(sj5));
IkReal x1618=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x1619=((cj5)*(x1608));
IkReal x1620=((r20)*(x1619));
gconst64=IKsign(((((IkReal(-1.00000000000000))*(x1609)*(x1613)*(x1619)))+(((cj6)*(x1611)*(x1614)))+(((r21)*(x1614)*(x1619)))+(((IkReal(-1.00000000000000))*(x1609)*(x1613)*(x1616)))+(((IkReal(-1.00000000000000))*(x1610)*(x1617)))+(((IkReal(-1.00000000000000))*(r20)*(x1616)*(x1618)))+(((IkReal(-1.00000000000000))*(x1618)*(x1620)))+(((IkReal(-1.00000000000000))*(cj6)*(x1611)*(x1613)))+(((sj6)*(x1611)*(x1612)))+(((r21)*(x1614)*(x1616)))+(((r21)*(sj6)*(x1617)))+(((IkReal(-1.00000000000000))*(sj6)*(x1611)*(x1618)))+(((IkReal(-1.00000000000000))*(sj6)*(x1609)*(x1615)))+(((r20)*(x1612)*(x1616)))+(((x1610)*(x1615)))+(((x1612)*(x1620)))));
IkReal x1621=(cj6)*(cj6);
IkReal x1622=(sj6)*(sj6);
IkReal x1623=((IkReal(1.00000000000000))*(r21));
IkReal x1624=((cj6)*(r20));
IkReal x1625=((r22)*(sj5));
IkReal x1626=((r01)*(sj0));
IkReal x1627=((r00)*(sj0));
IkReal x1628=((cj0)*(r10));
IkReal x1629=((r02)*(sj0)*(sj5));
IkReal x1630=((cj5)*(x1621));
IkReal x1631=((cj0)*(r12)*(sj5));
IkReal x1632=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x1633=((cj5)*(x1622));
IkReal x1634=((r20)*(x1633));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1623)*(x1627)*(x1630)))+(((IkReal(-1.00000000000000))*(r20)*(x1630)*(x1632)))+(((sj6)*(x1625)*(x1626)))+(((IkReal(-1.00000000000000))*(x1624)*(x1631)))+(((IkReal(-1.00000000000000))*(sj6)*(x1625)*(x1632)))+(((r21)*(x1628)*(x1633)))+(((x1626)*(x1634)))+(((IkReal(-1.00000000000000))*(x1632)*(x1634)))+(((cj6)*(x1625)*(x1628)))+(((x1624)*(x1629)))+(((r21)*(sj6)*(x1631)))+(((r20)*(x1626)*(x1630)))+(((r21)*(x1628)*(x1630)))+(((IkReal(-1.00000000000000))*(cj6)*(x1625)*(x1627)))+(((IkReal(-1.00000000000000))*(x1623)*(x1627)*(x1633)))+(((IkReal(-1.00000000000000))*(sj6)*(x1623)*(x1629))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1635=((sj0)*(sj6));
IkReal x1636=((cj0)*(r10));
IkReal x1637=((IkReal(1.00000000000000))*(cj5));
IkReal x1638=((cj6)*(sj0));
IkReal x1639=((cj0)*(r11));
if( IKabs(((gconst64)*(((((IkReal(-1.00000000000000))*(sj6)*(x1639)))+(((cj6)*(x1636)))+(((IkReal(-1.00000000000000))*(r00)*(x1638)))+(((r01)*(x1635))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst64)*(((((cj5)*(cj6)*(x1639)))+(((cj5)*(sj6)*(x1636)))+(((IkReal(-1.00000000000000))*(r01)*(x1637)*(x1638)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x1635)*(x1637)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst64)*(((((IkReal(-1.00000000000000))*(sj6)*(x1639)))+(((cj6)*(x1636)))+(((IkReal(-1.00000000000000))*(r00)*(x1638)))+(((r01)*(x1635)))))), ((gconst64)*(((((cj5)*(cj6)*(x1639)))+(((cj5)*(sj6)*(x1636)))+(((IkReal(-1.00000000000000))*(r01)*(x1637)*(x1638)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x1635)*(x1637)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1640=IKsin(j4);
IkReal x1641=IKcos(j4);
IkReal x1642=((r22)*(sj5));
IkReal x1643=((IkReal(1.00000000000000))*(cj6));
IkReal x1644=((IkReal(1.00000000000000))*(cj0));
IkReal x1645=((cj5)*(r11));
IkReal x1646=((cj5)*(cj6));
IkReal x1647=((r11)*(sj6));
IkReal x1648=((IkReal(1.00000000000000))*(sj6));
IkReal x1649=((cj6)*(r00));
IkReal x1650=((r12)*(sj5));
IkReal x1651=((r02)*(sj5));
IkReal x1652=((cj6)*(r10));
IkReal x1653=((cj5)*(sj6));
IkReal x1654=((cj5)*(r01));
IkReal x1655=((sj0)*(x1640));
IkReal x1656=((r00)*(x1653));
IkReal x1657=((cj0)*(x1640));
IkReal x1658=((sj0)*(x1641));
IkReal x1659=((r20)*(x1641));
IkReal x1660=((cj0)*(x1641));
IkReal x1661=((r21)*(x1640));
IkReal x1662=((r21)*(x1641));
IkReal x1663=((r20)*(x1640));
IkReal x1664=((x1641)*(x1650));
IkReal x1665=((r01)*(sj6)*(x1641));
IkReal x1666=((cj5)*(r10)*(x1648));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x1643)*(x1659)))+(((x1646)*(x1661)))+(((x1640)*(x1642)))+(((sj6)*(x1662)))+(((x1653)*(x1663))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1648)*(x1661)))+(((x1641)*(x1642)))+(((x1653)*(x1659)))+(((x1646)*(x1662)))+(((cj6)*(x1663))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x1640)*(x1644)*(x1653)))+(((r01)*(sj6)*(x1658)))+(((x1651)*(x1655)))+(((r01)*(x1646)*(x1655)))+(((x1652)*(x1660)))+(((IkReal(-1.00000000000000))*(x1640)*(x1644)*(x1650)))+(((IkReal(-1.00000000000000))*(x1643)*(x1645)*(x1657)))+(((IkReal(-1.00000000000000))*(x1641)*(x1644)*(x1647)))+(((x1655)*(x1656)))+(((IkReal(-1.00000000000000))*(r00)*(x1643)*(x1658))));
evalcond[3]=((((x1649)*(x1655)))+(((x1656)*(x1658)))+(((IkReal(-1.00000000000000))*(r01)*(x1648)*(x1655)))+(((IkReal(-1.00000000000000))*(r10)*(x1641)*(x1644)*(x1653)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x1644)*(x1664)))+(((x1651)*(x1658)))+(((x1647)*(x1657)))+(((r01)*(x1646)*(x1658)))+(((IkReal(-1.00000000000000))*(r10)*(x1643)*(x1657)))+(((IkReal(-1.00000000000000))*(x1643)*(x1645)*(x1660))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1644)*(x1665)))+(((IkReal(-1.00000000000000))*(x1640)*(x1644)*(x1656)))+(((IkReal(-1.00000000000000))*(x1643)*(x1654)*(x1657)))+(((IkReal(-1.00000000000000))*(x1643)*(x1645)*(x1655)))+(((IkReal(-1.00000000000000))*(x1655)*(x1666)))+(((x1649)*(x1660)))+(((x1652)*(x1658)))+(((IkReal(-1.00000000000000))*(x1640)*(x1644)*(x1651)))+(((IkReal(-1.00000000000000))*(x1650)*(x1655)))+(((IkReal(-1.00000000000000))*(x1647)*(x1658))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1643)*(x1645)*(x1658)))+(sj3)+(((x1647)*(x1655)))+(((IkReal(-1.00000000000000))*(x1658)*(x1666)))+(((IkReal(-1.00000000000000))*(x1641)*(x1644)*(x1651)))+(((IkReal(-1.00000000000000))*(r00)*(x1643)*(x1657)))+(((IkReal(-1.00000000000000))*(r10)*(x1643)*(x1655)))+(((IkReal(-1.00000000000000))*(x1641)*(x1644)*(x1656)))+(((IkReal(-1.00000000000000))*(x1650)*(x1658)))+(((IkReal(-1.00000000000000))*(x1643)*(x1654)*(x1660)))+(((r01)*(sj6)*(x1657))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst63)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst63)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst63)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst63)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1667=IKsin(j4);
IkReal x1668=IKcos(j4);
IkReal x1669=((r22)*(sj5));
IkReal x1670=((IkReal(1.00000000000000))*(cj6));
IkReal x1671=((IkReal(1.00000000000000))*(cj0));
IkReal x1672=((cj5)*(r11));
IkReal x1673=((cj5)*(cj6));
IkReal x1674=((r11)*(sj6));
IkReal x1675=((IkReal(1.00000000000000))*(sj6));
IkReal x1676=((cj6)*(r00));
IkReal x1677=((r12)*(sj5));
IkReal x1678=((r02)*(sj5));
IkReal x1679=((cj6)*(r10));
IkReal x1680=((cj5)*(sj6));
IkReal x1681=((cj5)*(r01));
IkReal x1682=((sj0)*(x1667));
IkReal x1683=((r00)*(x1680));
IkReal x1684=((cj0)*(x1667));
IkReal x1685=((sj0)*(x1668));
IkReal x1686=((r20)*(x1668));
IkReal x1687=((cj0)*(x1668));
IkReal x1688=((r21)*(x1667));
IkReal x1689=((r21)*(x1668));
IkReal x1690=((r20)*(x1667));
IkReal x1691=((x1668)*(x1677));
IkReal x1692=((r01)*(sj6)*(x1668));
IkReal x1693=((cj5)*(r10)*(x1675));
evalcond[0]=((IkReal(-1.00000000000000))+(((x1680)*(x1690)))+(((x1667)*(x1669)))+(((sj6)*(x1689)))+(((IkReal(-1.00000000000000))*(x1670)*(x1686)))+(((x1673)*(x1688))));
evalcond[1]=((((cj6)*(x1690)))+(((x1668)*(x1669)))+(((x1673)*(x1689)))+(((IkReal(-1.00000000000000))*(x1675)*(x1688)))+(((x1680)*(x1686))));
evalcond[2]=((((r01)*(sj6)*(x1685)))+(((x1682)*(x1683)))+(((x1679)*(x1687)))+(((x1678)*(x1682)))+(((IkReal(-1.00000000000000))*(x1668)*(x1671)*(x1674)))+(((IkReal(-1.00000000000000))*(r10)*(x1667)*(x1671)*(x1680)))+(((IkReal(-1.00000000000000))*(x1667)*(x1671)*(x1677)))+(((IkReal(-1.00000000000000))*(x1670)*(x1672)*(x1684)))+(((r01)*(x1673)*(x1682)))+(((IkReal(-1.00000000000000))*(r00)*(x1670)*(x1685))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r01)*(x1675)*(x1682)))+(((IkReal(-1.00000000000000))*(x1671)*(x1691)))+(((IkReal(-1.00000000000000))*(r10)*(x1670)*(x1684)))+(((IkReal(-1.00000000000000))*(r10)*(x1668)*(x1671)*(x1680)))+(((r01)*(x1673)*(x1685)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x1670)*(x1672)*(x1687)))+(((x1676)*(x1682)))+(((x1683)*(x1685)))+(((x1674)*(x1684)))+(((x1678)*(x1685))));
evalcond[4]=((((x1676)*(x1687)))+(((IkReal(-1.00000000000000))*(x1667)*(x1671)*(x1683)))+(((IkReal(-1.00000000000000))*(x1670)*(x1681)*(x1684)))+(((IkReal(-1.00000000000000))*(x1670)*(x1672)*(x1682)))+(((IkReal(-1.00000000000000))*(x1667)*(x1671)*(x1678)))+(((IkReal(-1.00000000000000))*(x1677)*(x1682)))+(((IkReal(-1.00000000000000))*(x1682)*(x1693)))+(((IkReal(-1.00000000000000))*(x1671)*(x1692)))+(((IkReal(-1.00000000000000))*(x1674)*(x1685)))+(((x1679)*(x1685))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1685)*(x1693)))+(((IkReal(-1.00000000000000))*(x1677)*(x1685)))+(((IkReal(-1.00000000000000))*(r10)*(x1670)*(x1682)))+(((IkReal(-1.00000000000000))*(x1670)*(x1672)*(x1685)))+(sj3)+(((x1674)*(x1682)))+(((IkReal(-1.00000000000000))*(x1670)*(x1681)*(x1687)))+(((IkReal(-1.00000000000000))*(x1668)*(x1671)*(x1678)))+(((r01)*(sj6)*(x1684)))+(((IkReal(-1.00000000000000))*(r00)*(x1670)*(x1684)))+(((IkReal(-1.00000000000000))*(x1668)*(x1671)*(x1683))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1694=((cj6)*(sj5));
IkReal x1695=((IkReal(1.00000000000000))*(cj5));
IkReal x1696=((sj5)*(sj6));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r20)*(x1696)))+(((IkReal(-1.00000000000000))*(r21)*(x1694)))+(((cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj0)*(r00)*(x1696)))+(((r10)*(sj0)*(x1696)))+(((cj0)*(r01)*(x1694)))+(((r11)*(sj0)*(x1694)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1695)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1695))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r20)*(x1696)))+(((IkReal(-1.00000000000000))*(r21)*(x1694)))+(((cj5)*(r22)))))))+IKsqr(((((cj0)*(r00)*(x1696)))+(((r10)*(sj0)*(x1696)))+(((cj0)*(r01)*(x1694)))+(((r11)*(sj0)*(x1694)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1695)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1695)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r20)*(x1696)))+(((IkReal(-1.00000000000000))*(r21)*(x1694)))+(((cj5)*(r22)))))), ((((cj0)*(r00)*(x1696)))+(((r10)*(sj0)*(x1696)))+(((cj0)*(r01)*(x1694)))+(((r11)*(sj0)*(x1694)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1695)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1695)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x1697=IKsin(j3);
IkReal x1698=((sj5)*(sj6));
IkReal x1699=((cj0)*(cj5));
IkReal x1700=((IkReal(1.00000000000000))*(cj0));
IkReal x1701=((IkReal(1.00000000000000))*(sj0));
IkReal x1702=((cj6)*(r01)*(sj5));
IkReal x1703=((cj6)*(r11)*(sj5));
evalcond[0]=((((cj2)*(x1697)))+(((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r20)*(x1698))));
evalcond[1]=((((r12)*(x1699)))+(((IkReal(-1.00000000000000))*(x1700)*(x1703)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(x1701)))+(((sj0)*(x1702)))+(((r00)*(sj0)*(x1698)))+(((IkReal(-1.00000000000000))*(sj2)*(x1697)))+(((IkReal(-1.00000000000000))*(r10)*(x1698)*(x1700))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x1698)*(x1700)))+(((r02)*(x1699)))+(((IkReal(-1.00000000000000))*(x1700)*(x1702)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r10)*(x1698)*(x1701)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(x1701)*(x1703))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst54;
IkReal x1704=(r21)*(r21);
IkReal x1705=(cj5)*(cj5);
IkReal x1706=(sj6)*(sj6);
IkReal x1707=(cj6)*(cj6);
IkReal x1708=(r20)*(r20);
IkReal x1709=((cj6)*(r21));
IkReal x1710=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x1711=((cj5)*(r22)*(sj5));
IkReal x1712=((IkReal(1.00000000000000))*(x1706));
IkReal x1713=((IkReal(1.00000000000000))*(x1707));
gconst54=IKsign(((((IkReal(-1.00000000000000))*(x1708)*(x1713)))+(((IkReal(-2.00000000000000))*(x1709)*(x1711)))+(((x1709)*(x1710)))+(((IkReal(-1.00000000000000))*(x1704)*(x1712)))+(((IkReal(-1.00000000000000))*(x1704)*(x1705)*(x1713)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1705)*(x1709)*(x1710)))+(((IkReal(-1.00000000000000))*(x1710)*(x1711)))+(((IkReal(-1.00000000000000))*(x1705)*(x1708)*(x1712)))));
IkReal x1714=(r21)*(r21);
IkReal x1715=(cj5)*(cj5);
IkReal x1716=(sj6)*(sj6);
IkReal x1717=(cj6)*(cj6);
IkReal x1718=(r20)*(r20);
IkReal x1719=((cj6)*(r21));
IkReal x1720=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x1721=((cj5)*(r22)*(sj5));
IkReal x1722=((IkReal(1.00000000000000))*(x1716));
IkReal x1723=((IkReal(1.00000000000000))*(x1717));
dummyeval[0]=((((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1714)*(x1722)))+(((IkReal(-1.00000000000000))*(x1715)*(x1719)*(x1720)))+(((x1719)*(x1720)))+(((IkReal(-1.00000000000000))*(x1720)*(x1721)))+(((IkReal(-2.00000000000000))*(x1719)*(x1721)))+(((IkReal(-1.00000000000000))*(x1718)*(x1723)))+(((IkReal(-1.00000000000000))*(x1715)*(x1718)*(x1722)))+(((IkReal(-1.00000000000000))*(x1714)*(x1715)*(x1723))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst55;
IkReal x1724=(cj6)*(cj6);
IkReal x1725=(sj6)*(sj6);
IkReal x1726=((IkReal(1.00000000000000))*(r01));
IkReal x1727=((sj0)*(sj5));
IkReal x1728=((cj6)*(r22));
IkReal x1729=((r21)*(sj6));
IkReal x1730=((r00)*(r21));
IkReal x1731=((cj0)*(sj5));
IkReal x1732=((cj6)*(r20));
IkReal x1733=((r22)*(sj6));
IkReal x1734=((cj0)*(cj5));
IkReal x1735=((IkReal(1.00000000000000))*(r10));
IkReal x1736=((cj5)*(sj0));
IkReal x1737=((r20)*(x1725));
IkReal x1738=((x1724)*(x1736));
gconst55=IKsign(((((x1725)*(x1730)*(x1736)))+(((r11)*(r20)*(x1724)*(x1734)))+(((IkReal(-1.00000000000000))*(r02)*(x1727)*(x1732)))+(((IkReal(-1.00000000000000))*(r20)*(x1726)*(x1738)))+(((r02)*(x1727)*(x1729)))+(((IkReal(-1.00000000000000))*(x1728)*(x1731)*(x1735)))+(((IkReal(-1.00000000000000))*(r12)*(x1729)*(x1731)))+(((IkReal(-1.00000000000000))*(x1726)*(x1736)*(x1737)))+(((x1730)*(x1738)))+(((r11)*(x1734)*(x1737)))+(((IkReal(-1.00000000000000))*(r21)*(x1725)*(x1734)*(x1735)))+(((IkReal(-1.00000000000000))*(r21)*(x1724)*(x1734)*(x1735)))+(((r00)*(x1727)*(x1728)))+(((r11)*(x1731)*(x1733)))+(((IkReal(-1.00000000000000))*(x1726)*(x1727)*(x1733)))+(((r12)*(x1731)*(x1732)))));
IkReal x1739=(cj6)*(cj6);
IkReal x1740=(sj6)*(sj6);
IkReal x1741=((IkReal(1.00000000000000))*(r01));
IkReal x1742=((sj0)*(sj5));
IkReal x1743=((cj6)*(r22));
IkReal x1744=((r21)*(sj6));
IkReal x1745=((r00)*(r21));
IkReal x1746=((cj0)*(sj5));
IkReal x1747=((cj6)*(r20));
IkReal x1748=((r22)*(sj6));
IkReal x1749=((cj0)*(cj5));
IkReal x1750=((IkReal(1.00000000000000))*(r10));
IkReal x1751=((cj5)*(sj0));
IkReal x1752=((r20)*(x1740));
IkReal x1753=((x1739)*(x1751));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r20)*(x1741)*(x1753)))+(((IkReal(-1.00000000000000))*(r21)*(x1740)*(x1749)*(x1750)))+(((IkReal(-1.00000000000000))*(r21)*(x1739)*(x1749)*(x1750)))+(((r00)*(x1742)*(x1743)))+(((x1740)*(x1745)*(x1751)))+(((r11)*(x1749)*(x1752)))+(((r12)*(x1746)*(x1747)))+(((x1745)*(x1753)))+(((r02)*(x1742)*(x1744)))+(((IkReal(-1.00000000000000))*(r12)*(x1744)*(x1746)))+(((IkReal(-1.00000000000000))*(r02)*(x1742)*(x1747)))+(((IkReal(-1.00000000000000))*(x1741)*(x1751)*(x1752)))+(((IkReal(-1.00000000000000))*(x1741)*(x1742)*(x1748)))+(((IkReal(-1.00000000000000))*(x1743)*(x1746)*(x1750)))+(((r11)*(r20)*(x1739)*(x1749)))+(((r11)*(x1746)*(x1748))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1754=((cj5)*(sj6));
IkReal x1755=((cj2)*(r20));
IkReal x1756=((IkReal(1.00000000000000))*(sj6));
IkReal x1757=((cj2)*(r21));
IkReal x1758=((cj0)*(sj2));
IkReal x1759=((cj5)*(cj6));
IkReal x1760=((IkReal(1.00000000000000))*(sj0)*(sj2));
IkReal x1761=((r10)*(x1758));
if( IKabs(((gconst55)*(((((IkReal(-1.00000000000000))*(r11)*(x1756)*(x1758)))+(((r01)*(sj0)*(sj2)*(sj6)))+(((cj6)*(x1761)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x1760)))+(((IkReal(-1.00000000000000))*(x1756)*(x1757)))+(((cj6)*(x1755))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst55)*(((((cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x1754)*(x1760)))+(((IkReal(-1.00000000000000))*(r01)*(x1759)*(x1760)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1760)))+(((x1754)*(x1755)))+(((x1754)*(x1761)))+(((r12)*(sj5)*(x1758)))+(((x1757)*(x1759)))+(((r11)*(x1758)*(x1759))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst55)*(((((IkReal(-1.00000000000000))*(r11)*(x1756)*(x1758)))+(((r01)*(sj0)*(sj2)*(sj6)))+(((cj6)*(x1761)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x1760)))+(((IkReal(-1.00000000000000))*(x1756)*(x1757)))+(((cj6)*(x1755)))))), ((gconst55)*(((((cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x1754)*(x1760)))+(((IkReal(-1.00000000000000))*(r01)*(x1759)*(x1760)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1760)))+(((x1754)*(x1755)))+(((x1754)*(x1761)))+(((r12)*(sj5)*(x1758)))+(((x1757)*(x1759)))+(((r11)*(x1758)*(x1759)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1762=IKsin(j4);
IkReal x1763=IKcos(j4);
IkReal x1764=((r00)*(sj6));
IkReal x1765=((IkReal(1.00000000000000))*(r12));
IkReal x1766=((IkReal(1.00000000000000))*(cj6));
IkReal x1767=((cj6)*(r01));
IkReal x1768=((cj0)*(r11));
IkReal x1769=((r01)*(sj6));
IkReal x1770=((IkReal(1.00000000000000))*(cj5));
IkReal x1771=((cj5)*(r11));
IkReal x1772=((cj0)*(r01));
IkReal x1773=((r02)*(sj5));
IkReal x1774=((cj6)*(r10));
IkReal x1775=((sj5)*(x1762));
IkReal x1776=((cj0)*(x1763));
IkReal x1777=((sj6)*(x1762));
IkReal x1778=((sj0)*(x1763));
IkReal x1779=((r10)*(x1762));
IkReal x1780=((IkReal(1.00000000000000))*(r10)*(sj6));
IkReal x1781=((cj5)*(x1762));
IkReal x1782=((IkReal(1.00000000000000))*(r11)*(sj6));
IkReal x1783=((r00)*(x1762));
IkReal x1784=((r20)*(x1763));
IkReal x1785=((r21)*(x1763));
IkReal x1786=((sj0)*(x1781));
evalcond[0]=((((sj6)*(x1785)))+(sj2)+(((cj5)*(r20)*(x1777)))+(((r22)*(x1775)))+(((IkReal(-1.00000000000000))*(x1766)*(x1784)))+(((cj6)*(r21)*(x1781))));
evalcond[1]=((((cj5)*(cj6)*(x1785)))+(((cj6)*(r20)*(x1762)))+(((r22)*(sj5)*(x1763)))+(((cj5)*(sj6)*(x1784)))+(((IkReal(-1.00000000000000))*(r21)*(x1777)))+(((IkReal(-1.00000000000000))*(cj2)*(cj3))));
evalcond[2]=((((x1769)*(x1778)))+(((IkReal(-1.00000000000000))*(x1766)*(x1768)*(x1781)))+(((IkReal(-1.00000000000000))*(sj6)*(x1763)*(x1768)))+(((x1767)*(x1786)))+(cj2)+(((x1774)*(x1776)))+(((x1764)*(x1786)))+(((sj0)*(x1762)*(x1773)))+(((IkReal(-1.00000000000000))*(r00)*(x1766)*(x1778)))+(((IkReal(-1.00000000000000))*(cj0)*(x1765)*(x1775)))+(((IkReal(-1.00000000000000))*(cj0)*(r10)*(x1770)*(x1777))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x1770)*(x1776)))+(((x1768)*(x1777)))+(((IkReal(-1.00000000000000))*(cj5)*(x1763)*(x1766)*(x1768)))+(((cj5)*(x1764)*(x1778)))+(((cj6)*(sj0)*(x1783)))+(((cj5)*(x1767)*(x1778)))+(((IkReal(-1.00000000000000))*(sj0)*(x1762)*(x1769)))+(((x1773)*(x1778)))+(((IkReal(-1.00000000000000))*(cj0)*(x1766)*(x1779)))+(((IkReal(-1.00000000000000))*(sj5)*(x1765)*(x1776)))+(((cj3)*(sj2))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1778)*(x1782)))+(((cj6)*(r00)*(x1776)))+(((IkReal(-1.00000000000000))*(cj0)*(x1762)*(x1764)*(x1770)))+(((IkReal(-1.00000000000000))*(x1769)*(x1776)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1770)*(x1777)))+(((IkReal(-1.00000000000000))*(sj0)*(x1765)*(x1775)))+(((IkReal(-1.00000000000000))*(cj0)*(x1762)*(x1773)))+(((x1774)*(x1778)))+(((IkReal(-1.00000000000000))*(x1766)*(x1772)*(x1781)))+(((IkReal(-1.00000000000000))*(sj0)*(x1762)*(x1766)*(x1771))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1773)*(x1776)))+(((IkReal(-1.00000000000000))*(sj5)*(x1765)*(x1778)))+(sj3)+(((IkReal(-1.00000000000000))*(cj0)*(x1766)*(x1783)))+(((r11)*(sj0)*(x1777)))+(((IkReal(-1.00000000000000))*(x1766)*(x1771)*(x1778)))+(((IkReal(-1.00000000000000))*(cj5)*(x1763)*(x1766)*(x1772)))+(((cj0)*(x1762)*(x1769)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x1770)*(x1778)))+(((IkReal(-1.00000000000000))*(x1764)*(x1770)*(x1776)))+(((IkReal(-1.00000000000000))*(sj0)*(x1766)*(x1779))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1787=((cj6)*(r20));
IkReal x1788=((r22)*(sj5));
IkReal x1789=((r21)*(sj2));
IkReal x1790=((cj5)*(cj6));
IkReal x1791=((cj5)*(r20)*(sj6));
IkReal x1792=((IkReal(1.00000000000000))*(cj2)*(cj3));
if( IKabs(((gconst54)*(((((IkReal(-1.00000000000000))*(x1787)*(x1792)))+(((cj2)*(cj3)*(r21)*(sj6)))+(((sj2)*(x1788)))+(((sj2)*(x1791)))+(((x1789)*(x1790))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst54)*(((((IkReal(-1.00000000000000))*(r21)*(x1790)*(x1792)))+(((IkReal(-1.00000000000000))*(sj2)*(x1787)))+(((IkReal(-1.00000000000000))*(x1788)*(x1792)))+(((sj6)*(x1789)))+(((IkReal(-1.00000000000000))*(x1791)*(x1792))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst54)*(((((IkReal(-1.00000000000000))*(x1787)*(x1792)))+(((cj2)*(cj3)*(r21)*(sj6)))+(((sj2)*(x1788)))+(((sj2)*(x1791)))+(((x1789)*(x1790)))))), ((gconst54)*(((((IkReal(-1.00000000000000))*(r21)*(x1790)*(x1792)))+(((IkReal(-1.00000000000000))*(sj2)*(x1787)))+(((IkReal(-1.00000000000000))*(x1788)*(x1792)))+(((sj6)*(x1789)))+(((IkReal(-1.00000000000000))*(x1791)*(x1792)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1793=IKsin(j4);
IkReal x1794=IKcos(j4);
IkReal x1795=((r00)*(sj6));
IkReal x1796=((IkReal(1.00000000000000))*(r12));
IkReal x1797=((IkReal(1.00000000000000))*(cj6));
IkReal x1798=((cj6)*(r01));
IkReal x1799=((cj0)*(r11));
IkReal x1800=((r01)*(sj6));
IkReal x1801=((IkReal(1.00000000000000))*(cj5));
IkReal x1802=((cj5)*(r11));
IkReal x1803=((cj0)*(r01));
IkReal x1804=((r02)*(sj5));
IkReal x1805=((cj6)*(r10));
IkReal x1806=((sj5)*(x1793));
IkReal x1807=((cj0)*(x1794));
IkReal x1808=((sj6)*(x1793));
IkReal x1809=((sj0)*(x1794));
IkReal x1810=((r10)*(x1793));
IkReal x1811=((IkReal(1.00000000000000))*(r10)*(sj6));
IkReal x1812=((cj5)*(x1793));
IkReal x1813=((IkReal(1.00000000000000))*(r11)*(sj6));
IkReal x1814=((r00)*(x1793));
IkReal x1815=((r20)*(x1794));
IkReal x1816=((r21)*(x1794));
IkReal x1817=((sj0)*(x1812));
evalcond[0]=((((r22)*(x1806)))+(((sj6)*(x1816)))+(sj2)+(((cj6)*(r21)*(x1812)))+(((cj5)*(r20)*(x1808)))+(((IkReal(-1.00000000000000))*(x1797)*(x1815))));
evalcond[1]=((((r22)*(sj5)*(x1794)))+(((cj6)*(r20)*(x1793)))+(((cj5)*(cj6)*(x1816)))+(((cj5)*(sj6)*(x1815)))+(((IkReal(-1.00000000000000))*(r21)*(x1808)))+(((IkReal(-1.00000000000000))*(cj2)*(cj3))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1797)*(x1799)*(x1812)))+(((sj0)*(x1793)*(x1804)))+(((x1800)*(x1809)))+(((IkReal(-1.00000000000000))*(cj0)*(x1796)*(x1806)))+(((x1795)*(x1817)))+(cj2)+(((x1805)*(x1807)))+(((x1798)*(x1817)))+(((IkReal(-1.00000000000000))*(sj6)*(x1794)*(x1799)))+(((IkReal(-1.00000000000000))*(r00)*(x1797)*(x1809)))+(((IkReal(-1.00000000000000))*(cj0)*(r10)*(x1801)*(x1808))));
evalcond[3]=((((cj6)*(sj0)*(x1814)))+(((x1799)*(x1808)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x1801)*(x1807)))+(((IkReal(-1.00000000000000))*(sj0)*(x1793)*(x1800)))+(((x1804)*(x1809)))+(((cj3)*(sj2)))+(((cj5)*(x1798)*(x1809)))+(((cj5)*(x1795)*(x1809)))+(((IkReal(-1.00000000000000))*(cj0)*(x1797)*(x1810)))+(((IkReal(-1.00000000000000))*(sj5)*(x1796)*(x1807)))+(((IkReal(-1.00000000000000))*(cj5)*(x1794)*(x1797)*(x1799))));
evalcond[4]=((((x1805)*(x1809)))+(((IkReal(-1.00000000000000))*(x1809)*(x1813)))+(((IkReal(-1.00000000000000))*(x1797)*(x1803)*(x1812)))+(((IkReal(-1.00000000000000))*(cj0)*(x1793)*(x1804)))+(((IkReal(-1.00000000000000))*(sj0)*(x1796)*(x1806)))+(((IkReal(-1.00000000000000))*(cj0)*(x1793)*(x1795)*(x1801)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1801)*(x1808)))+(((IkReal(-1.00000000000000))*(sj0)*(x1793)*(x1797)*(x1802)))+(((IkReal(-1.00000000000000))*(x1800)*(x1807)))+(((cj6)*(r00)*(x1807))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1804)*(x1807)))+(((IkReal(-1.00000000000000))*(x1797)*(x1802)*(x1809)))+(((cj0)*(x1793)*(x1800)))+(sj3)+(((IkReal(-1.00000000000000))*(cj5)*(x1794)*(x1797)*(x1803)))+(((IkReal(-1.00000000000000))*(sj0)*(x1797)*(x1810)))+(((IkReal(-1.00000000000000))*(cj0)*(x1797)*(x1814)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x1801)*(x1809)))+(((IkReal(-1.00000000000000))*(sj5)*(x1796)*(x1809)))+(((r11)*(sj0)*(x1808)))+(((IkReal(-1.00000000000000))*(x1795)*(x1801)*(x1807))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1818=((cj5)*(sj6));
IkReal x1819=((cj2)*(r20));
IkReal x1820=((IkReal(1.00000000000000))*(sj6));
IkReal x1821=((cj2)*(r21));
IkReal x1822=((cj5)*(cj6));
IkReal x1823=((IkReal(1.00000000000000))*(sj0)*(sj2));
IkReal x1824=((cj0)*(r10)*(sj2));
IkReal x1825=((cj0)*(r11)*(sj2));
if( IKabs(((gconst52)*(((((IkReal(-1.00000000000000))*(x1820)*(x1821)))+(((r01)*(sj0)*(sj2)*(sj6)))+(((IkReal(-1.00000000000000))*(x1820)*(x1825)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x1823)))+(((cj6)*(x1824)))+(((cj6)*(x1819))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst52)*(((((x1818)*(x1824)))+(((cj2)*(r22)*(sj5)))+(((cj0)*(r12)*(sj2)*(sj5)))+(((x1821)*(x1822)))+(((IkReal(-1.00000000000000))*(r01)*(x1822)*(x1823)))+(((x1818)*(x1819)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1823)))+(((x1822)*(x1825)))+(((IkReal(-1.00000000000000))*(r00)*(x1818)*(x1823))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst52)*(((((IkReal(-1.00000000000000))*(x1820)*(x1821)))+(((r01)*(sj0)*(sj2)*(sj6)))+(((IkReal(-1.00000000000000))*(x1820)*(x1825)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x1823)))+(((cj6)*(x1824)))+(((cj6)*(x1819)))))), ((gconst52)*(((((x1818)*(x1824)))+(((cj2)*(r22)*(sj5)))+(((cj0)*(r12)*(sj2)*(sj5)))+(((x1821)*(x1822)))+(((IkReal(-1.00000000000000))*(r01)*(x1822)*(x1823)))+(((x1818)*(x1819)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1823)))+(((x1822)*(x1825)))+(((IkReal(-1.00000000000000))*(r00)*(x1818)*(x1823)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1826=IKsin(j4);
IkReal x1827=IKcos(j4);
IkReal x1828=((r00)*(sj6));
IkReal x1829=((cj6)*(r01));
IkReal x1830=((IkReal(1.00000000000000))*(cj0));
IkReal x1831=((IkReal(1.00000000000000))*(sj0));
IkReal x1832=((r10)*(sj6));
IkReal x1833=((sj5)*(x1826));
IkReal x1834=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x1835=((cj5)*(x1826));
IkReal x1836=((cj6)*(x1827));
IkReal x1837=((sj0)*(x1835));
IkReal x1838=((r01)*(sj6)*(x1827));
IkReal x1839=((r11)*(sj6)*(x1827));
evalcond[0]=((sj2)+(((r22)*(x1833)))+(((r20)*(sj6)*(x1835)))+(((r21)*(sj6)*(x1827)))+(((IkReal(-1.00000000000000))*(r20)*(x1836)))+(((cj6)*(r21)*(x1835))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1830)*(x1839)))+(((cj0)*(r10)*(x1836)))+(((r02)*(sj0)*(x1833)))+(((IkReal(-1.00000000000000))*(r12)*(x1830)*(x1833)))+(cj2)+(((IkReal(-1.00000000000000))*(x1830)*(x1832)*(x1835)))+(((sj0)*(x1838)))+(((x1828)*(x1837)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1830)*(x1835)))+(((IkReal(-1.00000000000000))*(r00)*(x1831)*(x1836)))+(((x1829)*(x1837))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1831)*(x1839)))+(((IkReal(-1.00000000000000))*(r02)*(x1830)*(x1833)))+(((IkReal(-1.00000000000000))*(x1829)*(x1830)*(x1835)))+(((r10)*(sj0)*(x1836)))+(((IkReal(-1.00000000000000))*(r12)*(x1831)*(x1833)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1831)*(x1835)))+(((IkReal(-1.00000000000000))*(x1830)*(x1838)))+(((IkReal(-1.00000000000000))*(x1831)*(x1832)*(x1835)))+(((IkReal(-1.00000000000000))*(x1828)*(x1830)*(x1835)))+(((cj0)*(r00)*(x1836))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst56;
gconst56=IKsign(cj2);
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x1840=((cj5)*(sj4));
IkReal x1841=((IkReal(1.00000000000000))*(sj6));
IkReal x1842=((r10)*(sj0));
IkReal x1843=((sj4)*(sj5));
IkReal x1844=((cj5)*(cj6));
IkReal x1845=((r01)*(sj0));
IkReal x1846=((IkReal(1.00000000000000))*(r02));
IkReal x1847=((IkReal(0.374290000000000))*(cj0));
IkReal x1848=((cj5)*(r12));
IkReal x1849=((cj6)*(sj5));
IkReal x1850=((cj0)*(r11));
IkReal x1851=((cj5)*(sj0));
IkReal x1852=((r20)*(sj6));
IkReal x1853=((IkReal(1.00000000000000))*(sj0));
IkReal x1854=((cj4)*(cj5));
IkReal x1855=((IkReal(1.00000000000000))*(cj6));
IkReal x1856=((IkReal(0.0100000000000000))*(sj5));
IkReal x1857=((sj5)*(sj6));
IkReal x1858=((cj0)*(r10));
IkReal x1859=((cj4)*(cj6));
IkReal x1860=((cj0)*(r01));
IkReal x1861=((IkReal(1.00000000000000))*(cj4));
IkReal x1862=((cj0)*(r00));
IkReal x1863=((IkReal(0.374290000000000))*(sj0));
IkReal x1864=((cj0)*(r12));
IkReal x1865=((IkReal(0.374290000000000))*(sj5));
IkReal x1866=((cj4)*(sj6));
IkReal x1867=((IkReal(1.00000000000000))*(cj0));
IkReal x1868=((r02)*(sj0));
IkReal x1869=((IkReal(0.0100000000000000))*(cj5));
IkReal x1870=((r11)*(sj0));
IkReal x1871=((r00)*(sj0)*(sj6));
IkReal x1872=((r00)*(x1859));
IkReal x1873=((sj6)*(x1869));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x1866)))+(((cj6)*(r21)*(x1840)))+(((x1840)*(x1852)))+(((r22)*(x1843)))+(((IkReal(-1.00000000000000))*(cj4)*(r20)*(x1855))));
evalcond[2]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(x1852)*(x1869)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-0.0100000000000000))*(r21)*(x1844)))+(((x1852)*(x1865)))+(pz)+(((IkReal(0.374290000000000))*(r21)*(x1849)))+(((IkReal(-1.00000000000000))*(r22)*(x1856))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1846)*(x1851)))+(((x1845)*(x1849)))+(((cj0)*(x1848)))+(((IkReal(-1.00000000000000))*(x1849)*(x1850)))+(((r00)*(sj0)*(x1857)))+(((IkReal(-1.00000000000000))*(sj5)*(x1841)*(x1858))));
evalcond[4]=((IkReal(1.00000000000000))+(((x1845)*(x1866)))+(((IkReal(-1.00000000000000))*(x1853)*(x1872)))+(((IkReal(-1.00000000000000))*(x1840)*(x1850)*(x1855)))+(((x1840)*(x1871)))+(((x1858)*(x1859)))+(((IkReal(-1.00000000000000))*(x1840)*(x1841)*(x1858)))+(((IkReal(-1.00000000000000))*(cj4)*(x1841)*(x1850)))+(((x1843)*(x1868)))+(((cj6)*(x1840)*(x1845)))+(((IkReal(-1.00000000000000))*(x1843)*(x1864))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj4)*(x1841)*(x1845)))+(((r00)*(x1851)*(x1866)))+(((IkReal(-1.00000000000000))*(sj4)*(x1855)*(x1858)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((cj4)*(sj5)*(x1868)))+(((IkReal(-1.00000000000000))*(x1841)*(x1854)*(x1858)))+(((IkReal(-1.00000000000000))*(sj5)*(x1861)*(x1864)))+(((cj4)*(x1844)*(x1845)))+(((sj4)*(sj6)*(x1850)))+(((IkReal(-1.00000000000000))*(x1844)*(x1850)*(x1861))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x1840)*(x1841)*(x1862)))+(((IkReal(-1.00000000000000))*(cj0)*(x1843)*(x1846)))+(((IkReal(-1.00000000000000))*(x1840)*(x1855)*(x1860)))+(((x1859)*(x1862)))+(((IkReal(-1.00000000000000))*(x1840)*(x1841)*(x1842)))+(((IkReal(-1.00000000000000))*(cj4)*(x1841)*(x1870)))+(((x1842)*(x1859)))+(((IkReal(-1.00000000000000))*(cj4)*(x1841)*(x1860)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1840)*(x1853)))+(((IkReal(-1.00000000000000))*(r12)*(x1843)*(x1853))));
evalcond[7]=((((IkReal(0.0100000000000000))*(x1844)*(x1850)))+(((IkReal(-0.0100000000000000))*(x1844)*(x1845)))+(((IkReal(-0.374290000000000))*(r02)*(x1851)))+(((x1847)*(x1848)))+(((r00)*(x1857)*(x1863)))+(((IkReal(-1.00000000000000))*(r11)*(x1847)*(x1849)))+(((x1856)*(x1864)))+(((IkReal(0.374290000000000))*(x1845)*(x1849)))+(((IkReal(-1.00000000000000))*(py)*(x1867)))+(((IkReal(-1.00000000000000))*(r10)*(x1847)*(x1857)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x1851)))+(((IkReal(-1.00000000000000))*(x1856)*(x1868)))+(((px)*(sj0)))+(((x1858)*(x1873))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(-1.00000000000000))*(py)*(x1853)))+(((r12)*(sj0)*(x1856)))+(((cj0)*(r02)*(x1856)))+(((IkReal(0.0100000000000000))*(x1844)*(x1870)))+(((IkReal(-1.00000000000000))*(px)*(x1867)))+(((IkReal(0.0100000000000000))*(x1844)*(x1860)))+(((x1862)*(x1873)))+(((IkReal(-1.00000000000000))*(r01)*(x1847)*(x1849)))+(((cj5)*(r02)*(x1847)))+(((IkReal(-0.374290000000000))*(x1842)*(x1857)))+(((IkReal(-1.00000000000000))*(r00)*(x1847)*(x1857)))+(((x1842)*(x1873)))+(((x1848)*(x1863)))+(((IkReal(-1.00000000000000))*(r11)*(x1849)*(x1863))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1874=((IkReal(1.00000000000000))*(r21));
IkReal x1875=((cj4)*(cj5));
IkReal x1876=((r20)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x1874)))+(((IkReal(-1.00000000000000))*(sj5)*(x1876)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj6)*(r20)*(sj4)))+(((cj6)*(r21)*(x1875)))+(((cj4)*(r22)*(sj5)))+(((x1875)*(x1876)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x1874))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x1874)))+(((IkReal(-1.00000000000000))*(sj5)*(x1876)))+(((cj5)*(r22)))))+IKsqr(((((cj6)*(r20)*(sj4)))+(((cj6)*(r21)*(x1875)))+(((cj4)*(r22)*(sj5)))+(((x1875)*(x1876)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x1874)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x1874)))+(((IkReal(-1.00000000000000))*(sj5)*(x1876)))+(((cj5)*(r22)))), ((((cj6)*(r20)*(sj4)))+(((cj6)*(r21)*(x1875)))+(((cj4)*(r22)*(sj5)))+(((x1875)*(x1876)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x1874)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1877=IKcos(j3);
IkReal x1878=IKsin(j3);
IkReal x1879=((IkReal(1.00000000000000))*(cj4));
IkReal x1880=((sj0)*(sj5));
IkReal x1881=((cj0)*(cj5));
IkReal x1882=((cj6)*(r01));
IkReal x1883=((r00)*(sj6));
IkReal x1884=((cj6)*(r11));
IkReal x1885=((cj5)*(sj0));
IkReal x1886=((cj6)*(sj4));
IkReal x1887=((sj4)*(sj6));
IkReal x1888=((cj4)*(cj5));
IkReal x1889=((cj6)*(r21));
IkReal x1890=((r20)*(sj6));
IkReal x1891=((r10)*(sj6));
IkReal x1892=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(x1878)+(((sj5)*(x1889)))+(((sj5)*(x1890))));
evalcond[1]=((((x1888)*(x1889)))+(((x1888)*(x1890)))+(((IkReal(-1.00000000000000))*(r21)*(x1887)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x1886)))+(((IkReal(-1.00000000000000))*(x1877))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1880)*(x1891)))+(((r12)*(x1885)))+(((r02)*(x1881)))+(((IkReal(-1.00000000000000))*(x1883)*(x1892)))+(x1877)+(((IkReal(-1.00000000000000))*(x1880)*(x1884)))+(((IkReal(-1.00000000000000))*(x1882)*(x1892))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1886)))+(((r11)*(sj0)*(x1887)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1886)))+(((IkReal(-1.00000000000000))*(x1879)*(x1881)*(x1882)))+(((IkReal(-1.00000000000000))*(x1879)*(x1881)*(x1883)))+(((IkReal(-1.00000000000000))*(r12)*(x1879)*(x1880)))+(((IkReal(-1.00000000000000))*(x1879)*(x1885)*(x1891)))+(x1878)+(((cj0)*(r01)*(x1887)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x1879)))+(((IkReal(-1.00000000000000))*(x1879)*(x1884)*(x1885))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x1893=((cj5)*(sj4));
IkReal x1894=((IkReal(1.00000000000000))*(sj6));
IkReal x1895=((r10)*(sj0));
IkReal x1896=((sj4)*(sj5));
IkReal x1897=((cj5)*(cj6));
IkReal x1898=((r01)*(sj0));
IkReal x1899=((IkReal(1.00000000000000))*(r02));
IkReal x1900=((IkReal(0.374290000000000))*(cj0));
IkReal x1901=((cj5)*(r12));
IkReal x1902=((cj6)*(sj5));
IkReal x1903=((cj0)*(r11));
IkReal x1904=((cj5)*(sj0));
IkReal x1905=((r20)*(sj6));
IkReal x1906=((IkReal(1.00000000000000))*(sj0));
IkReal x1907=((cj4)*(cj5));
IkReal x1908=((IkReal(1.00000000000000))*(cj6));
IkReal x1909=((IkReal(0.0100000000000000))*(sj5));
IkReal x1910=((sj5)*(sj6));
IkReal x1911=((cj0)*(r10));
IkReal x1912=((cj4)*(cj6));
IkReal x1913=((cj0)*(r01));
IkReal x1914=((IkReal(1.00000000000000))*(cj4));
IkReal x1915=((cj0)*(r00));
IkReal x1916=((IkReal(0.374290000000000))*(sj0));
IkReal x1917=((cj0)*(r12));
IkReal x1918=((IkReal(0.374290000000000))*(sj5));
IkReal x1919=((cj4)*(sj6));
IkReal x1920=((IkReal(1.00000000000000))*(cj0));
IkReal x1921=((r02)*(sj0));
IkReal x1922=((IkReal(0.0100000000000000))*(cj5));
IkReal x1923=((r11)*(sj0));
IkReal x1924=((r00)*(sj0)*(sj6));
IkReal x1925=((r00)*(x1912));
IkReal x1926=((sj6)*(x1922));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j2, IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj4)*(r20)*(x1908)))+(((r21)*(x1919)))+(((r22)*(x1896)))+(((x1893)*(x1905)))+(((cj6)*(r21)*(x1893))));
evalcond[2]=((IkReal(0.0690000000000000))+(((IkReal(0.374290000000000))*(r21)*(x1902)))+(((IkReal(-1.00000000000000))*(r22)*(x1909)))+(((IkReal(-0.0100000000000000))*(r21)*(x1897)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((x1905)*(x1918)))+(((IkReal(-1.00000000000000))*(x1905)*(x1922)))+(pz));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x1894)*(x1911)))+(((r00)*(sj0)*(x1910)))+(((cj0)*(x1901)))+(((x1898)*(x1902)))+(((IkReal(-1.00000000000000))*(x1899)*(x1904)))+(((IkReal(-1.00000000000000))*(x1902)*(x1903))));
evalcond[4]=((IkReal(-1.00000000000000))+(((cj6)*(x1893)*(x1898)))+(((IkReal(-1.00000000000000))*(x1893)*(x1894)*(x1911)))+(((IkReal(-1.00000000000000))*(x1896)*(x1917)))+(((x1893)*(x1924)))+(((IkReal(-1.00000000000000))*(cj4)*(x1894)*(x1903)))+(((x1911)*(x1912)))+(((IkReal(-1.00000000000000))*(x1906)*(x1925)))+(((x1898)*(x1919)))+(((IkReal(-1.00000000000000))*(x1893)*(x1903)*(x1908)))+(((x1896)*(x1921))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj4)*(x1894)*(x1898)))+(((cj4)*(sj5)*(x1921)))+(((cj4)*(x1897)*(x1898)))+(((r00)*(x1904)*(x1919)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((sj4)*(sj6)*(x1903)))+(((IkReal(-1.00000000000000))*(sj5)*(x1914)*(x1917)))+(((IkReal(-1.00000000000000))*(x1897)*(x1903)*(x1914)))+(((IkReal(-1.00000000000000))*(x1894)*(x1907)*(x1911)))+(((IkReal(-1.00000000000000))*(sj4)*(x1908)*(x1911))));
evalcond[6]=((((x1912)*(x1915)))+(((IkReal(-1.00000000000000))*(x1893)*(x1894)*(x1915)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1893)*(x1906)))+(((IkReal(-1.00000000000000))*(cj0)*(x1896)*(x1899)))+(((IkReal(-1.00000000000000))*(cj4)*(x1894)*(x1923)))+(((IkReal(-1.00000000000000))*(x1893)*(x1894)*(x1895)))+(((IkReal(-1.00000000000000))*(cj4)*(x1894)*(x1913)))+(((IkReal(-1.00000000000000))*(r12)*(x1896)*(x1906)))+(((IkReal(-1.00000000000000))*(x1893)*(x1908)*(x1913)))+(((x1895)*(x1912))));
evalcond[7]=((((IkReal(0.0100000000000000))*(x1897)*(x1903)))+(((x1900)*(x1901)))+(((IkReal(-0.374290000000000))*(r02)*(x1904)))+(((IkReal(-0.0100000000000000))*(x1897)*(x1898)))+(((IkReal(-1.00000000000000))*(x1909)*(x1921)))+(((IkReal(-1.00000000000000))*(py)*(x1920)))+(((x1911)*(x1926)))+(((r00)*(x1910)*(x1916)))+(((IkReal(-1.00000000000000))*(r11)*(x1900)*(x1902)))+(((x1909)*(x1917)))+(((IkReal(-1.00000000000000))*(r10)*(x1900)*(x1910)))+(((IkReal(0.374290000000000))*(x1898)*(x1902)))+(((px)*(sj0)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x1904))));
evalcond[8]=((IkReal(-0.295420000000000))+(((cj0)*(r02)*(x1909)))+(((IkReal(-1.00000000000000))*(py)*(x1906)))+(((IkReal(-1.00000000000000))*(r00)*(x1900)*(x1910)))+(((x1901)*(x1916)))+(((x1895)*(x1926)))+(((IkReal(-1.00000000000000))*(px)*(x1920)))+(((IkReal(-1.00000000000000))*(r11)*(x1902)*(x1916)))+(((r12)*(sj0)*(x1909)))+(((x1915)*(x1926)))+(((cj5)*(r02)*(x1900)))+(((IkReal(-1.00000000000000))*(r01)*(x1900)*(x1902)))+(((IkReal(-0.374290000000000))*(x1895)*(x1910)))+(((IkReal(0.0100000000000000))*(x1897)*(x1913)))+(((IkReal(0.0100000000000000))*(x1897)*(x1923))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1927=((IkReal(1.00000000000000))*(cj4));
IkReal x1928=((cj6)*(r21));
IkReal x1929=((r20)*(sj6));
if( IKabs(((((sj5)*(x1929)))+(((sj5)*(x1928)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj5)*(x1927)*(x1928)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1927)))+(((IkReal(-1.00000000000000))*(cj5)*(x1927)*(x1929)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x1929)))+(((sj5)*(x1928)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(x1927)*(x1928)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1927)))+(((IkReal(-1.00000000000000))*(cj5)*(x1927)*(x1929)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x1929)))+(((sj5)*(x1928)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((IkReal(-1.00000000000000))*(cj5)*(x1927)*(x1928)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1927)))+(((IkReal(-1.00000000000000))*(cj5)*(x1927)*(x1929)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1930=IKcos(j3);
IkReal x1931=IKsin(j3);
IkReal x1932=((IkReal(1.00000000000000))*(cj4));
IkReal x1933=((sj0)*(sj5));
IkReal x1934=((cj0)*(cj5));
IkReal x1935=((cj6)*(r01));
IkReal x1936=((r00)*(sj6));
IkReal x1937=((cj6)*(r11));
IkReal x1938=((cj5)*(sj0));
IkReal x1939=((cj6)*(sj4));
IkReal x1940=((sj4)*(sj6));
IkReal x1941=((cj4)*(cj5));
IkReal x1942=((cj6)*(r21));
IkReal x1943=((r20)*(sj6));
IkReal x1944=((r10)*(sj6));
IkReal x1945=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((((sj5)*(x1943)))+(((IkReal(-1.00000000000000))*(x1931)))+(((sj5)*(x1942)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((x1930)+(((IkReal(-1.00000000000000))*(r21)*(x1940)))+(((x1941)*(x1943)))+(((r20)*(x1939)))+(((cj4)*(r22)*(sj5)))+(((x1941)*(x1942))));
evalcond[2]=((x1930)+(((r02)*(x1934)))+(((IkReal(-1.00000000000000))*(x1936)*(x1945)))+(((r12)*(x1938)))+(((IkReal(-1.00000000000000))*(x1935)*(x1945)))+(((IkReal(-1.00000000000000))*(x1933)*(x1937)))+(((IkReal(-1.00000000000000))*(x1933)*(x1944))));
evalcond[3]=((x1931)+(((IkReal(-1.00000000000000))*(r12)*(x1932)*(x1933)))+(((IkReal(-1.00000000000000))*(x1932)*(x1934)*(x1936)))+(((IkReal(-1.00000000000000))*(x1932)*(x1938)*(x1944)))+(((cj0)*(r01)*(x1940)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x1932)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1939)))+(((r11)*(sj0)*(x1940)))+(((IkReal(-1.00000000000000))*(x1932)*(x1934)*(x1935)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1939)))+(((IkReal(-1.00000000000000))*(x1932)*(x1937)*(x1938))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x1946=((IkReal(1.00000000000000))*(cj0));
IkReal x1947=((cj4)*(sj6));
IkReal x1948=((sj0)*(sj4));
IkReal x1949=((cj5)*(sj6));
IkReal x1950=((sj4)*(sj5));
IkReal x1951=((r12)*(sj5));
IkReal x1952=((IkReal(0.374290000000000))*(cj5));
IkReal x1953=((r02)*(sj0));
IkReal x1954=((r20)*(sj4));
IkReal x1955=((IkReal(1.00000000000000))*(sj0));
IkReal x1956=((IkReal(1.00000000000000))*(cj5));
IkReal x1957=((cj0)*(r10));
IkReal x1958=((cj4)*(cj6));
IkReal x1959=((r00)*(sj0));
IkReal x1960=((cj6)*(r21));
IkReal x1961=((IkReal(0.374290000000000))*(sj5));
IkReal x1962=((cj0)*(r00));
IkReal x1963=((IkReal(0.0100000000000000))*(sj5));
IkReal x1964=((cj0)*(r02));
IkReal x1965=((cj5)*(sj4));
IkReal x1966=((cj6)*(r01));
IkReal x1967=((cj6)*(r11));
IkReal x1968=((r01)*(sj0));
IkReal x1969=((r10)*(sj0));
IkReal x1970=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x1971=((sj6)*(x1961));
IkReal x1972=((cj0)*(cj6)*(x1961));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x1956)))+(((sj5)*(x1960)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(1.00000000000000))+(((r21)*(x1947)))+(((x1949)*(x1954)))+(((x1960)*(x1965)))+(((IkReal(-1.00000000000000))*(r20)*(x1958)))+(((r22)*(x1950))));
evalcond[3]=((((r20)*(x1971)))+(((IkReal(-0.0100000000000000))*(r20)*(x1949)))+(((IkReal(-1.00000000000000))*(r22)*(x1963)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x1952)))+(((x1960)*(x1961)))+(((IkReal(-0.0100000000000000))*(cj5)*(x1960))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj5)*(r20)*(x1947)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r21)*(x1958)))+(((cj6)*(x1954))));
evalcond[5]=((((cj5)*(x1948)*(x1966)))+(((x1957)*(x1958)))+(((x1947)*(x1968)))+(((r00)*(x1948)*(x1949)))+(((IkReal(-1.00000000000000))*(r11)*(x1946)*(x1947)))+(((IkReal(-1.00000000000000))*(x1946)*(x1965)*(x1967)))+(((r02)*(sj5)*(x1948)))+(((IkReal(-1.00000000000000))*(r12)*(x1946)*(x1950)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x1946)*(x1949)))+(((IkReal(-1.00000000000000))*(r00)*(x1955)*(x1958))));
evalcond[6]=((((x1958)*(x1969)))+(((IkReal(-1.00000000000000))*(x1946)*(x1965)*(x1966)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x1946)*(x1949)))+(((IkReal(-1.00000000000000))*(r11)*(x1947)*(x1955)))+(((IkReal(-1.00000000000000))*(r02)*(x1946)*(x1950)))+(((IkReal(-1.00000000000000))*(r10)*(x1948)*(x1949)))+(((IkReal(-1.00000000000000))*(r01)*(x1946)*(x1947)))+(((IkReal(-1.00000000000000))*(x1948)*(x1951)))+(((IkReal(-1.00000000000000))*(x1948)*(x1956)*(x1967)))+(((x1958)*(x1962))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(x1961)*(x1967)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x1966)))+(((IkReal(-0.0100000000000000))*(x1949)*(x1959)))+(((cj0)*(r12)*(x1952)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x1967)))+(((IkReal(-1.00000000000000))*(x1953)*(x1963)))+(((IkReal(-1.00000000000000))*(x1957)*(x1971)))+(((IkReal(-1.00000000000000))*(x1952)*(x1953)))+(((IkReal(0.0100000000000000))*(x1949)*(x1957)))+(((IkReal(0.0100000000000000))*(cj0)*(x1951)))+(((px)*(sj0)))+(((x1959)*(x1971)))+(((IkReal(-1.00000000000000))*(py)*(x1946)))+(((sj0)*(x1961)*(x1966))));
evalcond[8]=((IkReal(-0.295420000000000))+(((r12)*(sj0)*(x1952)))+(((x1963)*(x1964)))+(((IkReal(0.0100000000000000))*(sj0)*(x1951)))+(((IkReal(-1.00000000000000))*(px)*(x1946)))+(((IkReal(-1.00000000000000))*(sj0)*(x1961)*(x1967)))+(((IkReal(0.0100000000000000))*(x1949)*(x1969)))+(((IkReal(-1.00000000000000))*(cj0)*(x1961)*(x1966)))+(((IkReal(-1.00000000000000))*(x1969)*(x1971)))+(((IkReal(-1.00000000000000))*(py)*(x1955)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x1966)))+(((IkReal(-1.00000000000000))*(x1962)*(x1971)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x1967)))+(((IkReal(0.0100000000000000))*(x1949)*(x1962)))+(((x1952)*(x1964))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1973=((sj0)*(sj5));
IkReal x1974=((r00)*(sj6));
IkReal x1975=((IkReal(1.00000000000000))*(cj5));
IkReal x1976=((cj6)*(r11));
IkReal x1977=((cj6)*(r01));
IkReal x1978=((r10)*(sj6));
IkReal x1979=((cj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(x1978)*(x1979)))+(((IkReal(-1.00000000000000))*(x1976)*(x1979)))+(((x1973)*(x1974)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1975)))+(((cj0)*(cj5)*(r12)))+(((x1973)*(x1977))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1975)))+(((x1974)*(x1979)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1975)))+(((x1973)*(x1976)))+(((x1973)*(x1978)))+(((x1977)*(x1979))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x1978)*(x1979)))+(((IkReal(-1.00000000000000))*(x1976)*(x1979)))+(((x1973)*(x1974)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1975)))+(((cj0)*(cj5)*(r12)))+(((x1973)*(x1977)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1975)))+(((x1974)*(x1979)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1975)))+(((x1973)*(x1976)))+(((x1973)*(x1978)))+(((x1977)*(x1979)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x1978)*(x1979)))+(((IkReal(-1.00000000000000))*(x1976)*(x1979)))+(((x1973)*(x1974)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1975)))+(((cj0)*(cj5)*(r12)))+(((x1973)*(x1977)))), ((((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1975)))+(((x1974)*(x1979)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1975)))+(((x1973)*(x1976)))+(((x1973)*(x1978)))+(((x1977)*(x1979)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1980=IKcos(j3);
IkReal x1981=IKsin(j3);
IkReal x1982=((sj0)*(sj5));
IkReal x1983=((r00)*(sj6));
IkReal x1984=((cj6)*(sj0));
IkReal x1985=((IkReal(1.00000000000000))*(cj4));
IkReal x1986=((r00)*(sj4));
IkReal x1987=((cj0)*(cj5));
IkReal x1988=((cj5)*(sj0));
IkReal x1989=((cj6)*(r11));
IkReal x1990=((r10)*(sj6));
IkReal x1991=((cj0)*(sj5));
IkReal x1992=((r10)*(sj4));
IkReal x1993=((cj4)*(cj5)*(r01));
IkReal x1994=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x1995=((cj0)*(sj4)*(sj6));
IkReal x1996=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(r02)*(x1988)))+(((x1982)*(x1983)))+(((cj6)*(r01)*(x1982)))+(((IkReal(-1.00000000000000))*(x1989)*(x1991)))+(((IkReal(-1.00000000000000))*(x1981)))+(((IkReal(-1.00000000000000))*(x1990)*(x1991)))+(((r12)*(x1987))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1991)))+(x1980)+(((r12)*(x1988)))+(((IkReal(-1.00000000000000))*(x1982)*(x1989)))+(((IkReal(-1.00000000000000))*(x1983)*(x1991)))+(((r02)*(x1987)))+(((IkReal(-1.00000000000000))*(x1982)*(x1990))));
evalcond[2]=((((cj4)*(x1983)*(x1988)))+(x1980)+(((r11)*(x1995)))+(((IkReal(-1.00000000000000))*(x1992)*(x1994)))+(((cj4)*(r02)*(x1982)))+(((x1984)*(x1993)))+(((IkReal(-1.00000000000000))*(r12)*(x1985)*(x1991)))+(((IkReal(-1.00000000000000))*(x1985)*(x1987)*(x1990)))+(((IkReal(-1.00000000000000))*(r01)*(x1996)))+(((IkReal(-1.00000000000000))*(x1985)*(x1987)*(x1989)))+(((x1984)*(x1986))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1984)*(x1992)))+(x1981)+(((IkReal(-1.00000000000000))*(r02)*(x1985)*(x1991)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1985)*(x1987)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1984)*(x1985)))+(((IkReal(-1.00000000000000))*(x1986)*(x1994)))+(((IkReal(-1.00000000000000))*(x1983)*(x1985)*(x1987)))+(((r01)*(x1995)))+(((r11)*(x1996)))+(((IkReal(-1.00000000000000))*(x1985)*(x1988)*(x1990)))+(((IkReal(-1.00000000000000))*(r12)*(x1982)*(x1985))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x1997=((IkReal(1.00000000000000))*(cj0));
IkReal x1998=((cj4)*(sj6));
IkReal x1999=((sj0)*(sj4));
IkReal x2000=((cj5)*(sj6));
IkReal x2001=((sj4)*(sj5));
IkReal x2002=((r12)*(sj5));
IkReal x2003=((IkReal(0.374290000000000))*(cj5));
IkReal x2004=((r02)*(sj0));
IkReal x2005=((r20)*(sj4));
IkReal x2006=((IkReal(1.00000000000000))*(sj0));
IkReal x2007=((IkReal(1.00000000000000))*(cj5));
IkReal x2008=((cj0)*(r10));
IkReal x2009=((cj4)*(cj6));
IkReal x2010=((r00)*(sj0));
IkReal x2011=((cj6)*(r21));
IkReal x2012=((IkReal(0.374290000000000))*(sj5));
IkReal x2013=((cj0)*(r00));
IkReal x2014=((IkReal(0.0100000000000000))*(sj5));
IkReal x2015=((cj0)*(r02));
IkReal x2016=((cj5)*(sj4));
IkReal x2017=((cj6)*(r01));
IkReal x2018=((cj6)*(r11));
IkReal x2019=((r01)*(sj0));
IkReal x2020=((r10)*(sj0));
IkReal x2021=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x2022=((sj6)*(x2012));
IkReal x2023=((cj0)*(cj6)*(x2012));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x2011)))+(((IkReal(-1.00000000000000))*(r22)*(x2007)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(-1.00000000000000))+(((r22)*(x2001)))+(((r21)*(x1998)))+(((x2000)*(x2005)))+(((IkReal(-1.00000000000000))*(r20)*(x2009)))+(((x2011)*(x2016))));
evalcond[3]=((((IkReal(-0.0100000000000000))*(cj5)*(x2011)))+(((x2011)*(x2012)))+(((IkReal(-1.00000000000000))*(r22)*(x2003)))+(((IkReal(-0.0100000000000000))*(r20)*(x2000)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x2014)))+(((r20)*(x2022))));
evalcond[4]=((((cj5)*(r21)*(x2009)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(x2005)))+(((cj5)*(r20)*(x1998))));
evalcond[5]=((((r02)*(sj5)*(x1999)))+(((x1998)*(x2019)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x1997)*(x2000)))+(((x2008)*(x2009)))+(((r00)*(x1999)*(x2000)))+(((IkReal(-1.00000000000000))*(r00)*(x2006)*(x2009)))+(((IkReal(-1.00000000000000))*(x1997)*(x2016)*(x2018)))+(((IkReal(-1.00000000000000))*(r11)*(x1997)*(x1998)))+(((IkReal(-1.00000000000000))*(r12)*(x1997)*(x2001)))+(((cj5)*(x1999)*(x2017))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r01)*(x1997)*(x1998)))+(((IkReal(-1.00000000000000))*(x1999)*(x2002)))+(((x2009)*(x2020)))+(((x2009)*(x2013)))+(((IkReal(-1.00000000000000))*(r10)*(x1999)*(x2000)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x1997)*(x2000)))+(((IkReal(-1.00000000000000))*(r02)*(x1997)*(x2001)))+(((IkReal(-1.00000000000000))*(x1999)*(x2007)*(x2018)))+(((IkReal(-1.00000000000000))*(x1997)*(x2016)*(x2017)))+(((IkReal(-1.00000000000000))*(r11)*(x1998)*(x2006))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(x2008)*(x2022)))+(((IkReal(-1.00000000000000))*(cj0)*(x2012)*(x2018)))+(((IkReal(-1.00000000000000))*(x2004)*(x2014)))+(((x2010)*(x2022)))+(((IkReal(-1.00000000000000))*(py)*(x1997)))+(((IkReal(0.0100000000000000))*(cj0)*(x2002)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x2017)))+(((IkReal(-0.0100000000000000))*(x2000)*(x2010)))+(((IkReal(-1.00000000000000))*(x2003)*(x2004)))+(((cj0)*(r12)*(x2003)))+(((px)*(sj0)))+(((sj0)*(x2012)*(x2017)))+(((IkReal(0.0100000000000000))*(x2000)*(x2008)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x2018))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(0.0100000000000000))*(sj0)*(x2002)))+(((r12)*(sj0)*(x2003)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x2018)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x2017)))+(((x2014)*(x2015)))+(((IkReal(-1.00000000000000))*(sj0)*(x2012)*(x2018)))+(((IkReal(0.0100000000000000))*(x2000)*(x2013)))+(((IkReal(-1.00000000000000))*(cj0)*(x2012)*(x2017)))+(((IkReal(-1.00000000000000))*(x2020)*(x2022)))+(((IkReal(-1.00000000000000))*(py)*(x2006)))+(((IkReal(-1.00000000000000))*(x2013)*(x2022)))+(((IkReal(-1.00000000000000))*(px)*(x1997)))+(((IkReal(0.0100000000000000))*(x2000)*(x2020)))+(((x2003)*(x2015))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2024=((IkReal(1.00000000000000))*(cj5));
IkReal x2025=((r10)*(sj5)*(sj6));
IkReal x2026=((cj6)*(sj0)*(sj5));
IkReal x2027=((r00)*(sj5)*(sj6));
IkReal x2028=((cj0)*(cj6)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r01)*(x2026)))+(((r11)*(x2028)))+(((cj0)*(x2025)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2024)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(sj0)*(x2027))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj0)*(x2027)))+(((sj0)*(x2025)))+(((r01)*(x2028)))+(((r11)*(x2026)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2024)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2024))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r01)*(x2026)))+(((r11)*(x2028)))+(((cj0)*(x2025)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2024)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(sj0)*(x2027)))))+IKsqr(((((cj0)*(x2027)))+(((sj0)*(x2025)))+(((r01)*(x2028)))+(((r11)*(x2026)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2024)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2024)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r01)*(x2026)))+(((r11)*(x2028)))+(((cj0)*(x2025)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2024)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(sj0)*(x2027)))), ((((cj0)*(x2027)))+(((sj0)*(x2025)))+(((r01)*(x2028)))+(((r11)*(x2026)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2024)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2024)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2029=IKcos(j3);
IkReal x2030=IKsin(j3);
IkReal x2031=((sj0)*(sj5));
IkReal x2032=((r00)*(sj6));
IkReal x2033=((IkReal(1.00000000000000))*(cj4));
IkReal x2034=((cj6)*(sj0));
IkReal x2035=((r00)*(sj4));
IkReal x2036=((cj0)*(cj5));
IkReal x2037=((cj6)*(r01));
IkReal x2038=((cj5)*(sj0));
IkReal x2039=((cj0)*(sj5));
IkReal x2040=((cj6)*(r11));
IkReal x2041=((r10)*(sj6));
IkReal x2042=((r10)*(sj4));
IkReal x2043=((cj0)*(sj4)*(sj6));
IkReal x2044=((sj0)*(sj4)*(sj6));
IkReal x2045=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((x2030)+(((x2031)*(x2032)))+(((IkReal(-1.00000000000000))*(r02)*(x2038)))+(((IkReal(-1.00000000000000))*(x2039)*(x2040)))+(((r12)*(x2036)))+(((x2031)*(x2037)))+(((IkReal(-1.00000000000000))*(x2039)*(x2041))));
evalcond[1]=((x2029)+(((IkReal(-1.00000000000000))*(x2032)*(x2039)))+(((r02)*(x2036)))+(((IkReal(-1.00000000000000))*(x2031)*(x2041)))+(((IkReal(-1.00000000000000))*(x2037)*(x2039)))+(((r12)*(x2038)))+(((IkReal(-1.00000000000000))*(x2031)*(x2040))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2029)))+(((cj4)*(x2032)*(x2038)))+(((IkReal(-1.00000000000000))*(x2033)*(x2036)*(x2041)))+(((IkReal(-1.00000000000000))*(r12)*(x2033)*(x2039)))+(((IkReal(-1.00000000000000))*(x2042)*(x2045)))+(((IkReal(-1.00000000000000))*(x2033)*(x2036)*(x2040)))+(((IkReal(-1.00000000000000))*(r01)*(x2044)))+(((r11)*(x2043)))+(((cj4)*(cj5)*(r01)*(x2034)))+(((cj4)*(r02)*(x2031)))+(((x2034)*(x2035))));
evalcond[3]=((x2030)+(((r01)*(x2043)))+(((IkReal(-1.00000000000000))*(r02)*(x2033)*(x2039)))+(((r11)*(x2044)))+(((IkReal(-1.00000000000000))*(x2034)*(x2042)))+(((IkReal(-1.00000000000000))*(r12)*(x2031)*(x2033)))+(((IkReal(-1.00000000000000))*(x2032)*(x2033)*(x2036)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x2033)*(x2034)))+(((IkReal(-1.00000000000000))*(x2033)*(x2038)*(x2041)))+(((IkReal(-1.00000000000000))*(x2033)*(x2036)*(x2037)))+(((IkReal(-1.00000000000000))*(x2035)*(x2045))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2046=((sj0)*(sj5));
IkReal x2047=((r00)*(sj6));
IkReal x2048=((IkReal(1.00000000000000))*(cj5));
IkReal x2049=((cj6)*(r11));
IkReal x2050=((cj6)*(r01));
IkReal x2051=((cj0)*(sj5));
IkReal x2052=((r10)*(sj6));
if( IKabs(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2049)*(x2051)))+(((x2046)*(x2047)))+(((x2046)*(x2050)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2048)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2051)*(x2052))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2048)))+(((x2046)*(x2052)))+(((x2050)*(x2051)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2048)))+(((x2046)*(x2049)))+(((x2047)*(x2051))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2049)*(x2051)))+(((x2046)*(x2047)))+(((x2046)*(x2050)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2048)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2051)*(x2052)))))))+IKsqr(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2048)))+(((x2046)*(x2052)))+(((x2050)*(x2051)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2048)))+(((x2046)*(x2049)))+(((x2047)*(x2051)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2049)*(x2051)))+(((x2046)*(x2047)))+(((x2046)*(x2050)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2048)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2051)*(x2052)))))), ((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2048)))+(((x2046)*(x2052)))+(((x2050)*(x2051)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2048)))+(((x2046)*(x2049)))+(((x2047)*(x2051)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2053=IKsin(j3);
IkReal x2054=IKcos(j3);
IkReal x2055=((sj0)*(sj5));
IkReal x2056=((r00)*(sj6));
IkReal x2057=((IkReal(1.00000000000000))*(cj4));
IkReal x2058=((cj6)*(r01));
IkReal x2059=((cj0)*(cj5));
IkReal x2060=((cj5)*(sj0));
IkReal x2061=((cj6)*(r11));
IkReal x2062=((cj6)*(sj4));
IkReal x2063=((cj0)*(sj5));
IkReal x2064=((cj4)*(cj5));
IkReal x2065=((cj6)*(r21));
IkReal x2066=((r20)*(sj6));
IkReal x2067=((r10)*(sj6));
IkReal x2068=((IkReal(1.00000000000000))*(cj0));
IkReal x2069=((cj0)*(sj4)*(sj6));
IkReal x2070=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x2066)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((cj2)*(x2053)))+(((sj5)*(x2065))));
evalcond[1]=((((r20)*(x2062)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x2064)*(x2066)))+(((IkReal(-1.00000000000000))*(cj2)*(x2054)))+(((cj4)*(r22)*(sj5)))+(((x2064)*(x2065))));
evalcond[2]=((((x2055)*(x2056)))+(((IkReal(-1.00000000000000))*(x2063)*(x2067)))+(((IkReal(-1.00000000000000))*(r02)*(x2060)))+(((IkReal(-1.00000000000000))*(sj2)*(x2053)))+(((x2055)*(x2058)))+(((r12)*(x2059)))+(((IkReal(-1.00000000000000))*(x2061)*(x2063))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x2055)*(x2061)))+(((r02)*(x2059)))+(((IkReal(-1.00000000000000))*(x2058)*(x2063)))+(x2054)+(((IkReal(-1.00000000000000))*(x2056)*(x2063)))+(((r12)*(x2060)))+(((IkReal(-1.00000000000000))*(x2055)*(x2067))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r01)*(x2070)))+(((IkReal(-1.00000000000000))*(r12)*(x2057)*(x2063)))+(((r00)*(sj0)*(x2062)))+(((cj4)*(r02)*(x2055)))+(((IkReal(-1.00000000000000))*(r10)*(x2062)*(x2068)))+(((IkReal(-1.00000000000000))*(x2057)*(x2059)*(x2061)))+(((r11)*(x2069)))+(((cj4)*(x2058)*(x2060)))+(((IkReal(-1.00000000000000))*(x2057)*(x2059)*(x2067)))+(((cj4)*(x2056)*(x2060)))+(((sj2)*(x2054))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2057)*(x2058)*(x2059)))+(((IkReal(-1.00000000000000))*(x2057)*(x2060)*(x2061)))+(x2053)+(((IkReal(-1.00000000000000))*(r12)*(x2055)*(x2057)))+(((r01)*(x2069)))+(((IkReal(-1.00000000000000))*(r00)*(x2062)*(x2068)))+(((r11)*(x2070)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2062)))+(((IkReal(-1.00000000000000))*(x2057)*(x2060)*(x2067)))+(((IkReal(-1.00000000000000))*(x2056)*(x2057)*(x2059)))+(((IkReal(-1.00000000000000))*(r02)*(x2057)*(x2063))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2071=((cj6)*(sj5));
IkReal x2072=((IkReal(1.00000000000000))*(cj5));
IkReal x2073=((sj5)*(sj6));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r21)*(x2071)))+(((IkReal(-1.00000000000000))*(r20)*(x2073)))+(((cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r11)*(sj0)*(x2071)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2072)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2072)))+(((cj0)*(r01)*(x2071)))+(((cj0)*(r00)*(x2073)))+(((r10)*(sj0)*(x2073))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r21)*(x2071)))+(((IkReal(-1.00000000000000))*(r20)*(x2073)))+(((cj5)*(r22)))))))+IKsqr(((((r11)*(sj0)*(x2071)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2072)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2072)))+(((cj0)*(r01)*(x2071)))+(((cj0)*(r00)*(x2073)))+(((r10)*(sj0)*(x2073)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r21)*(x2071)))+(((IkReal(-1.00000000000000))*(r20)*(x2073)))+(((cj5)*(r22)))))), ((((r11)*(sj0)*(x2071)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2072)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2072)))+(((cj0)*(r01)*(x2071)))+(((cj0)*(r00)*(x2073)))+(((r10)*(sj0)*(x2073)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2074=IKsin(j3);
IkReal x2075=IKcos(j3);
IkReal x2076=((sj0)*(sj5));
IkReal x2077=((r00)*(sj6));
IkReal x2078=((IkReal(1.00000000000000))*(cj4));
IkReal x2079=((cj6)*(r01));
IkReal x2080=((cj0)*(cj5));
IkReal x2081=((cj5)*(sj0));
IkReal x2082=((cj6)*(r11));
IkReal x2083=((cj6)*(sj4));
IkReal x2084=((cj0)*(sj5));
IkReal x2085=((cj4)*(cj5));
IkReal x2086=((cj6)*(r21));
IkReal x2087=((r20)*(sj6));
IkReal x2088=((r10)*(sj6));
IkReal x2089=((IkReal(1.00000000000000))*(cj0));
IkReal x2090=((cj0)*(sj4)*(sj6));
IkReal x2091=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x2087)))+(((cj2)*(x2074)))+(((sj5)*(x2086)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj2)*(x2075)))+(((x2085)*(x2087)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((x2085)*(x2086)))+(((r20)*(x2083))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2084)*(x2088)))+(((IkReal(-1.00000000000000))*(sj2)*(x2074)))+(((x2076)*(x2079)))+(((IkReal(-1.00000000000000))*(x2082)*(x2084)))+(((x2076)*(x2077)))+(((r12)*(x2080)))+(((IkReal(-1.00000000000000))*(r02)*(x2081))));
evalcond[3]=((x2075)+(((IkReal(-1.00000000000000))*(x2076)*(x2082)))+(((r12)*(x2081)))+(((r02)*(x2080)))+(((IkReal(-1.00000000000000))*(x2077)*(x2084)))+(((IkReal(-1.00000000000000))*(x2076)*(x2088)))+(((IkReal(-1.00000000000000))*(x2079)*(x2084))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r10)*(x2083)*(x2089)))+(((IkReal(-1.00000000000000))*(x2078)*(x2080)*(x2082)))+(((r00)*(sj0)*(x2083)))+(((IkReal(-1.00000000000000))*(r12)*(x2078)*(x2084)))+(((cj4)*(r02)*(x2076)))+(((r11)*(x2090)))+(((sj2)*(x2075)))+(((IkReal(-1.00000000000000))*(x2078)*(x2080)*(x2088)))+(((cj4)*(x2077)*(x2081)))+(((cj4)*(x2079)*(x2081)))+(((IkReal(-1.00000000000000))*(r01)*(x2091))));
evalcond[5]=((x2074)+(((r01)*(x2090)))+(((IkReal(-1.00000000000000))*(x2078)*(x2079)*(x2080)))+(((IkReal(-1.00000000000000))*(x2078)*(x2081)*(x2082)))+(((IkReal(-1.00000000000000))*(x2077)*(x2078)*(x2080)))+(((IkReal(-1.00000000000000))*(r12)*(x2076)*(x2078)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2083)))+(((r11)*(x2091)))+(((IkReal(-1.00000000000000))*(r00)*(x2083)*(x2089)))+(((IkReal(-1.00000000000000))*(r02)*(x2078)*(x2084)))+(((IkReal(-1.00000000000000))*(x2078)*(x2081)*(x2088))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2092=((IkReal(1.00000000000000))*(r21));
IkReal x2093=((cj4)*(cj5));
IkReal x2094=((r20)*(sj6));
if( IKabs(((gconst56)*(((((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x2092)))+(((IkReal(-1.00000000000000))*(sj5)*(x2094)))+(((cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst56)*(((((x2093)*(x2094)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x2092)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x2093))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst56)*(((((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x2092)))+(((IkReal(-1.00000000000000))*(sj5)*(x2094)))+(((cj5)*(r22)))))), ((gconst56)*(((((x2093)*(x2094)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x2092)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x2093)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2095=IKsin(j3);
IkReal x2096=IKcos(j3);
IkReal x2097=((sj0)*(sj5));
IkReal x2098=((r00)*(sj6));
IkReal x2099=((IkReal(1.00000000000000))*(cj4));
IkReal x2100=((cj6)*(r01));
IkReal x2101=((cj0)*(cj5));
IkReal x2102=((cj5)*(sj0));
IkReal x2103=((cj6)*(r11));
IkReal x2104=((cj6)*(sj4));
IkReal x2105=((cj0)*(sj5));
IkReal x2106=((cj4)*(cj5));
IkReal x2107=((cj6)*(r21));
IkReal x2108=((r20)*(sj6));
IkReal x2109=((r10)*(sj6));
IkReal x2110=((IkReal(1.00000000000000))*(cj0));
IkReal x2111=((cj0)*(sj4)*(sj6));
IkReal x2112=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x2108)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((cj2)*(x2095)))+(((sj5)*(x2107))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj2)*(x2096)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x2106)*(x2108)))+(((cj4)*(r22)*(sj5)))+(((x2106)*(x2107)))+(((r20)*(x2104))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj2)*(x2095)))+(((IkReal(-1.00000000000000))*(x2103)*(x2105)))+(((IkReal(-1.00000000000000))*(x2105)*(x2109)))+(((x2097)*(x2098)))+(((r12)*(x2101)))+(((x2097)*(x2100)))+(((IkReal(-1.00000000000000))*(r02)*(x2102))));
evalcond[3]=((x2096)+(((IkReal(-1.00000000000000))*(x2098)*(x2105)))+(((IkReal(-1.00000000000000))*(x2100)*(x2105)))+(((r12)*(x2102)))+(((r02)*(x2101)))+(((IkReal(-1.00000000000000))*(x2097)*(x2103)))+(((IkReal(-1.00000000000000))*(x2097)*(x2109))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x2099)*(x2101)*(x2103)))+(((IkReal(-1.00000000000000))*(r10)*(x2104)*(x2110)))+(((sj2)*(x2096)))+(((cj4)*(r02)*(x2097)))+(((cj4)*(x2100)*(x2102)))+(((cj4)*(x2098)*(x2102)))+(((IkReal(-1.00000000000000))*(r12)*(x2099)*(x2105)))+(((IkReal(-1.00000000000000))*(x2099)*(x2101)*(x2109)))+(((IkReal(-1.00000000000000))*(r01)*(x2112)))+(((r11)*(x2111)))+(((r00)*(sj0)*(x2104))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2099)*(x2100)*(x2101)))+(((IkReal(-1.00000000000000))*(r00)*(x2104)*(x2110)))+(((r01)*(x2111)))+(((IkReal(-1.00000000000000))*(x2098)*(x2099)*(x2101)))+(x2095)+(((r11)*(x2112)))+(((IkReal(-1.00000000000000))*(r12)*(x2097)*(x2099)))+(((IkReal(-1.00000000000000))*(r02)*(x2099)*(x2105)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2104)))+(((IkReal(-1.00000000000000))*(x2099)*(x2102)*(x2109)))+(((IkReal(-1.00000000000000))*(x2099)*(x2102)*(x2103))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2113=((r11)*(sj0));
IkReal x2114=((cj0)*(r01));
IkReal x2115=((cj0)*(sj2));
IkReal x2116=((sj0)*(sj2));
IkReal x2117=((cj5)*(sj6));
IkReal x2118=((IkReal(1.00000000000000))*(sj2)*(sj6));
IkReal x2119=((cj5)*(cj6)*(sj2));
if( IKabs(((gconst53)*(((((cj6)*(r00)*(x2115)))+(((IkReal(-1.00000000000000))*(x2114)*(x2118)))+(((cj6)*(r10)*(x2116)))+(((IkReal(-1.00000000000000))*(x2113)*(x2118))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst53)*(((((x2114)*(x2119)))+(((r02)*(sj5)*(x2115)))+(((r00)*(x2115)*(x2117)))+(((r10)*(x2116)*(x2117)))+(((x2113)*(x2119)))+(((r12)*(sj5)*(x2116))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst53)*(((((cj6)*(r00)*(x2115)))+(((IkReal(-1.00000000000000))*(x2114)*(x2118)))+(((cj6)*(r10)*(x2116)))+(((IkReal(-1.00000000000000))*(x2113)*(x2118)))))), ((gconst53)*(((((x2114)*(x2119)))+(((r02)*(sj5)*(x2115)))+(((r00)*(x2115)*(x2117)))+(((r10)*(x2116)*(x2117)))+(((x2113)*(x2119)))+(((r12)*(sj5)*(x2116)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x2120=IKsin(j4);
IkReal x2121=IKcos(j4);
IkReal x2122=((r00)*(sj6));
IkReal x2123=((cj6)*(r01));
IkReal x2124=((IkReal(1.00000000000000))*(cj0));
IkReal x2125=((IkReal(1.00000000000000))*(sj0));
IkReal x2126=((r10)*(sj6));
IkReal x2127=((sj5)*(x2120));
IkReal x2128=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x2129=((cj5)*(x2120));
IkReal x2130=((cj6)*(x2121));
IkReal x2131=((sj0)*(x2129));
IkReal x2132=((r01)*(sj6)*(x2121));
IkReal x2133=((r11)*(sj6)*(x2121));
evalcond[0]=((sj2)+(((cj6)*(r21)*(x2129)))+(((IkReal(-1.00000000000000))*(r20)*(x2130)))+(((r21)*(sj6)*(x2121)))+(((r20)*(sj6)*(x2129)))+(((r22)*(x2127))));
evalcond[1]=((((sj0)*(x2132)))+(((x2123)*(x2131)))+(((IkReal(-1.00000000000000))*(r12)*(x2124)*(x2127)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2124)*(x2129)))+(((IkReal(-1.00000000000000))*(r00)*(x2125)*(x2130)))+(((IkReal(-1.00000000000000))*(x2124)*(x2126)*(x2129)))+(((cj0)*(r10)*(x2130)))+(cj2)+(((r02)*(sj0)*(x2127)))+(((IkReal(-1.00000000000000))*(x2124)*(x2133)))+(((x2122)*(x2131))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2125)*(x2133)))+(((IkReal(-1.00000000000000))*(x2125)*(x2126)*(x2129)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2125)*(x2129)))+(((IkReal(-1.00000000000000))*(x2123)*(x2124)*(x2129)))+(((IkReal(-1.00000000000000))*(x2124)*(x2132)))+(((IkReal(-1.00000000000000))*(r12)*(x2125)*(x2127)))+(((IkReal(-1.00000000000000))*(r02)*(x2124)*(x2127)))+(((IkReal(-1.00000000000000))*(x2122)*(x2124)*(x2129)))+(((r10)*(sj0)*(x2130)))+(((cj0)*(r00)*(x2130))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst56;
gconst56=IKsign(cj2);
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x2134=((cj5)*(sj4));
IkReal x2135=((IkReal(1.00000000000000))*(sj6));
IkReal x2136=((r10)*(sj0));
IkReal x2137=((sj4)*(sj5));
IkReal x2138=((cj5)*(cj6));
IkReal x2139=((r01)*(sj0));
IkReal x2140=((IkReal(1.00000000000000))*(r02));
IkReal x2141=((IkReal(0.374290000000000))*(cj0));
IkReal x2142=((cj5)*(r12));
IkReal x2143=((cj6)*(sj5));
IkReal x2144=((cj0)*(r11));
IkReal x2145=((cj5)*(sj0));
IkReal x2146=((r20)*(sj6));
IkReal x2147=((IkReal(1.00000000000000))*(sj0));
IkReal x2148=((cj4)*(cj5));
IkReal x2149=((IkReal(1.00000000000000))*(cj6));
IkReal x2150=((IkReal(0.0100000000000000))*(sj5));
IkReal x2151=((sj5)*(sj6));
IkReal x2152=((cj0)*(r10));
IkReal x2153=((cj4)*(cj6));
IkReal x2154=((cj0)*(r01));
IkReal x2155=((IkReal(1.00000000000000))*(cj4));
IkReal x2156=((cj0)*(r00));
IkReal x2157=((IkReal(0.374290000000000))*(sj0));
IkReal x2158=((cj0)*(r12));
IkReal x2159=((IkReal(0.374290000000000))*(sj5));
IkReal x2160=((cj4)*(sj6));
IkReal x2161=((IkReal(1.00000000000000))*(cj0));
IkReal x2162=((r02)*(sj0));
IkReal x2163=((IkReal(0.0100000000000000))*(cj5));
IkReal x2164=((r11)*(sj0));
IkReal x2165=((r00)*(sj0)*(sj6));
IkReal x2166=((r00)*(x2153));
IkReal x2167=((sj6)*(x2163));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x2137)))+(((x2134)*(x2146)))+(((cj6)*(r21)*(x2134)))+(((r21)*(x2160)))+(((IkReal(-1.00000000000000))*(cj4)*(r20)*(x2149))));
evalcond[2]=((IkReal(-0.0690000000000000))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(0.374290000000000))*(r21)*(x2143)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x2150)))+(((x2146)*(x2159)))+(((IkReal(-1.00000000000000))*(x2146)*(x2163)))+(((IkReal(-0.0100000000000000))*(r21)*(x2138))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x2143)*(x2144)))+(((r00)*(sj0)*(x2151)))+(((IkReal(-1.00000000000000))*(x2140)*(x2145)))+(((x2139)*(x2143)))+(((cj0)*(x2142)))+(((IkReal(-1.00000000000000))*(sj5)*(x2135)*(x2152))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x2147)*(x2166)))+(((IkReal(-1.00000000000000))*(cj4)*(x2135)*(x2144)))+(((IkReal(-1.00000000000000))*(x2134)*(x2144)*(x2149)))+(((IkReal(-1.00000000000000))*(x2137)*(x2158)))+(((x2139)*(x2160)))+(((cj6)*(x2134)*(x2139)))+(((x2134)*(x2165)))+(((x2152)*(x2153)))+(((x2137)*(x2162)))+(((IkReal(-1.00000000000000))*(x2134)*(x2135)*(x2152))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj4)*(x2135)*(x2139)))+(((sj4)*(sj6)*(x2144)))+(((cj4)*(sj5)*(x2162)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((IkReal(-1.00000000000000))*(x2135)*(x2148)*(x2152)))+(((IkReal(-1.00000000000000))*(sj4)*(x2149)*(x2152)))+(((IkReal(-1.00000000000000))*(x2138)*(x2144)*(x2155)))+(((cj4)*(x2138)*(x2139)))+(((r00)*(x2145)*(x2160)))+(((IkReal(-1.00000000000000))*(sj5)*(x2155)*(x2158))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x2134)*(x2135)*(x2136)))+(((IkReal(-1.00000000000000))*(r12)*(x2137)*(x2147)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2134)*(x2147)))+(((x2136)*(x2153)))+(((x2153)*(x2156)))+(((IkReal(-1.00000000000000))*(cj4)*(x2135)*(x2154)))+(((IkReal(-1.00000000000000))*(x2134)*(x2135)*(x2156)))+(((IkReal(-1.00000000000000))*(cj0)*(x2137)*(x2140)))+(((IkReal(-1.00000000000000))*(x2134)*(x2149)*(x2154)))+(((IkReal(-1.00000000000000))*(cj4)*(x2135)*(x2164))));
evalcond[7]=((((IkReal(-1.00000000000000))*(r11)*(x2141)*(x2143)))+(((IkReal(-0.374290000000000))*(r02)*(x2145)))+(((IkReal(0.374290000000000))*(x2139)*(x2143)))+(((x2152)*(x2167)))+(((IkReal(0.0100000000000000))*(x2138)*(x2144)))+(((x2150)*(x2158)))+(((IkReal(-1.00000000000000))*(py)*(x2161)))+(((IkReal(-1.00000000000000))*(r10)*(x2141)*(x2151)))+(((IkReal(-0.0100000000000000))*(x2138)*(x2139)))+(((x2141)*(x2142)))+(((px)*(sj0)))+(((r00)*(x2151)*(x2157)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x2145)))+(((IkReal(-1.00000000000000))*(x2150)*(x2162))));
evalcond[8]=((IkReal(-0.295420000000000))+(((x2136)*(x2167)))+(((cj5)*(r02)*(x2141)))+(((IkReal(-1.00000000000000))*(py)*(x2147)))+(((IkReal(0.0100000000000000))*(x2138)*(x2164)))+(((r12)*(sj0)*(x2150)))+(((IkReal(0.0100000000000000))*(x2138)*(x2154)))+(((IkReal(-1.00000000000000))*(r01)*(x2141)*(x2143)))+(((x2142)*(x2157)))+(((IkReal(-1.00000000000000))*(r00)*(x2141)*(x2151)))+(((IkReal(-1.00000000000000))*(r11)*(x2143)*(x2157)))+(((IkReal(-0.374290000000000))*(x2136)*(x2151)))+(((cj0)*(r02)*(x2150)))+(((x2156)*(x2167)))+(((IkReal(-1.00000000000000))*(px)*(x2161))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2168=((IkReal(1.00000000000000))*(r21));
IkReal x2169=((cj4)*(cj5));
IkReal x2170=((r20)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x2170)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x2168))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj6)*(r20)*(sj4)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x2168)))+(((cj4)*(r22)*(sj5)))+(((x2169)*(x2170)))+(((cj6)*(r21)*(x2169))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x2170)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x2168)))))+IKsqr(((((cj6)*(r20)*(sj4)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x2168)))+(((cj4)*(r22)*(sj5)))+(((x2169)*(x2170)))+(((cj6)*(r21)*(x2169)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x2170)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x2168)))), ((((cj6)*(r20)*(sj4)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x2168)))+(((cj4)*(r22)*(sj5)))+(((x2169)*(x2170)))+(((cj6)*(r21)*(x2169)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2171=IKcos(j3);
IkReal x2172=IKsin(j3);
IkReal x2173=((IkReal(1.00000000000000))*(cj4));
IkReal x2174=((sj0)*(sj5));
IkReal x2175=((cj0)*(cj5));
IkReal x2176=((cj6)*(r01));
IkReal x2177=((r00)*(sj6));
IkReal x2178=((cj6)*(r11));
IkReal x2179=((cj5)*(sj0));
IkReal x2180=((cj6)*(sj4));
IkReal x2181=((sj4)*(sj6));
IkReal x2182=((cj4)*(cj5));
IkReal x2183=((cj6)*(r21));
IkReal x2184=((r20)*(sj6));
IkReal x2185=((r10)*(sj6));
IkReal x2186=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((x2172)+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x2184)))+(((sj5)*(x2183))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(x2181)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x2171)))+(((x2182)*(x2183)))+(((x2182)*(x2184)))+(((r20)*(x2180))));
evalcond[2]=((x2171)+(((IkReal(-1.00000000000000))*(x2176)*(x2186)))+(((r02)*(x2175)))+(((IkReal(-1.00000000000000))*(x2174)*(x2185)))+(((IkReal(-1.00000000000000))*(x2174)*(x2178)))+(((r12)*(x2179)))+(((IkReal(-1.00000000000000))*(x2177)*(x2186))));
evalcond[3]=((((cj0)*(r01)*(x2181)))+(x2172)+(((r11)*(sj0)*(x2181)))+(((IkReal(-1.00000000000000))*(x2173)*(x2179)*(x2185)))+(((IkReal(-1.00000000000000))*(x2173)*(x2175)*(x2177)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x2180)))+(((IkReal(-1.00000000000000))*(x2173)*(x2178)*(x2179)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x2173)))+(((IkReal(-1.00000000000000))*(r12)*(x2173)*(x2174)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2180)))+(((IkReal(-1.00000000000000))*(x2173)*(x2175)*(x2176))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2187=((cj5)*(sj4));
IkReal x2188=((IkReal(1.00000000000000))*(sj6));
IkReal x2189=((r10)*(sj0));
IkReal x2190=((sj4)*(sj5));
IkReal x2191=((cj5)*(cj6));
IkReal x2192=((r01)*(sj0));
IkReal x2193=((IkReal(1.00000000000000))*(r02));
IkReal x2194=((IkReal(0.374290000000000))*(cj0));
IkReal x2195=((cj5)*(r12));
IkReal x2196=((cj6)*(sj5));
IkReal x2197=((cj0)*(r11));
IkReal x2198=((cj5)*(sj0));
IkReal x2199=((r20)*(sj6));
IkReal x2200=((IkReal(1.00000000000000))*(sj0));
IkReal x2201=((cj4)*(cj5));
IkReal x2202=((IkReal(1.00000000000000))*(cj6));
IkReal x2203=((IkReal(0.0100000000000000))*(sj5));
IkReal x2204=((sj5)*(sj6));
IkReal x2205=((cj0)*(r10));
IkReal x2206=((cj4)*(cj6));
IkReal x2207=((cj0)*(r01));
IkReal x2208=((IkReal(1.00000000000000))*(cj4));
IkReal x2209=((cj0)*(r00));
IkReal x2210=((IkReal(0.374290000000000))*(sj0));
IkReal x2211=((cj0)*(r12));
IkReal x2212=((IkReal(0.374290000000000))*(sj5));
IkReal x2213=((cj4)*(sj6));
IkReal x2214=((IkReal(1.00000000000000))*(cj0));
IkReal x2215=((r02)*(sj0));
IkReal x2216=((IkReal(0.0100000000000000))*(cj5));
IkReal x2217=((r11)*(sj0));
IkReal x2218=((r00)*(sj0)*(sj6));
IkReal x2219=((r00)*(x2206));
IkReal x2220=((sj6)*(x2216));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j2, IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x2190)))+(((r21)*(x2213)))+(((IkReal(-1.00000000000000))*(cj4)*(r20)*(x2202)))+(((x2187)*(x2199)))+(((cj6)*(r21)*(x2187))));
evalcond[2]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r22)*(x2203)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-0.0100000000000000))*(r21)*(x2191)))+(((IkReal(0.374290000000000))*(r21)*(x2196)))+(((IkReal(-1.00000000000000))*(x2199)*(x2216)))+(((x2199)*(x2212)))+(pz));
evalcond[3]=((((cj0)*(x2195)))+(((IkReal(-1.00000000000000))*(x2196)*(x2197)))+(((r00)*(sj0)*(x2204)))+(((x2192)*(x2196)))+(((IkReal(-1.00000000000000))*(x2193)*(x2198)))+(((IkReal(-1.00000000000000))*(sj5)*(x2188)*(x2205))));
evalcond[4]=((IkReal(-1.00000000000000))+(((x2192)*(x2213)))+(((IkReal(-1.00000000000000))*(x2187)*(x2197)*(x2202)))+(((IkReal(-1.00000000000000))*(x2190)*(x2211)))+(((IkReal(-1.00000000000000))*(x2200)*(x2219)))+(((x2187)*(x2218)))+(((IkReal(-1.00000000000000))*(cj4)*(x2188)*(x2197)))+(((x2190)*(x2215)))+(((IkReal(-1.00000000000000))*(x2187)*(x2188)*(x2205)))+(((cj6)*(x2187)*(x2192)))+(((x2205)*(x2206))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj4)*(x2202)*(x2205)))+(((IkReal(-1.00000000000000))*(x2191)*(x2197)*(x2208)))+(((sj4)*(sj6)*(x2197)))+(((cj6)*(r00)*(sj0)*(sj4)))+(((IkReal(-1.00000000000000))*(sj4)*(x2188)*(x2192)))+(((cj4)*(x2191)*(x2192)))+(((cj4)*(sj5)*(x2215)))+(((r00)*(x2198)*(x2213)))+(((IkReal(-1.00000000000000))*(x2188)*(x2201)*(x2205)))+(((IkReal(-1.00000000000000))*(sj5)*(x2208)*(x2211))));
evalcond[6]=((((x2189)*(x2206)))+(((IkReal(-1.00000000000000))*(cj4)*(x2188)*(x2217)))+(((IkReal(-1.00000000000000))*(cj0)*(x2190)*(x2193)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2187)*(x2200)))+(((x2206)*(x2209)))+(((IkReal(-1.00000000000000))*(cj4)*(x2188)*(x2207)))+(((IkReal(-1.00000000000000))*(x2187)*(x2202)*(x2207)))+(((IkReal(-1.00000000000000))*(x2187)*(x2188)*(x2209)))+(((IkReal(-1.00000000000000))*(r12)*(x2190)*(x2200)))+(((IkReal(-1.00000000000000))*(x2187)*(x2188)*(x2189))));
evalcond[7]=((((x2205)*(x2220)))+(((IkReal(-0.374290000000000))*(r02)*(x2198)))+(((IkReal(-0.0100000000000000))*(r00)*(sj6)*(x2198)))+(((IkReal(-1.00000000000000))*(r11)*(x2194)*(x2196)))+(((x2203)*(x2211)))+(((IkReal(0.0100000000000000))*(x2191)*(x2197)))+(((IkReal(-1.00000000000000))*(r10)*(x2194)*(x2204)))+(((IkReal(-1.00000000000000))*(py)*(x2214)))+(((IkReal(-0.0100000000000000))*(x2191)*(x2192)))+(((IkReal(0.374290000000000))*(x2192)*(x2196)))+(((r00)*(x2204)*(x2210)))+(((IkReal(-1.00000000000000))*(x2203)*(x2215)))+(((px)*(sj0)))+(((x2194)*(x2195))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(-1.00000000000000))*(r00)*(x2194)*(x2204)))+(((cj5)*(r02)*(x2194)))+(((cj0)*(r02)*(x2203)))+(((r12)*(sj0)*(x2203)))+(((IkReal(-0.374290000000000))*(x2189)*(x2204)))+(((x2195)*(x2210)))+(((x2209)*(x2220)))+(((IkReal(-1.00000000000000))*(r01)*(x2194)*(x2196)))+(((IkReal(0.0100000000000000))*(x2191)*(x2217)))+(((IkReal(-1.00000000000000))*(r11)*(x2196)*(x2210)))+(((IkReal(0.0100000000000000))*(x2191)*(x2207)))+(((IkReal(-1.00000000000000))*(py)*(x2200)))+(((x2189)*(x2220)))+(((IkReal(-1.00000000000000))*(px)*(x2214))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2221=((IkReal(1.00000000000000))*(cj4));
IkReal x2222=((cj6)*(r21));
IkReal x2223=((r20)*(sj6));
if( IKabs(((((sj5)*(x2223)))+(((sj5)*(x2222)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj5)*(x2221)*(x2223)))+(((IkReal(-1.00000000000000))*(cj5)*(x2221)*(x2222)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2221)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x2223)))+(((sj5)*(x2222)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(x2221)*(x2223)))+(((IkReal(-1.00000000000000))*(cj5)*(x2221)*(x2222)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2221)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x2223)))+(((sj5)*(x2222)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((IkReal(-1.00000000000000))*(cj5)*(x2221)*(x2223)))+(((IkReal(-1.00000000000000))*(cj5)*(x2221)*(x2222)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2221)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2224=IKcos(j3);
IkReal x2225=IKsin(j3);
IkReal x2226=((IkReal(1.00000000000000))*(cj4));
IkReal x2227=((sj0)*(sj5));
IkReal x2228=((cj0)*(cj5));
IkReal x2229=((cj6)*(r01));
IkReal x2230=((r00)*(sj6));
IkReal x2231=((cj6)*(r11));
IkReal x2232=((cj5)*(sj0));
IkReal x2233=((cj6)*(sj4));
IkReal x2234=((sj4)*(sj6));
IkReal x2235=((cj4)*(cj5));
IkReal x2236=((cj6)*(r21));
IkReal x2237=((r20)*(sj6));
IkReal x2238=((r10)*(sj6));
IkReal x2239=((IkReal(1.00000000000000))*(cj0)*(sj5));
evalcond[0]=((((sj5)*(x2236)))+(((sj5)*(x2237)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2225))));
evalcond[1]=((x2224)+(((r20)*(x2233)))+(((IkReal(-1.00000000000000))*(r21)*(x2234)))+(((x2235)*(x2237)))+(((cj4)*(r22)*(sj5)))+(((x2235)*(x2236))));
evalcond[2]=((x2224)+(((IkReal(-1.00000000000000))*(x2230)*(x2239)))+(((IkReal(-1.00000000000000))*(x2227)*(x2238)))+(((IkReal(-1.00000000000000))*(x2227)*(x2231)))+(((IkReal(-1.00000000000000))*(x2229)*(x2239)))+(((r12)*(x2232)))+(((r02)*(x2228))));
evalcond[3]=((x2225)+(((IkReal(-1.00000000000000))*(x2226)*(x2228)*(x2229)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x2226)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2233)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x2233)))+(((IkReal(-1.00000000000000))*(x2226)*(x2228)*(x2230)))+(((IkReal(-1.00000000000000))*(x2226)*(x2232)*(x2238)))+(((IkReal(-1.00000000000000))*(r12)*(x2226)*(x2227)))+(((IkReal(-1.00000000000000))*(x2226)*(x2231)*(x2232)))+(((cj0)*(r01)*(x2234)))+(((r11)*(sj0)*(x2234))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2240=((IkReal(1.00000000000000))*(cj0));
IkReal x2241=((cj4)*(sj6));
IkReal x2242=((sj0)*(sj4));
IkReal x2243=((cj5)*(sj6));
IkReal x2244=((sj4)*(sj5));
IkReal x2245=((r12)*(sj5));
IkReal x2246=((IkReal(0.374290000000000))*(cj5));
IkReal x2247=((r02)*(sj0));
IkReal x2248=((r20)*(sj4));
IkReal x2249=((IkReal(1.00000000000000))*(sj0));
IkReal x2250=((IkReal(1.00000000000000))*(cj5));
IkReal x2251=((cj0)*(r10));
IkReal x2252=((cj4)*(cj6));
IkReal x2253=((r00)*(sj0));
IkReal x2254=((cj6)*(r21));
IkReal x2255=((IkReal(0.374290000000000))*(sj5));
IkReal x2256=((cj0)*(r00));
IkReal x2257=((IkReal(0.0100000000000000))*(sj5));
IkReal x2258=((cj0)*(r02));
IkReal x2259=((cj5)*(sj4));
IkReal x2260=((cj6)*(r01));
IkReal x2261=((cj6)*(r11));
IkReal x2262=((r01)*(sj0));
IkReal x2263=((r10)*(sj0));
IkReal x2264=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x2265=((sj6)*(x2255));
IkReal x2266=((cj0)*(cj6)*(x2255));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x2254)))+(((IkReal(-1.00000000000000))*(r22)*(x2250)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(1.00000000000000))+(((x2254)*(x2259)))+(((IkReal(-1.00000000000000))*(r20)*(x2252)))+(((x2243)*(x2248)))+(((r21)*(x2241)))+(((r22)*(x2244))));
evalcond[3]=((((IkReal(-0.0100000000000000))*(cj5)*(x2254)))+(((IkReal(-0.0100000000000000))*(r20)*(x2243)))+(((IkReal(-1.00000000000000))*(r22)*(x2246)))+(((r20)*(x2265)))+(((x2254)*(x2255)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x2257))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(x2248)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r20)*(x2241)))+(((cj5)*(r21)*(x2252))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r11)*(x2240)*(x2241)))+(((x2241)*(x2262)))+(((r02)*(sj5)*(x2242)))+(((IkReal(-1.00000000000000))*(r12)*(x2240)*(x2244)))+(((IkReal(-1.00000000000000))*(r00)*(x2249)*(x2252)))+(((x2251)*(x2252)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x2240)*(x2243)))+(((IkReal(-1.00000000000000))*(x2240)*(x2259)*(x2261)))+(((r00)*(x2242)*(x2243)))+(((cj5)*(x2242)*(x2260))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r01)*(x2240)*(x2241)))+(((IkReal(-1.00000000000000))*(r11)*(x2241)*(x2249)))+(((x2252)*(x2256)))+(((IkReal(-1.00000000000000))*(x2240)*(x2259)*(x2260)))+(((IkReal(-1.00000000000000))*(r10)*(x2242)*(x2243)))+(((IkReal(-1.00000000000000))*(x2242)*(x2245)))+(((x2252)*(x2263)))+(((IkReal(-1.00000000000000))*(r02)*(x2240)*(x2244)))+(((IkReal(-1.00000000000000))*(x2242)*(x2250)*(x2261)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x2240)*(x2243))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(x2255)*(x2261)))+(((IkReal(-1.00000000000000))*(x2246)*(x2247)))+(((IkReal(0.0100000000000000))*(x2243)*(x2251)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x2260)))+(((IkReal(-1.00000000000000))*(x2251)*(x2265)))+(((cj0)*(r12)*(x2246)))+(((IkReal(-1.00000000000000))*(x2247)*(x2257)))+(((IkReal(-0.0100000000000000))*(x2243)*(x2253)))+(((IkReal(0.0100000000000000))*(cj0)*(x2245)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x2261)))+(((sj0)*(x2255)*(x2260)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(py)*(x2240)))+(((x2253)*(x2265))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x2260)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x2261)))+(((IkReal(0.0100000000000000))*(sj0)*(x2245)))+(((IkReal(-1.00000000000000))*(x2256)*(x2265)))+(((IkReal(-1.00000000000000))*(px)*(x2240)))+(((IkReal(-1.00000000000000))*(x2263)*(x2265)))+(((IkReal(-1.00000000000000))*(py)*(x2249)))+(((IkReal(0.0100000000000000))*(x2243)*(x2256)))+(((x2246)*(x2258)))+(((IkReal(-1.00000000000000))*(cj0)*(x2255)*(x2260)))+(((x2257)*(x2258)))+(((IkReal(-1.00000000000000))*(sj0)*(x2255)*(x2261)))+(((IkReal(0.0100000000000000))*(x2243)*(x2263)))+(((r12)*(sj0)*(x2246))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2267=((sj0)*(sj5));
IkReal x2268=((r00)*(sj6));
IkReal x2269=((IkReal(1.00000000000000))*(cj5));
IkReal x2270=((cj6)*(r11));
IkReal x2271=((cj6)*(r01));
IkReal x2272=((r10)*(sj6));
IkReal x2273=((cj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2269)))+(((x2267)*(x2268)))+(((x2267)*(x2271)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2272)*(x2273)))+(((IkReal(-1.00000000000000))*(x2270)*(x2273))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x2271)*(x2273)))+(((x2267)*(x2270)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2269)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2269)))+(((x2268)*(x2273)))+(((x2267)*(x2272))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2269)))+(((x2267)*(x2268)))+(((x2267)*(x2271)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2272)*(x2273)))+(((IkReal(-1.00000000000000))*(x2270)*(x2273)))))+IKsqr(((((x2271)*(x2273)))+(((x2267)*(x2270)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2269)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2269)))+(((x2268)*(x2273)))+(((x2267)*(x2272)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2269)))+(((x2267)*(x2268)))+(((x2267)*(x2271)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2272)*(x2273)))+(((IkReal(-1.00000000000000))*(x2270)*(x2273)))), ((((x2271)*(x2273)))+(((x2267)*(x2270)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2269)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2269)))+(((x2268)*(x2273)))+(((x2267)*(x2272)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2274=IKcos(j3);
IkReal x2275=IKsin(j3);
IkReal x2276=((sj0)*(sj5));
IkReal x2277=((r00)*(sj6));
IkReal x2278=((cj6)*(sj0));
IkReal x2279=((IkReal(1.00000000000000))*(cj4));
IkReal x2280=((r00)*(sj4));
IkReal x2281=((cj0)*(cj5));
IkReal x2282=((cj5)*(sj0));
IkReal x2283=((cj6)*(r11));
IkReal x2284=((r10)*(sj6));
IkReal x2285=((cj0)*(sj5));
IkReal x2286=((r10)*(sj4));
IkReal x2287=((cj4)*(cj5)*(r01));
IkReal x2288=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x2289=((cj0)*(sj4)*(sj6));
IkReal x2290=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(r02)*(x2282)))+(((cj6)*(r01)*(x2276)))+(((IkReal(-1.00000000000000))*(x2283)*(x2285)))+(((IkReal(-1.00000000000000))*(x2275)))+(((r12)*(x2281)))+(((x2276)*(x2277)))+(((IkReal(-1.00000000000000))*(x2284)*(x2285))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2277)*(x2285)))+(((IkReal(-1.00000000000000))*(x2276)*(x2283)))+(((r12)*(x2282)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2285)))+(x2274)+(((r02)*(x2281)))+(((IkReal(-1.00000000000000))*(x2276)*(x2284))));
evalcond[2]=((((cj4)*(x2277)*(x2282)))+(((x2278)*(x2280)))+(((cj4)*(r02)*(x2276)))+(((IkReal(-1.00000000000000))*(x2279)*(x2281)*(x2284)))+(((r11)*(x2289)))+(((IkReal(-1.00000000000000))*(x2286)*(x2288)))+(x2274)+(((IkReal(-1.00000000000000))*(r01)*(x2290)))+(((IkReal(-1.00000000000000))*(x2279)*(x2281)*(x2283)))+(((IkReal(-1.00000000000000))*(r12)*(x2279)*(x2285)))+(((x2278)*(x2287))));
evalcond[3]=((((r01)*(x2289)))+(((r11)*(x2290)))+(((IkReal(-1.00000000000000))*(x2279)*(x2282)*(x2284)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2279)*(x2281)))+(((IkReal(-1.00000000000000))*(r02)*(x2279)*(x2285)))+(((IkReal(-1.00000000000000))*(x2280)*(x2288)))+(((IkReal(-1.00000000000000))*(x2278)*(x2286)))+(x2275)+(((IkReal(-1.00000000000000))*(r12)*(x2276)*(x2279)))+(((IkReal(-1.00000000000000))*(x2277)*(x2279)*(x2281)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x2278)*(x2279))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2291=((IkReal(1.00000000000000))*(cj0));
IkReal x2292=((cj4)*(sj6));
IkReal x2293=((sj0)*(sj4));
IkReal x2294=((cj5)*(sj6));
IkReal x2295=((sj4)*(sj5));
IkReal x2296=((r12)*(sj5));
IkReal x2297=((IkReal(0.374290000000000))*(cj5));
IkReal x2298=((r02)*(sj0));
IkReal x2299=((r20)*(sj4));
IkReal x2300=((IkReal(1.00000000000000))*(sj0));
IkReal x2301=((IkReal(1.00000000000000))*(cj5));
IkReal x2302=((cj0)*(r10));
IkReal x2303=((cj4)*(cj6));
IkReal x2304=((r00)*(sj0));
IkReal x2305=((cj6)*(r21));
IkReal x2306=((IkReal(0.374290000000000))*(sj5));
IkReal x2307=((cj0)*(r00));
IkReal x2308=((IkReal(0.0100000000000000))*(sj5));
IkReal x2309=((cj0)*(r02));
IkReal x2310=((cj5)*(sj4));
IkReal x2311=((cj6)*(r01));
IkReal x2312=((cj6)*(r11));
IkReal x2313=((r01)*(sj0));
IkReal x2314=((r10)*(sj0));
IkReal x2315=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x2316=((sj6)*(x2306));
IkReal x2317=((cj0)*(cj6)*(x2306));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x2305)))+(((r20)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(x2301))));
evalcond[2]=((IkReal(-1.00000000000000))+(((r22)*(x2295)))+(((x2294)*(x2299)))+(((r21)*(x2292)))+(((x2305)*(x2310)))+(((IkReal(-1.00000000000000))*(r20)*(x2303))));
evalcond[3]=((((x2305)*(x2306)))+(((IkReal(-1.00000000000000))*(r22)*(x2308)))+(((IkReal(-1.00000000000000))*(r22)*(x2297)))+(((r20)*(x2316)))+(((IkReal(-0.0100000000000000))*(cj5)*(x2305)))+(((IkReal(-0.0100000000000000))*(r20)*(x2294)))+(pz));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj5)*(r20)*(x2292)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(x2299)))+(((cj5)*(r21)*(x2303))));
evalcond[5]=((((r02)*(sj5)*(x2293)))+(((x2302)*(x2303)))+(((r00)*(x2293)*(x2294)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x2291)*(x2294)))+(((IkReal(-1.00000000000000))*(r00)*(x2300)*(x2303)))+(((IkReal(-1.00000000000000))*(r12)*(x2291)*(x2295)))+(((IkReal(-1.00000000000000))*(x2291)*(x2310)*(x2312)))+(((cj5)*(x2293)*(x2311)))+(((IkReal(-1.00000000000000))*(r11)*(x2291)*(x2292)))+(((x2292)*(x2313))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r02)*(x2291)*(x2295)))+(((IkReal(-1.00000000000000))*(r11)*(x2292)*(x2300)))+(((IkReal(-1.00000000000000))*(x2291)*(x2310)*(x2311)))+(((x2303)*(x2314)))+(((IkReal(-1.00000000000000))*(x2293)*(x2296)))+(((IkReal(-1.00000000000000))*(x2293)*(x2301)*(x2312)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x2291)*(x2294)))+(((IkReal(-1.00000000000000))*(r10)*(x2293)*(x2294)))+(((x2303)*(x2307)))+(((IkReal(-1.00000000000000))*(r01)*(x2291)*(x2292))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((x2304)*(x2316)))+(((IkReal(-1.00000000000000))*(x2302)*(x2316)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x2311)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x2312)))+(((IkReal(0.0100000000000000))*(cj0)*(x2296)))+(((sj0)*(x2306)*(x2311)))+(((cj0)*(r12)*(x2297)))+(((IkReal(-1.00000000000000))*(cj0)*(x2306)*(x2312)))+(((IkReal(0.0100000000000000))*(x2294)*(x2302)))+(((IkReal(-0.0100000000000000))*(x2294)*(x2304)))+(((IkReal(-1.00000000000000))*(py)*(x2291)))+(((IkReal(-1.00000000000000))*(x2298)*(x2308)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x2297)*(x2298))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(0.0100000000000000))*(x2294)*(x2314)))+(((IkReal(-1.00000000000000))*(x2314)*(x2316)))+(((IkReal(0.0100000000000000))*(sj0)*(x2296)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x2312)))+(((r12)*(sj0)*(x2297)))+(((IkReal(-1.00000000000000))*(cj0)*(x2306)*(x2311)))+(((IkReal(-1.00000000000000))*(px)*(x2291)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x2311)))+(((IkReal(-1.00000000000000))*(x2307)*(x2316)))+(((IkReal(-1.00000000000000))*(py)*(x2300)))+(((x2297)*(x2309)))+(((IkReal(-1.00000000000000))*(sj0)*(x2306)*(x2312)))+(((x2308)*(x2309)))+(((IkReal(0.0100000000000000))*(x2294)*(x2307))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2318=((IkReal(1.00000000000000))*(cj5));
IkReal x2319=((r10)*(sj5)*(sj6));
IkReal x2320=((cj6)*(sj0)*(sj5));
IkReal x2321=((r00)*(sj5)*(sj6));
IkReal x2322=((cj0)*(cj6)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2318)))+(((cj5)*(r02)*(sj0)))+(((cj0)*(x2319)))+(((IkReal(-1.00000000000000))*(r01)*(x2320)))+(((IkReal(-1.00000000000000))*(sj0)*(x2321)))+(((r11)*(x2322))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2318)))+(((cj0)*(x2321)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2318)))+(((sj0)*(x2319)))+(((r11)*(x2320)))+(((r01)*(x2322))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2318)))+(((cj5)*(r02)*(sj0)))+(((cj0)*(x2319)))+(((IkReal(-1.00000000000000))*(r01)*(x2320)))+(((IkReal(-1.00000000000000))*(sj0)*(x2321)))+(((r11)*(x2322)))))+IKsqr(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2318)))+(((cj0)*(x2321)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2318)))+(((sj0)*(x2319)))+(((r11)*(x2320)))+(((r01)*(x2322)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2318)))+(((cj5)*(r02)*(sj0)))+(((cj0)*(x2319)))+(((IkReal(-1.00000000000000))*(r01)*(x2320)))+(((IkReal(-1.00000000000000))*(sj0)*(x2321)))+(((r11)*(x2322)))), ((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2318)))+(((cj0)*(x2321)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2318)))+(((sj0)*(x2319)))+(((r11)*(x2320)))+(((r01)*(x2322)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2323=IKcos(j3);
IkReal x2324=IKsin(j3);
IkReal x2325=((sj0)*(sj5));
IkReal x2326=((r00)*(sj6));
IkReal x2327=((IkReal(1.00000000000000))*(cj4));
IkReal x2328=((cj6)*(sj0));
IkReal x2329=((r00)*(sj4));
IkReal x2330=((cj0)*(cj5));
IkReal x2331=((cj6)*(r01));
IkReal x2332=((cj5)*(sj0));
IkReal x2333=((cj0)*(sj5));
IkReal x2334=((cj6)*(r11));
IkReal x2335=((r10)*(sj6));
IkReal x2336=((r10)*(sj4));
IkReal x2337=((cj0)*(sj4)*(sj6));
IkReal x2338=((sj0)*(sj4)*(sj6));
IkReal x2339=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((((r12)*(x2330)))+(x2324)+(((IkReal(-1.00000000000000))*(r02)*(x2332)))+(((IkReal(-1.00000000000000))*(x2333)*(x2334)))+(((x2325)*(x2326)))+(((x2325)*(x2331)))+(((IkReal(-1.00000000000000))*(x2333)*(x2335))));
evalcond[1]=((x2323)+(((IkReal(-1.00000000000000))*(x2325)*(x2335)))+(((IkReal(-1.00000000000000))*(x2331)*(x2333)))+(((IkReal(-1.00000000000000))*(x2325)*(x2334)))+(((r02)*(x2330)))+(((r12)*(x2332)))+(((IkReal(-1.00000000000000))*(x2326)*(x2333))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2336)*(x2339)))+(((IkReal(-1.00000000000000))*(r12)*(x2327)*(x2333)))+(((x2328)*(x2329)))+(((IkReal(-1.00000000000000))*(x2327)*(x2330)*(x2334)))+(((IkReal(-1.00000000000000))*(x2323)))+(((IkReal(-1.00000000000000))*(r01)*(x2338)))+(((IkReal(-1.00000000000000))*(x2327)*(x2330)*(x2335)))+(((cj4)*(x2326)*(x2332)))+(((r11)*(x2337)))+(((cj4)*(cj5)*(r01)*(x2328)))+(((cj4)*(r02)*(x2325))));
evalcond[3]=((x2324)+(((IkReal(-1.00000000000000))*(r02)*(x2327)*(x2333)))+(((IkReal(-1.00000000000000))*(x2326)*(x2327)*(x2330)))+(((IkReal(-1.00000000000000))*(x2327)*(x2330)*(x2331)))+(((IkReal(-1.00000000000000))*(x2329)*(x2339)))+(((IkReal(-1.00000000000000))*(x2328)*(x2336)))+(((IkReal(-1.00000000000000))*(x2327)*(x2332)*(x2335)))+(((IkReal(-1.00000000000000))*(r12)*(x2325)*(x2327)))+(((r11)*(x2338)))+(((r01)*(x2337)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x2327)*(x2328))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2340=((sj0)*(sj5));
IkReal x2341=((r00)*(sj6));
IkReal x2342=((IkReal(1.00000000000000))*(cj5));
IkReal x2343=((cj6)*(r11));
IkReal x2344=((cj6)*(r01));
IkReal x2345=((cj0)*(sj5));
IkReal x2346=((r10)*(sj6));
if( IKabs(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((x2340)*(x2341)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2342)))+(((IkReal(-1.00000000000000))*(x2343)*(x2345)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2345)*(x2346)))+(((x2340)*(x2344))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2342)))+(((x2341)*(x2345)))+(((x2340)*(x2343)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2342)))+(((x2340)*(x2346)))+(((x2344)*(x2345))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((x2340)*(x2341)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2342)))+(((IkReal(-1.00000000000000))*(x2343)*(x2345)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2345)*(x2346)))+(((x2340)*(x2344)))))))+IKsqr(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2342)))+(((x2341)*(x2345)))+(((x2340)*(x2343)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2342)))+(((x2340)*(x2346)))+(((x2344)*(x2345)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((x2340)*(x2341)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2342)))+(((IkReal(-1.00000000000000))*(x2343)*(x2345)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2345)*(x2346)))+(((x2340)*(x2344)))))), ((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2342)))+(((x2341)*(x2345)))+(((x2340)*(x2343)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2342)))+(((x2340)*(x2346)))+(((x2344)*(x2345)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2347=IKsin(j3);
IkReal x2348=IKcos(j3);
IkReal x2349=((sj0)*(sj5));
IkReal x2350=((r00)*(sj6));
IkReal x2351=((IkReal(1.00000000000000))*(cj4));
IkReal x2352=((cj6)*(r01));
IkReal x2353=((cj0)*(cj5));
IkReal x2354=((cj5)*(sj0));
IkReal x2355=((cj6)*(r11));
IkReal x2356=((cj6)*(sj4));
IkReal x2357=((cj0)*(sj5));
IkReal x2358=((cj4)*(cj5));
IkReal x2359=((cj6)*(r21));
IkReal x2360=((r20)*(sj6));
IkReal x2361=((r10)*(sj6));
IkReal x2362=((IkReal(1.00000000000000))*(cj0));
IkReal x2363=((cj0)*(sj4)*(sj6));
IkReal x2364=((sj0)*(sj4)*(sj6));
evalcond[0]=((((cj2)*(x2347)))+(((sj5)*(x2360)))+(((sj5)*(x2359)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj2)*(x2348)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((r20)*(x2356)))+(((cj4)*(r22)*(sj5)))+(((x2358)*(x2359)))+(((x2358)*(x2360))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2357)*(x2361)))+(((IkReal(-1.00000000000000))*(sj2)*(x2347)))+(((IkReal(-1.00000000000000))*(x2355)*(x2357)))+(((r12)*(x2353)))+(((x2349)*(x2350)))+(((IkReal(-1.00000000000000))*(r02)*(x2354)))+(((x2349)*(x2352))));
evalcond[3]=((((r02)*(x2353)))+(((IkReal(-1.00000000000000))*(x2349)*(x2361)))+(((IkReal(-1.00000000000000))*(x2350)*(x2357)))+(x2348)+(((r12)*(x2354)))+(((IkReal(-1.00000000000000))*(x2349)*(x2355)))+(((IkReal(-1.00000000000000))*(x2352)*(x2357))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r12)*(x2351)*(x2357)))+(((cj4)*(x2350)*(x2354)))+(((IkReal(-1.00000000000000))*(x2351)*(x2353)*(x2361)))+(((r00)*(sj0)*(x2356)))+(((IkReal(-1.00000000000000))*(r10)*(x2356)*(x2362)))+(((cj4)*(x2352)*(x2354)))+(((IkReal(-1.00000000000000))*(x2351)*(x2353)*(x2355)))+(((r11)*(x2363)))+(((cj4)*(r02)*(x2349)))+(((sj2)*(x2348)))+(((IkReal(-1.00000000000000))*(r01)*(x2364))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2351)*(x2354)*(x2355)))+(((IkReal(-1.00000000000000))*(x2351)*(x2354)*(x2361)))+(((r11)*(x2364)))+(((IkReal(-1.00000000000000))*(r12)*(x2349)*(x2351)))+(x2347)+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2356)))+(((IkReal(-1.00000000000000))*(x2351)*(x2352)*(x2353)))+(((IkReal(-1.00000000000000))*(r02)*(x2351)*(x2357)))+(((IkReal(-1.00000000000000))*(r00)*(x2356)*(x2362)))+(((r01)*(x2363)))+(((IkReal(-1.00000000000000))*(x2350)*(x2351)*(x2353))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2365=((cj6)*(sj5));
IkReal x2366=((IkReal(1.00000000000000))*(cj5));
IkReal x2367=((sj5)*(sj6));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r21)*(x2365)))+(((IkReal(-1.00000000000000))*(r20)*(x2367)))+(((cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj0)*(r01)*(x2365)))+(((r10)*(sj0)*(x2367)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2366)))+(((r11)*(sj0)*(x2365)))+(((cj0)*(r00)*(x2367)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2366))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r21)*(x2365)))+(((IkReal(-1.00000000000000))*(r20)*(x2367)))+(((cj5)*(r22)))))))+IKsqr(((((cj0)*(r01)*(x2365)))+(((r10)*(sj0)*(x2367)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2366)))+(((r11)*(sj0)*(x2365)))+(((cj0)*(r00)*(x2367)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2366)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r21)*(x2365)))+(((IkReal(-1.00000000000000))*(r20)*(x2367)))+(((cj5)*(r22)))))), ((((cj0)*(r01)*(x2365)))+(((r10)*(sj0)*(x2367)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2366)))+(((r11)*(sj0)*(x2365)))+(((cj0)*(r00)*(x2367)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2366)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2368=IKsin(j3);
IkReal x2369=IKcos(j3);
IkReal x2370=((sj0)*(sj5));
IkReal x2371=((r00)*(sj6));
IkReal x2372=((IkReal(1.00000000000000))*(cj4));
IkReal x2373=((cj6)*(r01));
IkReal x2374=((cj0)*(cj5));
IkReal x2375=((cj5)*(sj0));
IkReal x2376=((cj6)*(r11));
IkReal x2377=((cj6)*(sj4));
IkReal x2378=((cj0)*(sj5));
IkReal x2379=((cj4)*(cj5));
IkReal x2380=((cj6)*(r21));
IkReal x2381=((r20)*(sj6));
IkReal x2382=((r10)*(sj6));
IkReal x2383=((IkReal(1.00000000000000))*(cj0));
IkReal x2384=((cj0)*(sj4)*(sj6));
IkReal x2385=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x2380)))+(((sj5)*(x2381)))+(((cj2)*(x2368))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj2)*(x2369)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x2377)))+(((x2379)*(x2381)))+(((x2379)*(x2380))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2376)*(x2378)))+(((r12)*(x2374)))+(((x2370)*(x2373)))+(((IkReal(-1.00000000000000))*(x2378)*(x2382)))+(((IkReal(-1.00000000000000))*(r02)*(x2375)))+(((x2370)*(x2371)))+(((IkReal(-1.00000000000000))*(sj2)*(x2368))));
evalcond[3]=((x2369)+(((IkReal(-1.00000000000000))*(x2370)*(x2382)))+(((r02)*(x2374)))+(((IkReal(-1.00000000000000))*(x2371)*(x2378)))+(((IkReal(-1.00000000000000))*(x2370)*(x2376)))+(((r12)*(x2375)))+(((IkReal(-1.00000000000000))*(x2373)*(x2378))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r12)*(x2372)*(x2378)))+(((IkReal(-1.00000000000000))*(x2372)*(x2374)*(x2376)))+(((r11)*(x2384)))+(((cj4)*(x2373)*(x2375)))+(((cj4)*(r02)*(x2370)))+(((sj2)*(x2369)))+(((IkReal(-1.00000000000000))*(r01)*(x2385)))+(((r00)*(sj0)*(x2377)))+(((IkReal(-1.00000000000000))*(r10)*(x2377)*(x2383)))+(((IkReal(-1.00000000000000))*(x2372)*(x2374)*(x2382)))+(((cj4)*(x2371)*(x2375))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2372)*(x2373)*(x2374)))+(x2368)+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2377)))+(((IkReal(-1.00000000000000))*(x2372)*(x2375)*(x2382)))+(((IkReal(-1.00000000000000))*(r00)*(x2377)*(x2383)))+(((r01)*(x2384)))+(((IkReal(-1.00000000000000))*(x2371)*(x2372)*(x2374)))+(((IkReal(-1.00000000000000))*(x2372)*(x2375)*(x2376)))+(((IkReal(-1.00000000000000))*(r12)*(x2370)*(x2372)))+(((IkReal(-1.00000000000000))*(r02)*(x2372)*(x2378)))+(((r11)*(x2385))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2386=((IkReal(1.00000000000000))*(r21));
IkReal x2387=((cj4)*(cj5));
IkReal x2388=((r20)*(sj6));
if( IKabs(((gconst56)*(((((IkReal(-1.00000000000000))*(sj5)*(x2388)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x2386)))+(((cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst56)*(((((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x2387)))+(((x2387)*(x2388)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x2386))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst56)*(((((IkReal(-1.00000000000000))*(sj5)*(x2388)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x2386)))+(((cj5)*(r22)))))), ((gconst56)*(((((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(x2387)))+(((x2387)*(x2388)))+(((IkReal(-1.00000000000000))*(sj4)*(sj6)*(x2386)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2389=IKsin(j3);
IkReal x2390=IKcos(j3);
IkReal x2391=((sj0)*(sj5));
IkReal x2392=((r00)*(sj6));
IkReal x2393=((IkReal(1.00000000000000))*(cj4));
IkReal x2394=((cj6)*(r01));
IkReal x2395=((cj0)*(cj5));
IkReal x2396=((cj5)*(sj0));
IkReal x2397=((cj6)*(r11));
IkReal x2398=((cj6)*(sj4));
IkReal x2399=((cj0)*(sj5));
IkReal x2400=((cj4)*(cj5));
IkReal x2401=((cj6)*(r21));
IkReal x2402=((r20)*(sj6));
IkReal x2403=((r10)*(sj6));
IkReal x2404=((IkReal(1.00000000000000))*(cj0));
IkReal x2405=((cj0)*(sj4)*(sj6));
IkReal x2406=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((cj2)*(x2389)))+(((sj5)*(x2401)))+(((sj5)*(x2402))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((r20)*(x2398)))+(((x2400)*(x2402)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj2)*(x2390)))+(((x2400)*(x2401))));
evalcond[2]=((((x2391)*(x2392)))+(((IkReal(-1.00000000000000))*(r02)*(x2396)))+(((IkReal(-1.00000000000000))*(x2399)*(x2403)))+(((IkReal(-1.00000000000000))*(sj2)*(x2389)))+(((IkReal(-1.00000000000000))*(x2397)*(x2399)))+(((r12)*(x2395)))+(((x2391)*(x2394))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x2391)*(x2403)))+(((r12)*(x2396)))+(((r02)*(x2395)))+(((IkReal(-1.00000000000000))*(x2392)*(x2399)))+(x2390)+(((IkReal(-1.00000000000000))*(x2394)*(x2399)))+(((IkReal(-1.00000000000000))*(x2391)*(x2397))));
evalcond[4]=((((cj4)*(r02)*(x2391)))+(((sj2)*(x2390)))+(((cj4)*(x2392)*(x2396)))+(((IkReal(-1.00000000000000))*(r01)*(x2406)))+(((cj4)*(x2394)*(x2396)))+(((IkReal(-1.00000000000000))*(x2393)*(x2395)*(x2397)))+(((r11)*(x2405)))+(((IkReal(-1.00000000000000))*(r10)*(x2398)*(x2404)))+(((IkReal(-1.00000000000000))*(x2393)*(x2395)*(x2403)))+(((IkReal(-1.00000000000000))*(r12)*(x2393)*(x2399)))+(((r00)*(sj0)*(x2398))));
evalcond[5]=((x2389)+(((IkReal(-1.00000000000000))*(r00)*(x2398)*(x2404)))+(((r01)*(x2405)))+(((IkReal(-1.00000000000000))*(x2393)*(x2394)*(x2395)))+(((IkReal(-1.00000000000000))*(r12)*(x2391)*(x2393)))+(((IkReal(-1.00000000000000))*(x2393)*(x2396)*(x2397)))+(((IkReal(-1.00000000000000))*(x2393)*(x2396)*(x2403)))+(((r11)*(x2406)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2398)))+(((IkReal(-1.00000000000000))*(x2392)*(x2393)*(x2395)))+(((IkReal(-1.00000000000000))*(r02)*(x2393)*(x2399))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

} else
{
IkReal x2407=((r20)*(sj6));
IkReal x2408=((IkReal(0.0100000000000000))*(cj5));
IkReal x2409=((IkReal(0.374290000000000))*(sj5));
IkReal x2410=((cj6)*(r21));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.364420000000000))+(((IkReal(-1.00000000000000))*(x2408)*(x2410)))+(((IkReal(-1.00000000000000))*(x2407)*(x2408)))+(((x2407)*(x2409)))+(((IkReal(-0.0100000000000000))*(r22)*(sj5)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((x2409)*(x2410))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x2411=((IkReal(0.144927536231884))*(cj0));
IkReal x2412=((r02)*(sj5));
IkReal x2413=((IkReal(14.4927536231884))*(cj0));
IkReal x2414=((cj5)*(cj6));
IkReal x2415=((cj5)*(sj6));
IkReal x2416=((IkReal(5.42449275362319))*(sj0));
IkReal x2417=((cj5)*(r12));
IkReal x2418=((IkReal(14.4927536231884))*(sj0));
IkReal x2419=((IkReal(0.144927536231884))*(sj0));
IkReal x2420=((sj5)*(sj6));
IkReal x2421=((IkReal(5.42449275362319))*(cj0));
IkReal x2422=((r12)*(sj5));
IkReal x2423=((cj5)*(r02));
IkReal x2424=((cj6)*(r11)*(sj5));
IkReal x2425=((IkReal(5.42449275362319))*(cj6)*(r01)*(sj5));
if( IKabs(((((r10)*(x2420)*(x2421)))+(((IkReal(-1.00000000000000))*(r00)*(x2416)*(x2420)))+(((IkReal(-1.00000000000000))*(px)*(x2418)))+(((IkReal(-1.00000000000000))*(x2411)*(x2422)))+(((r01)*(x2414)*(x2419)))+(((py)*(x2413)))+(((x2421)*(x2424)))+(((x2412)*(x2419)))+(((IkReal(-1.00000000000000))*(r11)*(x2411)*(x2414)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(sj5)*(x2416)))+(((IkReal(-1.00000000000000))*(r10)*(x2411)*(x2415)))+(((r00)*(x2415)*(x2419)))+(((IkReal(-1.00000000000000))*(x2417)*(x2421)))+(((x2416)*(x2423))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(1.00000000000000))+(((x2411)*(x2412)))+(((IkReal(-1.00000000000000))*(px)*(x2413)))+(((r00)*(x2411)*(x2415)))+(((r11)*(x2414)*(x2419)))+(((r10)*(x2415)*(x2419)))+(((x2421)*(x2423)))+(((x2416)*(x2417)))+(((r01)*(x2411)*(x2414)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(sj5)*(x2421)))+(((IkReal(-1.00000000000000))*(r00)*(x2420)*(x2421)))+(((IkReal(-1.00000000000000))*(x2416)*(x2424)))+(((x2419)*(x2422)))+(((IkReal(-1.00000000000000))*(r10)*(x2416)*(x2420)))+(((IkReal(-1.00000000000000))*(py)*(x2418))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r10)*(x2420)*(x2421)))+(((IkReal(-1.00000000000000))*(r00)*(x2416)*(x2420)))+(((IkReal(-1.00000000000000))*(px)*(x2418)))+(((IkReal(-1.00000000000000))*(x2411)*(x2422)))+(((r01)*(x2414)*(x2419)))+(((py)*(x2413)))+(((x2421)*(x2424)))+(((x2412)*(x2419)))+(((IkReal(-1.00000000000000))*(r11)*(x2411)*(x2414)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(sj5)*(x2416)))+(((IkReal(-1.00000000000000))*(r10)*(x2411)*(x2415)))+(((r00)*(x2415)*(x2419)))+(((IkReal(-1.00000000000000))*(x2417)*(x2421)))+(((x2416)*(x2423)))))+IKsqr(((IkReal(1.00000000000000))+(((x2411)*(x2412)))+(((IkReal(-1.00000000000000))*(px)*(x2413)))+(((r00)*(x2411)*(x2415)))+(((r11)*(x2414)*(x2419)))+(((r10)*(x2415)*(x2419)))+(((x2421)*(x2423)))+(((x2416)*(x2417)))+(((r01)*(x2411)*(x2414)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(sj5)*(x2421)))+(((IkReal(-1.00000000000000))*(r00)*(x2420)*(x2421)))+(((IkReal(-1.00000000000000))*(x2416)*(x2424)))+(((x2419)*(x2422)))+(((IkReal(-1.00000000000000))*(r10)*(x2416)*(x2420)))+(((IkReal(-1.00000000000000))*(py)*(x2418)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((r10)*(x2420)*(x2421)))+(((IkReal(-1.00000000000000))*(r00)*(x2416)*(x2420)))+(((IkReal(-1.00000000000000))*(px)*(x2418)))+(((IkReal(-1.00000000000000))*(x2411)*(x2422)))+(((r01)*(x2414)*(x2419)))+(((py)*(x2413)))+(((x2421)*(x2424)))+(((x2412)*(x2419)))+(((IkReal(-1.00000000000000))*(r11)*(x2411)*(x2414)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(sj5)*(x2416)))+(((IkReal(-1.00000000000000))*(r10)*(x2411)*(x2415)))+(((r00)*(x2415)*(x2419)))+(((IkReal(-1.00000000000000))*(x2417)*(x2421)))+(((x2416)*(x2423)))), ((IkReal(1.00000000000000))+(((x2411)*(x2412)))+(((IkReal(-1.00000000000000))*(px)*(x2413)))+(((r00)*(x2411)*(x2415)))+(((r11)*(x2414)*(x2419)))+(((r10)*(x2415)*(x2419)))+(((x2421)*(x2423)))+(((x2416)*(x2417)))+(((r01)*(x2411)*(x2414)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(sj5)*(x2421)))+(((IkReal(-1.00000000000000))*(r00)*(x2420)*(x2421)))+(((IkReal(-1.00000000000000))*(x2416)*(x2424)))+(((x2419)*(x2422)))+(((IkReal(-1.00000000000000))*(r10)*(x2416)*(x2420)))+(((IkReal(-1.00000000000000))*(py)*(x2418)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x2426=((IkReal(0.374290000000000))*(sj0));
IkReal x2427=((cj5)*(r02));
IkReal x2428=((IkReal(0.0100000000000000))*(cj0));
IkReal x2429=((cj5)*(cj6));
IkReal x2430=((r02)*(sj5));
IkReal x2431=((cj5)*(sj6));
IkReal x2432=((IkReal(1.00000000000000))*(py));
IkReal x2433=((cj6)*(sj5));
IkReal x2434=((IkReal(0.0100000000000000))*(sj0));
IkReal x2435=((sj5)*(sj6));
IkReal x2436=((cj5)*(r12));
IkReal x2437=((IkReal(0.374290000000000))*(cj0));
IkReal x2438=((r12)*(sj5));
IkReal x2439=((x2433)*(x2437));
IkReal x2440=((x2435)*(x2437));
evalcond[0]=((((x2428)*(x2438)))+(((IkReal(-1.00000000000000))*(r10)*(x2440)))+(((IkReal(-1.00000000000000))*(r00)*(x2431)*(x2434)))+(((IkReal(-1.00000000000000))*(r11)*(x2439)))+(((IkReal(-1.00000000000000))*(r01)*(x2429)*(x2434)))+(((r01)*(x2426)*(x2433)))+(((IkReal(-1.00000000000000))*(x2426)*(x2427)))+(((IkReal(0.0690000000000000))*(IKsin(j2))))+(((r10)*(x2428)*(x2431)))+(((r00)*(x2426)*(x2435)))+(((px)*(sj0)))+(((r11)*(x2428)*(x2429)))+(((IkReal(-1.00000000000000))*(cj0)*(x2432)))+(((IkReal(-1.00000000000000))*(x2430)*(x2434)))+(((x2436)*(x2437))));
evalcond[1]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((x2434)*(x2438)))+(((IkReal(-0.0690000000000000))*(IKcos(j2))))+(((r00)*(x2428)*(x2431)))+(((x2426)*(x2436)))+(((r10)*(x2431)*(x2434)))+(((x2427)*(x2437)))+(((IkReal(-1.00000000000000))*(r00)*(x2440)))+(((IkReal(-1.00000000000000))*(r01)*(x2439)))+(((IkReal(-1.00000000000000))*(r10)*(x2426)*(x2435)))+(((r11)*(x2429)*(x2434)))+(((x2428)*(x2430)))+(((r01)*(x2428)*(x2429)))+(((IkReal(-1.00000000000000))*(r11)*(x2426)*(x2433)))+(((IkReal(-1.00000000000000))*(sj0)*(x2432))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst65;
IkReal x2441=(cj6)*(cj6);
IkReal x2442=(sj6)*(sj6);
IkReal x2443=((IkReal(1.00000000000000))*(r21));
IkReal x2444=((cj6)*(r20));
IkReal x2445=((r22)*(sj5));
IkReal x2446=((r01)*(sj0));
IkReal x2447=((r00)*(sj0));
IkReal x2448=((cj0)*(r10));
IkReal x2449=((r02)*(sj0)*(sj5));
IkReal x2450=((cj5)*(x2441));
IkReal x2451=((cj0)*(r12)*(sj5));
IkReal x2452=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x2453=((cj5)*(x2442));
IkReal x2454=((r20)*(x2453));
gconst65=IKsign(((((IkReal(-1.00000000000000))*(cj6)*(x2445)*(x2447)))+(((sj6)*(x2445)*(x2446)))+(((r21)*(x2448)*(x2450)))+(((IkReal(-1.00000000000000))*(x2443)*(x2447)*(x2453)))+(((x2446)*(x2454)))+(((IkReal(-1.00000000000000))*(x2443)*(x2447)*(x2450)))+(((r21)*(x2448)*(x2453)))+(((IkReal(-1.00000000000000))*(x2444)*(x2451)))+(((IkReal(-1.00000000000000))*(sj6)*(x2445)*(x2452)))+(((r20)*(x2446)*(x2450)))+(((IkReal(-1.00000000000000))*(x2452)*(x2454)))+(((IkReal(-1.00000000000000))*(r20)*(x2450)*(x2452)))+(((x2444)*(x2449)))+(((IkReal(-1.00000000000000))*(sj6)*(x2443)*(x2449)))+(((r21)*(sj6)*(x2451)))+(((cj6)*(x2445)*(x2448)))));
IkReal x2455=(cj6)*(cj6);
IkReal x2456=(sj6)*(sj6);
IkReal x2457=((IkReal(1.00000000000000))*(r21));
IkReal x2458=((cj6)*(r20));
IkReal x2459=((r22)*(sj5));
IkReal x2460=((r01)*(sj0));
IkReal x2461=((r00)*(sj0));
IkReal x2462=((cj0)*(r10));
IkReal x2463=((r02)*(sj0)*(sj5));
IkReal x2464=((cj5)*(x2455));
IkReal x2465=((cj0)*(r12)*(sj5));
IkReal x2466=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x2467=((cj5)*(x2456));
IkReal x2468=((r20)*(x2467));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2458)*(x2465)))+(((r21)*(sj6)*(x2465)))+(((IkReal(-1.00000000000000))*(x2457)*(x2461)*(x2467)))+(((x2458)*(x2463)))+(((IkReal(-1.00000000000000))*(sj6)*(x2459)*(x2466)))+(((IkReal(-1.00000000000000))*(x2466)*(x2468)))+(((cj6)*(x2459)*(x2462)))+(((IkReal(-1.00000000000000))*(x2457)*(x2461)*(x2464)))+(((r20)*(x2460)*(x2464)))+(((r21)*(x2462)*(x2467)))+(((sj6)*(x2459)*(x2460)))+(((IkReal(-1.00000000000000))*(cj6)*(x2459)*(x2461)))+(((IkReal(-1.00000000000000))*(r20)*(x2464)*(x2466)))+(((IkReal(-1.00000000000000))*(sj6)*(x2457)*(x2463)))+(((r21)*(x2462)*(x2464)))+(((x2460)*(x2468))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst66;
IkReal x2469=(sj6)*(sj6);
IkReal x2470=(cj6)*(cj6);
IkReal x2471=((r10)*(sj0));
IkReal x2472=((r22)*(sj5));
IkReal x2473=((cj0)*(cj5));
IkReal x2474=((IkReal(1.00000000000000))*(r20));
IkReal x2475=((cj0)*(sj6));
IkReal x2476=((r21)*(sj5));
IkReal x2477=((sj0)*(sj6));
IkReal x2478=((cj6)*(sj5));
IkReal x2479=((r21)*(x2470));
IkReal x2480=((cj5)*(r11)*(sj0));
IkReal x2481=((r21)*(x2469));
gconst66=IKsign(((((r12)*(x2476)*(x2477)))+(((IkReal(-1.00000000000000))*(x2470)*(x2474)*(x2480)))+(((IkReal(-1.00000000000000))*(r01)*(x2469)*(x2473)*(x2474)))+(((IkReal(-1.00000000000000))*(r01)*(x2472)*(x2475)))+(((r00)*(x2473)*(x2481)))+(((cj5)*(x2471)*(x2481)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2474)*(x2478)))+(((r02)*(x2475)*(x2476)))+(((IkReal(-1.00000000000000))*(x2469)*(x2474)*(x2480)))+(((cj5)*(x2471)*(x2479)))+(((r00)*(x2473)*(x2479)))+(((IkReal(-1.00000000000000))*(r11)*(x2472)*(x2477)))+(((cj0)*(cj6)*(r00)*(x2472)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2474)*(x2478)))+(((IkReal(-1.00000000000000))*(r01)*(x2470)*(x2473)*(x2474)))+(((cj6)*(x2471)*(x2472)))));
IkReal x2482=(sj6)*(sj6);
IkReal x2483=(cj6)*(cj6);
IkReal x2484=((r10)*(sj0));
IkReal x2485=((r22)*(sj5));
IkReal x2486=((cj0)*(cj5));
IkReal x2487=((IkReal(1.00000000000000))*(r20));
IkReal x2488=((cj0)*(sj6));
IkReal x2489=((r21)*(sj5));
IkReal x2490=((sj0)*(sj6));
IkReal x2491=((cj6)*(sj5));
IkReal x2492=((r21)*(x2483));
IkReal x2493=((cj5)*(r11)*(sj0));
IkReal x2494=((r21)*(x2482));
dummyeval[0]=((((cj6)*(x2484)*(x2485)))+(((r02)*(x2488)*(x2489)))+(((r00)*(x2486)*(x2494)))+(((cj5)*(x2484)*(x2494)))+(((IkReal(-1.00000000000000))*(r01)*(x2483)*(x2486)*(x2487)))+(((IkReal(-1.00000000000000))*(x2482)*(x2487)*(x2493)))+(((IkReal(-1.00000000000000))*(x2483)*(x2487)*(x2493)))+(((IkReal(-1.00000000000000))*(r01)*(x2485)*(x2488)))+(((IkReal(-1.00000000000000))*(r01)*(x2482)*(x2486)*(x2487)))+(((cj5)*(x2484)*(x2492)))+(((IkReal(-1.00000000000000))*(r11)*(x2485)*(x2490)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2487)*(x2491)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2487)*(x2491)))+(((cj0)*(cj6)*(r00)*(x2485)))+(((r00)*(x2486)*(x2492)))+(((r12)*(x2489)*(x2490))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x2495=((cj0)*(r11));
IkReal x2496=((r01)*(sj0));
IkReal x2497=((cj0)*(r01));
IkReal x2498=((IkReal(0.374290000000000))*(sj0));
IkReal x2499=((cj5)*(r02));
IkReal x2500=((IkReal(0.374290000000000))*(cj0));
IkReal x2501=((r11)*(sj0));
IkReal x2502=((IkReal(0.0100000000000000))*(cj0));
IkReal x2503=((r02)*(sj5));
IkReal x2504=((cj5)*(sj6));
IkReal x2505=((IkReal(1.00000000000000))*(sj0));
IkReal x2506=((cj5)*(r12));
IkReal x2507=((IkReal(0.0100000000000000))*(sj5));
IkReal x2508=((sj5)*(sj6));
IkReal x2509=((IkReal(1.00000000000000))*(cj0));
IkReal x2510=((IkReal(0.0100000000000000))*(sj0));
IkReal x2511=((IkReal(0.374290000000000))*(cj6)*(sj5));
IkReal x2512=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x2513=((r10)*(x2508));
IkReal x2514=((IkReal(1.00000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.364420000000000))+(((IkReal(0.374290000000000))*(r20)*(x2508)))+(((IkReal(-0.0100000000000000))*(r20)*(x2504)))+(((IkReal(-1.00000000000000))*(r21)*(x2512)))+(((r21)*(x2511)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r22)*(x2507)))+(pz));
evalcond[2]=((((sj0)*(x2506)))+(((IkReal(-1.00000000000000))*(x2501)*(x2514)))+(((IkReal(-1.00000000000000))*(r00)*(x2508)*(x2509)))+(((IkReal(-1.00000000000000))*(x2505)*(x2513)))+(((cj0)*(x2499)))+(((IkReal(-1.00000000000000))*(x2497)*(x2514))));
evalcond[3]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(x2500)*(x2513)))+(((r10)*(x2502)*(x2504)))+(((IkReal(-1.00000000000000))*(x2495)*(x2511)))+(((IkReal(-1.00000000000000))*(py)*(x2509)))+(((x2500)*(x2506)))+(((IkReal(-1.00000000000000))*(x2498)*(x2499)))+(((x2495)*(x2512)))+(((IkReal(-1.00000000000000))*(r00)*(x2504)*(x2510)))+(((x2496)*(x2511)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x2503)*(x2510)))+(((r12)*(sj5)*(x2502)))+(((r00)*(x2498)*(x2508)))+(((IkReal(-1.00000000000000))*(x2496)*(x2512))));
evalcond[4]=((IkReal(0.0690000000000000))+(((r00)*(x2502)*(x2504)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj5)*(x2498)))+(((x2498)*(x2506)))+(((x2502)*(x2503)))+(((IkReal(-1.00000000000000))*(r00)*(x2500)*(x2508)))+(((r12)*(sj0)*(x2507)))+(((IkReal(-1.00000000000000))*(px)*(x2509)))+(((IkReal(-1.00000000000000))*(x2497)*(x2511)))+(((x2501)*(x2512)))+(((x2499)*(x2500)))+(((x2497)*(x2512)))+(((IkReal(-1.00000000000000))*(py)*(x2505)))+(((r10)*(x2504)*(x2510)))+(((IkReal(-1.00000000000000))*(x2498)*(x2513))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2515=((sj5)*(sj6));
IkReal x2516=((cj6)*(sj5));
IkReal x2517=((IkReal(1.00000000000000))*(cj0));
IkReal x2518=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r11)*(x2516)*(x2517)))+(((r00)*(sj0)*(x2515)))+(((IkReal(-1.00000000000000))*(r10)*(x2515)*(x2517)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2518)))+(((cj0)*(cj5)*(r12)))+(((r01)*(sj0)*(x2516))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r20)*(x2515)))+(((r21)*(x2516)))+(((IkReal(-1.00000000000000))*(r22)*(x2518))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r11)*(x2516)*(x2517)))+(((r00)*(sj0)*(x2515)))+(((IkReal(-1.00000000000000))*(r10)*(x2515)*(x2517)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2518)))+(((cj0)*(cj5)*(r12)))+(((r01)*(sj0)*(x2516)))))+IKsqr(((((r20)*(x2515)))+(((r21)*(x2516)))+(((IkReal(-1.00000000000000))*(r22)*(x2518)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r11)*(x2516)*(x2517)))+(((r00)*(sj0)*(x2515)))+(((IkReal(-1.00000000000000))*(r10)*(x2515)*(x2517)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2518)))+(((cj0)*(cj5)*(r12)))+(((r01)*(sj0)*(x2516)))), ((((r20)*(x2515)))+(((r21)*(x2516)))+(((IkReal(-1.00000000000000))*(r22)*(x2518)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x2519=((sj5)*(sj6));
IkReal x2520=((cj6)*(sj5));
IkReal x2521=((IkReal(1.00000000000000))*(cj0));
IkReal x2522=((IkReal(1.00000000000000))*(cj5));
evalcond[0]=((((r21)*(x2520)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((r20)*(x2519)))+(((IkReal(-1.00000000000000))*(r22)*(x2522))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2522)))+(((IkReal(-1.00000000000000))*(r11)*(x2520)*(x2521)))+(((r01)*(sj0)*(x2520)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r10)*(x2519)*(x2521)))+(((r00)*(sj0)*(x2519)))+(((IkReal(-1.00000000000000))*(IKsin(j3)))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst71;
IkReal x2523=(r21)*(r21);
IkReal x2524=(cj5)*(cj5);
IkReal x2525=(sj6)*(sj6);
IkReal x2526=(cj6)*(cj6);
IkReal x2527=(r20)*(r20);
IkReal x2528=((cj6)*(r21));
IkReal x2529=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x2530=((cj5)*(r22)*(sj5));
IkReal x2531=((IkReal(1.00000000000000))*(x2525));
IkReal x2532=((IkReal(1.00000000000000))*(x2526));
gconst71=IKsign(((((IkReal(-1.00000000000000))*(x2523)*(x2531)))+(((IkReal(-2.00000000000000))*(x2528)*(x2530)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x2523)*(x2524)*(x2532)))+(((IkReal(-1.00000000000000))*(x2527)*(x2532)))+(((IkReal(-1.00000000000000))*(x2524)*(x2527)*(x2531)))+(((x2528)*(x2529)))+(((IkReal(-1.00000000000000))*(x2524)*(x2528)*(x2529)))+(((IkReal(-1.00000000000000))*(x2529)*(x2530)))));
IkReal x2533=(r21)*(r21);
IkReal x2534=(cj5)*(cj5);
IkReal x2535=(sj6)*(sj6);
IkReal x2536=(cj6)*(cj6);
IkReal x2537=(r20)*(r20);
IkReal x2538=((cj6)*(r21));
IkReal x2539=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x2540=((cj5)*(r22)*(sj5));
IkReal x2541=((IkReal(1.00000000000000))*(x2535));
IkReal x2542=((IkReal(1.00000000000000))*(x2536));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2533)*(x2534)*(x2542)))+(((IkReal(-2.00000000000000))*(x2538)*(x2540)))+(((IkReal(-1.00000000000000))*(x2533)*(x2541)))+(((IkReal(-1.00000000000000))*(x2534)*(x2537)*(x2541)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x2534)*(x2538)*(x2539)))+(((x2538)*(x2539)))+(((IkReal(-1.00000000000000))*(x2537)*(x2542)))+(((IkReal(-1.00000000000000))*(x2539)*(x2540))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst72;
IkReal x2543=(sj6)*(sj6);
IkReal x2544=(cj5)*(cj5);
IkReal x2545=(cj6)*(cj6);
IkReal x2546=(sj5)*(sj5);
IkReal x2547=((r01)*(sj0));
IkReal x2548=((cj0)*(sj6));
IkReal x2549=((cj6)*(r21));
IkReal x2550=((r22)*(sj0));
IkReal x2551=((cj5)*(sj5));
IkReal x2552=((r00)*(sj6));
IkReal x2553=((IkReal(1.00000000000000))*(cj0));
IkReal x2554=((cj6)*(r22));
IkReal x2555=((r02)*(sj0));
IkReal x2556=((r20)*(sj6));
IkReal x2557=((IkReal(1.00000000000000))*(cj6));
IkReal x2558=((r00)*(sj0));
IkReal x2559=((r21)*(x2544));
IkReal x2560=((IkReal(1.00000000000000))*(x2551));
IkReal x2561=((r21)*(x2543));
IkReal x2562=((cj6)*(r11)*(r20));
IkReal x2563=((r20)*(x2545));
IkReal x2564=((r20)*(x2543)*(x2544));
gconst72=IKsign(((((IkReal(-1.00000000000000))*(r11)*(x2551)*(x2553)*(x2554)))+(((x2558)*(x2563)))+(((x2558)*(x2564)))+(((cj6)*(x2544)*(x2547)*(x2556)))+(((IkReal(-1.00000000000000))*(x2547)*(x2556)*(x2557)))+(((x2547)*(x2561)))+(((x2550)*(x2551)*(x2552)))+(((r10)*(x2548)*(x2549)))+(((IkReal(-1.00000000000000))*(r11)*(r20)*(x2544)*(x2548)*(x2557)))+(((r02)*(x2546)*(x2550)))+(((IkReal(-1.00000000000000))*(r12)*(x2549)*(x2551)*(x2553)))+(((IkReal(-1.00000000000000))*(r11)*(x2545)*(x2553)*(x2559)))+(((IkReal(-1.00000000000000))*(r12)*(r20)*(x2548)*(x2560)))+(((x2549)*(x2551)*(x2555)))+(((x2547)*(x2551)*(x2554)))+(((IkReal(-1.00000000000000))*(r12)*(r22)*(x2546)*(x2553)))+(((x2548)*(x2562)))+(((sj0)*(x2544)*(x2549)*(x2552)))+(((IkReal(-1.00000000000000))*(r10)*(x2544)*(x2548)*(x2549)))+(((IkReal(-1.00000000000000))*(r10)*(x2553)*(x2563)))+(((IkReal(-1.00000000000000))*(r10)*(x2553)*(x2564)))+(((IkReal(-1.00000000000000))*(r10)*(r22)*(x2548)*(x2560)))+(((x2545)*(x2547)*(x2559)))+(((IkReal(-1.00000000000000))*(sj0)*(x2549)*(x2552)))+(((x2551)*(x2555)*(x2556)))+(((IkReal(-1.00000000000000))*(r11)*(x2553)*(x2561)))));
IkReal x2565=(sj6)*(sj6);
IkReal x2566=(cj5)*(cj5);
IkReal x2567=(cj6)*(cj6);
IkReal x2568=(sj5)*(sj5);
IkReal x2569=((r01)*(sj0));
IkReal x2570=((cj0)*(sj6));
IkReal x2571=((cj6)*(r21));
IkReal x2572=((r22)*(sj0));
IkReal x2573=((cj5)*(sj5));
IkReal x2574=((r00)*(sj6));
IkReal x2575=((IkReal(1.00000000000000))*(cj0));
IkReal x2576=((cj6)*(r22));
IkReal x2577=((r02)*(sj0));
IkReal x2578=((r20)*(sj6));
IkReal x2579=((IkReal(1.00000000000000))*(cj6));
IkReal x2580=((r00)*(sj0));
IkReal x2581=((r21)*(x2566));
IkReal x2582=((IkReal(1.00000000000000))*(x2573));
IkReal x2583=((r21)*(x2565));
IkReal x2584=((cj6)*(r11)*(r20));
IkReal x2585=((r20)*(x2567));
IkReal x2586=((r20)*(x2565)*(x2566));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r11)*(x2567)*(x2575)*(x2581)))+(((x2580)*(x2585)))+(((cj6)*(x2566)*(x2569)*(x2578)))+(((IkReal(-1.00000000000000))*(sj0)*(x2571)*(x2574)))+(((x2569)*(x2583)))+(((IkReal(-1.00000000000000))*(r12)*(x2571)*(x2573)*(x2575)))+(((IkReal(-1.00000000000000))*(r12)*(r20)*(x2570)*(x2582)))+(((IkReal(-1.00000000000000))*(r11)*(r20)*(x2566)*(x2570)*(x2579)))+(((IkReal(-1.00000000000000))*(r10)*(x2575)*(x2585)))+(((x2570)*(x2584)))+(((x2580)*(x2586)))+(((x2567)*(x2569)*(x2581)))+(((IkReal(-1.00000000000000))*(x2569)*(x2578)*(x2579)))+(((x2571)*(x2573)*(x2577)))+(((x2572)*(x2573)*(x2574)))+(((sj0)*(x2566)*(x2571)*(x2574)))+(((IkReal(-1.00000000000000))*(r12)*(r22)*(x2568)*(x2575)))+(((IkReal(-1.00000000000000))*(r10)*(r22)*(x2570)*(x2582)))+(((IkReal(-1.00000000000000))*(r10)*(x2566)*(x2570)*(x2571)))+(((r02)*(x2568)*(x2572)))+(((IkReal(-1.00000000000000))*(r11)*(x2573)*(x2575)*(x2576)))+(((x2569)*(x2573)*(x2576)))+(((x2573)*(x2577)*(x2578)))+(((IkReal(-1.00000000000000))*(r11)*(x2575)*(x2583)))+(((IkReal(-1.00000000000000))*(r10)*(x2575)*(x2586)))+(((r10)*(x2570)*(x2571))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2587=((IkReal(1.00000000000000))*(cj3));
IkReal x2588=((cj5)*(x2587));
if( IKabs(((gconst72)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x2587)))+(((cj3)*(r21)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst72)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2588)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2588)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2587))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst72)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x2587)))+(((cj3)*(r21)*(sj6)))))), ((gconst72)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2588)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2588)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2587)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2589=IKsin(j4);
IkReal x2590=IKcos(j4);
IkReal x2591=((r22)*(sj5));
IkReal x2592=((IkReal(1.00000000000000))*(cj6));
IkReal x2593=((IkReal(1.00000000000000))*(cj0));
IkReal x2594=((cj5)*(r11));
IkReal x2595=((cj5)*(cj6));
IkReal x2596=((r11)*(sj6));
IkReal x2597=((IkReal(1.00000000000000))*(sj6));
IkReal x2598=((cj6)*(r00));
IkReal x2599=((r12)*(sj5));
IkReal x2600=((r02)*(sj5));
IkReal x2601=((cj6)*(r10));
IkReal x2602=((cj5)*(sj6));
IkReal x2603=((cj5)*(r01));
IkReal x2604=((sj0)*(x2589));
IkReal x2605=((r00)*(x2602));
IkReal x2606=((cj0)*(x2589));
IkReal x2607=((sj0)*(x2590));
IkReal x2608=((r20)*(x2590));
IkReal x2609=((cj0)*(x2590));
IkReal x2610=((r21)*(x2589));
IkReal x2611=((r21)*(x2590));
IkReal x2612=((r20)*(x2589));
IkReal x2613=((x2590)*(x2599));
IkReal x2614=((r01)*(sj6)*(x2590));
IkReal x2615=((cj5)*(r10)*(x2597));
evalcond[0]=((((sj6)*(x2611)))+(((IkReal(-1.00000000000000))*(x2592)*(x2608)))+(((x2602)*(x2612)))+(((x2595)*(x2610)))+(((x2589)*(x2591))));
evalcond[1]=((((x2602)*(x2608)))+(((x2590)*(x2591)))+(((IkReal(-1.00000000000000))*(x2597)*(x2610)))+(((cj6)*(x2612)))+(((IkReal(-1.00000000000000))*(sj3)))+(((x2595)*(x2611))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2589)*(x2593)*(x2599)))+(((IkReal(-1.00000000000000))*(r10)*(x2589)*(x2593)*(x2602)))+(((x2600)*(x2604)))+(((x2604)*(x2605)))+(((IkReal(-1.00000000000000))*(r00)*(x2592)*(x2607)))+(((r01)*(x2595)*(x2604)))+(((IkReal(-1.00000000000000))*(x2592)*(x2594)*(x2606)))+(((IkReal(-1.00000000000000))*(x2590)*(x2593)*(x2596)))+(((x2601)*(x2609)))+(((r01)*(sj6)*(x2607))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x2592)*(x2606)))+(((IkReal(-1.00000000000000))*(x2593)*(x2613)))+(((IkReal(-1.00000000000000))*(r10)*(x2590)*(x2593)*(x2602)))+(((IkReal(-1.00000000000000))*(x2592)*(x2594)*(x2609)))+(cj3)+(((x2600)*(x2607)))+(((x2598)*(x2604)))+(((IkReal(-1.00000000000000))*(r01)*(x2597)*(x2604)))+(((r01)*(x2595)*(x2607)))+(((x2605)*(x2607)))+(((x2596)*(x2606))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x2604)*(x2615)))+(((IkReal(-1.00000000000000))*(x2589)*(x2593)*(x2600)))+(((IkReal(-1.00000000000000))*(x2589)*(x2593)*(x2605)))+(((IkReal(-1.00000000000000))*(x2592)*(x2594)*(x2604)))+(((IkReal(-1.00000000000000))*(x2592)*(x2603)*(x2606)))+(((IkReal(-1.00000000000000))*(x2599)*(x2604)))+(((x2601)*(x2607)))+(((IkReal(-1.00000000000000))*(x2596)*(x2607)))+(((x2598)*(x2609)))+(((IkReal(-1.00000000000000))*(x2593)*(x2614))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2607)*(x2615)))+(((r01)*(sj6)*(x2606)))+(((IkReal(-1.00000000000000))*(r00)*(x2592)*(x2606)))+(((IkReal(-1.00000000000000))*(x2592)*(x2603)*(x2609)))+(((IkReal(-1.00000000000000))*(x2590)*(x2593)*(x2600)))+(((IkReal(-1.00000000000000))*(x2599)*(x2607)))+(((IkReal(-1.00000000000000))*(x2590)*(x2593)*(x2605)))+(((IkReal(-1.00000000000000))*(x2592)*(x2594)*(x2607)))+(((x2596)*(x2604)))+(((IkReal(-1.00000000000000))*(r10)*(x2592)*(x2604))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2616=((r21)*(sj3));
IkReal x2617=((IkReal(1.00000000000000))*(r20)*(sj3));
if( IKabs(((gconst71)*(((((IkReal(-1.00000000000000))*(cj6)*(x2617)))+(((sj6)*(x2616))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst71)*(((((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x2617)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x2616)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst71)*(((((IkReal(-1.00000000000000))*(cj6)*(x2617)))+(((sj6)*(x2616)))))), ((gconst71)*(((((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x2617)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x2616)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2618=IKsin(j4);
IkReal x2619=IKcos(j4);
IkReal x2620=((r22)*(sj5));
IkReal x2621=((IkReal(1.00000000000000))*(cj6));
IkReal x2622=((IkReal(1.00000000000000))*(cj0));
IkReal x2623=((cj5)*(r11));
IkReal x2624=((cj5)*(cj6));
IkReal x2625=((r11)*(sj6));
IkReal x2626=((IkReal(1.00000000000000))*(sj6));
IkReal x2627=((cj6)*(r00));
IkReal x2628=((r12)*(sj5));
IkReal x2629=((r02)*(sj5));
IkReal x2630=((cj6)*(r10));
IkReal x2631=((cj5)*(sj6));
IkReal x2632=((cj5)*(r01));
IkReal x2633=((sj0)*(x2618));
IkReal x2634=((r00)*(x2631));
IkReal x2635=((cj0)*(x2618));
IkReal x2636=((sj0)*(x2619));
IkReal x2637=((r20)*(x2619));
IkReal x2638=((cj0)*(x2619));
IkReal x2639=((r21)*(x2618));
IkReal x2640=((r21)*(x2619));
IkReal x2641=((r20)*(x2618));
IkReal x2642=((x2619)*(x2628));
IkReal x2643=((r01)*(sj6)*(x2619));
IkReal x2644=((cj5)*(r10)*(x2626));
evalcond[0]=((((sj6)*(x2640)))+(((IkReal(-1.00000000000000))*(x2621)*(x2637)))+(((x2631)*(x2641)))+(((x2618)*(x2620)))+(((x2624)*(x2639))));
evalcond[1]=((((x2624)*(x2640)))+(((IkReal(-1.00000000000000))*(x2626)*(x2639)))+(((x2619)*(x2620)))+(((x2631)*(x2637)))+(((cj6)*(x2641)))+(((IkReal(-1.00000000000000))*(sj3))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2618)*(x2622)*(x2628)))+(((IkReal(-1.00000000000000))*(x2621)*(x2623)*(x2635)))+(((IkReal(-1.00000000000000))*(r00)*(x2621)*(x2636)))+(((r01)*(sj6)*(x2636)))+(((x2633)*(x2634)))+(((x2630)*(x2638)))+(((IkReal(-1.00000000000000))*(x2619)*(x2622)*(x2625)))+(((r01)*(x2624)*(x2633)))+(((x2629)*(x2633)))+(((IkReal(-1.00000000000000))*(r10)*(x2618)*(x2622)*(x2631))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x2621)*(x2635)))+(((IkReal(-1.00000000000000))*(r01)*(x2626)*(x2633)))+(((r01)*(x2624)*(x2636)))+(((x2629)*(x2636)))+(((IkReal(-1.00000000000000))*(x2622)*(x2642)))+(((x2634)*(x2636)))+(cj3)+(((x2627)*(x2633)))+(((x2625)*(x2635)))+(((IkReal(-1.00000000000000))*(x2621)*(x2623)*(x2638)))+(((IkReal(-1.00000000000000))*(r10)*(x2619)*(x2622)*(x2631))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x2618)*(x2622)*(x2629)))+(((x2630)*(x2636)))+(((IkReal(-1.00000000000000))*(x2628)*(x2633)))+(((IkReal(-1.00000000000000))*(x2621)*(x2623)*(x2633)))+(((IkReal(-1.00000000000000))*(x2625)*(x2636)))+(((x2627)*(x2638)))+(((IkReal(-1.00000000000000))*(x2633)*(x2644)))+(((IkReal(-1.00000000000000))*(x2621)*(x2632)*(x2635)))+(((IkReal(-1.00000000000000))*(x2622)*(x2643)))+(((IkReal(-1.00000000000000))*(x2618)*(x2622)*(x2634))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r00)*(x2621)*(x2635)))+(((x2625)*(x2633)))+(((IkReal(-1.00000000000000))*(r10)*(x2621)*(x2633)))+(((IkReal(-1.00000000000000))*(x2621)*(x2632)*(x2638)))+(((IkReal(-1.00000000000000))*(x2636)*(x2644)))+(((IkReal(-1.00000000000000))*(x2619)*(x2622)*(x2629)))+(((IkReal(-1.00000000000000))*(x2619)*(x2622)*(x2634)))+(((IkReal(-1.00000000000000))*(x2621)*(x2623)*(x2636)))+(((r01)*(sj6)*(x2635)))+(((IkReal(-1.00000000000000))*(x2628)*(x2636))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x2645=((cj0)*(r11));
IkReal x2646=((r01)*(sj0));
IkReal x2647=((cj0)*(r01));
IkReal x2648=((IkReal(0.374290000000000))*(sj0));
IkReal x2649=((cj5)*(r02));
IkReal x2650=((IkReal(0.374290000000000))*(cj0));
IkReal x2651=((r11)*(sj0));
IkReal x2652=((IkReal(0.0100000000000000))*(cj0));
IkReal x2653=((r02)*(sj5));
IkReal x2654=((cj5)*(sj6));
IkReal x2655=((IkReal(1.00000000000000))*(sj0));
IkReal x2656=((cj5)*(r12));
IkReal x2657=((IkReal(0.0100000000000000))*(sj5));
IkReal x2658=((sj5)*(sj6));
IkReal x2659=((IkReal(1.00000000000000))*(cj0));
IkReal x2660=((IkReal(0.0100000000000000))*(sj0));
IkReal x2661=((IkReal(0.374290000000000))*(cj6)*(sj5));
IkReal x2662=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x2663=((r10)*(x2658));
IkReal x2664=((IkReal(1.00000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.364420000000000))+(((IkReal(-0.0100000000000000))*(r20)*(x2654)))+(((IkReal(-1.00000000000000))*(r21)*(x2662)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(0.374290000000000))*(r20)*(x2658)))+(((IkReal(-1.00000000000000))*(r22)*(x2657)))+(pz)+(((r21)*(x2661))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2651)*(x2664)))+(((IkReal(-1.00000000000000))*(r00)*(x2658)*(x2659)))+(((IkReal(-1.00000000000000))*(x2647)*(x2664)))+(((sj0)*(x2656)))+(((cj0)*(x2649)))+(((IkReal(-1.00000000000000))*(x2655)*(x2663))));
evalcond[3]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(x2648)*(x2649)))+(((r10)*(x2652)*(x2654)))+(((IkReal(-1.00000000000000))*(x2650)*(x2663)))+(((x2645)*(x2662)))+(((IkReal(-1.00000000000000))*(x2646)*(x2662)))+(((IkReal(-1.00000000000000))*(x2645)*(x2661)))+(((IkReal(-1.00000000000000))*(r00)*(x2654)*(x2660)))+(((IkReal(-1.00000000000000))*(py)*(x2659)))+(((r12)*(sj5)*(x2652)))+(((x2650)*(x2656)))+(((r00)*(x2648)*(x2658)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x2653)*(x2660)))+(((x2646)*(x2661))));
evalcond[4]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(x2648)*(x2663)))+(((x2648)*(x2656)))+(((x2651)*(x2662)))+(((x2652)*(x2653)))+(((IkReal(-1.00000000000000))*(px)*(x2659)))+(((x2649)*(x2650)))+(((r10)*(x2654)*(x2660)))+(((r12)*(sj0)*(x2657)))+(((x2647)*(x2662)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj5)*(x2648)))+(((r00)*(x2652)*(x2654)))+(((IkReal(-1.00000000000000))*(r00)*(x2650)*(x2658)))+(((IkReal(-1.00000000000000))*(x2647)*(x2661)))+(((IkReal(-1.00000000000000))*(py)*(x2655))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2665=((sj5)*(sj6));
IkReal x2666=((IkReal(1.00000000000000))*(cj5));
IkReal x2667=((IkReal(1.00000000000000))*(sj0));
IkReal x2668=((cj6)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2666)))+(((cj0)*(r11)*(x2668)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x2667)*(x2668)))+(((cj0)*(r10)*(x2665)))+(((IkReal(-1.00000000000000))*(r00)*(x2665)*(x2667))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r20)*(x2665)))+(((IkReal(-1.00000000000000))*(r22)*(x2666)))+(((r21)*(x2668))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2666)))+(((cj0)*(r11)*(x2668)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x2667)*(x2668)))+(((cj0)*(r10)*(x2665)))+(((IkReal(-1.00000000000000))*(r00)*(x2665)*(x2667)))))+IKsqr(((((r20)*(x2665)))+(((IkReal(-1.00000000000000))*(r22)*(x2666)))+(((r21)*(x2668)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj0)*(r12)*(x2666)))+(((cj0)*(r11)*(x2668)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x2667)*(x2668)))+(((cj0)*(r10)*(x2665)))+(((IkReal(-1.00000000000000))*(r00)*(x2665)*(x2667)))), ((((r20)*(x2665)))+(((IkReal(-1.00000000000000))*(r22)*(x2666)))+(((r21)*(x2668)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x2669=((sj5)*(sj6));
IkReal x2670=((cj6)*(sj5));
IkReal x2671=((IkReal(1.00000000000000))*(cj0));
IkReal x2672=((IkReal(1.00000000000000))*(cj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(IKcos(j3))))+(((r21)*(x2670)))+(((IkReal(-1.00000000000000))*(r22)*(x2672)))+(((r20)*(x2669))));
evalcond[1]=((((r00)*(sj0)*(x2669)))+(((IkReal(-1.00000000000000))*(r10)*(x2669)*(x2671)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2672)))+(((r01)*(sj0)*(x2670)))+(((IkReal(-1.00000000000000))*(r11)*(x2670)*(x2671)))+(IKsin(j3)));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst75;
IkReal x2673=(r21)*(r21);
IkReal x2674=(cj5)*(cj5);
IkReal x2675=(sj6)*(sj6);
IkReal x2676=(cj6)*(cj6);
IkReal x2677=(r20)*(r20);
IkReal x2678=((cj6)*(r21));
IkReal x2679=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x2680=((cj5)*(r22)*(sj5));
IkReal x2681=((IkReal(1.00000000000000))*(x2675));
IkReal x2682=((IkReal(1.00000000000000))*(x2676));
gconst75=IKsign(((((x2678)*(x2679)))+(((IkReal(-1.00000000000000))*(x2674)*(x2677)*(x2681)))+(((IkReal(-1.00000000000000))*(x2673)*(x2681)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x2679)*(x2680)))+(((IkReal(-2.00000000000000))*(x2678)*(x2680)))+(((IkReal(-1.00000000000000))*(x2674)*(x2678)*(x2679)))+(((IkReal(-1.00000000000000))*(x2677)*(x2682)))+(((IkReal(-1.00000000000000))*(x2673)*(x2674)*(x2682)))));
IkReal x2683=(r21)*(r21);
IkReal x2684=(cj5)*(cj5);
IkReal x2685=(sj6)*(sj6);
IkReal x2686=(cj6)*(cj6);
IkReal x2687=(r20)*(r20);
IkReal x2688=((cj6)*(r21));
IkReal x2689=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x2690=((cj5)*(r22)*(sj5));
IkReal x2691=((IkReal(1.00000000000000))*(x2685));
IkReal x2692=((IkReal(1.00000000000000))*(x2686));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2689)*(x2690)))+(((IkReal(-1.00000000000000))*(x2683)*(x2691)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((x2688)*(x2689)))+(((IkReal(-1.00000000000000))*(x2683)*(x2684)*(x2692)))+(((IkReal(-2.00000000000000))*(x2688)*(x2690)))+(((IkReal(-1.00000000000000))*(x2684)*(x2687)*(x2691)))+(((IkReal(-1.00000000000000))*(x2684)*(x2688)*(x2689)))+(((IkReal(-1.00000000000000))*(x2687)*(x2692))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst76;
IkReal x2693=(cj6)*(cj6);
IkReal x2694=(cj5)*(cj5);
IkReal x2695=(sj6)*(sj6);
IkReal x2696=(sj5)*(sj5);
IkReal x2697=((cj0)*(r12));
IkReal x2698=((cj6)*(sj6));
IkReal x2699=((cj0)*(r21));
IkReal x2700=((cj0)*(r11));
IkReal x2701=((IkReal(1.00000000000000))*(r20));
IkReal x2702=((r01)*(sj0));
IkReal x2703=((r00)*(sj0));
IkReal x2704=((IkReal(1.00000000000000))*(r22));
IkReal x2705=((cj0)*(r10));
IkReal x2706=((r02)*(sj0));
IkReal x2707=((r22)*(x2696));
IkReal x2708=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x2709=((cj5)*(cj6)*(sj5));
IkReal x2710=((cj5)*(sj5)*(sj6));
IkReal x2711=((cj0)*(r20)*(x2694));
IkReal x2712=((x2693)*(x2694));
gconst76=IKsign(((((IkReal(-1.00000000000000))*(r10)*(x2698)*(x2699)))+(((x2697)*(x2707)))+(((r21)*(x2698)*(x2703)))+(((IkReal(-1.00000000000000))*(x2698)*(x2700)*(x2701)))+(((r20)*(x2694)*(x2698)*(x2700)))+(((r20)*(x2694)*(x2695)*(x2705)))+(((IkReal(-1.00000000000000))*(x2696)*(x2704)*(x2706)))+(((IkReal(-1.00000000000000))*(x2701)*(x2706)*(x2710)))+(((r20)*(x2693)*(x2705)))+(((IkReal(-1.00000000000000))*(r21)*(x2706)*(x2709)))+(((IkReal(-1.00000000000000))*(x2693)*(x2701)*(x2703)))+(((r22)*(x2705)*(x2710)))+(((IkReal(-1.00000000000000))*(x2694)*(x2698)*(x2701)*(x2702)))+(((r21)*(x2697)*(x2709)))+(((IkReal(-1.00000000000000))*(x2703)*(x2704)*(x2710)))+(((IkReal(-1.00000000000000))*(x2694)*(x2695)*(x2701)*(x2703)))+(((IkReal(-1.00000000000000))*(x2702)*(x2704)*(x2709)))+(((r20)*(x2698)*(x2702)))+(((r10)*(x2694)*(x2698)*(x2699)))+(((r11)*(x2695)*(x2699)))+(((IkReal(-1.00000000000000))*(r21)*(x2702)*(x2712)))+(((IkReal(-1.00000000000000))*(r21)*(x2694)*(x2698)*(x2703)))+(((r20)*(x2697)*(x2710)))+(((r22)*(x2700)*(x2709)))+(((IkReal(-1.00000000000000))*(r21)*(x2695)*(x2702)))+(((r11)*(x2699)*(x2712)))));
IkReal x2713=(cj6)*(cj6);
IkReal x2714=(cj5)*(cj5);
IkReal x2715=(sj6)*(sj6);
IkReal x2716=(sj5)*(sj5);
IkReal x2717=((cj0)*(r12));
IkReal x2718=((cj6)*(sj6));
IkReal x2719=((cj0)*(r21));
IkReal x2720=((cj0)*(r11));
IkReal x2721=((IkReal(1.00000000000000))*(r20));
IkReal x2722=((r01)*(sj0));
IkReal x2723=((r00)*(sj0));
IkReal x2724=((IkReal(1.00000000000000))*(r22));
IkReal x2725=((cj0)*(r10));
IkReal x2726=((r02)*(sj0));
IkReal x2727=((r22)*(x2716));
IkReal x2728=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x2729=((cj5)*(cj6)*(sj5));
IkReal x2730=((cj5)*(sj5)*(sj6));
IkReal x2731=((cj0)*(r20)*(x2714));
IkReal x2732=((x2713)*(x2714));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2714)*(x2715)*(x2721)*(x2723)))+(((r22)*(x2725)*(x2730)))+(((IkReal(-1.00000000000000))*(x2714)*(x2718)*(x2721)*(x2722)))+(((IkReal(-1.00000000000000))*(r21)*(x2715)*(x2722)))+(((r11)*(x2715)*(x2719)))+(((x2717)*(x2727)))+(((IkReal(-1.00000000000000))*(x2723)*(x2724)*(x2730)))+(((IkReal(-1.00000000000000))*(x2722)*(x2724)*(x2729)))+(((r21)*(x2717)*(x2729)))+(((IkReal(-1.00000000000000))*(r10)*(x2718)*(x2719)))+(((r11)*(x2719)*(x2732)))+(((r21)*(x2718)*(x2723)))+(((IkReal(-1.00000000000000))*(x2713)*(x2721)*(x2723)))+(((IkReal(-1.00000000000000))*(x2716)*(x2724)*(x2726)))+(((r20)*(x2714)*(x2715)*(x2725)))+(((r10)*(x2714)*(x2718)*(x2719)))+(((r20)*(x2713)*(x2725)))+(((IkReal(-1.00000000000000))*(x2718)*(x2720)*(x2721)))+(((r20)*(x2718)*(x2722)))+(((IkReal(-1.00000000000000))*(r21)*(x2714)*(x2718)*(x2723)))+(((IkReal(-1.00000000000000))*(r21)*(x2726)*(x2729)))+(((IkReal(-1.00000000000000))*(x2721)*(x2726)*(x2730)))+(((r20)*(x2714)*(x2718)*(x2720)))+(((r20)*(x2717)*(x2730)))+(((r22)*(x2720)*(x2729)))+(((IkReal(-1.00000000000000))*(r21)*(x2722)*(x2732))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2733=((IkReal(1.00000000000000))*(cj3));
IkReal x2734=((cj5)*(x2733));
if( IKabs(((gconst76)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x2733)))+(((cj3)*(r21)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst76)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2734)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2733)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2734))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst76)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x2733)))+(((cj3)*(r21)*(sj6)))))), ((gconst76)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2734)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2733)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2734)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2735=IKsin(j4);
IkReal x2736=IKcos(j4);
IkReal x2737=((r22)*(sj5));
IkReal x2738=((IkReal(1.00000000000000))*(cj6));
IkReal x2739=((IkReal(1.00000000000000))*(cj0));
IkReal x2740=((cj5)*(r11));
IkReal x2741=((cj5)*(cj6));
IkReal x2742=((r11)*(sj6));
IkReal x2743=((IkReal(1.00000000000000))*(sj6));
IkReal x2744=((cj6)*(r00));
IkReal x2745=((r12)*(sj5));
IkReal x2746=((r02)*(sj5));
IkReal x2747=((cj6)*(r10));
IkReal x2748=((cj5)*(sj6));
IkReal x2749=((cj5)*(r01));
IkReal x2750=((sj0)*(x2735));
IkReal x2751=((r00)*(x2748));
IkReal x2752=((cj0)*(x2735));
IkReal x2753=((sj0)*(x2736));
IkReal x2754=((r20)*(x2736));
IkReal x2755=((cj0)*(x2736));
IkReal x2756=((r21)*(x2735));
IkReal x2757=((r21)*(x2736));
IkReal x2758=((r20)*(x2735));
IkReal x2759=((x2736)*(x2745));
IkReal x2760=((r01)*(sj6)*(x2736));
IkReal x2761=((cj5)*(r10)*(x2743));
evalcond[0]=((((x2748)*(x2758)))+(((x2735)*(x2737)))+(((x2741)*(x2756)))+(((IkReal(-1.00000000000000))*(x2738)*(x2754)))+(((sj6)*(x2757))));
evalcond[1]=((((x2736)*(x2737)))+(((x2741)*(x2757)))+(((x2748)*(x2754)))+(((cj6)*(x2758)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x2743)*(x2756))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2736)*(x2739)*(x2742)))+(((IkReal(-1.00000000000000))*(r00)*(x2738)*(x2753)))+(((x2750)*(x2751)))+(((r01)*(x2741)*(x2750)))+(((IkReal(-1.00000000000000))*(r10)*(x2735)*(x2739)*(x2748)))+(((IkReal(-1.00000000000000))*(x2738)*(x2740)*(x2752)))+(((x2746)*(x2750)))+(((x2747)*(x2755)))+(((IkReal(-1.00000000000000))*(x2735)*(x2739)*(x2745)))+(((r01)*(sj6)*(x2753))));
evalcond[3]=((((x2751)*(x2753)))+(((IkReal(-1.00000000000000))*(x2738)*(x2740)*(x2755)))+(((IkReal(-1.00000000000000))*(x2739)*(x2759)))+(((IkReal(-1.00000000000000))*(r10)*(x2738)*(x2752)))+(((IkReal(-1.00000000000000))*(r10)*(x2736)*(x2739)*(x2748)))+(((x2744)*(x2750)))+(((x2746)*(x2753)))+(((r01)*(x2741)*(x2753)))+(((x2742)*(x2752)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(r01)*(x2743)*(x2750))));
evalcond[4]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x2739)*(x2760)))+(((IkReal(-1.00000000000000))*(x2745)*(x2750)))+(((IkReal(-1.00000000000000))*(x2735)*(x2739)*(x2746)))+(((IkReal(-1.00000000000000))*(x2742)*(x2753)))+(((IkReal(-1.00000000000000))*(x2735)*(x2739)*(x2751)))+(((IkReal(-1.00000000000000))*(x2738)*(x2740)*(x2750)))+(((IkReal(-1.00000000000000))*(x2750)*(x2761)))+(((IkReal(-1.00000000000000))*(x2738)*(x2749)*(x2752)))+(((x2744)*(x2755)))+(((x2747)*(x2753))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2736)*(x2739)*(x2751)))+(((r01)*(sj6)*(x2752)))+(((IkReal(-1.00000000000000))*(x2738)*(x2740)*(x2753)))+(((x2742)*(x2750)))+(((IkReal(-1.00000000000000))*(x2745)*(x2753)))+(((IkReal(-1.00000000000000))*(x2738)*(x2749)*(x2755)))+(((IkReal(-1.00000000000000))*(x2736)*(x2739)*(x2746)))+(((IkReal(-1.00000000000000))*(x2753)*(x2761)))+(((IkReal(-1.00000000000000))*(r00)*(x2738)*(x2752)))+(((IkReal(-1.00000000000000))*(r10)*(x2738)*(x2750))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2762=((r21)*(sj3));
IkReal x2763=((IkReal(1.00000000000000))*(r20)*(sj3));
if( IKabs(((gconst75)*(((((IkReal(-1.00000000000000))*(cj6)*(x2763)))+(((sj6)*(x2762))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst75)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x2762)))+(((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x2763)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst75)*(((((IkReal(-1.00000000000000))*(cj6)*(x2763)))+(((sj6)*(x2762)))))), ((gconst75)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x2762)))+(((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x2763)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2764=IKsin(j4);
IkReal x2765=IKcos(j4);
IkReal x2766=((r22)*(sj5));
IkReal x2767=((IkReal(1.00000000000000))*(cj6));
IkReal x2768=((IkReal(1.00000000000000))*(cj0));
IkReal x2769=((cj5)*(r11));
IkReal x2770=((cj5)*(cj6));
IkReal x2771=((r11)*(sj6));
IkReal x2772=((IkReal(1.00000000000000))*(sj6));
IkReal x2773=((cj6)*(r00));
IkReal x2774=((r12)*(sj5));
IkReal x2775=((r02)*(sj5));
IkReal x2776=((cj6)*(r10));
IkReal x2777=((cj5)*(sj6));
IkReal x2778=((cj5)*(r01));
IkReal x2779=((sj0)*(x2764));
IkReal x2780=((r00)*(x2777));
IkReal x2781=((cj0)*(x2764));
IkReal x2782=((sj0)*(x2765));
IkReal x2783=((r20)*(x2765));
IkReal x2784=((cj0)*(x2765));
IkReal x2785=((r21)*(x2764));
IkReal x2786=((r21)*(x2765));
IkReal x2787=((r20)*(x2764));
IkReal x2788=((x2765)*(x2774));
IkReal x2789=((r01)*(sj6)*(x2765));
IkReal x2790=((cj5)*(r10)*(x2772));
evalcond[0]=((((sj6)*(x2786)))+(((x2777)*(x2787)))+(((IkReal(-1.00000000000000))*(x2767)*(x2783)))+(((x2764)*(x2766)))+(((x2770)*(x2785))));
evalcond[1]=((((x2770)*(x2786)))+(((x2765)*(x2766)))+(((x2777)*(x2783)))+(((IkReal(-1.00000000000000))*(sj3)))+(((cj6)*(x2787)))+(((IkReal(-1.00000000000000))*(x2772)*(x2785))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2767)*(x2769)*(x2781)))+(((IkReal(-1.00000000000000))*(x2764)*(x2768)*(x2774)))+(((r01)*(sj6)*(x2782)))+(((IkReal(-1.00000000000000))*(x2765)*(x2768)*(x2771)))+(((IkReal(-1.00000000000000))*(r10)*(x2764)*(x2768)*(x2777)))+(((x2779)*(x2780)))+(((x2775)*(x2779)))+(((r01)*(x2770)*(x2779)))+(((x2776)*(x2784)))+(((IkReal(-1.00000000000000))*(r00)*(x2767)*(x2782))));
evalcond[3]=((((r01)*(x2770)*(x2782)))+(((x2773)*(x2779)))+(((IkReal(-1.00000000000000))*(x2767)*(x2769)*(x2784)))+(((IkReal(-1.00000000000000))*(r10)*(x2767)*(x2781)))+(((IkReal(-1.00000000000000))*(r10)*(x2765)*(x2768)*(x2777)))+(((x2780)*(x2782)))+(((IkReal(-1.00000000000000))*(cj3)))+(((x2775)*(x2782)))+(((IkReal(-1.00000000000000))*(r01)*(x2772)*(x2779)))+(((x2771)*(x2781)))+(((IkReal(-1.00000000000000))*(x2768)*(x2788))));
evalcond[4]=((IkReal(-1.00000000000000))+(((x2776)*(x2782)))+(((IkReal(-1.00000000000000))*(x2764)*(x2768)*(x2775)))+(((IkReal(-1.00000000000000))*(x2774)*(x2779)))+(((IkReal(-1.00000000000000))*(x2764)*(x2768)*(x2780)))+(((IkReal(-1.00000000000000))*(x2767)*(x2778)*(x2781)))+(((x2773)*(x2784)))+(((IkReal(-1.00000000000000))*(x2771)*(x2782)))+(((IkReal(-1.00000000000000))*(x2768)*(x2789)))+(((IkReal(-1.00000000000000))*(x2779)*(x2790)))+(((IkReal(-1.00000000000000))*(x2767)*(x2769)*(x2779))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2767)*(x2778)*(x2784)))+(((r01)*(sj6)*(x2781)))+(((IkReal(-1.00000000000000))*(r10)*(x2767)*(x2779)))+(((IkReal(-1.00000000000000))*(x2765)*(x2768)*(x2780)))+(((IkReal(-1.00000000000000))*(x2767)*(x2769)*(x2782)))+(((IkReal(-1.00000000000000))*(x2774)*(x2782)))+(((x2771)*(x2779)))+(((IkReal(-1.00000000000000))*(x2782)*(x2790)))+(((IkReal(-1.00000000000000))*(r00)*(x2767)*(x2781)))+(((IkReal(-1.00000000000000))*(x2765)*(x2768)*(x2775))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2791=((sj5)*(sj6));
IkReal x2792=((IkReal(1.00000000000000))*(cj5));
IkReal x2793=((cj6)*(sj5));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj0)*(r00)*(x2791)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2792)))+(((r11)*(sj0)*(x2793)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2792)))+(((r10)*(sj0)*(x2791)))+(((cj0)*(r01)*(x2793))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r22)*(x2792)))+(((r21)*(x2793)))+(((r20)*(x2791))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj0)*(r00)*(x2791)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2792)))+(((r11)*(sj0)*(x2793)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2792)))+(((r10)*(sj0)*(x2791)))+(((cj0)*(r01)*(x2793)))))))+IKsqr(((((IkReal(-1.00000000000000))*(r22)*(x2792)))+(((r21)*(x2793)))+(((r20)*(x2791)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((cj0)*(r00)*(x2791)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x2792)))+(((r11)*(sj0)*(x2793)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x2792)))+(((r10)*(sj0)*(x2791)))+(((cj0)*(r01)*(x2793)))))), ((((IkReal(-1.00000000000000))*(r22)*(x2792)))+(((r21)*(x2793)))+(((r20)*(x2791)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x2794=IKsin(j3);
IkReal x2795=((sj5)*(sj6));
IkReal x2796=((cj0)*(cj5));
IkReal x2797=((IkReal(1.00000000000000))*(cj0));
IkReal x2798=((IkReal(1.00000000000000))*(sj0));
IkReal x2799=((cj6)*(r01)*(sj5));
IkReal x2800=((cj6)*(r11)*(sj5));
evalcond[0]=((((cj6)*(r21)*(sj5)))+(((r20)*(x2795)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r10)*(x2795)*(x2797)))+(((sj0)*(x2799)))+(((r12)*(x2796)))+(((IkReal(-1.00000000000000))*(x2797)*(x2800)))+(((r00)*(sj0)*(x2795)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(x2798)))+(((IkReal(-1.00000000000000))*(sj2)*(x2794))));
evalcond[2]=((((cj2)*(x2794)))+(((IkReal(-1.00000000000000))*(x2797)*(x2799)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r00)*(x2795)*(x2797)))+(((IkReal(-1.00000000000000))*(x2798)*(x2800)))+(((IkReal(-1.00000000000000))*(r10)*(x2795)*(x2798)))+(((r02)*(x2796))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst67;
IkReal x2801=(r21)*(r21);
IkReal x2802=(cj5)*(cj5);
IkReal x2803=(sj6)*(sj6);
IkReal x2804=(cj6)*(cj6);
IkReal x2805=(r20)*(r20);
IkReal x2806=((cj6)*(r21));
IkReal x2807=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x2808=((cj5)*(r22)*(sj5));
IkReal x2809=((IkReal(1.00000000000000))*(x2803));
IkReal x2810=((IkReal(1.00000000000000))*(x2804));
gconst67=IKsign(((((IkReal(-1.00000000000000))*(x2807)*(x2808)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x2802)*(x2805)*(x2809)))+(((IkReal(-1.00000000000000))*(x2805)*(x2810)))+(((IkReal(-1.00000000000000))*(x2801)*(x2809)))+(((IkReal(-1.00000000000000))*(x2802)*(x2806)*(x2807)))+(((x2806)*(x2807)))+(((IkReal(-2.00000000000000))*(x2806)*(x2808)))+(((IkReal(-1.00000000000000))*(x2801)*(x2802)*(x2810)))));
IkReal x2811=(r21)*(r21);
IkReal x2812=(cj5)*(cj5);
IkReal x2813=(sj6)*(sj6);
IkReal x2814=(cj6)*(cj6);
IkReal x2815=(r20)*(r20);
IkReal x2816=((cj6)*(r21));
IkReal x2817=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x2818=((cj5)*(r22)*(sj5));
IkReal x2819=((IkReal(1.00000000000000))*(x2813));
IkReal x2820=((IkReal(1.00000000000000))*(x2814));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2817)*(x2818)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x2811)*(x2819)))+(((IkReal(-1.00000000000000))*(x2815)*(x2820)))+(((IkReal(-1.00000000000000))*(x2812)*(x2816)*(x2817)))+(((IkReal(-1.00000000000000))*(x2812)*(x2815)*(x2819)))+(((x2816)*(x2817)))+(((IkReal(-1.00000000000000))*(x2811)*(x2812)*(x2820)))+(((IkReal(-2.00000000000000))*(x2816)*(x2818))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst68;
IkReal x2821=(cj6)*(cj6);
IkReal x2822=(sj6)*(sj6);
IkReal x2823=((IkReal(1.00000000000000))*(r21));
IkReal x2824=((cj6)*(r20));
IkReal x2825=((r22)*(sj5));
IkReal x2826=((r01)*(sj0));
IkReal x2827=((r00)*(sj0));
IkReal x2828=((cj0)*(r10));
IkReal x2829=((r02)*(sj0)*(sj5));
IkReal x2830=((cj5)*(x2821));
IkReal x2831=((cj0)*(r12)*(sj5));
IkReal x2832=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x2833=((cj5)*(x2822));
IkReal x2834=((r20)*(x2833));
gconst68=IKsign(((((cj6)*(x2825)*(x2828)))+(((IkReal(-1.00000000000000))*(x2823)*(x2827)*(x2833)))+(((IkReal(-1.00000000000000))*(sj6)*(x2823)*(x2829)))+(((IkReal(-1.00000000000000))*(sj6)*(x2825)*(x2832)))+(((IkReal(-1.00000000000000))*(x2832)*(x2834)))+(((IkReal(-1.00000000000000))*(cj6)*(x2825)*(x2827)))+(((x2826)*(x2834)))+(((r20)*(x2826)*(x2830)))+(((IkReal(-1.00000000000000))*(x2824)*(x2831)))+(((x2824)*(x2829)))+(((r21)*(x2828)*(x2833)))+(((IkReal(-1.00000000000000))*(x2823)*(x2827)*(x2830)))+(((sj6)*(x2825)*(x2826)))+(((r21)*(sj6)*(x2831)))+(((r21)*(x2828)*(x2830)))+(((IkReal(-1.00000000000000))*(r20)*(x2830)*(x2832)))));
IkReal x2835=(cj6)*(cj6);
IkReal x2836=(sj6)*(sj6);
IkReal x2837=((IkReal(1.00000000000000))*(r21));
IkReal x2838=((cj6)*(r20));
IkReal x2839=((r22)*(sj5));
IkReal x2840=((r01)*(sj0));
IkReal x2841=((r00)*(sj0));
IkReal x2842=((cj0)*(r10));
IkReal x2843=((r02)*(sj0)*(sj5));
IkReal x2844=((cj5)*(x2835));
IkReal x2845=((cj0)*(r12)*(sj5));
IkReal x2846=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x2847=((cj5)*(x2836));
IkReal x2848=((r20)*(x2847));
dummyeval[0]=((((x2838)*(x2843)))+(((IkReal(-1.00000000000000))*(sj6)*(x2839)*(x2846)))+(((r21)*(x2842)*(x2847)))+(((cj6)*(x2839)*(x2842)))+(((IkReal(-1.00000000000000))*(cj6)*(x2839)*(x2841)))+(((r21)*(x2842)*(x2844)))+(((IkReal(-1.00000000000000))*(x2837)*(x2841)*(x2844)))+(((r20)*(x2840)*(x2844)))+(((sj6)*(x2839)*(x2840)))+(((x2840)*(x2848)))+(((IkReal(-1.00000000000000))*(x2838)*(x2845)))+(((IkReal(-1.00000000000000))*(sj6)*(x2837)*(x2843)))+(((r21)*(sj6)*(x2845)))+(((IkReal(-1.00000000000000))*(x2846)*(x2848)))+(((IkReal(-1.00000000000000))*(r20)*(x2844)*(x2846)))+(((IkReal(-1.00000000000000))*(x2837)*(x2841)*(x2847))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2849=((cj2)*(sj6));
IkReal x2850=((IkReal(1.00000000000000))*(r20));
IkReal x2851=((cj2)*(cj6));
if( IKabs(((gconst68)*(((((r21)*(x2849)))+(((IkReal(-1.00000000000000))*(x2850)*(x2851))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst68)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x2851)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x2849)*(x2850))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst68)*(((((r21)*(x2849)))+(((IkReal(-1.00000000000000))*(x2850)*(x2851)))))), ((gconst68)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x2851)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x2849)*(x2850)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2852=IKsin(j4);
IkReal x2853=IKcos(j4);
IkReal x2854=((r00)*(sj6));
IkReal x2855=((IkReal(1.00000000000000))*(r12));
IkReal x2856=((IkReal(1.00000000000000))*(cj6));
IkReal x2857=((cj6)*(r01));
IkReal x2858=((r11)*(sj6));
IkReal x2859=((r01)*(sj6));
IkReal x2860=((IkReal(1.00000000000000))*(cj5));
IkReal x2861=((r10)*(sj6));
IkReal x2862=((cj5)*(r11));
IkReal x2863=((cj6)*(r00));
IkReal x2864=((r21)*(sj6));
IkReal x2865=((r02)*(sj5));
IkReal x2866=((cj6)*(r10));
IkReal x2867=((cj5)*(sj6));
IkReal x2868=((cj5)*(r01));
IkReal x2869=((sj5)*(x2852));
IkReal x2870=((cj0)*(x2853));
IkReal x2871=((cj0)*(x2852));
IkReal x2872=((sj0)*(x2853));
IkReal x2873=((sj0)*(x2852));
IkReal x2874=((r20)*(x2853));
IkReal x2875=((cj5)*(cj6)*(r21));
IkReal x2876=((r20)*(x2852));
IkReal x2877=((cj5)*(x2873));
evalcond[0]=((((r22)*(x2869)))+(((x2852)*(x2875)))+(((IkReal(-1.00000000000000))*(x2856)*(x2874)))+(((x2853)*(x2864)))+(((x2867)*(x2876))));
evalcond[1]=((((cj6)*(x2876)))+(((IkReal(-1.00000000000000))*(x2852)*(x2864)))+(((x2867)*(x2874)))+(((IkReal(-1.00000000000000))*(sj3)))+(((r22)*(sj5)*(x2853)))+(((x2853)*(x2875))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x2856)*(x2872)))+(((IkReal(-1.00000000000000))*(cj0)*(x2855)*(x2869)))+(((IkReal(-1.00000000000000))*(x2858)*(x2870)))+(((x2857)*(x2877)))+(((x2865)*(x2873)))+(((IkReal(-1.00000000000000))*(x2856)*(x2862)*(x2871)))+(cj2)+(((x2859)*(x2872)))+(((x2854)*(x2877)))+(((IkReal(-1.00000000000000))*(x2860)*(x2861)*(x2871)))+(((x2866)*(x2870))));
evalcond[3]=((((x2865)*(x2872)))+(((x2858)*(x2871)))+(((IkReal(-1.00000000000000))*(x2856)*(x2862)*(x2870)))+(((cj5)*(x2857)*(x2872)))+(((x2863)*(x2873)))+(((IkReal(-1.00000000000000))*(x2859)*(x2873)))+(((cj3)*(sj2)))+(((cj5)*(x2854)*(x2872)))+(((IkReal(-1.00000000000000))*(r10)*(x2856)*(x2871)))+(((IkReal(-1.00000000000000))*(sj5)*(x2855)*(x2870)))+(((IkReal(-1.00000000000000))*(x2860)*(x2861)*(x2870))));
evalcond[4]=((((x2866)*(x2872)))+(((IkReal(-1.00000000000000))*(x2856)*(x2868)*(x2871)))+(sj2)+(((IkReal(-1.00000000000000))*(x2859)*(x2870)))+(((IkReal(-1.00000000000000))*(x2860)*(x2861)*(x2873)))+(((IkReal(-1.00000000000000))*(x2854)*(x2860)*(x2871)))+(((IkReal(-1.00000000000000))*(x2856)*(x2862)*(x2873)))+(((IkReal(-1.00000000000000))*(x2858)*(x2872)))+(((x2863)*(x2870)))+(((IkReal(-1.00000000000000))*(sj0)*(x2855)*(x2869)))+(((IkReal(-1.00000000000000))*(x2865)*(x2871))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x2856)*(x2873)))+(((IkReal(-1.00000000000000))*(r00)*(x2856)*(x2871)))+(((IkReal(-1.00000000000000))*(x2860)*(x2861)*(x2872)))+(((IkReal(-1.00000000000000))*(sj5)*(x2855)*(x2872)))+(((IkReal(-1.00000000000000))*(x2856)*(x2868)*(x2870)))+(((x2859)*(x2871)))+(((IkReal(-1.00000000000000))*(x2865)*(x2870)))+(((x2858)*(x2873)))+(((IkReal(-1.00000000000000))*(x2854)*(x2860)*(x2870)))+(((IkReal(-1.00000000000000))*(x2856)*(x2862)*(x2872)))+(((IkReal(-1.00000000000000))*(cj2)*(cj3))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2878=((r21)*(sj3));
IkReal x2879=((IkReal(1.00000000000000))*(r20)*(sj3));
if( IKabs(((gconst67)*(((((IkReal(-1.00000000000000))*(cj6)*(x2879)))+(((sj6)*(x2878))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst67)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x2878)))+(((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x2879)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst67)*(((((IkReal(-1.00000000000000))*(cj6)*(x2879)))+(((sj6)*(x2878)))))), ((gconst67)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x2878)))+(((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x2879)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2880=IKsin(j4);
IkReal x2881=IKcos(j4);
IkReal x2882=((r00)*(sj6));
IkReal x2883=((IkReal(1.00000000000000))*(r12));
IkReal x2884=((IkReal(1.00000000000000))*(cj6));
IkReal x2885=((cj6)*(r01));
IkReal x2886=((r11)*(sj6));
IkReal x2887=((r01)*(sj6));
IkReal x2888=((IkReal(1.00000000000000))*(cj5));
IkReal x2889=((r10)*(sj6));
IkReal x2890=((cj5)*(r11));
IkReal x2891=((cj6)*(r00));
IkReal x2892=((r21)*(sj6));
IkReal x2893=((r02)*(sj5));
IkReal x2894=((cj6)*(r10));
IkReal x2895=((cj5)*(sj6));
IkReal x2896=((cj5)*(r01));
IkReal x2897=((sj5)*(x2880));
IkReal x2898=((cj0)*(x2881));
IkReal x2899=((cj0)*(x2880));
IkReal x2900=((sj0)*(x2881));
IkReal x2901=((sj0)*(x2880));
IkReal x2902=((r20)*(x2881));
IkReal x2903=((cj5)*(cj6)*(r21));
IkReal x2904=((r20)*(x2880));
IkReal x2905=((cj5)*(x2901));
evalcond[0]=((((IkReal(-1.00000000000000))*(x2884)*(x2902)))+(((r22)*(x2897)))+(((x2895)*(x2904)))+(((x2880)*(x2903)))+(((x2881)*(x2892))));
evalcond[1]=((((x2881)*(x2903)))+(((x2895)*(x2902)))+(((cj6)*(x2904)))+(((r22)*(sj5)*(x2881)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x2880)*(x2892))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2886)*(x2898)))+(((IkReal(-1.00000000000000))*(r00)*(x2884)*(x2900)))+(((x2894)*(x2898)))+(((x2885)*(x2905)))+(((IkReal(-1.00000000000000))*(x2888)*(x2889)*(x2899)))+(((IkReal(-1.00000000000000))*(x2884)*(x2890)*(x2899)))+(((x2893)*(x2901)))+(cj2)+(((IkReal(-1.00000000000000))*(cj0)*(x2883)*(x2897)))+(((x2882)*(x2905)))+(((x2887)*(x2900))));
evalcond[3]=((((x2893)*(x2900)))+(((cj5)*(x2885)*(x2900)))+(((IkReal(-1.00000000000000))*(x2888)*(x2889)*(x2898)))+(((cj5)*(x2882)*(x2900)))+(((IkReal(-1.00000000000000))*(x2887)*(x2901)))+(((IkReal(-1.00000000000000))*(sj5)*(x2883)*(x2898)))+(((IkReal(-1.00000000000000))*(x2884)*(x2890)*(x2898)))+(((x2886)*(x2899)))+(((cj3)*(sj2)))+(((IkReal(-1.00000000000000))*(r10)*(x2884)*(x2899)))+(((x2891)*(x2901))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x2886)*(x2900)))+(((IkReal(-1.00000000000000))*(sj0)*(x2883)*(x2897)))+(((IkReal(-1.00000000000000))*(x2882)*(x2888)*(x2899)))+(sj2)+(((IkReal(-1.00000000000000))*(x2888)*(x2889)*(x2901)))+(((IkReal(-1.00000000000000))*(x2893)*(x2899)))+(((IkReal(-1.00000000000000))*(x2887)*(x2898)))+(((IkReal(-1.00000000000000))*(x2884)*(x2896)*(x2899)))+(((x2891)*(x2898)))+(((x2894)*(x2900)))+(((IkReal(-1.00000000000000))*(x2884)*(x2890)*(x2901))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x2884)*(x2901)))+(((IkReal(-1.00000000000000))*(sj5)*(x2883)*(x2900)))+(((IkReal(-1.00000000000000))*(x2884)*(x2890)*(x2900)))+(((IkReal(-1.00000000000000))*(x2888)*(x2889)*(x2900)))+(((IkReal(-1.00000000000000))*(x2884)*(x2896)*(x2898)))+(((IkReal(-1.00000000000000))*(r00)*(x2884)*(x2899)))+(((x2887)*(x2899)))+(((IkReal(-1.00000000000000))*(x2882)*(x2888)*(x2898)))+(((x2886)*(x2901)))+(((IkReal(-1.00000000000000))*(x2893)*(x2898)))+(((IkReal(-1.00000000000000))*(cj2)*(cj3))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2906=((IkReal(1.00000000000000))*(sj2));
if( IKabs(((gconst66)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x2906)))+(((r21)*(sj2)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst66)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2906)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r21)*(x2906)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(sj6)*(x2906))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst66)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x2906)))+(((r21)*(sj2)*(sj6)))))), ((gconst66)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2906)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r21)*(x2906)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(sj6)*(x2906)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x2907=IKsin(j4);
IkReal x2908=IKcos(j4);
IkReal x2909=((r00)*(sj6));
IkReal x2910=((cj6)*(r01));
IkReal x2911=((IkReal(1.00000000000000))*(cj0));
IkReal x2912=((IkReal(1.00000000000000))*(sj0));
IkReal x2913=((r10)*(sj6));
IkReal x2914=((sj5)*(x2907));
IkReal x2915=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x2916=((cj5)*(x2907));
IkReal x2917=((cj6)*(x2908));
IkReal x2918=((sj0)*(x2916));
IkReal x2919=((r01)*(sj6)*(x2908));
IkReal x2920=((r11)*(sj6)*(x2908));
evalcond[0]=((((cj6)*(r21)*(x2916)))+(((IkReal(-1.00000000000000))*(r20)*(x2917)))+(((r22)*(x2914)))+(((r21)*(sj6)*(x2908)))+(((r20)*(sj6)*(x2916))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2911)*(x2913)*(x2916)))+(((IkReal(-1.00000000000000))*(x2911)*(x2920)))+(((cj0)*(r10)*(x2917)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2911)*(x2916)))+(((IkReal(-1.00000000000000))*(r00)*(x2912)*(x2917)))+(((x2910)*(x2918)))+(cj2)+(((IkReal(-1.00000000000000))*(r12)*(x2911)*(x2914)))+(((r02)*(sj0)*(x2914)))+(((sj0)*(x2919)))+(((x2909)*(x2918))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2909)*(x2911)*(x2916)))+(((IkReal(-1.00000000000000))*(x2912)*(x2920)))+(((cj0)*(r00)*(x2917)))+(sj2)+(((IkReal(-1.00000000000000))*(x2910)*(x2911)*(x2916)))+(((IkReal(-1.00000000000000))*(r02)*(x2911)*(x2914)))+(((IkReal(-1.00000000000000))*(x2912)*(x2913)*(x2916)))+(((IkReal(-1.00000000000000))*(x2911)*(x2919)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2912)*(x2916)))+(((IkReal(-1.00000000000000))*(r12)*(x2912)*(x2914)))+(((r10)*(sj0)*(x2917))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2921=((r20)*(sj6));
IkReal x2922=((cj4)*(cj5));
IkReal x2923=((cj6)*(r21));
if( IKabs(((((x2922)*(x2923)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x2921)*(x2922))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x2923)))+(((sj5)*(x2921)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((x2922)*(x2923)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x2921)*(x2922)))))+IKsqr(((((sj5)*(x2923)))+(((sj5)*(x2921)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((x2922)*(x2923)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x2921)*(x2922)))), ((((sj5)*(x2923)))+(((sj5)*(x2921)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2924=IKsin(j3);
IkReal x2925=IKcos(j3);
IkReal x2926=((sj0)*(sj5));
IkReal x2927=((r00)*(sj6));
IkReal x2928=((cj6)*(r01));
IkReal x2929=((cj4)*(cj5));
IkReal x2930=((IkReal(1.00000000000000))*(cj0));
IkReal x2931=((cj5)*(r12));
IkReal x2932=((IkReal(1.00000000000000))*(sj0));
IkReal x2933=((cj6)*(r11));
IkReal x2934=((cj6)*(sj4));
IkReal x2935=((cj5)*(r02));
IkReal x2936=((cj6)*(r21));
IkReal x2937=((r20)*(sj6));
IkReal x2938=((r10)*(sj6));
IkReal x2939=((sj4)*(sj6));
IkReal x2940=((cj4)*(r02));
IkReal x2941=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x2942=((cj0)*(x2939));
IkReal x2943=((IkReal(1.00000000000000))*(x2924));
IkReal x2944=((IkReal(1.00000000000000))*(x2925));
evalcond[0]=((((sj5)*(x2937)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2944)))+(((sj5)*(x2936))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(x2939)))+(((x2929)*(x2936)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x2943)))+(((r20)*(x2934)))+(((x2929)*(x2937))));
evalcond[2]=((((x2926)*(x2927)))+(((cj0)*(x2931)))+(((IkReal(-1.00000000000000))*(sj5)*(x2930)*(x2938)))+(((IkReal(-1.00000000000000))*(x2932)*(x2935)))+(((IkReal(-1.00000000000000))*(sj5)*(x2930)*(x2933)))+(((x2926)*(x2928)))+(((IkReal(-1.00000000000000))*(sj2)*(x2943))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x2926)*(x2938)))+(((cj2)*(x2924)))+(((IkReal(-1.00000000000000))*(sj5)*(x2928)*(x2930)))+(((IkReal(-1.00000000000000))*(x2926)*(x2933)))+(((cj0)*(x2935)))+(((sj0)*(x2931)))+(((IkReal(-1.00000000000000))*(sj5)*(x2927)*(x2930))));
evalcond[4]=((((x2926)*(x2940)))+(((IkReal(-1.00000000000000))*(r01)*(x2932)*(x2939)))+(((r11)*(x2942)))+(((sj0)*(x2928)*(x2929)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x2930)))+(((r00)*(sj0)*(x2934)))+(((sj0)*(x2927)*(x2929)))+(((IkReal(-1.00000000000000))*(x2929)*(x2930)*(x2933)))+(((IkReal(-1.00000000000000))*(r10)*(x2930)*(x2934)))+(((IkReal(-1.00000000000000))*(x2929)*(x2930)*(x2938)))+(((sj2)*(x2925))));
evalcond[5]=((((r11)*(sj0)*(x2939)))+(((IkReal(-1.00000000000000))*(x2927)*(x2929)*(x2930)))+(((r01)*(x2942)))+(((IkReal(-1.00000000000000))*(r10)*(x2932)*(x2934)))+(((IkReal(-1.00000000000000))*(x2926)*(x2941)))+(((IkReal(-1.00000000000000))*(r00)*(x2930)*(x2934)))+(((IkReal(-1.00000000000000))*(sj5)*(x2930)*(x2940)))+(((IkReal(-1.00000000000000))*(x2929)*(x2932)*(x2933)))+(((IkReal(-1.00000000000000))*(x2928)*(x2929)*(x2930)))+(((IkReal(-1.00000000000000))*(cj2)*(x2944)))+(((IkReal(-1.00000000000000))*(x2929)*(x2932)*(x2938))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2945=((cj2)*(sj6));
IkReal x2946=((IkReal(1.00000000000000))*(r20));
IkReal x2947=((cj2)*(cj6));
if( IKabs(((gconst65)*(((((IkReal(-1.00000000000000))*(x2946)*(x2947)))+(((r21)*(x2945))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst65)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x2947)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x2945)*(x2946))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst65)*(((((IkReal(-1.00000000000000))*(x2946)*(x2947)))+(((r21)*(x2945)))))), ((gconst65)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x2947)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x2945)*(x2946)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x2948=IKsin(j4);
IkReal x2949=IKcos(j4);
IkReal x2950=((r00)*(sj6));
IkReal x2951=((cj6)*(r01));
IkReal x2952=((IkReal(1.00000000000000))*(cj0));
IkReal x2953=((IkReal(1.00000000000000))*(sj0));
IkReal x2954=((r10)*(sj6));
IkReal x2955=((sj5)*(x2948));
IkReal x2956=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x2957=((cj5)*(x2948));
IkReal x2958=((cj6)*(x2949));
IkReal x2959=((sj0)*(x2957));
IkReal x2960=((r01)*(sj6)*(x2949));
IkReal x2961=((r11)*(sj6)*(x2949));
evalcond[0]=((((r20)*(sj6)*(x2957)))+(((cj6)*(r21)*(x2957)))+(((r22)*(x2955)))+(((IkReal(-1.00000000000000))*(r20)*(x2958)))+(((r21)*(sj6)*(x2949))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2952)*(x2954)*(x2957)))+(((IkReal(-1.00000000000000))*(r12)*(x2952)*(x2955)))+(((IkReal(-1.00000000000000))*(r00)*(x2953)*(x2958)))+(((x2950)*(x2959)))+(((x2951)*(x2959)))+(cj2)+(((sj0)*(x2960)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2952)*(x2957)))+(((IkReal(-1.00000000000000))*(x2952)*(x2961)))+(((cj0)*(r10)*(x2958)))+(((r02)*(sj0)*(x2955))));
evalcond[2]=((sj2)+(((IkReal(-1.00000000000000))*(x2950)*(x2952)*(x2957)))+(((IkReal(-1.00000000000000))*(x2951)*(x2952)*(x2957)))+(((cj0)*(r00)*(x2958)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2953)*(x2957)))+(((IkReal(-1.00000000000000))*(r12)*(x2953)*(x2955)))+(((IkReal(-1.00000000000000))*(x2953)*(x2961)))+(((r10)*(sj0)*(x2958)))+(((IkReal(-1.00000000000000))*(x2952)*(x2960)))+(((IkReal(-1.00000000000000))*(x2953)*(x2954)*(x2957)))+(((IkReal(-1.00000000000000))*(r02)*(x2952)*(x2955))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2962=((r20)*(sj6));
IkReal x2963=((cj4)*(cj5));
IkReal x2964=((cj6)*(r21));
if( IKabs(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x2962)*(x2963)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x2963)*(x2964))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x2962)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x2964))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x2962)*(x2963)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x2963)*(x2964)))))+IKsqr(((((sj5)*(x2962)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x2964)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x2962)*(x2963)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x2963)*(x2964)))), ((((sj5)*(x2962)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x2964)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2965=IKsin(j3);
IkReal x2966=IKcos(j3);
IkReal x2967=((sj0)*(sj5));
IkReal x2968=((r00)*(sj6));
IkReal x2969=((cj6)*(r01));
IkReal x2970=((cj4)*(cj5));
IkReal x2971=((IkReal(1.00000000000000))*(cj0));
IkReal x2972=((cj5)*(r12));
IkReal x2973=((IkReal(1.00000000000000))*(sj0));
IkReal x2974=((cj6)*(r11));
IkReal x2975=((cj6)*(sj4));
IkReal x2976=((cj5)*(r02));
IkReal x2977=((cj6)*(r21));
IkReal x2978=((r20)*(sj6));
IkReal x2979=((r10)*(sj6));
IkReal x2980=((sj4)*(sj6));
IkReal x2981=((cj4)*(r02));
IkReal x2982=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x2983=((cj0)*(x2980));
IkReal x2984=((IkReal(1.00000000000000))*(x2965));
IkReal x2985=((IkReal(1.00000000000000))*(x2966));
evalcond[0]=((((sj5)*(x2978)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2985)))+(((sj5)*(x2977))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2984)))+(((cj4)*(r22)*(sj5)))+(((x2970)*(x2977)))+(((IkReal(-1.00000000000000))*(r21)*(x2980)))+(((r20)*(x2975)))+(((x2970)*(x2978))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj2)*(x2984)))+(((IkReal(-1.00000000000000))*(x2973)*(x2976)))+(((IkReal(-1.00000000000000))*(sj5)*(x2971)*(x2979)))+(((cj0)*(x2972)))+(((x2967)*(x2968)))+(((x2967)*(x2969)))+(((IkReal(-1.00000000000000))*(sj5)*(x2971)*(x2974))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x2968)*(x2971)))+(((IkReal(-1.00000000000000))*(x2967)*(x2974)))+(((IkReal(-1.00000000000000))*(sj5)*(x2969)*(x2971)))+(((sj0)*(x2972)))+(((cj0)*(x2976)))+(((IkReal(-1.00000000000000))*(x2967)*(x2979)))+(((cj2)*(x2965))));
evalcond[4]=((((sj0)*(x2969)*(x2970)))+(((IkReal(-1.00000000000000))*(r01)*(x2973)*(x2980)))+(((r11)*(x2983)))+(((IkReal(-1.00000000000000))*(r10)*(x2971)*(x2975)))+(((IkReal(-1.00000000000000))*(x2970)*(x2971)*(x2979)))+(((x2967)*(x2981)))+(((sj0)*(x2968)*(x2970)))+(((IkReal(-1.00000000000000))*(x2970)*(x2971)*(x2974)))+(((r00)*(sj0)*(x2975)))+(((sj2)*(x2966)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x2971))));
evalcond[5]=((((r01)*(x2983)))+(((IkReal(-1.00000000000000))*(sj5)*(x2971)*(x2981)))+(((IkReal(-1.00000000000000))*(r10)*(x2973)*(x2975)))+(((IkReal(-1.00000000000000))*(r00)*(x2971)*(x2975)))+(((IkReal(-1.00000000000000))*(x2967)*(x2982)))+(((IkReal(-1.00000000000000))*(x2970)*(x2973)*(x2979)))+(((IkReal(-1.00000000000000))*(x2969)*(x2970)*(x2971)))+(((r11)*(sj0)*(x2980)))+(((IkReal(-1.00000000000000))*(x2968)*(x2970)*(x2971)))+(((IkReal(-1.00000000000000))*(cj2)*(x2985)))+(((IkReal(-1.00000000000000))*(x2970)*(x2973)*(x2974))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}
}
}

} else
{
IkReal x2986=((r20)*(sj6));
IkReal x2987=((IkReal(0.0100000000000000))*(cj5));
IkReal x2988=((IkReal(0.374290000000000))*(sj5));
IkReal x2989=((cj6)*(r21));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(-0.364420000000000))+(((x2988)*(x2989)))+(((IkReal(-1.00000000000000))*(x2986)*(x2987)))+(((IkReal(-0.0100000000000000))*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x2987)*(x2989)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((x2986)*(x2988))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x2990=((r00)*(sj6));
IkReal x2991=((IkReal(14.4927536231884))*(cj0));
IkReal x2992=((cj6)*(r11));
IkReal x2993=((cj0)*(sj5));
IkReal x2994=((IkReal(0.144927536231884))*(r02));
IkReal x2995=((r10)*(sj6));
IkReal x2996=((cj5)*(sj0));
IkReal x2997=((IkReal(5.42449275362319))*(r12));
IkReal x2998=((IkReal(14.4927536231884))*(sj0));
IkReal x2999=((cj6)*(r01));
IkReal x3000=((sj0)*(sj5));
IkReal x3001=((IkReal(0.144927536231884))*(r12));
IkReal x3002=((IkReal(5.42449275362319))*(r02));
IkReal x3003=((cj0)*(cj5));
IkReal x3004=((IkReal(0.144927536231884))*(x3003));
IkReal x3005=((IkReal(5.42449275362319))*(sj5)*(x2999));
if( IKabs(((((IkReal(0.144927536231884))*(x2990)*(x2996)))+(((IkReal(5.42449275362319))*(x2993)*(x2995)))+(((IkReal(-1.00000000000000))*(px)*(x2998)))+(((IkReal(-1.00000000000000))*(x2997)*(x3003)))+(((x2996)*(x3002)))+(((IkReal(-5.42449275362319))*(x2999)*(x3000)))+(((py)*(x2991)))+(((IkReal(0.144927536231884))*(x2996)*(x2999)))+(((IkReal(5.42449275362319))*(x2992)*(x2993)))+(((IkReal(-1.00000000000000))*(x2993)*(x3001)))+(((IkReal(-1.00000000000000))*(x2995)*(x3004)))+(((x2994)*(x3000)))+(((IkReal(-1.00000000000000))*(x2992)*(x3004)))+(((IkReal(-5.42449275362319))*(x2990)*(x3000))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x2990)*(x3004)))+(((IkReal(5.42449275362319))*(x2993)*(x2999)))+(((IkReal(5.42449275362319))*(x2992)*(x3000)))+(((IkReal(-1.00000000000000))*(x3000)*(x3001)))+(((IkReal(5.42449275362319))*(x2990)*(x2993)))+(((IkReal(5.42449275362319))*(x2995)*(x3000)))+(((IkReal(-1.00000000000000))*(x2999)*(x3004)))+(((px)*(x2991)))+(((IkReal(-1.00000000000000))*(x3002)*(x3003)))+(((IkReal(-1.00000000000000))*(x2993)*(x2994)))+(((py)*(x2998)))+(((IkReal(-0.144927536231884))*(x2992)*(x2996)))+(((IkReal(-0.144927536231884))*(x2995)*(x2996)))+(((IkReal(-1.00000000000000))*(x2996)*(x2997))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(0.144927536231884))*(x2990)*(x2996)))+(((IkReal(5.42449275362319))*(x2993)*(x2995)))+(((IkReal(-1.00000000000000))*(px)*(x2998)))+(((IkReal(-1.00000000000000))*(x2997)*(x3003)))+(((x2996)*(x3002)))+(((IkReal(-5.42449275362319))*(x2999)*(x3000)))+(((py)*(x2991)))+(((IkReal(0.144927536231884))*(x2996)*(x2999)))+(((IkReal(5.42449275362319))*(x2992)*(x2993)))+(((IkReal(-1.00000000000000))*(x2993)*(x3001)))+(((IkReal(-1.00000000000000))*(x2995)*(x3004)))+(((x2994)*(x3000)))+(((IkReal(-1.00000000000000))*(x2992)*(x3004)))+(((IkReal(-5.42449275362319))*(x2990)*(x3000)))))+IKsqr(((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x2990)*(x3004)))+(((IkReal(5.42449275362319))*(x2993)*(x2999)))+(((IkReal(5.42449275362319))*(x2992)*(x3000)))+(((IkReal(-1.00000000000000))*(x3000)*(x3001)))+(((IkReal(5.42449275362319))*(x2990)*(x2993)))+(((IkReal(5.42449275362319))*(x2995)*(x3000)))+(((IkReal(-1.00000000000000))*(x2999)*(x3004)))+(((px)*(x2991)))+(((IkReal(-1.00000000000000))*(x3002)*(x3003)))+(((IkReal(-1.00000000000000))*(x2993)*(x2994)))+(((py)*(x2998)))+(((IkReal(-0.144927536231884))*(x2992)*(x2996)))+(((IkReal(-0.144927536231884))*(x2995)*(x2996)))+(((IkReal(-1.00000000000000))*(x2996)*(x2997)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((IkReal(0.144927536231884))*(x2990)*(x2996)))+(((IkReal(5.42449275362319))*(x2993)*(x2995)))+(((IkReal(-1.00000000000000))*(px)*(x2998)))+(((IkReal(-1.00000000000000))*(x2997)*(x3003)))+(((x2996)*(x3002)))+(((IkReal(-5.42449275362319))*(x2999)*(x3000)))+(((py)*(x2991)))+(((IkReal(0.144927536231884))*(x2996)*(x2999)))+(((IkReal(5.42449275362319))*(x2992)*(x2993)))+(((IkReal(-1.00000000000000))*(x2993)*(x3001)))+(((IkReal(-1.00000000000000))*(x2995)*(x3004)))+(((x2994)*(x3000)))+(((IkReal(-1.00000000000000))*(x2992)*(x3004)))+(((IkReal(-5.42449275362319))*(x2990)*(x3000)))), ((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x2990)*(x3004)))+(((IkReal(5.42449275362319))*(x2993)*(x2999)))+(((IkReal(5.42449275362319))*(x2992)*(x3000)))+(((IkReal(-1.00000000000000))*(x3000)*(x3001)))+(((IkReal(5.42449275362319))*(x2990)*(x2993)))+(((IkReal(5.42449275362319))*(x2995)*(x3000)))+(((IkReal(-1.00000000000000))*(x2999)*(x3004)))+(((px)*(x2991)))+(((IkReal(-1.00000000000000))*(x3002)*(x3003)))+(((IkReal(-1.00000000000000))*(x2993)*(x2994)))+(((py)*(x2998)))+(((IkReal(-0.144927536231884))*(x2992)*(x2996)))+(((IkReal(-0.144927536231884))*(x2995)*(x2996)))+(((IkReal(-1.00000000000000))*(x2996)*(x2997)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x3006=((IkReal(0.374290000000000))*(sj0));
IkReal x3007=((cj5)*(r02));
IkReal x3008=((IkReal(0.0100000000000000))*(cj0));
IkReal x3009=((cj5)*(cj6));
IkReal x3010=((r02)*(sj5));
IkReal x3011=((cj5)*(sj6));
IkReal x3012=((IkReal(1.00000000000000))*(py));
IkReal x3013=((cj6)*(sj5));
IkReal x3014=((IkReal(0.0100000000000000))*(sj0));
IkReal x3015=((sj5)*(sj6));
IkReal x3016=((cj5)*(r12));
IkReal x3017=((IkReal(0.374290000000000))*(cj0));
IkReal x3018=((r12)*(sj5));
IkReal x3019=((x3013)*(x3017));
IkReal x3020=((x3015)*(x3017));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(x3012)))+(((IkReal(-1.00000000000000))*(r10)*(x3020)))+(((IkReal(-1.00000000000000))*(x3006)*(x3007)))+(((r10)*(x3008)*(x3011)))+(((r00)*(x3006)*(x3015)))+(((IkReal(-1.00000000000000))*(r01)*(x3009)*(x3014)))+(((IkReal(-1.00000000000000))*(r11)*(x3019)))+(((IkReal(0.0690000000000000))*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(r00)*(x3011)*(x3014)))+(((x3016)*(x3017)))+(((x3008)*(x3018)))+(((r01)*(x3006)*(x3013)))+(((px)*(sj0)))+(((r11)*(x3008)*(x3009)))+(((IkReal(-1.00000000000000))*(x3010)*(x3014))));
evalcond[1]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x3006)*(x3015)))+(((r01)*(x3008)*(x3009)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-1.00000000000000))*(sj0)*(x3012)))+(((x3007)*(x3017)))+(((x3008)*(x3010)))+(((IkReal(-1.00000000000000))*(r00)*(x3020)))+(((IkReal(0.0690000000000000))*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(r11)*(x3006)*(x3013)))+(((r00)*(x3008)*(x3011)))+(((x3006)*(x3016)))+(((IkReal(-1.00000000000000))*(r01)*(x3019)))+(((r10)*(x3011)*(x3014)))+(((r11)*(x3009)*(x3014)))+(((x3014)*(x3018))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst77;
IkReal x3021=(cj6)*(cj6);
IkReal x3022=(sj6)*(sj6);
IkReal x3023=((IkReal(1.00000000000000))*(r21));
IkReal x3024=((cj6)*(r20));
IkReal x3025=((r22)*(sj5));
IkReal x3026=((r01)*(sj0));
IkReal x3027=((r00)*(sj0));
IkReal x3028=((cj0)*(r10));
IkReal x3029=((r02)*(sj0)*(sj5));
IkReal x3030=((cj5)*(x3021));
IkReal x3031=((cj0)*(r12)*(sj5));
IkReal x3032=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3033=((cj5)*(x3022));
IkReal x3034=((r20)*(x3033));
gconst77=IKsign(((((IkReal(-1.00000000000000))*(sj6)*(x3023)*(x3029)))+(((sj6)*(x3025)*(x3026)))+(((x3026)*(x3034)))+(((r20)*(x3026)*(x3030)))+(((r21)*(sj6)*(x3031)))+(((IkReal(-1.00000000000000))*(sj6)*(x3025)*(x3032)))+(((IkReal(-1.00000000000000))*(x3024)*(x3031)))+(((IkReal(-1.00000000000000))*(x3023)*(x3027)*(x3030)))+(((IkReal(-1.00000000000000))*(cj6)*(x3025)*(x3027)))+(((IkReal(-1.00000000000000))*(x3032)*(x3034)))+(((x3024)*(x3029)))+(((IkReal(-1.00000000000000))*(r20)*(x3030)*(x3032)))+(((r21)*(x3028)*(x3030)))+(((IkReal(-1.00000000000000))*(x3023)*(x3027)*(x3033)))+(((cj6)*(x3025)*(x3028)))+(((r21)*(x3028)*(x3033)))));
IkReal x3035=(cj6)*(cj6);
IkReal x3036=(sj6)*(sj6);
IkReal x3037=((IkReal(1.00000000000000))*(r21));
IkReal x3038=((cj6)*(r20));
IkReal x3039=((r22)*(sj5));
IkReal x3040=((r01)*(sj0));
IkReal x3041=((r00)*(sj0));
IkReal x3042=((cj0)*(r10));
IkReal x3043=((r02)*(sj0)*(sj5));
IkReal x3044=((cj5)*(x3035));
IkReal x3045=((cj0)*(r12)*(sj5));
IkReal x3046=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3047=((cj5)*(x3036));
IkReal x3048=((r20)*(x3047));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3046)*(x3048)))+(((IkReal(-1.00000000000000))*(x3037)*(x3041)*(x3047)))+(((r20)*(x3040)*(x3044)))+(((r21)*(x3042)*(x3044)))+(((x3040)*(x3048)))+(((cj6)*(x3039)*(x3042)))+(((IkReal(-1.00000000000000))*(sj6)*(x3039)*(x3046)))+(((r21)*(sj6)*(x3045)))+(((IkReal(-1.00000000000000))*(cj6)*(x3039)*(x3041)))+(((IkReal(-1.00000000000000))*(r20)*(x3044)*(x3046)))+(((r21)*(x3042)*(x3047)))+(((IkReal(-1.00000000000000))*(x3038)*(x3045)))+(((x3038)*(x3043)))+(((sj6)*(x3039)*(x3040)))+(((IkReal(-1.00000000000000))*(x3037)*(x3041)*(x3044)))+(((IkReal(-1.00000000000000))*(sj6)*(x3037)*(x3043))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst78;
IkReal x3049=(cj6)*(cj6);
IkReal x3050=(sj6)*(sj6);
IkReal x3051=((sj5)*(sj6));
IkReal x3052=((IkReal(1.00000000000000))*(cj0));
IkReal x3053=((cj6)*(sj5));
IkReal x3054=((r20)*(sj0));
IkReal x3055=((cj0)*(r20));
IkReal x3056=((r00)*(r21));
IkReal x3057=((r22)*(sj0));
IkReal x3058=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x3059=((cj5)*(x3050));
IkReal x3060=((cj5)*(x3049));
gconst78=IKsign(((((r12)*(x3053)*(x3054)))+(((r01)*(x3055)*(x3060)))+(((IkReal(-1.00000000000000))*(x3052)*(x3056)*(x3060)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x3052)*(x3053)))+(((IkReal(-1.00000000000000))*(x3052)*(x3056)*(x3059)))+(((IkReal(-1.00000000000000))*(r12)*(x3051)*(x3058)))+(((IkReal(-1.00000000000000))*(r10)*(x3058)*(x3060)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x3051)*(x3052)))+(((IkReal(-1.00000000000000))*(r10)*(x3053)*(x3057)))+(((r02)*(x3053)*(x3055)))+(((cj0)*(r01)*(r22)*(x3051)))+(((r11)*(x3054)*(x3059)))+(((IkReal(-1.00000000000000))*(r10)*(x3058)*(x3059)))+(((r11)*(x3051)*(x3057)))+(((r11)*(x3054)*(x3060)))+(((r01)*(x3055)*(x3059)))));
IkReal x3061=(cj6)*(cj6);
IkReal x3062=(sj6)*(sj6);
IkReal x3063=((sj5)*(sj6));
IkReal x3064=((IkReal(1.00000000000000))*(cj0));
IkReal x3065=((cj6)*(sj5));
IkReal x3066=((r20)*(sj0));
IkReal x3067=((cj0)*(r20));
IkReal x3068=((r00)*(r21));
IkReal x3069=((r22)*(sj0));
IkReal x3070=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x3071=((cj5)*(x3062));
IkReal x3072=((cj5)*(x3061));
dummyeval[0]=((((r12)*(x3065)*(x3066)))+(((IkReal(-1.00000000000000))*(r10)*(x3070)*(x3071)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x3064)*(x3065)))+(((r01)*(x3067)*(x3072)))+(((IkReal(-1.00000000000000))*(r12)*(x3063)*(x3070)))+(((cj0)*(r01)*(r22)*(x3063)))+(((r11)*(x3063)*(x3069)))+(((IkReal(-1.00000000000000))*(r10)*(x3070)*(x3072)))+(((r02)*(x3065)*(x3067)))+(((r01)*(x3067)*(x3071)))+(((r11)*(x3066)*(x3072)))+(((r11)*(x3066)*(x3071)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x3063)*(x3064)))+(((IkReal(-1.00000000000000))*(x3064)*(x3068)*(x3071)))+(((IkReal(-1.00000000000000))*(x3064)*(x3068)*(x3072)))+(((IkReal(-1.00000000000000))*(r10)*(x3065)*(x3069))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x3073=((sj0)*(sj5));
IkReal x3074=((r00)*(sj6));
IkReal x3075=((cj6)*(r01));
IkReal x3076=((cj0)*(cj5));
IkReal x3077=((cj0)*(sj5));
IkReal x3078=((r10)*(sj6));
IkReal x3079=((cj6)*(r11));
IkReal x3080=((IkReal(0.374290000000000))*(sj5));
IkReal x3081=((IkReal(0.0100000000000000))*(r02));
IkReal x3082=((IkReal(1.00000000000000))*(py));
IkReal x3083=((cj5)*(sj0));
IkReal x3084=((IkReal(0.374290000000000))*(r12));
IkReal x3085=((r20)*(sj6));
IkReal x3086=((IkReal(0.0100000000000000))*(r12));
IkReal x3087=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x3088=((r02)*(x3083));
IkReal x3089=((IkReal(0.374290000000000))*(cj6)*(x3077));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(-0.364420000000000))+(((IkReal(-0.0100000000000000))*(cj5)*(x3085)))+(((cj6)*(r21)*(x3080)))+(((IkReal(-0.0100000000000000))*(r22)*(sj5)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((x3080)*(x3085)))+(pz)+(((IkReal(-1.00000000000000))*(r21)*(x3087))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3077)*(x3078)))+(((IkReal(-1.00000000000000))*(x3077)*(x3079)))+(((x3073)*(x3075)))+(((x3073)*(x3074)))+(((r12)*(x3076)))+(((IkReal(-1.00000000000000))*(x3088))));
evalcond[3]=((((x3076)*(x3084)))+(((IkReal(-1.00000000000000))*(cj0)*(x3082)))+(((IkReal(-0.374290000000000))*(x3077)*(x3078)))+(((IkReal(0.0100000000000000))*(x3076)*(x3079)))+(((IkReal(0.374290000000000))*(x3073)*(x3075)))+(((IkReal(-1.00000000000000))*(x3073)*(x3081)))+(((IkReal(-0.0100000000000000))*(x3075)*(x3083)))+(((IkReal(-0.0100000000000000))*(x3074)*(x3083)))+(((IkReal(-0.374290000000000))*(x3077)*(x3079)))+(((x3077)*(x3086)))+(((px)*(sj0)))+(((IkReal(-0.374290000000000))*(x3088)))+(((IkReal(0.0100000000000000))*(x3076)*(x3078)))+(((IkReal(0.374290000000000))*(x3073)*(x3074))));
evalcond[4]=((IkReal(0.138000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((x3073)*(x3086)))+(((IkReal(0.0100000000000000))*(x3075)*(x3076)))+(((x3083)*(x3084)))+(((IkReal(-0.374290000000000))*(x3074)*(x3077)))+(((IkReal(-1.00000000000000))*(sj0)*(x3082)))+(((IkReal(0.0100000000000000))*(x3079)*(x3083)))+(((IkReal(0.374290000000000))*(r02)*(x3076)))+(((x3077)*(x3081)))+(((IkReal(-0.374290000000000))*(x3073)*(x3078)))+(((IkReal(0.0100000000000000))*(x3074)*(x3076)))+(((IkReal(0.0100000000000000))*(x3078)*(x3083)))+(((IkReal(-0.374290000000000))*(x3073)*(x3079)))+(((IkReal(-0.374290000000000))*(x3075)*(x3077))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3090=((IkReal(1.00000000000000))*(cj6)*(sj5));
IkReal x3091=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x3090)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x3091)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x3091)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x3090))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r20)*(x3091)))+(((IkReal(-1.00000000000000))*(r21)*(x3090)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x3090)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x3091)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x3091)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x3090)))))+IKsqr(((((IkReal(-1.00000000000000))*(r20)*(x3091)))+(((IkReal(-1.00000000000000))*(r21)*(x3090)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x3090)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x3091)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x3091)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x3090)))), ((((IkReal(-1.00000000000000))*(r20)*(x3091)))+(((IkReal(-1.00000000000000))*(r21)*(x3090)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x3092=((sj5)*(sj6));
IkReal x3093=((IkReal(1.00000000000000))*(cj6)*(sj5));
evalcond[0]=((((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(IKcos(j3))+(((r20)*(x3092))));
evalcond[1]=((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x3093)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x3092)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x3092)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x3093)))+(((IkReal(-1.00000000000000))*(IKsin(j3)))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst83;
IkReal x3094=(cj5)*(cj5);
IkReal x3095=(r20)*(r20);
IkReal x3096=(sj6)*(sj6);
IkReal x3097=(cj6)*(cj6);
IkReal x3098=(r21)*(r21);
IkReal x3099=((cj6)*(r21));
IkReal x3100=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3101=((cj5)*(r22)*(sj5));
gconst83=IKsign(((((x3100)*(x3101)))+(((x3094)*(x3095)*(x3096)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3096)*(x3098)))+(((x3094)*(x3097)*(x3098)))+(((x3095)*(x3097)))+(((IkReal(2.00000000000000))*(x3099)*(x3101)))+(((x3094)*(x3099)*(x3100)))+(((IkReal(-1.00000000000000))*(x3099)*(x3100)))));
IkReal x3102=(cj5)*(cj5);
IkReal x3103=(r20)*(r20);
IkReal x3104=(sj6)*(sj6);
IkReal x3105=(cj6)*(cj6);
IkReal x3106=(r21)*(r21);
IkReal x3107=((cj6)*(r21));
IkReal x3108=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3109=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x3104)*(x3106)))+(((x3103)*(x3105)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3102)*(x3105)*(x3106)))+(((x3102)*(x3103)*(x3104)))+(((x3102)*(x3107)*(x3108)))+(((IkReal(2.00000000000000))*(x3107)*(x3109)))+(((x3108)*(x3109)))+(((IkReal(-1.00000000000000))*(x3107)*(x3108))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst84;
IkReal x3110=(cj6)*(cj6);
IkReal x3111=(sj6)*(sj6);
IkReal x3112=((IkReal(1.00000000000000))*(r21));
IkReal x3113=((cj6)*(r20));
IkReal x3114=((r22)*(sj5));
IkReal x3115=((r01)*(sj0));
IkReal x3116=((r00)*(sj0));
IkReal x3117=((cj0)*(r10));
IkReal x3118=((r02)*(sj0)*(sj5));
IkReal x3119=((cj5)*(x3110));
IkReal x3120=((cj0)*(r12)*(sj5));
IkReal x3121=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3122=((cj5)*(x3111));
IkReal x3123=((r20)*(x3122));
gconst84=IKsign(((((IkReal(-1.00000000000000))*(x3112)*(x3116)*(x3122)))+(((IkReal(-1.00000000000000))*(x3112)*(x3116)*(x3119)))+(((IkReal(-1.00000000000000))*(x3113)*(x3120)))+(((r21)*(sj6)*(x3120)))+(((r20)*(x3115)*(x3119)))+(((IkReal(-1.00000000000000))*(x3121)*(x3123)))+(((IkReal(-1.00000000000000))*(cj6)*(x3114)*(x3116)))+(((IkReal(-1.00000000000000))*(sj6)*(x3114)*(x3121)))+(((x3115)*(x3123)))+(((IkReal(-1.00000000000000))*(sj6)*(x3112)*(x3118)))+(((x3113)*(x3118)))+(((sj6)*(x3114)*(x3115)))+(((IkReal(-1.00000000000000))*(r20)*(x3119)*(x3121)))+(((r21)*(x3117)*(x3119)))+(((cj6)*(x3114)*(x3117)))+(((r21)*(x3117)*(x3122)))));
IkReal x3124=(cj6)*(cj6);
IkReal x3125=(sj6)*(sj6);
IkReal x3126=((IkReal(1.00000000000000))*(r21));
IkReal x3127=((cj6)*(r20));
IkReal x3128=((r22)*(sj5));
IkReal x3129=((r01)*(sj0));
IkReal x3130=((r00)*(sj0));
IkReal x3131=((cj0)*(r10));
IkReal x3132=((r02)*(sj0)*(sj5));
IkReal x3133=((cj5)*(x3124));
IkReal x3134=((cj0)*(r12)*(sj5));
IkReal x3135=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3136=((cj5)*(x3125));
IkReal x3137=((r20)*(x3136));
dummyeval[0]=((((cj6)*(x3128)*(x3131)))+(((sj6)*(x3128)*(x3129)))+(((IkReal(-1.00000000000000))*(x3135)*(x3137)))+(((r21)*(x3131)*(x3136)))+(((IkReal(-1.00000000000000))*(x3127)*(x3134)))+(((r21)*(sj6)*(x3134)))+(((r21)*(x3131)*(x3133)))+(((r20)*(x3129)*(x3133)))+(((IkReal(-1.00000000000000))*(r20)*(x3133)*(x3135)))+(((IkReal(-1.00000000000000))*(cj6)*(x3128)*(x3130)))+(((IkReal(-1.00000000000000))*(x3126)*(x3130)*(x3133)))+(((IkReal(-1.00000000000000))*(sj6)*(x3128)*(x3135)))+(((x3129)*(x3137)))+(((IkReal(-1.00000000000000))*(sj6)*(x3126)*(x3132)))+(((IkReal(-1.00000000000000))*(x3126)*(x3130)*(x3136)))+(((x3127)*(x3132))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3138=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((gconst84)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst84)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3138)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3138)))+(((IkReal(-1.00000000000000))*(r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst84)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))), ((gconst84)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3138)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3138)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3139=IKsin(j4);
IkReal x3140=IKcos(j4);
IkReal x3141=((r22)*(sj5));
IkReal x3142=((IkReal(1.00000000000000))*(cj6));
IkReal x3143=((IkReal(1.00000000000000))*(cj0));
IkReal x3144=((cj5)*(r11));
IkReal x3145=((cj5)*(cj6));
IkReal x3146=((r11)*(sj6));
IkReal x3147=((IkReal(1.00000000000000))*(sj6));
IkReal x3148=((cj6)*(r00));
IkReal x3149=((r12)*(sj5));
IkReal x3150=((r02)*(sj5));
IkReal x3151=((cj6)*(r10));
IkReal x3152=((cj5)*(sj6));
IkReal x3153=((cj5)*(r01));
IkReal x3154=((sj0)*(x3139));
IkReal x3155=((r00)*(x3152));
IkReal x3156=((cj0)*(x3139));
IkReal x3157=((sj0)*(x3140));
IkReal x3158=((r20)*(x3140));
IkReal x3159=((cj0)*(x3140));
IkReal x3160=((r21)*(x3139));
IkReal x3161=((r21)*(x3140));
IkReal x3162=((r20)*(x3139));
IkReal x3163=((x3140)*(x3149));
IkReal x3164=((r01)*(sj6)*(x3140));
IkReal x3165=((cj5)*(r10)*(x3147));
evalcond[0]=((((x3139)*(x3141)))+(((IkReal(-1.00000000000000))*(x3142)*(x3158)))+(((sj6)*(x3161)))+(((x3152)*(x3162)))+(((x3145)*(x3160))));
evalcond[1]=((((x3152)*(x3158)))+(sj3)+(((cj6)*(x3162)))+(((IkReal(-1.00000000000000))*(x3147)*(x3160)))+(((x3145)*(x3161)))+(((x3140)*(x3141))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x3139)*(x3143)*(x3149)))+(((IkReal(-1.00000000000000))*(r00)*(x3142)*(x3157)))+(((r01)*(sj6)*(x3157)))+(((x3150)*(x3154)))+(((IkReal(-1.00000000000000))*(r10)*(x3139)*(x3143)*(x3152)))+(((IkReal(-1.00000000000000))*(x3140)*(x3143)*(x3146)))+(((IkReal(-1.00000000000000))*(x3142)*(x3144)*(x3156)))+(((r01)*(x3145)*(x3154)))+(((x3151)*(x3159)))+(((x3154)*(x3155))));
evalcond[3]=((((r01)*(x3145)*(x3157)))+(((x3155)*(x3157)))+(((x3146)*(x3156)))+(((IkReal(-1.00000000000000))*(x3142)*(x3144)*(x3159)))+(((IkReal(-1.00000000000000))*(x3143)*(x3163)))+(((IkReal(-1.00000000000000))*(r10)*(x3142)*(x3156)))+(((IkReal(-1.00000000000000))*(r01)*(x3147)*(x3154)))+(((x3148)*(x3154)))+(((IkReal(-1.00000000000000))*(r10)*(x3140)*(x3143)*(x3152)))+(((x3150)*(x3157))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3154)*(x3165)))+(((IkReal(-1.00000000000000))*(x3142)*(x3153)*(x3156)))+(((IkReal(-1.00000000000000))*(x3146)*(x3157)))+(((IkReal(-1.00000000000000))*(x3143)*(x3164)))+(((IkReal(-1.00000000000000))*(x3142)*(x3144)*(x3154)))+(((IkReal(-1.00000000000000))*(x3149)*(x3154)))+(((x3151)*(x3157)))+(((IkReal(-1.00000000000000))*(x3139)*(x3143)*(x3155)))+(((IkReal(-1.00000000000000))*(x3139)*(x3143)*(x3150)))+(((x3148)*(x3159))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x3142)*(x3153)*(x3159)))+(((IkReal(-1.00000000000000))*(r00)*(x3142)*(x3156)))+(((x3146)*(x3154)))+(((IkReal(-1.00000000000000))*(x3140)*(x3143)*(x3150)))+(cj3)+(((IkReal(-1.00000000000000))*(x3149)*(x3157)))+(((IkReal(-1.00000000000000))*(r10)*(x3142)*(x3154)))+(((IkReal(-1.00000000000000))*(x3157)*(x3165)))+(((IkReal(-1.00000000000000))*(x3142)*(x3144)*(x3157)))+(((r01)*(sj6)*(x3156)))+(((IkReal(-1.00000000000000))*(x3140)*(x3143)*(x3155))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3166=((r21)*(sj3));
IkReal x3167=((IkReal(1.00000000000000))*(r20)*(sj3));
if( IKabs(((gconst83)*(((((IkReal(-1.00000000000000))*(cj6)*(x3167)))+(((sj6)*(x3166))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst83)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3166)))+(((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x3167)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst83)*(((((IkReal(-1.00000000000000))*(cj6)*(x3167)))+(((sj6)*(x3166)))))), ((gconst83)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3166)))+(((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x3167)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3168=IKsin(j4);
IkReal x3169=IKcos(j4);
IkReal x3170=((r22)*(sj5));
IkReal x3171=((IkReal(1.00000000000000))*(cj6));
IkReal x3172=((IkReal(1.00000000000000))*(cj0));
IkReal x3173=((cj5)*(r11));
IkReal x3174=((cj5)*(cj6));
IkReal x3175=((r11)*(sj6));
IkReal x3176=((IkReal(1.00000000000000))*(sj6));
IkReal x3177=((cj6)*(r00));
IkReal x3178=((r12)*(sj5));
IkReal x3179=((r02)*(sj5));
IkReal x3180=((cj6)*(r10));
IkReal x3181=((cj5)*(sj6));
IkReal x3182=((cj5)*(r01));
IkReal x3183=((sj0)*(x3168));
IkReal x3184=((r00)*(x3181));
IkReal x3185=((cj0)*(x3168));
IkReal x3186=((sj0)*(x3169));
IkReal x3187=((r20)*(x3169));
IkReal x3188=((cj0)*(x3169));
IkReal x3189=((r21)*(x3168));
IkReal x3190=((r21)*(x3169));
IkReal x3191=((r20)*(x3168));
IkReal x3192=((x3169)*(x3178));
IkReal x3193=((r01)*(sj6)*(x3169));
IkReal x3194=((cj5)*(r10)*(x3176));
evalcond[0]=((((sj6)*(x3190)))+(((x3181)*(x3191)))+(((x3168)*(x3170)))+(((IkReal(-1.00000000000000))*(x3171)*(x3187)))+(((x3174)*(x3189))));
evalcond[1]=((((x3169)*(x3170)))+(sj3)+(((cj6)*(x3191)))+(((x3174)*(x3190)))+(((x3181)*(x3187)))+(((IkReal(-1.00000000000000))*(x3176)*(x3189))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x3168)*(x3172)*(x3181)))+(((x3180)*(x3188)))+(((IkReal(-1.00000000000000))*(r00)*(x3171)*(x3186)))+(((x3183)*(x3184)))+(((r01)*(x3174)*(x3183)))+(((r01)*(sj6)*(x3186)))+(((IkReal(-1.00000000000000))*(x3168)*(x3172)*(x3178)))+(((IkReal(-1.00000000000000))*(x3169)*(x3172)*(x3175)))+(((x3179)*(x3183)))+(((IkReal(-1.00000000000000))*(x3171)*(x3173)*(x3185))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x3171)*(x3173)*(x3188)))+(((x3175)*(x3185)))+(((IkReal(-1.00000000000000))*(r10)*(x3169)*(x3172)*(x3181)))+(((x3184)*(x3186)))+(((x3179)*(x3186)))+(((IkReal(-1.00000000000000))*(x3172)*(x3192)))+(((IkReal(-1.00000000000000))*(r01)*(x3176)*(x3183)))+(((IkReal(-1.00000000000000))*(r10)*(x3171)*(x3185)))+(((x3177)*(x3183)))+(((r01)*(x3174)*(x3186))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3171)*(x3173)*(x3183)))+(((x3180)*(x3186)))+(((x3177)*(x3188)))+(((IkReal(-1.00000000000000))*(x3168)*(x3172)*(x3184)))+(((IkReal(-1.00000000000000))*(x3172)*(x3193)))+(((IkReal(-1.00000000000000))*(x3168)*(x3172)*(x3179)))+(((IkReal(-1.00000000000000))*(x3183)*(x3194)))+(((IkReal(-1.00000000000000))*(x3175)*(x3186)))+(((IkReal(-1.00000000000000))*(x3178)*(x3183)))+(((IkReal(-1.00000000000000))*(x3171)*(x3182)*(x3185))));
evalcond[5]=((((r01)*(sj6)*(x3185)))+(((IkReal(-1.00000000000000))*(x3178)*(x3186)))+(((IkReal(-1.00000000000000))*(x3169)*(x3172)*(x3184)))+(((IkReal(-1.00000000000000))*(x3186)*(x3194)))+(((IkReal(-1.00000000000000))*(x3171)*(x3173)*(x3186)))+(cj3)+(((IkReal(-1.00000000000000))*(x3171)*(x3182)*(x3188)))+(((x3175)*(x3183)))+(((IkReal(-1.00000000000000))*(x3169)*(x3172)*(x3179)))+(((IkReal(-1.00000000000000))*(r00)*(x3171)*(x3185)))+(((IkReal(-1.00000000000000))*(r10)*(x3171)*(x3183))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x3195=((sj0)*(sj5));
IkReal x3196=((r00)*(sj6));
IkReal x3197=((cj6)*(r01));
IkReal x3198=((cj0)*(cj5));
IkReal x3199=((cj0)*(sj5));
IkReal x3200=((r10)*(sj6));
IkReal x3201=((cj6)*(r11));
IkReal x3202=((IkReal(0.374290000000000))*(sj5));
IkReal x3203=((IkReal(0.0100000000000000))*(r02));
IkReal x3204=((IkReal(1.00000000000000))*(py));
IkReal x3205=((cj5)*(sj0));
IkReal x3206=((IkReal(0.374290000000000))*(r12));
IkReal x3207=((r20)*(sj6));
IkReal x3208=((IkReal(0.0100000000000000))*(r12));
IkReal x3209=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x3210=((r02)*(x3205));
IkReal x3211=((IkReal(0.374290000000000))*(cj6)*(x3199));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j2, IkReal(6.28318530717959))));
evalcond[1]=((IkReal(-0.364420000000000))+(((IkReal(-0.0100000000000000))*(cj5)*(x3207)))+(((IkReal(-0.0100000000000000))*(r22)*(sj5)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x3209)))+(pz)+(((x3202)*(x3207)))+(((cj6)*(r21)*(x3202))));
evalcond[2]=((((r12)*(x3198)))+(((IkReal(-1.00000000000000))*(x3210)))+(((IkReal(-1.00000000000000))*(x3199)*(x3201)))+(((IkReal(-1.00000000000000))*(x3199)*(x3200)))+(((x3195)*(x3197)))+(((x3195)*(x3196))));
evalcond[3]=((((IkReal(0.374290000000000))*(x3195)*(x3196)))+(((IkReal(-0.374290000000000))*(x3199)*(x3200)))+(((IkReal(0.374290000000000))*(x3195)*(x3197)))+(((IkReal(0.0100000000000000))*(x3198)*(x3200)))+(((IkReal(-1.00000000000000))*(cj0)*(x3204)))+(((IkReal(-1.00000000000000))*(x3195)*(x3203)))+(((x3198)*(x3206)))+(((x3199)*(x3208)))+(((IkReal(0.0100000000000000))*(x3198)*(x3201)))+(((IkReal(-0.374290000000000))*(x3199)*(x3201)))+(((px)*(sj0)))+(((IkReal(-0.0100000000000000))*(x3197)*(x3205)))+(((IkReal(-0.374290000000000))*(x3210)))+(((IkReal(-0.0100000000000000))*(x3196)*(x3205))));
evalcond[4]=((((IkReal(0.0100000000000000))*(x3197)*(x3198)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-0.374290000000000))*(x3196)*(x3199)))+(((x3195)*(x3208)))+(((IkReal(0.374290000000000))*(r02)*(x3198)))+(((IkReal(-0.374290000000000))*(x3197)*(x3199)))+(((IkReal(-0.374290000000000))*(x3195)*(x3200)))+(((x3199)*(x3203)))+(((IkReal(-1.00000000000000))*(sj0)*(x3204)))+(((x3205)*(x3206)))+(((IkReal(0.0100000000000000))*(x3200)*(x3205)))+(((IkReal(-0.374290000000000))*(x3195)*(x3201)))+(((IkReal(0.0100000000000000))*(x3201)*(x3205)))+(((IkReal(0.0100000000000000))*(x3196)*(x3198))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3212=((IkReal(1.00000000000000))*(cj5));
IkReal x3213=((cj6)*(sj5));
IkReal x3214=((sj5)*(sj6));
if( IKabs(((((r10)*(sj0)*(x3214)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x3212)))+(((r11)*(sj0)*(x3213)))+(((cj0)*(r00)*(x3214)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x3212)))+(((cj0)*(r01)*(x3213))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r21)*(x3213)))+(((IkReal(-1.00000000000000))*(r20)*(x3214)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r10)*(sj0)*(x3214)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x3212)))+(((r11)*(sj0)*(x3213)))+(((cj0)*(r00)*(x3214)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x3212)))+(((cj0)*(r01)*(x3213)))))+IKsqr(((((IkReal(-1.00000000000000))*(r21)*(x3213)))+(((IkReal(-1.00000000000000))*(r20)*(x3214)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r10)*(sj0)*(x3214)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x3212)))+(((r11)*(sj0)*(x3213)))+(((cj0)*(r00)*(x3214)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x3212)))+(((cj0)*(r01)*(x3213)))), ((((IkReal(-1.00000000000000))*(r21)*(x3213)))+(((IkReal(-1.00000000000000))*(r20)*(x3214)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x3215=((sj5)*(sj6));
IkReal x3216=((IkReal(1.00000000000000))*(cj6)*(sj5));
evalcond[0]=((((cj6)*(r21)*(sj5)))+(((r20)*(x3215)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(IKcos(j3)));
evalcond[1]=((((cj0)*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x3215)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(x3216)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x3215)))+(IKsin(j3))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x3216))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst87;
IkReal x3217=(cj5)*(cj5);
IkReal x3218=(r20)*(r20);
IkReal x3219=(sj6)*(sj6);
IkReal x3220=(cj6)*(cj6);
IkReal x3221=(r21)*(r21);
IkReal x3222=((cj6)*(r21));
IkReal x3223=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3224=((cj5)*(r22)*(sj5));
gconst87=IKsign(((((IkReal(-1.00000000000000))*(x3222)*(x3223)))+(((x3217)*(x3218)*(x3219)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3219)*(x3221)))+(((x3218)*(x3220)))+(((x3217)*(x3222)*(x3223)))+(((x3223)*(x3224)))+(((x3217)*(x3220)*(x3221)))+(((IkReal(2.00000000000000))*(x3222)*(x3224)))));
IkReal x3225=(cj5)*(cj5);
IkReal x3226=(r20)*(r20);
IkReal x3227=(sj6)*(sj6);
IkReal x3228=(cj6)*(cj6);
IkReal x3229=(r21)*(r21);
IkReal x3230=((cj6)*(r21));
IkReal x3231=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3232=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x3227)*(x3229)))+(((x3231)*(x3232)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3225)*(x3228)*(x3229)))+(((IkReal(-1.00000000000000))*(x3230)*(x3231)))+(((x3226)*(x3228)))+(((x3225)*(x3230)*(x3231)))+(((x3225)*(x3226)*(x3227)))+(((IkReal(2.00000000000000))*(x3230)*(x3232))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst88;
IkReal x3233=(cj6)*(cj6);
IkReal x3234=(sj6)*(sj6);
IkReal x3235=((IkReal(1.00000000000000))*(r01));
IkReal x3236=((sj0)*(sj5));
IkReal x3237=((cj6)*(r22));
IkReal x3238=((r21)*(sj6));
IkReal x3239=((r00)*(r21));
IkReal x3240=((cj0)*(sj5));
IkReal x3241=((cj6)*(r20));
IkReal x3242=((r22)*(sj6));
IkReal x3243=((cj0)*(cj5));
IkReal x3244=((IkReal(1.00000000000000))*(r10));
IkReal x3245=((cj5)*(sj0));
IkReal x3246=((r20)*(x3234));
IkReal x3247=((x3233)*(x3245));
gconst88=IKsign(((((IkReal(-1.00000000000000))*(r21)*(x3234)*(x3243)*(x3244)))+(((r11)*(x3240)*(x3242)))+(((x3234)*(x3239)*(x3245)))+(((r12)*(x3240)*(x3241)))+(((IkReal(-1.00000000000000))*(r21)*(x3233)*(x3243)*(x3244)))+(((r00)*(x3236)*(x3237)))+(((IkReal(-1.00000000000000))*(x3237)*(x3240)*(x3244)))+(((r11)*(r20)*(x3233)*(x3243)))+(((r02)*(x3236)*(x3238)))+(((IkReal(-1.00000000000000))*(x3235)*(x3245)*(x3246)))+(((IkReal(-1.00000000000000))*(x3235)*(x3236)*(x3242)))+(((IkReal(-1.00000000000000))*(r20)*(x3235)*(x3247)))+(((IkReal(-1.00000000000000))*(r02)*(x3236)*(x3241)))+(((IkReal(-1.00000000000000))*(r12)*(x3238)*(x3240)))+(((x3239)*(x3247)))+(((r11)*(x3243)*(x3246)))));
IkReal x3248=(cj6)*(cj6);
IkReal x3249=(sj6)*(sj6);
IkReal x3250=((IkReal(1.00000000000000))*(r01));
IkReal x3251=((sj0)*(sj5));
IkReal x3252=((cj6)*(r22));
IkReal x3253=((r21)*(sj6));
IkReal x3254=((r00)*(r21));
IkReal x3255=((cj0)*(sj5));
IkReal x3256=((cj6)*(r20));
IkReal x3257=((r22)*(sj6));
IkReal x3258=((cj0)*(cj5));
IkReal x3259=((IkReal(1.00000000000000))*(r10));
IkReal x3260=((cj5)*(sj0));
IkReal x3261=((r20)*(x3249));
IkReal x3262=((x3248)*(x3260));
dummyeval[0]=((((r11)*(x3258)*(x3261)))+(((IkReal(-1.00000000000000))*(x3252)*(x3255)*(x3259)))+(((IkReal(-1.00000000000000))*(x3250)*(x3251)*(x3257)))+(((IkReal(-1.00000000000000))*(r12)*(x3253)*(x3255)))+(((IkReal(-1.00000000000000))*(r02)*(x3251)*(x3256)))+(((r02)*(x3251)*(x3253)))+(((r11)*(r20)*(x3248)*(x3258)))+(((IkReal(-1.00000000000000))*(r21)*(x3248)*(x3258)*(x3259)))+(((r00)*(x3251)*(x3252)))+(((x3249)*(x3254)*(x3260)))+(((r11)*(x3255)*(x3257)))+(((IkReal(-1.00000000000000))*(r21)*(x3249)*(x3258)*(x3259)))+(((IkReal(-1.00000000000000))*(r20)*(x3250)*(x3262)))+(((IkReal(-1.00000000000000))*(x3250)*(x3260)*(x3261)))+(((r12)*(x3255)*(x3256)))+(((x3254)*(x3262))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3263=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((gconst88)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst88)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3263)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3263))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst88)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))), ((gconst88)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3263)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3263)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3264=IKsin(j4);
IkReal x3265=IKcos(j4);
IkReal x3266=((r22)*(sj5));
IkReal x3267=((IkReal(1.00000000000000))*(cj6));
IkReal x3268=((IkReal(1.00000000000000))*(cj0));
IkReal x3269=((cj5)*(r11));
IkReal x3270=((cj5)*(cj6));
IkReal x3271=((r11)*(sj6));
IkReal x3272=((IkReal(1.00000000000000))*(sj6));
IkReal x3273=((cj6)*(r00));
IkReal x3274=((r12)*(sj5));
IkReal x3275=((r02)*(sj5));
IkReal x3276=((cj6)*(r10));
IkReal x3277=((cj5)*(sj6));
IkReal x3278=((cj5)*(r01));
IkReal x3279=((sj0)*(x3264));
IkReal x3280=((r00)*(x3277));
IkReal x3281=((cj0)*(x3264));
IkReal x3282=((sj0)*(x3265));
IkReal x3283=((r20)*(x3265));
IkReal x3284=((cj0)*(x3265));
IkReal x3285=((r21)*(x3264));
IkReal x3286=((r21)*(x3265));
IkReal x3287=((r20)*(x3264));
IkReal x3288=((x3265)*(x3274));
IkReal x3289=((r01)*(sj6)*(x3265));
IkReal x3290=((cj5)*(r10)*(x3272));
evalcond[0]=((((x3277)*(x3287)))+(((x3264)*(x3266)))+(((IkReal(-1.00000000000000))*(x3267)*(x3283)))+(((x3270)*(x3285)))+(((sj6)*(x3286))));
evalcond[1]=((sj3)+(((cj6)*(x3287)))+(((IkReal(-1.00000000000000))*(x3272)*(x3285)))+(((x3277)*(x3283)))+(((x3270)*(x3286)))+(((x3265)*(x3266))));
evalcond[2]=((IkReal(-1.00000000000000))+(((r01)*(sj6)*(x3282)))+(((r01)*(x3270)*(x3279)))+(((x3275)*(x3279)))+(((IkReal(-1.00000000000000))*(x3264)*(x3268)*(x3274)))+(((IkReal(-1.00000000000000))*(x3267)*(x3269)*(x3281)))+(((IkReal(-1.00000000000000))*(r10)*(x3264)*(x3268)*(x3277)))+(((x3276)*(x3284)))+(((IkReal(-1.00000000000000))*(r00)*(x3267)*(x3282)))+(((x3279)*(x3280)))+(((IkReal(-1.00000000000000))*(x3265)*(x3268)*(x3271))));
evalcond[3]=((((x3273)*(x3279)))+(((x3275)*(x3282)))+(((IkReal(-1.00000000000000))*(r10)*(x3265)*(x3268)*(x3277)))+(((r01)*(x3270)*(x3282)))+(((x3280)*(x3282)))+(((IkReal(-1.00000000000000))*(r10)*(x3267)*(x3281)))+(((IkReal(-1.00000000000000))*(x3267)*(x3269)*(x3284)))+(((IkReal(-1.00000000000000))*(x3268)*(x3288)))+(((x3271)*(x3281)))+(((IkReal(-1.00000000000000))*(r01)*(x3272)*(x3279))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3274)*(x3279)))+(((x3273)*(x3284)))+(((IkReal(-1.00000000000000))*(x3279)*(x3290)))+(((IkReal(-1.00000000000000))*(x3267)*(x3278)*(x3281)))+(((IkReal(-1.00000000000000))*(x3267)*(x3269)*(x3279)))+(((IkReal(-1.00000000000000))*(x3264)*(x3268)*(x3280)))+(((x3276)*(x3282)))+(((IkReal(-1.00000000000000))*(x3264)*(x3268)*(x3275)))+(((IkReal(-1.00000000000000))*(x3271)*(x3282)))+(((IkReal(-1.00000000000000))*(x3268)*(x3289))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3267)*(x3279)))+(((IkReal(-1.00000000000000))*(r00)*(x3267)*(x3281)))+(((IkReal(-1.00000000000000))*(x3274)*(x3282)))+(((x3271)*(x3279)))+(((IkReal(-1.00000000000000))*(x3267)*(x3278)*(x3284)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x3265)*(x3268)*(x3280)))+(((IkReal(-1.00000000000000))*(x3265)*(x3268)*(x3275)))+(((IkReal(-1.00000000000000))*(x3267)*(x3269)*(x3282)))+(((r01)*(sj6)*(x3281)))+(((IkReal(-1.00000000000000))*(x3282)*(x3290))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3291=((r21)*(sj3));
IkReal x3292=((IkReal(1.00000000000000))*(r20)*(sj3));
if( IKabs(((gconst87)*(((((sj6)*(x3291)))+(((IkReal(-1.00000000000000))*(cj6)*(x3292))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst87)*(((((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x3292)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3291)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst87)*(((((sj6)*(x3291)))+(((IkReal(-1.00000000000000))*(cj6)*(x3292)))))), ((gconst87)*(((((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x3292)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3291)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3293=IKsin(j4);
IkReal x3294=IKcos(j4);
IkReal x3295=((r22)*(sj5));
IkReal x3296=((IkReal(1.00000000000000))*(cj6));
IkReal x3297=((IkReal(1.00000000000000))*(cj0));
IkReal x3298=((cj5)*(r11));
IkReal x3299=((cj5)*(cj6));
IkReal x3300=((r11)*(sj6));
IkReal x3301=((IkReal(1.00000000000000))*(sj6));
IkReal x3302=((cj6)*(r00));
IkReal x3303=((r12)*(sj5));
IkReal x3304=((r02)*(sj5));
IkReal x3305=((cj6)*(r10));
IkReal x3306=((cj5)*(sj6));
IkReal x3307=((cj5)*(r01));
IkReal x3308=((sj0)*(x3293));
IkReal x3309=((r00)*(x3306));
IkReal x3310=((cj0)*(x3293));
IkReal x3311=((sj0)*(x3294));
IkReal x3312=((r20)*(x3294));
IkReal x3313=((cj0)*(x3294));
IkReal x3314=((r21)*(x3293));
IkReal x3315=((r21)*(x3294));
IkReal x3316=((r20)*(x3293));
IkReal x3317=((x3294)*(x3303));
IkReal x3318=((r01)*(sj6)*(x3294));
IkReal x3319=((cj5)*(r10)*(x3301));
evalcond[0]=((((IkReal(-1.00000000000000))*(x3296)*(x3312)))+(((x3299)*(x3314)))+(((x3293)*(x3295)))+(((x3306)*(x3316)))+(((sj6)*(x3315))));
evalcond[1]=((((cj6)*(x3316)))+(sj3)+(((x3306)*(x3312)))+(((IkReal(-1.00000000000000))*(x3301)*(x3314)))+(((x3294)*(x3295)))+(((x3299)*(x3315))));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x3294)*(x3297)*(x3300)))+(((r01)*(x3299)*(x3308)))+(((IkReal(-1.00000000000000))*(x3296)*(x3298)*(x3310)))+(((x3305)*(x3313)))+(((IkReal(-1.00000000000000))*(r00)*(x3296)*(x3311)))+(((x3308)*(x3309)))+(((IkReal(-1.00000000000000))*(r10)*(x3293)*(x3297)*(x3306)))+(((x3304)*(x3308)))+(((r01)*(sj6)*(x3311)))+(((IkReal(-1.00000000000000))*(x3293)*(x3297)*(x3303))));
evalcond[3]=((((x3300)*(x3310)))+(((IkReal(-1.00000000000000))*(x3296)*(x3298)*(x3313)))+(((IkReal(-1.00000000000000))*(x3297)*(x3317)))+(((IkReal(-1.00000000000000))*(r10)*(x3294)*(x3297)*(x3306)))+(((x3304)*(x3311)))+(((x3309)*(x3311)))+(((IkReal(-1.00000000000000))*(r01)*(x3301)*(x3308)))+(((IkReal(-1.00000000000000))*(r10)*(x3296)*(x3310)))+(((r01)*(x3299)*(x3311)))+(((x3302)*(x3308))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3300)*(x3311)))+(((x3305)*(x3311)))+(((x3302)*(x3313)))+(((IkReal(-1.00000000000000))*(x3308)*(x3319)))+(((IkReal(-1.00000000000000))*(x3296)*(x3298)*(x3308)))+(((IkReal(-1.00000000000000))*(x3293)*(x3297)*(x3304)))+(((IkReal(-1.00000000000000))*(x3296)*(x3307)*(x3310)))+(((IkReal(-1.00000000000000))*(x3293)*(x3297)*(x3309)))+(((IkReal(-1.00000000000000))*(x3303)*(x3308)))+(((IkReal(-1.00000000000000))*(x3297)*(x3318))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3296)*(x3308)))+(((r01)*(sj6)*(x3310)))+(((IkReal(-1.00000000000000))*(r00)*(x3296)*(x3310)))+(((IkReal(-1.00000000000000))*(x3296)*(x3307)*(x3313)))+(((IkReal(-1.00000000000000))*(x3311)*(x3319)))+(((x3300)*(x3308)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x3294)*(x3297)*(x3304)))+(((IkReal(-1.00000000000000))*(x3303)*(x3311)))+(((IkReal(-1.00000000000000))*(x3296)*(x3298)*(x3311)))+(((IkReal(-1.00000000000000))*(x3294)*(x3297)*(x3309))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3320=((sj0)*(sj5));
IkReal x3321=((IkReal(1.00000000000000))*(cj6)*(sj5));
IkReal x3322=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((cj6)*(r01)*(x3320)))+(((IkReal(-1.00000000000000))*(cj0)*(r11)*(x3321)))+(((cj0)*(cj5)*(r12)))+(((r00)*(sj6)*(x3320)))+(((IkReal(-1.00000000000000))*(cj0)*(r10)*(x3322)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(sj0))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r20)*(x3322)))+(((IkReal(-1.00000000000000))*(r21)*(x3321)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((cj6)*(r01)*(x3320)))+(((IkReal(-1.00000000000000))*(cj0)*(r11)*(x3321)))+(((cj0)*(cj5)*(r12)))+(((r00)*(sj6)*(x3320)))+(((IkReal(-1.00000000000000))*(cj0)*(r10)*(x3322)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(sj0)))))))+IKsqr(((((IkReal(-1.00000000000000))*(r20)*(x3322)))+(((IkReal(-1.00000000000000))*(r21)*(x3321)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((cj6)*(r01)*(x3320)))+(((IkReal(-1.00000000000000))*(cj0)*(r11)*(x3321)))+(((cj0)*(cj5)*(r12)))+(((r00)*(sj6)*(x3320)))+(((IkReal(-1.00000000000000))*(cj0)*(r10)*(x3322)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(sj0)))))), ((((IkReal(-1.00000000000000))*(r20)*(x3322)))+(((IkReal(-1.00000000000000))*(r21)*(x3321)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x3323=IKsin(j3);
IkReal x3324=((sj5)*(sj6));
IkReal x3325=((cj0)*(cj5));
IkReal x3326=((IkReal(1.00000000000000))*(cj0));
IkReal x3327=((IkReal(1.00000000000000))*(sj0));
IkReal x3328=((IkReal(1.00000000000000))*(x3323));
IkReal x3329=((cj6)*(r01)*(sj5));
IkReal x3330=((cj6)*(r11)*(sj5));
evalcond[0]=((((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r20)*(x3324)))+(IKcos(j3)));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3326)*(x3330)))+(((r12)*(x3325)))+(((r00)*(sj0)*(x3324)))+(((IkReal(-1.00000000000000))*(sj2)*(x3328)))+(((IkReal(-1.00000000000000))*(r10)*(x3324)*(x3326)))+(((sj0)*(x3329)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(x3327))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x3324)*(x3326)))+(((r02)*(x3325)))+(((IkReal(-1.00000000000000))*(x3327)*(x3330)))+(((IkReal(-1.00000000000000))*(r10)*(x3324)*(x3327)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(cj2)*(x3328)))+(((IkReal(-1.00000000000000))*(x3326)*(x3329))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst79;
IkReal x3331=(cj5)*(cj5);
IkReal x3332=(r20)*(r20);
IkReal x3333=(sj6)*(sj6);
IkReal x3334=(cj6)*(cj6);
IkReal x3335=(r21)*(r21);
IkReal x3336=((cj6)*(r21));
IkReal x3337=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3338=((cj5)*(r22)*(sj5));
gconst79=IKsign(((((x3337)*(x3338)))+(((IkReal(-1.00000000000000))*(x3336)*(x3337)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3331)*(x3334)*(x3335)))+(((x3331)*(x3336)*(x3337)))+(((x3331)*(x3332)*(x3333)))+(((x3333)*(x3335)))+(((IkReal(2.00000000000000))*(x3336)*(x3338)))+(((x3332)*(x3334)))));
IkReal x3339=(cj5)*(cj5);
IkReal x3340=(r20)*(r20);
IkReal x3341=(sj6)*(sj6);
IkReal x3342=(cj6)*(cj6);
IkReal x3343=(r21)*(r21);
IkReal x3344=((cj6)*(r21));
IkReal x3345=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3346=((cj5)*(r22)*(sj5));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3344)*(x3345)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3340)*(x3342)))+(((x3341)*(x3343)))+(((x3339)*(x3340)*(x3341)))+(((x3339)*(x3342)*(x3343)))+(((x3345)*(x3346)))+(((IkReal(2.00000000000000))*(x3344)*(x3346)))+(((x3339)*(x3344)*(x3345))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst80;
IkReal x3347=(cj6)*(cj6);
IkReal x3348=(sj6)*(sj6);
IkReal x3349=((IkReal(1.00000000000000))*(r21));
IkReal x3350=((cj6)*(r20));
IkReal x3351=((r22)*(sj5));
IkReal x3352=((r01)*(sj0));
IkReal x3353=((r00)*(sj0));
IkReal x3354=((cj0)*(r10));
IkReal x3355=((r02)*(sj0)*(sj5));
IkReal x3356=((cj5)*(x3347));
IkReal x3357=((cj0)*(r12)*(sj5));
IkReal x3358=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3359=((cj5)*(x3348));
IkReal x3360=((r20)*(x3359));
gconst80=IKsign(((((x3352)*(x3360)))+(((IkReal(-1.00000000000000))*(x3349)*(x3353)*(x3359)))+(((r20)*(x3352)*(x3356)))+(((IkReal(-1.00000000000000))*(x3358)*(x3360)))+(((x3350)*(x3355)))+(((cj6)*(x3351)*(x3354)))+(((IkReal(-1.00000000000000))*(sj6)*(x3351)*(x3358)))+(((IkReal(-1.00000000000000))*(cj6)*(x3351)*(x3353)))+(((r21)*(sj6)*(x3357)))+(((r21)*(x3354)*(x3356)))+(((sj6)*(x3351)*(x3352)))+(((r21)*(x3354)*(x3359)))+(((IkReal(-1.00000000000000))*(r20)*(x3356)*(x3358)))+(((IkReal(-1.00000000000000))*(x3349)*(x3353)*(x3356)))+(((IkReal(-1.00000000000000))*(x3350)*(x3357)))+(((IkReal(-1.00000000000000))*(sj6)*(x3349)*(x3355)))));
IkReal x3361=(cj6)*(cj6);
IkReal x3362=(sj6)*(sj6);
IkReal x3363=((IkReal(1.00000000000000))*(r21));
IkReal x3364=((cj6)*(r20));
IkReal x3365=((r22)*(sj5));
IkReal x3366=((r01)*(sj0));
IkReal x3367=((r00)*(sj0));
IkReal x3368=((cj0)*(r10));
IkReal x3369=((r02)*(sj0)*(sj5));
IkReal x3370=((cj5)*(x3361));
IkReal x3371=((cj0)*(r12)*(sj5));
IkReal x3372=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3373=((cj5)*(x3362));
IkReal x3374=((r20)*(x3373));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r20)*(x3370)*(x3372)))+(((x3366)*(x3374)))+(((x3364)*(x3369)))+(((r21)*(x3368)*(x3370)))+(((IkReal(-1.00000000000000))*(x3363)*(x3367)*(x3370)))+(((r21)*(sj6)*(x3371)))+(((r21)*(x3368)*(x3373)))+(((IkReal(-1.00000000000000))*(x3364)*(x3371)))+(((IkReal(-1.00000000000000))*(sj6)*(x3363)*(x3369)))+(((IkReal(-1.00000000000000))*(x3372)*(x3374)))+(((cj6)*(x3365)*(x3368)))+(((r20)*(x3366)*(x3370)))+(((sj6)*(x3365)*(x3366)))+(((IkReal(-1.00000000000000))*(x3363)*(x3367)*(x3373)))+(((IkReal(-1.00000000000000))*(sj6)*(x3365)*(x3372)))+(((IkReal(-1.00000000000000))*(cj6)*(x3365)*(x3367))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3375=((cj2)*(sj6));
IkReal x3376=((IkReal(1.00000000000000))*(r20));
IkReal x3377=((cj2)*(cj6));
if( IKabs(((gconst80)*(((((r21)*(x3375)))+(((IkReal(-1.00000000000000))*(x3376)*(x3377))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst80)*(((((IkReal(-1.00000000000000))*(cj5)*(x3375)*(x3376)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3377))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst80)*(((((r21)*(x3375)))+(((IkReal(-1.00000000000000))*(x3376)*(x3377)))))), ((gconst80)*(((((IkReal(-1.00000000000000))*(cj5)*(x3375)*(x3376)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3377)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3378=IKsin(j4);
IkReal x3379=IKcos(j4);
IkReal x3380=((r00)*(sj6));
IkReal x3381=((IkReal(1.00000000000000))*(r12));
IkReal x3382=((IkReal(1.00000000000000))*(cj6));
IkReal x3383=((cj6)*(r01));
IkReal x3384=((r11)*(sj6));
IkReal x3385=((r01)*(sj6));
IkReal x3386=((IkReal(1.00000000000000))*(cj5));
IkReal x3387=((IkReal(1.00000000000000))*(sj6));
IkReal x3388=((cj5)*(r11));
IkReal x3389=((cj6)*(r00));
IkReal x3390=((cj5)*(cj6));
IkReal x3391=((r02)*(sj5));
IkReal x3392=((cj6)*(r10));
IkReal x3393=((cj5)*(sj6));
IkReal x3394=((r10)*(sj6));
IkReal x3395=((cj5)*(r01));
IkReal x3396=((sj5)*(x3378));
IkReal x3397=((cj0)*(x3379));
IkReal x3398=((cj0)*(x3378));
IkReal x3399=((sj0)*(x3379));
IkReal x3400=((sj0)*(x3378));
IkReal x3401=((r20)*(x3379));
IkReal x3402=((r21)*(x3378));
IkReal x3403=((r21)*(x3379));
IkReal x3404=((r20)*(x3378));
IkReal x3405=((cj5)*(x3400));
evalcond[0]=((((r22)*(x3396)))+(((IkReal(-1.00000000000000))*(x3382)*(x3401)))+(((x3393)*(x3404)))+(((x3390)*(x3402)))+(((sj6)*(x3403))));
evalcond[1]=((((cj6)*(x3404)))+(sj3)+(((IkReal(-1.00000000000000))*(x3387)*(x3402)))+(((r22)*(sj5)*(x3379)))+(((x3393)*(x3401)))+(((x3390)*(x3403))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3384)*(x3397)))+(((x3385)*(x3399)))+(((x3391)*(x3400)))+(((IkReal(-1.00000000000000))*(x3386)*(x3394)*(x3398)))+(((x3392)*(x3397)))+(((x3380)*(x3405)))+(cj2)+(((IkReal(-1.00000000000000))*(r00)*(x3382)*(x3399)))+(((IkReal(-1.00000000000000))*(x3382)*(x3388)*(x3398)))+(((IkReal(-1.00000000000000))*(cj0)*(x3381)*(x3396)))+(((x3383)*(x3405))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x3382)*(x3388)*(x3397)))+(((IkReal(-1.00000000000000))*(x3386)*(x3394)*(x3397)))+(((x3389)*(x3400)))+(((IkReal(-1.00000000000000))*(sj5)*(x3381)*(x3397)))+(((cj5)*(x3380)*(x3399)))+(((IkReal(-1.00000000000000))*(r10)*(x3382)*(x3398)))+(((IkReal(-1.00000000000000))*(x3385)*(x3400)))+(((cj5)*(x3383)*(x3399)))+(((cj3)*(sj2)))+(((x3391)*(x3399)))+(((x3384)*(x3398))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj0)*(x3381)*(x3396)))+(((IkReal(-1.00000000000000))*(sj2)))+(((x3389)*(x3397)))+(((IkReal(-1.00000000000000))*(x3385)*(x3397)))+(((x3392)*(x3399)))+(((IkReal(-1.00000000000000))*(x3391)*(x3398)))+(((IkReal(-1.00000000000000))*(x3380)*(x3386)*(x3398)))+(((IkReal(-1.00000000000000))*(x3386)*(x3394)*(x3400)))+(((IkReal(-1.00000000000000))*(x3382)*(x3395)*(x3398)))+(((IkReal(-1.00000000000000))*(x3384)*(x3399)))+(((IkReal(-1.00000000000000))*(x3382)*(x3388)*(x3400))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3382)*(x3400)))+(((IkReal(-1.00000000000000))*(x3380)*(x3386)*(x3397)))+(((IkReal(-1.00000000000000))*(x3391)*(x3397)))+(((IkReal(-1.00000000000000))*(x3386)*(x3394)*(x3399)))+(((IkReal(-1.00000000000000))*(r00)*(x3382)*(x3398)))+(((x3384)*(x3400)))+(((cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(x3382)*(x3395)*(x3397)))+(((IkReal(-1.00000000000000))*(sj5)*(x3381)*(x3399)))+(((x3385)*(x3398)))+(((IkReal(-1.00000000000000))*(x3382)*(x3388)*(x3399))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3406=((r21)*(sj3));
IkReal x3407=((IkReal(1.00000000000000))*(r20)*(sj3));
if( IKabs(((gconst79)*(((((sj6)*(x3406)))+(((IkReal(-1.00000000000000))*(cj6)*(x3407))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst79)*(((((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x3407)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3406)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst79)*(((((sj6)*(x3406)))+(((IkReal(-1.00000000000000))*(cj6)*(x3407)))))), ((gconst79)*(((((IkReal(-1.00000000000000))*(cj5)*(sj6)*(x3407)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3406)))+(((IkReal(-1.00000000000000))*(r22)*(sj3)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3408=IKsin(j4);
IkReal x3409=IKcos(j4);
IkReal x3410=((r00)*(sj6));
IkReal x3411=((IkReal(1.00000000000000))*(r12));
IkReal x3412=((IkReal(1.00000000000000))*(cj6));
IkReal x3413=((cj6)*(r01));
IkReal x3414=((r11)*(sj6));
IkReal x3415=((r01)*(sj6));
IkReal x3416=((IkReal(1.00000000000000))*(cj5));
IkReal x3417=((IkReal(1.00000000000000))*(sj6));
IkReal x3418=((cj5)*(r11));
IkReal x3419=((cj6)*(r00));
IkReal x3420=((cj5)*(cj6));
IkReal x3421=((r02)*(sj5));
IkReal x3422=((cj6)*(r10));
IkReal x3423=((cj5)*(sj6));
IkReal x3424=((r10)*(sj6));
IkReal x3425=((cj5)*(r01));
IkReal x3426=((sj5)*(x3408));
IkReal x3427=((cj0)*(x3409));
IkReal x3428=((cj0)*(x3408));
IkReal x3429=((sj0)*(x3409));
IkReal x3430=((sj0)*(x3408));
IkReal x3431=((r20)*(x3409));
IkReal x3432=((r21)*(x3408));
IkReal x3433=((r21)*(x3409));
IkReal x3434=((r20)*(x3408));
IkReal x3435=((cj5)*(x3430));
evalcond[0]=((((r22)*(x3426)))+(((sj6)*(x3433)))+(((x3420)*(x3432)))+(((IkReal(-1.00000000000000))*(x3412)*(x3431)))+(((x3423)*(x3434))));
evalcond[1]=((((r22)*(sj5)*(x3409)))+(sj3)+(((cj6)*(x3434)))+(((x3423)*(x3431)))+(((x3420)*(x3433)))+(((IkReal(-1.00000000000000))*(x3417)*(x3432))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3414)*(x3427)))+(((IkReal(-1.00000000000000))*(r00)*(x3412)*(x3429)))+(((IkReal(-1.00000000000000))*(x3416)*(x3424)*(x3428)))+(((x3422)*(x3427)))+(((x3415)*(x3429)))+(((x3413)*(x3435)))+(cj2)+(((IkReal(-1.00000000000000))*(cj0)*(x3411)*(x3426)))+(((x3410)*(x3435)))+(((IkReal(-1.00000000000000))*(x3412)*(x3418)*(x3428)))+(((x3421)*(x3430))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x3415)*(x3430)))+(((IkReal(-1.00000000000000))*(x3412)*(x3418)*(x3427)))+(((x3419)*(x3430)))+(((IkReal(-1.00000000000000))*(sj5)*(x3411)*(x3427)))+(((cj5)*(x3410)*(x3429)))+(((IkReal(-1.00000000000000))*(r10)*(x3412)*(x3428)))+(((cj3)*(sj2)))+(((IkReal(-1.00000000000000))*(x3416)*(x3424)*(x3427)))+(((x3421)*(x3429)))+(((x3414)*(x3428)))+(((cj5)*(x3413)*(x3429))));
evalcond[4]=((((x3419)*(x3427)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x3421)*(x3428)))+(((IkReal(-1.00000000000000))*(x3412)*(x3425)*(x3428)))+(((IkReal(-1.00000000000000))*(x3412)*(x3418)*(x3430)))+(((x3422)*(x3429)))+(((IkReal(-1.00000000000000))*(x3410)*(x3416)*(x3428)))+(((IkReal(-1.00000000000000))*(x3414)*(x3429)))+(((IkReal(-1.00000000000000))*(sj0)*(x3411)*(x3426)))+(((IkReal(-1.00000000000000))*(x3415)*(x3427)))+(((IkReal(-1.00000000000000))*(x3416)*(x3424)*(x3430))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x3412)*(x3418)*(x3429)))+(((IkReal(-1.00000000000000))*(x3410)*(x3416)*(x3427)))+(((x3415)*(x3428)))+(((x3414)*(x3430)))+(((IkReal(-1.00000000000000))*(r00)*(x3412)*(x3428)))+(((IkReal(-1.00000000000000))*(x3416)*(x3424)*(x3429)))+(((cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(x3412)*(x3425)*(x3427)))+(((IkReal(-1.00000000000000))*(r10)*(x3412)*(x3430)))+(((IkReal(-1.00000000000000))*(sj5)*(x3411)*(x3429)))+(((IkReal(-1.00000000000000))*(x3421)*(x3427))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3436=((IkReal(1.00000000000000))*(sj2));
if( IKabs(((gconst78)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x3436)))+(((r21)*(sj2)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst78)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3436)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r21)*(x3436)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(sj6)*(x3436))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst78)*(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x3436)))+(((r21)*(sj2)*(sj6)))))), ((gconst78)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3436)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r21)*(x3436)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(sj6)*(x3436)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3437=IKsin(j4);
IkReal x3438=IKcos(j4);
IkReal x3439=((r00)*(sj6));
IkReal x3440=((cj6)*(r01));
IkReal x3441=((IkReal(1.00000000000000))*(cj0));
IkReal x3442=((IkReal(1.00000000000000))*(sj0));
IkReal x3443=((r10)*(sj6));
IkReal x3444=((sj5)*(x3437));
IkReal x3445=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x3446=((cj5)*(x3437));
IkReal x3447=((cj6)*(x3438));
IkReal x3448=((sj0)*(x3446));
IkReal x3449=((r01)*(sj6)*(x3438));
IkReal x3450=((r11)*(sj6)*(x3438));
evalcond[0]=((((r22)*(x3444)))+(((r21)*(sj6)*(x3438)))+(((r20)*(sj6)*(x3446)))+(((cj6)*(r21)*(x3446)))+(((IkReal(-1.00000000000000))*(r20)*(x3447))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r12)*(x3441)*(x3444)))+(((r02)*(sj0)*(x3444)))+(((sj0)*(x3449)))+(((x3440)*(x3448)))+(((IkReal(-1.00000000000000))*(x3441)*(x3450)))+(cj2)+(((cj0)*(r10)*(x3447)))+(((x3439)*(x3448)))+(((IkReal(-1.00000000000000))*(r00)*(x3442)*(x3447)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3441)*(x3446)))+(((IkReal(-1.00000000000000))*(x3441)*(x3443)*(x3446))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3440)*(x3441)*(x3446)))+(((IkReal(-1.00000000000000))*(x3442)*(x3443)*(x3446)))+(((IkReal(-1.00000000000000))*(x3439)*(x3441)*(x3446)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(r02)*(x3441)*(x3444)))+(((r10)*(sj0)*(x3447)))+(((cj0)*(r00)*(x3447)))+(((IkReal(-1.00000000000000))*(x3442)*(x3450)))+(((IkReal(-1.00000000000000))*(r12)*(x3442)*(x3444)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3442)*(x3446)))+(((IkReal(-1.00000000000000))*(x3441)*(x3449))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3451=((IkReal(1.00000000000000))*(sj5));
IkReal x3452=((cj6)*(r21));
IkReal x3453=((r20)*(sj6));
IkReal x3454=((IkReal(1.00000000000000))*(cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(x3452)*(x3454)))+(((IkReal(-1.00000000000000))*(x3453)*(x3454)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x3451)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x3451)*(x3452)))+(((IkReal(-1.00000000000000))*(x3451)*(x3453)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x3452)*(x3454)))+(((IkReal(-1.00000000000000))*(x3453)*(x3454)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x3451)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))+IKsqr(((((IkReal(-1.00000000000000))*(x3451)*(x3452)))+(((IkReal(-1.00000000000000))*(x3451)*(x3453)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x3452)*(x3454)))+(((IkReal(-1.00000000000000))*(x3453)*(x3454)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x3451)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))), ((((IkReal(-1.00000000000000))*(x3451)*(x3452)))+(((IkReal(-1.00000000000000))*(x3451)*(x3453)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3455=IKsin(j3);
IkReal x3456=IKcos(j3);
IkReal x3457=((sj0)*(sj5));
IkReal x3458=((r00)*(sj6));
IkReal x3459=((IkReal(1.00000000000000))*(cj4));
IkReal x3460=((cj6)*(r01));
IkReal x3461=((cj0)*(cj5));
IkReal x3462=((cj5)*(sj0));
IkReal x3463=((cj6)*(r11));
IkReal x3464=((cj0)*(sj5));
IkReal x3465=((cj6)*(sj4));
IkReal x3466=((cj4)*(cj5));
IkReal x3467=((cj6)*(r21));
IkReal x3468=((r20)*(sj6));
IkReal x3469=((r10)*(sj6));
IkReal x3470=((IkReal(1.00000000000000))*(cj0));
IkReal x3471=((IkReal(1.00000000000000))*(x3455));
IkReal x3472=((cj0)*(sj4)*(sj6));
IkReal x3473=((sj0)*(sj4)*(sj6));
evalcond[0]=((x3456)+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x3468)))+(((sj5)*(x3467))));
evalcond[1]=((((r20)*(x3465)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(x3455)+(((cj4)*(r22)*(sj5)))+(((x3466)*(x3468)))+(((x3466)*(x3467))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj2)*(x3471)))+(((IkReal(-1.00000000000000))*(r02)*(x3462)))+(((x3457)*(x3460)))+(((IkReal(-1.00000000000000))*(x3464)*(x3469)))+(((x3457)*(x3458)))+(((IkReal(-1.00000000000000))*(x3463)*(x3464)))+(((r12)*(x3461))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x3457)*(x3463)))+(((IkReal(-1.00000000000000))*(cj2)*(x3471)))+(((r02)*(x3461)))+(((IkReal(-1.00000000000000))*(x3460)*(x3464)))+(((r12)*(x3462)))+(((IkReal(-1.00000000000000))*(x3457)*(x3469)))+(((IkReal(-1.00000000000000))*(x3458)*(x3464))));
evalcond[4]=((((r00)*(sj0)*(x3465)))+(((cj4)*(x3458)*(x3462)))+(((IkReal(-1.00000000000000))*(r12)*(x3459)*(x3464)))+(((cj4)*(r02)*(x3457)))+(((IkReal(-1.00000000000000))*(r01)*(x3473)))+(((IkReal(-1.00000000000000))*(x3459)*(x3461)*(x3469)))+(((sj2)*(x3456)))+(((cj4)*(x3460)*(x3462)))+(((IkReal(-1.00000000000000))*(r10)*(x3465)*(x3470)))+(((IkReal(-1.00000000000000))*(x3459)*(x3461)*(x3463)))+(((r11)*(x3472))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x3458)*(x3459)*(x3461)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x3465)))+(((IkReal(-1.00000000000000))*(x3459)*(x3460)*(x3461)))+(((r01)*(x3472)))+(((cj2)*(x3456)))+(((IkReal(-1.00000000000000))*(r00)*(x3465)*(x3470)))+(((IkReal(-1.00000000000000))*(r02)*(x3459)*(x3464)))+(((r11)*(x3473)))+(((IkReal(-1.00000000000000))*(r12)*(x3457)*(x3459)))+(((IkReal(-1.00000000000000))*(x3459)*(x3462)*(x3469)))+(((IkReal(-1.00000000000000))*(x3459)*(x3462)*(x3463))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3474=((cj2)*(sj6));
IkReal x3475=((IkReal(1.00000000000000))*(r20));
IkReal x3476=((cj2)*(cj6));
if( IKabs(((gconst77)*(((((r21)*(x3474)))+(((IkReal(-1.00000000000000))*(x3475)*(x3476))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst77)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3476)))+(((IkReal(-1.00000000000000))*(cj5)*(x3474)*(x3475)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst77)*(((((r21)*(x3474)))+(((IkReal(-1.00000000000000))*(x3475)*(x3476)))))), ((gconst77)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3476)))+(((IkReal(-1.00000000000000))*(cj5)*(x3474)*(x3475)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3477=IKsin(j4);
IkReal x3478=IKcos(j4);
IkReal x3479=((r00)*(sj6));
IkReal x3480=((cj6)*(r01));
IkReal x3481=((IkReal(1.00000000000000))*(cj0));
IkReal x3482=((IkReal(1.00000000000000))*(sj0));
IkReal x3483=((r10)*(sj6));
IkReal x3484=((sj5)*(x3477));
IkReal x3485=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x3486=((cj5)*(x3477));
IkReal x3487=((cj6)*(x3478));
IkReal x3488=((sj0)*(x3486));
IkReal x3489=((r01)*(sj6)*(x3478));
IkReal x3490=((r11)*(sj6)*(x3478));
evalcond[0]=((((r20)*(sj6)*(x3486)))+(((cj6)*(r21)*(x3486)))+(((r21)*(sj6)*(x3478)))+(((IkReal(-1.00000000000000))*(r20)*(x3487)))+(((r22)*(x3484))));
evalcond[1]=((((sj0)*(x3489)))+(((IkReal(-1.00000000000000))*(r12)*(x3481)*(x3484)))+(((IkReal(-1.00000000000000))*(x3481)*(x3483)*(x3486)))+(((r02)*(sj0)*(x3484)))+(((cj0)*(r10)*(x3487)))+(((IkReal(-1.00000000000000))*(r00)*(x3482)*(x3487)))+(cj2)+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3481)*(x3486)))+(((x3479)*(x3488)))+(((x3480)*(x3488)))+(((IkReal(-1.00000000000000))*(x3481)*(x3490))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r02)*(x3481)*(x3484)))+(((IkReal(-1.00000000000000))*(x3482)*(x3483)*(x3486)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x3479)*(x3481)*(x3486)))+(((IkReal(-1.00000000000000))*(x3482)*(x3490)))+(((cj0)*(r00)*(x3487)))+(((IkReal(-1.00000000000000))*(r12)*(x3482)*(x3484)))+(((r10)*(sj0)*(x3487)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3482)*(x3486)))+(((IkReal(-1.00000000000000))*(x3480)*(x3481)*(x3486)))+(((IkReal(-1.00000000000000))*(x3481)*(x3489))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3491=((IkReal(1.00000000000000))*(sj5));
IkReal x3492=((cj6)*(r21));
IkReal x3493=((r20)*(sj6));
IkReal x3494=((IkReal(1.00000000000000))*(cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj4)*(r22)*(x3491)))+(((IkReal(-1.00000000000000))*(x3493)*(x3494)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x3492)*(x3494)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x3491)*(x3492)))+(((IkReal(-1.00000000000000))*(x3491)*(x3493)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj4)*(r22)*(x3491)))+(((IkReal(-1.00000000000000))*(x3493)*(x3494)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x3492)*(x3494)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))+IKsqr(((((IkReal(-1.00000000000000))*(x3491)*(x3492)))+(((IkReal(-1.00000000000000))*(x3491)*(x3493)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj4)*(r22)*(x3491)))+(((IkReal(-1.00000000000000))*(x3493)*(x3494)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x3492)*(x3494)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))), ((((IkReal(-1.00000000000000))*(x3491)*(x3492)))+(((IkReal(-1.00000000000000))*(x3491)*(x3493)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3495=IKsin(j3);
IkReal x3496=IKcos(j3);
IkReal x3497=((sj0)*(sj5));
IkReal x3498=((r00)*(sj6));
IkReal x3499=((IkReal(1.00000000000000))*(cj4));
IkReal x3500=((cj6)*(r01));
IkReal x3501=((cj0)*(cj5));
IkReal x3502=((cj5)*(sj0));
IkReal x3503=((cj6)*(r11));
IkReal x3504=((cj0)*(sj5));
IkReal x3505=((cj6)*(sj4));
IkReal x3506=((cj4)*(cj5));
IkReal x3507=((cj6)*(r21));
IkReal x3508=((r20)*(sj6));
IkReal x3509=((r10)*(sj6));
IkReal x3510=((IkReal(1.00000000000000))*(cj0));
IkReal x3511=((IkReal(1.00000000000000))*(x3495));
IkReal x3512=((cj0)*(sj4)*(sj6));
IkReal x3513=((sj0)*(sj4)*(sj6));
evalcond[0]=((x3496)+(((sj5)*(x3508)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x3507))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x3506)*(x3507)))+(x3495)+(((cj4)*(r22)*(sj5)))+(((x3506)*(x3508)))+(((r20)*(x3505))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3503)*(x3504)))+(((IkReal(-1.00000000000000))*(x3504)*(x3509)))+(((IkReal(-1.00000000000000))*(r02)*(x3502)))+(((r12)*(x3501)))+(((x3497)*(x3500)))+(((x3497)*(x3498)))+(((IkReal(-1.00000000000000))*(sj2)*(x3511))));
evalcond[3]=((((r02)*(x3501)))+(((IkReal(-1.00000000000000))*(x3497)*(x3509)))+(((IkReal(-1.00000000000000))*(x3498)*(x3504)))+(((IkReal(-1.00000000000000))*(x3500)*(x3504)))+(((IkReal(-1.00000000000000))*(x3497)*(x3503)))+(((IkReal(-1.00000000000000))*(cj2)*(x3511)))+(((r12)*(x3502))));
evalcond[4]=((((cj4)*(r02)*(x3497)))+(((IkReal(-1.00000000000000))*(r10)*(x3505)*(x3510)))+(((IkReal(-1.00000000000000))*(x3499)*(x3501)*(x3509)))+(((r00)*(sj0)*(x3505)))+(((IkReal(-1.00000000000000))*(x3499)*(x3501)*(x3503)))+(((IkReal(-1.00000000000000))*(r01)*(x3513)))+(((r11)*(x3512)))+(((cj4)*(x3500)*(x3502)))+(((sj2)*(x3496)))+(((cj4)*(x3498)*(x3502)))+(((IkReal(-1.00000000000000))*(r12)*(x3499)*(x3504))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x3499)*(x3502)*(x3509)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x3505)))+(((IkReal(-1.00000000000000))*(x3499)*(x3502)*(x3503)))+(((IkReal(-1.00000000000000))*(r02)*(x3499)*(x3504)))+(((IkReal(-1.00000000000000))*(x3498)*(x3499)*(x3501)))+(((r01)*(x3512)))+(((cj2)*(x3496)))+(((IkReal(-1.00000000000000))*(r12)*(x3497)*(x3499)))+(((r11)*(x3513)))+(((IkReal(-1.00000000000000))*(x3499)*(x3500)*(x3501)))+(((IkReal(-1.00000000000000))*(r00)*(x3505)*(x3510))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x3514=((cj6)*(r01));
IkReal x3515=((cj0)*(cj5));
IkReal x3516=((sj0)*(sj5));
IkReal x3517=((cj0)*(sj5));
IkReal x3518=((cj6)*(r11));
IkReal x3519=((r10)*(sj6));
IkReal x3520=((cj5)*(sj0));
IkReal x3521=((r00)*(sj6));
if( IKabs(((((IkReal(-5.42449275362319))*(x3516)*(x3521)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((IkReal(5.42449275362319))*(x3517)*(x3518)))+(((IkReal(-0.144927536231884))*(x3515)*(x3519)))+(((IkReal(5.42449275362319))*(x3517)*(x3519)))+(((IkReal(-0.144927536231884))*(r12)*(x3517)))+(((IkReal(0.144927536231884))*(x3514)*(x3520)))+(((IkReal(0.144927536231884))*(x3520)*(x3521)))+(((IkReal(-5.42449275362319))*(r12)*(x3515)))+(((IkReal(-0.144927536231884))*(x3515)*(x3518)))+(((IkReal(-5.42449275362319))*(x3514)*(x3516)))+(((IkReal(5.42449275362319))*(r02)*(x3520)))+(((IkReal(0.144927536231884))*(r02)*(x3516))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(0.0144927536231884))*(((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((IkReal(69.0000000000000))+(((IkReal(-374.290000000000))*(x3514)*(x3517)))+(((IkReal(10.0000000000000))*(x3515)*(x3521)))+(((IkReal(10.0000000000000))*(r02)*(x3517)))+(((IkReal(10.0000000000000))*(x3519)*(x3520)))+(((IkReal(-374.290000000000))*(x3517)*(x3521)))+(((IkReal(-1000.00000000000))*(cj0)*(px)))+(((IkReal(10.0000000000000))*(x3518)*(x3520)))+(((IkReal(364.420000000000))*(cj1)))+(((IkReal(10.0000000000000))*(x3514)*(x3515)))+(((IkReal(-374.290000000000))*(x3516)*(x3519)))+(((IkReal(-374.290000000000))*(x3516)*(x3518)))+(((IkReal(374.290000000000))*(r12)*(x3520)))+(((IkReal(374.290000000000))*(r02)*(x3515)))+(((IkReal(-1000.00000000000))*(py)*(sj0)))+(((IkReal(10.0000000000000))*(r12)*(x3516))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-5.42449275362319))*(x3516)*(x3521)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((IkReal(5.42449275362319))*(x3517)*(x3518)))+(((IkReal(-0.144927536231884))*(x3515)*(x3519)))+(((IkReal(5.42449275362319))*(x3517)*(x3519)))+(((IkReal(-0.144927536231884))*(r12)*(x3517)))+(((IkReal(0.144927536231884))*(x3514)*(x3520)))+(((IkReal(0.144927536231884))*(x3520)*(x3521)))+(((IkReal(-5.42449275362319))*(r12)*(x3515)))+(((IkReal(-0.144927536231884))*(x3515)*(x3518)))+(((IkReal(-5.42449275362319))*(x3514)*(x3516)))+(((IkReal(5.42449275362319))*(r02)*(x3520)))+(((IkReal(0.144927536231884))*(r02)*(x3516)))))+IKsqr(((IkReal(0.0144927536231884))*(((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((IkReal(69.0000000000000))+(((IkReal(-374.290000000000))*(x3514)*(x3517)))+(((IkReal(10.0000000000000))*(x3515)*(x3521)))+(((IkReal(10.0000000000000))*(r02)*(x3517)))+(((IkReal(10.0000000000000))*(x3519)*(x3520)))+(((IkReal(-374.290000000000))*(x3517)*(x3521)))+(((IkReal(-1000.00000000000))*(cj0)*(px)))+(((IkReal(10.0000000000000))*(x3518)*(x3520)))+(((IkReal(364.420000000000))*(cj1)))+(((IkReal(10.0000000000000))*(x3514)*(x3515)))+(((IkReal(-374.290000000000))*(x3516)*(x3519)))+(((IkReal(-374.290000000000))*(x3516)*(x3518)))+(((IkReal(374.290000000000))*(r12)*(x3520)))+(((IkReal(374.290000000000))*(r02)*(x3515)))+(((IkReal(-1000.00000000000))*(py)*(sj0)))+(((IkReal(10.0000000000000))*(r12)*(x3516)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((IkReal(-5.42449275362319))*(x3516)*(x3521)))+(((IkReal(14.4927536231884))*(cj0)*(py)))+(((IkReal(-14.4927536231884))*(px)*(sj0)))+(((IkReal(5.42449275362319))*(x3517)*(x3518)))+(((IkReal(-0.144927536231884))*(x3515)*(x3519)))+(((IkReal(5.42449275362319))*(x3517)*(x3519)))+(((IkReal(-0.144927536231884))*(r12)*(x3517)))+(((IkReal(0.144927536231884))*(x3514)*(x3520)))+(((IkReal(0.144927536231884))*(x3520)*(x3521)))+(((IkReal(-5.42449275362319))*(r12)*(x3515)))+(((IkReal(-0.144927536231884))*(x3515)*(x3518)))+(((IkReal(-5.42449275362319))*(x3514)*(x3516)))+(((IkReal(5.42449275362319))*(r02)*(x3520)))+(((IkReal(0.144927536231884))*(r02)*(x3516)))), ((IkReal(0.0144927536231884))*(((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((IkReal(69.0000000000000))+(((IkReal(-374.290000000000))*(x3514)*(x3517)))+(((IkReal(10.0000000000000))*(x3515)*(x3521)))+(((IkReal(10.0000000000000))*(r02)*(x3517)))+(((IkReal(10.0000000000000))*(x3519)*(x3520)))+(((IkReal(-374.290000000000))*(x3517)*(x3521)))+(((IkReal(-1000.00000000000))*(cj0)*(px)))+(((IkReal(10.0000000000000))*(x3518)*(x3520)))+(((IkReal(364.420000000000))*(cj1)))+(((IkReal(10.0000000000000))*(x3514)*(x3515)))+(((IkReal(-374.290000000000))*(x3516)*(x3519)))+(((IkReal(-374.290000000000))*(x3516)*(x3518)))+(((IkReal(374.290000000000))*(r12)*(x3520)))+(((IkReal(374.290000000000))*(r02)*(x3515)))+(((IkReal(-1000.00000000000))*(py)*(sj0)))+(((IkReal(10.0000000000000))*(r12)*(x3516)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[3];
IkReal x3522=IKcos(j2);
IkReal x3523=((IkReal(0.374290000000000))*(sj5));
IkReal x3524=((cj0)*(sj6));
IkReal x3525=((IkReal(0.0100000000000000))*(sj5));
IkReal x3526=((cj0)*(r02));
IkReal x3527=((IkReal(0.0100000000000000))*(cj5));
IkReal x3528=((IkReal(1.00000000000000))*(py));
IkReal x3529=((r01)*(sj0));
IkReal x3530=((r20)*(sj6));
IkReal x3531=((r11)*(sj0));
IkReal x3532=((IkReal(0.374290000000000))*(cj5));
IkReal x3533=((cj0)*(r12));
IkReal x3534=((sj0)*(x3532));
IkReal x3535=((cj6)*(x3527));
IkReal x3536=((IkReal(0.0690000000000000))*(x3522));
IkReal x3537=((r10)*(sj0)*(sj6));
IkReal x3538=((r00)*(sj0)*(sj6));
IkReal x3539=((cj0)*(cj6)*(x3523));
evalcond[0]=((((x3523)*(x3530)))+(((IkReal(0.364420000000000))*(sj1)))+(((cj1)*(x3536)))+(((IkReal(-1.00000000000000))*(r21)*(x3535)))+(((IkReal(-1.00000000000000))*(x3527)*(x3530)))+(((IkReal(-1.00000000000000))*(r22)*(x3532)))+(((cj6)*(r21)*(x3523)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x3525))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3529)*(x3535)))+(((x3532)*(x3533)))+(((x3525)*(x3533)))+(((r10)*(x3524)*(x3527)))+(((IkReal(-1.00000000000000))*(r11)*(x3539)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3525)))+(((cj6)*(x3523)*(x3529)))+(((x3523)*(x3538)))+(((IkReal(-1.00000000000000))*(x3527)*(x3538)))+(((IkReal(0.0690000000000000))*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(r10)*(x3523)*(x3524)))+(((IkReal(-1.00000000000000))*(r02)*(x3534)))+(((IkReal(-1.00000000000000))*(cj0)*(x3528)))+(((px)*(sj0)))+(((cj0)*(r11)*(x3535))));
evalcond[2]=((IkReal(0.0690000000000000))+(((x3526)*(x3532)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-1.00000000000000))*(r01)*(x3539)))+(((x3527)*(x3537)))+(((r12)*(sj0)*(x3525)))+(((IkReal(-1.00000000000000))*(cj6)*(x3523)*(x3531)))+(((r00)*(x3524)*(x3527)))+(((IkReal(-1.00000000000000))*(x3523)*(x3537)))+(((IkReal(-1.00000000000000))*(sj0)*(x3528)))+(((x3525)*(x3526)))+(((cj0)*(r01)*(x3535)))+(((IkReal(0.364420000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(r00)*(x3523)*(x3524)))+(((r12)*(x3534)))+(((IkReal(-1.00000000000000))*(sj1)*(x3536)))+(((x3531)*(x3535))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst0;
IkReal x3540=(cj6)*(cj6);
IkReal x3541=(sj6)*(sj6);
IkReal x3542=((IkReal(1.00000000000000))*(r01));
IkReal x3543=((sj0)*(sj5));
IkReal x3544=((cj6)*(r22));
IkReal x3545=((r21)*(sj6));
IkReal x3546=((r00)*(r21));
IkReal x3547=((cj0)*(sj5));
IkReal x3548=((cj6)*(r20));
IkReal x3549=((r22)*(sj6));
IkReal x3550=((cj0)*(cj5));
IkReal x3551=((IkReal(1.00000000000000))*(r10));
IkReal x3552=((cj5)*(sj0));
IkReal x3553=((r20)*(x3541));
IkReal x3554=((x3540)*(x3552));
gconst0=IKsign(((((r00)*(x3543)*(x3544)))+(((x3546)*(x3554)))+(((IkReal(-1.00000000000000))*(x3544)*(x3547)*(x3551)))+(((IkReal(-1.00000000000000))*(r21)*(x3541)*(x3550)*(x3551)))+(((IkReal(-1.00000000000000))*(r12)*(x3545)*(x3547)))+(((IkReal(-1.00000000000000))*(r20)*(x3542)*(x3554)))+(((r11)*(x3547)*(x3549)))+(((r12)*(x3547)*(x3548)))+(((r11)*(x3550)*(x3553)))+(((r11)*(r20)*(x3540)*(x3550)))+(((IkReal(-1.00000000000000))*(x3542)*(x3552)*(x3553)))+(((IkReal(-1.00000000000000))*(r21)*(x3540)*(x3550)*(x3551)))+(((IkReal(-1.00000000000000))*(x3542)*(x3543)*(x3549)))+(((IkReal(-1.00000000000000))*(r02)*(x3543)*(x3548)))+(((r02)*(x3543)*(x3545)))+(((x3541)*(x3546)*(x3552)))));
IkReal x3555=(cj6)*(cj6);
IkReal x3556=(sj6)*(sj6);
IkReal x3557=((IkReal(1.00000000000000))*(r01));
IkReal x3558=((sj0)*(sj5));
IkReal x3559=((cj6)*(r22));
IkReal x3560=((r21)*(sj6));
IkReal x3561=((r00)*(r21));
IkReal x3562=((cj0)*(sj5));
IkReal x3563=((cj6)*(r20));
IkReal x3564=((r22)*(sj6));
IkReal x3565=((cj0)*(cj5));
IkReal x3566=((IkReal(1.00000000000000))*(r10));
IkReal x3567=((cj5)*(sj0));
IkReal x3568=((r20)*(x3556));
IkReal x3569=((x3555)*(x3567));
dummyeval[0]=((((r11)*(x3562)*(x3564)))+(((IkReal(-1.00000000000000))*(x3557)*(x3558)*(x3564)))+(((IkReal(-1.00000000000000))*(r02)*(x3558)*(x3563)))+(((IkReal(-1.00000000000000))*(r21)*(x3555)*(x3565)*(x3566)))+(((r11)*(r20)*(x3555)*(x3565)))+(((r00)*(x3558)*(x3559)))+(((IkReal(-1.00000000000000))*(r21)*(x3556)*(x3565)*(x3566)))+(((r11)*(x3565)*(x3568)))+(((x3561)*(x3569)))+(((IkReal(-1.00000000000000))*(x3559)*(x3562)*(x3566)))+(((r02)*(x3558)*(x3560)))+(((IkReal(-1.00000000000000))*(r12)*(x3560)*(x3562)))+(((IkReal(-1.00000000000000))*(r20)*(x3557)*(x3569)))+(((r12)*(x3562)*(x3563)))+(((x3556)*(x3561)*(x3567)))+(((IkReal(-1.00000000000000))*(x3557)*(x3567)*(x3568))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
IkReal x3570=(cj6)*(cj6);
IkReal x3571=(sj6)*(sj6);
IkReal x3572=((sj5)*(sj6));
IkReal x3573=((IkReal(1.00000000000000))*(cj0));
IkReal x3574=((cj6)*(sj5));
IkReal x3575=((r20)*(sj0));
IkReal x3576=((cj0)*(r20));
IkReal x3577=((r00)*(r21));
IkReal x3578=((r22)*(sj0));
IkReal x3579=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x3580=((cj5)*(x3571));
IkReal x3581=((cj5)*(x3570));
gconst1=IKsign(((((IkReal(-1.00000000000000))*(x3573)*(x3577)*(x3580)))+(((IkReal(-1.00000000000000))*(r10)*(x3579)*(x3580)))+(((r02)*(x3574)*(x3576)))+(((r12)*(x3574)*(x3575)))+(((r11)*(x3575)*(x3580)))+(((IkReal(-1.00000000000000))*(r10)*(x3579)*(x3581)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x3572)*(x3573)))+(((IkReal(-1.00000000000000))*(r10)*(x3574)*(x3578)))+(((r11)*(x3575)*(x3581)))+(((r01)*(x3576)*(x3580)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x3573)*(x3574)))+(((r11)*(x3572)*(x3578)))+(((r01)*(x3576)*(x3581)))+(((cj0)*(r01)*(r22)*(x3572)))+(((IkReal(-1.00000000000000))*(r12)*(x3572)*(x3579)))+(((IkReal(-1.00000000000000))*(x3573)*(x3577)*(x3581)))));
IkReal x3582=(cj6)*(cj6);
IkReal x3583=(sj6)*(sj6);
IkReal x3584=((sj5)*(sj6));
IkReal x3585=((IkReal(1.00000000000000))*(cj0));
IkReal x3586=((cj6)*(sj5));
IkReal x3587=((r20)*(sj0));
IkReal x3588=((cj0)*(r20));
IkReal x3589=((r00)*(r21));
IkReal x3590=((r22)*(sj0));
IkReal x3591=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x3592=((cj5)*(x3583));
IkReal x3593=((cj5)*(x3582));
dummyeval[0]=((((r02)*(x3586)*(x3588)))+(((r11)*(x3584)*(x3590)))+(((r11)*(x3587)*(x3592)))+(((IkReal(-1.00000000000000))*(r10)*(x3591)*(x3593)))+(((IkReal(-1.00000000000000))*(r10)*(x3586)*(x3590)))+(((r01)*(x3588)*(x3593)))+(((IkReal(-1.00000000000000))*(r10)*(x3591)*(x3592)))+(((cj0)*(r01)*(r22)*(x3584)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x3584)*(x3585)))+(((IkReal(-1.00000000000000))*(x3585)*(x3589)*(x3592)))+(((IkReal(-1.00000000000000))*(r12)*(x3584)*(x3591)))+(((r01)*(x3588)*(x3592)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x3585)*(x3586)))+(((r11)*(x3587)*(x3593)))+(((r12)*(x3586)*(x3587)))+(((IkReal(-1.00000000000000))*(x3585)*(x3589)*(x3593))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
IkReal x3594=(cj1)*(cj1);
IkReal x3595=(sj1)*(sj1);
dummyeval[0]=((((cj2)*(x3594)))+(((cj2)*(x3595))));
dummyeval[1]=((x3595)+(x3594));
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
IkReal x3596=((IkReal(0.374290000000000))*(sj5));
IkReal x3597=((cj0)*(sj6));
IkReal x3598=((IkReal(0.0100000000000000))*(sj5));
IkReal x3599=((cj0)*(r02));
IkReal x3600=((IkReal(0.0100000000000000))*(cj5));
IkReal x3601=((IkReal(1.00000000000000))*(py));
IkReal x3602=((r01)*(sj0));
IkReal x3603=((r20)*(sj6));
IkReal x3604=((r11)*(sj0));
IkReal x3605=((IkReal(0.374290000000000))*(cj5));
IkReal x3606=((cj0)*(r12));
IkReal x3607=((sj0)*(x3605));
IkReal x3608=((cj6)*(x3600));
IkReal x3609=((r10)*(sj0)*(sj6));
IkReal x3610=((r00)*(sj0)*(sj6));
IkReal x3611=((cj0)*(cj6)*(x3596));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(0.364420000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(r22)*(x3598)))+(((IkReal(-1.00000000000000))*(r21)*(x3608)))+(((cj6)*(r21)*(x3596)))+(((x3596)*(x3603)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x3605)))+(((IkReal(-1.00000000000000))*(x3600)*(x3603))));
evalcond[2]=((IkReal(0.0690000000000000))+(((r10)*(x3597)*(x3600)))+(((IkReal(-1.00000000000000))*(x3600)*(x3610)))+(((IkReal(-1.00000000000000))*(cj0)*(x3601)))+(((x3596)*(x3610)))+(((cj0)*(r11)*(x3608)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3598)))+(((IkReal(-1.00000000000000))*(x3602)*(x3608)))+(((x3598)*(x3606)))+(((IkReal(-1.00000000000000))*(r11)*(x3611)))+(((x3605)*(x3606)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(r02)*(x3607)))+(((cj6)*(x3596)*(x3602)))+(((IkReal(-1.00000000000000))*(r10)*(x3596)*(x3597))));
evalcond[3]=((IkReal(0.0690000000000000))+(((x3599)*(x3605)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((r12)*(sj0)*(x3598)))+(((IkReal(-1.00000000000000))*(sj0)*(x3601)))+(((x3600)*(x3609)))+(((IkReal(-1.00000000000000))*(r01)*(x3611)))+(((IkReal(-1.00000000000000))*(x3596)*(x3609)))+(((x3604)*(x3608)))+(((cj0)*(r01)*(x3608)))+(((IkReal(-1.00000000000000))*(cj6)*(x3596)*(x3604)))+(((r00)*(x3597)*(x3600)))+(((IkReal(0.364420000000000))*(cj1)))+(((r12)*(x3607)))+(((IkReal(-1.00000000000000))*(r00)*(x3596)*(x3597)))+(((x3598)*(x3599))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst13;
IkReal x3612=(cj6)*(cj6);
IkReal x3613=(sj6)*(sj6);
IkReal x3614=((IkReal(1.00000000000000))*(r21));
IkReal x3615=((cj6)*(r20));
IkReal x3616=((r22)*(sj5));
IkReal x3617=((r01)*(sj0));
IkReal x3618=((r00)*(sj0));
IkReal x3619=((cj0)*(r10));
IkReal x3620=((r02)*(sj0)*(sj5));
IkReal x3621=((cj5)*(x3612));
IkReal x3622=((cj0)*(r12)*(sj5));
IkReal x3623=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3624=((cj5)*(x3613));
IkReal x3625=((r20)*(x3624));
gconst13=IKsign(((((r20)*(x3617)*(x3621)))+(((IkReal(-1.00000000000000))*(x3614)*(x3618)*(x3621)))+(((sj6)*(x3616)*(x3617)))+(((x3615)*(x3620)))+(((x3617)*(x3625)))+(((IkReal(-1.00000000000000))*(x3623)*(x3625)))+(((r21)*(sj6)*(x3622)))+(((r21)*(x3619)*(x3624)))+(((r21)*(x3619)*(x3621)))+(((IkReal(-1.00000000000000))*(x3614)*(x3618)*(x3624)))+(((IkReal(-1.00000000000000))*(sj6)*(x3614)*(x3620)))+(((cj6)*(x3616)*(x3619)))+(((IkReal(-1.00000000000000))*(sj6)*(x3616)*(x3623)))+(((IkReal(-1.00000000000000))*(cj6)*(x3616)*(x3618)))+(((IkReal(-1.00000000000000))*(r20)*(x3621)*(x3623)))+(((IkReal(-1.00000000000000))*(x3615)*(x3622)))));
IkReal x3626=(cj6)*(cj6);
IkReal x3627=(sj6)*(sj6);
IkReal x3628=((IkReal(1.00000000000000))*(r21));
IkReal x3629=((cj6)*(r20));
IkReal x3630=((r22)*(sj5));
IkReal x3631=((r01)*(sj0));
IkReal x3632=((r00)*(sj0));
IkReal x3633=((cj0)*(r10));
IkReal x3634=((r02)*(sj0)*(sj5));
IkReal x3635=((cj5)*(x3626));
IkReal x3636=((cj0)*(r12)*(sj5));
IkReal x3637=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3638=((cj5)*(x3627));
IkReal x3639=((r20)*(x3638));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3637)*(x3639)))+(((r21)*(sj6)*(x3636)))+(((IkReal(-1.00000000000000))*(sj6)*(x3630)*(x3637)))+(((sj6)*(x3630)*(x3631)))+(((IkReal(-1.00000000000000))*(x3628)*(x3632)*(x3635)))+(((cj6)*(x3630)*(x3633)))+(((IkReal(-1.00000000000000))*(x3629)*(x3636)))+(((IkReal(-1.00000000000000))*(sj6)*(x3628)*(x3634)))+(((x3631)*(x3639)))+(((r20)*(x3631)*(x3635)))+(((IkReal(-1.00000000000000))*(x3628)*(x3632)*(x3638)))+(((IkReal(-1.00000000000000))*(r20)*(x3635)*(x3637)))+(((r21)*(x3633)*(x3635)))+(((x3629)*(x3634)))+(((IkReal(-1.00000000000000))*(cj6)*(x3630)*(x3632)))+(((r21)*(x3633)*(x3638))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst14;
IkReal x3640=(cj6)*(cj6);
IkReal x3641=(sj6)*(sj6);
IkReal x3642=((sj5)*(sj6));
IkReal x3643=((IkReal(1.00000000000000))*(cj0));
IkReal x3644=((cj6)*(sj5));
IkReal x3645=((r20)*(sj0));
IkReal x3646=((cj0)*(r20));
IkReal x3647=((r00)*(r21));
IkReal x3648=((r22)*(sj0));
IkReal x3649=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x3650=((cj5)*(x3641));
IkReal x3651=((cj5)*(x3640));
gconst14=IKsign(((((cj0)*(r01)*(r22)*(x3642)))+(((r11)*(x3645)*(x3651)))+(((r01)*(x3646)*(x3651)))+(((IkReal(-1.00000000000000))*(x3643)*(x3647)*(x3650)))+(((r02)*(x3644)*(x3646)))+(((r12)*(x3644)*(x3645)))+(((r01)*(x3646)*(x3650)))+(((IkReal(-1.00000000000000))*(r10)*(x3649)*(x3651)))+(((r11)*(x3645)*(x3650)))+(((IkReal(-1.00000000000000))*(r12)*(x3642)*(x3649)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x3643)*(x3644)))+(((IkReal(-1.00000000000000))*(r10)*(x3649)*(x3650)))+(((IkReal(-1.00000000000000))*(x3643)*(x3647)*(x3651)))+(((IkReal(-1.00000000000000))*(r10)*(x3644)*(x3648)))+(((r11)*(x3642)*(x3648)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x3642)*(x3643)))));
IkReal x3652=(cj6)*(cj6);
IkReal x3653=(sj6)*(sj6);
IkReal x3654=((sj5)*(sj6));
IkReal x3655=((IkReal(1.00000000000000))*(cj0));
IkReal x3656=((cj6)*(sj5));
IkReal x3657=((r20)*(sj0));
IkReal x3658=((cj0)*(r20));
IkReal x3659=((r00)*(r21));
IkReal x3660=((r22)*(sj0));
IkReal x3661=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x3662=((cj5)*(x3653));
IkReal x3663=((cj5)*(x3652));
dummyeval[0]=((((cj0)*(r01)*(r22)*(x3654)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x3655)*(x3656)))+(((r11)*(x3657)*(x3663)))+(((r11)*(x3657)*(x3662)))+(((IkReal(-1.00000000000000))*(x3655)*(x3659)*(x3663)))+(((r12)*(x3656)*(x3657)))+(((IkReal(-1.00000000000000))*(r10)*(x3656)*(x3660)))+(((IkReal(-1.00000000000000))*(r12)*(x3654)*(x3661)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x3654)*(x3655)))+(((r01)*(x3658)*(x3662)))+(((r11)*(x3654)*(x3660)))+(((IkReal(-1.00000000000000))*(r10)*(x3661)*(x3663)))+(((r01)*(x3658)*(x3663)))+(((IkReal(-1.00000000000000))*(x3655)*(x3659)*(x3662)))+(((IkReal(-1.00000000000000))*(r10)*(x3661)*(x3662)))+(((r02)*(x3656)*(x3658))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x3664=((cj5)*(r22));
IkReal x3665=((IkReal(0.374290000000000))*(sj5));
IkReal x3666=((cj0)*(sj6));
IkReal x3667=((cj6)*(r21));
IkReal x3668=((IkReal(0.0100000000000000))*(sj5));
IkReal x3669=((cj0)*(r02));
IkReal x3670=((IkReal(0.0100000000000000))*(cj5));
IkReal x3671=((IkReal(1.00000000000000))*(py));
IkReal x3672=((r01)*(sj0));
IkReal x3673=((r20)*(sj6));
IkReal x3674=((r11)*(sj0));
IkReal x3675=((IkReal(0.374290000000000))*(cj5));
IkReal x3676=((cj0)*(r12));
IkReal x3677=((sj0)*(x3675));
IkReal x3678=((cj6)*(x3670));
IkReal x3679=((r10)*(sj0)*(sj6));
IkReal x3680=((r00)*(sj0)*(sj6));
IkReal x3681=((cj0)*(cj6)*(x3665));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x3667)))+(((IkReal(-1.00000000000000))*(x3664)))+(((sj5)*(x3673))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3670)*(x3673)))+(((IkReal(-1.00000000000000))*(r22)*(x3668)))+(pz)+(((x3665)*(x3673)))+(((IkReal(-0.374290000000000))*(x3664)))+(((IkReal(-1.00000000000000))*(x3667)*(x3670)))+(((x3665)*(x3667))));
evalcond[3]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(x3671)))+(((x3668)*(x3676)))+(((IkReal(-1.00000000000000))*(r10)*(x3665)*(x3666)))+(((x3665)*(x3680)))+(((IkReal(-1.00000000000000))*(x3670)*(x3680)))+(((IkReal(-1.00000000000000))*(r02)*(x3677)))+(((cj0)*(r11)*(x3678)))+(((r10)*(x3666)*(x3670)))+(((x3675)*(x3676)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3668)))+(((IkReal(-1.00000000000000))*(x3672)*(x3678)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(r11)*(x3681)))+(((cj6)*(x3665)*(x3672))));
evalcond[4]=((IkReal(0.433420000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-1.00000000000000))*(cj6)*(x3665)*(x3674)))+(((r12)*(x3677)))+(((x3674)*(x3678)))+(((x3668)*(x3669)))+(((IkReal(-1.00000000000000))*(sj0)*(x3671)))+(((x3670)*(x3679)))+(((IkReal(-1.00000000000000))*(r00)*(x3665)*(x3666)))+(((r00)*(x3666)*(x3670)))+(((IkReal(-1.00000000000000))*(r01)*(x3681)))+(((IkReal(-1.00000000000000))*(x3665)*(x3679)))+(((r12)*(sj0)*(x3668)))+(((x3669)*(x3675)))+(((cj0)*(r01)*(x3678))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3682=((cj0)*(cj5));
IkReal x3683=((IkReal(1.00000000000000))*(cj0));
IkReal x3684=((cj6)*(r11));
IkReal x3685=((r10)*(sj6));
IkReal x3686=((cj5)*(sj0));
IkReal x3687=((r00)*(sj5)*(sj6));
IkReal x3688=((cj6)*(r01)*(sj5));
IkReal x3689=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r02)*(x3686)))+(((sj0)*(x3687)))+(((IkReal(-1.00000000000000))*(sj5)*(x3683)*(x3684)))+(((IkReal(-1.00000000000000))*(sj5)*(x3683)*(x3685)))+(((r12)*(x3682)))+(((sj0)*(x3688))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r02)*(x3682)))+(((IkReal(-1.00000000000000))*(x3685)*(x3689)))+(((IkReal(-1.00000000000000))*(x3683)*(x3687)))+(((r12)*(x3686)))+(((IkReal(-1.00000000000000))*(x3684)*(x3689)))+(((IkReal(-1.00000000000000))*(x3683)*(x3688))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r02)*(x3686)))+(((sj0)*(x3687)))+(((IkReal(-1.00000000000000))*(sj5)*(x3683)*(x3684)))+(((IkReal(-1.00000000000000))*(sj5)*(x3683)*(x3685)))+(((r12)*(x3682)))+(((sj0)*(x3688)))))+IKsqr(((((r02)*(x3682)))+(((IkReal(-1.00000000000000))*(x3685)*(x3689)))+(((IkReal(-1.00000000000000))*(x3683)*(x3687)))+(((r12)*(x3686)))+(((IkReal(-1.00000000000000))*(x3684)*(x3689)))+(((IkReal(-1.00000000000000))*(x3683)*(x3688)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r02)*(x3686)))+(((sj0)*(x3687)))+(((IkReal(-1.00000000000000))*(sj5)*(x3683)*(x3684)))+(((IkReal(-1.00000000000000))*(sj5)*(x3683)*(x3685)))+(((r12)*(x3682)))+(((sj0)*(x3688)))), ((((r02)*(x3682)))+(((IkReal(-1.00000000000000))*(x3685)*(x3689)))+(((IkReal(-1.00000000000000))*(x3683)*(x3687)))+(((r12)*(x3686)))+(((IkReal(-1.00000000000000))*(x3684)*(x3689)))+(((IkReal(-1.00000000000000))*(x3683)*(x3688)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x3690=((cj0)*(cj5));
IkReal x3691=((IkReal(1.00000000000000))*(cj0));
IkReal x3692=((cj6)*(r11));
IkReal x3693=((r10)*(sj6));
IkReal x3694=((cj5)*(sj0));
IkReal x3695=((r00)*(sj5)*(sj6));
IkReal x3696=((cj6)*(r01)*(sj5));
IkReal x3697=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj5)*(x3691)*(x3692)))+(((sj0)*(x3696)))+(((IkReal(-1.00000000000000))*(sj5)*(x3691)*(x3693)))+(((IkReal(-1.00000000000000))*(r02)*(x3694)))+(((sj0)*(x3695)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((r12)*(x3690))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3692)*(x3697)))+(((IkReal(-1.00000000000000))*(x3691)*(x3696)))+(((IkReal(-1.00000000000000))*(x3691)*(x3695)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(x3693)*(x3697)))+(((r02)*(x3690)))+(((r12)*(x3694))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst20;
IkReal x3698=(cj5)*(cj5);
IkReal x3699=(r20)*(r20);
IkReal x3700=(sj6)*(sj6);
IkReal x3701=(cj6)*(cj6);
IkReal x3702=(r21)*(r21);
IkReal x3703=((cj6)*(r21));
IkReal x3704=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3705=((cj5)*(r22)*(sj5));
gconst20=IKsign(((((x3698)*(x3699)*(x3700)))+(((x3700)*(x3702)))+(((x3704)*(x3705)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3698)*(x3703)*(x3704)))+(((x3698)*(x3701)*(x3702)))+(((x3699)*(x3701)))+(((IkReal(-1.00000000000000))*(x3703)*(x3704)))+(((IkReal(2.00000000000000))*(x3703)*(x3705)))));
IkReal x3706=(cj5)*(cj5);
IkReal x3707=(r20)*(r20);
IkReal x3708=(sj6)*(sj6);
IkReal x3709=(cj6)*(cj6);
IkReal x3710=(r21)*(r21);
IkReal x3711=((cj6)*(r21));
IkReal x3712=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3713=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x3706)*(x3707)*(x3708)))+(((IkReal(2.00000000000000))*(x3711)*(x3713)))+(((x3707)*(x3709)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3706)*(x3709)*(x3710)))+(((IkReal(-1.00000000000000))*(x3711)*(x3712)))+(((x3712)*(x3713)))+(((x3708)*(x3710)))+(((x3706)*(x3711)*(x3712))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst21;
IkReal x3714=(cj6)*(cj6);
IkReal x3715=(sj6)*(sj6);
IkReal x3716=((IkReal(1.00000000000000))*(r21));
IkReal x3717=((cj6)*(r20));
IkReal x3718=((r22)*(sj5));
IkReal x3719=((r01)*(sj0));
IkReal x3720=((r00)*(sj0));
IkReal x3721=((cj0)*(r10));
IkReal x3722=((r02)*(sj0)*(sj5));
IkReal x3723=((cj5)*(x3714));
IkReal x3724=((cj0)*(r12)*(sj5));
IkReal x3725=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3726=((cj5)*(x3715));
IkReal x3727=((r20)*(x3726));
gconst21=IKsign(((((IkReal(-1.00000000000000))*(r20)*(x3723)*(x3725)))+(((cj6)*(x3718)*(x3721)))+(((IkReal(-1.00000000000000))*(x3717)*(x3724)))+(((IkReal(-1.00000000000000))*(cj6)*(x3718)*(x3720)))+(((IkReal(-1.00000000000000))*(sj6)*(x3718)*(x3725)))+(((IkReal(-1.00000000000000))*(sj6)*(x3716)*(x3722)))+(((r21)*(sj6)*(x3724)))+(((x3717)*(x3722)))+(((r20)*(x3719)*(x3723)))+(((r21)*(x3721)*(x3726)))+(((x3719)*(x3727)))+(((IkReal(-1.00000000000000))*(x3725)*(x3727)))+(((r21)*(x3721)*(x3723)))+(((IkReal(-1.00000000000000))*(x3716)*(x3720)*(x3726)))+(((IkReal(-1.00000000000000))*(x3716)*(x3720)*(x3723)))+(((sj6)*(x3718)*(x3719)))));
IkReal x3728=(cj6)*(cj6);
IkReal x3729=(sj6)*(sj6);
IkReal x3730=((IkReal(1.00000000000000))*(r21));
IkReal x3731=((cj6)*(r20));
IkReal x3732=((r22)*(sj5));
IkReal x3733=((r01)*(sj0));
IkReal x3734=((r00)*(sj0));
IkReal x3735=((cj0)*(r10));
IkReal x3736=((r02)*(sj0)*(sj5));
IkReal x3737=((cj5)*(x3728));
IkReal x3738=((cj0)*(r12)*(sj5));
IkReal x3739=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3740=((cj5)*(x3729));
IkReal x3741=((r20)*(x3740));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3730)*(x3734)*(x3737)))+(((sj6)*(x3732)*(x3733)))+(((x3731)*(x3736)))+(((r21)*(sj6)*(x3738)))+(((cj6)*(x3732)*(x3735)))+(((r21)*(x3735)*(x3740)))+(((r20)*(x3733)*(x3737)))+(((IkReal(-1.00000000000000))*(x3731)*(x3738)))+(((IkReal(-1.00000000000000))*(x3739)*(x3741)))+(((r21)*(x3735)*(x3737)))+(((x3733)*(x3741)))+(((IkReal(-1.00000000000000))*(sj6)*(x3730)*(x3736)))+(((IkReal(-1.00000000000000))*(r20)*(x3737)*(x3739)))+(((IkReal(-1.00000000000000))*(x3730)*(x3734)*(x3740)))+(((IkReal(-1.00000000000000))*(cj6)*(x3732)*(x3734)))+(((IkReal(-1.00000000000000))*(sj6)*(x3732)*(x3739))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3742=((sj0)*(sj6));
IkReal x3743=((cj0)*(cj6));
IkReal x3744=((IkReal(1.00000000000000))*(cj5));
IkReal x3745=((cj6)*(sj0));
IkReal x3746=((cj0)*(sj6));
if( IKabs(((gconst21)*(((((IkReal(-1.00000000000000))*(r00)*(x3745)))+(((IkReal(-1.00000000000000))*(r11)*(x3746)))+(((r10)*(x3743)))+(((r01)*(x3742))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst21)*(((((cj5)*(r11)*(x3743)))+(((IkReal(-1.00000000000000))*(r00)*(x3742)*(x3744)))+(((IkReal(-1.00000000000000))*(r01)*(x3744)*(x3745)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(r10)*(x3746))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst21)*(((((IkReal(-1.00000000000000))*(r00)*(x3745)))+(((IkReal(-1.00000000000000))*(r11)*(x3746)))+(((r10)*(x3743)))+(((r01)*(x3742)))))), ((gconst21)*(((((cj5)*(r11)*(x3743)))+(((IkReal(-1.00000000000000))*(r00)*(x3742)*(x3744)))+(((IkReal(-1.00000000000000))*(r01)*(x3744)*(x3745)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(r10)*(x3746)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3747=IKsin(j4);
IkReal x3748=IKcos(j4);
IkReal x3749=((r22)*(sj5));
IkReal x3750=((IkReal(1.00000000000000))*(cj6));
IkReal x3751=((IkReal(1.00000000000000))*(cj0));
IkReal x3752=((cj5)*(r11));
IkReal x3753=((cj5)*(cj6));
IkReal x3754=((r11)*(sj6));
IkReal x3755=((IkReal(1.00000000000000))*(sj6));
IkReal x3756=((cj6)*(r00));
IkReal x3757=((r12)*(sj5));
IkReal x3758=((r02)*(sj5));
IkReal x3759=((cj6)*(r10));
IkReal x3760=((cj5)*(sj6));
IkReal x3761=((cj5)*(r01));
IkReal x3762=((sj0)*(x3747));
IkReal x3763=((r00)*(x3760));
IkReal x3764=((cj0)*(x3747));
IkReal x3765=((sj0)*(x3748));
IkReal x3766=((r20)*(x3748));
IkReal x3767=((cj0)*(x3748));
IkReal x3768=((r21)*(x3747));
IkReal x3769=((r21)*(x3748));
IkReal x3770=((r20)*(x3747));
IkReal x3771=((x3748)*(x3757));
IkReal x3772=((r01)*(sj6)*(x3748));
IkReal x3773=((cj5)*(r10)*(x3755));
evalcond[0]=((IkReal(-1.00000000000000))+(((x3753)*(x3768)))+(((x3747)*(x3749)))+(((x3760)*(x3770)))+(((sj6)*(x3769)))+(((IkReal(-1.00000000000000))*(x3750)*(x3766))));
evalcond[1]=((((cj6)*(x3770)))+(((x3753)*(x3769)))+(((x3760)*(x3766)))+(((x3748)*(x3749)))+(((IkReal(-1.00000000000000))*(x3755)*(x3768))));
evalcond[2]=((((x3759)*(x3767)))+(((x3762)*(x3763)))+(((r01)*(sj6)*(x3765)))+(((IkReal(-1.00000000000000))*(x3748)*(x3751)*(x3754)))+(((r01)*(x3753)*(x3762)))+(((IkReal(-1.00000000000000))*(r00)*(x3750)*(x3765)))+(((IkReal(-1.00000000000000))*(x3750)*(x3752)*(x3764)))+(((x3758)*(x3762)))+(((IkReal(-1.00000000000000))*(x3747)*(x3751)*(x3757)))+(((IkReal(-1.00000000000000))*(r10)*(x3747)*(x3751)*(x3760))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x3750)*(x3764)))+(((IkReal(-1.00000000000000))*(x3750)*(x3752)*(x3767)))+(((IkReal(-1.00000000000000))*(r01)*(x3755)*(x3762)))+(((x3754)*(x3764)))+(((IkReal(-1.00000000000000))*(x3751)*(x3771)))+(((x3756)*(x3762)))+(cj3)+(((IkReal(-1.00000000000000))*(r10)*(x3748)*(x3751)*(x3760)))+(((r01)*(x3753)*(x3765)))+(((x3758)*(x3765)))+(((x3763)*(x3765))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3750)*(x3752)*(x3762)))+(((IkReal(-1.00000000000000))*(x3747)*(x3751)*(x3758)))+(((IkReal(-1.00000000000000))*(x3762)*(x3773)))+(((IkReal(-1.00000000000000))*(x3757)*(x3762)))+(((IkReal(-1.00000000000000))*(x3754)*(x3765)))+(((IkReal(-1.00000000000000))*(x3750)*(x3761)*(x3764)))+(((IkReal(-1.00000000000000))*(x3751)*(x3772)))+(((x3759)*(x3765)))+(((IkReal(-1.00000000000000))*(x3747)*(x3751)*(x3763)))+(((x3756)*(x3767))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3750)*(x3762)))+(((IkReal(-1.00000000000000))*(x3757)*(x3765)))+(((IkReal(-1.00000000000000))*(x3750)*(x3752)*(x3765)))+(((IkReal(-1.00000000000000))*(x3748)*(x3751)*(x3758)))+(((IkReal(-1.00000000000000))*(r00)*(x3750)*(x3764)))+(((IkReal(-1.00000000000000))*(x3750)*(x3761)*(x3767)))+(((IkReal(-1.00000000000000))*(x3765)*(x3773)))+(((x3754)*(x3762)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x3748)*(x3751)*(x3763)))+(((r01)*(sj6)*(x3764))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst20)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst20)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst20)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst20)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3774=IKsin(j4);
IkReal x3775=IKcos(j4);
IkReal x3776=((r22)*(sj5));
IkReal x3777=((IkReal(1.00000000000000))*(cj6));
IkReal x3778=((IkReal(1.00000000000000))*(cj0));
IkReal x3779=((cj5)*(r11));
IkReal x3780=((cj5)*(cj6));
IkReal x3781=((r11)*(sj6));
IkReal x3782=((IkReal(1.00000000000000))*(sj6));
IkReal x3783=((cj6)*(r00));
IkReal x3784=((r12)*(sj5));
IkReal x3785=((r02)*(sj5));
IkReal x3786=((cj6)*(r10));
IkReal x3787=((cj5)*(sj6));
IkReal x3788=((cj5)*(r01));
IkReal x3789=((sj0)*(x3774));
IkReal x3790=((r00)*(x3787));
IkReal x3791=((cj0)*(x3774));
IkReal x3792=((sj0)*(x3775));
IkReal x3793=((r20)*(x3775));
IkReal x3794=((cj0)*(x3775));
IkReal x3795=((r21)*(x3774));
IkReal x3796=((r21)*(x3775));
IkReal x3797=((r20)*(x3774));
IkReal x3798=((x3775)*(x3784));
IkReal x3799=((r01)*(sj6)*(x3775));
IkReal x3800=((cj5)*(r10)*(x3782));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x3777)*(x3793)))+(((x3787)*(x3797)))+(((x3780)*(x3795)))+(((x3774)*(x3776)))+(((sj6)*(x3796))));
evalcond[1]=((((x3787)*(x3793)))+(((IkReal(-1.00000000000000))*(x3782)*(x3795)))+(((x3775)*(x3776)))+(((x3780)*(x3796)))+(((cj6)*(x3797))));
evalcond[2]=((((x3789)*(x3790)))+(((IkReal(-1.00000000000000))*(x3775)*(x3778)*(x3781)))+(((x3785)*(x3789)))+(((IkReal(-1.00000000000000))*(x3774)*(x3778)*(x3784)))+(((r01)*(sj6)*(x3792)))+(((r01)*(x3780)*(x3789)))+(((x3786)*(x3794)))+(((IkReal(-1.00000000000000))*(r00)*(x3777)*(x3792)))+(((IkReal(-1.00000000000000))*(x3777)*(x3779)*(x3791)))+(((IkReal(-1.00000000000000))*(r10)*(x3774)*(x3778)*(x3787))));
evalcond[3]=((((x3785)*(x3792)))+(((IkReal(-1.00000000000000))*(r10)*(x3775)*(x3778)*(x3787)))+(((IkReal(-1.00000000000000))*(x3778)*(x3798)))+(((x3783)*(x3789)))+(cj3)+(((IkReal(-1.00000000000000))*(x3777)*(x3779)*(x3794)))+(((IkReal(-1.00000000000000))*(r10)*(x3777)*(x3791)))+(((r01)*(x3780)*(x3792)))+(((x3781)*(x3791)))+(((x3790)*(x3792)))+(((IkReal(-1.00000000000000))*(r01)*(x3782)*(x3789))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3774)*(x3778)*(x3785)))+(((x3786)*(x3792)))+(((IkReal(-1.00000000000000))*(x3784)*(x3789)))+(((IkReal(-1.00000000000000))*(x3777)*(x3788)*(x3791)))+(((IkReal(-1.00000000000000))*(x3778)*(x3799)))+(((IkReal(-1.00000000000000))*(x3774)*(x3778)*(x3790)))+(((IkReal(-1.00000000000000))*(x3789)*(x3800)))+(((IkReal(-1.00000000000000))*(x3777)*(x3779)*(x3789)))+(((IkReal(-1.00000000000000))*(x3781)*(x3792)))+(((x3783)*(x3794))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3777)*(x3789)))+(((IkReal(-1.00000000000000))*(x3784)*(x3792)))+(((r01)*(sj6)*(x3791)))+(((IkReal(-1.00000000000000))*(x3792)*(x3800)))+(((x3781)*(x3789)))+(((IkReal(-1.00000000000000))*(x3775)*(x3778)*(x3790)))+(((IkReal(-1.00000000000000))*(x3777)*(x3779)*(x3792)))+(((IkReal(-1.00000000000000))*(x3777)*(x3788)*(x3794)))+(((IkReal(-1.00000000000000))*(x3775)*(x3778)*(x3785)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(r00)*(x3777)*(x3791))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x3801=((cj5)*(r22));
IkReal x3802=((IkReal(0.374290000000000))*(sj5));
IkReal x3803=((cj0)*(sj6));
IkReal x3804=((cj6)*(r21));
IkReal x3805=((IkReal(0.0100000000000000))*(sj5));
IkReal x3806=((cj0)*(r02));
IkReal x3807=((IkReal(0.0100000000000000))*(cj5));
IkReal x3808=((IkReal(1.00000000000000))*(py));
IkReal x3809=((r01)*(sj0));
IkReal x3810=((r20)*(sj6));
IkReal x3811=((r11)*(sj0));
IkReal x3812=((IkReal(0.374290000000000))*(cj5));
IkReal x3813=((cj0)*(r12));
IkReal x3814=((sj0)*(x3812));
IkReal x3815=((cj6)*(x3807));
IkReal x3816=((r10)*(sj0)*(sj6));
IkReal x3817=((r00)*(sj0)*(sj6));
IkReal x3818=((cj0)*(cj6)*(x3802));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j1, IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x3804)))+(((sj5)*(x3810)))+(((IkReal(-1.00000000000000))*(x3801))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3807)*(x3810)))+(((IkReal(-0.374290000000000))*(x3801)))+(((x3802)*(x3810)))+(((IkReal(-1.00000000000000))*(x3804)*(x3807)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x3805)))+(((x3802)*(x3804))));
evalcond[3]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r02)*(x3814)))+(((x3805)*(x3813)))+(((IkReal(-1.00000000000000))*(r11)*(x3818)))+(((x3802)*(x3817)))+(((x3812)*(x3813)))+(((IkReal(-1.00000000000000))*(cj0)*(x3808)))+(((IkReal(-1.00000000000000))*(r10)*(x3802)*(x3803)))+(((cj0)*(r11)*(x3815)))+(((IkReal(-1.00000000000000))*(x3809)*(x3815)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3805)))+(((IkReal(-1.00000000000000))*(x3807)*(x3817)))+(((cj6)*(x3802)*(x3809)))+(((px)*(sj0)))+(((r10)*(x3803)*(x3807))));
evalcond[4]=((IkReal(-0.295420000000000))+(((r12)*(x3814)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((x3805)*(x3806)))+(((IkReal(-1.00000000000000))*(cj6)*(x3802)*(x3811)))+(((x3811)*(x3815)))+(((IkReal(-1.00000000000000))*(x3802)*(x3816)))+(((x3807)*(x3816)))+(((r12)*(sj0)*(x3805)))+(((r00)*(x3803)*(x3807)))+(((IkReal(-1.00000000000000))*(r00)*(x3802)*(x3803)))+(((IkReal(-1.00000000000000))*(r01)*(x3818)))+(((cj0)*(r01)*(x3815)))+(((IkReal(-1.00000000000000))*(sj0)*(x3808)))+(((x3806)*(x3812))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3819=((sj0)*(sj5));
IkReal x3820=((r00)*(sj6));
IkReal x3821=((IkReal(1.00000000000000))*(cj5));
IkReal x3822=((cj6)*(r11));
IkReal x3823=((cj6)*(r01));
IkReal x3824=((r10)*(sj6));
IkReal x3825=((cj0)*(sj5));
if( IKabs(((((x3819)*(x3820)))+(((IkReal(-1.00000000000000))*(x3822)*(x3825)))+(((IkReal(-1.00000000000000))*(x3824)*(x3825)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3821)))+(((cj0)*(cj5)*(r12)))+(((x3819)*(x3823))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x3823)*(x3825)))+(((x3820)*(x3825)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x3821)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x3821)))+(((x3819)*(x3822)))+(((x3819)*(x3824))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((x3819)*(x3820)))+(((IkReal(-1.00000000000000))*(x3822)*(x3825)))+(((IkReal(-1.00000000000000))*(x3824)*(x3825)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3821)))+(((cj0)*(cj5)*(r12)))+(((x3819)*(x3823)))))+IKsqr(((((x3823)*(x3825)))+(((x3820)*(x3825)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x3821)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x3821)))+(((x3819)*(x3822)))+(((x3819)*(x3824)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((x3819)*(x3820)))+(((IkReal(-1.00000000000000))*(x3822)*(x3825)))+(((IkReal(-1.00000000000000))*(x3824)*(x3825)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3821)))+(((cj0)*(cj5)*(r12)))+(((x3819)*(x3823)))), ((((x3823)*(x3825)))+(((x3820)*(x3825)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x3821)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x3821)))+(((x3819)*(x3822)))+(((x3819)*(x3824)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x3826=((cj0)*(cj5));
IkReal x3827=((IkReal(1.00000000000000))*(cj0));
IkReal x3828=((cj6)*(r11));
IkReal x3829=((r10)*(sj6));
IkReal x3830=((cj5)*(sj0));
IkReal x3831=((r00)*(sj5)*(sj6));
IkReal x3832=((cj6)*(r01)*(sj5));
IkReal x3833=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj5)*(x3827)*(x3828)))+(((IkReal(-1.00000000000000))*(r02)*(x3830)))+(((IkReal(-1.00000000000000))*(sj5)*(x3827)*(x3829)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((sj0)*(x3832)))+(((sj0)*(x3831)))+(((r12)*(x3826))));
evalcond[1]=((((r12)*(x3830)))+(((IkReal(-1.00000000000000))*(x3827)*(x3831)))+(((IkReal(-1.00000000000000))*(x3828)*(x3833)))+(((r02)*(x3826)))+(((IkReal(-1.00000000000000))*(x3829)*(x3833)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(x3827)*(x3832))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst24;
IkReal x3834=(r21)*(r21);
IkReal x3835=(cj5)*(cj5);
IkReal x3836=(sj6)*(sj6);
IkReal x3837=(cj6)*(cj6);
IkReal x3838=(r20)*(r20);
IkReal x3839=((cj6)*(r21));
IkReal x3840=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3841=((cj5)*(r22)*(sj5));
IkReal x3842=((IkReal(1.00000000000000))*(x3836));
IkReal x3843=((IkReal(1.00000000000000))*(x3837));
gconst24=IKsign(((((IkReal(-1.00000000000000))*(x3834)*(x3835)*(x3843)))+(((x3839)*(x3840)))+(((IkReal(-1.00000000000000))*(x3835)*(x3839)*(x3840)))+(((IkReal(-1.00000000000000))*(x3835)*(x3838)*(x3842)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3834)*(x3842)))+(((IkReal(-2.00000000000000))*(x3839)*(x3841)))+(((IkReal(-1.00000000000000))*(x3838)*(x3843)))+(((IkReal(-1.00000000000000))*(x3840)*(x3841)))));
IkReal x3844=(r21)*(r21);
IkReal x3845=(cj5)*(cj5);
IkReal x3846=(sj6)*(sj6);
IkReal x3847=(cj6)*(cj6);
IkReal x3848=(r20)*(r20);
IkReal x3849=((cj6)*(r21));
IkReal x3850=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3851=((cj5)*(r22)*(sj5));
IkReal x3852=((IkReal(1.00000000000000))*(x3846));
IkReal x3853=((IkReal(1.00000000000000))*(x3847));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3848)*(x3853)))+(((IkReal(-2.00000000000000))*(x3849)*(x3851)))+(((x3849)*(x3850)))+(((IkReal(-1.00000000000000))*(x3844)*(x3845)*(x3853)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3845)*(x3848)*(x3852)))+(((IkReal(-1.00000000000000))*(x3844)*(x3852)))+(((IkReal(-1.00000000000000))*(x3850)*(x3851)))+(((IkReal(-1.00000000000000))*(x3845)*(x3849)*(x3850))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst25;
IkReal x3854=(cj6)*(cj6);
IkReal x3855=(sj6)*(sj6);
IkReal x3856=((IkReal(1.00000000000000))*(r01));
IkReal x3857=((sj0)*(sj5));
IkReal x3858=((cj6)*(r22));
IkReal x3859=((r21)*(sj6));
IkReal x3860=((r00)*(r21));
IkReal x3861=((cj0)*(sj5));
IkReal x3862=((cj6)*(r20));
IkReal x3863=((r22)*(sj6));
IkReal x3864=((cj0)*(cj5));
IkReal x3865=((IkReal(1.00000000000000))*(r10));
IkReal x3866=((cj5)*(sj0));
IkReal x3867=((r20)*(x3855));
IkReal x3868=((x3854)*(x3866));
gconst25=IKsign(((((IkReal(-1.00000000000000))*(r02)*(x3857)*(x3862)))+(((r11)*(x3864)*(x3867)))+(((r00)*(x3857)*(x3858)))+(((IkReal(-1.00000000000000))*(x3856)*(x3857)*(x3863)))+(((x3855)*(x3860)*(x3866)))+(((r11)*(r20)*(x3854)*(x3864)))+(((IkReal(-1.00000000000000))*(x3856)*(x3866)*(x3867)))+(((r11)*(x3861)*(x3863)))+(((IkReal(-1.00000000000000))*(x3858)*(x3861)*(x3865)))+(((r02)*(x3857)*(x3859)))+(((IkReal(-1.00000000000000))*(r12)*(x3859)*(x3861)))+(((r12)*(x3861)*(x3862)))+(((IkReal(-1.00000000000000))*(r20)*(x3856)*(x3868)))+(((IkReal(-1.00000000000000))*(r21)*(x3855)*(x3864)*(x3865)))+(((x3860)*(x3868)))+(((IkReal(-1.00000000000000))*(r21)*(x3854)*(x3864)*(x3865)))));
IkReal x3869=(cj6)*(cj6);
IkReal x3870=(sj6)*(sj6);
IkReal x3871=((IkReal(1.00000000000000))*(r01));
IkReal x3872=((sj0)*(sj5));
IkReal x3873=((cj6)*(r22));
IkReal x3874=((r21)*(sj6));
IkReal x3875=((r00)*(r21));
IkReal x3876=((cj0)*(sj5));
IkReal x3877=((cj6)*(r20));
IkReal x3878=((r22)*(sj6));
IkReal x3879=((cj0)*(cj5));
IkReal x3880=((IkReal(1.00000000000000))*(r10));
IkReal x3881=((cj5)*(sj0));
IkReal x3882=((r20)*(x3870));
IkReal x3883=((x3869)*(x3881));
dummyeval[0]=((((x3870)*(x3875)*(x3881)))+(((r11)*(x3879)*(x3882)))+(((IkReal(-1.00000000000000))*(x3873)*(x3876)*(x3880)))+(((IkReal(-1.00000000000000))*(r21)*(x3869)*(x3879)*(x3880)))+(((r00)*(x3872)*(x3873)))+(((IkReal(-1.00000000000000))*(x3871)*(x3872)*(x3878)))+(((r11)*(x3876)*(x3878)))+(((IkReal(-1.00000000000000))*(r02)*(x3872)*(x3877)))+(((IkReal(-1.00000000000000))*(r20)*(x3871)*(x3883)))+(((r12)*(x3876)*(x3877)))+(((IkReal(-1.00000000000000))*(r21)*(x3870)*(x3879)*(x3880)))+(((x3875)*(x3883)))+(((IkReal(-1.00000000000000))*(x3871)*(x3881)*(x3882)))+(((r11)*(r20)*(x3869)*(x3879)))+(((IkReal(-1.00000000000000))*(r12)*(x3874)*(x3876)))+(((r02)*(x3872)*(x3874))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3884=((r01)*(sj0));
IkReal x3885=((IkReal(1.00000000000000))*(cj5));
IkReal x3886=((cj0)*(r10));
IkReal x3887=((r00)*(sj0));
IkReal x3888=((cj0)*(r11));
if( IKabs(((gconst25)*(((((sj6)*(x3884)))+(((IkReal(-1.00000000000000))*(cj6)*(x3887)))+(((IkReal(-1.00000000000000))*(sj6)*(x3888)))+(((cj6)*(x3886))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst25)*(((((cj5)*(cj6)*(x3888)))+(((IkReal(-1.00000000000000))*(cj6)*(x3884)*(x3885)))+(((IkReal(-1.00000000000000))*(sj6)*(x3885)*(x3887)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(sj6)*(x3886))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst25)*(((((sj6)*(x3884)))+(((IkReal(-1.00000000000000))*(cj6)*(x3887)))+(((IkReal(-1.00000000000000))*(sj6)*(x3888)))+(((cj6)*(x3886)))))), ((gconst25)*(((((cj5)*(cj6)*(x3888)))+(((IkReal(-1.00000000000000))*(cj6)*(x3884)*(x3885)))+(((IkReal(-1.00000000000000))*(sj6)*(x3885)*(x3887)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((cj5)*(sj6)*(x3886)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3889=IKsin(j4);
IkReal x3890=IKcos(j4);
IkReal x3891=((r22)*(sj5));
IkReal x3892=((IkReal(1.00000000000000))*(cj6));
IkReal x3893=((IkReal(1.00000000000000))*(cj0));
IkReal x3894=((cj5)*(r11));
IkReal x3895=((cj5)*(cj6));
IkReal x3896=((r11)*(sj6));
IkReal x3897=((IkReal(1.00000000000000))*(sj6));
IkReal x3898=((cj6)*(r00));
IkReal x3899=((r12)*(sj5));
IkReal x3900=((r02)*(sj5));
IkReal x3901=((cj6)*(r10));
IkReal x3902=((cj5)*(sj6));
IkReal x3903=((cj5)*(r01));
IkReal x3904=((sj0)*(x3889));
IkReal x3905=((r00)*(x3902));
IkReal x3906=((cj0)*(x3889));
IkReal x3907=((sj0)*(x3890));
IkReal x3908=((r20)*(x3890));
IkReal x3909=((cj0)*(x3890));
IkReal x3910=((r21)*(x3889));
IkReal x3911=((r21)*(x3890));
IkReal x3912=((r20)*(x3889));
IkReal x3913=((x3890)*(x3899));
IkReal x3914=((r01)*(sj6)*(x3890));
IkReal x3915=((cj5)*(r10)*(x3897));
evalcond[0]=((IkReal(1.00000000000000))+(((x3902)*(x3912)))+(((IkReal(-1.00000000000000))*(x3892)*(x3908)))+(((x3889)*(x3891)))+(((x3895)*(x3910)))+(((sj6)*(x3911))));
evalcond[1]=((((x3890)*(x3891)))+(((x3902)*(x3908)))+(((x3895)*(x3911)))+(((cj6)*(x3912)))+(((IkReal(-1.00000000000000))*(x3897)*(x3910))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3890)*(x3893)*(x3896)))+(((x3904)*(x3905)))+(((x3900)*(x3904)))+(((IkReal(-1.00000000000000))*(r00)*(x3892)*(x3907)))+(((x3901)*(x3909)))+(((r01)*(sj6)*(x3907)))+(((IkReal(-1.00000000000000))*(x3889)*(x3893)*(x3899)))+(((r01)*(x3895)*(x3904)))+(((IkReal(-1.00000000000000))*(r10)*(x3889)*(x3893)*(x3902)))+(((IkReal(-1.00000000000000))*(x3892)*(x3894)*(x3906))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r01)*(x3897)*(x3904)))+(((x3896)*(x3906)))+(((IkReal(-1.00000000000000))*(x3892)*(x3894)*(x3909)))+(((x3905)*(x3907)))+(((r01)*(x3895)*(x3907)))+(((IkReal(-1.00000000000000))*(r10)*(x3890)*(x3893)*(x3902)))+(cj3)+(((x3898)*(x3904)))+(((x3900)*(x3907)))+(((IkReal(-1.00000000000000))*(r10)*(x3892)*(x3906)))+(((IkReal(-1.00000000000000))*(x3893)*(x3913))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3889)*(x3893)*(x3905)))+(((IkReal(-1.00000000000000))*(x3892)*(x3903)*(x3906)))+(((IkReal(-1.00000000000000))*(x3896)*(x3907)))+(((IkReal(-1.00000000000000))*(x3904)*(x3915)))+(((IkReal(-1.00000000000000))*(x3893)*(x3914)))+(((x3901)*(x3907)))+(((IkReal(-1.00000000000000))*(x3889)*(x3893)*(x3900)))+(((IkReal(-1.00000000000000))*(x3899)*(x3904)))+(((x3898)*(x3909)))+(((IkReal(-1.00000000000000))*(x3892)*(x3894)*(x3904))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r00)*(x3892)*(x3906)))+(((r01)*(sj6)*(x3906)))+(sj3)+(((IkReal(-1.00000000000000))*(x3892)*(x3903)*(x3909)))+(((IkReal(-1.00000000000000))*(x3890)*(x3893)*(x3900)))+(((IkReal(-1.00000000000000))*(x3892)*(x3894)*(x3907)))+(((IkReal(-1.00000000000000))*(x3899)*(x3907)))+(((x3896)*(x3904)))+(((IkReal(-1.00000000000000))*(r10)*(x3892)*(x3904)))+(((IkReal(-1.00000000000000))*(x3890)*(x3893)*(x3905)))+(((IkReal(-1.00000000000000))*(x3907)*(x3915))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst24)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst24)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst24)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst24)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3916=IKsin(j4);
IkReal x3917=IKcos(j4);
IkReal x3918=((r22)*(sj5));
IkReal x3919=((IkReal(1.00000000000000))*(cj6));
IkReal x3920=((IkReal(1.00000000000000))*(cj0));
IkReal x3921=((cj5)*(r11));
IkReal x3922=((cj5)*(cj6));
IkReal x3923=((r11)*(sj6));
IkReal x3924=((IkReal(1.00000000000000))*(sj6));
IkReal x3925=((cj6)*(r00));
IkReal x3926=((r12)*(sj5));
IkReal x3927=((r02)*(sj5));
IkReal x3928=((cj6)*(r10));
IkReal x3929=((cj5)*(sj6));
IkReal x3930=((cj5)*(r01));
IkReal x3931=((sj0)*(x3916));
IkReal x3932=((r00)*(x3929));
IkReal x3933=((cj0)*(x3916));
IkReal x3934=((sj0)*(x3917));
IkReal x3935=((r20)*(x3917));
IkReal x3936=((cj0)*(x3917));
IkReal x3937=((r21)*(x3916));
IkReal x3938=((r21)*(x3917));
IkReal x3939=((r20)*(x3916));
IkReal x3940=((x3917)*(x3926));
IkReal x3941=((r01)*(sj6)*(x3917));
IkReal x3942=((cj5)*(r10)*(x3924));
evalcond[0]=((IkReal(1.00000000000000))+(((x3929)*(x3939)))+(((x3922)*(x3937)))+(((sj6)*(x3938)))+(((x3916)*(x3918)))+(((IkReal(-1.00000000000000))*(x3919)*(x3935))));
evalcond[1]=((((x3917)*(x3918)))+(((x3922)*(x3938)))+(((x3929)*(x3935)))+(((cj6)*(x3939)))+(((IkReal(-1.00000000000000))*(x3924)*(x3937))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3916)*(x3920)*(x3926)))+(((IkReal(-1.00000000000000))*(r10)*(x3916)*(x3920)*(x3929)))+(((r01)*(x3922)*(x3931)))+(((r01)*(sj6)*(x3934)))+(((IkReal(-1.00000000000000))*(r00)*(x3919)*(x3934)))+(((IkReal(-1.00000000000000))*(x3917)*(x3920)*(x3923)))+(((x3931)*(x3932)))+(((IkReal(-1.00000000000000))*(x3919)*(x3921)*(x3933)))+(((x3928)*(x3936)))+(((x3927)*(x3931))));
evalcond[3]=((((x3925)*(x3931)))+(((x3923)*(x3933)))+(((x3932)*(x3934)))+(((IkReal(-1.00000000000000))*(r01)*(x3924)*(x3931)))+(((r01)*(x3922)*(x3934)))+(((IkReal(-1.00000000000000))*(r10)*(x3919)*(x3933)))+(cj3)+(((IkReal(-1.00000000000000))*(x3919)*(x3921)*(x3936)))+(((x3927)*(x3934)))+(((IkReal(-1.00000000000000))*(r10)*(x3917)*(x3920)*(x3929)))+(((IkReal(-1.00000000000000))*(x3920)*(x3940))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3920)*(x3941)))+(((IkReal(-1.00000000000000))*(x3923)*(x3934)))+(((IkReal(-1.00000000000000))*(x3916)*(x3920)*(x3932)))+(((IkReal(-1.00000000000000))*(x3919)*(x3930)*(x3933)))+(((x3925)*(x3936)))+(((IkReal(-1.00000000000000))*(x3919)*(x3921)*(x3931)))+(((IkReal(-1.00000000000000))*(x3926)*(x3931)))+(((IkReal(-1.00000000000000))*(x3916)*(x3920)*(x3927)))+(((x3928)*(x3934)))+(((IkReal(-1.00000000000000))*(x3931)*(x3942))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x3917)*(x3920)*(x3927)))+(((IkReal(-1.00000000000000))*(x3917)*(x3920)*(x3932)))+(sj3)+(((IkReal(-1.00000000000000))*(x3934)*(x3942)))+(((r01)*(sj6)*(x3933)))+(((IkReal(-1.00000000000000))*(x3919)*(x3921)*(x3934)))+(((IkReal(-1.00000000000000))*(r10)*(x3919)*(x3931)))+(((IkReal(-1.00000000000000))*(x3926)*(x3934)))+(((x3923)*(x3931)))+(((IkReal(-1.00000000000000))*(r00)*(x3919)*(x3933)))+(((IkReal(-1.00000000000000))*(x3919)*(x3930)*(x3936))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3943=((sj5)*(sj6));
IkReal x3944=((cj6)*(sj5));
IkReal x3945=((IkReal(1.00000000000000))*(cj0));
IkReal x3946=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((((r00)*(sj0)*(x3943)))+(((IkReal(-1.00000000000000))*(r10)*(x3943)*(x3945)))+(((r01)*(sj0)*(x3944)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x3944)*(x3945)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3946))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r20)*(x3943)))+(((IkReal(-1.00000000000000))*(r22)*(x3946)))+(((r21)*(x3944))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r00)*(sj0)*(x3943)))+(((IkReal(-1.00000000000000))*(r10)*(x3943)*(x3945)))+(((r01)*(sj0)*(x3944)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x3944)*(x3945)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3946)))))+IKsqr(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r20)*(x3943)))+(((IkReal(-1.00000000000000))*(r22)*(x3946)))+(((r21)*(x3944)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r00)*(sj0)*(x3943)))+(((IkReal(-1.00000000000000))*(r10)*(x3943)*(x3945)))+(((r01)*(sj0)*(x3944)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x3944)*(x3945)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x3946)))), ((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r20)*(x3943)))+(((IkReal(-1.00000000000000))*(r22)*(x3946)))+(((r21)*(x3944)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x3947=IKcos(j3);
IkReal x3948=((sj5)*(sj6));
IkReal x3949=((cj0)*(cj5));
IkReal x3950=((IkReal(1.00000000000000))*(cj0));
IkReal x3951=((IkReal(1.00000000000000))*(sj0));
IkReal x3952=((IkReal(1.00000000000000))*(x3947));
IkReal x3953=((cj6)*(r01)*(sj5));
IkReal x3954=((cj6)*(r11)*(sj5));
evalcond[0]=((((cj6)*(r21)*(sj5)))+(((r20)*(x3948)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj1)*(x3952))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj5)*(r02)*(x3951)))+(((r12)*(x3949)))+(((IkReal(-1.00000000000000))*(r10)*(x3948)*(x3950)))+(((sj0)*(x3953)))+(((r00)*(sj0)*(x3948)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(x3950)*(x3954))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3951)*(x3954)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(r10)*(x3948)*(x3951)))+(((IkReal(-1.00000000000000))*(x3950)*(x3953)))+(((r02)*(x3949)))+(((IkReal(-1.00000000000000))*(r00)*(x3948)*(x3950)))+(((IkReal(-1.00000000000000))*(cj1)*(x3952))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst15;
IkReal x3955=(r21)*(r21);
IkReal x3956=(cj5)*(cj5);
IkReal x3957=(sj6)*(sj6);
IkReal x3958=(cj6)*(cj6);
IkReal x3959=(r20)*(r20);
IkReal x3960=((cj6)*(r21));
IkReal x3961=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3962=((cj5)*(r22)*(sj5));
IkReal x3963=((IkReal(1.00000000000000))*(x3957));
IkReal x3964=((IkReal(1.00000000000000))*(x3958));
gconst15=IKsign(((((IkReal(-1.00000000000000))*(x3959)*(x3964)))+(((IkReal(-2.00000000000000))*(x3960)*(x3962)))+(((IkReal(-1.00000000000000))*(x3955)*(x3963)))+(((IkReal(-1.00000000000000))*(x3961)*(x3962)))+(((IkReal(-1.00000000000000))*(x3956)*(x3959)*(x3963)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((x3960)*(x3961)))+(((IkReal(-1.00000000000000))*(x3956)*(x3960)*(x3961)))+(((IkReal(-1.00000000000000))*(x3955)*(x3956)*(x3964)))));
IkReal x3965=(r21)*(r21);
IkReal x3966=(cj5)*(cj5);
IkReal x3967=(sj6)*(sj6);
IkReal x3968=(cj6)*(cj6);
IkReal x3969=(r20)*(r20);
IkReal x3970=((cj6)*(r21));
IkReal x3971=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x3972=((cj5)*(r22)*(sj5));
IkReal x3973=((IkReal(1.00000000000000))*(x3967));
IkReal x3974=((IkReal(1.00000000000000))*(x3968));
dummyeval[0]=((((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((x3970)*(x3971)))+(((IkReal(-1.00000000000000))*(x3966)*(x3970)*(x3971)))+(((IkReal(-1.00000000000000))*(x3966)*(x3969)*(x3973)))+(((IkReal(-1.00000000000000))*(x3971)*(x3972)))+(((IkReal(-2.00000000000000))*(x3970)*(x3972)))+(((IkReal(-1.00000000000000))*(x3965)*(x3973)))+(((IkReal(-1.00000000000000))*(x3965)*(x3966)*(x3974)))+(((IkReal(-1.00000000000000))*(x3969)*(x3974))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst16;
IkReal x3975=(cj6)*(cj6);
IkReal x3976=(sj6)*(sj6);
IkReal x3977=((IkReal(1.00000000000000))*(r21));
IkReal x3978=((cj6)*(r20));
IkReal x3979=((r22)*(sj5));
IkReal x3980=((r01)*(sj0));
IkReal x3981=((r00)*(sj0));
IkReal x3982=((cj0)*(r10));
IkReal x3983=((r02)*(sj0)*(sj5));
IkReal x3984=((cj5)*(x3975));
IkReal x3985=((cj0)*(r12)*(sj5));
IkReal x3986=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x3987=((cj5)*(x3976));
IkReal x3988=((r20)*(x3987));
gconst16=IKsign(((((x3978)*(x3983)))+(((IkReal(-1.00000000000000))*(x3977)*(x3981)*(x3987)))+(((IkReal(-1.00000000000000))*(sj6)*(x3977)*(x3983)))+(((r21)*(sj6)*(x3985)))+(((r21)*(x3982)*(x3984)))+(((r21)*(x3982)*(x3987)))+(((IkReal(-1.00000000000000))*(x3986)*(x3988)))+(((IkReal(-1.00000000000000))*(x3977)*(x3981)*(x3984)))+(((IkReal(-1.00000000000000))*(x3978)*(x3985)))+(((IkReal(-1.00000000000000))*(sj6)*(x3979)*(x3986)))+(((cj6)*(x3979)*(x3982)))+(((sj6)*(x3979)*(x3980)))+(((x3980)*(x3988)))+(((IkReal(-1.00000000000000))*(cj6)*(x3979)*(x3981)))+(((r20)*(x3980)*(x3984)))+(((IkReal(-1.00000000000000))*(r20)*(x3984)*(x3986)))));
IkReal x3989=(cj6)*(cj6);
IkReal x3990=(sj6)*(sj6);
IkReal x3991=((IkReal(1.00000000000000))*(r21));
IkReal x3992=((cj6)*(r20));
IkReal x3993=((r22)*(sj5));
IkReal x3994=((r01)*(sj0));
IkReal x3995=((r00)*(sj0));
IkReal x3996=((cj0)*(r10));
IkReal x3997=((r02)*(sj0)*(sj5));
IkReal x3998=((cj5)*(x3989));
IkReal x3999=((cj0)*(r12)*(sj5));
IkReal x4000=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x4001=((cj5)*(x3990));
IkReal x4002=((r20)*(x4001));
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj6)*(x3993)*(x3995)))+(((IkReal(-1.00000000000000))*(x3992)*(x3999)))+(((sj6)*(x3993)*(x3994)))+(((r21)*(x3996)*(x3998)))+(((IkReal(-1.00000000000000))*(x4000)*(x4002)))+(((r21)*(x3996)*(x4001)))+(((r20)*(x3994)*(x3998)))+(((IkReal(-1.00000000000000))*(sj6)*(x3991)*(x3997)))+(((cj6)*(x3993)*(x3996)))+(((IkReal(-1.00000000000000))*(r20)*(x3998)*(x4000)))+(((IkReal(-1.00000000000000))*(sj6)*(x3993)*(x4000)))+(((IkReal(-1.00000000000000))*(x3991)*(x3995)*(x4001)))+(((x3994)*(x4002)))+(((r21)*(sj6)*(x3999)))+(((x3992)*(x3997)))+(((IkReal(-1.00000000000000))*(x3991)*(x3995)*(x3998))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x4003=((cj1)*(sj6));
IkReal x4004=((r01)*(sj0));
IkReal x4005=((cj0)*(r11));
IkReal x4006=((cj1)*(cj6));
IkReal x4007=((cj0)*(r10));
IkReal x4008=((IkReal(1.00000000000000))*(sj0));
IkReal x4009=((cj1)*(sj5));
if( IKabs(((gconst16)*(((((IkReal(-1.00000000000000))*(r00)*(x4006)*(x4008)))+(((x4006)*(x4007)))+(((IkReal(-1.00000000000000))*(x4003)*(x4005)))+(((x4003)*(x4004))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst16)*(((((IkReal(-1.00000000000000))*(cj5)*(x4004)*(x4006)))+(((cj0)*(r12)*(x4009)))+(((IkReal(-1.00000000000000))*(r02)*(x4008)*(x4009)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4003)*(x4008)))+(((cj5)*(x4003)*(x4007)))+(((cj5)*(x4005)*(x4006))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst16)*(((((IkReal(-1.00000000000000))*(r00)*(x4006)*(x4008)))+(((x4006)*(x4007)))+(((IkReal(-1.00000000000000))*(x4003)*(x4005)))+(((x4003)*(x4004)))))), ((gconst16)*(((((IkReal(-1.00000000000000))*(cj5)*(x4004)*(x4006)))+(((cj0)*(r12)*(x4009)))+(((IkReal(-1.00000000000000))*(r02)*(x4008)*(x4009)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4003)*(x4008)))+(((cj5)*(x4003)*(x4007)))+(((cj5)*(x4005)*(x4006)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x4010=IKsin(j4);
IkReal x4011=IKcos(j4);
IkReal x4012=((r22)*(sj5));
IkReal x4013=((IkReal(1.00000000000000))*(cj6));
IkReal x4014=((IkReal(1.00000000000000))*(cj0));
IkReal x4015=((cj5)*(r11));
IkReal x4016=((cj5)*(cj6));
IkReal x4017=((IkReal(1.00000000000000))*(sj3));
IkReal x4018=((r11)*(sj6));
IkReal x4019=((IkReal(1.00000000000000))*(sj6));
IkReal x4020=((cj6)*(r00));
IkReal x4021=((r12)*(sj5));
IkReal x4022=((r02)*(sj5));
IkReal x4023=((cj6)*(r10));
IkReal x4024=((cj5)*(sj6));
IkReal x4025=((cj5)*(r01));
IkReal x4026=((sj0)*(x4010));
IkReal x4027=((r00)*(x4024));
IkReal x4028=((cj0)*(x4010));
IkReal x4029=((sj0)*(x4011));
IkReal x4030=((r20)*(x4011));
IkReal x4031=((cj0)*(x4011));
IkReal x4032=((r21)*(x4010));
IkReal x4033=((r21)*(x4011));
IkReal x4034=((r20)*(x4010));
IkReal x4035=((x4011)*(x4021));
IkReal x4036=((r01)*(sj6)*(x4011));
IkReal x4037=((cj5)*(r10)*(x4019));
evalcond[0]=((((IkReal(-1.00000000000000))*(x4013)*(x4030)))+(((IkReal(-1.00000000000000))*(cj1)))+(((x4024)*(x4034)))+(((sj6)*(x4033)))+(((x4010)*(x4012)))+(((x4016)*(x4032))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj1)*(x4017)))+(((x4024)*(x4030)))+(((x4016)*(x4033)))+(((cj6)*(x4034)))+(((IkReal(-1.00000000000000))*(x4019)*(x4032)))+(((x4011)*(x4012))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x4013)*(x4029)))+(((r01)*(sj6)*(x4029)))+(((x4023)*(x4031)))+(((IkReal(-1.00000000000000))*(x4011)*(x4014)*(x4018)))+(((x4026)*(x4027)))+(((r01)*(x4016)*(x4026)))+(((IkReal(-1.00000000000000))*(x4010)*(x4014)*(x4021)))+(((IkReal(-1.00000000000000))*(x4013)*(x4015)*(x4028)))+(((IkReal(-1.00000000000000))*(r10)*(x4010)*(x4014)*(x4024)))+(((x4022)*(x4026))));
evalcond[3]=((((x4020)*(x4026)))+(((x4018)*(x4028)))+(((x4027)*(x4029)))+(((IkReal(-1.00000000000000))*(x4014)*(x4035)))+(((IkReal(-1.00000000000000))*(x4013)*(x4015)*(x4031)))+(cj3)+(((IkReal(-1.00000000000000))*(r10)*(x4013)*(x4028)))+(((x4022)*(x4029)))+(((r01)*(x4016)*(x4029)))+(((IkReal(-1.00000000000000))*(r10)*(x4011)*(x4014)*(x4024)))+(((IkReal(-1.00000000000000))*(r01)*(x4019)*(x4026))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x4010)*(x4014)*(x4022)))+(((IkReal(-1.00000000000000))*(x4014)*(x4036)))+(((IkReal(-1.00000000000000))*(x4021)*(x4026)))+(((IkReal(-1.00000000000000))*(x4010)*(x4014)*(x4027)))+(sj1)+(((IkReal(-1.00000000000000))*(x4013)*(x4015)*(x4026)))+(((x4023)*(x4029)))+(((IkReal(-1.00000000000000))*(x4026)*(x4037)))+(((x4020)*(x4031)))+(((IkReal(-1.00000000000000))*(x4018)*(x4029)))+(((IkReal(-1.00000000000000))*(x4013)*(x4025)*(x4028))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x4013)*(x4026)))+(((IkReal(-1.00000000000000))*(r00)*(x4013)*(x4028)))+(((IkReal(-1.00000000000000))*(x4013)*(x4025)*(x4031)))+(((IkReal(-1.00000000000000))*(x4011)*(x4014)*(x4022)))+(((IkReal(-1.00000000000000))*(x4011)*(x4014)*(x4027)))+(((IkReal(-1.00000000000000))*(cj1)*(x4017)))+(((IkReal(-1.00000000000000))*(x4029)*(x4037)))+(((x4018)*(x4026)))+(((r01)*(sj6)*(x4028)))+(((IkReal(-1.00000000000000))*(x4021)*(x4029)))+(((IkReal(-1.00000000000000))*(x4013)*(x4015)*(x4029))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x4038=((IkReal(1.00000000000000))*(cj1));
IkReal x4039=((sj1)*(sj3));
IkReal x4040=((r21)*(sj6));
IkReal x4041=((r22)*(sj5));
IkReal x4042=((cj6)*(r20));
IkReal x4043=((cj5)*(r20)*(sj6));
IkReal x4044=((cj5)*(cj6)*(r21));
if( IKabs(((gconst15)*(((((IkReal(-1.00000000000000))*(x4038)*(x4041)))+(((IkReal(-1.00000000000000))*(x4038)*(x4043)))+(((x4039)*(x4040)))+(((IkReal(-1.00000000000000))*(x4038)*(x4044)))+(((IkReal(-1.00000000000000))*(x4039)*(x4042))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst15)*(((((cj1)*(x4042)))+(((IkReal(-1.00000000000000))*(x4038)*(x4040)))+(((IkReal(-1.00000000000000))*(x4039)*(x4041)))+(((IkReal(-1.00000000000000))*(x4039)*(x4044)))+(((IkReal(-1.00000000000000))*(x4039)*(x4043))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst15)*(((((IkReal(-1.00000000000000))*(x4038)*(x4041)))+(((IkReal(-1.00000000000000))*(x4038)*(x4043)))+(((x4039)*(x4040)))+(((IkReal(-1.00000000000000))*(x4038)*(x4044)))+(((IkReal(-1.00000000000000))*(x4039)*(x4042)))))), ((gconst15)*(((((cj1)*(x4042)))+(((IkReal(-1.00000000000000))*(x4038)*(x4040)))+(((IkReal(-1.00000000000000))*(x4039)*(x4041)))+(((IkReal(-1.00000000000000))*(x4039)*(x4044)))+(((IkReal(-1.00000000000000))*(x4039)*(x4043)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x4045=IKsin(j4);
IkReal x4046=IKcos(j4);
IkReal x4047=((r22)*(sj5));
IkReal x4048=((IkReal(1.00000000000000))*(cj6));
IkReal x4049=((IkReal(1.00000000000000))*(cj0));
IkReal x4050=((cj5)*(r11));
IkReal x4051=((cj5)*(cj6));
IkReal x4052=((IkReal(1.00000000000000))*(sj3));
IkReal x4053=((r11)*(sj6));
IkReal x4054=((IkReal(1.00000000000000))*(sj6));
IkReal x4055=((cj6)*(r00));
IkReal x4056=((r12)*(sj5));
IkReal x4057=((r02)*(sj5));
IkReal x4058=((cj6)*(r10));
IkReal x4059=((cj5)*(sj6));
IkReal x4060=((cj5)*(r01));
IkReal x4061=((sj0)*(x4045));
IkReal x4062=((r00)*(x4059));
IkReal x4063=((cj0)*(x4045));
IkReal x4064=((sj0)*(x4046));
IkReal x4065=((r20)*(x4046));
IkReal x4066=((cj0)*(x4046));
IkReal x4067=((r21)*(x4045));
IkReal x4068=((r21)*(x4046));
IkReal x4069=((r20)*(x4045));
IkReal x4070=((x4046)*(x4056));
IkReal x4071=((r01)*(sj6)*(x4046));
IkReal x4072=((cj5)*(r10)*(x4054));
evalcond[0]=((((x4051)*(x4067)))+(((sj6)*(x4068)))+(((x4045)*(x4047)))+(((IkReal(-1.00000000000000))*(cj1)))+(((x4059)*(x4069)))+(((IkReal(-1.00000000000000))*(x4048)*(x4065))));
evalcond[1]=((((x4059)*(x4065)))+(((IkReal(-1.00000000000000))*(x4054)*(x4067)))+(((IkReal(-1.00000000000000))*(sj1)*(x4052)))+(((cj6)*(x4069)))+(((x4051)*(x4068)))+(((x4046)*(x4047))));
evalcond[2]=((((x4057)*(x4061)))+(((x4061)*(x4062)))+(((IkReal(-1.00000000000000))*(x4046)*(x4049)*(x4053)))+(((r01)*(x4051)*(x4061)))+(((r01)*(sj6)*(x4064)))+(((IkReal(-1.00000000000000))*(r00)*(x4048)*(x4064)))+(((IkReal(-1.00000000000000))*(x4048)*(x4050)*(x4063)))+(((IkReal(-1.00000000000000))*(r10)*(x4045)*(x4049)*(x4059)))+(((IkReal(-1.00000000000000))*(x4045)*(x4049)*(x4056)))+(((x4058)*(x4066))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x4048)*(x4063)))+(((x4053)*(x4063)))+(((x4055)*(x4061)))+(((x4057)*(x4064)))+(((IkReal(-1.00000000000000))*(x4048)*(x4050)*(x4066)))+(cj3)+(((r01)*(x4051)*(x4064)))+(((x4062)*(x4064)))+(((IkReal(-1.00000000000000))*(r01)*(x4054)*(x4061)))+(((IkReal(-1.00000000000000))*(r10)*(x4046)*(x4049)*(x4059)))+(((IkReal(-1.00000000000000))*(x4049)*(x4070))));
evalcond[4]=((sj1)+(((IkReal(-1.00000000000000))*(x4048)*(x4050)*(x4061)))+(((IkReal(-1.00000000000000))*(x4056)*(x4061)))+(((IkReal(-1.00000000000000))*(x4061)*(x4072)))+(((IkReal(-1.00000000000000))*(x4045)*(x4049)*(x4062)))+(((x4055)*(x4066)))+(((IkReal(-1.00000000000000))*(x4048)*(x4060)*(x4063)))+(((x4058)*(x4064)))+(((IkReal(-1.00000000000000))*(x4045)*(x4049)*(x4057)))+(((IkReal(-1.00000000000000))*(x4049)*(x4071)))+(((IkReal(-1.00000000000000))*(x4053)*(x4064))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj1)*(x4052)))+(((IkReal(-1.00000000000000))*(x4048)*(x4050)*(x4064)))+(((IkReal(-1.00000000000000))*(x4048)*(x4060)*(x4066)))+(((IkReal(-1.00000000000000))*(x4046)*(x4049)*(x4057)))+(((IkReal(-1.00000000000000))*(r10)*(x4048)*(x4061)))+(((IkReal(-1.00000000000000))*(x4064)*(x4072)))+(((x4053)*(x4061)))+(((IkReal(-1.00000000000000))*(x4056)*(x4064)))+(((IkReal(-1.00000000000000))*(x4046)*(x4049)*(x4062)))+(((IkReal(-1.00000000000000))*(r00)*(x4048)*(x4063)))+(((r01)*(sj6)*(x4063))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x4073=((sj0)*(sj6));
IkReal x4074=((cj0)*(cj6));
IkReal x4075=((cj0)*(sj6));
IkReal x4076=((IkReal(1.00000000000000))*(cj1));
IkReal x4077=((r20)*(sj1));
IkReal x4078=((cj6)*(sj0));
IkReal x4079=((r21)*(sj1));
IkReal x4080=((cj5)*(x4076));
if( IKabs(((gconst14)*(((((IkReal(-1.00000000000000))*(sj6)*(x4079)))+(((cj6)*(x4077)))+(((cj1)*(r11)*(x4073)))+(((cj1)*(r01)*(x4075)))+(((IkReal(-1.00000000000000))*(r10)*(x4076)*(x4078)))+(((IkReal(-1.00000000000000))*(r00)*(x4074)*(x4076))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst14)*(((((IkReal(-1.00000000000000))*(r11)*(x4078)*(x4080)))+(((IkReal(-1.00000000000000))*(r00)*(x4075)*(x4080)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(sj5)*(x4076)))+(((cj5)*(sj6)*(x4077)))+(((IkReal(-1.00000000000000))*(r01)*(x4074)*(x4080)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x4076)))+(((IkReal(-1.00000000000000))*(r10)*(x4073)*(x4080)))+(((cj5)*(cj6)*(x4079)))+(((r22)*(sj1)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst14)*(((((IkReal(-1.00000000000000))*(sj6)*(x4079)))+(((cj6)*(x4077)))+(((cj1)*(r11)*(x4073)))+(((cj1)*(r01)*(x4075)))+(((IkReal(-1.00000000000000))*(r10)*(x4076)*(x4078)))+(((IkReal(-1.00000000000000))*(r00)*(x4074)*(x4076)))))), ((gconst14)*(((((IkReal(-1.00000000000000))*(r11)*(x4078)*(x4080)))+(((IkReal(-1.00000000000000))*(r00)*(x4075)*(x4080)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(sj5)*(x4076)))+(((cj5)*(sj6)*(x4077)))+(((IkReal(-1.00000000000000))*(r01)*(x4074)*(x4080)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(sj5)*(x4076)))+(((IkReal(-1.00000000000000))*(r10)*(x4073)*(x4080)))+(((cj5)*(cj6)*(x4079)))+(((r22)*(sj1)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x4081=IKsin(j4);
IkReal x4082=IKcos(j4);
IkReal x4083=((r00)*(sj6));
IkReal x4084=((cj6)*(r01));
IkReal x4085=((IkReal(1.00000000000000))*(cj0));
IkReal x4086=((IkReal(1.00000000000000))*(sj0));
IkReal x4087=((r10)*(sj6));
IkReal x4088=((sj5)*(x4081));
IkReal x4089=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x4090=((cj5)*(x4081));
IkReal x4091=((cj6)*(x4082));
IkReal x4092=((sj0)*(x4090));
IkReal x4093=((r01)*(sj6)*(x4082));
IkReal x4094=((r11)*(sj6)*(x4082));
evalcond[0]=((((r20)*(sj6)*(x4090)))+(((r21)*(sj6)*(x4082)))+(((IkReal(-1.00000000000000))*(cj1)))+(((r22)*(x4088)))+(((cj6)*(r21)*(x4090)))+(((IkReal(-1.00000000000000))*(r20)*(x4091))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4085)*(x4094)))+(((r02)*(sj0)*(x4088)))+(((x4084)*(x4092)))+(((IkReal(-1.00000000000000))*(r00)*(x4086)*(x4091)))+(((IkReal(-1.00000000000000))*(x4085)*(x4087)*(x4090)))+(((cj0)*(r10)*(x4091)))+(((x4083)*(x4092)))+(((IkReal(-1.00000000000000))*(r12)*(x4085)*(x4088)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x4085)*(x4090)))+(((sj0)*(x4093))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4086)*(x4094)))+(((IkReal(-1.00000000000000))*(x4083)*(x4085)*(x4090)))+(((IkReal(-1.00000000000000))*(r02)*(x4085)*(x4088)))+(((IkReal(-1.00000000000000))*(x4086)*(x4087)*(x4090)))+(((cj0)*(r00)*(x4091)))+(sj1)+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x4086)*(x4090)))+(((r10)*(sj0)*(x4091)))+(((IkReal(-1.00000000000000))*(r12)*(x4086)*(x4088)))+(((IkReal(-1.00000000000000))*(x4085)*(x4093)))+(((IkReal(-1.00000000000000))*(x4084)*(x4085)*(x4090))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst17;
gconst17=IKsign(sj1);
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x4095=((IkReal(1.00000000000000))*(cj0));
IkReal x4096=((cj4)*(sj6));
IkReal x4097=((sj0)*(sj6));
IkReal x4098=((cj5)*(sj4));
IkReal x4099=((IkReal(0.374290000000000))*(sj5));
IkReal x4100=((sj4)*(sj5));
IkReal x4101=((cj0)*(cj6));
IkReal x4102=((IkReal(0.0100000000000000))*(cj5));
IkReal x4103=((cj4)*(sj5));
IkReal x4104=((cj5)*(sj0));
IkReal x4105=((IkReal(0.374290000000000))*(r02));
IkReal x4106=((r20)*(sj6));
IkReal x4107=((cj6)*(r21));
IkReal x4108=((IkReal(1.00000000000000))*(sj0));
IkReal x4109=((cj0)*(sj6));
IkReal x4110=((cj4)*(cj6));
IkReal x4111=((IkReal(0.374290000000000))*(r12));
IkReal x4112=((cj0)*(cj5));
IkReal x4113=((cj6)*(sj5));
IkReal x4114=((cj6)*(r01));
IkReal x4115=((r00)*(sj6));
IkReal x4116=((IkReal(0.0100000000000000))*(sj5));
IkReal x4117=((cj6)*(r11));
IkReal x4118=((IkReal(1.00000000000000))*(r10));
IkReal x4119=((r02)*(sj0));
IkReal x4120=((cj6)*(sj4));
IkReal x4121=((r12)*(x4108));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x4100)))+(((r21)*(x4096)))+(((x4098)*(x4107)))+(((IkReal(-1.00000000000000))*(r20)*(x4110)))+(((x4098)*(x4106))));
evalcond[2]=((IkReal(0.364420000000000))+(((x4099)*(x4107)))+(((x4099)*(x4106)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r22)*(x4116)))+(pz)+(((IkReal(-1.00000000000000))*(x4102)*(x4107)))+(((IkReal(-1.00000000000000))*(x4102)*(x4106))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x4095)*(x4115)))+(((r12)*(x4104)))+(((IkReal(-1.00000000000000))*(r11)*(x4108)*(x4113)))+(((IkReal(-1.00000000000000))*(sj5)*(x4097)*(x4118)))+(((IkReal(-1.00000000000000))*(r01)*(x4095)*(x4113)))+(((r02)*(x4112))));
evalcond[4]=((((sj0)*(x4098)*(x4114)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x4095)*(x4098)))+(((IkReal(-1.00000000000000))*(r12)*(x4095)*(x4100)))+(((IkReal(-1.00000000000000))*(r00)*(x4108)*(x4110)))+(((IkReal(-1.00000000000000))*(r11)*(x4095)*(x4096)))+(((r00)*(x4097)*(x4098)))+(((IkReal(-1.00000000000000))*(x4095)*(x4098)*(x4117)))+(((r01)*(sj0)*(x4096)))+(((x4100)*(x4119)))+(((cj4)*(r10)*(x4101))));
evalcond[5]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x4095)*(x4098)*(x4114)))+(((IkReal(-1.00000000000000))*(x4098)*(x4108)*(x4117)))+(((IkReal(-1.00000000000000))*(x4100)*(x4121)))+(((cj4)*(r00)*(x4101)))+(((IkReal(-1.00000000000000))*(x4097)*(x4098)*(x4118)))+(((IkReal(-1.00000000000000))*(r11)*(x4096)*(x4108)))+(((IkReal(-1.00000000000000))*(x4095)*(x4098)*(x4115)))+(((IkReal(-1.00000000000000))*(r02)*(x4095)*(x4100)))+(((IkReal(-1.00000000000000))*(r01)*(x4095)*(x4096)))+(((r10)*(sj0)*(x4110))));
evalcond[6]=((IkReal(0.0690000000000000))+(((sj0)*(x4099)*(x4114)))+(((IkReal(-1.00000000000000))*(sj0)*(x4102)*(x4114)))+(((r11)*(x4101)*(x4102)))+(((r00)*(x4097)*(x4099)))+(((IkReal(-1.00000000000000))*(r11)*(x4099)*(x4101)))+(((IkReal(-1.00000000000000))*(r00)*(x4097)*(x4102)))+(((IkReal(-1.00000000000000))*(r10)*(x4099)*(x4109)))+(((IkReal(-1.00000000000000))*(x4116)*(x4119)))+(((IkReal(-1.00000000000000))*(py)*(x4095)))+(((IkReal(-1.00000000000000))*(x4104)*(x4105)))+(((r10)*(x4102)*(x4109)))+(((cj0)*(r12)*(x4116)))+(((px)*(sj0)))+(((x4111)*(x4112))));
evalcond[7]=((((IkReal(-1.00000000000000))*(r02)*(x4095)*(x4103)))+(((r01)*(sj4)*(x4109)))+(((IkReal(-1.00000000000000))*(x4103)*(x4121)))+(((IkReal(-1.00000000000000))*(r00)*(x4095)*(x4120)))+(((r11)*(sj4)*(x4097)))+(((IkReal(-1.00000000000000))*(r10)*(x4108)*(x4120)))+(((IkReal(-1.00000000000000))*(x4096)*(x4104)*(x4118)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x4095)*(x4110)))+(((IkReal(-1.00000000000000))*(r11)*(x4104)*(x4110)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4095)*(x4096))));
evalcond[8]=((IkReal(0.0690000000000000))+(((r00)*(x4102)*(x4109)))+(((IkReal(-1.00000000000000))*(sj0)*(x4099)*(x4117)))+(((IkReal(-1.00000000000000))*(px)*(x4095)))+(((IkReal(-1.00000000000000))*(r01)*(x4099)*(x4101)))+(((r10)*(x4097)*(x4102)))+(((IkReal(-1.00000000000000))*(r10)*(x4097)*(x4099)))+(((cj0)*(r02)*(x4116)))+(((x4105)*(x4112)))+(((r01)*(x4101)*(x4102)))+(((IkReal(-1.00000000000000))*(r00)*(x4099)*(x4109)))+(((IkReal(-1.00000000000000))*(py)*(x4108)))+(((r12)*(sj0)*(x4116)))+(((x4104)*(x4111)))+(((sj0)*(x4102)*(x4117))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4122=((r20)*(sj6));
IkReal x4123=((cj4)*(cj5));
IkReal x4124=((cj6)*(r21));
if( IKabs(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((x4123)*(x4124)))+(((cj4)*(r22)*(sj5)))+(((x4122)*(x4123))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x4124)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4122))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((x4123)*(x4124)))+(((cj4)*(r22)*(sj5)))+(((x4122)*(x4123)))))+IKsqr(((((sj5)*(x4124)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4122)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((x4123)*(x4124)))+(((cj4)*(r22)*(sj5)))+(((x4122)*(x4123)))), ((((sj5)*(x4124)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4122)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4125=IKcos(j3);
IkReal x4126=((sj0)*(sj5));
IkReal x4127=((r00)*(sj6));
IkReal x4128=((cj6)*(r01));
IkReal x4129=((cj5)*(sj0));
IkReal x4130=((cj0)*(cj5));
IkReal x4131=((cj6)*(sj4));
IkReal x4132=((sj4)*(sj6));
IkReal x4133=((cj0)*(r11));
IkReal x4134=((cj4)*(cj6));
IkReal x4135=((cj4)*(sj6));
IkReal x4136=((IkReal(1.00000000000000))*(cj0));
IkReal x4137=((cj4)*(sj5));
IkReal x4138=((sj5)*(sj6));
IkReal x4139=((cj6)*(sj5));
IkReal x4140=((IkReal(1.00000000000000))*(IKsin(j3)));
evalcond[0]=((((r21)*(x4139)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x4125)))+(((r20)*(x4138))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4140)))+(((r20)*(x4131)))+(((IkReal(-1.00000000000000))*(r21)*(x4132)))+(((cj5)*(r21)*(x4134)))+(((r22)*(x4137)))+(((cj5)*(r20)*(x4135))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4140)))+(((x4126)*(x4128)))+(((IkReal(-1.00000000000000))*(r02)*(x4129)))+(((IkReal(-1.00000000000000))*(x4133)*(x4139)))+(((r12)*(x4130)))+(((IkReal(-1.00000000000000))*(r10)*(x4136)*(x4138)))+(((x4126)*(x4127))));
evalcond[3]=((((cj4)*(x4127)*(x4129)))+(((IkReal(-1.00000000000000))*(r10)*(x4130)*(x4135)))+(((x4132)*(x4133)))+(((cj4)*(r02)*(x4126)))+(((IkReal(-1.00000000000000))*(r12)*(x4136)*(x4137)))+(((IkReal(-1.00000000000000))*(r10)*(x4131)*(x4136)))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x4132)))+(((IkReal(-1.00000000000000))*(r11)*(x4130)*(x4134)))+(((r00)*(sj0)*(x4131)))+(((cj4)*(x4128)*(x4129)))+(x4125));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4141=((IkReal(1.00000000000000))*(cj0));
IkReal x4142=((cj4)*(sj6));
IkReal x4143=((sj0)*(sj6));
IkReal x4144=((cj5)*(sj4));
IkReal x4145=((IkReal(0.374290000000000))*(sj5));
IkReal x4146=((sj4)*(sj5));
IkReal x4147=((cj0)*(cj6));
IkReal x4148=((IkReal(0.0100000000000000))*(cj5));
IkReal x4149=((cj4)*(sj5));
IkReal x4150=((cj5)*(sj0));
IkReal x4151=((IkReal(0.374290000000000))*(r02));
IkReal x4152=((r20)*(sj6));
IkReal x4153=((cj6)*(r21));
IkReal x4154=((IkReal(1.00000000000000))*(sj0));
IkReal x4155=((cj0)*(sj6));
IkReal x4156=((cj4)*(cj6));
IkReal x4157=((IkReal(0.374290000000000))*(r12));
IkReal x4158=((cj0)*(cj5));
IkReal x4159=((cj6)*(sj5));
IkReal x4160=((cj6)*(r01));
IkReal x4161=((r00)*(sj6));
IkReal x4162=((IkReal(0.0100000000000000))*(sj5));
IkReal x4163=((cj6)*(r11));
IkReal x4164=((IkReal(1.00000000000000))*(r10));
IkReal x4165=((r02)*(sj0));
IkReal x4166=((cj6)*(sj4));
IkReal x4167=((r12)*(x4154));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((x4144)*(x4153)))+(((x4144)*(x4152)))+(((r22)*(x4146)))+(((r21)*(x4142)))+(((IkReal(-1.00000000000000))*(r20)*(x4156))));
evalcond[2]=((IkReal(-0.364420000000000))+(((IkReal(-1.00000000000000))*(x4148)*(x4152)))+(((IkReal(-1.00000000000000))*(r22)*(x4162)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((x4145)*(x4152)))+(((IkReal(-1.00000000000000))*(x4148)*(x4153)))+(((x4145)*(x4153))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x4141)*(x4161)))+(((IkReal(-1.00000000000000))*(r11)*(x4154)*(x4159)))+(((IkReal(-1.00000000000000))*(r01)*(x4141)*(x4159)))+(((r12)*(x4150)))+(((r02)*(x4158)))+(((IkReal(-1.00000000000000))*(sj5)*(x4143)*(x4164))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r12)*(x4141)*(x4146)))+(((sj0)*(x4144)*(x4160)))+(((IkReal(-1.00000000000000))*(r11)*(x4141)*(x4142)))+(((r01)*(sj0)*(x4142)))+(((IkReal(-1.00000000000000))*(x4141)*(x4144)*(x4163)))+(((IkReal(-1.00000000000000))*(r00)*(x4154)*(x4156)))+(((cj4)*(r10)*(x4147)))+(((x4146)*(x4165)))+(((r00)*(x4143)*(x4144)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x4141)*(x4144))));
evalcond[5]=((IkReal(-1.00000000000000))+(((r10)*(sj0)*(x4156)))+(((IkReal(-1.00000000000000))*(x4146)*(x4167)))+(((cj4)*(r00)*(x4147)))+(((IkReal(-1.00000000000000))*(x4141)*(x4144)*(x4161)))+(((IkReal(-1.00000000000000))*(r11)*(x4142)*(x4154)))+(((IkReal(-1.00000000000000))*(x4144)*(x4154)*(x4163)))+(((IkReal(-1.00000000000000))*(x4141)*(x4144)*(x4160)))+(((IkReal(-1.00000000000000))*(x4143)*(x4144)*(x4164)))+(((IkReal(-1.00000000000000))*(r01)*(x4141)*(x4142)))+(((IkReal(-1.00000000000000))*(r02)*(x4141)*(x4146))));
evalcond[6]=((IkReal(0.0690000000000000))+(((r11)*(x4147)*(x4148)))+(((cj0)*(r12)*(x4162)))+(((IkReal(-1.00000000000000))*(x4162)*(x4165)))+(((r00)*(x4143)*(x4145)))+(((IkReal(-1.00000000000000))*(py)*(x4141)))+(((IkReal(-1.00000000000000))*(sj0)*(x4148)*(x4160)))+(((x4157)*(x4158)))+(((IkReal(-1.00000000000000))*(r00)*(x4143)*(x4148)))+(((r10)*(x4148)*(x4155)))+(((IkReal(-1.00000000000000))*(r10)*(x4145)*(x4155)))+(((IkReal(-1.00000000000000))*(x4150)*(x4151)))+(((sj0)*(x4145)*(x4160)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(r11)*(x4145)*(x4147))));
evalcond[7]=((((r01)*(sj4)*(x4155)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4141)*(x4142)))+(((IkReal(-1.00000000000000))*(r11)*(x4150)*(x4156)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x4141)*(x4156)))+(((IkReal(-1.00000000000000))*(r10)*(x4154)*(x4166)))+(((IkReal(-1.00000000000000))*(x4142)*(x4150)*(x4164)))+(((r11)*(sj4)*(x4143)))+(((IkReal(-1.00000000000000))*(r02)*(x4141)*(x4149)))+(((IkReal(-1.00000000000000))*(r00)*(x4141)*(x4166)))+(((IkReal(-1.00000000000000))*(x4149)*(x4167))));
evalcond[8]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x4143)*(x4145)))+(((r10)*(x4143)*(x4148)))+(((IkReal(-1.00000000000000))*(r00)*(x4145)*(x4155)))+(((r00)*(x4148)*(x4155)))+(((x4150)*(x4157)))+(((r12)*(sj0)*(x4162)))+(((IkReal(-1.00000000000000))*(sj0)*(x4145)*(x4163)))+(((sj0)*(x4148)*(x4163)))+(((IkReal(-1.00000000000000))*(r01)*(x4145)*(x4147)))+(((cj0)*(r02)*(x4162)))+(((r01)*(x4147)*(x4148)))+(((IkReal(-1.00000000000000))*(py)*(x4154)))+(((x4151)*(x4158)))+(((IkReal(-1.00000000000000))*(px)*(x4141))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4168=((IkReal(1.00000000000000))*(sj5));
IkReal x4169=((cj6)*(r21));
IkReal x4170=((r20)*(sj6));
IkReal x4171=((IkReal(1.00000000000000))*(cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(x4170)*(x4171)))+(((IkReal(-1.00000000000000))*(x4169)*(x4171)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x4168)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x4168)*(x4170)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x4168)*(x4169))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x4170)*(x4171)))+(((IkReal(-1.00000000000000))*(x4169)*(x4171)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x4168)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))+IKsqr(((((IkReal(-1.00000000000000))*(x4168)*(x4170)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x4168)*(x4169)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x4170)*(x4171)))+(((IkReal(-1.00000000000000))*(x4169)*(x4171)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x4168)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))), ((((IkReal(-1.00000000000000))*(x4168)*(x4170)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x4168)*(x4169)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4172=IKsin(j3);
IkReal x4173=IKcos(j3);
IkReal x4174=((sj0)*(sj5));
IkReal x4175=((r00)*(sj6));
IkReal x4176=((cj6)*(r01));
IkReal x4177=((cj5)*(sj0));
IkReal x4178=((cj0)*(cj5));
IkReal x4179=((cj6)*(sj4));
IkReal x4180=((sj4)*(sj6));
IkReal x4181=((cj0)*(r11));
IkReal x4182=((cj4)*(cj6));
IkReal x4183=((cj4)*(sj6));
IkReal x4184=((IkReal(1.00000000000000))*(cj0));
IkReal x4185=((cj4)*(sj5));
IkReal x4186=((sj5)*(sj6));
IkReal x4187=((cj6)*(sj5));
evalcond[0]=((((r21)*(x4187)))+(x4173)+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r20)*(x4186))));
evalcond[1]=((x4172)+(((r22)*(x4185)))+(((cj5)*(r21)*(x4182)))+(((IkReal(-1.00000000000000))*(r21)*(x4180)))+(((r20)*(x4179)))+(((cj5)*(r20)*(x4183))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4181)*(x4187)))+(((IkReal(-1.00000000000000))*(r02)*(x4177)))+(((r12)*(x4178)))+(((x4174)*(x4175)))+(((x4174)*(x4176)))+(((IkReal(-1.00000000000000))*(r10)*(x4184)*(x4186)))+(((IkReal(-1.00000000000000))*(x4172))));
evalcond[3]=((((r00)*(sj0)*(x4179)))+(((x4180)*(x4181)))+(((cj4)*(r02)*(x4174)))+(x4173)+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x4180)))+(((cj4)*(x4176)*(x4177)))+(((cj4)*(x4175)*(x4177)))+(((IkReal(-1.00000000000000))*(r10)*(x4179)*(x4184)))+(((IkReal(-1.00000000000000))*(r10)*(x4178)*(x4183)))+(((IkReal(-1.00000000000000))*(r12)*(x4184)*(x4185)))+(((IkReal(-1.00000000000000))*(r11)*(x4178)*(x4182))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4188=((IkReal(1.00000000000000))*(cj0));
IkReal x4189=((cj4)*(sj6));
IkReal x4190=((sj0)*(sj4));
IkReal x4191=((cj5)*(sj6));
IkReal x4192=((sj4)*(sj5));
IkReal x4193=((r12)*(sj5));
IkReal x4194=((IkReal(0.374290000000000))*(cj5));
IkReal x4195=((r02)*(sj0));
IkReal x4196=((r20)*(sj4));
IkReal x4197=((IkReal(1.00000000000000))*(sj0));
IkReal x4198=((IkReal(1.00000000000000))*(cj5));
IkReal x4199=((cj0)*(r10));
IkReal x4200=((cj4)*(cj6));
IkReal x4201=((r00)*(sj0));
IkReal x4202=((cj6)*(r21));
IkReal x4203=((IkReal(0.374290000000000))*(sj5));
IkReal x4204=((cj0)*(r00));
IkReal x4205=((IkReal(0.0100000000000000))*(sj5));
IkReal x4206=((cj0)*(r02));
IkReal x4207=((cj5)*(sj4));
IkReal x4208=((cj6)*(r01));
IkReal x4209=((cj6)*(r11));
IkReal x4210=((r01)*(sj0));
IkReal x4211=((r10)*(sj0));
IkReal x4212=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x4213=((sj6)*(x4203));
IkReal x4214=((cj0)*(cj6)*(x4203));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x4202)))+(((IkReal(-1.00000000000000))*(r22)*(x4198)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(-1.00000000000000))+(((x4202)*(x4207)))+(((x4191)*(x4196)))+(((r21)*(x4189)))+(((r22)*(x4192)))+(((IkReal(-1.00000000000000))*(r20)*(x4200))));
evalcond[3]=((((IkReal(-0.0100000000000000))*(r20)*(x4191)))+(((IkReal(-0.0100000000000000))*(cj5)*(x4202)))+(((x4202)*(x4203)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x4194)))+(((IkReal(-1.00000000000000))*(r22)*(x4205)))+(((r20)*(x4213))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj5)*(r21)*(x4200)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r20)*(x4189)))+(((cj6)*(x4196))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(sj4)*(x4188)*(x4191)))+(((r00)*(x4190)*(x4191)))+(((IkReal(-1.00000000000000))*(r00)*(x4197)*(x4200)))+(((IkReal(-1.00000000000000))*(r11)*(x4188)*(x4189)))+(((x4199)*(x4200)))+(((cj5)*(x4190)*(x4208)))+(((r02)*(sj5)*(x4190)))+(((IkReal(-1.00000000000000))*(r12)*(x4188)*(x4192)))+(((IkReal(-1.00000000000000))*(x4188)*(x4207)*(x4209)))+(((x4189)*(x4210))));
evalcond[6]=((((x4200)*(x4204)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x4188)*(x4191)))+(((x4200)*(x4211)))+(((IkReal(-1.00000000000000))*(r01)*(x4188)*(x4189)))+(((IkReal(-1.00000000000000))*(x4188)*(x4207)*(x4208)))+(((IkReal(-1.00000000000000))*(r02)*(x4188)*(x4192)))+(((IkReal(-1.00000000000000))*(x4190)*(x4198)*(x4209)))+(((IkReal(-1.00000000000000))*(x4190)*(x4193)))+(((IkReal(-1.00000000000000))*(r11)*(x4189)*(x4197)))+(((IkReal(-1.00000000000000))*(r10)*(x4190)*(x4191))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(x4203)*(x4209)))+(((IkReal(-1.00000000000000))*(x4195)*(x4205)))+(((sj0)*(x4203)*(x4208)))+(((IkReal(-1.00000000000000))*(py)*(x4188)))+(((cj0)*(r12)*(x4194)))+(((x4201)*(x4213)))+(((IkReal(-1.00000000000000))*(x4194)*(x4195)))+(((IkReal(-1.00000000000000))*(x4199)*(x4213)))+(((IkReal(0.0100000000000000))*(x4191)*(x4199)))+(((IkReal(0.0100000000000000))*(cj0)*(x4193)))+(((px)*(sj0)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4209)))+(((IkReal(-0.0100000000000000))*(x4191)*(x4201)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x4208))));
evalcond[8]=((IkReal(0.433420000000000))+(((r12)*(sj0)*(x4194)))+(((IkReal(0.0100000000000000))*(x4191)*(x4211)))+(((x4194)*(x4206)))+(((x4205)*(x4206)))+(((IkReal(-1.00000000000000))*(px)*(x4188)))+(((IkReal(-1.00000000000000))*(cj0)*(x4203)*(x4208)))+(((IkReal(0.0100000000000000))*(sj0)*(x4193)))+(((IkReal(-1.00000000000000))*(py)*(x4197)))+(((IkReal(-1.00000000000000))*(sj0)*(x4203)*(x4209)))+(((IkReal(0.0100000000000000))*(x4191)*(x4204)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4208)))+(((IkReal(-1.00000000000000))*(x4211)*(x4213)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x4209)))+(((IkReal(-1.00000000000000))*(x4204)*(x4213))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4215=((cj0)*(cj5));
IkReal x4216=((IkReal(1.00000000000000))*(cj0));
IkReal x4217=((cj6)*(r11));
IkReal x4218=((r10)*(sj6));
IkReal x4219=((cj5)*(sj0));
IkReal x4220=((r00)*(sj5)*(sj6));
IkReal x4221=((cj6)*(r01)*(sj5));
IkReal x4222=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((sj0)*(x4221)))+(((IkReal(-1.00000000000000))*(r02)*(x4219)))+(((IkReal(-1.00000000000000))*(sj5)*(x4216)*(x4217)))+(((sj0)*(x4220)))+(((r12)*(x4215)))+(((IkReal(-1.00000000000000))*(sj5)*(x4216)*(x4218))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x4218)*(x4222)))+(((IkReal(-1.00000000000000))*(x4216)*(x4221)))+(((IkReal(-1.00000000000000))*(x4217)*(x4222)))+(((r02)*(x4215)))+(((r12)*(x4219)))+(((IkReal(-1.00000000000000))*(x4216)*(x4220))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj0)*(x4221)))+(((IkReal(-1.00000000000000))*(r02)*(x4219)))+(((IkReal(-1.00000000000000))*(sj5)*(x4216)*(x4217)))+(((sj0)*(x4220)))+(((r12)*(x4215)))+(((IkReal(-1.00000000000000))*(sj5)*(x4216)*(x4218)))))+IKsqr(((((IkReal(-1.00000000000000))*(x4218)*(x4222)))+(((IkReal(-1.00000000000000))*(x4216)*(x4221)))+(((IkReal(-1.00000000000000))*(x4217)*(x4222)))+(((r02)*(x4215)))+(((r12)*(x4219)))+(((IkReal(-1.00000000000000))*(x4216)*(x4220)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj0)*(x4221)))+(((IkReal(-1.00000000000000))*(r02)*(x4219)))+(((IkReal(-1.00000000000000))*(sj5)*(x4216)*(x4217)))+(((sj0)*(x4220)))+(((r12)*(x4215)))+(((IkReal(-1.00000000000000))*(sj5)*(x4216)*(x4218)))), ((((IkReal(-1.00000000000000))*(x4218)*(x4222)))+(((IkReal(-1.00000000000000))*(x4216)*(x4221)))+(((IkReal(-1.00000000000000))*(x4217)*(x4222)))+(((r02)*(x4215)))+(((r12)*(x4219)))+(((IkReal(-1.00000000000000))*(x4216)*(x4220)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4223=IKcos(j3);
IkReal x4224=((sj0)*(sj5));
IkReal x4225=((r00)*(sj6));
IkReal x4226=((cj6)*(sj0));
IkReal x4227=((IkReal(1.00000000000000))*(cj4));
IkReal x4228=((r00)*(sj4));
IkReal x4229=((cj0)*(cj5));
IkReal x4230=((cj5)*(sj0));
IkReal x4231=((cj6)*(r11));
IkReal x4232=((r10)*(sj6));
IkReal x4233=((cj0)*(sj5));
IkReal x4234=((r10)*(sj4));
IkReal x4235=((IkReal(1.00000000000000))*(IKsin(j3)));
IkReal x4236=((cj4)*(cj5)*(r01));
IkReal x4237=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x4238=((cj0)*(sj4)*(sj6));
IkReal x4239=((sj0)*(sj4)*(sj6));
evalcond[0]=((((cj6)*(r01)*(x4224)))+(((IkReal(-1.00000000000000))*(x4231)*(x4233)))+(((x4224)*(x4225)))+(((IkReal(-1.00000000000000))*(x4232)*(x4233)))+(((IkReal(-1.00000000000000))*(x4235)))+(((r12)*(x4229)))+(((IkReal(-1.00000000000000))*(r02)*(x4230))));
evalcond[1]=((((r02)*(x4229)))+(((r12)*(x4230)))+(((IkReal(-1.00000000000000))*(x4225)*(x4233)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4233)))+(((IkReal(-1.00000000000000))*(x4223)))+(((IkReal(-1.00000000000000))*(x4224)*(x4232)))+(((IkReal(-1.00000000000000))*(x4224)*(x4231))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4234)*(x4237)))+(((x4226)*(x4236)))+(((cj4)*(x4225)*(x4230)))+(((IkReal(-1.00000000000000))*(r12)*(x4227)*(x4233)))+(((cj4)*(r02)*(x4224)))+(x4223)+(((IkReal(-1.00000000000000))*(r01)*(x4239)))+(((x4226)*(x4228)))+(((IkReal(-1.00000000000000))*(x4227)*(x4229)*(x4232)))+(((IkReal(-1.00000000000000))*(x4227)*(x4229)*(x4231)))+(((r11)*(x4238))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4227)*(x4229)))+(((IkReal(-1.00000000000000))*(x4227)*(x4230)*(x4232)))+(((IkReal(-1.00000000000000))*(r12)*(x4224)*(x4227)))+(((IkReal(-1.00000000000000))*(x4228)*(x4237)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x4226)*(x4227)))+(((r01)*(x4238)))+(((IkReal(-1.00000000000000))*(x4226)*(x4234)))+(((IkReal(-1.00000000000000))*(r02)*(x4227)*(x4233)))+(((r11)*(x4239)))+(((IkReal(-1.00000000000000))*(x4235)))+(((IkReal(-1.00000000000000))*(x4225)*(x4227)*(x4229))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4240=((IkReal(1.00000000000000))*(cj0));
IkReal x4241=((cj4)*(sj6));
IkReal x4242=((sj0)*(sj4));
IkReal x4243=((cj5)*(sj6));
IkReal x4244=((sj4)*(sj5));
IkReal x4245=((r12)*(sj5));
IkReal x4246=((IkReal(0.374290000000000))*(cj5));
IkReal x4247=((r02)*(sj0));
IkReal x4248=((r20)*(sj4));
IkReal x4249=((IkReal(1.00000000000000))*(sj0));
IkReal x4250=((IkReal(1.00000000000000))*(cj5));
IkReal x4251=((cj0)*(r10));
IkReal x4252=((cj4)*(cj6));
IkReal x4253=((r00)*(sj0));
IkReal x4254=((cj6)*(r21));
IkReal x4255=((IkReal(0.374290000000000))*(sj5));
IkReal x4256=((cj0)*(r00));
IkReal x4257=((IkReal(0.0100000000000000))*(sj5));
IkReal x4258=((cj0)*(r02));
IkReal x4259=((cj5)*(sj4));
IkReal x4260=((cj6)*(r01));
IkReal x4261=((cj6)*(r11));
IkReal x4262=((r01)*(sj0));
IkReal x4263=((r10)*(sj0));
IkReal x4264=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x4265=((sj6)*(x4255));
IkReal x4266=((cj0)*(cj6)*(x4255));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j1, IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x4250)))+(((sj5)*(x4254)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(1.00000000000000))+(((x4243)*(x4248)))+(((r21)*(x4241)))+(((IkReal(-1.00000000000000))*(r20)*(x4252)))+(((x4254)*(x4259)))+(((r22)*(x4244))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x4246)))+(((x4254)*(x4255)))+(((IkReal(-0.0100000000000000))*(cj5)*(x4254)))+(pz)+(((IkReal(-0.0100000000000000))*(r20)*(x4243)))+(((IkReal(-1.00000000000000))*(r22)*(x4257)))+(((r20)*(x4265))));
evalcond[4]=((((cj5)*(r21)*(x4252)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(x4248)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r20)*(x4241))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(sj4)*(x4240)*(x4243)))+(((r00)*(x4242)*(x4243)))+(((IkReal(-1.00000000000000))*(r12)*(x4240)*(x4244)))+(((IkReal(-1.00000000000000))*(r11)*(x4240)*(x4241)))+(((x4251)*(x4252)))+(((x4241)*(x4262)))+(((r02)*(sj5)*(x4242)))+(((IkReal(-1.00000000000000))*(x4240)*(x4259)*(x4261)))+(((IkReal(-1.00000000000000))*(r00)*(x4249)*(x4252)))+(((cj5)*(x4242)*(x4260))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r00)*(sj4)*(x4240)*(x4243)))+(((IkReal(-1.00000000000000))*(x4242)*(x4250)*(x4261)))+(((IkReal(-1.00000000000000))*(r01)*(x4240)*(x4241)))+(((x4252)*(x4256)))+(((IkReal(-1.00000000000000))*(r11)*(x4241)*(x4249)))+(((IkReal(-1.00000000000000))*(r10)*(x4242)*(x4243)))+(((IkReal(-1.00000000000000))*(x4242)*(x4245)))+(((IkReal(-1.00000000000000))*(x4240)*(x4259)*(x4260)))+(((x4252)*(x4263)))+(((IkReal(-1.00000000000000))*(r02)*(x4240)*(x4244))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(0.0100000000000000))*(x4243)*(x4251)))+(((IkReal(-1.00000000000000))*(cj0)*(x4255)*(x4261)))+(((x4253)*(x4265)))+(((IkReal(-0.0100000000000000))*(x4243)*(x4253)))+(((IkReal(0.0100000000000000))*(cj0)*(x4245)))+(((IkReal(-1.00000000000000))*(x4246)*(x4247)))+(((cj0)*(r12)*(x4246)))+(((IkReal(-1.00000000000000))*(x4251)*(x4265)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4261)))+(((sj0)*(x4255)*(x4260)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x4260)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x4247)*(x4257)))+(((IkReal(-1.00000000000000))*(py)*(x4240))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(-1.00000000000000))*(x4256)*(x4265)))+(((IkReal(-1.00000000000000))*(py)*(x4249)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x4261)))+(((IkReal(-1.00000000000000))*(cj0)*(x4255)*(x4260)))+(((r12)*(sj0)*(x4246)))+(((IkReal(-1.00000000000000))*(sj0)*(x4255)*(x4261)))+(((IkReal(0.0100000000000000))*(x4243)*(x4256)))+(((IkReal(0.0100000000000000))*(x4243)*(x4263)))+(((IkReal(-1.00000000000000))*(px)*(x4240)))+(((IkReal(-1.00000000000000))*(x4263)*(x4265)))+(((x4257)*(x4258)))+(((x4246)*(x4258)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4260)))+(((IkReal(0.0100000000000000))*(sj0)*(x4245))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4267=((sj0)*(sj5));
IkReal x4268=((r00)*(sj6));
IkReal x4269=((IkReal(1.00000000000000))*(cj5));
IkReal x4270=((cj6)*(r11));
IkReal x4271=((cj6)*(r01));
IkReal x4272=((r10)*(sj6));
IkReal x4273=((cj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(x4272)*(x4273)))+(((cj0)*(cj5)*(r12)))+(((x4267)*(x4268)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4269)))+(((x4267)*(x4271)))+(((IkReal(-1.00000000000000))*(x4270)*(x4273))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x4271)*(x4273)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4269)))+(((x4267)*(x4270)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4269)))+(((x4268)*(x4273)))+(((x4267)*(x4272))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x4272)*(x4273)))+(((cj0)*(cj5)*(r12)))+(((x4267)*(x4268)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4269)))+(((x4267)*(x4271)))+(((IkReal(-1.00000000000000))*(x4270)*(x4273)))))+IKsqr(((((x4271)*(x4273)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4269)))+(((x4267)*(x4270)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4269)))+(((x4268)*(x4273)))+(((x4267)*(x4272)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x4272)*(x4273)))+(((cj0)*(cj5)*(r12)))+(((x4267)*(x4268)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4269)))+(((x4267)*(x4271)))+(((IkReal(-1.00000000000000))*(x4270)*(x4273)))), ((((x4271)*(x4273)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4269)))+(((x4267)*(x4270)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4269)))+(((x4268)*(x4273)))+(((x4267)*(x4272)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4274=IKcos(j3);
IkReal x4275=IKsin(j3);
IkReal x4276=((sj0)*(sj5));
IkReal x4277=((r00)*(sj6));
IkReal x4278=((cj6)*(sj0));
IkReal x4279=((IkReal(1.00000000000000))*(cj4));
IkReal x4280=((r00)*(sj4));
IkReal x4281=((cj0)*(cj5));
IkReal x4282=((cj5)*(sj0));
IkReal x4283=((cj6)*(r11));
IkReal x4284=((r10)*(sj6));
IkReal x4285=((cj0)*(sj5));
IkReal x4286=((r10)*(sj4));
IkReal x4287=((cj4)*(cj5)*(r01));
IkReal x4288=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x4289=((cj0)*(sj4)*(sj6));
IkReal x4290=((sj0)*(sj4)*(sj6));
evalcond[0]=((((cj6)*(r01)*(x4276)))+(((IkReal(-1.00000000000000))*(x4284)*(x4285)))+(((IkReal(-1.00000000000000))*(x4283)*(x4285)))+(((IkReal(-1.00000000000000))*(x4275)))+(((x4276)*(x4277)))+(((IkReal(-1.00000000000000))*(r02)*(x4282)))+(((r12)*(x4281))));
evalcond[1]=((((r02)*(x4281)))+(((IkReal(-1.00000000000000))*(x4277)*(x4285)))+(((IkReal(-1.00000000000000))*(x4276)*(x4284)))+(x4274)+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4285)))+(((r12)*(x4282)))+(((IkReal(-1.00000000000000))*(x4276)*(x4283))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4279)*(x4281)*(x4284)))+(((x4278)*(x4287)))+(((r11)*(x4289)))+(((x4278)*(x4280)))+(((IkReal(-1.00000000000000))*(r01)*(x4290)))+(x4274)+(((IkReal(-1.00000000000000))*(x4286)*(x4288)))+(((IkReal(-1.00000000000000))*(r12)*(x4279)*(x4285)))+(((cj4)*(r02)*(x4276)))+(((IkReal(-1.00000000000000))*(x4279)*(x4281)*(x4283)))+(((cj4)*(x4277)*(x4282))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r02)*(x4279)*(x4285)))+(((IkReal(-1.00000000000000))*(x4280)*(x4288)))+(x4275)+(((r01)*(x4289)))+(((r11)*(x4290)))+(((IkReal(-1.00000000000000))*(x4279)*(x4282)*(x4284)))+(((IkReal(-1.00000000000000))*(x4278)*(x4286)))+(((IkReal(-1.00000000000000))*(x4277)*(x4279)*(x4281)))+(((IkReal(-1.00000000000000))*(r12)*(x4276)*(x4279)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4279)*(x4281)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x4278)*(x4279))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4291=((cj0)*(cj5));
IkReal x4292=((IkReal(1.00000000000000))*(cj0));
IkReal x4293=((cj6)*(r11));
IkReal x4294=((r10)*(sj6));
IkReal x4295=((cj5)*(sj0));
IkReal x4296=((r00)*(sj5)*(sj6));
IkReal x4297=((cj6)*(r01)*(sj5));
IkReal x4298=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x4292)*(x4294)))+(((sj0)*(x4296)))+(((sj0)*(x4297)))+(((IkReal(-1.00000000000000))*(r02)*(x4295)))+(((IkReal(-1.00000000000000))*(sj5)*(x4292)*(x4293)))+(((r12)*(x4291))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((r12)*(x4295)))+(((IkReal(-1.00000000000000))*(x4293)*(x4298)))+(((r02)*(x4291)))+(((IkReal(-1.00000000000000))*(x4294)*(x4298)))+(((IkReal(-1.00000000000000))*(x4292)*(x4297)))+(((IkReal(-1.00000000000000))*(x4292)*(x4296))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x4292)*(x4294)))+(((sj0)*(x4296)))+(((sj0)*(x4297)))+(((IkReal(-1.00000000000000))*(r02)*(x4295)))+(((IkReal(-1.00000000000000))*(sj5)*(x4292)*(x4293)))+(((r12)*(x4291)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((r12)*(x4295)))+(((IkReal(-1.00000000000000))*(x4293)*(x4298)))+(((r02)*(x4291)))+(((IkReal(-1.00000000000000))*(x4294)*(x4298)))+(((IkReal(-1.00000000000000))*(x4292)*(x4297)))+(((IkReal(-1.00000000000000))*(x4292)*(x4296)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x4292)*(x4294)))+(((sj0)*(x4296)))+(((sj0)*(x4297)))+(((IkReal(-1.00000000000000))*(r02)*(x4295)))+(((IkReal(-1.00000000000000))*(sj5)*(x4292)*(x4293)))+(((r12)*(x4291)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((r12)*(x4295)))+(((IkReal(-1.00000000000000))*(x4293)*(x4298)))+(((r02)*(x4291)))+(((IkReal(-1.00000000000000))*(x4294)*(x4298)))+(((IkReal(-1.00000000000000))*(x4292)*(x4297)))+(((IkReal(-1.00000000000000))*(x4292)*(x4296)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4299=IKsin(j3);
IkReal x4300=IKcos(j3);
IkReal x4301=((sj0)*(sj5));
IkReal x4302=((r00)*(sj6));
IkReal x4303=((cj6)*(r01));
IkReal x4304=((cj4)*(cj5));
IkReal x4305=((IkReal(1.00000000000000))*(cj0));
IkReal x4306=((cj5)*(r12));
IkReal x4307=((IkReal(1.00000000000000))*(sj0));
IkReal x4308=((cj6)*(r11));
IkReal x4309=((cj5)*(r02));
IkReal x4310=((IkReal(1.00000000000000))*(cj1));
IkReal x4311=((cj6)*(sj4));
IkReal x4312=((cj6)*(r21));
IkReal x4313=((r20)*(sj6));
IkReal x4314=((r10)*(sj6));
IkReal x4315=((sj4)*(sj6));
IkReal x4316=((cj4)*(r02));
IkReal x4317=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x4318=((IkReal(1.00000000000000))*(x4299));
IkReal x4319=((cj0)*(x4315));
evalcond[0]=((((sj5)*(x4313)))+(((IkReal(-1.00000000000000))*(sj1)*(x4300)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4312))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj1)*(x4318)))+(((x4304)*(x4313)))+(((IkReal(-1.00000000000000))*(r21)*(x4315)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x4311)))+(((x4304)*(x4312))));
evalcond[2]=((((cj0)*(x4306)))+(((IkReal(-1.00000000000000))*(sj5)*(x4305)*(x4314)))+(((x4301)*(x4303)))+(((IkReal(-1.00000000000000))*(x4318)))+(((IkReal(-1.00000000000000))*(x4307)*(x4309)))+(((x4301)*(x4302)))+(((IkReal(-1.00000000000000))*(sj5)*(x4305)*(x4308))));
evalcond[3]=((((sj0)*(x4306)))+(((IkReal(-1.00000000000000))*(x4301)*(x4308)))+(((IkReal(-1.00000000000000))*(sj5)*(x4302)*(x4305)))+(((IkReal(-1.00000000000000))*(x4301)*(x4314)))+(((IkReal(-1.00000000000000))*(x4300)*(x4310)))+(((IkReal(-1.00000000000000))*(sj5)*(x4303)*(x4305)))+(((cj0)*(x4309))));
evalcond[4]=((((r11)*(x4319)))+(((x4301)*(x4316)))+(((IkReal(-1.00000000000000))*(x4304)*(x4305)*(x4308)))+(((IkReal(-1.00000000000000))*(x4304)*(x4305)*(x4314)))+(((IkReal(-1.00000000000000))*(r10)*(x4305)*(x4311)))+(((sj0)*(x4303)*(x4304)))+(((IkReal(-1.00000000000000))*(r01)*(x4307)*(x4315)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x4305)))+(((sj0)*(x4302)*(x4304)))+(x4300)+(((r00)*(sj0)*(x4311))));
evalcond[5]=((((r11)*(sj0)*(x4315)))+(((IkReal(-1.00000000000000))*(r00)*(x4305)*(x4311)))+(((IkReal(-1.00000000000000))*(r10)*(x4307)*(x4311)))+(((IkReal(-1.00000000000000))*(x4299)*(x4310)))+(((IkReal(-1.00000000000000))*(x4304)*(x4307)*(x4308)))+(((IkReal(-1.00000000000000))*(x4301)*(x4317)))+(((IkReal(-1.00000000000000))*(sj5)*(x4305)*(x4316)))+(((IkReal(-1.00000000000000))*(x4303)*(x4304)*(x4305)))+(((IkReal(-1.00000000000000))*(x4304)*(x4307)*(x4314)))+(((IkReal(-1.00000000000000))*(x4302)*(x4304)*(x4305)))+(((r01)*(x4319))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4320=((sj5)*(sj6));
IkReal x4321=((cj6)*(sj5));
IkReal x4322=((IkReal(1.00000000000000))*(cj0));
IkReal x4323=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r10)*(x4320)*(x4322)))+(((r01)*(sj0)*(x4321)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4323)))+(((cj0)*(cj5)*(r12)))+(((r00)*(sj0)*(x4320)))+(((IkReal(-1.00000000000000))*(r11)*(x4321)*(x4322))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x4321)))+(((IkReal(-1.00000000000000))*(r22)*(x4323)))+(((r20)*(x4320))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r10)*(x4320)*(x4322)))+(((r01)*(sj0)*(x4321)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4323)))+(((cj0)*(cj5)*(r12)))+(((r00)*(sj0)*(x4320)))+(((IkReal(-1.00000000000000))*(r11)*(x4321)*(x4322)))))+IKsqr(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x4321)))+(((IkReal(-1.00000000000000))*(r22)*(x4323)))+(((r20)*(x4320)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r10)*(x4320)*(x4322)))+(((r01)*(sj0)*(x4321)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4323)))+(((cj0)*(cj5)*(r12)))+(((r00)*(sj0)*(x4320)))+(((IkReal(-1.00000000000000))*(r11)*(x4321)*(x4322)))), ((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x4321)))+(((IkReal(-1.00000000000000))*(r22)*(x4323)))+(((r20)*(x4320)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4324=IKsin(j3);
IkReal x4325=IKcos(j3);
IkReal x4326=((sj0)*(sj5));
IkReal x4327=((r00)*(sj6));
IkReal x4328=((cj6)*(r01));
IkReal x4329=((cj4)*(cj5));
IkReal x4330=((IkReal(1.00000000000000))*(cj0));
IkReal x4331=((cj5)*(r12));
IkReal x4332=((IkReal(1.00000000000000))*(sj0));
IkReal x4333=((cj6)*(r11));
IkReal x4334=((cj5)*(r02));
IkReal x4335=((IkReal(1.00000000000000))*(cj1));
IkReal x4336=((cj6)*(sj4));
IkReal x4337=((cj6)*(r21));
IkReal x4338=((r20)*(sj6));
IkReal x4339=((r10)*(sj6));
IkReal x4340=((sj4)*(sj6));
IkReal x4341=((cj4)*(r02));
IkReal x4342=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x4343=((IkReal(1.00000000000000))*(x4324));
IkReal x4344=((cj0)*(x4340));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj1)*(x4325)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4337)))+(((sj5)*(x4338))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(x4340)))+(((r20)*(x4336)))+(((x4329)*(x4337)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(sj1)*(x4343)))+(((x4329)*(x4338))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4343)))+(((cj0)*(x4331)))+(((x4326)*(x4328)))+(((x4326)*(x4327)))+(((IkReal(-1.00000000000000))*(x4332)*(x4334)))+(((IkReal(-1.00000000000000))*(sj5)*(x4330)*(x4339)))+(((IkReal(-1.00000000000000))*(sj5)*(x4330)*(x4333))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x4327)*(x4330)))+(((IkReal(-1.00000000000000))*(x4325)*(x4335)))+(((cj0)*(x4334)))+(((IkReal(-1.00000000000000))*(x4326)*(x4339)))+(((sj0)*(x4331)))+(((IkReal(-1.00000000000000))*(sj5)*(x4328)*(x4330)))+(((IkReal(-1.00000000000000))*(x4326)*(x4333))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x4330)))+(((IkReal(-1.00000000000000))*(x4329)*(x4330)*(x4333)))+(((IkReal(-1.00000000000000))*(x4329)*(x4330)*(x4339)))+(((r00)*(sj0)*(x4336)))+(((r11)*(x4344)))+(((sj0)*(x4327)*(x4329)))+(((IkReal(-1.00000000000000))*(r01)*(x4332)*(x4340)))+(((IkReal(-1.00000000000000))*(r10)*(x4330)*(x4336)))+(((x4326)*(x4341)))+(((sj0)*(x4328)*(x4329)))+(x4325));
evalcond[5]=((((r01)*(x4344)))+(((IkReal(-1.00000000000000))*(r00)*(x4330)*(x4336)))+(((IkReal(-1.00000000000000))*(x4326)*(x4342)))+(((IkReal(-1.00000000000000))*(x4328)*(x4329)*(x4330)))+(((IkReal(-1.00000000000000))*(r10)*(x4332)*(x4336)))+(((IkReal(-1.00000000000000))*(x4327)*(x4329)*(x4330)))+(((IkReal(-1.00000000000000))*(x4329)*(x4332)*(x4339)))+(((IkReal(-1.00000000000000))*(x4324)*(x4335)))+(((IkReal(-1.00000000000000))*(x4329)*(x4332)*(x4333)))+(((IkReal(-1.00000000000000))*(sj5)*(x4330)*(x4341)))+(((r11)*(sj0)*(x4340))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4345=((r20)*(sj6));
IkReal x4346=((cj4)*(cj5));
IkReal x4347=((cj6)*(r21));
if( IKabs(((gconst17)*(((((x4345)*(x4346)))+(((x4346)*(x4347)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst17)*(((((sj5)*(x4345)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4347))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst17)*(((((x4345)*(x4346)))+(((x4346)*(x4347)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))))), ((gconst17)*(((((sj5)*(x4345)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4347)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4348=IKsin(j3);
IkReal x4349=IKcos(j3);
IkReal x4350=((sj0)*(sj5));
IkReal x4351=((r00)*(sj6));
IkReal x4352=((cj6)*(r01));
IkReal x4353=((cj4)*(cj5));
IkReal x4354=((IkReal(1.00000000000000))*(cj0));
IkReal x4355=((cj5)*(r12));
IkReal x4356=((IkReal(1.00000000000000))*(sj0));
IkReal x4357=((cj6)*(r11));
IkReal x4358=((cj5)*(r02));
IkReal x4359=((IkReal(1.00000000000000))*(cj1));
IkReal x4360=((cj6)*(sj4));
IkReal x4361=((cj6)*(r21));
IkReal x4362=((r20)*(sj6));
IkReal x4363=((r10)*(sj6));
IkReal x4364=((sj4)*(sj6));
IkReal x4365=((cj4)*(r02));
IkReal x4366=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x4367=((IkReal(1.00000000000000))*(x4348));
IkReal x4368=((cj0)*(x4364));
evalcond[0]=((((sj5)*(x4361)))+(((sj5)*(x4362)))+(((IkReal(-1.00000000000000))*(sj1)*(x4349)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((x4353)*(x4362)))+(((x4353)*(x4361)))+(((IkReal(-1.00000000000000))*(r21)*(x4364)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x4360)))+(((IkReal(-1.00000000000000))*(sj1)*(x4367))));
evalcond[2]=((((cj0)*(x4355)))+(((IkReal(-1.00000000000000))*(x4356)*(x4358)))+(((x4350)*(x4352)))+(((IkReal(-1.00000000000000))*(sj5)*(x4354)*(x4363)))+(((IkReal(-1.00000000000000))*(sj5)*(x4354)*(x4357)))+(((IkReal(-1.00000000000000))*(x4367)))+(((x4350)*(x4351))));
evalcond[3]=((((cj0)*(x4358)))+(((IkReal(-1.00000000000000))*(x4349)*(x4359)))+(((IkReal(-1.00000000000000))*(sj5)*(x4352)*(x4354)))+(((IkReal(-1.00000000000000))*(sj5)*(x4351)*(x4354)))+(((IkReal(-1.00000000000000))*(x4350)*(x4357)))+(((sj0)*(x4355)))+(((IkReal(-1.00000000000000))*(x4350)*(x4363))));
evalcond[4]=((((r00)*(sj0)*(x4360)))+(((IkReal(-1.00000000000000))*(r01)*(x4356)*(x4364)))+(((sj0)*(x4352)*(x4353)))+(((sj0)*(x4351)*(x4353)))+(((IkReal(-1.00000000000000))*(x4353)*(x4354)*(x4363)))+(((IkReal(-1.00000000000000))*(x4353)*(x4354)*(x4357)))+(x4349)+(((IkReal(-1.00000000000000))*(r10)*(x4354)*(x4360)))+(((x4350)*(x4365)))+(((r11)*(x4368)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x4354))));
evalcond[5]=((((r01)*(x4368)))+(((IkReal(-1.00000000000000))*(sj5)*(x4354)*(x4365)))+(((IkReal(-1.00000000000000))*(x4353)*(x4356)*(x4357)))+(((r11)*(sj0)*(x4364)))+(((IkReal(-1.00000000000000))*(x4350)*(x4366)))+(((IkReal(-1.00000000000000))*(x4353)*(x4356)*(x4363)))+(((IkReal(-1.00000000000000))*(x4351)*(x4353)*(x4354)))+(((IkReal(-1.00000000000000))*(x4348)*(x4359)))+(((IkReal(-1.00000000000000))*(r10)*(x4356)*(x4360)))+(((IkReal(-1.00000000000000))*(r00)*(x4354)*(x4360)))+(((IkReal(-1.00000000000000))*(x4352)*(x4353)*(x4354))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x4369=((cj1)*(sj6));
IkReal x4370=((r01)*(sj0));
IkReal x4371=((cj0)*(r11));
IkReal x4372=((cj1)*(cj6));
IkReal x4373=((cj0)*(r10));
IkReal x4374=((IkReal(1.00000000000000))*(sj0));
IkReal x4375=((cj1)*(sj5));
if( IKabs(((gconst13)*(((((IkReal(-1.00000000000000))*(r00)*(x4372)*(x4374)))+(((x4372)*(x4373)))+(((x4369)*(x4370)))+(((IkReal(-1.00000000000000))*(x4369)*(x4371))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst13)*(((((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4369)*(x4374)))+(((IkReal(-1.00000000000000))*(r02)*(x4374)*(x4375)))+(((cj0)*(r12)*(x4375)))+(((cj5)*(x4369)*(x4373)))+(((IkReal(-1.00000000000000))*(cj5)*(x4370)*(x4372)))+(((cj5)*(x4371)*(x4372))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst13)*(((((IkReal(-1.00000000000000))*(r00)*(x4372)*(x4374)))+(((x4372)*(x4373)))+(((x4369)*(x4370)))+(((IkReal(-1.00000000000000))*(x4369)*(x4371)))))), ((gconst13)*(((((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4369)*(x4374)))+(((IkReal(-1.00000000000000))*(r02)*(x4374)*(x4375)))+(((cj0)*(r12)*(x4375)))+(((cj5)*(x4369)*(x4373)))+(((IkReal(-1.00000000000000))*(cj5)*(x4370)*(x4372)))+(((cj5)*(x4371)*(x4372)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x4376=IKsin(j4);
IkReal x4377=IKcos(j4);
IkReal x4378=((r00)*(sj6));
IkReal x4379=((cj6)*(r01));
IkReal x4380=((IkReal(1.00000000000000))*(cj0));
IkReal x4381=((IkReal(1.00000000000000))*(sj0));
IkReal x4382=((r10)*(sj6));
IkReal x4383=((sj5)*(x4376));
IkReal x4384=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x4385=((cj5)*(x4376));
IkReal x4386=((cj6)*(x4377));
IkReal x4387=((sj0)*(x4385));
IkReal x4388=((r01)*(sj6)*(x4377));
IkReal x4389=((r11)*(sj6)*(x4377));
evalcond[0]=((((r22)*(x4383)))+(((r20)*(sj6)*(x4385)))+(((r21)*(sj6)*(x4377)))+(((IkReal(-1.00000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(r20)*(x4386)))+(((cj6)*(r21)*(x4385))));
evalcond[1]=((((x4378)*(x4387)))+(((IkReal(-1.00000000000000))*(r12)*(x4380)*(x4383)))+(((cj0)*(r10)*(x4386)))+(((IkReal(-1.00000000000000))*(r00)*(x4381)*(x4386)))+(((r02)*(sj0)*(x4383)))+(((IkReal(-1.00000000000000))*(x4380)*(x4382)*(x4385)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x4380)*(x4385)))+(((IkReal(-1.00000000000000))*(x4380)*(x4389)))+(((x4379)*(x4387)))+(((sj0)*(x4388))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4379)*(x4380)*(x4385)))+(((cj0)*(r00)*(x4386)))+(((IkReal(-1.00000000000000))*(r12)*(x4381)*(x4383)))+(sj1)+(((IkReal(-1.00000000000000))*(x4380)*(x4388)))+(((r10)*(sj0)*(x4386)))+(((IkReal(-1.00000000000000))*(x4381)*(x4389)))+(((IkReal(-1.00000000000000))*(r02)*(x4380)*(x4383)))+(((IkReal(-1.00000000000000))*(x4381)*(x4382)*(x4385)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x4381)*(x4385)))+(((IkReal(-1.00000000000000))*(x4378)*(x4380)*(x4385))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst17;
gconst17=IKsign(sj1);
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x4390=((IkReal(1.00000000000000))*(cj0));
IkReal x4391=((cj4)*(sj6));
IkReal x4392=((sj0)*(sj6));
IkReal x4393=((cj5)*(sj4));
IkReal x4394=((IkReal(0.374290000000000))*(sj5));
IkReal x4395=((sj4)*(sj5));
IkReal x4396=((cj0)*(cj6));
IkReal x4397=((IkReal(0.0100000000000000))*(cj5));
IkReal x4398=((cj4)*(sj5));
IkReal x4399=((cj5)*(sj0));
IkReal x4400=((IkReal(0.374290000000000))*(r02));
IkReal x4401=((r20)*(sj6));
IkReal x4402=((cj6)*(r21));
IkReal x4403=((IkReal(1.00000000000000))*(sj0));
IkReal x4404=((cj0)*(sj6));
IkReal x4405=((cj4)*(cj6));
IkReal x4406=((IkReal(0.374290000000000))*(r12));
IkReal x4407=((cj0)*(cj5));
IkReal x4408=((cj6)*(sj5));
IkReal x4409=((cj6)*(r01));
IkReal x4410=((r00)*(sj6));
IkReal x4411=((IkReal(0.0100000000000000))*(sj5));
IkReal x4412=((cj6)*(r11));
IkReal x4413=((IkReal(1.00000000000000))*(r10));
IkReal x4414=((r02)*(sj0));
IkReal x4415=((cj6)*(sj4));
IkReal x4416=((r12)*(x4403));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x4405)))+(((x4393)*(x4402)))+(((x4393)*(x4401)))+(((r21)*(x4391)))+(((r22)*(x4395))));
evalcond[2]=((IkReal(0.364420000000000))+(((IkReal(-1.00000000000000))*(r22)*(x4411)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x4397)*(x4402)))+(((IkReal(-1.00000000000000))*(x4397)*(x4401)))+(((x4394)*(x4401)))+(pz)+(((x4394)*(x4402))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x4403)*(x4408)))+(((r12)*(x4399)))+(((IkReal(-1.00000000000000))*(r01)*(x4390)*(x4408)))+(((IkReal(-1.00000000000000))*(sj5)*(x4392)*(x4413)))+(((IkReal(-1.00000000000000))*(sj5)*(x4390)*(x4410)))+(((r02)*(x4407))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r11)*(x4390)*(x4391)))+(((r01)*(sj0)*(x4391)))+(((IkReal(-1.00000000000000))*(r00)*(x4403)*(x4405)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x4390)*(x4393)))+(((IkReal(-1.00000000000000))*(r12)*(x4390)*(x4395)))+(((x4395)*(x4414)))+(((IkReal(-1.00000000000000))*(x4390)*(x4393)*(x4412)))+(((r00)*(x4392)*(x4393)))+(((sj0)*(x4393)*(x4409)))+(((cj4)*(r10)*(x4396))));
evalcond[5]=((IkReal(1.00000000000000))+(((r10)*(sj0)*(x4405)))+(((IkReal(-1.00000000000000))*(x4390)*(x4393)*(x4410)))+(((IkReal(-1.00000000000000))*(x4393)*(x4403)*(x4412)))+(((IkReal(-1.00000000000000))*(r11)*(x4391)*(x4403)))+(((cj4)*(r00)*(x4396)))+(((IkReal(-1.00000000000000))*(x4390)*(x4393)*(x4409)))+(((IkReal(-1.00000000000000))*(r01)*(x4390)*(x4391)))+(((IkReal(-1.00000000000000))*(x4395)*(x4416)))+(((IkReal(-1.00000000000000))*(r02)*(x4390)*(x4395)))+(((IkReal(-1.00000000000000))*(x4392)*(x4393)*(x4413))));
evalcond[6]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(x4411)*(x4414)))+(((IkReal(-1.00000000000000))*(r00)*(x4392)*(x4397)))+(((IkReal(-1.00000000000000))*(x4399)*(x4400)))+(((r11)*(x4396)*(x4397)))+(((IkReal(-1.00000000000000))*(sj0)*(x4397)*(x4409)))+(((IkReal(-1.00000000000000))*(py)*(x4390)))+(((r10)*(x4397)*(x4404)))+(((x4406)*(x4407)))+(((cj0)*(r12)*(x4411)))+(((IkReal(-1.00000000000000))*(r11)*(x4394)*(x4396)))+(((IkReal(-1.00000000000000))*(r10)*(x4394)*(x4404)))+(((px)*(sj0)))+(((r00)*(x4392)*(x4394)))+(((sj0)*(x4394)*(x4409))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4390)*(x4391)))+(((IkReal(-1.00000000000000))*(x4398)*(x4416)))+(((r01)*(sj4)*(x4404)))+(((IkReal(-1.00000000000000))*(r02)*(x4390)*(x4398)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x4390)*(x4405)))+(((IkReal(-1.00000000000000))*(r00)*(x4390)*(x4415)))+(((IkReal(-1.00000000000000))*(r10)*(x4403)*(x4415)))+(((IkReal(-1.00000000000000))*(r11)*(x4399)*(x4405)))+(((r11)*(sj4)*(x4392)))+(((IkReal(-1.00000000000000))*(x4391)*(x4399)*(x4413))));
evalcond[8]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(px)*(x4390)))+(((r01)*(x4396)*(x4397)))+(((r12)*(sj0)*(x4411)))+(((x4399)*(x4406)))+(((IkReal(-1.00000000000000))*(r01)*(x4394)*(x4396)))+(((IkReal(-1.00000000000000))*(r00)*(x4394)*(x4404)))+(((IkReal(-1.00000000000000))*(sj0)*(x4394)*(x4412)))+(((IkReal(-1.00000000000000))*(r10)*(x4392)*(x4394)))+(((cj0)*(r02)*(x4411)))+(((r10)*(x4392)*(x4397)))+(((IkReal(-1.00000000000000))*(py)*(x4403)))+(((r00)*(x4397)*(x4404)))+(((sj0)*(x4397)*(x4412)))+(((x4400)*(x4407))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4417=((r20)*(sj6));
IkReal x4418=((cj4)*(cj5));
IkReal x4419=((cj6)*(r21));
if( IKabs(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x4417)*(x4418)))+(((x4418)*(x4419))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x4419)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4417))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x4417)*(x4418)))+(((x4418)*(x4419)))))+IKsqr(((((sj5)*(x4419)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4417)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x4417)*(x4418)))+(((x4418)*(x4419)))), ((((sj5)*(x4419)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4417)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4420=IKcos(j3);
IkReal x4421=((sj0)*(sj5));
IkReal x4422=((r00)*(sj6));
IkReal x4423=((cj6)*(r01));
IkReal x4424=((cj5)*(sj0));
IkReal x4425=((cj0)*(cj5));
IkReal x4426=((cj6)*(sj4));
IkReal x4427=((sj4)*(sj6));
IkReal x4428=((cj0)*(r11));
IkReal x4429=((cj4)*(cj6));
IkReal x4430=((cj4)*(sj6));
IkReal x4431=((IkReal(1.00000000000000))*(cj0));
IkReal x4432=((cj4)*(sj5));
IkReal x4433=((sj5)*(sj6));
IkReal x4434=((cj6)*(sj5));
IkReal x4435=((IkReal(1.00000000000000))*(IKsin(j3)));
evalcond[0]=((((r21)*(x4434)))+(((r20)*(x4433)))+(((IkReal(-1.00000000000000))*(x4420)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(x4427)))+(((r20)*(x4426)))+(((r22)*(x4432)))+(((cj5)*(r20)*(x4430)))+(((IkReal(-1.00000000000000))*(x4435)))+(((cj5)*(r21)*(x4429))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r02)*(x4424)))+(((r12)*(x4425)))+(((IkReal(-1.00000000000000))*(x4428)*(x4434)))+(((x4421)*(x4422)))+(((x4421)*(x4423)))+(((IkReal(-1.00000000000000))*(r10)*(x4431)*(x4433)))+(((IkReal(-1.00000000000000))*(x4435))));
evalcond[3]=((((cj4)*(r02)*(x4421)))+(((cj4)*(x4423)*(x4424)))+(((IkReal(-1.00000000000000))*(r11)*(x4425)*(x4429)))+(((IkReal(-1.00000000000000))*(r12)*(x4431)*(x4432)))+(x4420)+(((x4427)*(x4428)))+(((cj4)*(x4422)*(x4424)))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x4427)))+(((IkReal(-1.00000000000000))*(r10)*(x4425)*(x4430)))+(((r00)*(sj0)*(x4426)))+(((IkReal(-1.00000000000000))*(r10)*(x4426)*(x4431))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4436=((IkReal(1.00000000000000))*(cj0));
IkReal x4437=((cj4)*(sj6));
IkReal x4438=((sj0)*(sj6));
IkReal x4439=((cj5)*(sj4));
IkReal x4440=((IkReal(0.374290000000000))*(sj5));
IkReal x4441=((sj4)*(sj5));
IkReal x4442=((cj0)*(cj6));
IkReal x4443=((IkReal(0.0100000000000000))*(cj5));
IkReal x4444=((cj4)*(sj5));
IkReal x4445=((cj5)*(sj0));
IkReal x4446=((IkReal(0.374290000000000))*(r02));
IkReal x4447=((r20)*(sj6));
IkReal x4448=((cj6)*(r21));
IkReal x4449=((IkReal(1.00000000000000))*(sj0));
IkReal x4450=((cj0)*(sj6));
IkReal x4451=((cj4)*(cj6));
IkReal x4452=((IkReal(0.374290000000000))*(r12));
IkReal x4453=((cj0)*(cj5));
IkReal x4454=((cj6)*(sj5));
IkReal x4455=((cj6)*(r01));
IkReal x4456=((r00)*(sj6));
IkReal x4457=((IkReal(0.0100000000000000))*(sj5));
IkReal x4458=((cj6)*(r11));
IkReal x4459=((IkReal(1.00000000000000))*(r10));
IkReal x4460=((r02)*(sj0));
IkReal x4461=((cj6)*(sj4));
IkReal x4462=((r12)*(x4449));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x4437)))+(((x4439)*(x4448)))+(((x4439)*(x4447)))+(((r22)*(x4441)))+(((IkReal(-1.00000000000000))*(r20)*(x4451))));
evalcond[2]=((IkReal(-0.364420000000000))+(((IkReal(-1.00000000000000))*(x4443)*(x4447)))+(((x4440)*(x4447)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x4443)*(x4448)))+(((IkReal(-1.00000000000000))*(r22)*(x4457)))+(pz)+(((x4440)*(x4448))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x4436)*(x4456)))+(((IkReal(-1.00000000000000))*(r11)*(x4449)*(x4454)))+(((r12)*(x4445)))+(((IkReal(-1.00000000000000))*(r01)*(x4436)*(x4454)))+(((r02)*(x4453)))+(((IkReal(-1.00000000000000))*(sj5)*(x4438)*(x4459))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x4436)*(x4439)))+(((IkReal(-1.00000000000000))*(r11)*(x4436)*(x4437)))+(((IkReal(-1.00000000000000))*(r00)*(x4449)*(x4451)))+(((IkReal(-1.00000000000000))*(x4436)*(x4439)*(x4458)))+(((sj0)*(x4439)*(x4455)))+(((IkReal(-1.00000000000000))*(r12)*(x4436)*(x4441)))+(((r01)*(sj0)*(x4437)))+(((x4441)*(x4460)))+(((cj4)*(r10)*(x4442)))+(((r00)*(x4438)*(x4439))));
evalcond[5]=((IkReal(-1.00000000000000))+(((r10)*(sj0)*(x4451)))+(((cj4)*(r00)*(x4442)))+(((IkReal(-1.00000000000000))*(x4439)*(x4449)*(x4458)))+(((IkReal(-1.00000000000000))*(r02)*(x4436)*(x4441)))+(((IkReal(-1.00000000000000))*(x4441)*(x4462)))+(((IkReal(-1.00000000000000))*(x4436)*(x4439)*(x4455)))+(((IkReal(-1.00000000000000))*(x4436)*(x4439)*(x4456)))+(((IkReal(-1.00000000000000))*(r11)*(x4437)*(x4449)))+(((IkReal(-1.00000000000000))*(x4438)*(x4439)*(x4459)))+(((IkReal(-1.00000000000000))*(r01)*(x4436)*(x4437))));
evalcond[6]=((IkReal(0.0690000000000000))+(((r10)*(x4443)*(x4450)))+(((IkReal(-1.00000000000000))*(r11)*(x4440)*(x4442)))+(((x4452)*(x4453)))+(((cj0)*(r12)*(x4457)))+(((r00)*(x4438)*(x4440)))+(((IkReal(-1.00000000000000))*(x4445)*(x4446)))+(((r11)*(x4442)*(x4443)))+(((IkReal(-1.00000000000000))*(sj0)*(x4443)*(x4455)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(py)*(x4436)))+(((IkReal(-1.00000000000000))*(r00)*(x4438)*(x4443)))+(((IkReal(-1.00000000000000))*(x4457)*(x4460)))+(((IkReal(-1.00000000000000))*(r10)*(x4440)*(x4450)))+(((sj0)*(x4440)*(x4455))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x4437)*(x4445)*(x4459)))+(((r11)*(sj4)*(x4438)))+(((IkReal(-1.00000000000000))*(r11)*(x4445)*(x4451)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x4436)*(x4437)))+(((IkReal(-1.00000000000000))*(x4444)*(x4462)))+(((r01)*(sj4)*(x4450)))+(((IkReal(-1.00000000000000))*(r00)*(x4436)*(x4461)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x4436)*(x4451)))+(((IkReal(-1.00000000000000))*(r02)*(x4436)*(x4444)))+(((IkReal(-1.00000000000000))*(r10)*(x4449)*(x4461))));
evalcond[8]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r00)*(x4440)*(x4450)))+(((r01)*(x4442)*(x4443)))+(((r10)*(x4438)*(x4443)))+(((x4445)*(x4452)))+(((r12)*(sj0)*(x4457)))+(((IkReal(-1.00000000000000))*(px)*(x4436)))+(((IkReal(-1.00000000000000))*(py)*(x4449)))+(((cj0)*(r02)*(x4457)))+(((IkReal(-1.00000000000000))*(r01)*(x4440)*(x4442)))+(((IkReal(-1.00000000000000))*(r10)*(x4438)*(x4440)))+(((r00)*(x4443)*(x4450)))+(((sj0)*(x4443)*(x4458)))+(((x4446)*(x4453)))+(((IkReal(-1.00000000000000))*(sj0)*(x4440)*(x4458))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4463=((IkReal(1.00000000000000))*(sj5));
IkReal x4464=((cj6)*(r21));
IkReal x4465=((r20)*(sj6));
IkReal x4466=((IkReal(1.00000000000000))*(cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(x4464)*(x4466)))+(((IkReal(-1.00000000000000))*(x4465)*(x4466)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x4463)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x4463)*(x4465)))+(((IkReal(-1.00000000000000))*(x4463)*(x4464)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x4464)*(x4466)))+(((IkReal(-1.00000000000000))*(x4465)*(x4466)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x4463)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))+IKsqr(((((IkReal(-1.00000000000000))*(x4463)*(x4465)))+(((IkReal(-1.00000000000000))*(x4463)*(x4464)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x4464)*(x4466)))+(((IkReal(-1.00000000000000))*(x4465)*(x4466)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x4463)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))), ((((IkReal(-1.00000000000000))*(x4463)*(x4465)))+(((IkReal(-1.00000000000000))*(x4463)*(x4464)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4467=IKsin(j3);
IkReal x4468=IKcos(j3);
IkReal x4469=((sj0)*(sj5));
IkReal x4470=((r00)*(sj6));
IkReal x4471=((cj6)*(r01));
IkReal x4472=((cj5)*(sj0));
IkReal x4473=((cj0)*(cj5));
IkReal x4474=((cj6)*(sj4));
IkReal x4475=((sj4)*(sj6));
IkReal x4476=((cj0)*(r11));
IkReal x4477=((cj4)*(cj6));
IkReal x4478=((cj4)*(sj6));
IkReal x4479=((IkReal(1.00000000000000))*(cj0));
IkReal x4480=((cj4)*(sj5));
IkReal x4481=((sj5)*(sj6));
IkReal x4482=((cj6)*(sj5));
evalcond[0]=((x4468)+(((r21)*(x4482)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r20)*(x4481))));
evalcond[1]=((x4467)+(((r22)*(x4480)))+(((cj5)*(r20)*(x4478)))+(((cj5)*(r21)*(x4477)))+(((IkReal(-1.00000000000000))*(r21)*(x4475)))+(((r20)*(x4474))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x4479)*(x4481)))+(((r12)*(x4473)))+(((x4469)*(x4471)))+(((IkReal(-1.00000000000000))*(x4476)*(x4482)))+(((x4469)*(x4470)))+(((IkReal(-1.00000000000000))*(r02)*(x4472)))+(((IkReal(-1.00000000000000))*(x4467))));
evalcond[3]=((x4468)+(((r00)*(sj0)*(x4474)))+(((IkReal(-1.00000000000000))*(r10)*(x4474)*(x4479)))+(((cj4)*(x4471)*(x4472)))+(((cj4)*(r02)*(x4469)))+(((x4475)*(x4476)))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x4475)))+(((IkReal(-1.00000000000000))*(r11)*(x4473)*(x4477)))+(((IkReal(-1.00000000000000))*(r10)*(x4473)*(x4478)))+(((IkReal(-1.00000000000000))*(r12)*(x4479)*(x4480)))+(((cj4)*(x4470)*(x4472))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4483=((IkReal(1.00000000000000))*(cj0));
IkReal x4484=((cj4)*(sj6));
IkReal x4485=((sj0)*(sj4));
IkReal x4486=((cj5)*(sj6));
IkReal x4487=((sj4)*(sj5));
IkReal x4488=((r12)*(sj5));
IkReal x4489=((IkReal(0.374290000000000))*(cj5));
IkReal x4490=((r02)*(sj0));
IkReal x4491=((r20)*(sj4));
IkReal x4492=((IkReal(1.00000000000000))*(sj0));
IkReal x4493=((IkReal(1.00000000000000))*(cj5));
IkReal x4494=((cj0)*(r10));
IkReal x4495=((cj4)*(cj6));
IkReal x4496=((r00)*(sj0));
IkReal x4497=((cj6)*(r21));
IkReal x4498=((IkReal(0.374290000000000))*(sj5));
IkReal x4499=((cj0)*(r00));
IkReal x4500=((IkReal(0.0100000000000000))*(sj5));
IkReal x4501=((cj0)*(r02));
IkReal x4502=((cj5)*(sj4));
IkReal x4503=((cj6)*(r01));
IkReal x4504=((cj6)*(r11));
IkReal x4505=((r01)*(sj0));
IkReal x4506=((r10)*(sj0));
IkReal x4507=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x4508=((sj6)*(x4498));
IkReal x4509=((cj0)*(cj6)*(x4498));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x4497)))+(((IkReal(-1.00000000000000))*(r22)*(x4493)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r20)*(x4495)))+(((x4486)*(x4491)))+(((r22)*(x4487)))+(((r21)*(x4484)))+(((x4497)*(x4502))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x4489)))+(((IkReal(-1.00000000000000))*(r22)*(x4500)))+(((IkReal(-0.0100000000000000))*(cj5)*(x4497)))+(((IkReal(-0.0100000000000000))*(r20)*(x4486)))+(pz)+(((r20)*(x4508)))+(((x4497)*(x4498))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(x4491)))+(((cj5)*(r20)*(x4484)))+(((cj5)*(r21)*(x4495))));
evalcond[5]=((((x4494)*(x4495)))+(((x4484)*(x4505)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x4483)*(x4486)))+(((r02)*(sj5)*(x4485)))+(((r00)*(x4485)*(x4486)))+(((IkReal(-1.00000000000000))*(r12)*(x4483)*(x4487)))+(((IkReal(-1.00000000000000))*(r00)*(x4492)*(x4495)))+(((IkReal(-1.00000000000000))*(r11)*(x4483)*(x4484)))+(((IkReal(-1.00000000000000))*(x4483)*(x4502)*(x4504)))+(((cj5)*(x4485)*(x4503))));
evalcond[6]=((((x4495)*(x4506)))+(((x4495)*(x4499)))+(((IkReal(-1.00000000000000))*(x4483)*(x4502)*(x4503)))+(((IkReal(-1.00000000000000))*(r11)*(x4484)*(x4492)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x4483)*(x4486)))+(((IkReal(-1.00000000000000))*(r02)*(x4483)*(x4487)))+(((IkReal(-1.00000000000000))*(x4485)*(x4493)*(x4504)))+(((IkReal(-1.00000000000000))*(r10)*(x4485)*(x4486)))+(((IkReal(-1.00000000000000))*(x4485)*(x4488)))+(((IkReal(-1.00000000000000))*(r01)*(x4483)*(x4484))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(-0.0100000000000000))*(x4486)*(x4496)))+(((IkReal(-1.00000000000000))*(x4490)*(x4500)))+(((IkReal(-1.00000000000000))*(py)*(x4483)))+(((IkReal(-1.00000000000000))*(cj0)*(x4498)*(x4504)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x4503)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4504)))+(((sj0)*(x4498)*(x4503)))+(((x4496)*(x4508)))+(((IkReal(0.0100000000000000))*(cj0)*(x4488)))+(((IkReal(0.0100000000000000))*(x4486)*(x4494)))+(((cj0)*(r12)*(x4489)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x4489)*(x4490)))+(((IkReal(-1.00000000000000))*(x4494)*(x4508))));
evalcond[8]=((IkReal(0.433420000000000))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4503)))+(((x4500)*(x4501)))+(((x4489)*(x4501)))+(((r12)*(sj0)*(x4489)))+(((IkReal(0.0100000000000000))*(sj0)*(x4488)))+(((IkReal(-1.00000000000000))*(sj0)*(x4498)*(x4504)))+(((IkReal(-1.00000000000000))*(py)*(x4492)))+(((IkReal(-1.00000000000000))*(x4506)*(x4508)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x4504)))+(((IkReal(0.0100000000000000))*(x4486)*(x4506)))+(((IkReal(-1.00000000000000))*(x4499)*(x4508)))+(((IkReal(0.0100000000000000))*(x4486)*(x4499)))+(((IkReal(-1.00000000000000))*(px)*(x4483)))+(((IkReal(-1.00000000000000))*(cj0)*(x4498)*(x4503))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4510=((cj0)*(cj5));
IkReal x4511=((IkReal(1.00000000000000))*(cj0));
IkReal x4512=((cj6)*(r11));
IkReal x4513=((r10)*(sj6));
IkReal x4514=((cj5)*(sj0));
IkReal x4515=((r00)*(sj5)*(sj6));
IkReal x4516=((cj6)*(r01)*(sj5));
IkReal x4517=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x4511)*(x4512)))+(((IkReal(-1.00000000000000))*(sj5)*(x4511)*(x4513)))+(((r12)*(x4510)))+(((IkReal(-1.00000000000000))*(r02)*(x4514)))+(((sj0)*(x4515)))+(((sj0)*(x4516))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r02)*(x4510)))+(((r12)*(x4514)))+(((IkReal(-1.00000000000000))*(x4513)*(x4517)))+(((IkReal(-1.00000000000000))*(x4511)*(x4516)))+(((IkReal(-1.00000000000000))*(x4512)*(x4517)))+(((IkReal(-1.00000000000000))*(x4511)*(x4515))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x4511)*(x4512)))+(((IkReal(-1.00000000000000))*(sj5)*(x4511)*(x4513)))+(((r12)*(x4510)))+(((IkReal(-1.00000000000000))*(r02)*(x4514)))+(((sj0)*(x4515)))+(((sj0)*(x4516)))))+IKsqr(((((r02)*(x4510)))+(((r12)*(x4514)))+(((IkReal(-1.00000000000000))*(x4513)*(x4517)))+(((IkReal(-1.00000000000000))*(x4511)*(x4516)))+(((IkReal(-1.00000000000000))*(x4512)*(x4517)))+(((IkReal(-1.00000000000000))*(x4511)*(x4515)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x4511)*(x4512)))+(((IkReal(-1.00000000000000))*(sj5)*(x4511)*(x4513)))+(((r12)*(x4510)))+(((IkReal(-1.00000000000000))*(r02)*(x4514)))+(((sj0)*(x4515)))+(((sj0)*(x4516)))), ((((r02)*(x4510)))+(((r12)*(x4514)))+(((IkReal(-1.00000000000000))*(x4513)*(x4517)))+(((IkReal(-1.00000000000000))*(x4511)*(x4516)))+(((IkReal(-1.00000000000000))*(x4512)*(x4517)))+(((IkReal(-1.00000000000000))*(x4511)*(x4515)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4518=IKcos(j3);
IkReal x4519=((sj0)*(sj5));
IkReal x4520=((r00)*(sj6));
IkReal x4521=((cj6)*(sj0));
IkReal x4522=((IkReal(1.00000000000000))*(cj4));
IkReal x4523=((r00)*(sj4));
IkReal x4524=((cj0)*(cj5));
IkReal x4525=((cj5)*(sj0));
IkReal x4526=((cj6)*(r11));
IkReal x4527=((r10)*(sj6));
IkReal x4528=((cj0)*(sj5));
IkReal x4529=((r10)*(sj4));
IkReal x4530=((IkReal(1.00000000000000))*(IKsin(j3)));
IkReal x4531=((cj4)*(cj5)*(r01));
IkReal x4532=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x4533=((cj0)*(sj4)*(sj6));
IkReal x4534=((sj0)*(sj4)*(sj6));
evalcond[0]=((((x4519)*(x4520)))+(((IkReal(-1.00000000000000))*(x4526)*(x4528)))+(((r12)*(x4524)))+(((IkReal(-1.00000000000000))*(r02)*(x4525)))+(((cj6)*(r01)*(x4519)))+(((IkReal(-1.00000000000000))*(x4530)))+(((IkReal(-1.00000000000000))*(x4527)*(x4528))));
evalcond[1]=((((r02)*(x4524)))+(((IkReal(-1.00000000000000))*(x4518)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4528)))+(((IkReal(-1.00000000000000))*(x4519)*(x4526)))+(((IkReal(-1.00000000000000))*(x4520)*(x4528)))+(((r12)*(x4525)))+(((IkReal(-1.00000000000000))*(x4519)*(x4527))));
evalcond[2]=((x4518)+(((x4521)*(x4523)))+(((IkReal(-1.00000000000000))*(x4522)*(x4524)*(x4527)))+(((IkReal(-1.00000000000000))*(r12)*(x4522)*(x4528)))+(((IkReal(-1.00000000000000))*(x4522)*(x4524)*(x4526)))+(((IkReal(-1.00000000000000))*(r01)*(x4534)))+(((IkReal(-1.00000000000000))*(x4529)*(x4532)))+(((cj4)*(r02)*(x4519)))+(((r11)*(x4533)))+(((x4521)*(x4531)))+(((cj4)*(x4520)*(x4525))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4522)*(x4524)))+(((IkReal(-1.00000000000000))*(x4521)*(x4529)))+(((IkReal(-1.00000000000000))*(x4522)*(x4525)*(x4527)))+(((IkReal(-1.00000000000000))*(x4520)*(x4522)*(x4524)))+(((IkReal(-1.00000000000000))*(x4523)*(x4532)))+(((r11)*(x4534)))+(((r01)*(x4533)))+(((IkReal(-1.00000000000000))*(r12)*(x4519)*(x4522)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x4521)*(x4522)))+(((IkReal(-1.00000000000000))*(x4530)))+(((IkReal(-1.00000000000000))*(r02)*(x4522)*(x4528))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4535=((IkReal(1.00000000000000))*(cj0));
IkReal x4536=((cj4)*(sj6));
IkReal x4537=((sj0)*(sj4));
IkReal x4538=((cj5)*(sj6));
IkReal x4539=((sj4)*(sj5));
IkReal x4540=((r12)*(sj5));
IkReal x4541=((IkReal(0.374290000000000))*(cj5));
IkReal x4542=((r02)*(sj0));
IkReal x4543=((r20)*(sj4));
IkReal x4544=((IkReal(1.00000000000000))*(sj0));
IkReal x4545=((IkReal(1.00000000000000))*(cj5));
IkReal x4546=((cj0)*(r10));
IkReal x4547=((cj4)*(cj6));
IkReal x4548=((r00)*(sj0));
IkReal x4549=((cj6)*(r21));
IkReal x4550=((IkReal(0.374290000000000))*(sj5));
IkReal x4551=((cj0)*(r00));
IkReal x4552=((IkReal(0.0100000000000000))*(sj5));
IkReal x4553=((cj0)*(r02));
IkReal x4554=((cj5)*(sj4));
IkReal x4555=((cj6)*(r01));
IkReal x4556=((cj6)*(r11));
IkReal x4557=((r01)*(sj0));
IkReal x4558=((r10)*(sj0));
IkReal x4559=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x4560=((sj6)*(x4550));
IkReal x4561=((cj0)*(cj6)*(x4550));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j1, IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x4545)))+(((sj5)*(x4549)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r20)*(x4547)))+(((r21)*(x4536)))+(((x4538)*(x4543)))+(((r22)*(x4539)))+(((x4549)*(x4554))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x4541)))+(((IkReal(-0.0100000000000000))*(r20)*(x4538)))+(((x4549)*(x4550)))+(pz)+(((r20)*(x4560)))+(((IkReal(-1.00000000000000))*(r22)*(x4552)))+(((IkReal(-0.0100000000000000))*(cj5)*(x4549))));
evalcond[4]=((((cj5)*(r21)*(x4547)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj5)*(r20)*(x4536)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(x4543))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(sj4)*(x4535)*(x4538)))+(((cj5)*(x4537)*(x4555)))+(((IkReal(-1.00000000000000))*(r12)*(x4535)*(x4539)))+(((IkReal(-1.00000000000000))*(x4535)*(x4554)*(x4556)))+(((r00)*(x4537)*(x4538)))+(((r02)*(sj5)*(x4537)))+(((IkReal(-1.00000000000000))*(r00)*(x4544)*(x4547)))+(((IkReal(-1.00000000000000))*(r11)*(x4535)*(x4536)))+(((x4536)*(x4557)))+(((x4546)*(x4547))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r10)*(x4537)*(x4538)))+(((IkReal(-1.00000000000000))*(x4537)*(x4545)*(x4556)))+(((x4547)*(x4558)))+(((x4547)*(x4551)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x4535)*(x4538)))+(((IkReal(-1.00000000000000))*(x4537)*(x4540)))+(((IkReal(-1.00000000000000))*(r01)*(x4535)*(x4536)))+(((IkReal(-1.00000000000000))*(r02)*(x4535)*(x4539)))+(((IkReal(-1.00000000000000))*(r11)*(x4536)*(x4544)))+(((IkReal(-1.00000000000000))*(x4535)*(x4554)*(x4555))));
evalcond[7]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(x4550)*(x4556)))+(((IkReal(0.0100000000000000))*(cj0)*(x4540)))+(((IkReal(-1.00000000000000))*(py)*(x4535)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x4555)))+(((IkReal(-1.00000000000000))*(x4546)*(x4560)))+(((IkReal(-0.0100000000000000))*(x4538)*(x4548)))+(((x4548)*(x4560)))+(((IkReal(-1.00000000000000))*(x4542)*(x4552)))+(((IkReal(0.0100000000000000))*(x4538)*(x4546)))+(((cj0)*(r12)*(x4541)))+(((px)*(sj0)))+(((sj0)*(x4550)*(x4555)))+(((IkReal(-1.00000000000000))*(x4541)*(x4542)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4556))));
evalcond[8]=((IkReal(-0.295420000000000))+(((x4552)*(x4553)))+(((IkReal(-1.00000000000000))*(x4558)*(x4560)))+(((IkReal(-1.00000000000000))*(py)*(x4544)))+(((x4541)*(x4553)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x4555)))+(((IkReal(-1.00000000000000))*(px)*(x4535)))+(((IkReal(-1.00000000000000))*(sj0)*(x4550)*(x4556)))+(((IkReal(-1.00000000000000))*(cj0)*(x4550)*(x4555)))+(((r12)*(sj0)*(x4541)))+(((IkReal(0.0100000000000000))*(x4538)*(x4551)))+(((IkReal(-1.00000000000000))*(x4551)*(x4560)))+(((IkReal(0.0100000000000000))*(sj0)*(x4540)))+(((IkReal(0.0100000000000000))*(x4538)*(x4558)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x4556))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4562=((sj0)*(sj5));
IkReal x4563=((r00)*(sj6));
IkReal x4564=((IkReal(1.00000000000000))*(cj5));
IkReal x4565=((cj6)*(r11));
IkReal x4566=((cj6)*(r01));
IkReal x4567=((r10)*(sj6));
IkReal x4568=((cj0)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(x4565)*(x4568)))+(((x4562)*(x4563)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4564)))+(((IkReal(-1.00000000000000))*(x4567)*(x4568)))+(((cj0)*(cj5)*(r12)))+(((x4562)*(x4566))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x4563)*(x4568)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4564)))+(((x4562)*(x4567)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4564)))+(((x4562)*(x4565)))+(((x4566)*(x4568))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x4565)*(x4568)))+(((x4562)*(x4563)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4564)))+(((IkReal(-1.00000000000000))*(x4567)*(x4568)))+(((cj0)*(cj5)*(r12)))+(((x4562)*(x4566)))))+IKsqr(((((x4563)*(x4568)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4564)))+(((x4562)*(x4567)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4564)))+(((x4562)*(x4565)))+(((x4566)*(x4568)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x4565)*(x4568)))+(((x4562)*(x4563)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4564)))+(((IkReal(-1.00000000000000))*(x4567)*(x4568)))+(((cj0)*(cj5)*(r12)))+(((x4562)*(x4566)))), ((((x4563)*(x4568)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4564)))+(((x4562)*(x4567)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4564)))+(((x4562)*(x4565)))+(((x4566)*(x4568)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4569=IKcos(j3);
IkReal x4570=IKsin(j3);
IkReal x4571=((sj0)*(sj5));
IkReal x4572=((r00)*(sj6));
IkReal x4573=((cj6)*(sj0));
IkReal x4574=((IkReal(1.00000000000000))*(cj4));
IkReal x4575=((r00)*(sj4));
IkReal x4576=((cj0)*(cj5));
IkReal x4577=((cj5)*(sj0));
IkReal x4578=((cj6)*(r11));
IkReal x4579=((r10)*(sj6));
IkReal x4580=((cj0)*(sj5));
IkReal x4581=((r10)*(sj4));
IkReal x4582=((cj4)*(cj5)*(r01));
IkReal x4583=((IkReal(1.00000000000000))*(cj0)*(cj6));
IkReal x4584=((cj0)*(sj4)*(sj6));
IkReal x4585=((sj0)*(sj4)*(sj6));
evalcond[0]=((((r12)*(x4576)))+(((cj6)*(r01)*(x4571)))+(((IkReal(-1.00000000000000))*(x4579)*(x4580)))+(((x4571)*(x4572)))+(((IkReal(-1.00000000000000))*(x4578)*(x4580)))+(((IkReal(-1.00000000000000))*(x4570)))+(((IkReal(-1.00000000000000))*(r02)*(x4577))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4571)*(x4579)))+(((IkReal(-1.00000000000000))*(x4571)*(x4578)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4580)))+(((r12)*(x4577)))+(((IkReal(-1.00000000000000))*(x4572)*(x4580)))+(x4569)+(((r02)*(x4576))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x4585)))+(((IkReal(-1.00000000000000))*(x4574)*(x4576)*(x4579)))+(((IkReal(-1.00000000000000))*(x4574)*(x4576)*(x4578)))+(((cj4)*(x4572)*(x4577)))+(((r11)*(x4584)))+(((IkReal(-1.00000000000000))*(x4581)*(x4583)))+(((cj4)*(r02)*(x4571)))+(x4569)+(((x4573)*(x4575)))+(((x4573)*(x4582)))+(((IkReal(-1.00000000000000))*(r12)*(x4574)*(x4580))));
evalcond[3]=((x4570)+(((IkReal(-1.00000000000000))*(x4574)*(x4577)*(x4579)))+(((IkReal(-1.00000000000000))*(r02)*(x4574)*(x4580)))+(((r11)*(x4585)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4574)*(x4576)))+(((IkReal(-1.00000000000000))*(x4573)*(x4581)))+(((IkReal(-1.00000000000000))*(x4575)*(x4583)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x4573)*(x4574)))+(((r01)*(x4584)))+(((IkReal(-1.00000000000000))*(r12)*(x4571)*(x4574)))+(((IkReal(-1.00000000000000))*(x4572)*(x4574)*(x4576))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4586=((cj0)*(cj5));
IkReal x4587=((IkReal(1.00000000000000))*(cj0));
IkReal x4588=((cj6)*(r11));
IkReal x4589=((r10)*(sj6));
IkReal x4590=((cj5)*(sj0));
IkReal x4591=((r00)*(sj5)*(sj6));
IkReal x4592=((cj6)*(r01)*(sj5));
IkReal x4593=((IkReal(1.00000000000000))*(sj0)*(sj5));
if( IKabs(((((sj0)*(x4592)))+(((sj0)*(x4591)))+(((IkReal(-1.00000000000000))*(sj5)*(x4587)*(x4588)))+(((IkReal(-1.00000000000000))*(r02)*(x4590)))+(((r12)*(x4586)))+(((IkReal(-1.00000000000000))*(sj5)*(x4587)*(x4589))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x4587)*(x4592)))+(((IkReal(-1.00000000000000))*(x4588)*(x4593)))+(((IkReal(-1.00000000000000))*(x4589)*(x4593)))+(((IkReal(-1.00000000000000))*(x4587)*(x4591)))+(((r12)*(x4590)))+(((r02)*(x4586))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj0)*(x4592)))+(((sj0)*(x4591)))+(((IkReal(-1.00000000000000))*(sj5)*(x4587)*(x4588)))+(((IkReal(-1.00000000000000))*(r02)*(x4590)))+(((r12)*(x4586)))+(((IkReal(-1.00000000000000))*(sj5)*(x4587)*(x4589)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x4587)*(x4592)))+(((IkReal(-1.00000000000000))*(x4588)*(x4593)))+(((IkReal(-1.00000000000000))*(x4589)*(x4593)))+(((IkReal(-1.00000000000000))*(x4587)*(x4591)))+(((r12)*(x4590)))+(((r02)*(x4586)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj0)*(x4592)))+(((sj0)*(x4591)))+(((IkReal(-1.00000000000000))*(sj5)*(x4587)*(x4588)))+(((IkReal(-1.00000000000000))*(r02)*(x4590)))+(((r12)*(x4586)))+(((IkReal(-1.00000000000000))*(sj5)*(x4587)*(x4589)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x4587)*(x4592)))+(((IkReal(-1.00000000000000))*(x4588)*(x4593)))+(((IkReal(-1.00000000000000))*(x4589)*(x4593)))+(((IkReal(-1.00000000000000))*(x4587)*(x4591)))+(((r12)*(x4590)))+(((r02)*(x4586)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4594=IKsin(j3);
IkReal x4595=IKcos(j3);
IkReal x4596=((sj0)*(sj5));
IkReal x4597=((r00)*(sj6));
IkReal x4598=((cj6)*(r01));
IkReal x4599=((cj4)*(cj5));
IkReal x4600=((IkReal(1.00000000000000))*(cj0));
IkReal x4601=((cj5)*(r12));
IkReal x4602=((IkReal(1.00000000000000))*(sj0));
IkReal x4603=((cj6)*(r11));
IkReal x4604=((cj5)*(r02));
IkReal x4605=((IkReal(1.00000000000000))*(cj1));
IkReal x4606=((cj6)*(sj4));
IkReal x4607=((cj6)*(r21));
IkReal x4608=((r20)*(sj6));
IkReal x4609=((r10)*(sj6));
IkReal x4610=((sj4)*(sj6));
IkReal x4611=((cj4)*(r02));
IkReal x4612=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x4613=((IkReal(1.00000000000000))*(x4594));
IkReal x4614=((cj0)*(x4610));
evalcond[0]=((((sj5)*(x4608)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj1)*(x4595)))+(((sj5)*(x4607))));
evalcond[1]=((((r20)*(x4606)))+(((cj4)*(r22)*(sj5)))+(((x4599)*(x4607)))+(((IkReal(-1.00000000000000))*(sj1)*(x4613)))+(((IkReal(-1.00000000000000))*(r21)*(x4610)))+(((x4599)*(x4608))));
evalcond[2]=((((cj0)*(x4601)))+(((IkReal(-1.00000000000000))*(sj5)*(x4600)*(x4609)))+(((IkReal(-1.00000000000000))*(x4613)))+(((IkReal(-1.00000000000000))*(sj5)*(x4600)*(x4603)))+(((x4596)*(x4597)))+(((x4596)*(x4598)))+(((IkReal(-1.00000000000000))*(x4602)*(x4604))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x4598)*(x4600)))+(((IkReal(-1.00000000000000))*(x4595)*(x4605)))+(((sj0)*(x4601)))+(((IkReal(-1.00000000000000))*(x4596)*(x4603)))+(((cj0)*(x4604)))+(((IkReal(-1.00000000000000))*(sj5)*(x4597)*(x4600)))+(((IkReal(-1.00000000000000))*(x4596)*(x4609))));
evalcond[4]=((x4595)+(((r11)*(x4614)))+(((sj0)*(x4598)*(x4599)))+(((sj0)*(x4597)*(x4599)))+(((IkReal(-1.00000000000000))*(x4599)*(x4600)*(x4609)))+(((x4596)*(x4611)))+(((IkReal(-1.00000000000000))*(r01)*(x4602)*(x4610)))+(((IkReal(-1.00000000000000))*(x4599)*(x4600)*(x4603)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x4600)))+(((IkReal(-1.00000000000000))*(r10)*(x4600)*(x4606)))+(((r00)*(sj0)*(x4606))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x4594)*(x4605)))+(((IkReal(-1.00000000000000))*(x4599)*(x4602)*(x4603)))+(((IkReal(-1.00000000000000))*(r00)*(x4600)*(x4606)))+(((r01)*(x4614)))+(((IkReal(-1.00000000000000))*(x4597)*(x4599)*(x4600)))+(((IkReal(-1.00000000000000))*(x4599)*(x4602)*(x4609)))+(((IkReal(-1.00000000000000))*(x4598)*(x4599)*(x4600)))+(((IkReal(-1.00000000000000))*(sj5)*(x4600)*(x4611)))+(((r11)*(sj0)*(x4610)))+(((IkReal(-1.00000000000000))*(r10)*(x4602)*(x4606)))+(((IkReal(-1.00000000000000))*(x4596)*(x4612))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4615=((sj5)*(sj6));
IkReal x4616=((cj6)*(sj5));
IkReal x4617=((IkReal(1.00000000000000))*(cj0));
IkReal x4618=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((((r01)*(sj0)*(x4616)))+(((r00)*(sj0)*(x4615)))+(((IkReal(-1.00000000000000))*(r10)*(x4615)*(x4617)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4618)))+(((IkReal(-1.00000000000000))*(r11)*(x4616)*(x4617))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r22)*(x4618)))+(((r20)*(x4615)))+(((r21)*(x4616))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r01)*(sj0)*(x4616)))+(((r00)*(sj0)*(x4615)))+(((IkReal(-1.00000000000000))*(r10)*(x4615)*(x4617)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4618)))+(((IkReal(-1.00000000000000))*(r11)*(x4616)*(x4617)))))+IKsqr(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r22)*(x4618)))+(((r20)*(x4615)))+(((r21)*(x4616)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r01)*(sj0)*(x4616)))+(((r00)*(sj0)*(x4615)))+(((IkReal(-1.00000000000000))*(r10)*(x4615)*(x4617)))+(((cj0)*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4618)))+(((IkReal(-1.00000000000000))*(r11)*(x4616)*(x4617)))), ((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r22)*(x4618)))+(((r20)*(x4615)))+(((r21)*(x4616)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4619=IKsin(j3);
IkReal x4620=IKcos(j3);
IkReal x4621=((sj0)*(sj5));
IkReal x4622=((r00)*(sj6));
IkReal x4623=((cj6)*(r01));
IkReal x4624=((cj4)*(cj5));
IkReal x4625=((IkReal(1.00000000000000))*(cj0));
IkReal x4626=((cj5)*(r12));
IkReal x4627=((IkReal(1.00000000000000))*(sj0));
IkReal x4628=((cj6)*(r11));
IkReal x4629=((cj5)*(r02));
IkReal x4630=((IkReal(1.00000000000000))*(cj1));
IkReal x4631=((cj6)*(sj4));
IkReal x4632=((cj6)*(r21));
IkReal x4633=((r20)*(sj6));
IkReal x4634=((r10)*(sj6));
IkReal x4635=((sj4)*(sj6));
IkReal x4636=((cj4)*(r02));
IkReal x4637=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x4638=((IkReal(1.00000000000000))*(x4619));
IkReal x4639=((cj0)*(x4635));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj1)*(x4620)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4632)))+(((sj5)*(x4633))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj1)*(x4638)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x4631)))+(((x4624)*(x4633)))+(((x4624)*(x4632)))+(((IkReal(-1.00000000000000))*(r21)*(x4635))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4627)*(x4629)))+(((IkReal(-1.00000000000000))*(x4638)))+(((IkReal(-1.00000000000000))*(sj5)*(x4625)*(x4634)))+(((x4621)*(x4623)))+(((x4621)*(x4622)))+(((cj0)*(x4626)))+(((IkReal(-1.00000000000000))*(sj5)*(x4625)*(x4628))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x4621)*(x4628)))+(((cj0)*(x4629)))+(((IkReal(-1.00000000000000))*(sj5)*(x4622)*(x4625)))+(((IkReal(-1.00000000000000))*(sj5)*(x4623)*(x4625)))+(((IkReal(-1.00000000000000))*(x4620)*(x4630)))+(((IkReal(-1.00000000000000))*(x4621)*(x4634)))+(((sj0)*(x4626))));
evalcond[4]=((((sj0)*(x4623)*(x4624)))+(((IkReal(-1.00000000000000))*(x4624)*(x4625)*(x4634)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x4625)))+(((x4621)*(x4636)))+(((r11)*(x4639)))+(((IkReal(-1.00000000000000))*(r10)*(x4625)*(x4631)))+(((IkReal(-1.00000000000000))*(r01)*(x4627)*(x4635)))+(((r00)*(sj0)*(x4631)))+(((sj0)*(x4622)*(x4624)))+(((IkReal(-1.00000000000000))*(x4624)*(x4625)*(x4628)))+(x4620));
evalcond[5]=((((IkReal(-1.00000000000000))*(x4624)*(x4627)*(x4628)))+(((IkReal(-1.00000000000000))*(x4624)*(x4627)*(x4634)))+(((IkReal(-1.00000000000000))*(r00)*(x4625)*(x4631)))+(((IkReal(-1.00000000000000))*(r10)*(x4627)*(x4631)))+(((IkReal(-1.00000000000000))*(x4622)*(x4624)*(x4625)))+(((IkReal(-1.00000000000000))*(x4619)*(x4630)))+(((r11)*(sj0)*(x4635)))+(((IkReal(-1.00000000000000))*(x4621)*(x4637)))+(((IkReal(-1.00000000000000))*(sj5)*(x4625)*(x4636)))+(((r01)*(x4639)))+(((IkReal(-1.00000000000000))*(x4623)*(x4624)*(x4625))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4640=((r20)*(sj6));
IkReal x4641=((cj4)*(cj5));
IkReal x4642=((cj6)*(r21));
if( IKabs(((gconst17)*(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x4641)*(x4642)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x4640)*(x4641))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst17)*(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4640)))+(((sj5)*(x4642))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst17)*(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x4641)*(x4642)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x4640)*(x4641)))))), ((gconst17)*(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4640)))+(((sj5)*(x4642)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4643=IKsin(j3);
IkReal x4644=IKcos(j3);
IkReal x4645=((sj0)*(sj5));
IkReal x4646=((r00)*(sj6));
IkReal x4647=((cj6)*(r01));
IkReal x4648=((cj4)*(cj5));
IkReal x4649=((IkReal(1.00000000000000))*(cj0));
IkReal x4650=((cj5)*(r12));
IkReal x4651=((IkReal(1.00000000000000))*(sj0));
IkReal x4652=((cj6)*(r11));
IkReal x4653=((cj5)*(r02));
IkReal x4654=((IkReal(1.00000000000000))*(cj1));
IkReal x4655=((cj6)*(sj4));
IkReal x4656=((cj6)*(r21));
IkReal x4657=((r20)*(sj6));
IkReal x4658=((r10)*(sj6));
IkReal x4659=((sj4)*(sj6));
IkReal x4660=((cj4)*(r02));
IkReal x4661=((IkReal(1.00000000000000))*(cj4)*(r12));
IkReal x4662=((IkReal(1.00000000000000))*(x4643));
IkReal x4663=((cj0)*(x4659));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4656)))+(((sj5)*(x4657)))+(((IkReal(-1.00000000000000))*(sj1)*(x4644))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj1)*(x4662)))+(((r20)*(x4655)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r21)*(x4659)))+(((x4648)*(x4657)))+(((x4648)*(x4656))));
evalcond[2]=((((x4645)*(x4646)))+(((IkReal(-1.00000000000000))*(sj5)*(x4649)*(x4658)))+(((cj0)*(x4650)))+(((x4645)*(x4647)))+(((IkReal(-1.00000000000000))*(x4662)))+(((IkReal(-1.00000000000000))*(sj5)*(x4649)*(x4652)))+(((IkReal(-1.00000000000000))*(x4651)*(x4653))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x4645)*(x4658)))+(((IkReal(-1.00000000000000))*(sj5)*(x4647)*(x4649)))+(((IkReal(-1.00000000000000))*(x4644)*(x4654)))+(((cj0)*(x4653)))+(((sj0)*(x4650)))+(((IkReal(-1.00000000000000))*(x4645)*(x4652)))+(((IkReal(-1.00000000000000))*(sj5)*(x4646)*(x4649))));
evalcond[4]=((((r11)*(x4663)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(sj5)*(x4649)))+(((sj0)*(x4647)*(x4648)))+(((x4645)*(x4660)))+(((sj0)*(x4646)*(x4648)))+(((IkReal(-1.00000000000000))*(r01)*(x4651)*(x4659)))+(((IkReal(-1.00000000000000))*(x4648)*(x4649)*(x4658)))+(((r00)*(sj0)*(x4655)))+(((IkReal(-1.00000000000000))*(x4648)*(x4649)*(x4652)))+(x4644)+(((IkReal(-1.00000000000000))*(r10)*(x4649)*(x4655))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj5)*(x4649)*(x4660)))+(((r01)*(x4663)))+(((IkReal(-1.00000000000000))*(r10)*(x4651)*(x4655)))+(((IkReal(-1.00000000000000))*(x4648)*(x4651)*(x4658)))+(((IkReal(-1.00000000000000))*(x4643)*(x4654)))+(((IkReal(-1.00000000000000))*(x4648)*(x4651)*(x4652)))+(((IkReal(-1.00000000000000))*(r00)*(x4649)*(x4655)))+(((r11)*(sj0)*(x4659)))+(((IkReal(-1.00000000000000))*(x4647)*(x4648)*(x4649)))+(((IkReal(-1.00000000000000))*(x4645)*(x4661)))+(((IkReal(-1.00000000000000))*(x4646)*(x4648)*(x4649))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
IkReal x4664=((IkReal(0.374290000000000))*(sj5));
IkReal x4665=((cj0)*(sj6));
IkReal x4666=((IkReal(0.0100000000000000))*(sj5));
IkReal x4667=((cj0)*(r02));
IkReal x4668=((IkReal(0.0100000000000000))*(cj5));
IkReal x4669=((IkReal(1.00000000000000))*(py));
IkReal x4670=((r01)*(sj0));
IkReal x4671=((r20)*(sj6));
IkReal x4672=((r11)*(sj0));
IkReal x4673=((IkReal(0.374290000000000))*(cj5));
IkReal x4674=((cj0)*(r12));
IkReal x4675=((sj0)*(x4673));
IkReal x4676=((cj6)*(x4668));
IkReal x4677=((r10)*(sj0)*(sj6));
IkReal x4678=((r00)*(sj0)*(sj6));
IkReal x4679=((cj0)*(cj6)*(x4664));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(0.364420000000000))*(sj1)))+(((x4664)*(x4671)))+(((IkReal(-1.00000000000000))*(r22)*(x4673)))+(((cj6)*(r21)*(x4664)))+(((IkReal(-1.00000000000000))*(r21)*(x4676)))+(pz)+(((IkReal(-1.00000000000000))*(x4668)*(x4671)))+(((IkReal(-1.00000000000000))*(r22)*(x4666))));
evalcond[2]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(r11)*(x4679)))+(((IkReal(-1.00000000000000))*(x4670)*(x4676)))+(((x4664)*(x4678)))+(((IkReal(-1.00000000000000))*(x4668)*(x4678)))+(((x4666)*(x4674)))+(((cj0)*(r11)*(x4676)))+(((IkReal(-1.00000000000000))*(r10)*(x4664)*(x4665)))+(((cj6)*(x4664)*(x4670)))+(((r10)*(x4665)*(x4668)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4666)))+(((px)*(sj0)))+(((x4673)*(x4674)))+(((IkReal(-1.00000000000000))*(r02)*(x4675)))+(((IkReal(-1.00000000000000))*(cj0)*(x4669))));
evalcond[3]=((IkReal(0.0690000000000000))+(((x4667)*(x4673)))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-1.00000000000000))*(cj6)*(x4664)*(x4672)))+(((r00)*(x4665)*(x4668)))+(((r12)*(sj0)*(x4666)))+(((cj0)*(r01)*(x4676)))+(((IkReal(-1.00000000000000))*(r00)*(x4664)*(x4665)))+(((x4666)*(x4667)))+(((IkReal(-1.00000000000000))*(sj0)*(x4669)))+(((IkReal(-1.00000000000000))*(r01)*(x4679)))+(((r12)*(x4675)))+(((x4668)*(x4677)))+(((IkReal(0.364420000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x4664)*(x4677)))+(((x4672)*(x4676))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst26;
IkReal x4680=(cj6)*(cj6);
IkReal x4681=(sj6)*(sj6);
IkReal x4682=((IkReal(1.00000000000000))*(r01));
IkReal x4683=((sj0)*(sj5));
IkReal x4684=((cj6)*(r22));
IkReal x4685=((r21)*(sj6));
IkReal x4686=((r00)*(r21));
IkReal x4687=((cj0)*(sj5));
IkReal x4688=((cj6)*(r20));
IkReal x4689=((r22)*(sj6));
IkReal x4690=((cj0)*(cj5));
IkReal x4691=((IkReal(1.00000000000000))*(r10));
IkReal x4692=((cj5)*(sj0));
IkReal x4693=((r20)*(x4681));
IkReal x4694=((x4680)*(x4692));
gconst26=IKsign(((((r00)*(x4683)*(x4684)))+(((r11)*(x4690)*(x4693)))+(((x4686)*(x4694)))+(((IkReal(-1.00000000000000))*(x4682)*(x4683)*(x4689)))+(((IkReal(-1.00000000000000))*(r02)*(x4683)*(x4688)))+(((IkReal(-1.00000000000000))*(x4682)*(x4692)*(x4693)))+(((r11)*(x4687)*(x4689)))+(((IkReal(-1.00000000000000))*(r21)*(x4681)*(x4690)*(x4691)))+(((r11)*(r20)*(x4680)*(x4690)))+(((IkReal(-1.00000000000000))*(r12)*(x4685)*(x4687)))+(((IkReal(-1.00000000000000))*(x4684)*(x4687)*(x4691)))+(((r12)*(x4687)*(x4688)))+(((IkReal(-1.00000000000000))*(r21)*(x4680)*(x4690)*(x4691)))+(((x4681)*(x4686)*(x4692)))+(((r02)*(x4683)*(x4685)))+(((IkReal(-1.00000000000000))*(r20)*(x4682)*(x4694)))));
IkReal x4695=(cj6)*(cj6);
IkReal x4696=(sj6)*(sj6);
IkReal x4697=((IkReal(1.00000000000000))*(r01));
IkReal x4698=((sj0)*(sj5));
IkReal x4699=((cj6)*(r22));
IkReal x4700=((r21)*(sj6));
IkReal x4701=((r00)*(r21));
IkReal x4702=((cj0)*(sj5));
IkReal x4703=((cj6)*(r20));
IkReal x4704=((r22)*(sj6));
IkReal x4705=((cj0)*(cj5));
IkReal x4706=((IkReal(1.00000000000000))*(r10));
IkReal x4707=((cj5)*(sj0));
IkReal x4708=((r20)*(x4696));
IkReal x4709=((x4695)*(x4707));
dummyeval[0]=((((r11)*(x4705)*(x4708)))+(((IkReal(-1.00000000000000))*(x4697)*(x4698)*(x4704)))+(((IkReal(-1.00000000000000))*(r20)*(x4697)*(x4709)))+(((r11)*(x4702)*(x4704)))+(((IkReal(-1.00000000000000))*(r21)*(x4696)*(x4705)*(x4706)))+(((IkReal(-1.00000000000000))*(r21)*(x4695)*(x4705)*(x4706)))+(((r00)*(x4698)*(x4699)))+(((r11)*(r20)*(x4695)*(x4705)))+(((IkReal(-1.00000000000000))*(r12)*(x4700)*(x4702)))+(((r12)*(x4702)*(x4703)))+(((r02)*(x4698)*(x4700)))+(((IkReal(-1.00000000000000))*(x4699)*(x4702)*(x4706)))+(((x4701)*(x4709)))+(((x4696)*(x4701)*(x4707)))+(((IkReal(-1.00000000000000))*(x4697)*(x4707)*(x4708)))+(((IkReal(-1.00000000000000))*(r02)*(x4698)*(x4703))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst27;
IkReal x4710=(cj6)*(cj6);
IkReal x4711=(sj6)*(sj6);
IkReal x4712=((sj5)*(sj6));
IkReal x4713=((IkReal(1.00000000000000))*(cj0));
IkReal x4714=((cj6)*(sj5));
IkReal x4715=((r20)*(sj0));
IkReal x4716=((cj0)*(r20));
IkReal x4717=((r00)*(r21));
IkReal x4718=((r22)*(sj0));
IkReal x4719=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x4720=((cj5)*(x4711));
IkReal x4721=((cj5)*(x4710));
gconst27=IKsign(((((IkReal(-1.00000000000000))*(r10)*(x4719)*(x4721)))+(((r11)*(x4715)*(x4720)))+(((r01)*(x4716)*(x4720)))+(((r11)*(x4712)*(x4718)))+(((IkReal(-1.00000000000000))*(x4713)*(x4717)*(x4721)))+(((r01)*(x4716)*(x4721)))+(((IkReal(-1.00000000000000))*(r10)*(x4719)*(x4720)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x4713)*(x4714)))+(((r12)*(x4714)*(x4715)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x4712)*(x4713)))+(((cj0)*(r01)*(r22)*(x4712)))+(((r11)*(x4715)*(x4721)))+(((r02)*(x4714)*(x4716)))+(((IkReal(-1.00000000000000))*(x4713)*(x4717)*(x4720)))+(((IkReal(-1.00000000000000))*(r12)*(x4712)*(x4719)))+(((IkReal(-1.00000000000000))*(r10)*(x4714)*(x4718)))));
IkReal x4722=(cj6)*(cj6);
IkReal x4723=(sj6)*(sj6);
IkReal x4724=((sj5)*(sj6));
IkReal x4725=((IkReal(1.00000000000000))*(cj0));
IkReal x4726=((cj6)*(sj5));
IkReal x4727=((r20)*(sj0));
IkReal x4728=((cj0)*(r20));
IkReal x4729=((r00)*(r21));
IkReal x4730=((r22)*(sj0));
IkReal x4731=((IkReal(1.00000000000000))*(r21)*(sj0));
IkReal x4732=((cj5)*(x4723));
IkReal x4733=((cj5)*(x4722));
dummyeval[0]=((((cj0)*(r01)*(r22)*(x4724)))+(((IkReal(-1.00000000000000))*(r12)*(x4724)*(x4731)))+(((r02)*(x4726)*(x4728)))+(((IkReal(-1.00000000000000))*(r10)*(x4731)*(x4733)))+(((IkReal(-1.00000000000000))*(x4725)*(x4729)*(x4733)))+(((IkReal(-1.00000000000000))*(r02)*(r21)*(x4724)*(x4725)))+(((r01)*(x4728)*(x4733)))+(((IkReal(-1.00000000000000))*(r10)*(x4731)*(x4732)))+(((r11)*(x4727)*(x4732)))+(((r01)*(x4728)*(x4732)))+(((IkReal(-1.00000000000000))*(r10)*(x4726)*(x4730)))+(((IkReal(-1.00000000000000))*(r00)*(r22)*(x4725)*(x4726)))+(((r11)*(x4724)*(x4730)))+(((r12)*(x4726)*(x4727)))+(((r11)*(x4727)*(x4733)))+(((IkReal(-1.00000000000000))*(x4725)*(x4729)*(x4732))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x4734=((cj5)*(r22));
IkReal x4735=((IkReal(0.374290000000000))*(sj5));
IkReal x4736=((cj0)*(sj6));
IkReal x4737=((cj6)*(r21));
IkReal x4738=((IkReal(0.0100000000000000))*(sj5));
IkReal x4739=((cj0)*(r02));
IkReal x4740=((IkReal(0.0100000000000000))*(cj5));
IkReal x4741=((IkReal(1.00000000000000))*(py));
IkReal x4742=((r01)*(sj0));
IkReal x4743=((r20)*(sj6));
IkReal x4744=((r11)*(sj0));
IkReal x4745=((IkReal(0.374290000000000))*(cj5));
IkReal x4746=((cj0)*(r12));
IkReal x4747=((sj0)*(x4745));
IkReal x4748=((cj6)*(x4740));
IkReal x4749=((r10)*(sj0)*(sj6));
IkReal x4750=((r00)*(sj0)*(sj6));
IkReal x4751=((cj0)*(cj6)*(x4735));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4734)))+(((sj5)*(x4737)))+(((sj5)*(x4743))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r22)*(x4738)))+(((x4735)*(x4737)))+(pz)+(((IkReal(-1.00000000000000))*(x4740)*(x4743)))+(((IkReal(-0.374290000000000))*(x4734)))+(((IkReal(-1.00000000000000))*(x4737)*(x4740)))+(((x4735)*(x4743))));
evalcond[3]=((IkReal(-0.0690000000000000))+(((x4738)*(x4746)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4738)))+(((x4735)*(x4750)))+(((IkReal(-1.00000000000000))*(x4742)*(x4748)))+(((r10)*(x4736)*(x4740)))+(((cj0)*(r11)*(x4748)))+(((IkReal(-1.00000000000000))*(r11)*(x4751)))+(((IkReal(-1.00000000000000))*(r10)*(x4735)*(x4736)))+(((x4745)*(x4746)))+(((IkReal(-1.00000000000000))*(x4740)*(x4750)))+(((IkReal(-1.00000000000000))*(r02)*(x4747)))+(((cj6)*(x4735)*(x4742)))+(((IkReal(-1.00000000000000))*(cj0)*(x4741)))+(((px)*(sj0))));
evalcond[4]=((IkReal(0.433420000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((IkReal(-1.00000000000000))*(r01)*(x4751)))+(((IkReal(-1.00000000000000))*(x4735)*(x4749)))+(((r12)*(x4747)))+(((cj0)*(r01)*(x4748)))+(((r00)*(x4736)*(x4740)))+(((IkReal(-1.00000000000000))*(sj0)*(x4741)))+(((IkReal(-1.00000000000000))*(r00)*(x4735)*(x4736)))+(((x4738)*(x4739)))+(((x4739)*(x4745)))+(((r12)*(sj0)*(x4738)))+(((IkReal(-1.00000000000000))*(cj6)*(x4735)*(x4744)))+(((x4744)*(x4748)))+(((x4740)*(x4749))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4752=((cj5)*(r02));
IkReal x4753=((cj0)*(sj5));
IkReal x4754=((r10)*(sj6));
IkReal x4755=((IkReal(1.00000000000000))*(cj6));
IkReal x4756=((sj0)*(sj5));
IkReal x4757=((cj5)*(r12));
IkReal x4758=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj0)*(x4757)))+(((IkReal(-1.00000000000000))*(r01)*(x4755)*(x4756)))+(((x4753)*(x4754)))+(((IkReal(-1.00000000000000))*(x4756)*(x4758)))+(((cj6)*(r11)*(x4753)))+(((sj0)*(x4752))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj0)*(x4757)))+(((cj0)*(x4752)))+(((IkReal(-1.00000000000000))*(x4754)*(x4756)))+(((IkReal(-1.00000000000000))*(x4753)*(x4758)))+(((IkReal(-1.00000000000000))*(r11)*(x4755)*(x4756)))+(((IkReal(-1.00000000000000))*(r01)*(x4753)*(x4755))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj0)*(x4757)))+(((IkReal(-1.00000000000000))*(r01)*(x4755)*(x4756)))+(((x4753)*(x4754)))+(((IkReal(-1.00000000000000))*(x4756)*(x4758)))+(((cj6)*(r11)*(x4753)))+(((sj0)*(x4752)))))+IKsqr(((((sj0)*(x4757)))+(((cj0)*(x4752)))+(((IkReal(-1.00000000000000))*(x4754)*(x4756)))+(((IkReal(-1.00000000000000))*(x4753)*(x4758)))+(((IkReal(-1.00000000000000))*(r11)*(x4755)*(x4756)))+(((IkReal(-1.00000000000000))*(r01)*(x4753)*(x4755)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj0)*(x4757)))+(((IkReal(-1.00000000000000))*(r01)*(x4755)*(x4756)))+(((x4753)*(x4754)))+(((IkReal(-1.00000000000000))*(x4756)*(x4758)))+(((cj6)*(r11)*(x4753)))+(((sj0)*(x4752)))), ((((sj0)*(x4757)))+(((cj0)*(x4752)))+(((IkReal(-1.00000000000000))*(x4754)*(x4756)))+(((IkReal(-1.00000000000000))*(x4753)*(x4758)))+(((IkReal(-1.00000000000000))*(r11)*(x4755)*(x4756)))+(((IkReal(-1.00000000000000))*(r01)*(x4753)*(x4755)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x4759=((cj0)*(cj5));
IkReal x4760=((IkReal(1.00000000000000))*(cj0));
IkReal x4761=((cj6)*(r11));
IkReal x4762=((r10)*(sj6));
IkReal x4763=((cj5)*(sj0));
IkReal x4764=((r00)*(sj5)*(sj6));
IkReal x4765=((cj6)*(r01)*(sj5));
IkReal x4766=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((IkReal(-1.00000000000000))*(r02)*(x4763)))+(((sj0)*(x4765)))+(((r12)*(x4759)))+(((sj0)*(x4764)))+(((IkReal(-1.00000000000000))*(sj5)*(x4760)*(x4761)))+(IKsin(j3))+(((IkReal(-1.00000000000000))*(sj5)*(x4760)*(x4762))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4760)*(x4765)))+(((IkReal(-1.00000000000000))*(x4761)*(x4766)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((r02)*(x4759)))+(((IkReal(-1.00000000000000))*(x4760)*(x4764)))+(((r12)*(x4763)))+(((IkReal(-1.00000000000000))*(x4762)*(x4766))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst33;
IkReal x4767=(r21)*(r21);
IkReal x4768=(cj5)*(cj5);
IkReal x4769=(sj6)*(sj6);
IkReal x4770=(cj6)*(cj6);
IkReal x4771=(r20)*(r20);
IkReal x4772=((cj6)*(r21));
IkReal x4773=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x4774=((cj5)*(r22)*(sj5));
IkReal x4775=((IkReal(1.00000000000000))*(x4769));
IkReal x4776=((IkReal(1.00000000000000))*(x4770));
gconst33=IKsign(((((IkReal(-1.00000000000000))*(x4771)*(x4776)))+(((IkReal(-1.00000000000000))*(x4767)*(x4775)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x4767)*(x4768)*(x4776)))+(((IkReal(-1.00000000000000))*(x4768)*(x4771)*(x4775)))+(((IkReal(-1.00000000000000))*(x4768)*(x4772)*(x4773)))+(((x4772)*(x4773)))+(((IkReal(-1.00000000000000))*(x4773)*(x4774)))+(((IkReal(-2.00000000000000))*(x4772)*(x4774)))));
IkReal x4777=(r21)*(r21);
IkReal x4778=(cj5)*(cj5);
IkReal x4779=(sj6)*(sj6);
IkReal x4780=(cj6)*(cj6);
IkReal x4781=(r20)*(r20);
IkReal x4782=((cj6)*(r21));
IkReal x4783=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x4784=((cj5)*(r22)*(sj5));
IkReal x4785=((IkReal(1.00000000000000))*(x4779));
IkReal x4786=((IkReal(1.00000000000000))*(x4780));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x4777)*(x4785)))+(((IkReal(-1.00000000000000))*(x4783)*(x4784)))+(((IkReal(-1.00000000000000))*(x4778)*(x4782)*(x4783)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x4777)*(x4778)*(x4786)))+(((x4782)*(x4783)))+(((IkReal(-1.00000000000000))*(x4781)*(x4786)))+(((IkReal(-1.00000000000000))*(x4778)*(x4781)*(x4785)))+(((IkReal(-2.00000000000000))*(x4782)*(x4784))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst34;
IkReal x4787=(cj6)*(cj6);
IkReal x4788=(sj6)*(sj6);
IkReal x4789=((IkReal(1.00000000000000))*(r01));
IkReal x4790=((sj0)*(sj5));
IkReal x4791=((cj6)*(r22));
IkReal x4792=((r21)*(sj6));
IkReal x4793=((r00)*(r21));
IkReal x4794=((cj0)*(sj5));
IkReal x4795=((cj6)*(r20));
IkReal x4796=((r22)*(sj6));
IkReal x4797=((cj0)*(cj5));
IkReal x4798=((IkReal(1.00000000000000))*(r10));
IkReal x4799=((cj5)*(sj0));
IkReal x4800=((r20)*(x4788));
IkReal x4801=((x4787)*(x4799));
gconst34=IKsign(((((r02)*(x4790)*(x4792)))+(((IkReal(-1.00000000000000))*(r20)*(x4789)*(x4801)))+(((r12)*(x4794)*(x4795)))+(((r11)*(x4794)*(x4796)))+(((IkReal(-1.00000000000000))*(x4789)*(x4799)*(x4800)))+(((x4788)*(x4793)*(x4799)))+(((x4793)*(x4801)))+(((IkReal(-1.00000000000000))*(r21)*(x4787)*(x4797)*(x4798)))+(((r11)*(r20)*(x4787)*(x4797)))+(((IkReal(-1.00000000000000))*(r21)*(x4788)*(x4797)*(x4798)))+(((r00)*(x4790)*(x4791)))+(((IkReal(-1.00000000000000))*(r02)*(x4790)*(x4795)))+(((IkReal(-1.00000000000000))*(x4791)*(x4794)*(x4798)))+(((IkReal(-1.00000000000000))*(x4789)*(x4790)*(x4796)))+(((r11)*(x4797)*(x4800)))+(((IkReal(-1.00000000000000))*(r12)*(x4792)*(x4794)))));
IkReal x4802=(cj6)*(cj6);
IkReal x4803=(sj6)*(sj6);
IkReal x4804=((IkReal(1.00000000000000))*(r01));
IkReal x4805=((sj0)*(sj5));
IkReal x4806=((cj6)*(r22));
IkReal x4807=((r21)*(sj6));
IkReal x4808=((r00)*(r21));
IkReal x4809=((cj0)*(sj5));
IkReal x4810=((cj6)*(r20));
IkReal x4811=((r22)*(sj6));
IkReal x4812=((cj0)*(cj5));
IkReal x4813=((IkReal(1.00000000000000))*(r10));
IkReal x4814=((cj5)*(sj0));
IkReal x4815=((r20)*(x4803));
IkReal x4816=((x4802)*(x4814));
dummyeval[0]=((((r11)*(r20)*(x4802)*(x4812)))+(((IkReal(-1.00000000000000))*(r21)*(x4803)*(x4812)*(x4813)))+(((r12)*(x4809)*(x4810)))+(((IkReal(-1.00000000000000))*(x4804)*(x4805)*(x4811)))+(((IkReal(-1.00000000000000))*(r21)*(x4802)*(x4812)*(x4813)))+(((IkReal(-1.00000000000000))*(r20)*(x4804)*(x4816)))+(((x4803)*(x4808)*(x4814)))+(((IkReal(-1.00000000000000))*(x4806)*(x4809)*(x4813)))+(((IkReal(-1.00000000000000))*(r12)*(x4807)*(x4809)))+(((r00)*(x4805)*(x4806)))+(((r11)*(x4809)*(x4811)))+(((IkReal(-1.00000000000000))*(r02)*(x4805)*(x4810)))+(((x4808)*(x4816)))+(((r11)*(x4812)*(x4815)))+(((IkReal(-1.00000000000000))*(x4804)*(x4814)*(x4815)))+(((r02)*(x4805)*(x4807))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x4817=((sj0)*(sj6));
IkReal x4818=((cj0)*(r10));
IkReal x4819=((IkReal(1.00000000000000))*(cj5));
IkReal x4820=((cj6)*(sj0));
IkReal x4821=((cj0)*(r11));
if( IKabs(((gconst34)*(((((r01)*(x4817)))+(((IkReal(-1.00000000000000))*(r00)*(x4820)))+(((cj6)*(x4818)))+(((IkReal(-1.00000000000000))*(sj6)*(x4821))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst34)*(((((IkReal(-1.00000000000000))*(r00)*(x4817)*(x4819)))+(((cj0)*(r12)*(sj5)))+(((cj5)*(cj6)*(x4821)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(x4819)*(x4820)))+(((cj5)*(sj6)*(x4818))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst34)*(((((r01)*(x4817)))+(((IkReal(-1.00000000000000))*(r00)*(x4820)))+(((cj6)*(x4818)))+(((IkReal(-1.00000000000000))*(sj6)*(x4821)))))), ((gconst34)*(((((IkReal(-1.00000000000000))*(r00)*(x4817)*(x4819)))+(((cj0)*(r12)*(sj5)))+(((cj5)*(cj6)*(x4821)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(x4819)*(x4820)))+(((cj5)*(sj6)*(x4818)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x4822=IKsin(j4);
IkReal x4823=IKcos(j4);
IkReal x4824=((r22)*(sj5));
IkReal x4825=((IkReal(1.00000000000000))*(cj6));
IkReal x4826=((IkReal(1.00000000000000))*(cj0));
IkReal x4827=((cj5)*(r11));
IkReal x4828=((cj5)*(cj6));
IkReal x4829=((r11)*(sj6));
IkReal x4830=((IkReal(1.00000000000000))*(sj6));
IkReal x4831=((cj6)*(r00));
IkReal x4832=((r12)*(sj5));
IkReal x4833=((r02)*(sj5));
IkReal x4834=((cj6)*(r10));
IkReal x4835=((cj5)*(sj6));
IkReal x4836=((cj5)*(r01));
IkReal x4837=((sj0)*(x4822));
IkReal x4838=((r00)*(x4835));
IkReal x4839=((cj0)*(x4822));
IkReal x4840=((sj0)*(x4823));
IkReal x4841=((r20)*(x4823));
IkReal x4842=((cj0)*(x4823));
IkReal x4843=((r21)*(x4822));
IkReal x4844=((r21)*(x4823));
IkReal x4845=((r20)*(x4822));
IkReal x4846=((x4823)*(x4832));
IkReal x4847=((r01)*(sj6)*(x4823));
IkReal x4848=((cj5)*(r10)*(x4830));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x4825)*(x4841)))+(((x4835)*(x4845)))+(((sj6)*(x4844)))+(((x4828)*(x4843)))+(((x4822)*(x4824))));
evalcond[1]=((((x4828)*(x4844)))+(((x4835)*(x4841)))+(((cj6)*(x4845)))+(((IkReal(-1.00000000000000))*(x4830)*(x4843)))+(((x4823)*(x4824))));
evalcond[2]=((((r01)*(x4828)*(x4837)))+(((IkReal(-1.00000000000000))*(r10)*(x4822)*(x4826)*(x4835)))+(((IkReal(-1.00000000000000))*(x4822)*(x4826)*(x4832)))+(((IkReal(-1.00000000000000))*(x4825)*(x4827)*(x4839)))+(((IkReal(-1.00000000000000))*(r00)*(x4825)*(x4840)))+(((x4833)*(x4837)))+(((x4837)*(x4838)))+(((IkReal(-1.00000000000000))*(x4823)*(x4826)*(x4829)))+(((r01)*(sj6)*(x4840)))+(((x4834)*(x4842))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x4825)*(x4839)))+(((IkReal(-1.00000000000000))*(r01)*(x4830)*(x4837)))+(((IkReal(-1.00000000000000))*(x4825)*(x4827)*(x4842)))+(((x4838)*(x4840)))+(((x4829)*(x4839)))+(((IkReal(-1.00000000000000))*(r10)*(x4823)*(x4826)*(x4835)))+(((IkReal(-1.00000000000000))*(cj3)))+(((x4831)*(x4837)))+(((r01)*(x4828)*(x4840)))+(((x4833)*(x4840)))+(((IkReal(-1.00000000000000))*(x4826)*(x4846))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x4837)*(x4848)))+(((x4831)*(x4842)))+(((IkReal(-1.00000000000000))*(x4822)*(x4826)*(x4838)))+(((IkReal(-1.00000000000000))*(x4822)*(x4826)*(x4833)))+(((IkReal(-1.00000000000000))*(x4829)*(x4840)))+(((x4834)*(x4840)))+(((IkReal(-1.00000000000000))*(x4825)*(x4827)*(x4837)))+(((IkReal(-1.00000000000000))*(x4826)*(x4847)))+(((IkReal(-1.00000000000000))*(x4825)*(x4836)*(x4839)))+(((IkReal(-1.00000000000000))*(x4832)*(x4837))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x4825)*(x4837)))+(((r01)*(sj6)*(x4839)))+(((IkReal(-1.00000000000000))*(x4825)*(x4836)*(x4842)))+(((x4829)*(x4837)))+(((IkReal(-1.00000000000000))*(x4825)*(x4827)*(x4840)))+(((IkReal(-1.00000000000000))*(x4840)*(x4848)))+(((IkReal(-1.00000000000000))*(x4832)*(x4840)))+(((IkReal(-1.00000000000000))*(x4823)*(x4826)*(x4833)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(r00)*(x4825)*(x4839)))+(((IkReal(-1.00000000000000))*(x4823)*(x4826)*(x4838))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst33)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst33)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst33)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst33)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x4849=IKsin(j4);
IkReal x4850=IKcos(j4);
IkReal x4851=((r22)*(sj5));
IkReal x4852=((IkReal(1.00000000000000))*(cj6));
IkReal x4853=((IkReal(1.00000000000000))*(cj0));
IkReal x4854=((cj5)*(r11));
IkReal x4855=((cj5)*(cj6));
IkReal x4856=((r11)*(sj6));
IkReal x4857=((IkReal(1.00000000000000))*(sj6));
IkReal x4858=((cj6)*(r00));
IkReal x4859=((r12)*(sj5));
IkReal x4860=((r02)*(sj5));
IkReal x4861=((cj6)*(r10));
IkReal x4862=((cj5)*(sj6));
IkReal x4863=((cj5)*(r01));
IkReal x4864=((sj0)*(x4849));
IkReal x4865=((r00)*(x4862));
IkReal x4866=((cj0)*(x4849));
IkReal x4867=((sj0)*(x4850));
IkReal x4868=((r20)*(x4850));
IkReal x4869=((cj0)*(x4850));
IkReal x4870=((r21)*(x4849));
IkReal x4871=((r21)*(x4850));
IkReal x4872=((r20)*(x4849));
IkReal x4873=((x4850)*(x4859));
IkReal x4874=((r01)*(sj6)*(x4850));
IkReal x4875=((cj5)*(r10)*(x4857));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x4852)*(x4868)))+(((sj6)*(x4871)))+(((x4849)*(x4851)))+(((x4855)*(x4870)))+(((x4862)*(x4872))));
evalcond[1]=((((x4850)*(x4851)))+(((IkReal(-1.00000000000000))*(x4857)*(x4870)))+(((x4862)*(x4868)))+(((cj6)*(x4872)))+(((x4855)*(x4871))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x4852)*(x4867)))+(((IkReal(-1.00000000000000))*(x4852)*(x4854)*(x4866)))+(((x4861)*(x4869)))+(((x4864)*(x4865)))+(((IkReal(-1.00000000000000))*(r10)*(x4849)*(x4853)*(x4862)))+(((IkReal(-1.00000000000000))*(x4849)*(x4853)*(x4859)))+(((IkReal(-1.00000000000000))*(x4850)*(x4853)*(x4856)))+(((x4860)*(x4864)))+(((r01)*(x4855)*(x4864)))+(((r01)*(sj6)*(x4867))));
evalcond[3]=((((x4858)*(x4864)))+(((IkReal(-1.00000000000000))*(r10)*(x4852)*(x4866)))+(((x4856)*(x4866)))+(((IkReal(-1.00000000000000))*(r10)*(x4850)*(x4853)*(x4862)))+(((r01)*(x4855)*(x4867)))+(((IkReal(-1.00000000000000))*(r01)*(x4857)*(x4864)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x4853)*(x4873)))+(((x4865)*(x4867)))+(((IkReal(-1.00000000000000))*(x4852)*(x4854)*(x4869)))+(((x4860)*(x4867))));
evalcond[4]=((((x4858)*(x4869)))+(((IkReal(-1.00000000000000))*(x4849)*(x4853)*(x4865)))+(((IkReal(-1.00000000000000))*(x4864)*(x4875)))+(((IkReal(-1.00000000000000))*(x4852)*(x4863)*(x4866)))+(((IkReal(-1.00000000000000))*(x4859)*(x4864)))+(((IkReal(-1.00000000000000))*(x4853)*(x4874)))+(((IkReal(-1.00000000000000))*(x4849)*(x4853)*(x4860)))+(((IkReal(-1.00000000000000))*(x4856)*(x4867)))+(((x4861)*(x4867)))+(((IkReal(-1.00000000000000))*(x4852)*(x4854)*(x4864))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x4850)*(x4853)*(x4860)))+(((IkReal(-1.00000000000000))*(r00)*(x4852)*(x4866)))+(((x4856)*(x4864)))+(((IkReal(-1.00000000000000))*(x4852)*(x4854)*(x4867)))+(((r01)*(sj6)*(x4866)))+(((IkReal(-1.00000000000000))*(x4852)*(x4863)*(x4869)))+(((IkReal(-1.00000000000000))*(x4867)*(x4875)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(r10)*(x4852)*(x4864)))+(((IkReal(-1.00000000000000))*(x4859)*(x4867)))+(((IkReal(-1.00000000000000))*(x4850)*(x4853)*(x4865))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x4876=((cj5)*(r22));
IkReal x4877=((IkReal(0.374290000000000))*(sj5));
IkReal x4878=((cj0)*(sj6));
IkReal x4879=((cj6)*(r21));
IkReal x4880=((IkReal(0.0100000000000000))*(sj5));
IkReal x4881=((cj0)*(r02));
IkReal x4882=((IkReal(0.0100000000000000))*(cj5));
IkReal x4883=((IkReal(1.00000000000000))*(py));
IkReal x4884=((r01)*(sj0));
IkReal x4885=((r20)*(sj6));
IkReal x4886=((r11)*(sj0));
IkReal x4887=((IkReal(0.374290000000000))*(cj5));
IkReal x4888=((cj0)*(r12));
IkReal x4889=((sj0)*(x4887));
IkReal x4890=((cj6)*(x4882));
IkReal x4891=((r10)*(sj0)*(sj6));
IkReal x4892=((r00)*(sj0)*(sj6));
IkReal x4893=((cj0)*(cj6)*(x4877));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j1, IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4876)))+(((sj5)*(x4879)))+(((sj5)*(x4885))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x4879)*(x4882)))+(((IkReal(-0.374290000000000))*(x4876)))+(((x4877)*(x4879)))+(((IkReal(-1.00000000000000))*(r22)*(x4880)))+(((IkReal(-1.00000000000000))*(x4882)*(x4885)))+(pz)+(((x4877)*(x4885))));
evalcond[3]=((IkReal(-0.0690000000000000))+(((cj0)*(r11)*(x4890)))+(((x4880)*(x4888)))+(((IkReal(-1.00000000000000))*(x4884)*(x4890)))+(((x4877)*(x4892)))+(((r10)*(x4878)*(x4882)))+(((IkReal(-1.00000000000000))*(r10)*(x4877)*(x4878)))+(((IkReal(-1.00000000000000))*(r02)*(x4889)))+(((cj6)*(x4877)*(x4884)))+(((x4887)*(x4888)))+(((IkReal(-1.00000000000000))*(x4882)*(x4892)))+(((IkReal(-1.00000000000000))*(cj0)*(x4883)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x4880)))+(((IkReal(-1.00000000000000))*(r11)*(x4893))));
evalcond[4]=((IkReal(-0.295420000000000))+(((IkReal(-1.00000000000000))*(cj0)*(px)))+(((cj0)*(r01)*(x4890)))+(((IkReal(-1.00000000000000))*(r00)*(x4877)*(x4878)))+(((r12)*(x4889)))+(((IkReal(-1.00000000000000))*(cj6)*(x4877)*(x4886)))+(((x4882)*(x4891)))+(((r12)*(sj0)*(x4880)))+(((IkReal(-1.00000000000000))*(x4877)*(x4891)))+(((x4881)*(x4887)))+(((IkReal(-1.00000000000000))*(sj0)*(x4883)))+(((r00)*(x4878)*(x4882)))+(((x4880)*(x4881)))+(((IkReal(-1.00000000000000))*(r01)*(x4893)))+(((x4886)*(x4890))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4894=((IkReal(1.00000000000000))*(cj5));
IkReal x4895=((r10)*(sj5)*(sj6));
IkReal x4896=((cj6)*(sj0)*(sj5));
IkReal x4897=((r00)*(sj5)*(sj6));
IkReal x4898=((cj0)*(cj6)*(sj5));
if( IKabs(((((r11)*(x4898)))+(((cj0)*(x4895)))+(((IkReal(-1.00000000000000))*(sj0)*(x4897)))+(((IkReal(-1.00000000000000))*(r01)*(x4896)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x4894)))+(((cj5)*(r02)*(sj0))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r01)*(x4898)))+(((cj0)*(x4897)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4894)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4894)))+(((r11)*(x4896)))+(((sj0)*(x4895))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r11)*(x4898)))+(((cj0)*(x4895)))+(((IkReal(-1.00000000000000))*(sj0)*(x4897)))+(((IkReal(-1.00000000000000))*(r01)*(x4896)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x4894)))+(((cj5)*(r02)*(sj0)))))+IKsqr(((((r01)*(x4898)))+(((cj0)*(x4897)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4894)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4894)))+(((r11)*(x4896)))+(((sj0)*(x4895)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r11)*(x4898)))+(((cj0)*(x4895)))+(((IkReal(-1.00000000000000))*(sj0)*(x4897)))+(((IkReal(-1.00000000000000))*(r01)*(x4896)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x4894)))+(((cj5)*(r02)*(sj0)))), ((((r01)*(x4898)))+(((cj0)*(x4897)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x4894)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x4894)))+(((r11)*(x4896)))+(((sj0)*(x4895)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x4899=((cj0)*(cj5));
IkReal x4900=((IkReal(1.00000000000000))*(cj0));
IkReal x4901=((cj6)*(r11));
IkReal x4902=((r10)*(sj6));
IkReal x4903=((cj5)*(sj0));
IkReal x4904=((r00)*(sj5)*(sj6));
IkReal x4905=((cj6)*(r01)*(sj5));
IkReal x4906=((IkReal(1.00000000000000))*(sj0)*(sj5));
evalcond[0]=((((sj0)*(x4904)))+(((r12)*(x4899)))+(IKsin(j3))+(((IkReal(-1.00000000000000))*(sj5)*(x4900)*(x4901)))+(((IkReal(-1.00000000000000))*(sj5)*(x4900)*(x4902)))+(((sj0)*(x4905)))+(((IkReal(-1.00000000000000))*(r02)*(x4903))));
evalcond[1]=((((r02)*(x4899)))+(((IkReal(-1.00000000000000))*(x4902)*(x4906)))+(((IkReal(-1.00000000000000))*(x4900)*(x4905)))+(((IkReal(-1.00000000000000))*(x4900)*(x4904)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(x4901)*(x4906)))+(((r12)*(x4903))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst37;
IkReal x4907=(cj5)*(cj5);
IkReal x4908=(r20)*(r20);
IkReal x4909=(sj6)*(sj6);
IkReal x4910=(cj6)*(cj6);
IkReal x4911=(r21)*(r21);
IkReal x4912=((cj6)*(r21));
IkReal x4913=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x4914=((cj5)*(r22)*(sj5));
gconst37=IKsign(((((x4907)*(x4910)*(x4911)))+(((x4907)*(x4908)*(x4909)))+(((x4913)*(x4914)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x4907)*(x4912)*(x4913)))+(((IkReal(-1.00000000000000))*(x4912)*(x4913)))+(((IkReal(2.00000000000000))*(x4912)*(x4914)))+(((x4908)*(x4910)))+(((x4909)*(x4911)))));
IkReal x4915=(cj5)*(cj5);
IkReal x4916=(r20)*(r20);
IkReal x4917=(sj6)*(sj6);
IkReal x4918=(cj6)*(cj6);
IkReal x4919=(r21)*(r21);
IkReal x4920=((cj6)*(r21));
IkReal x4921=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x4922=((cj5)*(r22)*(sj5));
dummyeval[0]=((((IkReal(2.00000000000000))*(x4920)*(x4922)))+(((x4915)*(x4916)*(x4917)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x4917)*(x4919)))+(((IkReal(-1.00000000000000))*(x4920)*(x4921)))+(((x4915)*(x4920)*(x4921)))+(((x4921)*(x4922)))+(((x4915)*(x4918)*(x4919)))+(((x4916)*(x4918))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst38;
IkReal x4923=(cj6)*(cj6);
IkReal x4924=(sj6)*(sj6);
IkReal x4925=((IkReal(1.00000000000000))*(r21));
IkReal x4926=((cj6)*(r20));
IkReal x4927=((r22)*(sj5));
IkReal x4928=((r01)*(sj0));
IkReal x4929=((r00)*(sj0));
IkReal x4930=((cj0)*(r10));
IkReal x4931=((r02)*(sj0)*(sj5));
IkReal x4932=((cj5)*(x4923));
IkReal x4933=((cj0)*(r12)*(sj5));
IkReal x4934=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x4935=((cj5)*(x4924));
IkReal x4936=((r20)*(x4935));
gconst38=IKsign(((((x4928)*(x4936)))+(((IkReal(-1.00000000000000))*(cj6)*(x4927)*(x4929)))+(((IkReal(-1.00000000000000))*(sj6)*(x4927)*(x4934)))+(((IkReal(-1.00000000000000))*(sj6)*(x4925)*(x4931)))+(((r21)*(sj6)*(x4933)))+(((r21)*(x4930)*(x4935)))+(((IkReal(-1.00000000000000))*(x4925)*(x4929)*(x4935)))+(((x4926)*(x4931)))+(((IkReal(-1.00000000000000))*(r20)*(x4932)*(x4934)))+(((IkReal(-1.00000000000000))*(x4925)*(x4929)*(x4932)))+(((IkReal(-1.00000000000000))*(x4926)*(x4933)))+(((r21)*(x4930)*(x4932)))+(((IkReal(-1.00000000000000))*(x4934)*(x4936)))+(((r20)*(x4928)*(x4932)))+(((cj6)*(x4927)*(x4930)))+(((sj6)*(x4927)*(x4928)))));
IkReal x4937=(cj6)*(cj6);
IkReal x4938=(sj6)*(sj6);
IkReal x4939=((IkReal(1.00000000000000))*(r21));
IkReal x4940=((cj6)*(r20));
IkReal x4941=((r22)*(sj5));
IkReal x4942=((r01)*(sj0));
IkReal x4943=((r00)*(sj0));
IkReal x4944=((cj0)*(r10));
IkReal x4945=((r02)*(sj0)*(sj5));
IkReal x4946=((cj5)*(x4937));
IkReal x4947=((cj0)*(r12)*(sj5));
IkReal x4948=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x4949=((cj5)*(x4938));
IkReal x4950=((r20)*(x4949));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x4939)*(x4943)*(x4946)))+(((r21)*(x4944)*(x4949)))+(((r21)*(x4944)*(x4946)))+(((r20)*(x4942)*(x4946)))+(((IkReal(-1.00000000000000))*(cj6)*(x4941)*(x4943)))+(((sj6)*(x4941)*(x4942)))+(((IkReal(-1.00000000000000))*(sj6)*(x4939)*(x4945)))+(((x4940)*(x4945)))+(((IkReal(-1.00000000000000))*(x4940)*(x4947)))+(((IkReal(-1.00000000000000))*(x4948)*(x4950)))+(((IkReal(-1.00000000000000))*(x4939)*(x4943)*(x4949)))+(((IkReal(-1.00000000000000))*(sj6)*(x4941)*(x4948)))+(((x4942)*(x4950)))+(((cj6)*(x4941)*(x4944)))+(((r21)*(sj6)*(x4947)))+(((IkReal(-1.00000000000000))*(r20)*(x4946)*(x4948))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x4951=((sj0)*(sj6));
IkReal x4952=((cj0)*(r10));
IkReal x4953=((IkReal(1.00000000000000))*(cj5));
IkReal x4954=((cj6)*(sj0));
IkReal x4955=((cj0)*(r11));
if( IKabs(((gconst38)*(((((cj6)*(x4952)))+(((r01)*(x4951)))+(((IkReal(-1.00000000000000))*(r00)*(x4954)))+(((IkReal(-1.00000000000000))*(sj6)*(x4955))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst38)*(((((cj5)*(sj6)*(x4952)))+(((IkReal(-1.00000000000000))*(r01)*(x4953)*(x4954)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x4951)*(x4953)))+(((cj5)*(cj6)*(x4955))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst38)*(((((cj6)*(x4952)))+(((r01)*(x4951)))+(((IkReal(-1.00000000000000))*(r00)*(x4954)))+(((IkReal(-1.00000000000000))*(sj6)*(x4955)))))), ((gconst38)*(((((cj5)*(sj6)*(x4952)))+(((IkReal(-1.00000000000000))*(r01)*(x4953)*(x4954)))+(((cj0)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(x4951)*(x4953)))+(((cj5)*(cj6)*(x4955)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x4956=IKsin(j4);
IkReal x4957=IKcos(j4);
IkReal x4958=((r22)*(sj5));
IkReal x4959=((IkReal(1.00000000000000))*(cj6));
IkReal x4960=((IkReal(1.00000000000000))*(cj0));
IkReal x4961=((cj5)*(r11));
IkReal x4962=((cj5)*(cj6));
IkReal x4963=((r11)*(sj6));
IkReal x4964=((IkReal(1.00000000000000))*(sj6));
IkReal x4965=((cj6)*(r00));
IkReal x4966=((r12)*(sj5));
IkReal x4967=((r02)*(sj5));
IkReal x4968=((cj6)*(r10));
IkReal x4969=((cj5)*(sj6));
IkReal x4970=((cj5)*(r01));
IkReal x4971=((sj0)*(x4956));
IkReal x4972=((r00)*(x4969));
IkReal x4973=((cj0)*(x4956));
IkReal x4974=((sj0)*(x4957));
IkReal x4975=((r20)*(x4957));
IkReal x4976=((cj0)*(x4957));
IkReal x4977=((r21)*(x4956));
IkReal x4978=((r21)*(x4957));
IkReal x4979=((r20)*(x4956));
IkReal x4980=((x4957)*(x4966));
IkReal x4981=((r01)*(sj6)*(x4957));
IkReal x4982=((cj5)*(r10)*(x4964));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x4959)*(x4975)))+(((x4969)*(x4979)))+(((sj6)*(x4978)))+(((x4956)*(x4958)))+(((x4962)*(x4977))));
evalcond[1]=((((x4969)*(x4975)))+(((IkReal(-1.00000000000000))*(x4964)*(x4977)))+(((x4962)*(x4978)))+(((x4957)*(x4958)))+(((cj6)*(x4979))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x4956)*(x4960)*(x4969)))+(((x4967)*(x4971)))+(((IkReal(-1.00000000000000))*(x4956)*(x4960)*(x4966)))+(((IkReal(-1.00000000000000))*(x4957)*(x4960)*(x4963)))+(((r01)*(x4962)*(x4971)))+(((r01)*(sj6)*(x4974)))+(((x4971)*(x4972)))+(((IkReal(-1.00000000000000))*(r00)*(x4959)*(x4974)))+(((x4968)*(x4976)))+(((IkReal(-1.00000000000000))*(x4959)*(x4961)*(x4973))));
evalcond[3]=((((r01)*(x4962)*(x4974)))+(((x4965)*(x4971)))+(((IkReal(-1.00000000000000))*(r10)*(x4959)*(x4973)))+(((x4963)*(x4973)))+(((IkReal(-1.00000000000000))*(r01)*(x4964)*(x4971)))+(((IkReal(-1.00000000000000))*(r10)*(x4957)*(x4960)*(x4969)))+(((IkReal(-1.00000000000000))*(x4959)*(x4961)*(x4976)))+(((IkReal(-1.00000000000000))*(cj3)))+(((x4972)*(x4974)))+(((x4967)*(x4974)))+(((IkReal(-1.00000000000000))*(x4960)*(x4980))));
evalcond[4]=((((x4968)*(x4974)))+(((IkReal(-1.00000000000000))*(x4956)*(x4960)*(x4967)))+(((IkReal(-1.00000000000000))*(x4959)*(x4970)*(x4973)))+(((IkReal(-1.00000000000000))*(x4956)*(x4960)*(x4972)))+(((IkReal(-1.00000000000000))*(x4960)*(x4981)))+(((IkReal(-1.00000000000000))*(x4963)*(x4974)))+(((IkReal(-1.00000000000000))*(x4959)*(x4961)*(x4971)))+(((IkReal(-1.00000000000000))*(x4966)*(x4971)))+(((x4965)*(x4976)))+(((IkReal(-1.00000000000000))*(x4971)*(x4982))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x4959)*(x4970)*(x4976)))+(sj3)+(((IkReal(-1.00000000000000))*(r00)*(x4959)*(x4973)))+(((IkReal(-1.00000000000000))*(x4959)*(x4961)*(x4974)))+(((r01)*(sj6)*(x4973)))+(((IkReal(-1.00000000000000))*(x4966)*(x4974)))+(((x4963)*(x4971)))+(((IkReal(-1.00000000000000))*(x4957)*(x4960)*(x4972)))+(((IkReal(-1.00000000000000))*(r10)*(x4959)*(x4971)))+(((IkReal(-1.00000000000000))*(x4974)*(x4982)))+(((IkReal(-1.00000000000000))*(x4957)*(x4960)*(x4967))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst37)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst37)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst37)*(((((cj5)*(r20)*(sj6)))+(((r22)*(sj5)))+(((cj5)*(cj6)*(r21)))))), ((gconst37)*(((((r21)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x4983=IKsin(j4);
IkReal x4984=IKcos(j4);
IkReal x4985=((r22)*(sj5));
IkReal x4986=((IkReal(1.00000000000000))*(cj6));
IkReal x4987=((IkReal(1.00000000000000))*(cj0));
IkReal x4988=((cj5)*(r11));
IkReal x4989=((cj5)*(cj6));
IkReal x4990=((r11)*(sj6));
IkReal x4991=((IkReal(1.00000000000000))*(sj6));
IkReal x4992=((cj6)*(r00));
IkReal x4993=((r12)*(sj5));
IkReal x4994=((r02)*(sj5));
IkReal x4995=((cj6)*(r10));
IkReal x4996=((cj5)*(sj6));
IkReal x4997=((cj5)*(r01));
IkReal x4998=((sj0)*(x4983));
IkReal x4999=((r00)*(x4996));
IkReal x5000=((cj0)*(x4983));
IkReal x5001=((sj0)*(x4984));
IkReal x5002=((r20)*(x4984));
IkReal x5003=((cj0)*(x4984));
IkReal x5004=((r21)*(x4983));
IkReal x5005=((r21)*(x4984));
IkReal x5006=((r20)*(x4983));
IkReal x5007=((x4984)*(x4993));
IkReal x5008=((r01)*(sj6)*(x4984));
IkReal x5009=((cj5)*(r10)*(x4991));
evalcond[0]=((IkReal(-1.00000000000000))+(((sj6)*(x5005)))+(((x4996)*(x5006)))+(((x4983)*(x4985)))+(((x4989)*(x5004)))+(((IkReal(-1.00000000000000))*(x4986)*(x5002))));
evalcond[1]=((((x4989)*(x5005)))+(((x4984)*(x4985)))+(((IkReal(-1.00000000000000))*(x4991)*(x5004)))+(((cj6)*(x5006)))+(((x4996)*(x5002))));
evalcond[2]=((((r01)*(x4989)*(x4998)))+(((IkReal(-1.00000000000000))*(x4986)*(x4988)*(x5000)))+(((x4994)*(x4998)))+(((x4998)*(x4999)))+(((IkReal(-1.00000000000000))*(r10)*(x4983)*(x4987)*(x4996)))+(((IkReal(-1.00000000000000))*(x4984)*(x4987)*(x4990)))+(((IkReal(-1.00000000000000))*(x4983)*(x4987)*(x4993)))+(((x4995)*(x5003)))+(((IkReal(-1.00000000000000))*(r00)*(x4986)*(x5001)))+(((r01)*(sj6)*(x5001))));
evalcond[3]=((((x4994)*(x5001)))+(((IkReal(-1.00000000000000))*(r10)*(x4986)*(x5000)))+(((IkReal(-1.00000000000000))*(r10)*(x4984)*(x4987)*(x4996)))+(((IkReal(-1.00000000000000))*(x4987)*(x5007)))+(((x4990)*(x5000)))+(((r01)*(x4989)*(x5001)))+(((IkReal(-1.00000000000000))*(r01)*(x4991)*(x4998)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x4986)*(x4988)*(x5003)))+(((x4999)*(x5001)))+(((x4992)*(x4998))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x4993)*(x4998)))+(((IkReal(-1.00000000000000))*(x4983)*(x4987)*(x4999)))+(((IkReal(-1.00000000000000))*(x4987)*(x5008)))+(((IkReal(-1.00000000000000))*(x4986)*(x4988)*(x4998)))+(((IkReal(-1.00000000000000))*(x4990)*(x5001)))+(((IkReal(-1.00000000000000))*(x4983)*(x4987)*(x4994)))+(((x4992)*(x5003)))+(((IkReal(-1.00000000000000))*(x4998)*(x5009)))+(((x4995)*(x5001)))+(((IkReal(-1.00000000000000))*(x4986)*(x4997)*(x5000))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x4984)*(x4987)*(x4999)))+(sj3)+(((IkReal(-1.00000000000000))*(x5001)*(x5009)))+(((r01)*(sj6)*(x5000)))+(((IkReal(-1.00000000000000))*(x4993)*(x5001)))+(((IkReal(-1.00000000000000))*(x4986)*(x4997)*(x5003)))+(((IkReal(-1.00000000000000))*(x4984)*(x4987)*(x4994)))+(((IkReal(-1.00000000000000))*(x4986)*(x4988)*(x5001)))+(((IkReal(-1.00000000000000))*(r10)*(x4986)*(x4998)))+(((x4990)*(x4998)))+(((IkReal(-1.00000000000000))*(r00)*(x4986)*(x5000))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5010=((sj5)*(sj6));
IkReal x5011=((IkReal(1.00000000000000))*(sj0));
IkReal x5012=((cj6)*(sj5));
IkReal x5013=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r01)*(x5011)*(x5012)))+(((IkReal(-1.00000000000000))*(r00)*(x5010)*(x5011)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5013)))+(((cj0)*(r11)*(x5012)))+(((cj5)*(r02)*(sj0)))+(((cj0)*(r10)*(x5010))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x5012)))+(((IkReal(-1.00000000000000))*(r22)*(x5013)))+(((r20)*(x5010))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r01)*(x5011)*(x5012)))+(((IkReal(-1.00000000000000))*(r00)*(x5010)*(x5011)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5013)))+(((cj0)*(r11)*(x5012)))+(((cj5)*(r02)*(sj0)))+(((cj0)*(r10)*(x5010)))))+IKsqr(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x5012)))+(((IkReal(-1.00000000000000))*(r22)*(x5013)))+(((r20)*(x5010)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r01)*(x5011)*(x5012)))+(((IkReal(-1.00000000000000))*(r00)*(x5010)*(x5011)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5013)))+(((cj0)*(r11)*(x5012)))+(((cj5)*(r02)*(sj0)))+(((cj0)*(r10)*(x5010)))), ((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x5012)))+(((IkReal(-1.00000000000000))*(r22)*(x5013)))+(((r20)*(x5010)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x5014=IKcos(j3);
IkReal x5015=((sj5)*(sj6));
IkReal x5016=((cj0)*(cj5));
IkReal x5017=((IkReal(1.00000000000000))*(cj0));
IkReal x5018=((IkReal(1.00000000000000))*(sj0));
IkReal x5019=((IkReal(1.00000000000000))*(x5014));
IkReal x5020=((cj6)*(r01)*(sj5));
IkReal x5021=((cj6)*(r11)*(sj5));
evalcond[0]=((((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(sj1)*(x5019)))+(((r20)*(x5015)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))));
evalcond[1]=((((sj0)*(x5020)))+(((IkReal(-1.00000000000000))*(x5017)*(x5021)))+(((r12)*(x5016)))+(((r00)*(sj0)*(x5015)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(x5018)))+(((IkReal(-1.00000000000000))*(r10)*(x5015)*(x5017)))+(IKsin(j3)));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x5015)*(x5017)))+(((cj5)*(r12)*(sj0)))+(((r02)*(x5016)))+(((IkReal(-1.00000000000000))*(x5018)*(x5021)))+(((IkReal(-1.00000000000000))*(cj1)*(x5019)))+(((IkReal(-1.00000000000000))*(r10)*(x5015)*(x5018)))+(((IkReal(-1.00000000000000))*(x5017)*(x5020))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst28;
IkReal x5022=(r21)*(r21);
IkReal x5023=(cj5)*(cj5);
IkReal x5024=(sj6)*(sj6);
IkReal x5025=(cj6)*(cj6);
IkReal x5026=(r20)*(r20);
IkReal x5027=((cj6)*(r21));
IkReal x5028=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x5029=((cj5)*(r22)*(sj5));
IkReal x5030=((IkReal(1.00000000000000))*(x5024));
IkReal x5031=((IkReal(1.00000000000000))*(x5025));
gconst28=IKsign(((((IkReal(-1.00000000000000))*(x5026)*(x5031)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x5022)*(x5030)))+(((IkReal(-1.00000000000000))*(x5023)*(x5026)*(x5030)))+(((IkReal(-2.00000000000000))*(x5027)*(x5029)))+(((x5027)*(x5028)))+(((IkReal(-1.00000000000000))*(x5022)*(x5023)*(x5031)))+(((IkReal(-1.00000000000000))*(x5023)*(x5027)*(x5028)))+(((IkReal(-1.00000000000000))*(x5028)*(x5029)))));
IkReal x5032=(r21)*(r21);
IkReal x5033=(cj5)*(cj5);
IkReal x5034=(sj6)*(sj6);
IkReal x5035=(cj6)*(cj6);
IkReal x5036=(r20)*(r20);
IkReal x5037=((cj6)*(r21));
IkReal x5038=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x5039=((cj5)*(r22)*(sj5));
IkReal x5040=((IkReal(1.00000000000000))*(x5034));
IkReal x5041=((IkReal(1.00000000000000))*(x5035));
dummyeval[0]=((((x5037)*(x5038)))+(((IkReal(-1.00000000000000))*(x5038)*(x5039)))+(((IkReal(-1.00000000000000))*(x5036)*(x5041)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x5032)*(x5033)*(x5041)))+(((IkReal(-1.00000000000000))*(x5033)*(x5037)*(x5038)))+(((IkReal(-2.00000000000000))*(x5037)*(x5039)))+(((IkReal(-1.00000000000000))*(x5032)*(x5040)))+(((IkReal(-1.00000000000000))*(x5033)*(x5036)*(x5040))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst29;
IkReal x5042=(cj6)*(cj6);
IkReal x5043=(sj6)*(sj6);
IkReal x5044=((IkReal(1.00000000000000))*(r01));
IkReal x5045=((sj0)*(sj5));
IkReal x5046=((cj6)*(r22));
IkReal x5047=((r21)*(sj6));
IkReal x5048=((r00)*(r21));
IkReal x5049=((cj0)*(sj5));
IkReal x5050=((cj6)*(r20));
IkReal x5051=((r22)*(sj6));
IkReal x5052=((cj0)*(cj5));
IkReal x5053=((IkReal(1.00000000000000))*(r10));
IkReal x5054=((cj5)*(sj0));
IkReal x5055=((r20)*(x5043));
IkReal x5056=((x5042)*(x5054));
gconst29=IKsign(((((r11)*(r20)*(x5042)*(x5052)))+(((r00)*(x5045)*(x5046)))+(((IkReal(-1.00000000000000))*(x5046)*(x5049)*(x5053)))+(((IkReal(-1.00000000000000))*(r12)*(x5047)*(x5049)))+(((r11)*(x5052)*(x5055)))+(((IkReal(-1.00000000000000))*(r20)*(x5044)*(x5056)))+(((r02)*(x5045)*(x5047)))+(((IkReal(-1.00000000000000))*(r21)*(x5042)*(x5052)*(x5053)))+(((IkReal(-1.00000000000000))*(x5044)*(x5045)*(x5051)))+(((IkReal(-1.00000000000000))*(r21)*(x5043)*(x5052)*(x5053)))+(((r12)*(x5049)*(x5050)))+(((IkReal(-1.00000000000000))*(r02)*(x5045)*(x5050)))+(((x5043)*(x5048)*(x5054)))+(((x5048)*(x5056)))+(((IkReal(-1.00000000000000))*(x5044)*(x5054)*(x5055)))+(((r11)*(x5049)*(x5051)))));
IkReal x5057=(cj6)*(cj6);
IkReal x5058=(sj6)*(sj6);
IkReal x5059=((IkReal(1.00000000000000))*(r01));
IkReal x5060=((sj0)*(sj5));
IkReal x5061=((cj6)*(r22));
IkReal x5062=((r21)*(sj6));
IkReal x5063=((r00)*(r21));
IkReal x5064=((cj0)*(sj5));
IkReal x5065=((cj6)*(r20));
IkReal x5066=((r22)*(sj6));
IkReal x5067=((cj0)*(cj5));
IkReal x5068=((IkReal(1.00000000000000))*(r10));
IkReal x5069=((cj5)*(sj0));
IkReal x5070=((r20)*(x5058));
IkReal x5071=((x5057)*(x5069));
dummyeval[0]=((((r02)*(x5060)*(x5062)))+(((x5058)*(x5063)*(x5069)))+(((IkReal(-1.00000000000000))*(x5061)*(x5064)*(x5068)))+(((r11)*(r20)*(x5057)*(x5067)))+(((IkReal(-1.00000000000000))*(r12)*(x5062)*(x5064)))+(((r11)*(x5064)*(x5066)))+(((r11)*(x5067)*(x5070)))+(((IkReal(-1.00000000000000))*(r02)*(x5060)*(x5065)))+(((x5063)*(x5071)))+(((r00)*(x5060)*(x5061)))+(((r12)*(x5064)*(x5065)))+(((IkReal(-1.00000000000000))*(r21)*(x5058)*(x5067)*(x5068)))+(((IkReal(-1.00000000000000))*(x5059)*(x5069)*(x5070)))+(((IkReal(-1.00000000000000))*(x5059)*(x5060)*(x5066)))+(((IkReal(-1.00000000000000))*(r21)*(x5057)*(x5067)*(x5068)))+(((IkReal(-1.00000000000000))*(r20)*(x5059)*(x5071))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x5072=((cj1)*(cj6));
IkReal x5073=((IkReal(1.00000000000000))*(sj0));
IkReal x5074=((cj0)*(r10));
IkReal x5075=((cj1)*(sj5));
IkReal x5076=((cj1)*(sj6));
IkReal x5077=((cj0)*(r11));
if( IKabs(((gconst29)*(((((IkReal(-1.00000000000000))*(x5076)*(x5077)))+(((x5072)*(x5074)))+(((r01)*(sj0)*(x5076)))+(((IkReal(-1.00000000000000))*(r00)*(x5072)*(x5073))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst29)*(((((cj5)*(x5074)*(x5076)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5073)*(x5076)))+(((cj5)*(x5072)*(x5077)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x5072)*(x5073)))+(((IkReal(-1.00000000000000))*(r02)*(x5073)*(x5075)))+(((cj0)*(r12)*(x5075))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst29)*(((((IkReal(-1.00000000000000))*(x5076)*(x5077)))+(((x5072)*(x5074)))+(((r01)*(sj0)*(x5076)))+(((IkReal(-1.00000000000000))*(r00)*(x5072)*(x5073)))))), ((gconst29)*(((((cj5)*(x5074)*(x5076)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5073)*(x5076)))+(((cj5)*(x5072)*(x5077)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x5072)*(x5073)))+(((IkReal(-1.00000000000000))*(r02)*(x5073)*(x5075)))+(((cj0)*(r12)*(x5075)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x5078=IKsin(j4);
IkReal x5079=IKcos(j4);
IkReal x5080=((r22)*(sj5));
IkReal x5081=((IkReal(1.00000000000000))*(cj6));
IkReal x5082=((IkReal(1.00000000000000))*(cj0));
IkReal x5083=((IkReal(1.00000000000000))*(sj1));
IkReal x5084=((cj5)*(r11));
IkReal x5085=((cj5)*(cj6));
IkReal x5086=((r11)*(sj6));
IkReal x5087=((IkReal(1.00000000000000))*(sj6));
IkReal x5088=((cj6)*(r00));
IkReal x5089=((r12)*(sj5));
IkReal x5090=((r02)*(sj5));
IkReal x5091=((cj6)*(r10));
IkReal x5092=((cj5)*(sj6));
IkReal x5093=((cj5)*(r01));
IkReal x5094=((sj0)*(x5078));
IkReal x5095=((r00)*(x5092));
IkReal x5096=((cj0)*(x5078));
IkReal x5097=((sj0)*(x5079));
IkReal x5098=((r20)*(x5079));
IkReal x5099=((cj0)*(x5079));
IkReal x5100=((r21)*(x5078));
IkReal x5101=((r21)*(x5079));
IkReal x5102=((r20)*(x5078));
IkReal x5103=((x5079)*(x5089));
IkReal x5104=((r01)*(sj6)*(x5079));
IkReal x5105=((cj5)*(r10)*(x5087));
evalcond[0]=((((IkReal(-1.00000000000000))*(x5081)*(x5098)))+(((x5085)*(x5100)))+(((x5092)*(x5102)))+(cj1)+(((sj6)*(x5101)))+(((x5078)*(x5080))));
evalcond[1]=((((x5085)*(x5101)))+(((x5079)*(x5080)))+(((x5092)*(x5098)))+(((IkReal(-1.00000000000000))*(sj3)*(x5083)))+(((IkReal(-1.00000000000000))*(x5087)*(x5100)))+(((cj6)*(x5102))));
evalcond[2]=((((x5090)*(x5094)))+(((x5091)*(x5099)))+(((r01)*(sj6)*(x5097)))+(((IkReal(-1.00000000000000))*(x5078)*(x5082)*(x5089)))+(((IkReal(-1.00000000000000))*(x5079)*(x5082)*(x5086)))+(((IkReal(-1.00000000000000))*(r00)*(x5081)*(x5097)))+(((r01)*(x5085)*(x5094)))+(((IkReal(-1.00000000000000))*(r10)*(x5078)*(x5082)*(x5092)))+(((IkReal(-1.00000000000000))*(x5081)*(x5084)*(x5096)))+(((x5094)*(x5095))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x5082)*(x5103)))+(((IkReal(-1.00000000000000))*(r10)*(x5081)*(x5096)))+(((IkReal(-1.00000000000000))*(x5081)*(x5084)*(x5099)))+(((IkReal(-1.00000000000000))*(cj3)))+(((x5095)*(x5097)))+(((x5086)*(x5096)))+(((IkReal(-1.00000000000000))*(r01)*(x5087)*(x5094)))+(((r01)*(x5085)*(x5097)))+(((x5090)*(x5097)))+(((x5088)*(x5094)))+(((IkReal(-1.00000000000000))*(r10)*(x5079)*(x5082)*(x5092))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x5094)*(x5105)))+(((IkReal(-1.00000000000000))*(x5082)*(x5104)))+(((IkReal(-1.00000000000000))*(x5086)*(x5097)))+(((IkReal(-1.00000000000000))*(x5081)*(x5093)*(x5096)))+(((IkReal(-1.00000000000000))*(x5089)*(x5094)))+(((IkReal(-1.00000000000000))*(x5081)*(x5084)*(x5094)))+(((x5091)*(x5097)))+(((x5088)*(x5099)))+(((IkReal(-1.00000000000000))*(x5078)*(x5082)*(x5090)))+(((IkReal(-1.00000000000000))*(x5078)*(x5082)*(x5095)))+(((IkReal(-1.00000000000000))*(x5083))));
evalcond[5]=((((x5086)*(x5094)))+(((IkReal(-1.00000000000000))*(r00)*(x5081)*(x5096)))+(((IkReal(-1.00000000000000))*(r10)*(x5081)*(x5094)))+(((r01)*(sj6)*(x5096)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((IkReal(-1.00000000000000))*(x5081)*(x5093)*(x5099)))+(((IkReal(-1.00000000000000))*(x5079)*(x5082)*(x5090)))+(((IkReal(-1.00000000000000))*(x5079)*(x5082)*(x5095)))+(((IkReal(-1.00000000000000))*(x5081)*(x5084)*(x5097)))+(((IkReal(-1.00000000000000))*(x5097)*(x5105)))+(((IkReal(-1.00000000000000))*(x5089)*(x5097))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x5106=((cj1)*(r20));
IkReal x5107=((cj5)*(sj6));
IkReal x5108=((sj1)*(sj3));
IkReal x5109=((r21)*(sj6));
IkReal x5110=((r22)*(sj5));
IkReal x5111=((IkReal(1.00000000000000))*(cj6));
IkReal x5112=((cj5)*(r21));
if( IKabs(((gconst28)*(((((cj1)*(x5110)))+(((x5106)*(x5107)))+(((IkReal(-1.00000000000000))*(r20)*(x5108)*(x5111)))+(((x5108)*(x5109)))+(((cj1)*(cj6)*(x5112))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst28)*(((((IkReal(-1.00000000000000))*(r20)*(x5107)*(x5108)))+(((IkReal(-1.00000000000000))*(x5108)*(x5111)*(x5112)))+(((IkReal(-1.00000000000000))*(x5108)*(x5110)))+(((cj1)*(x5109)))+(((IkReal(-1.00000000000000))*(x5106)*(x5111))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst28)*(((((cj1)*(x5110)))+(((x5106)*(x5107)))+(((IkReal(-1.00000000000000))*(r20)*(x5108)*(x5111)))+(((x5108)*(x5109)))+(((cj1)*(cj6)*(x5112)))))), ((gconst28)*(((((IkReal(-1.00000000000000))*(r20)*(x5107)*(x5108)))+(((IkReal(-1.00000000000000))*(x5108)*(x5111)*(x5112)))+(((IkReal(-1.00000000000000))*(x5108)*(x5110)))+(((cj1)*(x5109)))+(((IkReal(-1.00000000000000))*(x5106)*(x5111)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x5113=IKsin(j4);
IkReal x5114=IKcos(j4);
IkReal x5115=((r22)*(sj5));
IkReal x5116=((IkReal(1.00000000000000))*(cj6));
IkReal x5117=((IkReal(1.00000000000000))*(cj0));
IkReal x5118=((IkReal(1.00000000000000))*(sj1));
IkReal x5119=((cj5)*(r11));
IkReal x5120=((cj5)*(cj6));
IkReal x5121=((r11)*(sj6));
IkReal x5122=((IkReal(1.00000000000000))*(sj6));
IkReal x5123=((cj6)*(r00));
IkReal x5124=((r12)*(sj5));
IkReal x5125=((r02)*(sj5));
IkReal x5126=((cj6)*(r10));
IkReal x5127=((cj5)*(sj6));
IkReal x5128=((cj5)*(r01));
IkReal x5129=((sj0)*(x5113));
IkReal x5130=((r00)*(x5127));
IkReal x5131=((cj0)*(x5113));
IkReal x5132=((sj0)*(x5114));
IkReal x5133=((r20)*(x5114));
IkReal x5134=((cj0)*(x5114));
IkReal x5135=((r21)*(x5113));
IkReal x5136=((r21)*(x5114));
IkReal x5137=((r20)*(x5113));
IkReal x5138=((x5114)*(x5124));
IkReal x5139=((r01)*(sj6)*(x5114));
IkReal x5140=((cj5)*(r10)*(x5122));
evalcond[0]=((((x5127)*(x5137)))+(((x5113)*(x5115)))+(((x5120)*(x5135)))+(cj1)+(((IkReal(-1.00000000000000))*(x5116)*(x5133)))+(((sj6)*(x5136))));
evalcond[1]=((((cj6)*(x5137)))+(((x5114)*(x5115)))+(((x5127)*(x5133)))+(((IkReal(-1.00000000000000))*(x5122)*(x5135)))+(((x5120)*(x5136)))+(((IkReal(-1.00000000000000))*(sj3)*(x5118))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x5113)*(x5117)*(x5124)))+(((IkReal(-1.00000000000000))*(x5116)*(x5119)*(x5131)))+(((x5125)*(x5129)))+(((x5129)*(x5130)))+(((IkReal(-1.00000000000000))*(x5114)*(x5117)*(x5121)))+(((x5126)*(x5134)))+(((r01)*(sj6)*(x5132)))+(((IkReal(-1.00000000000000))*(r10)*(x5113)*(x5117)*(x5127)))+(((r01)*(x5120)*(x5129)))+(((IkReal(-1.00000000000000))*(r00)*(x5116)*(x5132))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x5116)*(x5131)))+(((IkReal(-1.00000000000000))*(r10)*(x5114)*(x5117)*(x5127)))+(((x5130)*(x5132)))+(((IkReal(-1.00000000000000))*(x5117)*(x5138)))+(((IkReal(-1.00000000000000))*(x5116)*(x5119)*(x5134)))+(((x5123)*(x5129)))+(((r01)*(x5120)*(x5132)))+(((x5121)*(x5131)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(r01)*(x5122)*(x5129)))+(((x5125)*(x5132))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x5116)*(x5119)*(x5129)))+(((IkReal(-1.00000000000000))*(x5129)*(x5140)))+(((IkReal(-1.00000000000000))*(x5113)*(x5117)*(x5125)))+(((x5126)*(x5132)))+(((IkReal(-1.00000000000000))*(x5117)*(x5139)))+(((IkReal(-1.00000000000000))*(x5113)*(x5117)*(x5130)))+(((IkReal(-1.00000000000000))*(x5124)*(x5129)))+(((IkReal(-1.00000000000000))*(x5121)*(x5132)))+(((IkReal(-1.00000000000000))*(x5118)))+(((x5123)*(x5134)))+(((IkReal(-1.00000000000000))*(x5116)*(x5128)*(x5131))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x5116)*(x5128)*(x5134)))+(((IkReal(-1.00000000000000))*(x5114)*(x5117)*(x5125)))+(((IkReal(-1.00000000000000))*(x5114)*(x5117)*(x5130)))+(((IkReal(-1.00000000000000))*(x5116)*(x5119)*(x5132)))+(((IkReal(-1.00000000000000))*(r00)*(x5116)*(x5131)))+(((x5121)*(x5129)))+(((IkReal(-1.00000000000000))*(r10)*(x5116)*(x5129)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((IkReal(-1.00000000000000))*(x5132)*(x5140)))+(((r01)*(sj6)*(x5131)))+(((IkReal(-1.00000000000000))*(x5124)*(x5132))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x5141=((IkReal(1.00000000000000))*(sj1));
IkReal x5142=((cj0)*(cj1));
IkReal x5143=((cj1)*(sj0));
IkReal x5144=((cj5)*(sj6));
IkReal x5145=((cj5)*(cj6));
IkReal x5146=((sj6)*(x5142));
IkReal x5147=((cj6)*(x5143));
if( IKabs(((gconst27)*(((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x5143)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x5141)))+(((r10)*(x5147)))+(((IkReal(-1.00000000000000))*(r01)*(x5146)))+(((cj6)*(r00)*(x5142)))+(((r21)*(sj1)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst27)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x5141)))+(((r01)*(x5142)*(x5145)))+(((r12)*(sj5)*(x5143)))+(((IkReal(-1.00000000000000))*(r20)*(x5141)*(x5144)))+(((r11)*(x5143)*(x5145)))+(((r00)*(x5142)*(x5144)))+(((r02)*(sj5)*(x5142)))+(((IkReal(-1.00000000000000))*(r21)*(x5141)*(x5145)))+(((r10)*(x5143)*(x5144))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst27)*(((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x5143)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x5141)))+(((r10)*(x5147)))+(((IkReal(-1.00000000000000))*(r01)*(x5146)))+(((cj6)*(r00)*(x5142)))+(((r21)*(sj1)*(sj6)))))), ((gconst27)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x5141)))+(((r01)*(x5142)*(x5145)))+(((r12)*(sj5)*(x5143)))+(((IkReal(-1.00000000000000))*(r20)*(x5141)*(x5144)))+(((r11)*(x5143)*(x5145)))+(((r00)*(x5142)*(x5144)))+(((r02)*(sj5)*(x5142)))+(((IkReal(-1.00000000000000))*(r21)*(x5141)*(x5145)))+(((r10)*(x5143)*(x5144)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x5148=IKsin(j4);
IkReal x5149=IKcos(j4);
IkReal x5150=((r00)*(sj6));
IkReal x5151=((cj6)*(r01));
IkReal x5152=((IkReal(1.00000000000000))*(cj0));
IkReal x5153=((IkReal(1.00000000000000))*(sj0));
IkReal x5154=((r10)*(sj6));
IkReal x5155=((sj5)*(x5148));
IkReal x5156=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x5157=((cj5)*(x5148));
IkReal x5158=((cj6)*(x5149));
IkReal x5159=((sj0)*(x5157));
IkReal x5160=((r01)*(sj6)*(x5149));
IkReal x5161=((r11)*(sj6)*(x5149));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x5158)))+(((r21)*(sj6)*(x5149)))+(((r20)*(sj6)*(x5157)))+(cj1)+(((r22)*(x5155)))+(((cj6)*(r21)*(x5157))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x5153)*(x5158)))+(((IkReal(-1.00000000000000))*(r12)*(x5152)*(x5155)))+(((IkReal(-1.00000000000000))*(x5152)*(x5154)*(x5157)))+(((x5150)*(x5159)))+(((x5151)*(x5159)))+(((cj0)*(r10)*(x5158)))+(((r02)*(sj0)*(x5155)))+(((sj0)*(x5160)))+(((IkReal(-1.00000000000000))*(x5152)*(x5161)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x5152)*(x5157))));
evalcond[2]=((((r10)*(sj0)*(x5158)))+(((cj0)*(r00)*(x5158)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x5153)*(x5157)))+(((IkReal(-1.00000000000000))*(x5151)*(x5152)*(x5157)))+(((IkReal(-1.00000000000000))*(x5152)*(x5160)))+(((IkReal(-1.00000000000000))*(x5153)*(x5154)*(x5157)))+(((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x5150)*(x5152)*(x5157)))+(((IkReal(-1.00000000000000))*(r02)*(x5152)*(x5155)))+(((IkReal(-1.00000000000000))*(r12)*(x5153)*(x5155)))+(((IkReal(-1.00000000000000))*(x5153)*(x5161))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst30;
gconst30=IKsign(sj1);
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x5162=((IkReal(1.00000000000000))*(cj0));
IkReal x5163=((cj4)*(sj6));
IkReal x5164=((sj0)*(sj6));
IkReal x5165=((cj5)*(sj4));
IkReal x5166=((IkReal(0.374290000000000))*(sj5));
IkReal x5167=((sj4)*(sj5));
IkReal x5168=((cj0)*(cj6));
IkReal x5169=((IkReal(0.0100000000000000))*(cj5));
IkReal x5170=((cj4)*(sj5));
IkReal x5171=((cj5)*(sj0));
IkReal x5172=((IkReal(0.374290000000000))*(r02));
IkReal x5173=((r20)*(sj6));
IkReal x5174=((cj6)*(r21));
IkReal x5175=((IkReal(1.00000000000000))*(sj0));
IkReal x5176=((cj0)*(sj6));
IkReal x5177=((cj4)*(cj6));
IkReal x5178=((IkReal(0.374290000000000))*(r12));
IkReal x5179=((cj0)*(cj5));
IkReal x5180=((cj6)*(sj5));
IkReal x5181=((cj6)*(r01));
IkReal x5182=((r00)*(sj6));
IkReal x5183=((IkReal(0.0100000000000000))*(sj5));
IkReal x5184=((cj6)*(r11));
IkReal x5185=((IkReal(1.00000000000000))*(r10));
IkReal x5186=((r02)*(sj0));
IkReal x5187=((cj6)*(sj4));
IkReal x5188=((r12)*(x5175));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x5177)))+(((r21)*(x5163)))+(((x5165)*(x5173)))+(((r22)*(x5167)))+(((x5165)*(x5174))));
evalcond[2]=((IkReal(0.364420000000000))+(((x5166)*(x5174)))+(((IkReal(-1.00000000000000))*(x5169)*(x5174)))+(((IkReal(-1.00000000000000))*(x5169)*(x5173)))+(((IkReal(-1.00000000000000))*(r22)*(x5183)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((x5166)*(x5173))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x5164)*(x5185)))+(((IkReal(-1.00000000000000))*(sj5)*(x5162)*(x5182)))+(((r02)*(x5179)))+(((IkReal(-1.00000000000000))*(r01)*(x5162)*(x5180)))+(((IkReal(-1.00000000000000))*(r11)*(x5175)*(x5180)))+(((r12)*(x5171))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r11)*(x5162)*(x5163)))+(((cj4)*(r10)*(x5168)))+(((x5167)*(x5186)))+(((IkReal(-1.00000000000000))*(x5162)*(x5165)*(x5184)))+(((r00)*(x5164)*(x5165)))+(((IkReal(-1.00000000000000))*(r00)*(x5175)*(x5177)))+(((r01)*(sj0)*(x5163)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x5162)*(x5165)))+(((sj0)*(x5165)*(x5181)))+(((IkReal(-1.00000000000000))*(r12)*(x5162)*(x5167))));
evalcond[5]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r01)*(x5162)*(x5163)))+(((IkReal(-1.00000000000000))*(x5162)*(x5165)*(x5181)))+(((IkReal(-1.00000000000000))*(r02)*(x5162)*(x5167)))+(((r10)*(sj0)*(x5177)))+(((IkReal(-1.00000000000000))*(x5165)*(x5175)*(x5184)))+(((IkReal(-1.00000000000000))*(x5167)*(x5188)))+(((IkReal(-1.00000000000000))*(x5162)*(x5165)*(x5182)))+(((cj4)*(r00)*(x5168)))+(((IkReal(-1.00000000000000))*(r11)*(x5163)*(x5175)))+(((IkReal(-1.00000000000000))*(x5164)*(x5165)*(x5185))));
evalcond[6]=((IkReal(-0.0690000000000000))+(((r11)*(x5168)*(x5169)))+(((r10)*(x5169)*(x5176)))+(((IkReal(-1.00000000000000))*(py)*(x5162)))+(((IkReal(-1.00000000000000))*(r10)*(x5166)*(x5176)))+(((r00)*(x5164)*(x5166)))+(((x5178)*(x5179)))+(((IkReal(-1.00000000000000))*(x5171)*(x5172)))+(((cj0)*(r12)*(x5183)))+(((IkReal(-1.00000000000000))*(r11)*(x5166)*(x5168)))+(((IkReal(-1.00000000000000))*(r00)*(x5164)*(x5169)))+(((IkReal(-1.00000000000000))*(x5183)*(x5186)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(sj0)*(x5169)*(x5181)))+(((sj0)*(x5166)*(x5181))));
evalcond[7]=((((r01)*(sj4)*(x5176)))+(((IkReal(-1.00000000000000))*(r10)*(x5175)*(x5187)))+(((IkReal(-1.00000000000000))*(x5170)*(x5188)))+(((IkReal(-1.00000000000000))*(r11)*(x5171)*(x5177)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5162)*(x5163)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x5162)*(x5177)))+(((IkReal(-1.00000000000000))*(x5163)*(x5171)*(x5185)))+(((IkReal(-1.00000000000000))*(r00)*(x5162)*(x5187)))+(((r11)*(sj4)*(x5164)))+(((IkReal(-1.00000000000000))*(r02)*(x5162)*(x5170))));
evalcond[8]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r01)*(x5166)*(x5168)))+(((r12)*(sj0)*(x5183)))+(((IkReal(-1.00000000000000))*(r00)*(x5166)*(x5176)))+(((r00)*(x5169)*(x5176)))+(((r01)*(x5168)*(x5169)))+(((r10)*(x5164)*(x5169)))+(((IkReal(-1.00000000000000))*(px)*(x5162)))+(((sj0)*(x5169)*(x5184)))+(((cj0)*(r02)*(x5183)))+(((IkReal(-1.00000000000000))*(r10)*(x5164)*(x5166)))+(((IkReal(-1.00000000000000))*(py)*(x5175)))+(((IkReal(-1.00000000000000))*(sj0)*(x5166)*(x5184)))+(((x5172)*(x5179)))+(((x5171)*(x5178))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5189=((r20)*(sj6));
IkReal x5190=((cj4)*(cj5));
IkReal x5191=((cj6)*(r21));
if( IKabs(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x5189)*(x5190)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5190)*(x5191))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x5189)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5191))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x5189)*(x5190)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5190)*(x5191)))))+IKsqr(((((sj5)*(x5189)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5191)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x5189)*(x5190)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5190)*(x5191)))), ((((sj5)*(x5189)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5191)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5192=IKsin(j3);
IkReal x5193=((sj0)*(sj5));
IkReal x5194=((r00)*(sj6));
IkReal x5195=((cj6)*(r01));
IkReal x5196=((cj5)*(sj0));
IkReal x5197=((cj0)*(cj5));
IkReal x5198=((cj6)*(sj4));
IkReal x5199=((sj4)*(sj6));
IkReal x5200=((cj0)*(r11));
IkReal x5201=((cj4)*(cj6));
IkReal x5202=((cj4)*(sj6));
IkReal x5203=((IkReal(1.00000000000000))*(cj0));
IkReal x5204=((cj4)*(sj5));
IkReal x5205=((sj5)*(sj6));
IkReal x5206=((cj6)*(sj5));
IkReal x5207=((IkReal(1.00000000000000))*(IKcos(j3)));
evalcond[0]=((((IkReal(-1.00000000000000))*(x5207)))+(((r21)*(x5206)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r20)*(x5205))));
evalcond[1]=((((cj5)*(r21)*(x5201)))+(((cj5)*(r20)*(x5202)))+(((IkReal(-1.00000000000000))*(r21)*(x5199)))+(((r22)*(x5204)))+(((IkReal(-1.00000000000000))*(x5192)))+(((r20)*(x5198))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x5200)*(x5206)))+(x5192)+(((r12)*(x5197)))+(((IkReal(-1.00000000000000))*(r10)*(x5203)*(x5205)))+(((x5193)*(x5194)))+(((IkReal(-1.00000000000000))*(r02)*(x5196)))+(((x5193)*(x5195))));
evalcond[3]=((((x5199)*(x5200)))+(((cj4)*(x5195)*(x5196)))+(((IkReal(-1.00000000000000))*(r11)*(x5197)*(x5201)))+(((IkReal(-1.00000000000000))*(r10)*(x5197)*(x5202)))+(((IkReal(-1.00000000000000))*(x5207)))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x5199)))+(((IkReal(-1.00000000000000))*(r10)*(x5198)*(x5203)))+(((cj4)*(r02)*(x5193)))+(((IkReal(-1.00000000000000))*(r12)*(x5203)*(x5204)))+(((cj4)*(x5194)*(x5196)))+(((r00)*(sj0)*(x5198))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x5208=((IkReal(1.00000000000000))*(cj0));
IkReal x5209=((cj4)*(sj6));
IkReal x5210=((sj0)*(sj6));
IkReal x5211=((cj5)*(sj4));
IkReal x5212=((IkReal(0.374290000000000))*(sj5));
IkReal x5213=((sj4)*(sj5));
IkReal x5214=((cj0)*(cj6));
IkReal x5215=((IkReal(0.0100000000000000))*(cj5));
IkReal x5216=((cj4)*(sj5));
IkReal x5217=((cj5)*(sj0));
IkReal x5218=((IkReal(0.374290000000000))*(r02));
IkReal x5219=((r20)*(sj6));
IkReal x5220=((cj6)*(r21));
IkReal x5221=((IkReal(1.00000000000000))*(sj0));
IkReal x5222=((cj0)*(sj6));
IkReal x5223=((cj4)*(cj6));
IkReal x5224=((IkReal(0.374290000000000))*(r12));
IkReal x5225=((cj0)*(cj5));
IkReal x5226=((cj6)*(sj5));
IkReal x5227=((cj6)*(r01));
IkReal x5228=((r00)*(sj6));
IkReal x5229=((IkReal(0.0100000000000000))*(sj5));
IkReal x5230=((cj6)*(r11));
IkReal x5231=((IkReal(1.00000000000000))*(r10));
IkReal x5232=((r02)*(sj0));
IkReal x5233=((cj6)*(sj4));
IkReal x5234=((r12)*(x5221));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x5223)))+(((x5211)*(x5220)))+(((r22)*(x5213)))+(((r21)*(x5209)))+(((x5211)*(x5219))));
evalcond[2]=((IkReal(-0.364420000000000))+(((IkReal(-1.00000000000000))*(r22)*(x5229)))+(((IkReal(-1.00000000000000))*(x5215)*(x5220)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x5215)*(x5219)))+(pz)+(((x5212)*(x5219)))+(((x5212)*(x5220))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj5)*(x5210)*(x5231)))+(((IkReal(-1.00000000000000))*(r01)*(x5208)*(x5226)))+(((IkReal(-1.00000000000000))*(r11)*(x5221)*(x5226)))+(((r12)*(x5217)))+(((r02)*(x5225)))+(((IkReal(-1.00000000000000))*(sj5)*(x5208)*(x5228))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r12)*(x5208)*(x5213)))+(((r01)*(sj0)*(x5209)))+(((IkReal(-1.00000000000000))*(x5208)*(x5211)*(x5230)))+(((sj0)*(x5211)*(x5227)))+(((IkReal(-1.00000000000000))*(r00)*(x5221)*(x5223)))+(((IkReal(-1.00000000000000))*(r11)*(x5208)*(x5209)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x5208)*(x5211)))+(((cj4)*(r10)*(x5214)))+(((r00)*(x5210)*(x5211)))+(((x5213)*(x5232))));
evalcond[5]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x5208)*(x5211)*(x5228)))+(((IkReal(-1.00000000000000))*(r01)*(x5208)*(x5209)))+(((IkReal(-1.00000000000000))*(r02)*(x5208)*(x5213)))+(((IkReal(-1.00000000000000))*(r11)*(x5209)*(x5221)))+(((IkReal(-1.00000000000000))*(x5210)*(x5211)*(x5231)))+(((IkReal(-1.00000000000000))*(x5208)*(x5211)*(x5227)))+(((IkReal(-1.00000000000000))*(x5211)*(x5221)*(x5230)))+(((r10)*(sj0)*(x5223)))+(((cj4)*(r00)*(x5214)))+(((IkReal(-1.00000000000000))*(x5213)*(x5234))));
evalcond[6]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(py)*(x5208)))+(((r11)*(x5214)*(x5215)))+(((IkReal(-1.00000000000000))*(r00)*(x5210)*(x5215)))+(((IkReal(-1.00000000000000))*(x5229)*(x5232)))+(((IkReal(-1.00000000000000))*(x5217)*(x5218)))+(((IkReal(-1.00000000000000))*(sj0)*(x5215)*(x5227)))+(((r00)*(x5210)*(x5212)))+(((cj0)*(r12)*(x5229)))+(((IkReal(-1.00000000000000))*(r11)*(x5212)*(x5214)))+(((IkReal(-1.00000000000000))*(r10)*(x5212)*(x5222)))+(((x5224)*(x5225)))+(((px)*(sj0)))+(((sj0)*(x5212)*(x5227)))+(((r10)*(x5215)*(x5222))));
evalcond[7]=((((r11)*(sj4)*(x5210)))+(((IkReal(-1.00000000000000))*(r11)*(x5217)*(x5223)))+(((IkReal(-1.00000000000000))*(r10)*(x5221)*(x5233)))+(((IkReal(-1.00000000000000))*(r02)*(x5208)*(x5216)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x5208)*(x5223)))+(((r01)*(sj4)*(x5222)))+(((IkReal(-1.00000000000000))*(x5216)*(x5234)))+(((IkReal(-1.00000000000000))*(x5209)*(x5217)*(x5231)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5208)*(x5209)))+(((IkReal(-1.00000000000000))*(r00)*(x5208)*(x5233))));
evalcond[8]=((IkReal(0.0690000000000000))+(((r01)*(x5214)*(x5215)))+(((IkReal(-1.00000000000000))*(r01)*(x5212)*(x5214)))+(((sj0)*(x5215)*(x5230)))+(((r10)*(x5210)*(x5215)))+(((IkReal(-1.00000000000000))*(px)*(x5208)))+(((IkReal(-1.00000000000000))*(sj0)*(x5212)*(x5230)))+(((r00)*(x5215)*(x5222)))+(((IkReal(-1.00000000000000))*(r00)*(x5212)*(x5222)))+(((cj0)*(r02)*(x5229)))+(((r12)*(sj0)*(x5229)))+(((IkReal(-1.00000000000000))*(py)*(x5221)))+(((x5217)*(x5224)))+(((IkReal(-1.00000000000000))*(r10)*(x5210)*(x5212)))+(((x5218)*(x5225))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5235=((IkReal(1.00000000000000))*(sj5));
IkReal x5236=((cj6)*(r21));
IkReal x5237=((r20)*(sj6));
IkReal x5238=((IkReal(1.00000000000000))*(cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj4)*(r22)*(x5235)))+(((IkReal(-1.00000000000000))*(x5237)*(x5238)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x5236)*(x5238)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x5235)*(x5236)))+(((IkReal(-1.00000000000000))*(x5235)*(x5237)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj4)*(r22)*(x5235)))+(((IkReal(-1.00000000000000))*(x5237)*(x5238)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x5236)*(x5238)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))+IKsqr(((((IkReal(-1.00000000000000))*(x5235)*(x5236)))+(((IkReal(-1.00000000000000))*(x5235)*(x5237)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj4)*(r22)*(x5235)))+(((IkReal(-1.00000000000000))*(x5237)*(x5238)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x5236)*(x5238)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))), ((((IkReal(-1.00000000000000))*(x5235)*(x5236)))+(((IkReal(-1.00000000000000))*(x5235)*(x5237)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5239=IKsin(j3);
IkReal x5240=IKcos(j3);
IkReal x5241=((sj0)*(sj5));
IkReal x5242=((r00)*(sj6));
IkReal x5243=((cj6)*(r01));
IkReal x5244=((cj0)*(cj5));
IkReal x5245=((IkReal(1.00000000000000))*(cj5));
IkReal x5246=((cj4)*(cj5));
IkReal x5247=((cj6)*(sj4));
IkReal x5248=((sj4)*(sj6));
IkReal x5249=((cj0)*(r11));
IkReal x5250=((IkReal(1.00000000000000))*(cj4));
IkReal x5251=((cj6)*(r21));
IkReal x5252=((r20)*(sj6));
IkReal x5253=((cj0)*(sj5));
IkReal x5254=((r10)*(sj6));
evalcond[0]=((x5240)+(((IkReal(-1.00000000000000))*(r22)*(x5245)))+(((sj5)*(x5251)))+(((sj5)*(x5252))));
evalcond[1]=((((x5246)*(x5252)))+(x5239)+(((cj4)*(r22)*(sj5)))+(((r20)*(x5247)))+(((x5246)*(x5251)))+(((IkReal(-1.00000000000000))*(r21)*(x5248))));
evalcond[2]=((x5239)+(((r12)*(x5244)))+(((IkReal(-1.00000000000000))*(x5253)*(x5254)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x5249)))+(((x5241)*(x5242)))+(((x5241)*(x5243)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x5245))));
evalcond[3]=((((sj0)*(x5242)*(x5246)))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x5248)))+(((r00)*(sj0)*(x5247)))+(((IkReal(-1.00000000000000))*(x5244)*(x5250)*(x5254)))+(((sj0)*(x5243)*(x5246)))+(((IkReal(-1.00000000000000))*(cj0)*(r10)*(x5247)))+(((IkReal(-1.00000000000000))*(r12)*(x5250)*(x5253)))+(((x5248)*(x5249)))+(((IkReal(-1.00000000000000))*(x5240)))+(((cj4)*(r02)*(x5241)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x5244)*(x5250))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x5255=((IkReal(1.00000000000000))*(cj0));
IkReal x5256=((cj4)*(sj6));
IkReal x5257=((sj0)*(sj4));
IkReal x5258=((cj5)*(sj6));
IkReal x5259=((sj4)*(sj5));
IkReal x5260=((r12)*(sj5));
IkReal x5261=((IkReal(0.374290000000000))*(cj5));
IkReal x5262=((r02)*(sj0));
IkReal x5263=((r20)*(sj4));
IkReal x5264=((IkReal(1.00000000000000))*(sj0));
IkReal x5265=((IkReal(1.00000000000000))*(cj5));
IkReal x5266=((cj0)*(r10));
IkReal x5267=((cj4)*(cj6));
IkReal x5268=((r00)*(sj0));
IkReal x5269=((cj6)*(r21));
IkReal x5270=((IkReal(0.374290000000000))*(sj5));
IkReal x5271=((cj0)*(r00));
IkReal x5272=((IkReal(0.0100000000000000))*(sj5));
IkReal x5273=((cj0)*(r02));
IkReal x5274=((cj5)*(sj4));
IkReal x5275=((cj6)*(r01));
IkReal x5276=((cj6)*(r11));
IkReal x5277=((r01)*(sj0));
IkReal x5278=((r10)*(sj0));
IkReal x5279=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x5280=((sj6)*(x5270));
IkReal x5281=((cj0)*(cj6)*(x5270));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x5269)))+(((r20)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(r22)*(x5265))));
evalcond[2]=((IkReal(1.00000000000000))+(((x5258)*(x5263)))+(((IkReal(-1.00000000000000))*(r20)*(x5267)))+(((x5269)*(x5274)))+(((r21)*(x5256)))+(((r22)*(x5259))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x5272)))+(((r20)*(x5280)))+(((IkReal(-0.0100000000000000))*(r20)*(x5258)))+(((IkReal(-0.0100000000000000))*(cj5)*(x5269)))+(pz)+(((x5269)*(x5270)))+(((IkReal(-1.00000000000000))*(r22)*(x5261))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(x5263)))+(((cj5)*(r21)*(x5267)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r20)*(x5256))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r12)*(x5255)*(x5259)))+(((r02)*(sj5)*(x5257)))+(((x5266)*(x5267)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x5255)*(x5258)))+(((r00)*(x5257)*(x5258)))+(((IkReal(-1.00000000000000))*(r11)*(x5255)*(x5256)))+(((cj5)*(x5257)*(x5275)))+(((x5256)*(x5277)))+(((IkReal(-1.00000000000000))*(r00)*(x5264)*(x5267)))+(((IkReal(-1.00000000000000))*(x5255)*(x5274)*(x5276))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r11)*(x5256)*(x5264)))+(((IkReal(-1.00000000000000))*(r10)*(x5257)*(x5258)))+(((IkReal(-1.00000000000000))*(x5257)*(x5260)))+(((IkReal(-1.00000000000000))*(r02)*(x5255)*(x5259)))+(((IkReal(-1.00000000000000))*(x5257)*(x5265)*(x5276)))+(((x5267)*(x5271)))+(((IkReal(-1.00000000000000))*(x5255)*(x5274)*(x5275)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x5255)*(x5258)))+(((IkReal(-1.00000000000000))*(r01)*(x5255)*(x5256)))+(((x5267)*(x5278))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((cj0)*(r12)*(x5261)))+(((IkReal(-0.0100000000000000))*(x5258)*(x5268)))+(((IkReal(-1.00000000000000))*(x5266)*(x5280)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5276)))+(((x5268)*(x5280)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x5275)))+(((sj0)*(x5270)*(x5275)))+(((IkReal(0.0100000000000000))*(x5258)*(x5266)))+(((IkReal(-1.00000000000000))*(py)*(x5255)))+(((IkReal(-1.00000000000000))*(cj0)*(x5270)*(x5276)))+(((IkReal(-1.00000000000000))*(x5262)*(x5272)))+(((IkReal(0.0100000000000000))*(cj0)*(x5260)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(x5261)*(x5262))));
evalcond[8]=((IkReal(0.433420000000000))+(((r12)*(sj0)*(x5261)))+(((IkReal(0.0100000000000000))*(x5258)*(x5278)))+(((IkReal(-1.00000000000000))*(sj0)*(x5270)*(x5276)))+(((IkReal(-1.00000000000000))*(py)*(x5264)))+(((IkReal(-1.00000000000000))*(px)*(x5255)))+(((x5272)*(x5273)))+(((IkReal(-1.00000000000000))*(x5271)*(x5280)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x5276)))+(((x5261)*(x5273)))+(((IkReal(-1.00000000000000))*(x5278)*(x5280)))+(((IkReal(-1.00000000000000))*(cj0)*(x5270)*(x5275)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5275)))+(((IkReal(0.0100000000000000))*(sj0)*(x5260)))+(((IkReal(0.0100000000000000))*(x5258)*(x5271))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5282=((cj5)*(r02));
IkReal x5283=((cj0)*(sj5));
IkReal x5284=((r10)*(sj6));
IkReal x5285=((IkReal(1.00000000000000))*(cj6));
IkReal x5286=((sj0)*(sj5));
IkReal x5287=((cj5)*(r12));
IkReal x5288=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(x5286)*(x5288)))+(((IkReal(-1.00000000000000))*(cj0)*(x5287)))+(((sj0)*(x5282)))+(((IkReal(-1.00000000000000))*(r01)*(x5285)*(x5286)))+(((cj6)*(r11)*(x5283)))+(((x5283)*(x5284))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x5283)*(x5288)))+(((sj0)*(x5287)))+(((IkReal(-1.00000000000000))*(r11)*(x5285)*(x5286)))+(((IkReal(-1.00000000000000))*(r01)*(x5283)*(x5285)))+(((cj0)*(x5282)))+(((IkReal(-1.00000000000000))*(x5284)*(x5286))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x5286)*(x5288)))+(((IkReal(-1.00000000000000))*(cj0)*(x5287)))+(((sj0)*(x5282)))+(((IkReal(-1.00000000000000))*(r01)*(x5285)*(x5286)))+(((cj6)*(r11)*(x5283)))+(((x5283)*(x5284)))))+IKsqr(((((IkReal(-1.00000000000000))*(x5283)*(x5288)))+(((sj0)*(x5287)))+(((IkReal(-1.00000000000000))*(r11)*(x5285)*(x5286)))+(((IkReal(-1.00000000000000))*(r01)*(x5283)*(x5285)))+(((cj0)*(x5282)))+(((IkReal(-1.00000000000000))*(x5284)*(x5286)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x5286)*(x5288)))+(((IkReal(-1.00000000000000))*(cj0)*(x5287)))+(((sj0)*(x5282)))+(((IkReal(-1.00000000000000))*(r01)*(x5285)*(x5286)))+(((cj6)*(r11)*(x5283)))+(((x5283)*(x5284)))), ((((IkReal(-1.00000000000000))*(x5283)*(x5288)))+(((sj0)*(x5287)))+(((IkReal(-1.00000000000000))*(r11)*(x5285)*(x5286)))+(((IkReal(-1.00000000000000))*(r01)*(x5283)*(x5285)))+(((cj0)*(x5282)))+(((IkReal(-1.00000000000000))*(x5284)*(x5286)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5289=IKsin(j3);
IkReal x5290=((sj0)*(sj5));
IkReal x5291=((r00)*(sj6));
IkReal x5292=((IkReal(1.00000000000000))*(cj4));
IkReal x5293=((cj6)*(sj0));
IkReal x5294=((r00)*(sj4));
IkReal x5295=((cj0)*(cj5));
IkReal x5296=((cj6)*(r01));
IkReal x5297=((cj5)*(sj0));
IkReal x5298=((cj0)*(sj5));
IkReal x5299=((cj6)*(r11));
IkReal x5300=((r10)*(sj6));
IkReal x5301=((r10)*(sj4));
IkReal x5302=((IkReal(1.00000000000000))*(IKcos(j3)));
IkReal x5303=((cj0)*(sj4)*(sj6));
IkReal x5304=((sj0)*(sj4)*(sj6));
IkReal x5305=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((x5289)+(((r12)*(x5295)))+(((x5290)*(x5296)))+(((IkReal(-1.00000000000000))*(r02)*(x5297)))+(((IkReal(-1.00000000000000))*(x5298)*(x5299)))+(((IkReal(-1.00000000000000))*(x5298)*(x5300)))+(((x5290)*(x5291))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x5296)*(x5298)))+(((r12)*(x5297)))+(((IkReal(-1.00000000000000))*(x5290)*(x5300)))+(((IkReal(-1.00000000000000))*(x5290)*(x5299)))+(((IkReal(-1.00000000000000))*(x5302)))+(((IkReal(-1.00000000000000))*(x5291)*(x5298)))+(((r02)*(x5295))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r12)*(x5292)*(x5298)))+(((cj4)*(cj5)*(r01)*(x5293)))+(((IkReal(-1.00000000000000))*(x5301)*(x5305)))+(((cj4)*(r02)*(x5290)))+(((cj4)*(x5291)*(x5297)))+(((x5293)*(x5294)))+(((IkReal(-1.00000000000000))*(x5302)))+(((r11)*(x5303)))+(((IkReal(-1.00000000000000))*(x5292)*(x5295)*(x5300)))+(((IkReal(-1.00000000000000))*(r01)*(x5304)))+(((IkReal(-1.00000000000000))*(x5292)*(x5295)*(x5299))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x5292)*(x5297)*(x5300)))+(((IkReal(-1.00000000000000))*(x5291)*(x5292)*(x5295)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x5292)*(x5293)))+(((r11)*(x5304)))+(((r01)*(x5303)))+(((IkReal(-1.00000000000000))*(x5294)*(x5305)))+(((IkReal(-1.00000000000000))*(x5293)*(x5301)))+(((IkReal(-1.00000000000000))*(r12)*(x5290)*(x5292)))+(((IkReal(-1.00000000000000))*(x5289)))+(((IkReal(-1.00000000000000))*(x5292)*(x5295)*(x5296)))+(((IkReal(-1.00000000000000))*(r02)*(x5292)*(x5298))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x5306=((IkReal(1.00000000000000))*(cj0));
IkReal x5307=((cj4)*(sj6));
IkReal x5308=((sj0)*(sj4));
IkReal x5309=((cj5)*(sj6));
IkReal x5310=((sj4)*(sj5));
IkReal x5311=((r12)*(sj5));
IkReal x5312=((IkReal(0.374290000000000))*(cj5));
IkReal x5313=((r02)*(sj0));
IkReal x5314=((r20)*(sj4));
IkReal x5315=((IkReal(1.00000000000000))*(sj0));
IkReal x5316=((IkReal(1.00000000000000))*(cj5));
IkReal x5317=((cj0)*(r10));
IkReal x5318=((cj4)*(cj6));
IkReal x5319=((r00)*(sj0));
IkReal x5320=((cj6)*(r21));
IkReal x5321=((IkReal(0.374290000000000))*(sj5));
IkReal x5322=((cj0)*(r00));
IkReal x5323=((IkReal(0.0100000000000000))*(sj5));
IkReal x5324=((cj0)*(r02));
IkReal x5325=((cj5)*(sj4));
IkReal x5326=((cj6)*(r01));
IkReal x5327=((cj6)*(r11));
IkReal x5328=((r01)*(sj0));
IkReal x5329=((r10)*(sj0));
IkReal x5330=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x5331=((sj6)*(x5321));
IkReal x5332=((cj0)*(cj6)*(x5321));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j1, IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x5316)))+(((sj5)*(x5320)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r20)*(x5318)))+(((r21)*(x5307)))+(((x5320)*(x5325)))+(((r22)*(x5310)))+(((x5309)*(x5314))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x5323)))+(((IkReal(-1.00000000000000))*(r22)*(x5312)))+(((IkReal(-0.0100000000000000))*(r20)*(x5309)))+(((IkReal(-0.0100000000000000))*(cj5)*(x5320)))+(((x5320)*(x5321)))+(pz)+(((r20)*(x5331))));
evalcond[4]=((((cj5)*(r20)*(x5307)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(x5314)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r21)*(x5318))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r12)*(x5306)*(x5310)))+(((IkReal(-1.00000000000000))*(r11)*(x5306)*(x5307)))+(((r02)*(sj5)*(x5308)))+(((IkReal(-1.00000000000000))*(r00)*(x5315)*(x5318)))+(((x5307)*(x5328)))+(((r00)*(x5308)*(x5309)))+(((IkReal(-1.00000000000000))*(x5306)*(x5325)*(x5327)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x5306)*(x5309)))+(((x5317)*(x5318)))+(((cj5)*(x5308)*(x5326))));
evalcond[6]=((((x5318)*(x5322)))+(((IkReal(-1.00000000000000))*(x5308)*(x5311)))+(((IkReal(-1.00000000000000))*(x5308)*(x5316)*(x5327)))+(((IkReal(-1.00000000000000))*(r10)*(x5308)*(x5309)))+(((IkReal(-1.00000000000000))*(r02)*(x5306)*(x5310)))+(((IkReal(-1.00000000000000))*(x5306)*(x5325)*(x5326)))+(((IkReal(-1.00000000000000))*(r11)*(x5307)*(x5315)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x5306)*(x5309)))+(((IkReal(-1.00000000000000))*(r01)*(x5306)*(x5307)))+(((x5318)*(x5329))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((sj0)*(x5321)*(x5326)))+(((x5319)*(x5331)))+(((cj0)*(r12)*(x5312)))+(((IkReal(-1.00000000000000))*(x5312)*(x5313)))+(((IkReal(0.0100000000000000))*(x5309)*(x5317)))+(((IkReal(-1.00000000000000))*(x5313)*(x5323)))+(((IkReal(-0.0100000000000000))*(x5309)*(x5319)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5327)))+(((IkReal(-1.00000000000000))*(py)*(x5306)))+(((IkReal(0.0100000000000000))*(cj0)*(x5311)))+(((IkReal(-1.00000000000000))*(x5317)*(x5331)))+(((px)*(sj0)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x5326)))+(((IkReal(-1.00000000000000))*(cj0)*(x5321)*(x5327))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(0.0100000000000000))*(x5309)*(x5322)))+(((IkReal(-1.00000000000000))*(cj0)*(x5321)*(x5326)))+(((x5312)*(x5324)))+(((IkReal(-1.00000000000000))*(py)*(x5315)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x5327)))+(((IkReal(-1.00000000000000))*(sj0)*(x5321)*(x5327)))+(((IkReal(-1.00000000000000))*(x5329)*(x5331)))+(((x5323)*(x5324)))+(((IkReal(-1.00000000000000))*(x5322)*(x5331)))+(((IkReal(0.0100000000000000))*(sj0)*(x5311)))+(((IkReal(-1.00000000000000))*(px)*(x5306)))+(((r12)*(sj0)*(x5312)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5326)))+(((IkReal(0.0100000000000000))*(x5309)*(x5329))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5333=((IkReal(1.00000000000000))*(cj5));
IkReal x5334=((r10)*(sj5)*(sj6));
IkReal x5335=((cj6)*(sj0)*(sj5));
IkReal x5336=((r00)*(sj5)*(sj6));
IkReal x5337=((cj0)*(cj6)*(sj5));
if( IKabs(((((cj0)*(x5334)))+(((IkReal(-1.00000000000000))*(sj0)*(x5336)))+(((IkReal(-1.00000000000000))*(r01)*(x5335)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5333)))+(((r11)*(x5337))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj0)*(x5334)))+(((cj0)*(x5336)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x5333)))+(((r01)*(x5337)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x5333)))+(((r11)*(x5335))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj0)*(x5334)))+(((IkReal(-1.00000000000000))*(sj0)*(x5336)))+(((IkReal(-1.00000000000000))*(r01)*(x5335)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5333)))+(((r11)*(x5337)))))+IKsqr(((((sj0)*(x5334)))+(((cj0)*(x5336)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x5333)))+(((r01)*(x5337)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x5333)))+(((r11)*(x5335)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj0)*(x5334)))+(((IkReal(-1.00000000000000))*(sj0)*(x5336)))+(((IkReal(-1.00000000000000))*(r01)*(x5335)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5333)))+(((r11)*(x5337)))), ((((sj0)*(x5334)))+(((cj0)*(x5336)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x5333)))+(((r01)*(x5337)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x5333)))+(((r11)*(x5335)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5338=IKcos(j3);
IkReal x5339=IKsin(j3);
IkReal x5340=((sj0)*(sj5));
IkReal x5341=((r00)*(sj6));
IkReal x5342=((IkReal(1.00000000000000))*(cj4));
IkReal x5343=((cj6)*(sj0));
IkReal x5344=((r00)*(sj4));
IkReal x5345=((cj0)*(cj5));
IkReal x5346=((cj6)*(r01));
IkReal x5347=((cj5)*(sj0));
IkReal x5348=((cj0)*(sj5));
IkReal x5349=((cj6)*(r11));
IkReal x5350=((r10)*(sj6));
IkReal x5351=((r10)*(sj4));
IkReal x5352=((cj0)*(sj4)*(sj6));
IkReal x5353=((sj0)*(sj4)*(sj6));
IkReal x5354=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((((r12)*(x5345)))+(((IkReal(-1.00000000000000))*(x5348)*(x5350)))+(((IkReal(-1.00000000000000))*(x5348)*(x5349)))+(((IkReal(-1.00000000000000))*(r02)*(x5347)))+(((x5340)*(x5346)))+(((x5340)*(x5341)))+(x5339));
evalcond[1]=((((IkReal(-1.00000000000000))*(x5340)*(x5349)))+(((IkReal(-1.00000000000000))*(x5340)*(x5350)))+(((IkReal(-1.00000000000000))*(x5346)*(x5348)))+(((r02)*(x5345)))+(((IkReal(-1.00000000000000))*(x5341)*(x5348)))+(((r12)*(x5347)))+(x5338));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x5353)))+(((IkReal(-1.00000000000000))*(r12)*(x5342)*(x5348)))+(((IkReal(-1.00000000000000))*(x5342)*(x5345)*(x5350)))+(((cj4)*(x5341)*(x5347)))+(((IkReal(-1.00000000000000))*(x5342)*(x5345)*(x5349)))+(((cj4)*(cj5)*(r01)*(x5343)))+(((IkReal(-1.00000000000000))*(x5338)))+(((x5343)*(x5344)))+(((r11)*(x5352)))+(((IkReal(-1.00000000000000))*(x5351)*(x5354)))+(((cj4)*(r02)*(x5340))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r12)*(x5340)*(x5342)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x5342)*(x5343)))+(((IkReal(-1.00000000000000))*(x5343)*(x5351)))+(((IkReal(-1.00000000000000))*(x5341)*(x5342)*(x5345)))+(((IkReal(-1.00000000000000))*(x5342)*(x5345)*(x5346)))+(((IkReal(-1.00000000000000))*(x5344)*(x5354)))+(((IkReal(-1.00000000000000))*(r02)*(x5342)*(x5348)))+(((r11)*(x5353)))+(((r01)*(x5352)))+(((IkReal(-1.00000000000000))*(x5342)*(x5347)*(x5350)))+(x5339));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5355=((cj5)*(r02));
IkReal x5356=((cj0)*(sj5));
IkReal x5357=((r10)*(sj6));
IkReal x5358=((IkReal(1.00000000000000))*(cj6));
IkReal x5359=((sj0)*(sj5));
IkReal x5360=((cj5)*(r12));
IkReal x5361=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((x5356)*(x5357)))+(((cj6)*(r11)*(x5356)))+(((IkReal(-1.00000000000000))*(r01)*(x5358)*(x5359)))+(((sj0)*(x5355)))+(((IkReal(-1.00000000000000))*(x5359)*(x5361)))+(((IkReal(-1.00000000000000))*(cj0)*(x5360))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x5357)*(x5359)))+(((sj0)*(x5360)))+(((IkReal(-1.00000000000000))*(r01)*(x5356)*(x5358)))+(((IkReal(-1.00000000000000))*(r11)*(x5358)*(x5359)))+(((IkReal(-1.00000000000000))*(x5356)*(x5361)))+(((cj0)*(x5355))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((x5356)*(x5357)))+(((cj6)*(r11)*(x5356)))+(((IkReal(-1.00000000000000))*(r01)*(x5358)*(x5359)))+(((sj0)*(x5355)))+(((IkReal(-1.00000000000000))*(x5359)*(x5361)))+(((IkReal(-1.00000000000000))*(cj0)*(x5360)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x5357)*(x5359)))+(((sj0)*(x5360)))+(((IkReal(-1.00000000000000))*(r01)*(x5356)*(x5358)))+(((IkReal(-1.00000000000000))*(r11)*(x5358)*(x5359)))+(((IkReal(-1.00000000000000))*(x5356)*(x5361)))+(((cj0)*(x5355)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((x5356)*(x5357)))+(((cj6)*(r11)*(x5356)))+(((IkReal(-1.00000000000000))*(r01)*(x5358)*(x5359)))+(((sj0)*(x5355)))+(((IkReal(-1.00000000000000))*(x5359)*(x5361)))+(((IkReal(-1.00000000000000))*(cj0)*(x5360)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x5357)*(x5359)))+(((sj0)*(x5360)))+(((IkReal(-1.00000000000000))*(r01)*(x5356)*(x5358)))+(((IkReal(-1.00000000000000))*(r11)*(x5358)*(x5359)))+(((IkReal(-1.00000000000000))*(x5356)*(x5361)))+(((cj0)*(x5355)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x5362=IKsin(j3);
IkReal x5363=IKcos(j3);
IkReal x5364=((sj0)*(sj5));
IkReal x5365=((r00)*(sj6));
IkReal x5366=((IkReal(1.00000000000000))*(cj4));
IkReal x5367=((cj6)*(r01));
IkReal x5368=((cj0)*(cj5));
IkReal x5369=((cj5)*(sj0));
IkReal x5370=((cj6)*(r11));
IkReal x5371=((cj0)*(sj5));
IkReal x5372=((IkReal(1.00000000000000))*(cj1));
IkReal x5373=((cj6)*(sj4));
IkReal x5374=((IkReal(1.00000000000000))*(sj1));
IkReal x5375=((cj4)*(cj5));
IkReal x5376=((cj6)*(r21));
IkReal x5377=((r20)*(sj6));
IkReal x5378=((r10)*(sj6));
IkReal x5379=((IkReal(1.00000000000000))*(cj0));
IkReal x5380=((cj0)*(sj4)*(sj6));
IkReal x5381=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x5377)))+(((sj5)*(x5376)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x5363)*(x5374))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x5362)*(x5374)))+(((cj4)*(r22)*(sj5)))+(((x5375)*(x5376)))+(((r20)*(x5373)))+(((x5375)*(x5377))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x5371)*(x5378)))+(((x5364)*(x5367)))+(((r12)*(x5368)))+(((IkReal(-1.00000000000000))*(x5370)*(x5371)))+(((IkReal(-1.00000000000000))*(r02)*(x5369)))+(x5362)+(((x5364)*(x5365))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x5363)*(x5372)))+(((r12)*(x5369)))+(((IkReal(-1.00000000000000))*(x5365)*(x5371)))+(((IkReal(-1.00000000000000))*(x5364)*(x5378)))+(((r02)*(x5368)))+(((IkReal(-1.00000000000000))*(x5367)*(x5371)))+(((IkReal(-1.00000000000000))*(x5364)*(x5370))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r12)*(x5366)*(x5371)))+(((cj4)*(x5367)*(x5369)))+(((r00)*(sj0)*(x5373)))+(((IkReal(-1.00000000000000))*(r01)*(x5381)))+(((IkReal(-1.00000000000000))*(r10)*(x5373)*(x5379)))+(((IkReal(-1.00000000000000))*(x5363)))+(((r11)*(x5380)))+(((cj4)*(x5365)*(x5369)))+(((IkReal(-1.00000000000000))*(x5366)*(x5368)*(x5370)))+(((cj4)*(r02)*(x5364)))+(((IkReal(-1.00000000000000))*(x5366)*(x5368)*(x5378))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x5362)*(x5372)))+(((IkReal(-1.00000000000000))*(r02)*(x5366)*(x5371)))+(((IkReal(-1.00000000000000))*(x5366)*(x5367)*(x5368)))+(((IkReal(-1.00000000000000))*(x5366)*(x5369)*(x5378)))+(((r01)*(x5380)))+(((r11)*(x5381)))+(((IkReal(-1.00000000000000))*(x5365)*(x5366)*(x5368)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x5373)))+(((IkReal(-1.00000000000000))*(r12)*(x5364)*(x5366)))+(((IkReal(-1.00000000000000))*(x5366)*(x5369)*(x5370)))+(((IkReal(-1.00000000000000))*(r00)*(x5373)*(x5379))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5382=((sj5)*(sj6));
IkReal x5383=((IkReal(1.00000000000000))*(sj0));
IkReal x5384=((cj6)*(sj5));
IkReal x5385=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((((cj0)*(r10)*(x5382)))+(((cj0)*(r11)*(x5384)))+(((IkReal(-1.00000000000000))*(r01)*(x5383)*(x5384)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r00)*(x5382)*(x5383)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5385))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r22)*(x5385)))+(((r21)*(x5384)))+(((r20)*(x5382))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj0)*(r10)*(x5382)))+(((cj0)*(r11)*(x5384)))+(((IkReal(-1.00000000000000))*(r01)*(x5383)*(x5384)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r00)*(x5382)*(x5383)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5385)))))+IKsqr(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r22)*(x5385)))+(((r21)*(x5384)))+(((r20)*(x5382)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj0)*(r10)*(x5382)))+(((cj0)*(r11)*(x5384)))+(((IkReal(-1.00000000000000))*(r01)*(x5383)*(x5384)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r00)*(x5382)*(x5383)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5385)))), ((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r22)*(x5385)))+(((r21)*(x5384)))+(((r20)*(x5382)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x5386=IKsin(j3);
IkReal x5387=IKcos(j3);
IkReal x5388=((sj0)*(sj5));
IkReal x5389=((r00)*(sj6));
IkReal x5390=((IkReal(1.00000000000000))*(cj4));
IkReal x5391=((cj6)*(r01));
IkReal x5392=((cj0)*(cj5));
IkReal x5393=((cj5)*(sj0));
IkReal x5394=((cj6)*(r11));
IkReal x5395=((cj0)*(sj5));
IkReal x5396=((IkReal(1.00000000000000))*(cj1));
IkReal x5397=((cj6)*(sj4));
IkReal x5398=((IkReal(1.00000000000000))*(sj1));
IkReal x5399=((cj4)*(cj5));
IkReal x5400=((cj6)*(r21));
IkReal x5401=((r20)*(sj6));
IkReal x5402=((r10)*(sj6));
IkReal x5403=((IkReal(1.00000000000000))*(cj0));
IkReal x5404=((cj0)*(sj4)*(sj6));
IkReal x5405=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(x5387)*(x5398)))+(((sj5)*(x5400)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5401))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((x5399)*(x5400)))+(((IkReal(-1.00000000000000))*(x5386)*(x5398)))+(((x5399)*(x5401)))+(((r20)*(x5397))));
evalcond[2]=((((r12)*(x5392)))+(((IkReal(-1.00000000000000))*(r02)*(x5393)))+(((IkReal(-1.00000000000000))*(x5395)*(x5402)))+(((x5388)*(x5391)))+(((x5388)*(x5389)))+(x5386)+(((IkReal(-1.00000000000000))*(x5394)*(x5395))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x5388)*(x5402)))+(((IkReal(-1.00000000000000))*(x5391)*(x5395)))+(((IkReal(-1.00000000000000))*(x5388)*(x5394)))+(((IkReal(-1.00000000000000))*(x5389)*(x5395)))+(((IkReal(-1.00000000000000))*(x5387)*(x5396)))+(((r02)*(x5392)))+(((r12)*(x5393))));
evalcond[4]=((((cj4)*(x5391)*(x5393)))+(((IkReal(-1.00000000000000))*(x5390)*(x5392)*(x5402)))+(((IkReal(-1.00000000000000))*(x5387)))+(((r11)*(x5404)))+(((IkReal(-1.00000000000000))*(r10)*(x5397)*(x5403)))+(((r00)*(sj0)*(x5397)))+(((IkReal(-1.00000000000000))*(r12)*(x5390)*(x5395)))+(((IkReal(-1.00000000000000))*(x5390)*(x5392)*(x5394)))+(((cj4)*(x5389)*(x5393)))+(((IkReal(-1.00000000000000))*(r01)*(x5405)))+(((cj4)*(r02)*(x5388))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x5386)*(x5396)))+(((IkReal(-1.00000000000000))*(r12)*(x5388)*(x5390)))+(((r11)*(x5405)))+(((IkReal(-1.00000000000000))*(x5390)*(x5393)*(x5402)))+(((IkReal(-1.00000000000000))*(x5390)*(x5393)*(x5394)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x5397)))+(((IkReal(-1.00000000000000))*(r02)*(x5390)*(x5395)))+(((IkReal(-1.00000000000000))*(r00)*(x5397)*(x5403)))+(((r01)*(x5404)))+(((IkReal(-1.00000000000000))*(x5389)*(x5390)*(x5392)))+(((IkReal(-1.00000000000000))*(x5390)*(x5391)*(x5392))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5406=((r20)*(sj6));
IkReal x5407=((cj4)*(cj5));
IkReal x5408=((cj6)*(r21));
if( IKabs(((gconst30)*(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5406)*(x5407)))+(((x5407)*(x5408))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst30)*(((((sj5)*(x5408)))+(((sj5)*(x5406)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst30)*(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5406)*(x5407)))+(((x5407)*(x5408)))))), ((gconst30)*(((((sj5)*(x5408)))+(((sj5)*(x5406)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x5409=IKsin(j3);
IkReal x5410=IKcos(j3);
IkReal x5411=((sj0)*(sj5));
IkReal x5412=((r00)*(sj6));
IkReal x5413=((IkReal(1.00000000000000))*(cj4));
IkReal x5414=((cj6)*(r01));
IkReal x5415=((cj0)*(cj5));
IkReal x5416=((cj5)*(sj0));
IkReal x5417=((cj6)*(r11));
IkReal x5418=((cj0)*(sj5));
IkReal x5419=((IkReal(1.00000000000000))*(cj1));
IkReal x5420=((cj6)*(sj4));
IkReal x5421=((IkReal(1.00000000000000))*(sj1));
IkReal x5422=((cj4)*(cj5));
IkReal x5423=((cj6)*(r21));
IkReal x5424=((r20)*(sj6));
IkReal x5425=((r10)*(sj6));
IkReal x5426=((IkReal(1.00000000000000))*(cj0));
IkReal x5427=((cj0)*(sj4)*(sj6));
IkReal x5428=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x5424)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x5410)*(x5421)))+(((sj5)*(x5423))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x5422)*(x5424)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x5420)))+(((x5422)*(x5423)))+(((IkReal(-1.00000000000000))*(x5409)*(x5421))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x5418)*(x5425)))+(((r12)*(x5415)))+(((x5411)*(x5412)))+(((x5411)*(x5414)))+(((IkReal(-1.00000000000000))*(r02)*(x5416)))+(((IkReal(-1.00000000000000))*(x5417)*(x5418)))+(x5409));
evalcond[3]=((((IkReal(-1.00000000000000))*(x5411)*(x5417)))+(((r02)*(x5415)))+(((IkReal(-1.00000000000000))*(x5414)*(x5418)))+(((IkReal(-1.00000000000000))*(x5412)*(x5418)))+(((IkReal(-1.00000000000000))*(x5410)*(x5419)))+(((r12)*(x5416)))+(((IkReal(-1.00000000000000))*(x5411)*(x5425))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x5413)*(x5415)*(x5425)))+(((cj4)*(x5414)*(x5416)))+(((IkReal(-1.00000000000000))*(r01)*(x5428)))+(((cj4)*(x5412)*(x5416)))+(((IkReal(-1.00000000000000))*(r12)*(x5413)*(x5418)))+(((IkReal(-1.00000000000000))*(r10)*(x5420)*(x5426)))+(((cj4)*(r02)*(x5411)))+(((r11)*(x5427)))+(((IkReal(-1.00000000000000))*(x5413)*(x5415)*(x5417)))+(((IkReal(-1.00000000000000))*(x5410)))+(((r00)*(sj0)*(x5420))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x5409)*(x5419)))+(((r01)*(x5427)))+(((IkReal(-1.00000000000000))*(x5412)*(x5413)*(x5415)))+(((IkReal(-1.00000000000000))*(x5413)*(x5414)*(x5415)))+(((IkReal(-1.00000000000000))*(r00)*(x5420)*(x5426)))+(((r11)*(x5428)))+(((IkReal(-1.00000000000000))*(x5413)*(x5416)*(x5425)))+(((IkReal(-1.00000000000000))*(r12)*(x5411)*(x5413)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x5420)))+(((IkReal(-1.00000000000000))*(r02)*(x5413)*(x5418)))+(((IkReal(-1.00000000000000))*(x5413)*(x5416)*(x5417))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x5429=((cj1)*(sj6));
IkReal x5430=((r01)*(sj0));
IkReal x5431=((cj0)*(r11));
IkReal x5432=((cj1)*(cj6));
IkReal x5433=((cj0)*(r10));
IkReal x5434=((IkReal(1.00000000000000))*(sj0));
IkReal x5435=((cj1)*(sj5));
if( IKabs(((gconst26)*(((((IkReal(-1.00000000000000))*(r00)*(x5432)*(x5434)))+(((IkReal(-1.00000000000000))*(x5429)*(x5431)))+(((x5432)*(x5433)))+(((x5429)*(x5430))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst26)*(((((cj5)*(x5431)*(x5432)))+(((IkReal(-1.00000000000000))*(r02)*(x5434)*(x5435)))+(((IkReal(-1.00000000000000))*(cj5)*(x5430)*(x5432)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5429)*(x5434)))+(((cj0)*(r12)*(x5435)))+(((cj5)*(x5429)*(x5433))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst26)*(((((IkReal(-1.00000000000000))*(r00)*(x5432)*(x5434)))+(((IkReal(-1.00000000000000))*(x5429)*(x5431)))+(((x5432)*(x5433)))+(((x5429)*(x5430)))))), ((gconst26)*(((((cj5)*(x5431)*(x5432)))+(((IkReal(-1.00000000000000))*(r02)*(x5434)*(x5435)))+(((IkReal(-1.00000000000000))*(cj5)*(x5430)*(x5432)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5429)*(x5434)))+(((cj0)*(r12)*(x5435)))+(((cj5)*(x5429)*(x5433)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x5436=IKsin(j4);
IkReal x5437=IKcos(j4);
IkReal x5438=((r00)*(sj6));
IkReal x5439=((cj6)*(r01));
IkReal x5440=((IkReal(1.00000000000000))*(cj0));
IkReal x5441=((IkReal(1.00000000000000))*(sj0));
IkReal x5442=((r10)*(sj6));
IkReal x5443=((sj5)*(x5436));
IkReal x5444=((IkReal(1.00000000000000))*(cj6)*(r11));
IkReal x5445=((cj5)*(x5436));
IkReal x5446=((cj6)*(x5437));
IkReal x5447=((sj0)*(x5445));
IkReal x5448=((r01)*(sj6)*(x5437));
IkReal x5449=((r11)*(sj6)*(x5437));
evalcond[0]=((((r20)*(sj6)*(x5445)))+(((r22)*(x5443)))+(((r21)*(sj6)*(x5437)))+(cj1)+(((cj6)*(r21)*(x5445)))+(((IkReal(-1.00000000000000))*(r20)*(x5446))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x5440)*(x5442)*(x5445)))+(((x5439)*(x5447)))+(((r02)*(sj0)*(x5443)))+(((IkReal(-1.00000000000000))*(r12)*(x5440)*(x5443)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x5440)*(x5445)))+(((cj0)*(r10)*(x5446)))+(((x5438)*(x5447)))+(((IkReal(-1.00000000000000))*(x5440)*(x5449)))+(((IkReal(-1.00000000000000))*(r00)*(x5441)*(x5446)))+(((sj0)*(x5448))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x5438)*(x5440)*(x5445)))+(((IkReal(-1.00000000000000))*(x5441)*(x5449)))+(((IkReal(-1.00000000000000))*(x5439)*(x5440)*(x5445)))+(((IkReal(-1.00000000000000))*(r12)*(x5441)*(x5443)))+(((IkReal(-1.00000000000000))*(r02)*(x5440)*(x5443)))+(((IkReal(-1.00000000000000))*(sj1)))+(((r10)*(sj0)*(x5446)))+(((IkReal(-1.00000000000000))*(x5441)*(x5442)*(x5445)))+(((IkReal(-1.00000000000000))*(x5440)*(x5448)))+(((cj0)*(r00)*(x5446)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x5441)*(x5445))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst30;
gconst30=IKsign(sj1);
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x5450=((IkReal(1.00000000000000))*(cj0));
IkReal x5451=((cj4)*(sj6));
IkReal x5452=((sj0)*(sj6));
IkReal x5453=((cj5)*(sj4));
IkReal x5454=((IkReal(0.374290000000000))*(sj5));
IkReal x5455=((sj4)*(sj5));
IkReal x5456=((cj0)*(cj6));
IkReal x5457=((IkReal(0.0100000000000000))*(cj5));
IkReal x5458=((cj4)*(sj5));
IkReal x5459=((cj5)*(sj0));
IkReal x5460=((IkReal(0.374290000000000))*(r02));
IkReal x5461=((r20)*(sj6));
IkReal x5462=((cj6)*(r21));
IkReal x5463=((IkReal(1.00000000000000))*(sj0));
IkReal x5464=((cj0)*(sj6));
IkReal x5465=((cj4)*(cj6));
IkReal x5466=((IkReal(0.374290000000000))*(r12));
IkReal x5467=((cj0)*(cj5));
IkReal x5468=((cj6)*(sj5));
IkReal x5469=((cj6)*(r01));
IkReal x5470=((r00)*(sj6));
IkReal x5471=((IkReal(0.0100000000000000))*(sj5));
IkReal x5472=((cj6)*(r11));
IkReal x5473=((IkReal(1.00000000000000))*(r10));
IkReal x5474=((r02)*(sj0));
IkReal x5475=((cj6)*(sj4));
IkReal x5476=((r12)*(x5463));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x5465)))+(((x5453)*(x5461)))+(((r22)*(x5455)))+(((x5453)*(x5462)))+(((r21)*(x5451))));
evalcond[2]=((IkReal(0.364420000000000))+(((x5454)*(x5461)))+(((IkReal(-1.00000000000000))*(x5457)*(x5461)))+(((IkReal(-1.00000000000000))*(x5457)*(x5462)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r22)*(x5471)))+(pz)+(((x5454)*(x5462))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x5463)*(x5468)))+(((r02)*(x5467)))+(((IkReal(-1.00000000000000))*(r01)*(x5450)*(x5468)))+(((IkReal(-1.00000000000000))*(sj5)*(x5450)*(x5470)))+(((r12)*(x5459)))+(((IkReal(-1.00000000000000))*(sj5)*(x5452)*(x5473))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r12)*(x5450)*(x5455)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x5450)*(x5453)))+(((IkReal(-1.00000000000000))*(x5450)*(x5453)*(x5472)))+(((IkReal(-1.00000000000000))*(r11)*(x5450)*(x5451)))+(((sj0)*(x5453)*(x5469)))+(((x5455)*(x5474)))+(((r01)*(sj0)*(x5451)))+(((IkReal(-1.00000000000000))*(r00)*(x5463)*(x5465)))+(((cj4)*(r10)*(x5456)))+(((r00)*(x5452)*(x5453))));
evalcond[5]=((IkReal(-1.00000000000000))+(((r10)*(sj0)*(x5465)))+(((IkReal(-1.00000000000000))*(r01)*(x5450)*(x5451)))+(((cj4)*(r00)*(x5456)))+(((IkReal(-1.00000000000000))*(x5452)*(x5453)*(x5473)))+(((IkReal(-1.00000000000000))*(x5450)*(x5453)*(x5470)))+(((IkReal(-1.00000000000000))*(r02)*(x5450)*(x5455)))+(((IkReal(-1.00000000000000))*(x5450)*(x5453)*(x5469)))+(((IkReal(-1.00000000000000))*(r11)*(x5451)*(x5463)))+(((IkReal(-1.00000000000000))*(x5453)*(x5463)*(x5472)))+(((IkReal(-1.00000000000000))*(x5455)*(x5476))));
evalcond[6]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(r11)*(x5454)*(x5456)))+(((cj0)*(r12)*(x5471)))+(((r10)*(x5457)*(x5464)))+(((IkReal(-1.00000000000000))*(x5459)*(x5460)))+(((IkReal(-1.00000000000000))*(py)*(x5450)))+(((IkReal(-1.00000000000000))*(sj0)*(x5457)*(x5469)))+(((IkReal(-1.00000000000000))*(x5471)*(x5474)))+(((IkReal(-1.00000000000000))*(r00)*(x5452)*(x5457)))+(((r11)*(x5456)*(x5457)))+(((r00)*(x5452)*(x5454)))+(((px)*(sj0)))+(((x5466)*(x5467)))+(((sj0)*(x5454)*(x5469)))+(((IkReal(-1.00000000000000))*(r10)*(x5454)*(x5464))));
evalcond[7]=((((IkReal(-1.00000000000000))*(r00)*(x5450)*(x5475)))+(((IkReal(-1.00000000000000))*(x5451)*(x5459)*(x5473)))+(((IkReal(-1.00000000000000))*(x5458)*(x5476)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5450)*(x5451)))+(((IkReal(-1.00000000000000))*(r11)*(x5459)*(x5465)))+(((r11)*(sj4)*(x5452)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x5450)*(x5465)))+(((IkReal(-1.00000000000000))*(r02)*(x5450)*(x5458)))+(((r01)*(sj4)*(x5464)))+(((IkReal(-1.00000000000000))*(r10)*(x5463)*(x5475))));
evalcond[8]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x5452)*(x5454)))+(((cj0)*(r02)*(x5471)))+(((r01)*(x5456)*(x5457)))+(((x5460)*(x5467)))+(((r12)*(sj0)*(x5471)))+(((IkReal(-1.00000000000000))*(px)*(x5450)))+(((IkReal(-1.00000000000000))*(r01)*(x5454)*(x5456)))+(((x5459)*(x5466)))+(((IkReal(-1.00000000000000))*(py)*(x5463)))+(((r00)*(x5457)*(x5464)))+(((r10)*(x5452)*(x5457)))+(((IkReal(-1.00000000000000))*(sj0)*(x5454)*(x5472)))+(((IkReal(-1.00000000000000))*(r00)*(x5454)*(x5464)))+(((sj0)*(x5457)*(x5472))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5477=((r20)*(sj6));
IkReal x5478=((cj4)*(cj5));
IkReal x5479=((cj6)*(r21));
if( IKabs(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5477)*(x5478)))+(((x5478)*(x5479))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5477)))+(((sj5)*(x5479))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5477)*(x5478)))+(((x5478)*(x5479)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5477)))+(((sj5)*(x5479)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5477)*(x5478)))+(((x5478)*(x5479)))), ((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5477)))+(((sj5)*(x5479)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5480=IKsin(j3);
IkReal x5481=((sj0)*(sj5));
IkReal x5482=((r00)*(sj6));
IkReal x5483=((cj6)*(r01));
IkReal x5484=((cj5)*(sj0));
IkReal x5485=((cj0)*(cj5));
IkReal x5486=((cj6)*(sj4));
IkReal x5487=((sj4)*(sj6));
IkReal x5488=((cj0)*(r11));
IkReal x5489=((cj4)*(cj6));
IkReal x5490=((cj4)*(sj6));
IkReal x5491=((IkReal(1.00000000000000))*(cj0));
IkReal x5492=((cj4)*(sj5));
IkReal x5493=((sj5)*(sj6));
IkReal x5494=((cj6)*(sj5));
IkReal x5495=((IkReal(1.00000000000000))*(IKcos(j3)));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r21)*(x5494)))+(((r20)*(x5493)))+(((IkReal(-1.00000000000000))*(x5495))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(x5487)))+(((cj5)*(r20)*(x5490)))+(((IkReal(-1.00000000000000))*(x5480)))+(((r20)*(x5486)))+(((cj5)*(r21)*(x5489)))+(((r22)*(x5492))));
evalcond[2]=((x5480)+(((IkReal(-1.00000000000000))*(r10)*(x5491)*(x5493)))+(((r12)*(x5485)))+(((IkReal(-1.00000000000000))*(r02)*(x5484)))+(((x5481)*(x5482)))+(((IkReal(-1.00000000000000))*(x5488)*(x5494)))+(((x5481)*(x5483))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x5485)*(x5489)))+(((cj4)*(x5482)*(x5484)))+(((IkReal(-1.00000000000000))*(r12)*(x5491)*(x5492)))+(((IkReal(-1.00000000000000))*(r10)*(x5485)*(x5490)))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x5487)))+(((cj4)*(x5483)*(x5484)))+(((r00)*(sj0)*(x5486)))+(((cj4)*(r02)*(x5481)))+(((x5487)*(x5488)))+(((IkReal(-1.00000000000000))*(r10)*(x5486)*(x5491)))+(((IkReal(-1.00000000000000))*(x5495))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x5496=((IkReal(1.00000000000000))*(cj0));
IkReal x5497=((cj4)*(sj6));
IkReal x5498=((sj0)*(sj6));
IkReal x5499=((cj5)*(sj4));
IkReal x5500=((IkReal(0.374290000000000))*(sj5));
IkReal x5501=((sj4)*(sj5));
IkReal x5502=((cj0)*(cj6));
IkReal x5503=((IkReal(0.0100000000000000))*(cj5));
IkReal x5504=((cj4)*(sj5));
IkReal x5505=((cj5)*(sj0));
IkReal x5506=((IkReal(0.374290000000000))*(r02));
IkReal x5507=((r20)*(sj6));
IkReal x5508=((cj6)*(r21));
IkReal x5509=((IkReal(1.00000000000000))*(sj0));
IkReal x5510=((cj0)*(sj6));
IkReal x5511=((cj4)*(cj6));
IkReal x5512=((IkReal(0.374290000000000))*(r12));
IkReal x5513=((cj0)*(cj5));
IkReal x5514=((cj6)*(sj5));
IkReal x5515=((cj6)*(r01));
IkReal x5516=((r00)*(sj6));
IkReal x5517=((IkReal(0.0100000000000000))*(sj5));
IkReal x5518=((cj6)*(r11));
IkReal x5519=((IkReal(1.00000000000000))*(r10));
IkReal x5520=((r02)*(sj0));
IkReal x5521=((cj6)*(sj4));
IkReal x5522=((r12)*(x5509));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x5497)))+(((x5499)*(x5508)))+(((x5499)*(x5507)))+(((r22)*(x5501)))+(((IkReal(-1.00000000000000))*(r20)*(x5511))));
evalcond[2]=((IkReal(-0.364420000000000))+(((IkReal(-1.00000000000000))*(r22)*(x5517)))+(((x5500)*(x5508)))+(((x5500)*(x5507)))+(((IkReal(-1.00000000000000))*(x5503)*(x5508)))+(((IkReal(-0.374290000000000))*(cj5)*(r22)))+(pz)+(((IkReal(-1.00000000000000))*(x5503)*(x5507))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x5509)*(x5514)))+(((r12)*(x5505)))+(((IkReal(-1.00000000000000))*(sj5)*(x5496)*(x5516)))+(((IkReal(-1.00000000000000))*(r01)*(x5496)*(x5514)))+(((IkReal(-1.00000000000000))*(sj5)*(x5498)*(x5519)))+(((r02)*(x5513))));
evalcond[4]=((((r00)*(x5498)*(x5499)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x5496)*(x5499)))+(((cj4)*(r10)*(x5502)))+(((sj0)*(x5499)*(x5515)))+(((r01)*(sj0)*(x5497)))+(((IkReal(-1.00000000000000))*(r11)*(x5496)*(x5497)))+(((IkReal(-1.00000000000000))*(r12)*(x5496)*(x5501)))+(((IkReal(-1.00000000000000))*(x5496)*(x5499)*(x5518)))+(((IkReal(-1.00000000000000))*(r00)*(x5509)*(x5511)))+(((x5501)*(x5520))));
evalcond[5]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x5499)*(x5509)*(x5518)))+(((IkReal(-1.00000000000000))*(r02)*(x5496)*(x5501)))+(((IkReal(-1.00000000000000))*(x5496)*(x5499)*(x5516)))+(((IkReal(-1.00000000000000))*(r11)*(x5497)*(x5509)))+(((IkReal(-1.00000000000000))*(x5501)*(x5522)))+(((r10)*(sj0)*(x5511)))+(((cj4)*(r00)*(x5502)))+(((IkReal(-1.00000000000000))*(x5498)*(x5499)*(x5519)))+(((IkReal(-1.00000000000000))*(r01)*(x5496)*(x5497)))+(((IkReal(-1.00000000000000))*(x5496)*(x5499)*(x5515))));
evalcond[6]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x5500)*(x5510)))+(((IkReal(-1.00000000000000))*(x5505)*(x5506)))+(((IkReal(-1.00000000000000))*(sj0)*(x5503)*(x5515)))+(((cj0)*(r12)*(x5517)))+(((r10)*(x5503)*(x5510)))+(((r11)*(x5502)*(x5503)))+(((IkReal(-1.00000000000000))*(r00)*(x5498)*(x5503)))+(((IkReal(-1.00000000000000))*(py)*(x5496)))+(((r00)*(x5498)*(x5500)))+(((sj0)*(x5500)*(x5515)))+(((IkReal(-1.00000000000000))*(x5517)*(x5520)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(r11)*(x5500)*(x5502)))+(((x5512)*(x5513))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj5)*(r00)*(x5496)*(x5497)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x5496)*(x5511)))+(((IkReal(-1.00000000000000))*(x5504)*(x5522)))+(((IkReal(-1.00000000000000))*(r02)*(x5496)*(x5504)))+(((r01)*(sj4)*(x5510)))+(((IkReal(-1.00000000000000))*(x5497)*(x5505)*(x5519)))+(((IkReal(-1.00000000000000))*(r10)*(x5509)*(x5521)))+(((r11)*(sj4)*(x5498)))+(((IkReal(-1.00000000000000))*(r11)*(x5505)*(x5511)))+(((IkReal(-1.00000000000000))*(r00)*(x5496)*(x5521))));
evalcond[8]=((IkReal(0.0690000000000000))+(((IkReal(-1.00000000000000))*(py)*(x5509)))+(((r00)*(x5503)*(x5510)))+(((IkReal(-1.00000000000000))*(sj0)*(x5500)*(x5518)))+(((IkReal(-1.00000000000000))*(px)*(x5496)))+(((IkReal(-1.00000000000000))*(r10)*(x5498)*(x5500)))+(((r01)*(x5502)*(x5503)))+(((r10)*(x5498)*(x5503)))+(((IkReal(-1.00000000000000))*(r01)*(x5500)*(x5502)))+(((sj0)*(x5503)*(x5518)))+(((x5505)*(x5512)))+(((r12)*(sj0)*(x5517)))+(((x5506)*(x5513)))+(((IkReal(-1.00000000000000))*(r00)*(x5500)*(x5510)))+(((cj0)*(r02)*(x5517))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5523=((IkReal(1.00000000000000))*(sj5));
IkReal x5524=((cj6)*(r21));
IkReal x5525=((r20)*(sj6));
IkReal x5526=((IkReal(1.00000000000000))*(cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(x5524)*(x5526)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x5525)*(x5526)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x5523)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x5523)*(x5525)))+(((IkReal(-1.00000000000000))*(x5523)*(x5524)))+(((cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x5524)*(x5526)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x5525)*(x5526)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x5523)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))))+IKsqr(((((IkReal(-1.00000000000000))*(x5523)*(x5525)))+(((IkReal(-1.00000000000000))*(x5523)*(x5524)))+(((cj5)*(r22)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x5524)*(x5526)))+(((r21)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x5525)*(x5526)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(x5523)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(sj4)))), ((((IkReal(-1.00000000000000))*(x5523)*(x5525)))+(((IkReal(-1.00000000000000))*(x5523)*(x5524)))+(((cj5)*(r22)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5527=IKsin(j3);
IkReal x5528=IKcos(j3);
IkReal x5529=((sj0)*(sj5));
IkReal x5530=((r00)*(sj6));
IkReal x5531=((cj6)*(r01));
IkReal x5532=((cj0)*(cj5));
IkReal x5533=((IkReal(1.00000000000000))*(cj5));
IkReal x5534=((cj4)*(cj5));
IkReal x5535=((cj6)*(sj4));
IkReal x5536=((sj4)*(sj6));
IkReal x5537=((cj0)*(r11));
IkReal x5538=((IkReal(1.00000000000000))*(cj4));
IkReal x5539=((cj6)*(r21));
IkReal x5540=((r20)*(sj6));
IkReal x5541=((cj0)*(sj5));
IkReal x5542=((r10)*(sj6));
evalcond[0]=((((sj5)*(x5540)))+(((IkReal(-1.00000000000000))*(r22)*(x5533)))+(x5528)+(((sj5)*(x5539))));
evalcond[1]=((((x5534)*(x5540)))+(((cj4)*(r22)*(sj5)))+(((x5534)*(x5539)))+(x5527)+(((r20)*(x5535)))+(((IkReal(-1.00000000000000))*(r21)*(x5536))));
evalcond[2]=((((x5529)*(x5531)))+(((IkReal(-1.00000000000000))*(cj6)*(sj5)*(x5537)))+(((r12)*(x5532)))+(x5527)+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x5533)))+(((x5529)*(x5530)))+(((IkReal(-1.00000000000000))*(x5541)*(x5542))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r12)*(x5538)*(x5541)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x5532)*(x5538)))+(((r00)*(sj0)*(x5535)))+(((x5536)*(x5537)))+(((IkReal(-1.00000000000000))*(cj0)*(r10)*(x5535)))+(((IkReal(-1.00000000000000))*(x5528)))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(x5536)))+(((IkReal(-1.00000000000000))*(x5532)*(x5538)*(x5542)))+(((sj0)*(x5531)*(x5534)))+(((cj4)*(r02)*(x5529)))+(((sj0)*(x5530)*(x5534))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x5543=((IkReal(1.00000000000000))*(cj0));
IkReal x5544=((cj4)*(sj6));
IkReal x5545=((sj0)*(sj4));
IkReal x5546=((cj5)*(sj6));
IkReal x5547=((sj4)*(sj5));
IkReal x5548=((r12)*(sj5));
IkReal x5549=((IkReal(0.374290000000000))*(cj5));
IkReal x5550=((r02)*(sj0));
IkReal x5551=((r20)*(sj4));
IkReal x5552=((IkReal(1.00000000000000))*(sj0));
IkReal x5553=((IkReal(1.00000000000000))*(cj5));
IkReal x5554=((cj0)*(r10));
IkReal x5555=((cj4)*(cj6));
IkReal x5556=((r00)*(sj0));
IkReal x5557=((cj6)*(r21));
IkReal x5558=((IkReal(0.374290000000000))*(sj5));
IkReal x5559=((cj0)*(r00));
IkReal x5560=((IkReal(0.0100000000000000))*(sj5));
IkReal x5561=((cj0)*(r02));
IkReal x5562=((cj5)*(sj4));
IkReal x5563=((cj6)*(r01));
IkReal x5564=((cj6)*(r11));
IkReal x5565=((r01)*(sj0));
IkReal x5566=((r10)*(sj0));
IkReal x5567=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x5568=((sj6)*(x5558));
IkReal x5569=((cj0)*(cj6)*(x5558));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r22)*(x5553)))+(((sj5)*(x5557)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(1.00000000000000))+(((x5546)*(x5551)))+(((x5557)*(x5562)))+(((r22)*(x5547)))+(((IkReal(-1.00000000000000))*(r20)*(x5555)))+(((r21)*(x5544))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r22)*(x5560)))+(((x5557)*(x5558)))+(((IkReal(-0.0100000000000000))*(cj5)*(x5557)))+(((r20)*(x5568)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x5549)))+(((IkReal(-0.0100000000000000))*(r20)*(x5546))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj6)*(x5551)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r21)*(x5555)))+(((cj5)*(r20)*(x5544))));
evalcond[5]=((((r02)*(sj5)*(x5545)))+(((cj5)*(x5545)*(x5563)))+(((r00)*(x5545)*(x5546)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x5543)*(x5546)))+(((IkReal(-1.00000000000000))*(x5543)*(x5562)*(x5564)))+(((IkReal(-1.00000000000000))*(r00)*(x5552)*(x5555)))+(((x5544)*(x5565)))+(((IkReal(-1.00000000000000))*(r11)*(x5543)*(x5544)))+(((IkReal(-1.00000000000000))*(r12)*(x5543)*(x5547)))+(((x5554)*(x5555))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r02)*(x5543)*(x5547)))+(((IkReal(-1.00000000000000))*(r10)*(x5545)*(x5546)))+(((IkReal(-1.00000000000000))*(x5545)*(x5548)))+(((x5555)*(x5566)))+(((IkReal(-1.00000000000000))*(x5545)*(x5553)*(x5564)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(x5543)*(x5546)))+(((IkReal(-1.00000000000000))*(x5543)*(x5562)*(x5563)))+(((IkReal(-1.00000000000000))*(r11)*(x5544)*(x5552)))+(((IkReal(-1.00000000000000))*(r01)*(x5543)*(x5544)))+(((x5555)*(x5559))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((IkReal(-1.00000000000000))*(x5554)*(x5568)))+(((IkReal(-1.00000000000000))*(cj0)*(x5558)*(x5564)))+(((IkReal(0.0100000000000000))*(x5546)*(x5554)))+(((IkReal(-1.00000000000000))*(x5549)*(x5550)))+(((sj0)*(x5558)*(x5563)))+(((x5556)*(x5568)))+(((cj0)*(r12)*(x5549)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x5563)))+(((IkReal(0.0100000000000000))*(cj0)*(x5548)))+(((IkReal(-1.00000000000000))*(py)*(x5543)))+(((IkReal(-1.00000000000000))*(x5550)*(x5560)))+(((IkReal(-0.0100000000000000))*(x5546)*(x5556)))+(((px)*(sj0)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5564))));
evalcond[8]=((IkReal(0.433420000000000))+(((IkReal(0.0100000000000000))*(x5546)*(x5559)))+(((r12)*(sj0)*(x5549)))+(((x5549)*(x5561)))+(((IkReal(-1.00000000000000))*(x5566)*(x5568)))+(((IkReal(-1.00000000000000))*(py)*(x5552)))+(((IkReal(0.0100000000000000))*(x5546)*(x5566)))+(((IkReal(0.0100000000000000))*(sj0)*(x5548)))+(((x5560)*(x5561)))+(((IkReal(-1.00000000000000))*(sj0)*(x5558)*(x5564)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x5564)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5563)))+(((IkReal(-1.00000000000000))*(cj0)*(x5558)*(x5563)))+(((IkReal(-1.00000000000000))*(x5559)*(x5568)))+(((IkReal(-1.00000000000000))*(px)*(x5543))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5570=((cj5)*(r02));
IkReal x5571=((cj0)*(sj5));
IkReal x5572=((r10)*(sj6));
IkReal x5573=((IkReal(1.00000000000000))*(cj6));
IkReal x5574=((sj0)*(sj5));
IkReal x5575=((cj5)*(r12));
IkReal x5576=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((cj6)*(r11)*(x5571)))+(((IkReal(-1.00000000000000))*(cj0)*(x5575)))+(((x5571)*(x5572)))+(((IkReal(-1.00000000000000))*(x5574)*(x5576)))+(((IkReal(-1.00000000000000))*(r01)*(x5573)*(x5574)))+(((sj0)*(x5570))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r11)*(x5573)*(x5574)))+(((IkReal(-1.00000000000000))*(x5571)*(x5576)))+(((IkReal(-1.00000000000000))*(r01)*(x5571)*(x5573)))+(((cj0)*(x5570)))+(((IkReal(-1.00000000000000))*(x5572)*(x5574)))+(((sj0)*(x5575))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj6)*(r11)*(x5571)))+(((IkReal(-1.00000000000000))*(cj0)*(x5575)))+(((x5571)*(x5572)))+(((IkReal(-1.00000000000000))*(x5574)*(x5576)))+(((IkReal(-1.00000000000000))*(r01)*(x5573)*(x5574)))+(((sj0)*(x5570)))))+IKsqr(((((IkReal(-1.00000000000000))*(r11)*(x5573)*(x5574)))+(((IkReal(-1.00000000000000))*(x5571)*(x5576)))+(((IkReal(-1.00000000000000))*(r01)*(x5571)*(x5573)))+(((cj0)*(x5570)))+(((IkReal(-1.00000000000000))*(x5572)*(x5574)))+(((sj0)*(x5575)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj6)*(r11)*(x5571)))+(((IkReal(-1.00000000000000))*(cj0)*(x5575)))+(((x5571)*(x5572)))+(((IkReal(-1.00000000000000))*(x5574)*(x5576)))+(((IkReal(-1.00000000000000))*(r01)*(x5573)*(x5574)))+(((sj0)*(x5570)))), ((((IkReal(-1.00000000000000))*(r11)*(x5573)*(x5574)))+(((IkReal(-1.00000000000000))*(x5571)*(x5576)))+(((IkReal(-1.00000000000000))*(r01)*(x5571)*(x5573)))+(((cj0)*(x5570)))+(((IkReal(-1.00000000000000))*(x5572)*(x5574)))+(((sj0)*(x5575)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5577=IKsin(j3);
IkReal x5578=((sj0)*(sj5));
IkReal x5579=((r00)*(sj6));
IkReal x5580=((IkReal(1.00000000000000))*(cj4));
IkReal x5581=((cj6)*(sj0));
IkReal x5582=((r00)*(sj4));
IkReal x5583=((cj0)*(cj5));
IkReal x5584=((cj6)*(r01));
IkReal x5585=((cj5)*(sj0));
IkReal x5586=((cj0)*(sj5));
IkReal x5587=((cj6)*(r11));
IkReal x5588=((r10)*(sj6));
IkReal x5589=((r10)*(sj4));
IkReal x5590=((IkReal(1.00000000000000))*(IKcos(j3)));
IkReal x5591=((cj0)*(sj4)*(sj6));
IkReal x5592=((sj0)*(sj4)*(sj6));
IkReal x5593=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((((x5578)*(x5584)))+(((r12)*(x5583)))+(((IkReal(-1.00000000000000))*(x5586)*(x5587)))+(((x5578)*(x5579)))+(((IkReal(-1.00000000000000))*(x5586)*(x5588)))+(((IkReal(-1.00000000000000))*(r02)*(x5585)))+(x5577));
evalcond[1]=((((IkReal(-1.00000000000000))*(x5578)*(x5588)))+(((r02)*(x5583)))+(((r12)*(x5585)))+(((IkReal(-1.00000000000000))*(x5579)*(x5586)))+(((IkReal(-1.00000000000000))*(x5578)*(x5587)))+(((IkReal(-1.00000000000000))*(x5584)*(x5586)))+(((IkReal(-1.00000000000000))*(x5590))));
evalcond[2]=((((cj4)*(cj5)*(r01)*(x5581)))+(((cj4)*(r02)*(x5578)))+(((IkReal(-1.00000000000000))*(x5589)*(x5593)))+(((IkReal(-1.00000000000000))*(x5580)*(x5583)*(x5587)))+(((IkReal(-1.00000000000000))*(r12)*(x5580)*(x5586)))+(((cj4)*(x5579)*(x5585)))+(((r11)*(x5591)))+(((IkReal(-1.00000000000000))*(x5590)))+(((x5581)*(x5582)))+(((IkReal(-1.00000000000000))*(x5580)*(x5583)*(x5588)))+(((IkReal(-1.00000000000000))*(r01)*(x5592))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r12)*(x5578)*(x5580)))+(((IkReal(-1.00000000000000))*(x5577)))+(((IkReal(-1.00000000000000))*(x5580)*(x5585)*(x5588)))+(((IkReal(-1.00000000000000))*(x5580)*(x5583)*(x5584)))+(((r01)*(x5591)))+(((IkReal(-1.00000000000000))*(x5579)*(x5580)*(x5583)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x5580)*(x5581)))+(((IkReal(-1.00000000000000))*(r02)*(x5580)*(x5586)))+(((IkReal(-1.00000000000000))*(x5582)*(x5593)))+(((IkReal(-1.00000000000000))*(x5581)*(x5589)))+(((r11)*(x5592))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x5594=((IkReal(1.00000000000000))*(cj0));
IkReal x5595=((cj4)*(sj6));
IkReal x5596=((sj0)*(sj4));
IkReal x5597=((cj5)*(sj6));
IkReal x5598=((sj4)*(sj5));
IkReal x5599=((r12)*(sj5));
IkReal x5600=((IkReal(0.374290000000000))*(cj5));
IkReal x5601=((r02)*(sj0));
IkReal x5602=((r20)*(sj4));
IkReal x5603=((IkReal(1.00000000000000))*(sj0));
IkReal x5604=((IkReal(1.00000000000000))*(cj5));
IkReal x5605=((cj0)*(r10));
IkReal x5606=((cj4)*(cj6));
IkReal x5607=((r00)*(sj0));
IkReal x5608=((cj6)*(r21));
IkReal x5609=((IkReal(0.374290000000000))*(sj5));
IkReal x5610=((cj0)*(r00));
IkReal x5611=((IkReal(0.0100000000000000))*(sj5));
IkReal x5612=((cj0)*(r02));
IkReal x5613=((cj5)*(sj4));
IkReal x5614=((cj6)*(r01));
IkReal x5615=((cj6)*(r11));
IkReal x5616=((r01)*(sj0));
IkReal x5617=((r10)*(sj0));
IkReal x5618=((IkReal(0.0100000000000000))*(cj5)*(cj6));
IkReal x5619=((sj6)*(x5609));
IkReal x5620=((cj0)*(cj6)*(x5609));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j1, IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x5608)))+(((IkReal(-1.00000000000000))*(r22)*(x5604)))+(((r20)*(sj5)*(sj6))));
evalcond[2]=((IkReal(-1.00000000000000))+(((x5597)*(x5602)))+(((x5608)*(x5613)))+(((r22)*(x5598)))+(((IkReal(-1.00000000000000))*(r20)*(x5606)))+(((r21)*(x5595))));
evalcond[3]=((((IkReal(-0.0100000000000000))*(r20)*(x5597)))+(((IkReal(-0.0100000000000000))*(cj5)*(x5608)))+(((IkReal(-1.00000000000000))*(r22)*(x5611)))+(((x5608)*(x5609)))+(pz)+(((IkReal(-1.00000000000000))*(r22)*(x5600)))+(((r20)*(x5619))));
evalcond[4]=((((cj5)*(r21)*(x5606)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((cj5)*(r20)*(x5595)))+(((cj6)*(x5602))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x5594)*(x5613)*(x5615)))+(((x5595)*(x5616)))+(((IkReal(-1.00000000000000))*(r00)*(x5603)*(x5606)))+(((IkReal(-1.00000000000000))*(r11)*(x5594)*(x5595)))+(((cj5)*(x5596)*(x5614)))+(((IkReal(-1.00000000000000))*(r12)*(x5594)*(x5598)))+(((r02)*(sj5)*(x5596)))+(((IkReal(-1.00000000000000))*(r10)*(sj4)*(x5594)*(x5597)))+(((r00)*(x5596)*(x5597)))+(((x5605)*(x5606))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r00)*(sj4)*(x5594)*(x5597)))+(((x5606)*(x5617)))+(((IkReal(-1.00000000000000))*(r02)*(x5594)*(x5598)))+(((IkReal(-1.00000000000000))*(x5596)*(x5604)*(x5615)))+(((IkReal(-1.00000000000000))*(x5596)*(x5599)))+(((IkReal(-1.00000000000000))*(r01)*(x5594)*(x5595)))+(((IkReal(-1.00000000000000))*(x5594)*(x5613)*(x5614)))+(((IkReal(-1.00000000000000))*(r11)*(x5595)*(x5603)))+(((x5606)*(x5610)))+(((IkReal(-1.00000000000000))*(r10)*(x5596)*(x5597))));
evalcond[7]=((IkReal(-0.0690000000000000))+(((cj0)*(r12)*(x5600)))+(((IkReal(-1.00000000000000))*(x5601)*(x5611)))+(((sj0)*(x5609)*(x5614)))+(((IkReal(-1.00000000000000))*(x5600)*(x5601)))+(((IkReal(0.0100000000000000))*(cj0)*(x5599)))+(((IkReal(-0.0100000000000000))*(cj5)*(sj0)*(x5614)))+(((IkReal(-0.0100000000000000))*(x5597)*(x5607)))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5615)))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(py)*(x5594)))+(((IkReal(0.0100000000000000))*(x5597)*(x5605)))+(((x5607)*(x5619)))+(((IkReal(-1.00000000000000))*(x5605)*(x5619)))+(((IkReal(-1.00000000000000))*(cj0)*(x5609)*(x5615))));
evalcond[8]=((IkReal(-0.295420000000000))+(((IkReal(0.0100000000000000))*(cj0)*(cj5)*(x5614)))+(((IkReal(-1.00000000000000))*(cj0)*(x5609)*(x5614)))+(((IkReal(0.0100000000000000))*(cj5)*(sj0)*(x5615)))+(((IkReal(0.0100000000000000))*(sj0)*(x5599)))+(((IkReal(-1.00000000000000))*(x5617)*(x5619)))+(((IkReal(-1.00000000000000))*(sj0)*(x5609)*(x5615)))+(((IkReal(0.0100000000000000))*(x5597)*(x5617)))+(((IkReal(-1.00000000000000))*(py)*(x5603)))+(((r12)*(sj0)*(x5600)))+(((IkReal(0.0100000000000000))*(x5597)*(x5610)))+(((x5611)*(x5612)))+(((x5600)*(x5612)))+(((IkReal(-1.00000000000000))*(x5610)*(x5619)))+(((IkReal(-1.00000000000000))*(px)*(x5594))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5621=((IkReal(1.00000000000000))*(cj5));
IkReal x5622=((r10)*(sj5)*(sj6));
IkReal x5623=((cj6)*(sj0)*(sj5));
IkReal x5624=((r00)*(sj5)*(sj6));
IkReal x5625=((cj0)*(cj6)*(sj5));
if( IKabs(((((r11)*(x5625)))+(((cj0)*(x5622)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(sj0)*(x5624)))+(((IkReal(-1.00000000000000))*(r01)*(x5623)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5621))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x5621)))+(((r11)*(x5623)))+(((sj0)*(x5622)))+(((cj0)*(x5624)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x5621)))+(((r01)*(x5625))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r11)*(x5625)))+(((cj0)*(x5622)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(sj0)*(x5624)))+(((IkReal(-1.00000000000000))*(r01)*(x5623)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5621)))))+IKsqr(((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x5621)))+(((r11)*(x5623)))+(((sj0)*(x5622)))+(((cj0)*(x5624)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x5621)))+(((r01)*(x5625)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r11)*(x5625)))+(((cj0)*(x5622)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(sj0)*(x5624)))+(((IkReal(-1.00000000000000))*(r01)*(x5623)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5621)))), ((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x5621)))+(((r11)*(x5623)))+(((sj0)*(x5622)))+(((cj0)*(x5624)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x5621)))+(((r01)*(x5625)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x5626=IKcos(j3);
IkReal x5627=IKsin(j3);
IkReal x5628=((sj0)*(sj5));
IkReal x5629=((r00)*(sj6));
IkReal x5630=((IkReal(1.00000000000000))*(cj4));
IkReal x5631=((cj6)*(sj0));
IkReal x5632=((r00)*(sj4));
IkReal x5633=((cj0)*(cj5));
IkReal x5634=((cj6)*(r01));
IkReal x5635=((cj5)*(sj0));
IkReal x5636=((cj0)*(sj5));
IkReal x5637=((cj6)*(r11));
IkReal x5638=((r10)*(sj6));
IkReal x5639=((r10)*(sj4));
IkReal x5640=((cj0)*(sj4)*(sj6));
IkReal x5641=((sj0)*(sj4)*(sj6));
IkReal x5642=((IkReal(1.00000000000000))*(cj0)*(cj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(r02)*(x5635)))+(((x5628)*(x5629)))+(((IkReal(-1.00000000000000))*(x5636)*(x5638)))+(((r12)*(x5633)))+(((x5628)*(x5634)))+(x5627)+(((IkReal(-1.00000000000000))*(x5636)*(x5637))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x5628)*(x5637)))+(((IkReal(-1.00000000000000))*(x5629)*(x5636)))+(((IkReal(-1.00000000000000))*(x5634)*(x5636)))+(((IkReal(-1.00000000000000))*(x5628)*(x5638)))+(((r02)*(x5633)))+(((r12)*(x5635)))+(x5626));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x5641)))+(((IkReal(-1.00000000000000))*(r12)*(x5630)*(x5636)))+(((cj4)*(r02)*(x5628)))+(((IkReal(-1.00000000000000))*(x5630)*(x5633)*(x5638)))+(((cj4)*(cj5)*(r01)*(x5631)))+(((IkReal(-1.00000000000000))*(x5630)*(x5633)*(x5637)))+(((r11)*(x5640)))+(((cj4)*(x5629)*(x5635)))+(((x5631)*(x5632)))+(((IkReal(-1.00000000000000))*(x5639)*(x5642)))+(((IkReal(-1.00000000000000))*(x5626))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x5630)*(x5635)*(x5638)))+(((r11)*(x5641)))+(((IkReal(-1.00000000000000))*(x5629)*(x5630)*(x5633)))+(((IkReal(-1.00000000000000))*(x5631)*(x5639)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x5630)*(x5631)))+(((IkReal(-1.00000000000000))*(x5630)*(x5633)*(x5634)))+(((r01)*(x5640)))+(((IkReal(-1.00000000000000))*(r12)*(x5628)*(x5630)))+(((IkReal(-1.00000000000000))*(x5632)*(x5642)))+(x5627)+(((IkReal(-1.00000000000000))*(r02)*(x5630)*(x5636))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5643=((cj5)*(r02));
IkReal x5644=((cj0)*(sj5));
IkReal x5645=((r10)*(sj6));
IkReal x5646=((IkReal(1.00000000000000))*(cj6));
IkReal x5647=((sj0)*(sj5));
IkReal x5648=((cj5)*(r12));
IkReal x5649=((IkReal(1.00000000000000))*(r00)*(sj6));
if( IKabs(((((cj6)*(r11)*(x5644)))+(((x5644)*(x5645)))+(((IkReal(-1.00000000000000))*(cj0)*(x5648)))+(((IkReal(-1.00000000000000))*(x5647)*(x5649)))+(((IkReal(-1.00000000000000))*(r01)*(x5646)*(x5647)))+(((sj0)*(x5643))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((sj0)*(x5648)))+(((IkReal(-1.00000000000000))*(x5645)*(x5647)))+(((cj0)*(x5643)))+(((IkReal(-1.00000000000000))*(x5644)*(x5649)))+(((IkReal(-1.00000000000000))*(r11)*(x5646)*(x5647)))+(((IkReal(-1.00000000000000))*(r01)*(x5644)*(x5646))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj6)*(r11)*(x5644)))+(((x5644)*(x5645)))+(((IkReal(-1.00000000000000))*(cj0)*(x5648)))+(((IkReal(-1.00000000000000))*(x5647)*(x5649)))+(((IkReal(-1.00000000000000))*(r01)*(x5646)*(x5647)))+(((sj0)*(x5643)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((sj0)*(x5648)))+(((IkReal(-1.00000000000000))*(x5645)*(x5647)))+(((cj0)*(x5643)))+(((IkReal(-1.00000000000000))*(x5644)*(x5649)))+(((IkReal(-1.00000000000000))*(r11)*(x5646)*(x5647)))+(((IkReal(-1.00000000000000))*(r01)*(x5644)*(x5646)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj6)*(r11)*(x5644)))+(((x5644)*(x5645)))+(((IkReal(-1.00000000000000))*(cj0)*(x5648)))+(((IkReal(-1.00000000000000))*(x5647)*(x5649)))+(((IkReal(-1.00000000000000))*(r01)*(x5646)*(x5647)))+(((sj0)*(x5643)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((sj0)*(x5648)))+(((IkReal(-1.00000000000000))*(x5645)*(x5647)))+(((cj0)*(x5643)))+(((IkReal(-1.00000000000000))*(x5644)*(x5649)))+(((IkReal(-1.00000000000000))*(r11)*(x5646)*(x5647)))+(((IkReal(-1.00000000000000))*(r01)*(x5644)*(x5646)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x5650=IKsin(j3);
IkReal x5651=IKcos(j3);
IkReal x5652=((sj0)*(sj5));
IkReal x5653=((r00)*(sj6));
IkReal x5654=((IkReal(1.00000000000000))*(cj4));
IkReal x5655=((cj6)*(r01));
IkReal x5656=((cj0)*(cj5));
IkReal x5657=((cj5)*(sj0));
IkReal x5658=((cj6)*(r11));
IkReal x5659=((cj0)*(sj5));
IkReal x5660=((IkReal(1.00000000000000))*(cj1));
IkReal x5661=((cj6)*(sj4));
IkReal x5662=((IkReal(1.00000000000000))*(sj1));
IkReal x5663=((cj4)*(cj5));
IkReal x5664=((cj6)*(r21));
IkReal x5665=((r20)*(sj6));
IkReal x5666=((r10)*(sj6));
IkReal x5667=((IkReal(1.00000000000000))*(cj0));
IkReal x5668=((cj0)*(sj4)*(sj6));
IkReal x5669=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x5664)))+(((IkReal(-1.00000000000000))*(x5651)*(x5662)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5665))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((r20)*(x5661)))+(((x5663)*(x5665)))+(((IkReal(-1.00000000000000))*(x5650)*(x5662)))+(((x5663)*(x5664))));
evalcond[2]=((((x5652)*(x5653)))+(((r12)*(x5656)))+(((x5652)*(x5655)))+(((IkReal(-1.00000000000000))*(x5659)*(x5666)))+(((IkReal(-1.00000000000000))*(x5658)*(x5659)))+(x5650)+(((IkReal(-1.00000000000000))*(r02)*(x5657))));
evalcond[3]=((((r12)*(x5657)))+(((IkReal(-1.00000000000000))*(x5651)*(x5660)))+(((r02)*(x5656)))+(((IkReal(-1.00000000000000))*(x5655)*(x5659)))+(((IkReal(-1.00000000000000))*(x5652)*(x5666)))+(((IkReal(-1.00000000000000))*(x5652)*(x5658)))+(((IkReal(-1.00000000000000))*(x5653)*(x5659))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r01)*(x5669)))+(((cj4)*(x5655)*(x5657)))+(((IkReal(-1.00000000000000))*(x5654)*(x5656)*(x5658)))+(((r11)*(x5668)))+(((cj4)*(r02)*(x5652)))+(((IkReal(-1.00000000000000))*(x5654)*(x5656)*(x5666)))+(((IkReal(-1.00000000000000))*(r10)*(x5661)*(x5667)))+(((r00)*(sj0)*(x5661)))+(((cj4)*(x5653)*(x5657)))+(((IkReal(-1.00000000000000))*(r12)*(x5654)*(x5659)))+(((IkReal(-1.00000000000000))*(x5651))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r02)*(x5654)*(x5659)))+(((IkReal(-1.00000000000000))*(x5650)*(x5660)))+(((r11)*(x5669)))+(((IkReal(-1.00000000000000))*(x5653)*(x5654)*(x5656)))+(((IkReal(-1.00000000000000))*(r12)*(x5652)*(x5654)))+(((IkReal(-1.00000000000000))*(r00)*(x5661)*(x5667)))+(((IkReal(-1.00000000000000))*(x5654)*(x5657)*(x5658)))+(((IkReal(-1.00000000000000))*(x5654)*(x5655)*(x5656)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x5661)))+(((IkReal(-1.00000000000000))*(x5654)*(x5657)*(x5666)))+(((r01)*(x5668))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5670=((sj5)*(sj6));
IkReal x5671=((IkReal(1.00000000000000))*(sj0));
IkReal x5672=((cj6)*(sj5));
IkReal x5673=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r00)*(x5670)*(x5671)))+(((cj0)*(r10)*(x5670)))+(((cj0)*(r11)*(x5672)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x5671)*(x5672)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5673))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x5672)))+(((r20)*(x5670)))+(((IkReal(-1.00000000000000))*(r22)*(x5673))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r00)*(x5670)*(x5671)))+(((cj0)*(r10)*(x5670)))+(((cj0)*(r11)*(x5672)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x5671)*(x5672)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5673)))))+IKsqr(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x5672)))+(((r20)*(x5670)))+(((IkReal(-1.00000000000000))*(r22)*(x5673)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r00)*(x5670)*(x5671)))+(((cj0)*(r10)*(x5670)))+(((cj0)*(r11)*(x5672)))+(((cj5)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x5671)*(x5672)))+(((IkReal(-1.00000000000000))*(cj0)*(r12)*(x5673)))), ((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((r21)*(x5672)))+(((r20)*(x5670)))+(((IkReal(-1.00000000000000))*(r22)*(x5673)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x5674=IKsin(j3);
IkReal x5675=IKcos(j3);
IkReal x5676=((sj0)*(sj5));
IkReal x5677=((r00)*(sj6));
IkReal x5678=((IkReal(1.00000000000000))*(cj4));
IkReal x5679=((cj6)*(r01));
IkReal x5680=((cj0)*(cj5));
IkReal x5681=((cj5)*(sj0));
IkReal x5682=((cj6)*(r11));
IkReal x5683=((cj0)*(sj5));
IkReal x5684=((IkReal(1.00000000000000))*(cj1));
IkReal x5685=((cj6)*(sj4));
IkReal x5686=((IkReal(1.00000000000000))*(sj1));
IkReal x5687=((cj4)*(cj5));
IkReal x5688=((cj6)*(r21));
IkReal x5689=((r20)*(sj6));
IkReal x5690=((r10)*(sj6));
IkReal x5691=((IkReal(1.00000000000000))*(cj0));
IkReal x5692=((cj0)*(sj4)*(sj6));
IkReal x5693=((sj0)*(sj4)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(x5675)*(x5686)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5689)))+(((sj5)*(x5688))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x5687)*(x5689)))+(((IkReal(-1.00000000000000))*(x5674)*(x5686)))+(((r20)*(x5685)))+(((cj4)*(r22)*(sj5)))+(((x5687)*(x5688))));
evalcond[2]=((x5674)+(((IkReal(-1.00000000000000))*(x5682)*(x5683)))+(((IkReal(-1.00000000000000))*(r02)*(x5681)))+(((x5676)*(x5677)))+(((IkReal(-1.00000000000000))*(x5683)*(x5690)))+(((x5676)*(x5679)))+(((r12)*(x5680))));
evalcond[3]=((((r02)*(x5680)))+(((IkReal(-1.00000000000000))*(x5675)*(x5684)))+(((IkReal(-1.00000000000000))*(x5679)*(x5683)))+(((IkReal(-1.00000000000000))*(x5676)*(x5690)))+(((r12)*(x5681)))+(((IkReal(-1.00000000000000))*(x5677)*(x5683)))+(((IkReal(-1.00000000000000))*(x5676)*(x5682))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x5675)))+(((cj4)*(x5677)*(x5681)))+(((IkReal(-1.00000000000000))*(r01)*(x5693)))+(((r00)*(sj0)*(x5685)))+(((cj4)*(x5679)*(x5681)))+(((IkReal(-1.00000000000000))*(x5678)*(x5680)*(x5682)))+(((cj4)*(r02)*(x5676)))+(((IkReal(-1.00000000000000))*(r12)*(x5678)*(x5683)))+(((IkReal(-1.00000000000000))*(r10)*(x5685)*(x5691)))+(((r11)*(x5692)))+(((IkReal(-1.00000000000000))*(x5678)*(x5680)*(x5690))));
evalcond[5]=((((r01)*(x5692)))+(((IkReal(-1.00000000000000))*(x5674)*(x5684)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x5685)))+(((r11)*(x5693)))+(((IkReal(-1.00000000000000))*(r02)*(x5678)*(x5683)))+(((IkReal(-1.00000000000000))*(x5678)*(x5681)*(x5690)))+(((IkReal(-1.00000000000000))*(r12)*(x5676)*(x5678)))+(((IkReal(-1.00000000000000))*(x5677)*(x5678)*(x5680)))+(((IkReal(-1.00000000000000))*(x5678)*(x5681)*(x5682)))+(((IkReal(-1.00000000000000))*(x5678)*(x5679)*(x5680)))+(((IkReal(-1.00000000000000))*(r00)*(x5685)*(x5691))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5694=((r20)*(sj6));
IkReal x5695=((cj4)*(cj5));
IkReal x5696=((cj6)*(r21));
if( IKabs(((gconst30)*(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x5695)*(x5696)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5694)*(x5695))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst30)*(((((sj5)*(x5694)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5696))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst30)*(((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((x5695)*(x5696)))+(((cj6)*(r20)*(sj4)))+(((cj4)*(r22)*(sj5)))+(((x5694)*(x5695)))))), ((gconst30)*(((((sj5)*(x5694)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5696)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x5697=IKsin(j3);
IkReal x5698=IKcos(j3);
IkReal x5699=((sj0)*(sj5));
IkReal x5700=((r00)*(sj6));
IkReal x5701=((IkReal(1.00000000000000))*(cj4));
IkReal x5702=((cj6)*(r01));
IkReal x5703=((cj0)*(cj5));
IkReal x5704=((cj5)*(sj0));
IkReal x5705=((cj6)*(r11));
IkReal x5706=((cj0)*(sj5));
IkReal x5707=((IkReal(1.00000000000000))*(cj1));
IkReal x5708=((cj6)*(sj4));
IkReal x5709=((IkReal(1.00000000000000))*(sj1));
IkReal x5710=((cj4)*(cj5));
IkReal x5711=((cj6)*(r21));
IkReal x5712=((r20)*(sj6));
IkReal x5713=((r10)*(sj6));
IkReal x5714=((IkReal(1.00000000000000))*(cj0));
IkReal x5715=((cj0)*(sj4)*(sj6));
IkReal x5716=((sj0)*(sj4)*(sj6));
evalcond[0]=((((sj5)*(x5711)))+(((IkReal(-1.00000000000000))*(x5698)*(x5709)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x5712))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj6)))+(((cj4)*(r22)*(sj5)))+(((x5710)*(x5711)))+(((r20)*(x5708)))+(((IkReal(-1.00000000000000))*(x5697)*(x5709)))+(((x5710)*(x5712))));
evalcond[2]=((x5697)+(((x5699)*(x5702)))+(((x5699)*(x5700)))+(((IkReal(-1.00000000000000))*(r02)*(x5704)))+(((IkReal(-1.00000000000000))*(x5706)*(x5713)))+(((IkReal(-1.00000000000000))*(x5705)*(x5706)))+(((r12)*(x5703))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x5702)*(x5706)))+(((r02)*(x5703)))+(((IkReal(-1.00000000000000))*(x5700)*(x5706)))+(((IkReal(-1.00000000000000))*(x5699)*(x5705)))+(((IkReal(-1.00000000000000))*(x5698)*(x5707)))+(((r12)*(x5704)))+(((IkReal(-1.00000000000000))*(x5699)*(x5713))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x5701)*(x5703)*(x5713)))+(((IkReal(-1.00000000000000))*(r01)*(x5716)))+(((IkReal(-1.00000000000000))*(x5698)))+(((IkReal(-1.00000000000000))*(r12)*(x5701)*(x5706)))+(((IkReal(-1.00000000000000))*(r10)*(x5708)*(x5714)))+(((r00)*(sj0)*(x5708)))+(((r11)*(x5715)))+(((cj4)*(x5702)*(x5704)))+(((cj4)*(x5700)*(x5704)))+(((IkReal(-1.00000000000000))*(x5701)*(x5703)*(x5705)))+(((cj4)*(r02)*(x5699))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x5701)*(x5702)*(x5703)))+(((r01)*(x5715)))+(((IkReal(-1.00000000000000))*(x5700)*(x5701)*(x5703)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x5708)))+(((IkReal(-1.00000000000000))*(r00)*(x5708)*(x5714)))+(((IkReal(-1.00000000000000))*(x5697)*(x5707)))+(((IkReal(-1.00000000000000))*(r12)*(x5699)*(x5701)))+(((r11)*(x5716)))+(((IkReal(-1.00000000000000))*(x5701)*(x5704)*(x5705)))+(((IkReal(-1.00000000000000))*(x5701)*(x5704)*(x5713)))+(((IkReal(-1.00000000000000))*(r02)*(x5701)*(x5706))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x5717=(cj1)*(cj1);
IkReal x5718=(sj1)*(sj1);
IkReal x5719=((r00)*(sj6));
IkReal x5720=((cj6)*(r01));
IkReal x5721=((IkReal(1.00000000000000))*(cj1));
IkReal x5722=((cj5)*(r22));
IkReal x5723=((sj5)*(sj6));
IkReal x5724=((r10)*(sj0));
IkReal x5725=((cj1)*(cj5));
IkReal x5726=((cj0)*(r02));
IkReal x5727=((r12)*(sj0));
IkReal x5728=((IkReal(1.00000000000000))*(sj1));
IkReal x5729=((cj6)*(sj5));
IkReal x5730=((cj0)*(sj5));
IkReal x5731=((r11)*(sj0));
IkReal x5732=((sj1)*(x5730));
if( IKabs(((((IKabs(((((cj2)*(x5717)))+(((cj2)*(x5718))))) != 0)?((IkReal)1/(((((cj2)*(x5717)))+(((cj2)*(x5718)))))):(IkReal)1.0e30))*(((((x5720)*(x5732)))+(((sj1)*(x5729)*(x5731)))+(((IkReal(-1.00000000000000))*(cj5)*(x5726)*(x5728)))+(((IkReal(-1.00000000000000))*(cj5)*(x5727)*(x5728)))+(((cj1)*(r21)*(x5729)))+(((cj1)*(r20)*(x5723)))+(((x5719)*(x5732)))+(((sj1)*(x5723)*(x5724)))+(((IkReal(-1.00000000000000))*(x5721)*(x5722))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((x5718)+(x5717))) != 0)?((IkReal)1/(((x5718)+(x5717)))):(IkReal)1.0e30))*(((((x5725)*(x5726)))+(((IkReal(-1.00000000000000))*(x5721)*(x5723)*(x5724)))+(((IkReal(-1.00000000000000))*(x5719)*(x5721)*(x5730)))+(((x5725)*(x5727)))+(((IkReal(-1.00000000000000))*(x5722)*(x5728)))+(((r20)*(sj1)*(x5723)))+(((r21)*(sj1)*(x5729)))+(((IkReal(-1.00000000000000))*(x5720)*(x5721)*(x5730)))+(((IkReal(-1.00000000000000))*(x5721)*(x5729)*(x5731))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((cj2)*(x5717)))+(((cj2)*(x5718))))) != 0)?((IkReal)1/(((((cj2)*(x5717)))+(((cj2)*(x5718)))))):(IkReal)1.0e30))*(((((x5720)*(x5732)))+(((sj1)*(x5729)*(x5731)))+(((IkReal(-1.00000000000000))*(cj5)*(x5726)*(x5728)))+(((IkReal(-1.00000000000000))*(cj5)*(x5727)*(x5728)))+(((cj1)*(r21)*(x5729)))+(((cj1)*(r20)*(x5723)))+(((x5719)*(x5732)))+(((sj1)*(x5723)*(x5724)))+(((IkReal(-1.00000000000000))*(x5721)*(x5722)))))))+IKsqr(((((IKabs(((x5718)+(x5717))) != 0)?((IkReal)1/(((x5718)+(x5717)))):(IkReal)1.0e30))*(((((x5725)*(x5726)))+(((IkReal(-1.00000000000000))*(x5721)*(x5723)*(x5724)))+(((IkReal(-1.00000000000000))*(x5719)*(x5721)*(x5730)))+(((x5725)*(x5727)))+(((IkReal(-1.00000000000000))*(x5722)*(x5728)))+(((r20)*(sj1)*(x5723)))+(((r21)*(sj1)*(x5729)))+(((IkReal(-1.00000000000000))*(x5720)*(x5721)*(x5730)))+(((IkReal(-1.00000000000000))*(x5721)*(x5729)*(x5731)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(((((cj2)*(x5717)))+(((cj2)*(x5718))))) != 0)?((IkReal)1/(((((cj2)*(x5717)))+(((cj2)*(x5718)))))):(IkReal)1.0e30))*(((((x5720)*(x5732)))+(((sj1)*(x5729)*(x5731)))+(((IkReal(-1.00000000000000))*(cj5)*(x5726)*(x5728)))+(((IkReal(-1.00000000000000))*(cj5)*(x5727)*(x5728)))+(((cj1)*(r21)*(x5729)))+(((cj1)*(r20)*(x5723)))+(((x5719)*(x5732)))+(((sj1)*(x5723)*(x5724)))+(((IkReal(-1.00000000000000))*(x5721)*(x5722)))))), ((((IKabs(((x5718)+(x5717))) != 0)?((IkReal)1/(((x5718)+(x5717)))):(IkReal)1.0e30))*(((((x5725)*(x5726)))+(((IkReal(-1.00000000000000))*(x5721)*(x5723)*(x5724)))+(((IkReal(-1.00000000000000))*(x5719)*(x5721)*(x5730)))+(((x5725)*(x5727)))+(((IkReal(-1.00000000000000))*(x5722)*(x5728)))+(((r20)*(sj1)*(x5723)))+(((r21)*(sj1)*(x5729)))+(((IkReal(-1.00000000000000))*(x5720)*(x5721)*(x5730)))+(((IkReal(-1.00000000000000))*(x5721)*(x5729)*(x5731)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x5733=IKsin(j3);
IkReal x5734=IKcos(j3);
IkReal x5735=((sj5)*(sj6));
IkReal x5736=((cj0)*(cj5));
IkReal x5737=((IkReal(1.00000000000000))*(cj0));
IkReal x5738=((IkReal(1.00000000000000))*(sj0));
IkReal x5739=((IkReal(1.00000000000000))*(x5734));
IkReal x5740=((IkReal(1.00000000000000))*(x5733));
IkReal x5741=((cj6)*(r01)*(sj5));
IkReal x5742=((cj6)*(r11)*(sj5));
evalcond[0]=((((cj6)*(r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj1)*(x5739)))+(((IkReal(-1.00000000000000))*(cj1)*(cj2)*(x5740)))+(((r20)*(x5735))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x5737)*(x5742)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)*(x5738)))+(((r12)*(x5736)))+(((IkReal(-1.00000000000000))*(r10)*(x5735)*(x5737)))+(((sj0)*(x5741)))+(((IkReal(-1.00000000000000))*(sj2)*(x5740)))+(((r00)*(sj0)*(x5735))));
evalcond[2]=((((cj2)*(sj1)*(x5733)))+(((IkReal(-1.00000000000000))*(r00)*(x5735)*(x5737)))+(((IkReal(-1.00000000000000))*(x5738)*(x5742)))+(((cj5)*(r12)*(sj0)))+(((IkReal(-1.00000000000000))*(x5737)*(x5741)))+(((r02)*(x5736)))+(((IkReal(-1.00000000000000))*(r10)*(x5735)*(x5738)))+(((IkReal(-1.00000000000000))*(cj1)*(x5739))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
IkReal x5743=(r21)*(r21);
IkReal x5744=(cj5)*(cj5);
IkReal x5745=(sj6)*(sj6);
IkReal x5746=(cj6)*(cj6);
IkReal x5747=(r20)*(r20);
IkReal x5748=((cj6)*(r21));
IkReal x5749=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x5750=((cj5)*(r22)*(sj5));
IkReal x5751=((IkReal(1.00000000000000))*(x5745));
IkReal x5752=((IkReal(1.00000000000000))*(x5746));
gconst2=IKsign(((((x5748)*(x5749)))+(((IkReal(-1.00000000000000))*(x5749)*(x5750)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-2.00000000000000))*(x5748)*(x5750)))+(((IkReal(-1.00000000000000))*(x5744)*(x5747)*(x5751)))+(((IkReal(-1.00000000000000))*(x5743)*(x5744)*(x5752)))+(((IkReal(-1.00000000000000))*(x5743)*(x5751)))+(((IkReal(-1.00000000000000))*(x5747)*(x5752)))+(((IkReal(-1.00000000000000))*(x5744)*(x5748)*(x5749)))));
IkReal x5753=(r21)*(r21);
IkReal x5754=(cj5)*(cj5);
IkReal x5755=(sj6)*(sj6);
IkReal x5756=(cj6)*(cj6);
IkReal x5757=(r20)*(r20);
IkReal x5758=((cj6)*(r21));
IkReal x5759=((IkReal(2.00000000000000))*(r20)*(sj6));
IkReal x5760=((cj5)*(r22)*(sj5));
IkReal x5761=((IkReal(1.00000000000000))*(x5755));
IkReal x5762=((IkReal(1.00000000000000))*(x5756));
dummyeval[0]=((((IkReal(-2.00000000000000))*(x5758)*(x5760)))+(((IkReal(-1.00000000000000))*(x5753)*(x5761)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x5754)*(x5758)*(x5759)))+(((IkReal(-1.00000000000000))*(x5754)*(x5757)*(x5761)))+(((IkReal(-1.00000000000000))*(x5759)*(x5760)))+(((x5758)*(x5759)))+(((IkReal(-1.00000000000000))*(x5753)*(x5754)*(x5762)))+(((IkReal(-1.00000000000000))*(x5757)*(x5762))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x5763=(cj6)*(cj6);
IkReal x5764=(sj6)*(sj6);
IkReal x5765=((IkReal(1.00000000000000))*(r21));
IkReal x5766=((cj6)*(r20));
IkReal x5767=((r22)*(sj5));
IkReal x5768=((r01)*(sj0));
IkReal x5769=((r00)*(sj0));
IkReal x5770=((cj0)*(r10));
IkReal x5771=((r02)*(sj0)*(sj5));
IkReal x5772=((cj5)*(x5763));
IkReal x5773=((cj0)*(r12)*(sj5));
IkReal x5774=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x5775=((cj5)*(x5764));
IkReal x5776=((r20)*(x5775));
gconst3=IKsign(((((IkReal(-1.00000000000000))*(x5765)*(x5769)*(x5775)))+(((sj6)*(x5767)*(x5768)))+(((IkReal(-1.00000000000000))*(x5774)*(x5776)))+(((x5768)*(x5776)))+(((r21)*(x5770)*(x5775)))+(((cj6)*(x5767)*(x5770)))+(((r21)*(x5770)*(x5772)))+(((IkReal(-1.00000000000000))*(r20)*(x5772)*(x5774)))+(((r21)*(sj6)*(x5773)))+(((IkReal(-1.00000000000000))*(x5766)*(x5773)))+(((IkReal(-1.00000000000000))*(sj6)*(x5767)*(x5774)))+(((IkReal(-1.00000000000000))*(cj6)*(x5767)*(x5769)))+(((IkReal(-1.00000000000000))*(x5765)*(x5769)*(x5772)))+(((r20)*(x5768)*(x5772)))+(((IkReal(-1.00000000000000))*(sj6)*(x5765)*(x5771)))+(((x5766)*(x5771)))));
IkReal x5777=(cj6)*(cj6);
IkReal x5778=(sj6)*(sj6);
IkReal x5779=((IkReal(1.00000000000000))*(r21));
IkReal x5780=((cj6)*(r20));
IkReal x5781=((r22)*(sj5));
IkReal x5782=((r01)*(sj0));
IkReal x5783=((r00)*(sj0));
IkReal x5784=((cj0)*(r10));
IkReal x5785=((r02)*(sj0)*(sj5));
IkReal x5786=((cj5)*(x5777));
IkReal x5787=((cj0)*(r12)*(sj5));
IkReal x5788=((IkReal(1.00000000000000))*(cj0)*(r11));
IkReal x5789=((cj5)*(x5778));
IkReal x5790=((r20)*(x5789));
dummyeval[0]=((((x5780)*(x5785)))+(((r20)*(x5782)*(x5786)))+(((sj6)*(x5781)*(x5782)))+(((x5782)*(x5790)))+(((IkReal(-1.00000000000000))*(cj6)*(x5781)*(x5783)))+(((r21)*(x5784)*(x5789)))+(((r21)*(sj6)*(x5787)))+(((IkReal(-1.00000000000000))*(r20)*(x5786)*(x5788)))+(((IkReal(-1.00000000000000))*(sj6)*(x5779)*(x5785)))+(((IkReal(-1.00000000000000))*(x5788)*(x5790)))+(((r21)*(x5784)*(x5786)))+(((IkReal(-1.00000000000000))*(sj6)*(x5781)*(x5788)))+(((IkReal(-1.00000000000000))*(x5779)*(x5783)*(x5786)))+(((IkReal(-1.00000000000000))*(x5780)*(x5787)))+(((cj6)*(x5781)*(x5784)))+(((IkReal(-1.00000000000000))*(x5779)*(x5783)*(x5789))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x5791=((cj5)*(sj6));
IkReal x5792=((cj2)*(r21));
IkReal x5793=((cj5)*(cj6));
IkReal x5794=((IkReal(1.00000000000000))*(cj2)*(r20));
IkReal x5795=((cj0)*(cj1)*(sj2));
IkReal x5796=((IkReal(1.00000000000000))*(cj1)*(sj0)*(sj2));
IkReal x5797=((r10)*(x5795));
if( IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x5795)))+(((sj6)*(x5792)))+(((IkReal(-1.00000000000000))*(cj6)*(x5794)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x5796)))+(((cj1)*(r01)*(sj0)*(sj2)*(sj6)))+(((cj6)*(x5797))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(x5792)*(x5793)))+(((r11)*(x5793)*(x5795)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x5796)))+(((x5791)*(x5797)))+(((IkReal(-1.00000000000000))*(r01)*(x5793)*(x5796)))+(((IkReal(-1.00000000000000))*(r00)*(x5791)*(x5796)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x5791)*(x5794)))+(((r12)*(sj5)*(x5795))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x5795)))+(((sj6)*(x5792)))+(((IkReal(-1.00000000000000))*(cj6)*(x5794)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x5796)))+(((cj1)*(r01)*(sj0)*(sj2)*(sj6)))+(((cj6)*(x5797)))))), ((gconst3)*(((((IkReal(-1.00000000000000))*(x5792)*(x5793)))+(((r11)*(x5793)*(x5795)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x5796)))+(((x5791)*(x5797)))+(((IkReal(-1.00000000000000))*(r01)*(x5793)*(x5796)))+(((IkReal(-1.00000000000000))*(r00)*(x5791)*(x5796)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x5791)*(x5794)))+(((r12)*(sj5)*(x5795)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x5798=IKsin(j4);
IkReal x5799=IKcos(j4);
IkReal x5800=((r00)*(sj6));
IkReal x5801=((IkReal(1.00000000000000))*(r12));
IkReal x5802=((IkReal(1.00000000000000))*(cj6));
IkReal x5803=((cj6)*(r01));
IkReal x5804=((IkReal(1.00000000000000))*(cj1));
IkReal x5805=((cj2)*(cj3));
IkReal x5806=((IkReal(1.00000000000000))*(sj1));
IkReal x5807=((r11)*(sj6));
IkReal x5808=((r01)*(sj6));
IkReal x5809=((IkReal(1.00000000000000))*(cj5));
IkReal x5810=((r10)*(sj6));
IkReal x5811=((cj5)*(r11));
IkReal x5812=((cj6)*(r00));
IkReal x5813=((r21)*(sj6));
IkReal x5814=((r02)*(sj5));
IkReal x5815=((cj6)*(r10));
IkReal x5816=((cj5)*(sj6));
IkReal x5817=((cj5)*(r01));
IkReal x5818=((sj5)*(x5798));
IkReal x5819=((cj0)*(x5799));
IkReal x5820=((cj0)*(x5798));
IkReal x5821=((sj0)*(x5799));
IkReal x5822=((sj0)*(x5798));
IkReal x5823=((r20)*(x5799));
IkReal x5824=((cj5)*(cj6)*(r21));
IkReal x5825=((r20)*(x5798));
IkReal x5826=((cj5)*(x5822));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x5804)))+(((x5816)*(x5825)))+(((r22)*(x5818)))+(((IkReal(-1.00000000000000))*(x5802)*(x5823)))+(((x5798)*(x5824)))+(((x5799)*(x5813))));
evalcond[1]=((((x5799)*(x5824)))+(((IkReal(-1.00000000000000))*(sj3)*(x5806)))+(((cj1)*(x5805)))+(((r22)*(sj5)*(x5799)))+(((IkReal(-1.00000000000000))*(x5798)*(x5813)))+(((x5816)*(x5823)))+(((cj6)*(x5825))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x5802)*(x5821)))+(((IkReal(-1.00000000000000))*(cj0)*(x5801)*(x5818)))+(((IkReal(-1.00000000000000))*(x5802)*(x5811)*(x5820)))+(((x5808)*(x5821)))+(cj2)+(((x5803)*(x5826)))+(((IkReal(-1.00000000000000))*(x5809)*(x5810)*(x5820)))+(((x5800)*(x5826)))+(((x5815)*(x5819)))+(((IkReal(-1.00000000000000))*(x5807)*(x5819)))+(((x5814)*(x5822))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x5802)*(x5820)))+(((cj5)*(x5803)*(x5821)))+(((IkReal(-1.00000000000000))*(sj5)*(x5801)*(x5819)))+(((x5807)*(x5820)))+(((IkReal(-1.00000000000000))*(x5808)*(x5822)))+(((x5814)*(x5821)))+(((x5812)*(x5822)))+(((IkReal(-1.00000000000000))*(x5809)*(x5810)*(x5819)))+(((cj3)*(sj2)))+(((cj5)*(x5800)*(x5821)))+(((IkReal(-1.00000000000000))*(x5802)*(x5811)*(x5819))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x5809)*(x5810)*(x5822)))+(((x5815)*(x5821)))+(((IkReal(-1.00000000000000))*(x5814)*(x5820)))+(((IkReal(-1.00000000000000))*(x5808)*(x5819)))+(((x5812)*(x5819)))+(((IkReal(-1.00000000000000))*(sj0)*(x5801)*(x5818)))+(((IkReal(-1.00000000000000))*(x5807)*(x5821)))+(((IkReal(-1.00000000000000))*(x5800)*(x5809)*(x5820)))+(((sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x5802)*(x5811)*(x5822)))+(((IkReal(-1.00000000000000))*(x5802)*(x5817)*(x5820))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj5)*(x5801)*(x5821)))+(((IkReal(-1.00000000000000))*(x5802)*(x5817)*(x5819)))+(((IkReal(-1.00000000000000))*(x5805)*(x5806)))+(((IkReal(-1.00000000000000))*(x5814)*(x5819)))+(((IkReal(-1.00000000000000))*(r10)*(x5802)*(x5822)))+(((IkReal(-1.00000000000000))*(x5809)*(x5810)*(x5821)))+(((IkReal(-1.00000000000000))*(x5802)*(x5811)*(x5821)))+(((x5808)*(x5820)))+(((IkReal(-1.00000000000000))*(r00)*(x5802)*(x5820)))+(((x5807)*(x5822)))+(((IkReal(-1.00000000000000))*(sj3)*(x5804)))+(((IkReal(-1.00000000000000))*(x5800)*(x5809)*(x5819))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x5827=((cj1)*(sj2));
IkReal x5828=((cj6)*(r20));
IkReal x5829=((sj1)*(sj3));
IkReal x5830=((r21)*(sj6));
IkReal x5831=((IkReal(1.00000000000000))*(cj5));
IkReal x5832=((cj6)*(r21));
IkReal x5833=((r20)*(sj6));
IkReal x5834=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x5835=((cj1)*(cj2)*(cj3));
if( IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x5827)*(x5831)*(x5832)))+(((x5828)*(x5835)))+(((IkReal(-1.00000000000000))*(x5827)*(x5831)*(x5833)))+(((IkReal(-1.00000000000000))*