/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.epsilon.emc.emf.ContainmentChangeAdapter;
import org.eclipse.epsilon.emc.emf.EmfModelResourceFactory;
import org.eclipse.epsilon.emc.emf.EmfModelResourceSet;
import org.eclipse.epsilon.emc.emf.EmfPropertyGetter;
import org.eclipse.epsilon.emc.emf.EmfPropertySetter;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emc.emf.transactions.EmfModelTransactionSupport;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IAdaptableModel;
import org.eclipse.epsilon.eol.models.IComparableModel;
import org.eclipse.epsilon.eol.models.transactions.IModelTransactionSupport;

public abstract class AbstractEmfModel
extends CachedModel<EObject>
implements IComparableModel {
    protected Resource modelImpl;
    protected boolean expand = true;
    Map<String, EClass> eClassCache = new HashMap<String, EClass>();
    protected EmfModelTransactionSupport transactionSupport;

    protected InputStream getInputStream(String file) throws IOException {
        if (file.startsWith("bundleresource:") || file.startsWith("platform:")) {
            URL url = new URL(file);
            return url.openConnection().getInputStream();
        }
        return new FileInputStream(file);
    }

    protected void setDataTypesInstanceClasses(Resource metamodel) {
        TreeIterator it = metamodel.getAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (eObject instanceof EEnum || !(eObject instanceof EDataType)) continue;
            EDataType eDataType = (EDataType)eObject;
            String instanceClass = "";
            if (eDataType.getName().equals("String")) {
                instanceClass = "java.lang.String";
            } else if (eDataType.getName().equals("Boolean")) {
                instanceClass = "java.lang.Boolean";
            } else if (eDataType.getName().equals("Integer")) {
                instanceClass = "java.lang.Integer";
            } else if (eDataType.getName().equals("Float")) {
                instanceClass = "java.lang.Float";
            } else if (eDataType.getName().equals("Double")) {
                instanceClass = "java.lang.Double";
            }
            eDataType.setInstanceClassName(instanceClass);
        }
    }

    public void addMetamodelUri(String nsUri) {
        this.modelImpl.getResourceSet().getPackageRegistry().put((Object)nsUri, EPackage.Registry.INSTANCE.get((Object)nsUri));
    }

    protected EPackage.Registry getPackageRegistry() {
        return this.modelImpl.getResourceSet().getPackageRegistry();
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        for (Object pkg : this.getPackageRegistry().values()) {
            if (!(pkg instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)pkg;
            for (EClassifier classifier : EmfUtil.getAllEClassifiers(ePackage)) {
                EEnum eEnum;
                EEnumLiteral literal;
                if (!(classifier instanceof EEnum) || !((EEnum)classifier).getName().equals(enumeration) && !this.getFullyQualifiedName(classifier).equals(enumeration) || (literal = (eEnum = (EEnum)classifier).getEEnumLiteral(label)) == null) continue;
                return literal.getInstance();
            }
        }
        throw new EolEnumerationValueNotFoundException(enumeration, label, this.getName());
    }

    public boolean knowsAboutProperty(Object instance, String property) {
        if (!this.owns(instance)) {
            return false;
        }
        EObject eObject = (EObject)instance;
        return this.knowsAboutProperty(eObject, property);
    }

    protected boolean knowsAboutProperty(EObject instance, String property) {
        return EmfUtil.getEStructuralFeature(instance.eClass(), property) != null;
    }

    protected Collection<EObject> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(type);
        ArrayList<EObject> allOfType = new ArrayList<EObject>();
        for (EObject eObject : this.allContents()) {
            if (eObject.eClass() != eClass) continue;
            allOfType.add(eObject);
        }
        return allOfType;
    }

    public Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return this.classForName(type);
    }

    public EClass classForName(String name) throws EolModelElementTypeNotFoundException {
        if (name != null) {
            if (this.eClassCache.containsKey(name)) {
                return this.eClassCache.get(name);
            }
            EClass eClass = this.classForName(name, this.getPackageRegistry());
            if (eClass != null) {
                this.eClassCache.put(name, eClass);
                return eClass;
            }
        }
        throw new EolModelElementTypeNotFoundException(this.name, name);
    }

    protected EClass classForName(String name, EPackage.Registry registry) {
        boolean absolute = name.indexOf("::") > -1;
        for (Object pkg : registry.values()) {
            if (!(pkg instanceof EPackage)) continue;
            for (EClassifier eClassifier : EmfUtil.getAllEClassifiers((EPackage)pkg)) {
                if (!(eClassifier instanceof EClass)) continue;
                String eClassifierName = "";
                eClassifierName = absolute ? this.getFullyQualifiedName(eClassifier) : eClassifier.getName();
                if (eClassifierName.compareTo(name) != 0) continue;
                return (EClass)eClassifier;
            }
        }
        return null;
    }

    protected Collection<EObject> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(kind);
        ArrayList<EObject> allOfKind = new ArrayList<EObject>();
        for (EObject eObject : this.allContents()) {
            if (!eClass.isInstance((Object)eObject)) continue;
            allOfKind.add(eObject);
        }
        return allOfKind;
    }

    protected Collection<EObject> allContentsFromModel() {
        ArrayList<EObject> allInstances = new ArrayList<EObject>();
        if (!this.expand) {
            TreeIterator it = this.modelImpl.getAllContents();
            while (it.hasNext()) {
                allInstances.add((EObject)it.next());
            }
        } else {
            EList resources;
            if (this.modelImpl.getResourceSet() == null) {
                resources = new ArrayList();
                resources.add(this.modelImpl);
            } else {
                resources = this.modelImpl.getResourceSet().getResources();
            }
            for (Resource resource : resources) {
                TreeIterator it = resource.getAllContents();
                while (it.hasNext()) {
                    allInstances.add((EObject)it.next());
                }
            }
        }
        return allInstances;
    }

    protected EObject createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        EClass eClass = this.classForName(type);
        if (eClass.isAbstract()) {
            throw new EolNotInstantiableModelElementTypeException(this.name, type);
        }
        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.modelImpl.getContents().add((Object)instance);
        instance.eAdapters().add((Object)new ContainmentChangeAdapter(instance, this.modelImpl));
        return instance;
    }

    public IModelTransactionSupport getTransactionSupport() {
        if (this.transactionSupport == null) {
            this.transactionSupport = new EmfModelTransactionSupport(this);
        }
        return this.transactionSupport;
    }

    protected int instancesCount(Resource r) {
        int i = 0;
        TreeIterator ite = r.getAllContents();
        while (ite.hasNext()) {
            ite.next();
            ++i;
        }
        return i;
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        if (!(instance instanceof EObject)) {
            return false;
        }
        EObject eObject = (EObject)instance;
        EcoreUtil.delete((EObject)eObject);
        ArrayList<EObject> contents = new ArrayList<EObject>();
        TreeIterator contentsIterator = eObject.eAllContents();
        while (contentsIterator.hasNext()) {
            contents.add((EObject)contentsIterator.next());
        }
        for (EObject content : contents) {
            this.deleteElement(content);
        }
        contents.clear();
        return true;
    }

    public boolean owns(Object instance) {
        if (instance instanceof EObject) {
            EObject eObject = (EObject)instance;
            if (this.expand) {
                return EcoreUtil.isAncestor((ResourceSet)this.modelImpl.getResourceSet(), (EObject)eObject);
            }
            return EcoreUtil.isAncestor((Resource)this.modelImpl, (EObject)eObject);
        }
        return false;
    }

    public boolean store(String fileName) {
        return this.store(EmfUtil.createPlatformResourceURI(fileName));
    }

    public boolean store(URI uri) {
        URI oldUri = this.modelImpl.getURI();
        try {
            try {
                this.modelImpl.setURI(uri);
                this.modelImpl.save(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.modelImpl.setURI(oldUri);
                return false;
            }
        }
        finally {
            this.modelImpl.setURI(oldUri);
        }
        return true;
    }

    public void disposeModel() {
        if (this.modelImpl != null) {
            EmfModelResourceFactory.getInstance().removeCachedResource(this.modelImpl.getURI());
            this.modelImpl = null;
        }
        this.eClassCache.clear();
    }

    public Resource getResource() {
        return this.modelImpl;
    }

    public void setResource(Resource resource) {
        this.modelImpl = resource;
    }

    public Resource getModelImpl() {
        return this.modelImpl;
    }

    public void setModelImpl(Resource modelImpl) {
        this.modelImpl = modelImpl;
    }

    public Object getElementById(String id) {
        for (Resource resource : this.modelImpl.getResourceSet().getResources()) {
            EObject instance = resource.getEObject(id);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    public String getElementId(Object instance) {
        String id;
        EObject eObject = (EObject)instance;
        if (eObject.eResource() instanceof XMIResource && (id = ((XMIResource)eObject.eResource()).getID(eObject)) != null && id.trim().length() > 0) {
            return id;
        }
        if (eObject.eResource() instanceof XMLResource) {
            return ((XMLResource)eObject.eResource()).getURIFragment(eObject);
        }
        return "";
    }

    public void setElementId(Object instance, String newId) {
        if (newId == null || newId.isEmpty()) {
            return;
        }
        if (this.isUriFragment(newId)) {
            return;
        }
        EObject eObject = (EObject)instance;
        if (eObject.eResource() instanceof XMIResource) {
            ((XMIResource)eObject.eResource()).setID(eObject, newId);
        }
    }

    private boolean isUriFragment(String newId) {
        return newId.startsWith("/") || newId.startsWith("#/");
    }

    public IPropertyGetter getPropertyGetter() {
        return new EmfPropertyGetter();
    }

    public IPropertySetter getPropertySetter() {
        return new EmfPropertySetter();
    }

    public Object getTypeOf(Object instance) {
        return ((EObject)instance).eClass();
    }

    public String getTypeNameOf(Object instance) {
        if (!this.isModelElement(instance)) {
            throw new IllegalArgumentException("Not a valid EMF model element: " + instance + " (" + instance.getClass().getCanonicalName() + ") ");
        }
        return ((EClass)this.getTypeOf(instance)).getName();
    }

    public Collection<String> getAllTypeNamesOf(Object instance) {
        ArrayList<String> allTypeNames = new ArrayList<String>();
        if (this.isModelElement(instance)) {
            EClass type = (EClass)this.getTypeOf(instance);
            allTypeNames.add(type.getName());
            for (EClass supertype : type.getEAllSuperTypes()) {
                allTypeNames.add(supertype.getName());
            }
        }
        return allTypeNames;
    }

    public boolean isInstantiable(String type) {
        try {
            return !this.classForName(type).isAbstract();
        }
        catch (EolModelElementTypeNotFoundException eolModelElementTypeNotFoundException) {
            return false;
        }
    }

    public boolean hasType(String type) {
        block3: {
            try {
                if (!this.eClassCache.containsKey(type)) break block3;
                return true;
            }
            catch (EolModelElementTypeNotFoundException eolModelElementTypeNotFoundException) {
                return false;
            }
        }
        this.classForName(type);
        return true;
    }

    protected String getFullyQualifiedName(EClassifier eClassifier) {
        String fullyQualifiedName = eClassifier.getName();
        EPackage parent = eClassifier.getEPackage();
        while (parent != null) {
            fullyQualifiedName = String.valueOf(parent.getName()) + "::" + fullyQualifiedName;
            parent = parent.getESuperPackage();
        }
        return fullyQualifiedName;
    }

    public boolean isModelElement(Object instance) {
        return instance instanceof EObject;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(metaClass);
        return eClass.isInstance(instance);
    }

    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(metaClass);
        if (instance instanceof EObject) {
            EObject eObject = (EObject)instance;
            return eClass == eObject.eClass();
        }
        return false;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    public Object computeDifferencesWith(IComparableModel model) throws IOException, InterruptedException {
        if (model instanceof IAdaptableModel) {
            IAdaptableModel adapModel = (IAdaptableModel)model;
            model = (IComparableModel)adapModel.adaptTo(AbstractEmfModel.class);
        }
        if (!(model instanceof AbstractEmfModel)) {
            throw new IllegalArgumentException("Cannot compare an EMF model with a non-EMF model");
        }
        AbstractEmfModel other = (AbstractEmfModel)model;
        ResourceSet myResourceSet = this.cloneToTmpFiles(this.getResource().getResourceSet());
        ResourceSet otherResourceSet = this.cloneToTmpFiles(other.getResource().getResourceSet());
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("match.ignore.xmi.id", true);
        MatchResourceSet match = MatchService.doResourceSetMatch((ResourceSet)myResourceSet, (ResourceSet)otherResourceSet, options);
        DiffResourceSet diff = DiffService.doDiff((MatchResourceSet)match);
        boolean bAnyDifferences = false;
        for (DiffModel diffModel : diff.getDiffModels()) {
            if (diffModel.getDifferences().isEmpty()) continue;
            bAnyDifferences = true;
        }
        if (!bAnyDifferences) {
            return null;
        }
        ComparisonResourceSetSnapshot snap = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
        snap.setDate(new Date());
        snap.setDiffResourceSet(diff);
        snap.setMatchResourceSet(match);
        return snap;
    }

    /*
     * Unable to fully structure code
     */
    private ResourceSet cloneToTmpFiles(ResourceSet resourceSet) throws IOException {
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        newResourceSet = new EmfModelResourceSet();
        originalURIMap = new HashMap<Resource, URI>();
        for (Resource res : resourceSet.getResources()) {
            if ("platform".equals(res.getURI().scheme())) continue;
            originalURIMap.put(res, res.getURI());
        }
        try {
            for (Resource res : originalURIMap.keySet()) {
                tmpFile = File.createTempFile(String.valueOf(res.getURI().lastSegment()) + ".", ".model");
                res.setURI(URI.createFileURI((String)tmpFile.getAbsolutePath()));
            }
            newResources = new ArrayList<Resource>(originalURIMap.size());
            for (Resource res : originalURIMap.keySet()) {
                res.save(Collections.EMPTY_MAP);
                newResource = newResourceSet.createResource(res.getURI());
                newResources.add(newResource);
            }
            newResourceSet.setPackageRegistry(resourceSet.getPackageRegistry());
            for (Resource res : newResources) {
                res.load(null);
                EcoreUtil.resolveAll((Resource)res);
            }
        }
        finally {
            ** for (entry : originalURIMap.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            ((Resource)entry.getKey()).setURI((URI)entry.getValue());
            continue;
        }
lbl31:
        // 1 sources

        return newResourceSet;
    }
}

