/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.epsilon.commons.util.UriUtil;
import org.eclipse.epsilon.egl.EglPersistentTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.NullFormatter;
import org.eclipse.epsilon.egl.merge.output.ProtectedRegion;
import org.eclipse.epsilon.egl.output.Writer;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecificationFactory;
import org.eclipse.epsilon.egl.status.ProtectedRegionWarning;
import org.eclipse.epsilon.egl.traceability.OutputFile;
import org.eclipse.epsilon.egl.util.FileUtil;

public class EglFileGeneratingTemplate
extends EglPersistentTemplate {
    private String currentOutputPath;
    private OutputFile currentOutputFile;

    protected EglFileGeneratingTemplate(URI path, IEglContext context, URI outputRoot) throws Exception {
        this(new EglTemplateSpecificationFactory(new NullFormatter()).fromResource(path.toString(), path), context, outputRoot, outputRoot.getPath());
    }

    public EglFileGeneratingTemplate(EglTemplateSpecification spec, IEglContext context, URI outputRoot, String outputRootPath) throws Exception {
        super(spec, context, outputRoot, outputRootPath);
    }

    @Override
    protected void doGenerate(File target, String targetName, boolean overwrite, boolean protectRegions) throws EglRuntimeException {
        this.currentOutputPath = target.getAbsolutePath();
        try {
            if (protectRegions && target.exists()) {
                String merged = this.merge(FileUtil.read(target));
                this.write(target, targetName, merged, "Protected regions of " + targetName + " were preserved.");
                for (ProtectedRegion pr : this.module.getContext().getPartitioner().partition(merged).getProtectedRegions()) {
                    this.currentOutputFile.addProtectedRegion(pr.getId(), pr.isEnabled(), pr.getOffset());
                }
            } else {
                this.write(target, targetName, this.getContents(), "Successfully wrote to " + targetName);
            }
        }
        catch (IOException ex) {
            throw new EglRuntimeException("Could not generate to " + targetName, ex, this.module.getAst());
        }
    }

    private void write(File target, String targetName, String contents, String message) throws EglRuntimeException {
        try {
            new Writer(target, contents).write();
            this.addMessage(message);
            this.currentOutputFile = this.template.addOutputFile(targetName, UriUtil.fileToUri((File)target));
        }
        catch (IOException ex) {
            throw new EglRuntimeException("Could not write to " + target, ex, this.module.getAst());
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + target, e, this.module.getAst());
        }
    }

    @Override
    protected void addProtectedRegionWarning(ProtectedRegionWarning warning) {
        super.addProtectedRegionWarning(new ProtectedRegionWarning(warning.getId(), this.currentOutputPath));
    }
}

