/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.epsilon.egl.AbstractEglTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.CompositeFormatter;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.formatter.NullFormatter;
import org.eclipse.epsilon.egl.internal.EglModule;
import org.eclipse.epsilon.egl.merge.DefaultMerger;
import org.eclipse.epsilon.egl.merge.Merger;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecificationFactory;
import org.eclipse.epsilon.egl.status.ProtectedRegionWarning;
import org.eclipse.epsilon.egl.traceability.Template;

public class EglTemplate
extends AbstractEglTemplate {
    protected final String name;
    protected final Template template;
    private Formatter formatter;
    private String contents = "";
    private boolean processed = false;

    protected EglTemplate(URI path, IEglContext context) throws Exception {
        this(new EglTemplateSpecificationFactory(new NullFormatter()).fromResource(path.toString(), path), context);
    }

    public EglTemplate(EglTemplateSpecification spec, IEglContext context) throws Exception {
        this(spec.getName(), context, spec.createTemplate(), spec.getDefaultFormatter());
        spec.parseInto(this.module);
    }

    private EglTemplate(String name, IEglContext context, Template template, Formatter postprocessor) {
        super(new EglModule(context));
        this.name = name;
        this.template = template;
        this.formatter = postprocessor;
    }

    public String getName() {
        return this.name;
    }

    public void populate(String name, Object value) {
        this.template.addVariable(name, value);
    }

    public String process() throws EglRuntimeException {
        this.contents = this.module.execute(this.template, this.formatter);
        this.processed = true;
        return this.contents;
    }

    public String merge(String existing) throws EglRuntimeException {
        if (!this.isProcessed()) {
            this.process();
        }
        DefaultMerger merger = new DefaultMerger(this.module.getContext().getPartitioner(), this.contents, existing);
        String result = ((Merger)merger).merge();
        for (ProtectedRegionWarning warning : merger.getMergeWarnings()) {
            this.addProtectedRegionWarning(warning);
        }
        return result;
    }

    protected void addProtectedRegionWarning(ProtectedRegionWarning warning) {
        this.module.getContext().addStatusMessage(warning);
    }

    protected String getContents() {
        return this.contents;
    }

    protected boolean isProcessed() {
        return this.processed;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public void setFormatters(Formatter ... formatters) {
        this.setFormatters(Arrays.asList(formatters));
    }

    public void setFormatters(Collection<Formatter> formatters) {
        this.setFormatter(new CompositeFormatter(formatters));
    }
}

