/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.eol.EolModelDefinition;
import org.eclipse.epsilon.eol.EolModelGroupDefinition;
import org.eclipse.epsilon.eol.EolOperationFactory;
import org.eclipse.epsilon.eol.EolOperations;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class EglTemplateFactoryModuleAdapter
implements IEolExecutableModule {
    private final EglTemplateFactory factory;
    private EglTemplate current;

    public EglTemplateFactoryModuleAdapter(EglTemplateFactory factory) {
        this.factory = factory;
    }

    public boolean parse(File file) throws Exception {
        this.current = this.factory.load(file);
        return this.getParseProblems().isEmpty();
    }

    public boolean parse(URI uri) throws Exception {
        this.current = this.factory.load(uri);
        return this.getParseProblems().isEmpty();
    }

    public boolean parse(String code) throws Exception {
        this.current = this.factory.prepare(code);
        return this.getParseProblems().isEmpty();
    }

    public boolean parse(String code, File file) throws Exception {
        this.current = this.factory.load(code, file);
        return this.current.getParseProblems().isEmpty();
    }

    public List<ParseProblem> getParseProblems() {
        return this.current == null ? new LinkedList() : this.current.getParseProblems();
    }

    public Object execute() throws EolRuntimeException {
        return this.current == null ? null : this.current.process();
    }

    public AST getAst() {
        return this.current == null ? null : this.current.getAst();
    }

    public void reset() {
        this.current = null;
    }

    public void buildModel() throws Exception {
    }

    public List<?> getChildren() {
        return this.current == null ? Collections.EMPTY_LIST : this.current.getChildren();
    }

    public IEglContext getContext() {
        return this.factory.getContext();
    }

    public List<EolModelDefinition> getDeclaredModelDefinitions() {
        return this.current.getDeclaredModelDefinitions();
    }

    public List<EolModelGroupDefinition> getDeclaredModelGroupDefinitions() {
        return this.current.getDeclaredModelGroupDefinitions();
    }

    public EolOperations getDeclaredOperations() {
        return this.current.getDeclaredOperations();
    }

    public List<?> getImports() {
        return this.current.getImports();
    }

    public Set<EolModelDefinition> getModelDefinitions() {
        return this.current.getModelDefinitions();
    }

    public Set<EolModelGroupDefinition> getModelGroupDefinitions() {
        return this.current.getModelGroupDefinitions();
    }

    public EolOperationFactory getOperationFactory() {
        return this.current.getOperationFactory();
    }

    public EolOperations getOperations() {
        return this.current.getOperations();
    }

    public void setOperationFactory(EolOperationFactory operationFactory) {
        this.current.setOperationFactory(operationFactory);
    }

    public void setDefaultFormatters(Collection<Formatter> defaultFormatters) {
        this.factory.setDefaultFormatters(defaultFormatters);
    }
}

