/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.epsilon.egl.config.ConfigFileReader;
import org.eclipse.epsilon.egl.config.PersistenceException;
import org.eclipse.epsilon.egl.merge.partition.CommentBlockPartitioner;
import org.eclipse.epsilon.egl.merge.partition.CompositePartitioner;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfigFileReader
extends DefaultHandler
implements ConfigFileReader {
    private final String DTD_FILE_NAME = "ContentTypes.dtd";
    private final String DTD_URL = "http://www.epsilon.org/egl/ContentTypes.dtd";
    private final String ROOT_ELEMENT = "ContentTypes";
    private final Map<String, CompositePartitioner> contentTypes = new HashMap<String, CompositePartitioner>();
    private boolean correctRootFound = false;
    private String currentContentType;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, CompositePartitioner> read(InputStream stream) throws PersistenceException {
        Map<String, CompositePartitioner> map;
        try {
            this.correctRootFound = false;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.getXMLReader().setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals("http://www.epsilon.org/egl/ContentTypes.dtd")) {
                        return new InputSource(XMLConfigFileReader.class.getResourceAsStream("ContentTypes.dtd"));
                    }
                    return null;
                }
            });
            parser.getXMLReader().setErrorHandler(this);
            parser.getXMLReader().setContentHandler(this);
            parser.getXMLReader().parse(new InputSource(stream));
            if (!this.correctRootFound) {
                throw new PersistenceException("Did not find the expected root element: ContentTypes");
            }
            map = this.contentTypes;
        }
        catch (SAXParseException e) {
            try {
                String message = "Parse error at line " + e.getLineNumber() + ", " + "column " + e.getColumnNumber() + ":\n\n" + e.getMessage();
                throw new PersistenceException(message, e);
                catch (SAXException e2) {
                    throw new PersistenceException(e2);
                }
                catch (IOException e3) {
                    throw new PersistenceException(e3);
                }
                catch (ParserConfigurationException e4) {
                    throw new PersistenceException(e4);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (stream == null) return map;
            stream.close();
            return map;
        }
        catch (IOException iOException) {}
        return map;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("ContentTypes")) {
            this.correctRootFound = true;
        } else if (this.correctRootFound && qName.equals("ContentType")) {
            this.currentContentType = attributes.getValue("name");
            this.contentTypes.put(this.currentContentType, new CompositePartitioner(new CommentBlockPartitioner[0]));
        } else if (this.correctRootFound && qName.equals("CommentStyle")) {
            String startsWith = attributes.getValue("startsWith");
            String endsWith = attributes.getValue("endsWith");
            CommentBlockPartitioner partitioner = new CommentBlockPartitioner(startsWith, endsWith);
            if (this.currentContentType != null) {
                this.contentTypes.get(this.currentContentType).addPartitioner(partitioner);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.correctRootFound && qName.equals("ContentType")) {
            this.currentContentType = null;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }
}

