/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.internal;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.exceptions.EglStoppedException;
import org.eclipse.epsilon.egl.internal.EglModule;
import org.eclipse.epsilon.egl.internal.EglOperationFactory;
import org.eclipse.epsilon.egl.parse.problem.EglParseProblem;
import org.eclipse.epsilon.egl.preprocessor.Preprocessor;
import org.eclipse.epsilon.eol.EolLibraryModule;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class EglPreprocessorModule
extends EolModule {
    private final Preprocessor preprocessor = new Preprocessor();
    private static final HashMap<String, Class<?>> importConfiguration = new HashMap();

    static {
        importConfiguration.put("eol", EolLibraryModule.class);
        importConfiguration.put("egl", EglModule.class);
    }

    public boolean preprocess(AST ast, File sourceFile, URI sourceUri) {
        this.sourceFile = sourceFile;
        this.sourceUri = sourceUri;
        String eol = this.preprocessor.convertToEol(ast);
        try {
            this.setOperationFactory(new EglOperationFactory());
            if (this.parse(eol, sourceFile)) {
                this.updateASTLocations(this.ast);
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void updateASTLocations(AST ast) {
        ast.setColumn(this.preprocessor.getTrace().getEglColumnNumberFor(ast.getLine(), ast.getColumn()));
        ast.setLine(this.preprocessor.getTrace().getEglLineNumberFor(ast.getLine()));
        for (AST child : ast.getChildren()) {
            this.updateASTLocations(child);
        }
    }

    public Object execute() throws EglRuntimeException {
        try {
            return super.execute();
        }
        catch (EolInternalException ex) {
            if (ex.getInternal() instanceof EglStoppedException) {
                return null;
            }
            if (ex.getInternal() instanceof EglRuntimeException) {
                throw new EglRuntimeException(ex);
            }
            throw new EglRuntimeException("Error encountered whilst processing template.", ex);
        }
        catch (EolRuntimeException ex) {
            if (ex instanceof EglRuntimeException) {
                throw (EglRuntimeException)ex;
            }
            throw new EglRuntimeException(ex);
        }
    }

    public List<ParseProblem> getParseProblems() {
        List parseProblems = super.getParseProblems();
        int index = 0;
        while (index < parseProblems.size()) {
            ParseProblem problem = (ParseProblem)parseProblems.get(index);
            if (!(problem instanceof EglParseProblem)) {
                parseProblems.remove(index);
                parseProblems.add(index, new EglParseProblem(problem, this.preprocessor.getTrace()));
            }
            ++index;
        }
        return parseProblems;
    }

    public final HashMap<String, Class<?>> getImportConfiguration() {
        return importConfiguration;
    }
}

