/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.parse;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.commons.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.parse.EglLexer;
import org.eclipse.epsilon.egl.parse.RecognitionException;
import org.eclipse.epsilon.egl.parse.Token;

public class EglParser {
    private final EglLexer lexer;
    private final List<ParseProblem> problems = new LinkedList<ParseProblem>();
    private final EpsilonTreeAdaptor astFactory;
    private ParseProblem lastError = null;
    private Token current;
    private AST ast;

    public EglParser(EglLexer lexer, EpsilonTreeAdaptor astFactory) {
        if (lexer == null) {
            throw new NullPointerException("program cannot be null");
        }
        this.lexer = lexer;
        this.astFactory = astFactory;
        this.ast = this.createAST(Token.TokenType.PROGRAM, "", 1, 1);
    }

    public AST getAST() {
        return this.ast;
    }

    public List<ParseProblem> getParseProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public boolean parse() {
        try {
            this.nextToken();
            return this.parseProgram();
        }
        catch (RecognitionException e) {
            this.problems.add(new ParseProblem(e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
            return false;
        }
    }

    private void nextToken() throws RecognitionException {
        this.current = this.lexer.nextToken();
    }

    private boolean parseProgram() throws RecognitionException {
        while (true) {
            if (this.current.getTokenType() == Token.TokenType.EOF) {
                return true;
            }
            AST commentedAst = this.parseCommented();
            if (commentedAst != null) {
                this.ast.addChild((Tree)commentedAst);
                continue;
            }
            AST taggedAst = this.parseTagged();
            if (taggedAst != null) {
                this.ast.addChild((Tree)taggedAst);
                continue;
            }
            AST textAst = this.parseText();
            if (textAst == null) break;
            this.ast.addChild((Tree)textAst);
        }
        return false;
    }

    private AST parseText() throws RecognitionException {
        StringBuilder text = new StringBuilder();
        int line = -1;
        int col = -1;
        while (this.current.getTokenType() == Token.TokenType.PLAIN_TEXT) {
            if (line == -1) {
                line = this.current.getLine();
                col = this.current.getColumn();
            }
            text.append(this.current.getText());
            this.nextToken();
        }
        if (text.toString().length() > 0) {
            return this.createAST(Token.TokenType.PLAIN_TEXT, text.toString(), line, col);
        }
        if (this.current.getTokenType() == Token.TokenType.NEW_LINE) {
            AST newLineAST = this.createAST(this.current);
            this.nextToken();
            return newLineAST;
        }
        this.reportError(Token.TokenType.PLAIN_TEXT);
        return null;
    }

    private AST parseTagged() throws RecognitionException {
        Token startTagToken = this.current;
        if (this.current.getTokenType() != Token.TokenType.START_TAG && this.current.getTokenType() != Token.TokenType.START_OUTPUT_TAG) {
            return null;
        }
        this.nextToken();
        LinkedList<AST> textAsts = new LinkedList<AST>();
        AST next = null;
        do {
            if ((next = this.parseText()) == null) continue;
            textAsts.add(next);
        } while (next != null && this.current.getTokenType() != Token.TokenType.END_TAG);
        if (textAsts.size() == 0) {
            return null;
        }
        if (this.current.getTokenType() == Token.TokenType.END_TAG) {
            AST endTag = this.createAST(this.current);
            AST taggedAst = this.createAST(startTagToken);
            for (AST textAst : textAsts) {
                taggedAst.addChild((Tree)textAst);
            }
            taggedAst.addChild((Tree)endTag);
            this.nextToken();
            return taggedAst;
        }
        return null;
    }

    private AST parseCommented() throws RecognitionException {
        Token startCommentTagToken = this.current;
        if (this.current.getTokenType() != Token.TokenType.START_COMMENT_TAG) {
            return null;
        }
        this.nextToken();
        StringBuilder commentContents = new StringBuilder();
        while (this.current != null && this.current.getTokenType() != Token.TokenType.END_COMMENT_TAG && this.current.getTokenType() != Token.TokenType.EOF) {
            commentContents.append(this.current.getText());
            this.nextToken();
        }
        if (this.current.getTokenType() == Token.TokenType.END_COMMENT_TAG) {
            AST endCommentTag = this.createAST(this.current);
            AST commentedAst = this.createAST(startCommentTagToken);
            if (commentContents.toString().length() > 0) {
                commentedAst.addChild((Tree)this.createAST(Token.TokenType.PLAIN_TEXT, commentContents.toString(), startCommentTagToken.getLine(), startCommentTagToken.getColumn() + startCommentTagToken.getText().length()));
            }
            commentedAst.addChild((Tree)endCommentTag);
            this.nextToken();
            return commentedAst;
        }
        return null;
    }

    private AST createAST(Token t) {
        return this.astFactory.create((org.antlr.runtime.Token)t);
    }

    private AST createAST(Token.TokenType type, String text, int line, int col) {
        return this.astFactory.create((org.antlr.runtime.Token)new Token(type, text, line, col));
    }

    private void reportError(Token.TokenType expectedType) {
        if (this.lastError == null || this.lastError.getColumn() != this.current.getColumn() || this.lastError.getLine() != this.current.getLine()) {
            this.lastError = new ParseProblem(this.current.getLine(), this.current.getColumn(), "Unexpected token '" + (Object)((Object)this.current.getTokenType()) + "' " + "(was expecting '" + (Object)((Object)expectedType) + "')");
            this.problems.add(this.lastError);
        }
    }
}

