/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.traceability;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.commons.util.UriUtil;
import org.eclipse.epsilon.egl.traceability.Container;
import org.eclipse.epsilon.egl.traceability.Content;
import org.eclipse.epsilon.egl.traceability.OutputFile;
import org.eclipse.epsilon.egl.traceability.Variable;

public class Template
extends Container<Content<Template>> {
    private final List<Variable> variables = new LinkedList<Variable>();

    public Template() {
        this(null, "", null);
    }

    public Template(URI uri) {
        this(null, uri == null ? "" : UriUtil.getName((URI)uri), uri);
    }

    public Template(String name) {
        this(name, null);
    }

    public Template(String name, URI uri) {
        this(null, name, uri);
    }

    protected Template(Template parent, String name, URI uri) {
        super(parent, name, uri);
    }

    public OutputFile addOutputFile(String name, URI uri) {
        OutputFile outputFile = new OutputFile(this, name, uri);
        super.add(outputFile);
        return outputFile;
    }

    public OutputFile addOutputFile(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        return this.addOutputFile(UriUtil.getName((URI)uri), uri);
    }

    public Template addTemplate(String name, URI uri) {
        Template template = new Template(this, name, uri);
        super.add(template);
        return template;
    }

    public Template addTemplate(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        return this.addTemplate(UriUtil.getName((URI)uri), uri);
    }

    public Variable addVariable(String name, Object value) {
        Variable variable = new Variable(this, name, value);
        super.add(variable);
        this.variables.add(variable);
        return variable;
    }

    public Collection<Variable> getVariables() {
        return Collections.unmodifiableCollection(this.variables);
    }
}

