/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

public abstract class FileUtil {
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String ESCAPED_NEWLINE = NEWLINE.replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");

    private FileUtil() {
    }

    public static String resolve(String path, File parent) {
        if (path == null) {
            throw new NullPointerException("path may not be null");
        }
        File file = new File(path);
        if (!file.isAbsolute() && parent != null) {
            file = new File(parent, path);
        }
        return file.getAbsolutePath();
    }

    public static String read(File file) throws IOException {
        BufferedReader reader = null;
        try {
            int c;
            StringBuilder contents = new StringBuilder();
            reader = new BufferedReader(new FileReader(file));
            while ((c = reader.read()) != -1) {
                if ((char)c == '\r' && (char)reader.read() == '\n') {
                    contents.append(NEWLINE);
                    continue;
                }
                if ((char)c == '\n') {
                    contents.append(NEWLINE);
                    continue;
                }
                contents.append((char)c);
            }
            String string = contents.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void write(String path, String contents) throws IOException {
        FileUtil.write(new File(path), contents);
    }

    public static void write(String path, String contents, boolean append) throws IOException {
        FileUtil.write(new File(path), contents, append);
    }

    public static void write(File file, String contents) throws IOException {
        FileUtil.write(file, contents, false);
    }

    public static void write(File file, String contents, boolean append) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file, append);
            writer.write(contents);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

