/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.commons.parse;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class AST
extends CommonTree {
    protected URI uri;
    protected Integer line = null;
    protected Integer column = null;
    protected AST annotations;

    public AST() {
    }

    public AST(CommonTree commontree) {
        super(commontree);
        if (commontree.getChildren() != null) {
            for (Object child : commontree.getChildren()) {
                this.addChild((Tree)((CommonTree)child));
            }
        }
    }

    public AST(Token token, URI uri) {
        super(token);
        this.uri = uri;
    }

    public void setAnnotationsAst(AST annotations) {
        this.annotations = annotations;
    }

    public AST getAnnotationsAst() {
        return this.annotations;
    }

    public File getFile() {
        if (this.uri != null && "file".equals(this.uri.getScheme())) {
            return new File(this.uri);
        }
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    private AST cast(Tree tree) {
        if (tree instanceof AST) {
            return (AST)tree;
        }
        if (tree instanceof CommonTree) {
            return new AST((CommonTree)tree);
        }
        throw new IllegalArgumentException("Cannot cast " + tree.getClass().getSimpleName() + " to AST.");
    }

    public List<? extends AST> getChildren() {
        List children = super.getChildren();
        if (children == null) {
            return Collections.EMPTY_LIST;
        }
        return children;
    }

    public AST getParent() {
        return (AST)this.parent;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        if (this.line == null) {
            return super.getLine();
        }
        return this.line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        if (this.column == null) {
            return super.getCharPositionInLine();
        }
        return this.column;
    }

    public AST getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        List siblings = this.parent.getChildren();
        if (this.childIndex >= siblings.size() - 1) {
            return null;
        }
        return this.cast((Tree)siblings.get(this.childIndex + 1));
    }

    public void setNextSibling(AST sibling) {
        if (this.parent != null && sibling != null) {
            this.parent.getChildren().add(this.childIndex, sibling);
        }
    }

    public AST getChild(int i) {
        return this.cast(super.getChild(i));
    }

    public int getNumberOfChildren() {
        return this.getChildCount();
    }

    public AST getFirstChild() {
        if (this.getChildCount() > 0) {
            return this.cast((Tree)this.getChild(0));
        }
        return null;
    }

    public void setFirstChild(AST child) {
        if (this.getChildCount() == 0) {
            this.addChild((Tree)child);
        } else {
            this.children.add(0, child);
            this.freshenParentAndChildIndexes();
        }
    }
}

