/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.commons.profiling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.commons.profiling.FileMarker;
import org.eclipse.epsilon.commons.profiling.IProfilerListener;
import org.eclipse.epsilon.commons.profiling.ProfilerTarget;
import org.eclipse.epsilon.commons.profiling.Stopwatch;

public class Profiler {
    protected Collection<IProfilerListener> listeners = new ArrayList<IProfilerListener>();
    public static Profiler INSTANCE = new Profiler();
    protected ProfilerTarget root;
    protected ProfilerTarget activeTarget;
    protected Stopwatch stopwatch = new Stopwatch();
    protected Map<String, Long> targets;
    protected List<String> targetNames;

    public Profiler() {
        this.root = new ProfilerTarget("", this.stopwatch, "", null);
        this.reset();
    }

    public ProfilerTarget start(String targetName) {
        return this.start(targetName, "", null);
    }

    public ProfilerTarget start(String targetName, String data, FileMarker fileMarker) {
        this.stopwatch.pause();
        this.activeTarget.pause();
        ProfilerTarget target = new ProfilerTarget(targetName, this.stopwatch, data, fileMarker);
        this.activeTarget.addChild(target);
        this.activeTarget = target;
        if (this.targets.containsKey(targetName)) {
            this.targets.put(targetName, this.targets.get(targetName) + 1L);
        } else {
            this.targets.put(targetName, 1L);
        }
        if (!this.targetNames.contains(targetName)) {
            this.targetNames.add(targetName);
        }
        this.activeTarget.resume();
        this.stopwatch.resume();
        return target;
    }

    public void refresh() {
        for (IProfilerListener listener : this.listeners) {
            listener.refresh();
        }
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(String target) {
        this.stopwatch.pause();
        this.activeTarget.stop();
        if (target != null && target.compareTo(this.activeTarget.getName()) != 0) {
            throw new IllegalStateException("Attempted to stop profiling target " + target + " while the active one is " + this.activeTarget.getName());
        }
        this.activeTarget = this.activeTarget.getParent();
        for (IProfilerListener listener : this.listeners) {
            listener.targetStopped(target);
        }
        this.activeTarget.resume();
        this.stopwatch.resume();
    }

    public List<String> getTargetNames() {
        return this.targetNames;
    }

    public void print() {
        for (String targetName : this.getTargetNames()) {
            System.out.println(String.valueOf(targetName) + " -> " + this.getTotalTime(targetName, true) + "/" + this.getExecutionCount(targetName));
        }
    }

    public long getTotalTime(String targetName, boolean aggregate) {
        return this.getWorked(this.root, targetName, aggregate);
    }

    public long getExecutionCount(String targetName) {
        return this.targets.containsKey(targetName) ? this.targets.get(targetName) : 0L;
    }

    protected long getWorked(ProfilerTarget target, String targetName, boolean aggregate) {
        if (target.getName().compareTo(targetName) == 0) {
            return target.getWorked(aggregate);
        }
        long sum = 0L;
        ArrayList<ProfilerTarget> children = new ArrayList<ProfilerTarget>();
        children.addAll(target.getChildren());
        for (ProfilerTarget child : children) {
            sum += this.getWorked(child, targetName, aggregate);
        }
        return sum;
    }

    public boolean isRunning(String targetName) {
        ProfilerTarget target = this.activeTarget;
        while (target.getParent() != null) {
            if (target.getName().compareTo(targetName) == 0) {
                return true;
            }
            target = target.getParent();
        }
        return false;
    }

    public void reset() {
        this.root.getChildren().clear();
        this.activeTarget = this.root;
        this.targets = new HashMap<String, Long>();
        this.targetNames = new ArrayList<String>();
    }

    public void addListener(IProfilerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IProfilerListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public ProfilerTarget getRoot() {
        return this.root;
    }
}

