/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static Collection<?> asCollection(Object o) {
        if (o instanceof Collection) {
            return (Collection)o;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        return list;
    }

    public static List<?> asList(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof Collection) {
            List list = CollectionUtil.createDefaultList();
            list.addAll((Collection)o);
            return list;
        }
        List list = CollectionUtil.createDefaultList();
        list.add(o);
        return list;
    }

    public static Set<?> asSet(Object o) {
        if (o instanceof Set) {
            return (Set)o;
        }
        if (o instanceof Collection) {
            Set set = CollectionUtil.createDefaultSet();
            set.addAll((Collection)o);
            return set;
        }
        Set set = CollectionUtil.createDefaultSet();
        set.add(o);
        return set;
    }

    public static <T> Collection<T> flatten(Collection<T> original) {
        boolean hasNested = false;
        for (T o : original) {
            if (!(o instanceof Collection)) continue;
            hasNested = true;
            break;
        }
        if (!hasNested) {
            return original;
        }
        List<T> flattened = CollectionUtil.createDefaultList();
        for (T next : original) {
            if (next instanceof Collection) {
                flattened.addAll(CollectionUtil.flatten((Collection)next));
                continue;
            }
            flattened.add(next);
        }
        return flattened;
    }

    public static <T> Set<T> createDefaultSet() {
        return new LinkedHashSet();
    }

    public static <T> List<T> createDefaultList() {
        return new ArrayList();
    }

    public static <T> List<T> asList(Collection<T> c) {
        if (c instanceof List) {
            return (List)c;
        }
        ArrayList<T> copy = new ArrayList<T>();
        copy.addAll(c);
        return copy;
    }

    public static <T> Object getFirst(Collection<T> c) {
        if (c.size() == 0) {
            return null;
        }
        if (c instanceof List) {
            return ((List)c).get(0);
        }
        return c.iterator().next();
    }

    public static <T> List<T> iterate(Iterable<T> iterable) {
        List<T> filled = CollectionUtil.createDefaultList();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            filled.add(iterator.next());
        }
        return filled;
    }

    public static String join(Collection<?> collection, String delimiter) {
        return CollectionUtil.join(collection, delimiter, new ElementPrinter(){

            @Override
            public String print(Object element) {
                return element.toString();
            }
        });
    }

    public static String join(Collection<?> collection, String delimiter, ElementPrinter printer) {
        StringBuilder result = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            result.append(printer.print(next));
            if (!iterator.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static interface ElementPrinter {
        public String print(Object var1);
    }
}

