/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.epsilon.commons.module.AbstractModuleElement;
import org.eclipse.epsilon.commons.module.IModule;
import org.eclipse.epsilon.commons.module.ModuleElement;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.parse.EpsilonParseProblemManager;
import org.eclipse.epsilon.commons.parse.EpsilonParser;
import org.eclipse.epsilon.commons.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.commons.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public abstract class AbstractModule
extends AbstractModuleElement
implements IModule {
    protected EpsilonParser parser;
    protected ArrayList<ParseProblem> parseProblems = new ArrayList();

    public abstract void buildModel() throws Exception;

    public abstract String getMainRule();

    public abstract Lexer createLexer(InputStream var1);

    public abstract EpsilonParser createParser(TokenStream var1);

    public abstract void reset();

    public abstract List<ModuleElement> getChildren();

    public List<ParseProblem> getParseProblems() {
        return this.parseProblems;
    }

    public boolean parse(String code) throws Exception {
        return this.parse(code, null);
    }

    public boolean parse(String code, File file) throws Exception {
        this.sourceFile = file;
        Lexer lexer = this.createLexer(new ByteArrayInputStream(code.getBytes()));
        CommonTokenStream stream = new CommonTokenStream((TokenSource)lexer);
        EpsilonTreeAdaptor adaptor = new EpsilonTreeAdaptor(file);
        this.parser = this.createParser((TokenStream)stream);
        this.parser.setDeepTreeAdaptor((TreeAdaptor)adaptor);
        return this.invokeMainRule();
    }

    public boolean parse(URI uri) throws Exception {
        this.sourceUri = uri;
        String uriScheme = uri.getScheme();
        if ("file".equals(uriScheme)) {
            this.sourceFile = new File(uri);
        }
        Lexer lexer = null;
        Object fr = null;
        try {
            lexer = this.createLexer(uri.toURL().openStream());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        EpsilonTreeAdaptor adaptor = new EpsilonTreeAdaptor(uri);
        CommonTokenStream stream = new CommonTokenStream((TokenSource)lexer);
        this.parser = this.createParser((TokenStream)stream);
        this.parser.setDeepTreeAdaptor((TreeAdaptor)adaptor);
        boolean mainRuleResult = this.invokeMainRule();
        try {
            if (fr != null) {
                // empty if block
            }
        }
        catch (Throwable throwable) {}
        return mainRuleResult;
    }

    public boolean parse(File file) throws Exception {
        this.sourceFile = file;
        Lexer lexer = null;
        Object fr = null;
        lexer = this.createLexer(new FileInputStream(file));
        EpsilonTreeAdaptor astFactory = new EpsilonTreeAdaptor(file);
        CommonTokenStream stream = new CommonTokenStream((TokenSource)lexer);
        this.parser = this.createParser((TokenStream)stream);
        this.parser.setDeepTreeAdaptor((TreeAdaptor)astFactory);
        boolean mainRuleResult = this.invokeMainRule();
        try {
            if (fr != null) {
                // empty if block
            }
        }
        catch (Throwable throwable) {}
        return mainRuleResult;
    }

    protected boolean invokeMainRule() throws Exception {
        this.parseProblems.clear();
        EpsilonParseProblemManager.INSTANCE.reset();
        try {
            this.ast = (AST)((ParserRuleReturnScope)ReflectionUtil.executeMethod(this.parser, this.getMainRule(), new Object[0])).getTree();
        }
        catch (RecognitionException ex) {
            ParseProblem problem = new ParseProblem();
            problem.setLine(ex.line);
            problem.setColumn(ex.charPositionInLine);
            problem.setReason(ex.getMessage());
            this.getParseProblems().add(problem);
            ex.printStackTrace();
        }
        catch (Throwable throwable) {
            ParseProblem problem = new ParseProblem();
            Token next = this.parser.input.LT(1);
            problem.setLine(next.getLine());
            problem.setColumn(next.getCharPositionInLine());
            problem.setReason("mismatched input: '" + next.getText() + "'");
            this.getParseProblems().add(problem);
        }
        this.parseProblems.addAll(EpsilonParseProblemManager.INSTANCE.getParseProblems());
        EpsilonParseProblemManager.INSTANCE.reset();
        if (this.getParseProblems().size() == 0) {
            EolAnnotationsUtil.assignAnnotations(this.ast);
            this.buildModel();
            return true;
        }
        return false;
    }

    public AST getAst() {
        return this.ast;
    }
}

