/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.commons.module.AbstractModuleElement;
import org.eclipse.epsilon.commons.module.IModule;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.UriUtil;

public class EolImport
extends AbstractModuleElement {
    protected IModule module;
    protected boolean loaded = false;
    protected boolean found = false;

    public EolImport(AST ast, IModule module) {
        this.setAst(ast);
        this.module = module;
    }

    public void load(URI baseUri) {
        try {
            File file = new File(this.getPath());
            if (file.isAbsolute()) {
                if (!file.exists()) {
                    return;
                }
                this.module.parse(file);
            } else {
                this.module.parse(UriUtil.resolve((String)this.getPath(), (URI[])new URI[]{baseUri}));
            }
            this.found = true;
            if (this.module.getParseProblems().size() == 0) {
                this.loaded = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getChildren() {
        if (!this.loaded) {
            return Collections.EMPTY_LIST;
        }
        return this.module.getChildren();
    }

    public String toString() {
        return "import '" + this.ast.getFirstChild().getText() + "'";
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isFound() {
        return this.found;
    }

    public IModule getModule() {
        return this.module;
    }

    public String getPath() {
        return this.ast.getFirstChild().getText();
    }
}

