/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.annotations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.AstUtil;
import org.eclipse.epsilon.eol.annotations.EolExecutableAnnotation;
import org.eclipse.epsilon.eol.annotations.EolSimpleAnnotationFactory;
import org.eclipse.epsilon.eol.annotations.IEolAnnotation;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolAnnotationsUtil {
    public static void assignAnnotations(AST ast) {
        List children = AstUtil.getChildren((AST)ast);
        for (AST child : children) {
            if (child.getType() == 50) {
                AST target = null;
                if (child.getNextSibling() != null) {
                    if (child.getNextSibling().getType() != 61) {
                        target = child.getNextSibling();
                    } else if (child.getNextSibling().getNextSibling() != null) {
                        target = child.getNextSibling().getNextSibling();
                    }
                }
                if (target == null) continue;
                target.setAnnotationsAst(child);
                continue;
            }
            EolAnnotationsUtil.assignAnnotations(child);
        }
    }

    public static boolean getBooleanAnnotationValue(AST ast, String name, IEolContext context) throws EolRuntimeException {
        return EolAnnotationsUtil.getBooleanAnnotationValue(ast, name, context, false, true);
    }

    public static boolean getBooleanAnnotationValue(AST ast, String name, IEolContext context, boolean ifNotExists, boolean ifNoValue) throws EolRuntimeException {
        IEolAnnotation lazyAnnotation = EolAnnotationsUtil.getAnnotation(ast, name);
        if (lazyAnnotation == null) {
            return ifNotExists;
        }
        if (!lazyAnnotation.hasValue()) {
            return ifNoValue;
        }
        Object result = lazyAnnotation.getValue(context);
        try {
            boolean lazy = new Boolean(result.toString());
            return lazy;
        }
        catch (Exception exception) {
            throw new EolIllegalReturnException("Boolean", result, lazyAnnotation.getAst(), context);
        }
    }

    public static boolean hasAnnotation(AST ast, String name) {
        return !EolAnnotationsUtil.getAnnotations(ast, name).isEmpty();
    }

    public static IEolAnnotation getAnnotation(AST ast, String name) {
        List<IEolAnnotation> annotations = EolAnnotationsUtil.getAnnotations(ast, name);
        if (annotations.isEmpty()) {
            return null;
        }
        return annotations.get(0);
    }

    public static List<IEolAnnotation> getAnnotations(AST ast) {
        return EolAnnotationsUtil.getAnnotations(ast, null);
    }

    public static List<IEolAnnotation> getAnnotations(AST ast, String name) {
        ArrayList<IEolAnnotation> allAnnotations = new ArrayList<IEolAnnotation>();
        ArrayList<IEolAnnotation> annotations = new ArrayList<IEolAnnotation>();
        AST annotationsAst = ast.getAnnotationsAst();
        if (annotationsAst != null) {
            for (AST annotationAst : AstUtil.getChildren((AST)annotationsAst)) {
                if (annotationAst.getType() == 51) {
                    allAnnotations.add(new EolExecutableAnnotation(annotationAst));
                    continue;
                }
                allAnnotations.addAll(EolSimpleAnnotationFactory.createSimpleAnnotations(annotationAst));
            }
            if (name == null) {
                return allAnnotations;
            }
            for (IEolAnnotation annotation : allAnnotations) {
                if (!annotation.getName().equals(name)) continue;
                annotations.add(annotation);
            }
        }
        return annotations;
    }

    public static List<Object> getAnnotationsValues(AST ast, String name, IEolContext context) throws EolRuntimeException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (IEolAnnotation annotation : EolAnnotationsUtil.getAnnotations(ast, name)) {
            values.add(annotation.getValue(context));
        }
        return values;
    }

    public static Object getAnnotationValue(AST ast, String name, IEolContext context) throws EolRuntimeException {
        List<Object> values = EolAnnotationsUtil.getAnnotationsValues(ast, name, context);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }
}

