/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.annotations;

import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.annotations.IEolAnnotation;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolExecutableAnnotation
implements IEolAnnotation {
    protected String name;
    protected AST ast;
    protected AST expressionAst;

    public EolExecutableAnnotation(AST ast) {
        this.ast = ast;
        this.name = ast.getFirstChild().getText();
        this.expressionAst = ast.getFirstChild().getNextSibling();
    }

    @Override
    public AST getAst() {
        return this.ast;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue(IEolContext context) throws EolRuntimeException {
        return context.getExecutorFactory().executeAST(this.expressionAst, context);
    }

    @Override
    public boolean hasValue() {
        return true;
    }
}

