/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolNativeType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;

public class TypeExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        String typeName = ast.getText();
        if (typeName.equals("Integer")) {
            return EolPrimitiveType.Integer;
        }
        if (typeName.equals("Any")) {
            return EolAnyType.Instance;
        }
        if (typeName.equals("Boolean")) {
            return EolPrimitiveType.Boolean;
        }
        if (typeName.equals("String")) {
            return EolPrimitiveType.String;
        }
        if (typeName.equals("Real")) {
            return EolPrimitiveType.Real;
        }
        if (typeName.equals("Map")) {
            return EolPrimitiveType.Map;
        }
        if (typeName.equals("Sequence") || typeName.equals("List")) {
            return EolCollectionType.Sequence;
        }
        if (typeName.equals("Bag")) {
            return EolCollectionType.Bag;
        }
        if (typeName.equals("Set")) {
            return EolCollectionType.Set;
        }
        if (typeName.equals("OrderedSet")) {
            return EolCollectionType.OrderedSet;
        }
        if (typeName.equals("Collection")) {
            return EolCollectionType.Collection;
        }
        if (typeName.equals("Native")) {
            return new EolNativeType(ast.getFirstChild(), context);
        }
        if (typeName.equals("Nothing")) {
            return EolNoType.Instance;
        }
        try {
            EolModelElementType type = EolModelElementType.forName(typeName, context);
            return type;
        }
        catch (EolModelNotFoundException eolModelNotFoundException) {
        }
        catch (EolModelElementTypeNotFoundException eolModelElementTypeNotFoundException) {}
        throw new EolTypeNotFoundException(typeName, ast);
    }
}

