/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public class AnyOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return true;
    }

    public Object type() {
        if (EolPrimitiveType.String.isType(this.target)) {
            return EolPrimitiveType.String;
        }
        if (EolPrimitiveType.Boolean.isType(this.target)) {
            return EolPrimitiveType.Boolean;
        }
        if (EolPrimitiveType.Real.isType(this.target)) {
            return EolPrimitiveType.Real;
        }
        if (EolPrimitiveType.Integer.isType(this.target)) {
            return EolPrimitiveType.Integer;
        }
        if (EolCollectionType.Bag.isType(this.target)) {
            return EolCollectionType.Bag;
        }
        if (EolCollectionType.Sequence.isType(this.target)) {
            return EolCollectionType.Sequence;
        }
        if (EolCollectionType.Set.isType(this.target)) {
            return EolCollectionType.Set;
        }
        if (EolCollectionType.OrderedSet.isType(this.target)) {
            return EolCollectionType.OrderedSet;
        }
        IModel model = this.context.getModelRepository().getOwningModel(this.target);
        if (model != null) {
            return model.getTypeOf(this.target);
        }
        return null;
    }

    public String id() throws Exception {
        IModel model = this.context.getModelRepository().getOwningModel(this.target);
        if (model != null) {
            return model.getElementId(this.target);
        }
        throw new EolRuntimeException(String.valueOf(this.context.getPrettyPrinterManager().print(this.target)) + " is not a model element");
    }

    public boolean isTypeOf(EolType type) {
        return type.isType(this.target);
    }

    public boolean isKindOf(EolType type) {
        return type.isKind(this.target);
    }

    public Class getNativeType() {
        return this.target.getClass();
    }

    public Class nativeType() {
        return this.getNativeType();
    }

    public IModel getOwningModel() {
        return this.owningModel();
    }

    public IModel owningModel() {
        return this.context.getModelRepository().getOwningModel(this.target);
    }

    public boolean hasProperty(String property) throws Exception {
        IPropertyGetter getter = this.context.getIntrospectionManager().getPropertyGetterFor(this.target, property, this.context);
        try {
            getter.invoke(this.target, property);
        }
        catch (EolIllegalPropertyException eolIllegalPropertyException) {
            return false;
        }
        return true;
    }

    public String asString() {
        return this.context.getPrettyPrinterManager().print(this.target);
    }

    public boolean isDefined() {
        if (this.target == null) {
            return false;
        }
        return !(this.target instanceof String) || ((String)this.target).length() != 0;
    }

    public boolean isUndefined() {
        return !this.isDefined();
    }

    public Object ifUndefined(Object alternative) {
        if (this.isUndefined()) {
            return alternative;
        }
        return this.target;
    }

    public Object println() {
        return this.println("", "");
    }

    public Object println(String prefix) {
        return this.println(prefix, "");
    }

    public Object println(String prefix, String suffix) {
        this.context.getOutputStream().println(String.valueOf(prefix) + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public Object print() {
        return this.print("", "");
    }

    public Object print(String prefix) {
        return this.print(prefix, "");
    }

    public Object print(String prefix, String suffix) {
        this.context.getOutputStream().print(String.valueOf(prefix) + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public Object err() {
        return this.err("", "");
    }

    public Object err(String prefix) {
        return this.err(prefix, "");
    }

    public Object err(String prefix, String suffix) {
        this.context.getErrorStream().print(String.valueOf(prefix) + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public Object errln() {
        return this.errln("", "");
    }

    public Object errln(String prefix) {
        return this.errln(prefix, "");
    }

    public Object errln(String prefix, String suffix) {
        this.context.getErrorStream().println(String.valueOf(prefix) + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public String format(String formatString) {
        return String.format(formatString, this.target);
    }
}

