/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Collection;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolType;

public class CollectOperation
extends AbstractOperation {
    @Override
    public Object execute(Object obj, AST operationAst, IEolContext context) throws EolRuntimeException {
        AST declarationsAst = operationAst.getFirstChild();
        AST bodyAst = declarationsAst.getNextSibling();
        AST declarationAst = declarationsAst.getFirstChild();
        AST iteratorNameAst = declarationAst.getFirstChild();
        AST iteratorTypeAst = iteratorNameAst.getNextSibling();
        String iteratorName = iteratorNameAst.getText();
        EolType iteratorType = null;
        iteratorType = iteratorTypeAst != null ? (EolType)context.getExecutorFactory().executeAST(iteratorTypeAst, context) : EolAnyType.Instance;
        Collection source = CollectionUtil.asCollection((Object)obj);
        Collection result = null;
        result = EolCollectionType.isOrdered(source) ? new EolSequence() : new EolBag();
        FrameStack scope = context.getFrameStack();
        for (Object listItem : source) {
            if (iteratorType != null && !iteratorType.isKind(listItem)) continue;
            scope.enter(FrameType.UNPROTECTED, operationAst);
            scope.put(new Variable(iteratorName, listItem, iteratorType, true));
            Object bodyResult = context.getExecutorFactory().executeAST(bodyAst, context);
            result.add(bodyResult);
            scope.leave(operationAst);
        }
        return result;
    }
}

