/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Collection;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolType;

public class SelectOperation
extends AbstractOperation {
    protected boolean returnOnFirstMatch = false;

    public boolean isReturnOnFirstMatch() {
        return this.returnOnFirstMatch;
    }

    public void setReturnOnFirstMatch(boolean returnOnFirstMatch) {
        this.returnOnFirstMatch = returnOnFirstMatch;
    }

    @Override
    public Object execute(Object obj, AST ast, IEolContext context) throws EolRuntimeException {
        AST declarationsAst = ast.getFirstChild();
        AST bodyAst = declarationsAst.getNextSibling();
        AST declarationAst = declarationsAst.getFirstChild();
        AST iteratorNameAst = declarationAst.getFirstChild();
        AST iteratorTypeAst = iteratorNameAst.getNextSibling();
        String iteratorName = iteratorNameAst.getText();
        EolType iteratorType = null;
        iteratorType = iteratorTypeAst != null ? (EolType)context.getExecutorFactory().executeAST(iteratorTypeAst, context) : EolAnyType.Instance;
        Collection source = CollectionUtil.asCollection((Object)obj);
        Collection result = EolCollectionType.createSameType(source);
        FrameStack scope = context.getFrameStack();
        for (Object listItem : source) {
            if (iteratorType != null && !iteratorType.isKind(listItem)) continue;
            scope.enter(FrameType.UNPROTECTED, ast);
            scope.put(Variable.createReadOnlyVariable(iteratorName, listItem));
            Object bodyResult = context.getExecutorFactory().executeAST(bodyAst, context);
            if (bodyResult instanceof Boolean && ((Boolean)bodyResult).booleanValue()) {
                result.add(listItem);
                if (this.isReturnOnFirstMatch()) {
                    scope.leave(ast);
                    return result;
                }
            }
            scope.leave(ast);
        }
        return result;
    }
}

