/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;

public abstract class AbstractSimpleOperation
extends AbstractOperation {
    @Override
    public Object execute(Object source, AST operationAst, IEolContext context) throws EolRuntimeException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        AST parametersAst = operationAst.getFirstChild();
        if (parametersAst != null) {
            AST parameterAst = parametersAst.getFirstChild();
            int parameterIndex = 0;
            while (parameterAst != null) {
                try {
                    parameters.add(context.getExecutorFactory().executeAST(parameterAst, context));
                }
                catch (EolRuntimeException ex) {
                    if (this.getTolerateExceptionInParameter(parameterIndex)) {
                        parameters.add(ex);
                    }
                    throw ex;
                }
                catch (Throwable t) {
                    context.getErrorStream().println("THROWABLE " + t.getClass().getName());
                }
                parameterAst = parameterAst.getNextSibling();
                ++parameterIndex;
            }
        }
        try {
            return this.execute(source, parameters, context, operationAst);
        }
        catch (EolRuntimeException ex) {
            if (ex.getAst() == null) {
                ex.setAst(operationAst);
            }
            throw ex;
        }
    }

    public abstract Object execute(Object var1, List var2, IEolContext var3, AST var4) throws EolRuntimeException;

    public boolean getTolerateExceptionInParameter(int parameterIndex) {
        return false;
    }
}

