/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.commons.util.StringProperties;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.transactions.IModelTransactionSupport;
import org.eclipse.epsilon.eol.models.transactions.NoModelTransactionSupport;

public abstract class Model
implements IModel {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_READONLOAD = "readOnLoad";
    public static final String PROPERTY_STOREONDISPOSAL = "storeOnDisposal";
    public static final String PROPERTY_ALIASES = "aliases";
    protected String name;
    protected List<String> aliases = new ArrayList<String>();
    protected boolean storeOnDisposal = false;
    protected boolean readOnLoad = true;
    NoModelTransactionSupport transactionSupport = new NoModelTransactionSupport();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        this.name = properties.getProperty(PROPERTY_NAME);
        this.readOnLoad = new Boolean(properties.getProperty(PROPERTY_READONLOAD));
        this.storeOnDisposal = new Boolean(properties.getProperty(PROPERTY_STOREONDISPOSAL));
        String[] aliases = properties.getProperty(PROPERTY_ALIASES).split(",");
        int i = 0;
        while (i < aliases.length) {
            this.aliases.add(aliases[i].trim());
            ++i;
        }
    }

    @Override
    public Object createInstance(String type, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        return this.createInstance(type);
    }

    public Collection allInstances() {
        return this.allContents();
    }

    @Override
    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        Collection<?> allOfType = this.getAllOfKind(metaClass);
        return allOfType != null && allOfType.contains(instance);
    }

    @Override
    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        Collection<?> allOfClass = this.getAllOfType(metaClass);
        return allOfClass != null && allOfClass.contains(instance);
    }

    @Override
    public boolean isReadOnLoad() {
        return this.readOnLoad;
    }

    @Override
    public boolean isStoredOnDisposal() {
        return this.storeOnDisposal;
    }

    @Override
    public void setReadOnLoad(boolean readOnLoad) {
        this.readOnLoad = readOnLoad;
    }

    @Override
    public void setStoredOnDisposal(boolean storedOnDisposal) {
        this.storeOnDisposal = storedOnDisposal;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return new JavaPropertyGetter();
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new JavaPropertySetter();
    }

    @Override
    public void dispose() {
        if (this.isStoredOnDisposal()) {
            this.store();
        }
    }

    @Override
    public boolean knowsAboutProperty(Object instance, String property) {
        return this.owns(instance);
    }

    @Override
    public IModelTransactionSupport getTransactionSupport() {
        return this.transactionSupport;
    }
}

