/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epsilon.eol.util.IdentityBasedWeakHashMap;

public class CollectionAnnotator {
    protected IdentityBasedWeakHashMap<Object, AnnotatedCollectionType> cache = new IdentityBasedWeakHashMap();
    protected static CollectionAnnotator instance = new CollectionAnnotator();

    public static void main(String[] args) throws Exception {
        int i = 1;
        while (i < 1000) {
            CollectionAnnotator.getInstance().annotate(new ArrayList(), AnnotatedCollectionType.Sequence);
            ++i;
        }
        System.gc();
        Thread.sleep(1000L);
        System.err.println(CollectionAnnotator.getInstance().cacheSize());
    }

    public int cacheSize() {
        return this.cache.size();
    }

    public void annotate(Collection c, AnnotatedCollectionType ct) {
        this.cache.put(c, ct);
    }

    public AnnotatedCollectionType getType(Collection c) {
        return this.cache.get(c);
    }

    public static CollectionAnnotator getInstance() {
        return instance;
    }

    public static enum AnnotatedCollectionType {
        Bag,
        Sequence,
        Set,
        OrderedSet;

    }
}

