/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationParametersException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolType;

public class EolPrimitiveType
extends EolType {
    private Class clazz;
    private String name;
    public static EolPrimitiveType Integer = new EolPrimitiveType(Integer.class, "Integer");
    public static EolPrimitiveType String = new EolPrimitiveType(String.class, "String");
    public static EolPrimitiveType Boolean = new EolPrimitiveType(Boolean.class, "Boolean");
    public static EolPrimitiveType Real = new EolPrimitiveType(Float.class, "Real");
    public static EolPrimitiveType Map = new EolPrimitiveType(EolMap.class, "Map");

    private EolPrimitiveType(Class clazz, String name) {
        this.clazz = clazz;
        this.name = name;
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        throw new EolIllegalOperationParametersException("createInstance");
    }

    @Override
    public boolean isType(Object o) {
        if (o == null) {
            return false;
        }
        if (this == Integer && (o instanceof Integer || o instanceof Long)) {
            return true;
        }
        if (this == Real && (o instanceof Double || o instanceof Float)) {
            return true;
        }
        if (this == String && o instanceof String) {
            return true;
        }
        if (this == Boolean && o instanceof Boolean) {
            return true;
        }
        return this == Map && o instanceof EolMap;
    }

    public Class getClazz() {
        return this.clazz;
    }

    @Override
    public boolean isKind(Object o) {
        if (this == Integer) {
            return Integer.isType(o);
        }
        if (this == Real) {
            return Real.isType(o) || Integer.isType(o);
        }
        if (this == String) {
            return String.isType(o);
        }
        if (this == Boolean) {
            return Boolean.isType(o);
        }
        if (this == Map) {
            return Map.isType(o);
        }
        return false;
    }

    @Override
    public Object createInstance() {
        if (this == Integer) {
            return 0;
        }
        if (this == Real) {
            return Float.valueOf(0.0f);
        }
        if (this == String) {
            return "";
        }
        if (this == Boolean) {
            return false;
        }
        if (this == Map) {
            return new EolMap();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

