/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;

public class AbstractModuleEditorScanner
extends RuleBasedScanner {
    protected AbstractModuleEditor editor;
    protected List<String> keywords;
    protected List<String> builtinVariables;
    protected List<String> types;
    protected List<String> assertions;

    public AbstractModuleEditorScanner(AbstractModuleEditor editor) {
        this.editor = editor;
        this.keywords = editor.getKeywords();
        this.builtinVariables = editor.getBuiltinVariables();
        this.types = editor.getTypes();
        this.assertions = editor.getAssertions();
        Color backgroundColor = editor.getBackgroundColor();
        this.fDefaultReturnToken = new Token((Object)new TextAttribute(null, backgroundColor, 0));
        WordRule keywordsRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)new Token((Object)new TextAttribute(null, backgroundColor, 0)));
        ListIterator<String> li = this.keywords.listIterator();
        while (li.hasNext()) {
            keywordsRule.addWord(li.next().toString(), (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.KEYWORD, backgroundColor, 1)));
        }
        WordRule builtinRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)new Token((Object)new TextAttribute(null)));
        li = this.builtinVariables.listIterator();
        while (li.hasNext()) {
            keywordsRule.addWord(li.next().toString(), (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.BUILTIN, backgroundColor, 2)));
        }
        WordRule typesRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)new Token((Object)new TextAttribute(null)));
        li = this.types.listIterator();
        while (li.hasNext()) {
            keywordsRule.addWord(li.next().toString(), (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.TYPE, backgroundColor, 1)));
        }
        WordRule assertionsRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)new Token((Object)new TextAttribute(null)));
        li = this.assertions.listIterator();
        while (li.hasNext()) {
            assertionsRule.addWord(li.next().toString(), (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.ASSERTION, backgroundColor, 1)));
        }
        this.setRules(new IRule[]{new EndOfLineRule("--", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.COMMENT, backgroundColor, 0))), new MultiLineRule("-*", "*-", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.COMMENT, backgroundColor, 0))), new EndOfLineRule("//", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.COMMENT, backgroundColor, 0))), new MultiLineRule("/*", "*/", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.COMMENT, backgroundColor, 0))), new EndOfLineRule("@", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.ANNOTATION, backgroundColor, 0))), new EndOfLineRule("$", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.EXECUTABLEANNOTATION, backgroundColor, 0))), new SingleLineRule("\"", "\"", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.STRING, backgroundColor, 0)), '\\'), new SingleLineRule("'", "'", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.STRING, backgroundColor, 0)), '\\'), new SingleLineRule("`", "`", (IToken)new Token((Object)new TextAttribute(AbstractModuleEditor.DEFAULT, backgroundColor, 2)), '\\'), keywordsRule, builtinRule, typesRule});
    }
}

