/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor.autoclose;

import org.eclipse.epsilon.common.dt.editor.autoclose.AutoCloseAction;
import org.eclipse.epsilon.common.dt.editor.autoclose.AutoClosePair;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class AutoCloseCandidate {
    protected IDocument document;
    protected DocumentCommand command;

    public boolean isBackspace() {
        return this.command.length > 0 && this.command.text.length() == 0;
    }

    public boolean isSingleChar() {
        return this.command.length >= 0 && this.command.text != null && this.command.text.length() == 1;
    }

    public char getChar() {
        return this.command.text.charAt(0);
    }

    public char getNextChar() {
        try {
            return this.document.getChar(this.command.offset);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    public AutoCloseAction close(AutoClosePair pair) {
        this.command.text = String.valueOf(this.command.text) + pair.getRight();
        this.command.caretOffset = this.command.offset + 1;
        this.command.shiftsCaret = false;
        return new AutoCloseAction(pair, this.command.offset);
    }

    public void ignore() {
        this.command.caretOffset = this.command.offset + 1;
        this.command.shiftsCaret = false;
        this.command.text = "";
    }

    public AutoCloseCandidate(IDocument document, DocumentCommand command) {
        this.document = document;
        this.command = command;
    }

    public boolean evenInCurrentLine(char what) {
        return !this.oddInCurrentLine(what);
    }

    public boolean oddInCurrentLine(char what) {
        return this.countInCurrentLine(what) % 2 == 1;
    }

    public int countInCurrentLine(char what) {
        int count = 0;
        try {
            IRegion info = this.document.getLineInformationOfOffset(this.command.offset);
            int start = info.getOffset();
            int end = this.command.offset;
            int i = start;
            while (i < end) {
                char ch = this.document.getChar(i);
                if (ch == what) {
                    ++count;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return count;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public DocumentCommand getCommand() {
        return this.command;
    }

    public void setCommand(DocumentCommand command) {
        this.command = command;
    }
}

