/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.epsilon.common.dt.extensions.IllegalExtensionException;

public class ClassBasedExtension {
    public static final String CLASS_PROPERTY = "class";
    private final IConfigurationElement configElement;
    private final Class<?> expectedClass;

    public ClassBasedExtension(IConfigurationElement configElement, Class<?> expectedClass) {
        this.configElement = configElement;
        this.expectedClass = expectedClass;
    }

    public static List<ClassBasedExtension> getInstances(String extensionPointID, Class<?> expectedClass) {
        IConfigurationElement[] configElements;
        ArrayList<ClassBasedExtension> instances = new ArrayList<ClassBasedExtension>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            return instances;
        }
        IExtensionPoint point = registry.getExtensionPoint(extensionPointID);
        IConfigurationElement[] iConfigurationElementArray = configElements = point.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            ClassBasedExtension ext = new ClassBasedExtension(configElement, expectedClass);
            instances.add(ext);
            ++n2;
        }
        return instances;
    }

    public static <T> List<T> getImplementations(String extensionPointID, Class<T> expectedClass) throws IllegalExtensionException {
        ArrayList<Object> listeners = new ArrayList<Object>();
        for (ClassBasedExtension ext : ClassBasedExtension.getInstances(extensionPointID, expectedClass)) {
            listeners.add(ext.createInstance());
        }
        return listeners;
    }

    public String getClassName() {
        return this.configElement.getAttribute(CLASS_PROPERTY);
    }

    public Object createInstance() throws IllegalExtensionException {
        try {
            Object instance = this.configElement.createExecutableExtension(CLASS_PROPERTY);
            if (this.expectedClass.isInstance(instance)) {
                return instance;
            }
            throw new IllegalExtensionException(String.valueOf(this.getClassName()) + " was reported to be a " + this.expectedClass.getCanonicalName() + ", but it was a " + instance.getClass().getCanonicalName());
        }
        catch (Exception ex) {
            throw new IllegalExtensionException(ex);
        }
    }
}

