/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.epsilon.common.dt.EpsilonPlugin;
import org.eclipse.epsilon.common.dt.launching.dialogs.BrowseWorkspaceUtil;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractSourceConfigurationTab
extends AbstractLaunchConfigurationTab
implements ModifyListener {
    protected Label fileLabel;
    protected Text filePath;
    protected Button browse;
    protected Composite extras;

    public void createControl(Composite parent) {
        FillLayout parentLayout = new FillLayout();
        parent.setLayout((Layout)parentLayout);
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout controlLayout = new GridLayout(3, false);
        control.setLayout((Layout)controlLayout);
        this.fileLabel = new Label(control, 0);
        GridData filePathData = new GridData(768);
        this.filePath = new Text(control, 2048);
        this.filePath.setLayoutData((Object)filePathData);
        this.filePath.addModifyListener((ModifyListener)this);
        Button browse = new Button(control, 0);
        browse.setText("Browse Workspace...");
        browse.addListener(13, (Listener)new SelectSourceListener(this.filePath));
        this.fileLabel.setText(String.valueOf(this.getFileLabel()) + ": ");
        this.extras = new Composite(control, 0);
        GridData extrasData = new GridData(1808);
        extrasData.horizontalSpan = 3;
        this.extras.setLayoutData((Object)extrasData);
        control.setBounds(0, 0, 300, 300);
        control.layout();
        control.pack();
        this.canSave();
    }

    public Composite getExtras() {
        return this.extras;
    }

    public String getFileLabel() {
        return "Source";
    }

    public String getActiveEditorPath() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart part = page.getActiveEditor();
        if (part.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)part.getEditorInput();
            String path = fileEditorInput.getFile().getFullPath().toString();
            return path;
        }
        return "";
    }

    public String getActiveEditorName() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart part = page.getActiveEditor();
        if (part != null && part.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)part.getEditorInput();
            String fileName = fileEditorInput.getFile().getName();
            fileName = FileUtil.removeExtension((String)fileName);
            return fileName;
        }
        return "";
    }

    public Image getImage() {
        return this.getPlugin().createImage(this.getImagePath());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String activeEditorName = this.getActiveEditorName();
        if (activeEditorName.length() > 0) {
            configuration.rename(this.newLaunchConfigurationName(activeEditorName));
            configuration.setAttribute("source", this.getActiveEditorPath());
        }
        PlatformUI.getWorkbench();
    }

    protected String newLaunchConfigurationName(String fileName) {
        if (!this.launchConfigurationExists(fileName)) {
            return fileName;
        }
        int i = 1;
        String configurationName;
        while (this.launchConfigurationExists(configurationName = String.valueOf(fileName) + " (" + i + ")")) {
            ++i;
        }
        return configurationName;
    }

    private boolean launchConfigurationExists(String name) {
        ILaunchConfiguration[] cs = new ILaunchConfiguration[]{};
        try {
            cs = this.getLaunchManager().getLaunchConfigurations();
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
        int i = 0;
        while (i < cs.length) {
            ILaunchConfiguration c = cs[i];
            if (c.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.filePath.setText(configuration.getAttribute(this.getSourceAttributeName(), ""));
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.getSourceAttributeName(), this.filePath.getText());
    }

    public String getName() {
        return this.getTitle();
    }

    public boolean canSave() {
        IFile file = null;
        try {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.filePath.getText()));
        }
        catch (Exception exception) {}
        if (file == null || !file.exists()) {
            this.setErrorMessage("Selected file " + this.filePath.getText() + " does not exist");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void modifyText(ModifyEvent e) {
        this.canSave();
        this.updateLaunchConfigurationDialog();
    }

    public abstract EpsilonPlugin getPlugin();

    public abstract String getImagePath();

    public String getFileExtension() {
        return "";
    }

    public abstract String getSelectionTitle();

    public abstract String getSelectionSubtitle();

    public String getTitle() {
        return "Source";
    }

    public String getSourceAttributeName() {
        return "source";
    }

    public class SelectSourceListener
    implements Listener {
        Text text;

        public SelectSourceListener(Text text) {
            this.text = text;
        }

        public void handleEvent(Event event) {
            String selected = BrowseWorkspaceUtil.browseFilePath(AbstractSourceConfigurationTab.this.getShell(), AbstractSourceConfigurationTab.this.getSelectionTitle(), AbstractSourceConfigurationTab.this.getSelectionSubtitle(), "", AbstractSourceConfigurationTab.this.getPlugin().createImage(AbstractSourceConfigurationTab.this.getImagePath()));
            if (selected != null) {
                this.text.setText(selected);
            }
        }
    }
}

