/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.launching.dialogs;

import org.eclipse.epsilon.common.dt.launching.dialogs.BrowseWorkspaceUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractModelConfigurationDialog
extends TitleAreaDialog {
    protected StringProperties properties;
    protected Label nameLabel;
    protected Text nameText;
    protected Label aliasesLabel;
    protected Text aliasesText;
    protected Label readOnLoadLabel;
    protected Button readOnLoadCheckbox;
    protected Label storeOnDisposalLabel;
    protected Button storeOnDisposalCheckbox;

    protected static Composite createGroupContainer(Composite parent, String text, int columns) {
        Group group = new Group(parent, 4);
        group.setLayoutData((Object)new GridData(768));
        group.setText(text);
        group.setLayout((Layout)new GridLayout(1, false));
        Composite groupContent = new Composite((Composite)group, 4);
        groupContent.setLayout((Layout)new GridLayout(columns, false));
        groupContent.setLayoutData((Object)new GridData(768));
        return groupContent;
    }

    public AbstractModelConfigurationDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    public StringProperties getProperties() {
        return this.properties;
    }

    public void setProperties(StringProperties properties) {
        this.properties = properties;
    }

    protected Control createDialogArea(Composite parent) {
        Composite superControl = (Composite)super.createDialogArea(parent);
        this.setTitle("Configure " + this.getModelName());
        this.setMessage("Configure the details of the " + this.getModelName());
        this.getShell().setText("Configure " + this.getModelName());
        Composite control = new Composite(superControl, 4);
        control.setLayout((Layout)new GridLayout(1, true));
        control.setLayoutData((Object)new GridData(768));
        this.createGroups(control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.epsilon.help.emc_dialogs");
        this.loadProperties();
        control.layout();
        control.pack();
        return control;
    }

    protected void createLoadStoreOptionsGroup(Composite parent) {
        Composite groupContent = AbstractModelConfigurationDialog.createGroupContainer(parent, "Load/Store Options", 2);
        this.readOnLoadLabel = new Label(groupContent, 0);
        this.readOnLoadLabel.setText("Read on load: ");
        this.readOnLoadCheckbox = new Button(groupContent, 32);
        this.readOnLoadCheckbox.setLayoutData((Object)new GridData(768));
        this.readOnLoadCheckbox.setSelection(true);
        this.storeOnDisposalLabel = new Label(groupContent, 0);
        this.storeOnDisposalLabel.setText("Store on disposal: ");
        this.storeOnDisposalCheckbox = new Button(groupContent, 32);
        this.storeOnDisposalCheckbox.setLayoutData((Object)new GridData(768));
        this.storeOnDisposalCheckbox.setSelection(true);
        groupContent.layout();
        groupContent.pack();
    }

    protected void createNameAliasGroup(Composite parent) {
        Composite groupContent = AbstractModelConfigurationDialog.createGroupContainer(parent, "Identification", 2);
        this.nameLabel = new Label(groupContent, 0);
        this.nameLabel.setText("Name: ");
        this.nameText = new Text(groupContent, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.aliasesLabel = new Label(groupContent, 0);
        this.aliasesLabel.setText("Aliases: ");
        this.aliasesText = new Text(groupContent, 2048);
        this.aliasesText.setLayoutData((Object)new GridData(768));
        groupContent.layout();
        groupContent.pack();
    }

    protected void loadProperties() {
        if (this.properties == null) {
            return;
        }
        this.nameText.setText(this.properties.getProperty("name"));
        this.aliasesText.setText(this.properties.getProperty("aliases"));
        if (this.readOnLoadCheckbox != null) {
            this.readOnLoadCheckbox.setSelection(new Boolean(this.properties.getProperty("readOnLoad", "true")).booleanValue());
        }
        if (this.storeOnDisposalCheckbox != null) {
            this.storeOnDisposalCheckbox.setSelection(new Boolean(this.properties.getProperty("storeOnDisposal", "false")).booleanValue());
        }
    }

    protected void storeProperties() {
        this.properties = new StringProperties();
        this.properties.put((Object)"type", (Object)this.getModelType());
        this.properties.put((Object)"name", (Object)this.nameText.getText());
        this.properties.put((Object)"aliases", (Object)this.aliasesText.getText());
        if (this.readOnLoadCheckbox != null) {
            this.properties.put((Object)"readOnLoad", (Object)String.valueOf(this.readOnLoadCheckbox.getSelection()));
        }
        if (this.storeOnDisposalCheckbox != null) {
            this.properties.put((Object)"storeOnDisposal", (Object)String.valueOf(this.storeOnDisposalCheckbox.getSelection()));
        }
    }

    protected void okPressed() {
        this.storeProperties();
        super.okPressed();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void createGroups(Composite control) {
        this.createNameAliasGroup(control);
    }

    protected abstract String getModelName();

    protected abstract String getModelType();

    protected class BrowseWorkspaceForMetaModelsListener
    implements Listener {
        private Text text = null;

        public BrowseWorkspaceForMetaModelsListener(Text text) {
            this.text = text;
        }

        public void handleEvent(Event event) {
            String file = BrowseWorkspaceUtil.browseFilePath(AbstractModelConfigurationDialog.this.getShell(), "EMF meta-models in the workspace", "Select an EMF meta-model (ECore)", "ecore", null);
            if (file != null) {
                this.text.setText(file);
            }
        }
    }

    protected class BrowseWorkspaceForModelsListener
    implements Listener {
        private Text text = null;
        private String title = "";
        private String prompt = "";

        public BrowseWorkspaceForModelsListener(Text text, String title, String prompt) {
            this.text = text;
        }

        public void handleEvent(Event event) {
            String file = BrowseWorkspaceUtil.browseFilePath(AbstractModelConfigurationDialog.this.getShell(), this.title, this.prompt, "", null);
            if (file != null) {
                this.text.setText(file);
            }
        }
    }
}

