/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.launching.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BrowseWorkspaceUtil {
    public static String browseFilePath(Shell shell, String title, String message, String filter, Image image) {
        IFile file = BrowseWorkspaceUtil.browseFile(shell, title, message, filter, image);
        if (file != null) {
            return file.getFullPath().toString();
        }
        return null;
    }

    public static IFile browseFile(Shell shell, String title, String message, String filter, Image image) {
        ResourceListSelectionDialog elementSelector = new ResourceListSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 3);
        elementSelector.setTitle(title);
        elementSelector.setMessage(message);
        elementSelector.open();
        if (elementSelector.getReturnCode() == 0) {
            IFile f = (IFile)elementSelector.getResult()[0];
            return f;
        }
        return null;
    }

    public static Object[] browseFiles(Shell shell, String title, String message, String filter, Image image) {
        ElementTreeSelectionDialog elementSelector = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        elementSelector.addFilter((ViewerFilter)new ExtensionViewerFilter(filter));
        elementSelector.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        elementSelector.setTitle(title);
        elementSelector.setMessage(message);
        elementSelector.setAllowMultiple(true);
        elementSelector.setImage(image);
        elementSelector.open();
        if (elementSelector.getReturnCode() == 0) {
            return elementSelector.getResult();
        }
        return null;
    }

    static class ExtensionViewerFilter
    extends ViewerFilter {
        String filter = "";

        public ExtensionViewerFilter(String filter) {
            this.filter = filter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return true;
            }
            if (element instanceof IResource) {
                if (this.filter.length() > 0) {
                    return ((IResource)element).getName().endsWith(this.filter);
                }
                return true;
            }
            return false;
        }
    }
}

