/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.launching.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.epsilon.common.dt.launching.extensions.ModelTypeExtension;
import org.eclipse.epsilon.common.dt.launching.tabs.ModelTypeLabelProvider;
import org.eclipse.epsilon.common.dt.util.ListContentProvider;
import org.eclipse.epsilon.common.dt.util.LogUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModelTypeSelectionDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    protected ArrayList<ModelTypeExtension> modelTypes;
    protected TableViewer modelTypesViewer;
    protected ModelTypeExtension modelType;
    protected Button showAllButton;

    public ModelTypeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        preferredSize.height = 350;
        return super.getConstrainedShellBounds(preferredSize);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridData dialogAreaData = new GridData(1808);
        dialogArea.setLayoutData((Object)dialogAreaData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.epsilon.help.emc_dialogs");
        this.setTitle("Select type of model");
        this.setMessage("Select the type of model to add");
        this.getShell().setText("Select type of model");
        this.getShell().setImage(EpsilonCommonsPlugin.createImage("icons/model.gif"));
        Composite control = new Composite(dialogArea, 0);
        GridLayout controlLayout = new GridLayout(1, false);
        control.setLayout((Layout)controlLayout);
        GridData controlData = new GridData(1808);
        control.setLayoutData((Object)controlData);
        this.findModelTypes();
        this.modelTypesViewer = new TableViewer(control, 2048);
        GridData viewerData = new GridData(1808);
        this.modelTypesViewer.getControl().setLayoutData((Object)viewerData);
        this.modelTypesViewer.getControl().setFocus();
        this.showAllButton = new Button(control, 32);
        GridData showAllButtonGridData = new GridData(768);
        showAllButtonGridData.horizontalAlignment = 0x1000008;
        this.showAllButton.setLayoutData((Object)showAllButtonGridData);
        this.showAllButton.setText("Show all model types");
        this.showAllButton.setSelection(false);
        this.modelTypesViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.modelTypesViewer.setInput(this.getStableModelTypeExtensions());
        this.modelTypesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.modelTypesViewer.setLabelProvider((IBaseLabelProvider)new ModelTypeLabelProvider());
        this.modelTypesViewer.getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ModelTypeSelectionDialog.this.modelType = (ModelTypeExtension)((IStructuredSelection)ModelTypeSelectionDialog.this.modelTypesViewer.getSelection()).getFirstElement();
                if (ModelTypeSelectionDialog.this.modelType != null) {
                    ModelTypeSelectionDialog.this.close();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.modelTypesViewer.refresh();
        this.showAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ArrayList filtered = ModelTypeSelectionDialog.this.showAllButton.getSelection() ? ModelTypeSelectionDialog.this.modelTypes : ModelTypeSelectionDialog.this.getStableModelTypeExtensions();
                ModelTypeSelectionDialog.this.modelTypesViewer.setInput((Object)filtered);
                ModelTypeSelectionDialog.this.modelTypesViewer.refresh();
            }
        });
        return control;
    }

    private ArrayList<ModelTypeExtension> getStableModelTypeExtensions() {
        ArrayList<ModelTypeExtension> filtered = new ArrayList<ModelTypeExtension>();
        for (ModelTypeExtension ext : this.modelTypes) {
            if (!ext.isStable()) continue;
            filtered.add(ext);
        }
        return filtered;
    }

    private void findModelTypes() {
        this.modelTypes = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.epsilon.common.dt.modelType");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        try {
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[i];
                ModelTypeExtension modelType = new ModelTypeExtension();
                modelType.setClazz(configurationElement.getAttribute("class"));
                modelType.setType(configurationElement.getAttribute("type"));
                modelType.setLabel(configurationElement.getAttribute("label"));
                modelType.setStable(Boolean.parseBoolean(configurationElement.getAttribute("stable")));
                String contributingPlugin = configurationElement.getDeclaringExtension().getNamespaceIdentifier();
                Image image = AbstractUIPlugin.imageDescriptorFromPlugin((String)contributingPlugin, (String)configurationElement.getAttribute("icon")).createImage();
                modelType.setImage(image);
                modelType.setConfigurationElement(configurationElement);
                this.modelTypes.add(modelType);
                ++i;
            }
        }
        catch (Exception ex) {
            LogUtil.log(ex);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.modelType = (ModelTypeExtension)((IStructuredSelection)event.getSelection()).getFirstElement();
    }

    public ModelTypeExtension getModelType() {
        return this.modelType;
    }
}

