/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.launching.dialogs;

import org.eclipse.epsilon.common.dt.launching.extensions.ToolExtension;
import org.eclipse.epsilon.common.dt.util.ListContentProvider;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ToolConfigurationDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private StringProperties properties;
    private ComboViewer classCombo;
    private Label classLabel;
    private Text nameText;

    public ToolConfigurationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite superControl = (Composite)super.createDialogArea(parent);
        this.setTitle("Configure Tool");
        this.setMessage("Configure the details of the tool");
        this.getShell().setText("Configure Tool");
        Composite control = new Composite(superControl, 4);
        control.setLayout((Layout)new GridLayout(1, true));
        control.setLayoutData((Object)new GridData(768));
        Composite nameComposite = new Composite(control, 4);
        nameComposite.setLayoutData((Object)new GridData(768));
        GridLayout nameCompositeLayout = new GridLayout(2, false);
        nameComposite.setLayout((Layout)nameCompositeLayout);
        Label nameLabel = new Label(nameComposite, 0);
        nameLabel.setText("Name:");
        nameLabel.setLayoutData((Object)new GridData());
        this.nameText = new Text(nameComposite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.classLabel = new Label(nameComposite, 0);
        this.classLabel.setText("Class:");
        this.classLabel.setLayoutData((Object)new GridData());
        this.classCombo = new ComboViewer(nameComposite, 2056);
        this.classCombo.getControl().setLayoutData((Object)new GridData(768));
        this.classCombo.setContentProvider((IContentProvider)new ListContentProvider());
        this.classCombo.setInput(ToolExtension.getInstances());
        this.classCombo.addPostSelectionChangedListener((ISelectionChangedListener)this);
        this.loadProperties();
        nameComposite.layout();
        nameComposite.pack();
        control.layout();
        control.pack();
        return control;
    }

    protected void okPressed() {
        this.storeProperties();
        super.okPressed();
    }

    private void loadProperties() {
        if (this.properties == null) {
            return;
        }
        this.nameText.setText(this.properties.getProperty("name"));
        this.classCombo.setSelection((ISelection)new StructuredSelection((Object)ToolExtension.forClass(this.properties.getProperty("class"))));
    }

    private void storeProperties() {
        this.properties = new StringProperties();
        this.properties.put((Object)"name", (Object)this.nameText.getText());
        this.properties.put((Object)"class", (Object)((ToolExtension)((StructuredSelection)this.classCombo.getSelection()).getFirstElement()).getClazz());
    }

    public StringProperties getProperties() {
        return this.properties;
    }

    public void setProperties(StringProperties properties) {
        this.properties = properties;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ToolExtension extension = (ToolExtension)((StructuredSelection)this.classCombo.getSelection()).getFirstElement();
        if (extension == null) {
            return;
        }
        this.nameText.setText(extension.getDefaultName());
    }
}

