/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.launching.tabs;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.epsilon.common.dt.launching.dialogs.AbstractModelConfigurationDialog;
import org.eclipse.epsilon.common.dt.launching.dialogs.ModelTypeSelectionDialog;
import org.eclipse.epsilon.common.dt.launching.extensions.ModelTypeExtension;
import org.eclipse.epsilon.common.dt.util.ListContentProvider;
import org.eclipse.epsilon.common.dt.util.StringList;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ModelsConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected List models = new StringList();
    private TableViewer modelsViewer;
    private final List<Button> modelControls = new LinkedList<Button>();

    public void createControl(Composite parent) {
        FillLayout parentLayout = new FillLayout();
        parent.setLayout((Layout)parentLayout);
        Composite control = new Composite(parent, 4);
        this.setControl((Control)control);
        GridLayout controlLayout = new GridLayout(1, false);
        control.setLayout((Layout)controlLayout);
        this.createModelViewerControl(control);
        this.createBottomControl(control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.epsilon.help.emc_dialogs");
        control.pack();
        control.layout();
        this.canSave();
    }

    private void createModelViewerControl(Composite parent) {
        Composite topControl = new Composite(parent, 4);
        GridLayout topControlLayout = new GridLayout(2, false);
        topControl.setLayout((Layout)topControlLayout);
        GridData topControlData = new GridData(1808);
        topControl.setLayoutData((Object)topControlData);
        this.modelsViewer = new TableViewer(topControl, 2048);
        this.modelsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                new EditModelListener().handleEvent(null);
            }
        });
        this.modelsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.modelsViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.modelsViewer.setInput((Object)this.models);
        GridData buttonsData = new GridData(2);
        GridData viewerData = new GridData(1808);
        this.modelsViewer.getControl().setLayoutData((Object)viewerData);
        this.modelsViewer.getControl().setFocus();
        Composite buttons = new Composite(topControl, 132);
        buttons.setLayoutData((Object)buttonsData);
        GridLayout buttonsLayout = new GridLayout(1, true);
        buttons.setLayout((Layout)buttonsLayout);
        this.createButton(buttons, "Add...").addListener(13, (Listener)new AddModelListener());
        this.createButton(buttons, "Edit...").addListener(13, (Listener)new EditModelListener());
        this.createButton(buttons, "Remove").addListener(13, (Listener)new RemoveModelListener());
        this.createButton(buttons, "Duplicate").addListener(13, (Listener)new DuplicateModelListener());
    }

    protected void createBottomControl(Composite parent) {
    }

    protected void addListenerToButtonControls(SelectionListener listener) {
        for (Button control : this.modelControls) {
            control.addSelectionListener(listener);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.models = new StringList((Collection)configuration.getAttribute("models", (List)new StringList()));
            this.modelsViewer.setInput((Object)this.models);
            this.modelsViewer.refresh(true);
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("models", this.models);
    }

    public String getName() {
        return "Models";
    }

    public Image getImage() {
        return EpsilonCommonsPlugin.createImage("icons/model.gif");
    }

    public boolean canSave() {
        this.setErrorMessage(null);
        return true;
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        this.modelControls.add(button);
        return button;
    }

    class AddModelListener
    implements Listener {
        AddModelListener() {
        }

        public void handleEvent(Event event) {
            ModelTypeSelectionDialog dialog = new ModelTypeSelectionDialog(ModelsConfigurationTab.this.getShell());
            dialog.setBlockOnOpen(true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                ModelTypeExtension modelType = dialog.getModelType();
                if (modelType == null) {
                    return;
                }
                try {
                    AbstractModelConfigurationDialog modelConfigurationDialog = modelType.createDialog();
                    modelConfigurationDialog.setBlockOnOpen(true);
                    modelConfigurationDialog.open();
                    if (modelConfigurationDialog.getReturnCode() == 0) {
                        ModelsConfigurationTab.this.models.add(modelConfigurationDialog.getProperties().toString());
                        ModelsConfigurationTab.this.modelsViewer.refresh(true);
                        ModelsConfigurationTab.this.canSave();
                        ModelsConfigurationTab.this.updateLaunchConfigurationDialog();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class DuplicateModelListener
    implements Listener {
        DuplicateModelListener() {
        }

        public void handleEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)ModelsConfigurationTab.this.modelsViewer.getSelection();
            if (selection.getFirstElement() == null) {
                return;
            }
            int index = ModelsConfigurationTab.this.models.indexOf(selection.getFirstElement());
            ModelsConfigurationTab.this.models.add(index, selection.getFirstElement());
            ModelsConfigurationTab.this.modelsViewer.refresh(true);
            ModelsConfigurationTab.this.canSave();
            ModelsConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }

    class EditModelListener
    implements Listener {
        EditModelListener() {
        }

        public void handleEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)ModelsConfigurationTab.this.modelsViewer.getSelection();
            if (selection.getFirstElement() == null) {
                return;
            }
            StringProperties properties = new StringProperties();
            properties.load(selection.getFirstElement().toString());
            ModelTypeExtension modelType = ModelTypeExtension.forType(properties.getProperty("type"));
            AbstractModelConfigurationDialog dialog = null;
            try {
                dialog = modelType.createDialog();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            dialog.setBlockOnOpen(true);
            dialog.setProperties(properties);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                int index = ModelsConfigurationTab.this.models.indexOf(selection.getFirstElement());
                ModelsConfigurationTab.this.models.add(index, dialog.getProperties().toString());
                ModelsConfigurationTab.this.models.remove(index + 1);
                ModelsConfigurationTab.this.modelsViewer.refresh(true);
                ModelsConfigurationTab.this.canSave();
                ModelsConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        }
    }

    class ModelLabelProvider
    implements ILabelProvider {
        ModelLabelProvider() {
        }

        public Image getImage(Object element) {
            StringProperties properties = new StringProperties();
            properties.load(element.toString());
            return ModelTypeExtension.forType(properties.getProperty("type")).getImage();
        }

        public String getText(Object element) {
            StringProperties properties = new StringProperties();
            properties.load(element.toString());
            return properties.getProperty("name");
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class RemoveModelListener
    implements Listener {
        RemoveModelListener() {
        }

        public void handleEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)ModelsConfigurationTab.this.modelsViewer.getSelection();
            if (selection.getFirstElement() == null) {
                return;
            }
            int index = ModelsConfigurationTab.this.models.indexOf(selection.getFirstElement());
            ModelsConfigurationTab.this.models.remove(index);
            ModelsConfigurationTab.this.modelsViewer.refresh(true);
            ModelsConfigurationTab.this.canSave();
            ModelsConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

