/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.launching.tabs;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.epsilon.common.dt.launching.dialogs.ToolConfigurationDialog;
import org.eclipse.epsilon.common.dt.util.StringList;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ToolsConfigurationTab
extends AbstractLaunchConfigurationTab {
    private List tools = new StringList();
    private TableViewer toolsViewer;

    public void createControl(Composite parent) {
        FillLayout parentLayout = new FillLayout();
        parent.setLayout((Layout)parentLayout);
        Composite control = new Composite(parent, 4);
        this.setControl((Control)control);
        GridLayout controlLayout = new GridLayout(2, false);
        control.setLayout((Layout)controlLayout);
        this.toolsViewer = new TableViewer(control, 2048);
        this.toolsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.toolsViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.toolsViewer.setInput((Object)this.tools);
        GridData buttonsData = new GridData(2);
        GridData viewerData = new GridData(1808);
        this.toolsViewer.getControl().setLayoutData((Object)viewerData);
        Composite buttons = new Composite(control, 132);
        buttons.setLayoutData((Object)buttonsData);
        GridLayout buttonsLayout = new GridLayout(1, true);
        buttons.setLayout((Layout)buttonsLayout);
        this.createButton(buttons, "Add...").addListener(13, (Listener)new AddModelListener());
        this.createButton(buttons, "Edit...").addListener(13, (Listener)new EditModelListener());
        this.createButton(buttons, "Remove").addListener(13, (Listener)new RemoveModelListener());
        control.pack();
        control.layout();
        this.canSave();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.tools = new StringList((Collection)configuration.getAttribute("tools", (List)new StringList()));
            this.toolsViewer.setInput((Object)this.tools);
            this.toolsViewer.refresh(true);
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("tools", this.tools);
    }

    public String getName() {
        return "Tools";
    }

    public Image getImage() {
        return EpsilonCommonsPlugin.createImage("icons/tool.gif");
    }

    public boolean canSave() {
        this.setErrorMessage(null);
        return true;
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        return button;
    }

    class AddModelListener
    implements Listener {
        AddModelListener() {
        }

        public void handleEvent(Event event) {
            try {
                ToolConfigurationDialog toolConfigurationDialog = new ToolConfigurationDialog(ToolsConfigurationTab.this.getShell());
                toolConfigurationDialog.setBlockOnOpen(true);
                toolConfigurationDialog.open();
                if (toolConfigurationDialog.getReturnCode() == 0) {
                    ToolsConfigurationTab.this.tools.add(toolConfigurationDialog.getProperties().toString());
                    ToolsConfigurationTab.this.toolsViewer.refresh(true);
                    ToolsConfigurationTab.this.canSave();
                    ToolsConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class EditModelListener
    implements Listener {
        EditModelListener() {
        }

        public void handleEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)ToolsConfigurationTab.this.toolsViewer.getSelection();
            if (selection.getFirstElement() == null) {
                return;
            }
            StringProperties properties = new StringProperties();
            properties.load(selection.getFirstElement().toString());
            ToolConfigurationDialog dialog = new ToolConfigurationDialog(ToolsConfigurationTab.this.getShell());
            dialog.setBlockOnOpen(true);
            dialog.setProperties(properties);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                int index = ToolsConfigurationTab.this.tools.indexOf(selection.getFirstElement());
                ToolsConfigurationTab.this.tools.add(index, dialog.getProperties().toString());
                ToolsConfigurationTab.this.tools.remove(index + 1);
                ToolsConfigurationTab.this.toolsViewer.refresh(true);
                ToolsConfigurationTab.this.canSave();
                ToolsConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        }
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List list = (List)inputElement;
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ModelLabelProvider
    implements ILabelProvider {
        ModelLabelProvider() {
        }

        public Image getImage(Object element) {
            return EpsilonCommonsPlugin.createImage("icons/tool.gif");
        }

        public String getText(Object element) {
            StringProperties properties = new StringProperties();
            properties.load(element.toString());
            return String.valueOf(properties.getProperty("name")) + " (" + properties.getProperty("class") + ")";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class RemoveModelListener
    implements Listener {
        RemoveModelListener() {
        }

        public void handleEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)ToolsConfigurationTab.this.toolsViewer.getSelection();
            if (selection.getFirstElement() == null) {
                return;
            }
            int index = ToolsConfigurationTab.this.tools.indexOf(selection.getFirstElement());
            ToolsConfigurationTab.this.tools.remove(index);
            ToolsConfigurationTab.this.toolsViewer.refresh(true);
            ToolsConfigurationTab.this.canSave();
            ToolsConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

