/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.nature;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epsilon.common.dt.nature.AbstractNature;

public abstract class BuilderConfiguringNature
extends AbstractNature {
    protected abstract String getBuilderID();

    public void configure() throws CoreException {
        if (!this.projectHasBuildSpecForBuilder()) {
            this.applyBuildSpecToProject(this.addCommandForOurBuilderToExistingBuildSpec());
        }
    }

    private Collection<ICommand> addCommandForOurBuilderToExistingBuildSpec() throws CoreException {
        LinkedList<ICommand> newBuildSpec = new LinkedList<ICommand>();
        newBuildSpec.add(this.createOurBuildCommand());
        newBuildSpec.addAll(Arrays.asList(this.project.getDescription().getBuildSpec()));
        return newBuildSpec;
    }

    private ICommand createOurBuildCommand() throws CoreException {
        ICommand buildCommand = this.project.getDescription().newCommand();
        buildCommand.setBuilderName(this.getBuilderID());
        return buildCommand;
    }

    private void applyBuildSpecToProject(Collection<ICommand> buildSpec) throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        desc.setBuildSpec(buildSpec.toArray(new ICommand[0]));
        this.project.setDescription(desc, null);
    }

    public void deconfigure() {
    }

    private boolean projectHasBuildSpecForBuilder() throws CoreException {
        if (this.project != null) {
            ICommand[] iCommandArray = this.project.getDescription().getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand buildCommand = iCommandArray[n2];
                if (this.getBuilderID().equals(buildCommand.getBuilderName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

