/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.nature;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epsilon.common.dt.actions.AbstractObjectActionDelegate;
import org.eclipse.epsilon.common.dt.util.LogUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;

public abstract class ToggleNatureAction
extends AbstractObjectActionDelegate
implements IObjectActionDelegate {
    protected abstract String getNatureId();

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        try {
            action.setChecked(this.containsNature(selection));
        }
        catch (CoreException e) {
            LogUtil.log("Error encountered will trying to check or uncheck a ToggleNatureAction", (Exception)((Object)e));
        }
    }

    @Override
    public void run(IAction action) {
        try {
            if (this.getFirstElementInSelection() instanceof IProject) {
                IProject project = (IProject)this.getFirstElementInSelection();
                this.applyNaturesToProject(project, this.toggleNature(project));
            }
        }
        catch (CoreException e) {
            LogUtil.log("Error encountered will trying toggle a nature", (Exception)((Object)e));
        }
    }

    private Collection<String> toggleNature(IProject project) throws CoreException {
        String[] currentNatureIds = project.getDescription().getNatureIds();
        Collection<String> newNatureIds = this.containsOurNature(currentNatureIds) ? this.removeOurNature(currentNatureIds) : this.addOurNature(currentNatureIds);
        return newNatureIds;
    }

    private void applyNaturesToProject(IProject project, Collection<String> natureIds) throws CoreException {
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(natureIds.toArray(new String[0]));
        project.setDescription(desc, null);
    }

    private Collection<String> addOurNature(String[] natureIds) {
        LinkedList<String> newNatureIds = new LinkedList<String>();
        newNatureIds.add(this.getNatureId());
        newNatureIds.addAll(Arrays.asList(natureIds));
        return newNatureIds;
    }

    private Collection<String> removeOurNature(String[] natureIds) {
        LinkedList<String> newNatureIds = new LinkedList<String>(Arrays.asList(natureIds));
        newNatureIds.remove(this.getNatureId());
        return newNatureIds;
    }

    private boolean containsNature(ISelection selection) throws CoreException {
        if (this.getFirstElementOf(selection) instanceof IProject) {
            IProject project = (IProject)this.getFirstElementOf(selection);
            String[] natureIds = project.getDescription().getNatureIds();
            return this.containsOurNature(natureIds);
        }
        return false;
    }

    private boolean containsOurNature(String[] natureIds) {
        String[] stringArray = natureIds;
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            if (this.getNatureId().equals(natureId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

