/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LogUtil {
    public static void log(int severity, int code, String message, Exception ex) {
        EpsilonCommonsPlugin.getDefault().getLog().log((IStatus)new Status(severity, "org.eclipse.epsilon.common.dt", code, message, (Throwable)ex));
    }

    public static void logInfo(Object message) {
        LogUtil.logInfo(message.toString(), false);
    }

    public static void logInfo(final Object message, final boolean openInfoDialog) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EpsilonCommonsPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.epsilon.common.dt", message.toString()));
                if (openInfoDialog) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Information", (String)message.toString());
                }
            }
        });
    }

    public static void log(String message, Exception ex) {
        LogUtil.log(4, 0, message, ex);
    }

    public static void log(String message, Exception ex, boolean openErrorDialog) {
        LogUtil.log(message, ex);
        if (openErrorDialog) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)(String.valueOf(message) + "\r\nPlease check the error log for further information"));
        }
    }

    public static void log(Exception ex) {
        LogUtil.log(ex.getMessage(), ex);
    }
}

