/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.debug;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.epsilon.eol.dt.EolPlugin;
import org.eclipse.epsilon.eol.dt.debug.EolDebugConstants;

public class EolBreakpoint
extends LineBreakpoint {
    public static EolBreakpointUpdater updater = null;

    public EolBreakpoint() {
        this.configureUpdater();
    }

    public EolBreakpoint(final IResource resource, final int lineNumber) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(EolDebugConstants.BREAKPOINT_MARKER);
                EolBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)EolBreakpoint.this.getModelIdentifier());
                marker.setAttribute("message", (Object)EolBreakpoint.this.getMessage(resource, lineNumber));
            }
        };
        this.getLineNumber();
        this.run(this.getMarkerRule(resource), runnable);
        this.configureUpdater();
    }

    protected String getMessage(IResource resource, int lineNumber) {
        return "Line breakpoint:" + resource.getName() + " [line: " + lineNumber + "]";
    }

    protected void configureUpdater() {
        if (updater == null) {
            updater = new EolBreakpointUpdater();
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)updater);
        }
    }

    public String getModelIdentifier() {
        return EolDebugConstants.MODEL_IDENTIFIER;
    }

    class EolBreakpointUpdater
    implements IBreakpointListener {
        EolBreakpointUpdater() {
        }

        public void breakpointAdded(IBreakpoint breakpoint) {
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            if (breakpoint instanceof EolBreakpoint) {
                try {
                    ((EolBreakpoint)breakpoint).setAttribute("message", EolBreakpoint.this.getMessage(breakpoint.getMarker().getResource(), ((EolBreakpoint)breakpoint).getLineNumber()));
                }
                catch (CoreException e) {
                    EolPlugin.getDefault().logException((Exception)((Object)e));
                }
            }
        }
    }
}

