/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.debug;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.dt.debug.EolDebugElement;
import org.eclipse.epsilon.eol.dt.debug.EolDebugger;
import org.eclipse.epsilon.eol.dt.debug.EolThread;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;

public class EolDebugTarget
extends EolDebugElement
implements IDebugTarget {
    protected boolean suspended;
    protected boolean terminated;
    protected EolDebugger debugger = null;
    protected ILaunch launch;
    protected IThread[] threads = new IThread[1];
    protected IProcess process;
    protected IEolExecutableModule module;
    protected String name;

    public EolDebugTarget(ILaunch launch, IEolExecutableModule module, EolDebugger debugger, String name) {
        super(null);
        this.launch = launch;
        this.threads[0] = new EolThread(this);
        this.module = module;
        this.debugger = debugger;
        module.getContext().getExecutorFactory().setExecutionController((ExecutionController)debugger);
        this.name = name;
    }

    public IEolExecutableModule getModule() {
        return this.module;
    }

    public void stepInto() throws DebugException {
        this.fireSuspendEvent(2);
        this.debugger.step();
        this.fireResumeEvent(1);
    }

    public void stepOver() throws DebugException {
        this.fireSuspendEvent(2);
        this.debugger.stepOver();
        this.fireResumeEvent(2);
    }

    public void stepReturn() {
        this.fireSuspendEvent(2);
        this.debugger.stepReturn();
        this.fireResumeEvent(4);
    }

    public Object debug() throws DebugException, EolRuntimeException {
        this.fireCreationEvent();
        return this.debugger.debug(this.module);
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.terminated = true;
        this.suspended = false;
        this.fireTerminateEvent();
    }

    public boolean canResume() {
        return this.isSuspended() && !this.isTerminated();
    }

    public boolean canSuspend() {
        return !this.isSuspended() && !this.isTerminated();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.suspended = false;
        this.fireResumeEvent(1);
    }

    public void suspend() throws DebugException {
        this.suspended = true;
        this.fireSuspendEvent(2);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }
}

