/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.debug;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.epsilon.common.dt.util.EclipseUtil;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.dt.EolPlugin;
import org.eclipse.epsilon.eol.dt.debug.EolDebugConstants;
import org.eclipse.epsilon.eol.dt.debug.EolDebugTarget;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;

public class EolDebugger
implements ExecutionController {
    protected ArrayList<Integer> expressionOrStatementBlockContainers = new ArrayList();
    protected ArrayList<Integer> structuralBlocks = new ArrayList();
    private IDebugTarget target = null;
    private boolean stepping = false;
    private HashMap<String, IFile> iFiles = new HashMap();
    private AST currentAST;
    private AST stopAfterAST;
    private Integer stopAfterFrameStackSizeDropsBelow;

    public EolDebugger() {
        this.expressionOrStatementBlockContainers.add(28);
    }

    public void control(AST ast, IEolContext context) {
        if (!this.controls(ast, context)) {
            return;
        }
        IFile lastFile = this.getIFile(ast);
        this.currentAST = ast;
        if (this.stepping) {
            this.stepping = false;
            this.suspend(lastFile, ast);
        } else if (this.hasBreakpoint(ast)) {
            this.suspend(lastFile, ast);
        }
        if (this.target.isTerminated()) {
            return;
        }
    }

    public void done(AST ast, IEolContext context) {
        if (this.stopAfterAST != null && ast == this.stopAfterAST) {
            this.stepping = true;
            this.stopAfterAST = null;
        }
        if (this.stopAfterFrameStackSizeDropsBelow != null && this.frameStackSize() < this.stopAfterFrameStackSizeDropsBelow) {
            this.stepping = true;
            this.stopAfterFrameStackSizeDropsBelow = null;
        }
    }

    public boolean isTerminated() {
        return this.target.isTerminated();
    }

    public void report(IEolContext context) {
    }

    public void dispose() {
        this.target = null;
    }

    public Object debug(IEolExecutableModule module) throws EolRuntimeException {
        Object result = module.execute();
        try {
            this.target.terminate();
        }
        catch (DebugException e) {
            throw new EolRuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public void setTarget(IDebugTarget target) {
        this.target = target;
    }

    public IDebugTarget getTarget() {
        return this.target;
    }

    public void step() {
        this.stepping = true;
    }

    public void stepOver() {
        this.stopAfterAST = this.currentAST;
    }

    public void stepReturn() {
        this.stopAfterFrameStackSizeDropsBelow = this.frameStackSize();
    }

    private boolean controls(AST ast, IEolContext context) {
        if (ast.getParent() == null || ast.getType() == 61) {
            return false;
        }
        return this.isStatement(ast) || this.isContainedExpression(ast);
    }

    private int frameStackSize() {
        return ((EolDebugTarget)this.target).getModule().getContext().getFrameStack().getFrames().size();
    }

    private ArrayList<Integer> getExpressionOrStatementBlockHolders() {
        return this.expressionOrStatementBlockContainers;
    }

    private int getRealLine(int line) {
        return line;
    }

    private IFile getIFile(AST ast) {
        if (ast.getFile() != null) {
            return this.getIFile(ast.getFile());
        }
        return this.getIFile(ast.getUri());
    }

    private IFile getIFile(File file) {
        IFile iFile = this.iFiles.get(file.getAbsolutePath());
        if (iFile == null) {
            iFile = this.getIFile(file.toURI());
            this.iFiles.put(file.getAbsolutePath(), iFile);
        }
        return iFile;
    }

    private IFile getIFile(URI uri) {
        String[] uriParts = uri.toString().split("platform:/resource");
        if (uriParts.length > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uriParts[1]));
        }
        return ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri)[0];
    }

    private AST getGrandparent(AST ast) {
        return this.getParent(this.getParent(ast));
    }

    private AST getParent(AST ast) {
        return ast != null ? ast.getParent() : null;
    }

    private boolean hasBreakpoint(AST ast) {
        if (this.hasBreakpointItself(ast)) {
            return true;
        }
        if (this.isFirstStatement(ast)) {
            return this.hasBreakpoint(this.getGrandparent(ast));
        }
        if (this.isContainedExpression(ast)) {
            return this.hasBreakpoint(this.getParent(ast));
        }
        if (this.isStructuralBlock(this.getParent(ast))) {
            if (this.isExpressionOrStatementBlockContainer(ast)) {
                return this.hasBreakpoint(this.getParent(ast));
            }
            if (this.isStructuralBlock(ast)) {
                return this.hasBreakpoint(this.getParent(ast));
            }
        }
        return false;
    }

    private boolean hasBreakpointItself(AST ast) {
        IBreakpoint[] breakpoints;
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return false;
        }
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(EolDebugConstants.MODEL_IDENTIFIER);
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            IMarker marker = breakpoint.getMarker();
            if (marker.getResource().equals((Object)this.getIFile(ast)) && marker.getAttribute("lineNumber", 0) == this.getRealLine(ast.getLine())) {
                try {
                    return breakpoint.isEnabled();
                }
                catch (CoreException e) {
                    EolPlugin.getDefault().logException((Exception)((Object)e));
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean isExpressionOrStatementBlockContainer(AST ast) {
        if (ast == null) {
            return false;
        }
        return this.getExpressionOrStatementBlockHolders().contains(ast.getType());
    }

    private boolean isStructuralBlock(AST ast) {
        if (ast == null) {
            return false;
        }
        return this.structuralBlocks.contains(ast.getType());
    }

    private boolean isContainedExpression(AST ast) {
        AST parent = this.getParent(ast);
        if (parent == null) {
            return false;
        }
        return this.isExpressionOrStatementBlockContainer(parent) && parent.getChildCount() == 1;
    }

    private boolean isFirstStatement(AST ast) {
        AST parent = this.getParent(ast);
        if (parent == null) {
            return false;
        }
        if (parent.getType() != 61) {
            return false;
        }
        AST grandparent = this.getParent(parent);
        if (!this.isExpressionOrStatementBlockContainer(grandparent)) {
            return false;
        }
        return parent.getFirstChild() == ast;
    }

    private boolean isStatement(AST ast) {
        AST parent = this.getParent(ast);
        if (parent == null) {
            return false;
        }
        return parent.getType() == 61;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspend(IFile file, AST ast) {
        try {
            this.target.suspend();
            EclipseUtil.openEditorAt((IFile)file, (int)this.getRealLine(ast.getLine()), (int)1, (boolean)false);
            while (this.target.isSuspended() && !this.stepping && this.stopAfterAST == null && this.stopAfterFrameStackSizeDropsBelow == null) {
                EolDebugger eolDebugger = this;
                synchronized (eolDebugger) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Exception exception) {}
    }
}

