/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.debug;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.epsilon.common.dt.util.EclipseUtil;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dt.EolPlugin;
import org.eclipse.epsilon.eol.dt.debug.EolDebugElement;
import org.eclipse.epsilon.eol.dt.debug.EolVariable;
import org.eclipse.epsilon.eol.dt.debug.IVariableNameComparator;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EolStackFrame
extends EolDebugElement
implements IStackFrame {
    protected IThread thread;
    protected Frame frame;
    protected String name;

    public EolStackFrame(IThread thread, Frame frame, String name) {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.frame = frame;
        this.name = name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ISourceDisplay.class)) {
            return new EolSourceDisplay();
        }
        return super.getAdapter(adapter);
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        int i = 0;
        IVariable[] eolVariables = new EolVariable[this.frame.getAll().size()];
        for (Variable v : this.frame.getAll().values()) {
            eolVariables[i] = new EolVariable(this.getDebugTarget(), v.getName(), v.getValue());
            ++i;
        }
        Arrays.sort(eolVariables, new IVariableNameComparator());
        return eolVariables;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        if (this.frame.getCurrentStatement() != null) {
            return this.frame.getCurrentStatement().getLine();
        }
        return -1;
    }

    public int getCharStart() throws DebugException {
        int charStart = this.getCharStart(this.frame.getCurrentStatement());
        if (charStart < 0) {
            charStart = this.getCharStart(this.frame.getEntryPoint());
        }
        return charStart;
    }

    public int getCharEnd() throws DebugException {
        int charEnd = this.getCharEnd(this.frame.getCurrentStatement());
        if (charEnd < 0) {
            return this.getCharEnd(this.frame.getEntryPoint());
        }
        return charEnd;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    private int getCharStart(AST ast) throws DebugException {
        if (ast != null) {
            IDocument doc = this.getDocument(ast);
            try {
                if (doc != null) {
                    return doc.getLineOffset(ast.getLine() - 1);
                }
            }
            catch (BadLocationException e) {
                EolPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return -1;
    }

    private int getCharEnd(AST ast) throws DebugException {
        if (ast != null) {
            IDocument doc = this.getDocument(ast);
            try {
                if (doc != null) {
                    return doc.getLineOffset(ast.getLine());
                }
            }
            catch (BadLocationException e) {
                EolPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return -1;
    }

    private IDocument getDocument(AST current) {
        IFile file = EclipseUtil.findIFile((AST)current);
        try {
            IEditorPart editor;
            if (file != null && (editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)false)) instanceof AbstractTextEditor) {
                return ((AbstractTextEditor)editor).getDocumentProvider().getDocument((Object)new FileEditorInput(file));
            }
        }
        catch (PartInitException e) {
            EolPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    private static final class EolSourceDisplay
    implements ISourceDisplay {
        private EolSourceDisplay() {
        }

        public void displaySource(Object element, IWorkbenchPage page, boolean forceSourceLookup) {
            if (element instanceof EolStackFrame) {
                ISourceLookupResult lookupResult = DebugUITools.lookupSource((Object)element, (ISourceLocator)new EolSourceLocator());
                DebugUITools.displaySource((ISourceLookupResult)lookupResult, (IWorkbenchPage)page);
            }
        }
    }

    private static final class EolSourceLocator
    implements ISourceLocator,
    ISourcePresentation {
        private EolSourceLocator() {
        }

        public Object getSourceElement(IStackFrame stackFrame) {
            if (stackFrame instanceof EolStackFrame) {
                EolStackFrame eolSF = (EolStackFrame)stackFrame;
                IFile file = EclipseUtil.findIFile((AST)eolSF.frame.getCurrentStatement());
                if (file == null) {
                    file = EclipseUtil.findIFile((AST)eolSF.frame.getEntryPoint());
                }
                return file;
            }
            return null;
        }

        public IEditorInput getEditorInput(Object element) {
            if (element instanceof IFile) {
                return new FileEditorInput((IFile)element);
            }
            return null;
        }

        public String getEditorId(IEditorInput input, Object element) {
            IEditorDescriptor editor;
            if (element instanceof IFile && (editor = IDE.getDefaultEditor((IFile)((IFile)element))) != null) {
                return editor.getId();
            }
            return null;
        }
    }
}

