/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.debug;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.epsilon.eol.dt.debug.EolDebugElement;
import org.eclipse.epsilon.eol.dt.debug.EolDebugTarget;
import org.eclipse.epsilon.eol.dt.debug.EolVariable;
import org.eclipse.epsilon.eol.dt.debug.IVariableNameComparator;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public class EolVariableValue
extends EolDebugElement
implements IValue {
    private final Object value;
    private final EolVariable variable;
    private IVariable[] children;
    private static final Set<Class<?>> PRIMITIVE_WRAPPER_CLASSES = new HashSet();

    static {
        PRIMITIVE_WRAPPER_CLASSES.add(Boolean.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Character.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Byte.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Short.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Integer.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Long.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Float.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Double.class);
        PRIMITIVE_WRAPPER_CLASSES.add(Void.class);
    }

    public EolVariableValue(IDebugTarget target, EolVariable variable, Object value) {
        super(target);
        this.variable = variable;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public EolVariable getVariable() {
        return this.variable;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value != null ? this.value.getClass().getCanonicalName() : "(null)";
    }

    public String getValueString() throws DebugException {
        return "" + this.value;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.children == null) {
            if (!this.isNullOrPrimitiveWrapper(this.value) && !this.variable.isLoop()) {
                ArrayList<EolVariable> subvars = new ArrayList<EolVariable>();
                if (this.value instanceof Collection) {
                    int i = 0;
                    Iterator it = ((Collection)this.value).iterator();
                    while (it.hasNext()) {
                        subvars.add(new EolVariable(this.getDebugTarget(), "[" + i++ + "]", it.next()));
                    }
                } else if (this.value instanceof Object[]) {
                    Object[] array = (Object[])this.value;
                    int i = 0;
                    while (i < array.length) {
                        subvars.add(new EolVariable(this.getDebugTarget(), "[" + i + "]", array[i]));
                        ++i;
                    }
                }
                List fields = ReflectionUtil.getAllInheritedInstanceFields(this.value.getClass());
                for (Field f : fields) {
                    boolean bl = f.isAccessible();
                    try {
                        f.setAccessible(true);
                        subvars.add(new EolVariable(this.getDebugTarget(), f.getName(), f.get(this.value)));
                        f.setAccessible(bl);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (SecurityException securityException) {}
                }
                EolDebugTarget dt = (EolDebugTarget)this.getDebugTarget();
                Map allExtProps = dt.getModule().getContext().getExtendedProperties();
                if (allExtProps.containsKey(this.value)) {
                    for (Map.Entry entry : ((Map)allExtProps.get(this.value)).entrySet()) {
                        subvars.add(new EolVariable(this.getDebugTarget(), "~" + (String)entry.getKey(), entry.getValue()));
                    }
                }
                Collections.sort(subvars, new IVariableNameComparator());
                for (IVariable iVariable : subvars) {
                    EolVariable eolVar = (EolVariable)iVariable;
                    EolVariableValue eolVarValue = (EolVariableValue)iVariable.getValue();
                    if (eolVarValue.getValue() != this.value) continue;
                    eolVar.setLoop(true);
                }
                this.children = subvars.toArray(new IVariable[subvars.size()]);
            } else {
                this.children = new IVariable[0];
            }
        }
        return this.children;
    }

    private boolean isNullOrPrimitiveWrapper(Object value) {
        return value == null || PRIMITIVE_WRAPPER_CLASSES.contains(value.getClass());
    }

    public boolean hasVariables() throws DebugException {
        IVariable[] vars = this.getVariables();
        return vars != null && vars.length > 0;
    }
}

