/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.epsilon.common.dt.editor.IModuleParseListener;
import org.eclipse.epsilon.common.dt.editor.contentassist.IAbstractModuleEditorTemplateContributor;
import org.eclipse.epsilon.common.dt.editor.contentassist.TemplateWithImage;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dt.EolPlugin;
import org.eclipse.epsilon.eol.util.EolParserUtil;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.graphics.Image;

public class EolEditorPropertyTemplateContributor
implements IAbstractModuleEditorTemplateContributor,
IModuleParseListener {
    protected List<Template> templates = new ArrayList<Template>();
    protected HashSet<String> properties = new HashSet();
    Image propertyImage = EolPlugin.getDefault().createImage("icons/property.gif");

    public List<Template> getTemplates() {
        return this.templates;
    }

    public void moduleParsed(AbstractModuleEditor editor, IModule module) {
        this.templates.clear();
        this.properties.clear();
        this.findProperties(module.getAst());
        for (String property : this.properties) {
            this.templates.add((Template)new TemplateWithImage(property, "property", "", property, false, this.propertyImage));
        }
        System.err.println(this.templates.size());
    }

    protected void findProperties(AST root) {
        if (EolParserUtil.isProperty((AST)root)) {
            this.properties.add(root.getText());
        }
        for (AST child : root.getChildren()) {
            this.findProperties(child);
        }
    }
}

