/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.epsilon.common.dt.console.EpsilonConsole;
import org.eclipse.epsilon.common.dt.util.LogUtil;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.dt.debug.EolDebugTarget;
import org.eclipse.epsilon.eol.dt.debug.EolDebugger;
import org.eclipse.epsilon.eol.dt.launching.EclipseContextManager;
import org.eclipse.epsilon.eol.dt.launching.EpsilonLaunchConfigurationDelegateListener;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public abstract class EpsilonLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements EpsilonLaunchConfigurationDelegateListener {
    protected Object result = null;
    protected ILaunchConfiguration configuration = null;
    protected ArrayList<EpsilonLaunchConfigurationDelegateListener> listeners = null;

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!super.saveBeforeLaunch(configuration, mode, monitor)) {
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor progressMonitor) throws CoreException {
        this.configuration = configuration;
        this.launch(configuration, mode, launch, progressMonitor, this.createModule(), this.createDebugger(), "source", true, true);
    }

    public boolean launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor progressMonitor, IEolExecutableModule module, EolDebugger debugger, String lauchConfigurationSourceAttribute, boolean setup, boolean disposeModelRepository) throws CoreException {
        this.collectListeners();
        if (setup) {
            EpsilonConsole.getInstance().clear();
        }
        this.aboutToParse(configuration, mode, launch, progressMonitor, module);
        if (!this.parse((IModule)module, lauchConfigurationSourceAttribute, configuration, mode, launch, progressMonitor)) {
            return false;
        }
        EolDebugTarget target = null;
        try {
            try {
                EclipseContextManager.setup(module.getContext(), configuration, progressMonitor, launch, setup);
                this.aboutToExecute(configuration, mode, launch, progressMonitor, module);
                String subtask = "Executing";
                progressMonitor.subTask(subtask);
                progressMonitor.beginTask(subtask, 100);
                if ("run".equalsIgnoreCase(mode)) {
                    this.result = module.execute();
                } else if ("debug".equalsIgnoreCase(mode)) {
                    Map configurationAttributes = configuration.getAttributes();
                    for (Object key : configurationAttributes.keySet()) {
                        launch.setAttribute("" + key, "" + configurationAttributes.get(key));
                    }
                    String name = launch.getAttribute(lauchConfigurationSourceAttribute);
                    target = new EolDebugTarget(launch, module, debugger, name);
                    debugger.setTarget(target);
                    launch.addDebugTarget((IDebugTarget)target);
                    this.result = target.debug();
                }
                this.executed(configuration, mode, launch, progressMonitor, module, this.result);
            }
            catch (Exception e2) {
                EolRuntimeException e2 = EolRuntimeException.wrap((Throwable)e2);
                e2.printStackTrace();
                module.getContext().getErrorStream().println(e2.toString());
                progressMonitor.setCanceled(true);
                if (target != null && !disposeModelRepository) {
                    launch.removeDebugTarget(target);
                }
                this.teardown(module.getContext(), disposeModelRepository);
                return false;
            }
        }
        finally {
            if (target != null && !disposeModelRepository) {
                launch.removeDebugTarget(target);
            }
            this.teardown(module.getContext(), disposeModelRepository);
        }
        progressMonitor.done();
        return true;
    }

    public abstract IEolExecutableModule createModule() throws CoreException;

    protected void collectListeners() {
        this.listeners = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.epsilon.eol.dt.launchConfigurationExtension");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[i];
            try {
                EpsilonLaunchConfigurationDelegateListener listener = (EpsilonLaunchConfigurationDelegateListener)configurationElement.createExecutableExtension("listener");
                this.listeners.add(listener);
            }
            catch (CoreException e) {
                LogUtil.log((Exception)((Object)e));
            }
            ++i;
        }
    }

    @Override
    public void aboutToParse(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor progressMonitor, IEolExecutableModule module) throws CoreException {
        this.preParse(module);
        for (EpsilonLaunchConfigurationDelegateListener listener : this.listeners) {
            listener.aboutToParse(configuration, mode, launch, progressMonitor, module);
        }
    }

    @Override
    public void aboutToExecute(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor progressMonitor, IEolExecutableModule module) throws Exception {
        this.preExecute(module);
        for (EpsilonLaunchConfigurationDelegateListener listener : this.listeners) {
            listener.aboutToExecute(configuration, mode, launch, progressMonitor, module);
        }
    }

    @Override
    public void executed(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor progressMonitor, IEolExecutableModule module, Object result) throws Exception {
        this.postExecute(module);
        for (EpsilonLaunchConfigurationDelegateListener listener : this.listeners) {
            listener.executed(configuration, mode, launch, progressMonitor, module, result);
        }
    }

    protected void preParse(IEolExecutableModule module) {
    }

    protected void preExecute(IEolExecutableModule module) throws CoreException, EolRuntimeException {
    }

    protected void postExecute(IEolExecutableModule module) throws CoreException, EolRuntimeException {
    }

    protected EolDebugger createDebugger() {
        return new EolDebugger();
    }

    protected boolean parse(IModule module, String sourceAttribute, ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor progressMonitor) throws CoreException {
        String subTask = "";
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(configuration.getAttribute(sourceAttribute, "")));
        String fileName = file.getRawLocation().toOSString();
        subTask = "Parsing " + fileName;
        progressMonitor.subTask(subTask);
        progressMonitor.beginTask(subTask, 100);
        boolean parsed = false;
        try {
            parsed = module.parse(new File(fileName));
        }
        catch (Exception e) {
            e.printStackTrace(EpsilonConsole.getInstance().getErrorStream());
            return false;
        }
        progressMonitor.done();
        if (!parsed) {
            for (ParseProblem problem : module.getParseProblems()) {
                EpsilonConsole.getInstance().getErrorStream().println(problem.toString());
            }
        }
        return parsed;
    }

    public void teardown(IEolContext context, boolean disposeModelRepository) {
        if (disposeModelRepository) {
            context.getModelRepository().dispose();
        }
        context.getExecutorFactory().getExecutionController().dispose();
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            LogUtil.log((Exception)((Object)e));
        }
    }
}

