/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.launching.tabs;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.epsilon.common.dt.launching.dialogs.BrowseWorkspaceUtil;
import org.eclipse.epsilon.eol.dt.EolPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EolSourceConfigurationTab1
extends AbstractLaunchConfigurationTab
implements ModifyListener {
    protected Label fileLabel;
    protected Text filePath;
    protected Button browse;

    public void createControl(Composite parent) {
        FillLayout parentLayout = new FillLayout();
        parent.setLayout((Layout)parentLayout);
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout controlLayout = new GridLayout(3, false);
        control.setLayout((Layout)controlLayout);
        this.fileLabel = new Label(control, 0);
        GridData filePathData = new GridData(768);
        this.filePath = new Text(control, 2048);
        this.filePath.setLayoutData((Object)filePathData);
        this.filePath.addModifyListener((ModifyListener)this);
        Button browse = new Button(control, 0);
        browse.setText("Browse Workspace...");
        browse.addListener(13, (Listener)new SelectSourceListener());
        this.fileLabel.setText("Source: ");
        control.layout();
        control.pack();
        this.canSave();
    }

    public Image getImage() {
        return EolPlugin.getDefault().createImage("icons/eol.gif");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.filePath.setText(configuration.getAttribute("SOURCE.EOL", ""));
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("SOURCE.EOL", this.filePath.getText());
    }

    public String getName() {
        return "EOL Program";
    }

    public boolean canSave() {
        String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toPortableString();
        File f = new File(String.valueOf(workspacePath) + this.filePath.getText());
        if (!f.exists()) {
            this.setErrorMessage("Selected file " + this.filePath.getText() + " does not exist");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void modifyText(ModifyEvent e) {
        this.canSave();
        this.updateLaunchConfigurationDialog();
    }

    class SelectSourceListener
    implements Listener {
        SelectSourceListener() {
        }

        public void handleEvent(Event event) {
            String selected = BrowseWorkspaceUtil.browseFilePath((Shell)EolSourceConfigurationTab1.this.getShell(), (String)"Select EOL Program source", (String)"EOL Programs in Workspace", (String)"eol", (Image)EolPlugin.getDefault().createImage("icons/eol.gif"));
            if (selected != null) {
                EolSourceConfigurationTab1.this.filePath.setText(selected);
            }
        }
    }
}

