/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.userinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolUserException;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.userinput.AbstractUserInput;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JFaceUserInput
extends AbstractUserInput {
    protected PrettyPrinterManager prettyPrinterManager = null;

    public Object choose(final String question, final Collection choices, final Object default_) {
        ReturningRunnable runnable = new ReturningRunnable(){

            @Override
            public Object runImpl() {
                ArrayList values = choices instanceof List ? (ArrayList)choices : new ArrayList(choices);
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return (this).JFaceUserInput.this.prettyPrinterManager.toString(element);
                    }
                });
                dialog.setMessage(question);
                dialog.setTitle(question);
                dialog.setElements(values.toArray());
                if (dialog.open() == 0) {
                    if (dialog.getResult().length > 0) {
                        return dialog.getResult()[0];
                    }
                    return null;
                }
                return default_;
            }
        };
        return this.exec(runnable);
    }

    public Object chooseMany(final String question, final Collection choices, final Collection default_) {
        ReturningRunnable runnable = new ReturningRunnable(){

            @Override
            public Object runImpl() {
                ArrayList values = choices instanceof List ? (ArrayList)choices : new ArrayList(choices);
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return (this).JFaceUserInput.this.prettyPrinterManager.toString(element);
                    }
                });
                dialog.setMessage(question);
                dialog.setTitle(question);
                dialog.setMultipleSelection(true);
                dialog.setElements(values.toArray());
                if (dialog.open() == 0) {
                    return Arrays.asList(dialog.getResult());
                }
                return default_;
            }
        };
        return this.exec(runnable);
    }

    public JFaceUserInput(PrettyPrinterManager prettyPrinterManager) {
        this.prettyPrinterManager = prettyPrinterManager;
    }

    protected PrettyPrinterManager getPrettyPrinterManager() {
        return this.prettyPrinterManager;
    }

    public boolean confirm(final String question, boolean default_) throws EolUserException {
        ReturningRunnable runnable = new ReturningRunnable(){

            @Override
            public Object runImpl() {
                return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)question);
            }
        };
        return (Boolean)this.exec(runnable);
    }

    public String prompt(final String question, final String default_) {
        ReturningRunnable runnable = new ReturningRunnable(){

            @Override
            public Object runImpl() {
                InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), "String value prompt", question, default_, null);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return default_;
            }
        };
        return (String)this.exec(runnable);
    }

    public int promptInteger(final String question, final int default_) {
        ReturningRunnable runnable = new ReturningRunnable(){

            @Override
            public Object runImpl() {
                InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), "Integer value prompt", question, String.valueOf(default_), (IInputValidator)new IntegerValidator());
                if (dialog.open() == 0) {
                    return Integer.parseInt(dialog.getValue());
                }
                return default_;
            }
        };
        return (Integer)this.exec(runnable);
    }

    public float promptReal(String question, float default_) {
        return (float)this.promptReal(question, (double)default_);
    }

    public double promptReal(String question, double default_) {
        InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), "Real value prompt", question, String.valueOf(default_), (IInputValidator)new FloatValidator());
        if (dialog.open() == 0) {
            return Double.parseDouble(dialog.getValue());
        }
        return default_;
    }

    protected Object exec(ReturningRunnable runnable) {
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.getResult();
    }

    public void inform(final String message) {
        this.exec(new ReturningRunnable(){

            @Override
            public Object runImpl() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Information", (String)message);
                return null;
            }
        });
    }

    class FloatValidator
    implements IInputValidator {
        FloatValidator() {
        }

        public String isValid(String newText) {
            try {
                Float.parseFloat(newText);
                return null;
            }
            catch (Exception exception) {
                return String.valueOf(newText) + " is not a valid real number";
            }
        }
    }

    class IntegerValidator
    implements IInputValidator {
        IntegerValidator() {
        }

        public String isValid(String newText) {
            try {
                Integer.parseInt(newText);
                return null;
            }
            catch (Exception exception) {
                return String.valueOf(newText) + " is not a valid integer";
            }
        }
    }

    abstract class ReturningRunnable
    implements Runnable {
        Object result = null;

        ReturningRunnable() {
        }

        @Override
        public void run() {
            this.result = this.runImpl();
        }

        public abstract Object runImpl();

        public Object getResult() {
            return this.result;
        }
    }
}

